#!/usr/bin/env perl

use 5.006001;
use strict;
use warnings;

use English qw< -no_match_vars >;
use Carp qw< confess >;

use Carp qw<  confess >;
use Fatal qw<  open close >;

our $VERSION = '1.093_02';



my $this_program = __FILE__;
(my $test_file_name = $this_program) =~ s/ [.] PL \z //xms;
if ($this_program eq $test_file_name) {
    confess
        'Was not able to figure out the name of the file to generate.'
        . "This program: $this_program.";
}

print "\n\nGenerating $test_file_name.\n";



open my $test_file, '>', $test_file_name    ## no critic (RequireBriefOpen)
    or confess "Could not open $test_file_name: $ERRNO";


print {$test_file} <<"END_HEADER";
# Do not edit!!!  This test suite generated by $this_program.
END_HEADER

emit_simple_tests($test_file);
emit_footer($test_file);

close $test_file;
print "Done.\n\n";

#-----------------------------------------------------------------------------

sub emit_simple_tests {
    my ($test_file) = @_;

    print {$test_file} <<'END_SIMPLE_TESTS';
#-----------------------------------------------------------------------------

## name Basic Passes
## failures 0
## cut

my  $foo;
our $bar;
my($foo, $bar) = ("BLEH", "BLEH");
my @foo;
my %bar;
sub foo {}

my  $foo123;
my  $foo123bar;
sub foo123 {}
sub foo123bar {}

package This::SomeThing;
package This;
package This::Thing;
package Acme::12345;
package YYZ;

#-----------------------------------------------------------------------------

## name Basic Failures
## failures 14
## cut

my  $Foo;
our $Bar;
my  @Foo;
my  %Bar;
sub Foo {}

my  $foo_Bar;
sub foo_Bar {}

my  $FooBar;
sub FooBar {}

my  $foo123Bar;
sub foo123Bar {}

package pragma;
package Foo::baz;
package baz::FooBar;

#-----------------------------------------------------------------------------

## name Special case: main
## failures 0
## cut

package main;

#-----------------------------------------------------------------------------

## name Combined passes and fails
## failures 2
## cut

my($foo, $Bar);
our($Bar, $foo);

#-----------------------------------------------------------------------------

## name Variables from other packages should pass 
## failures 0
## cut

local $Other::Package::Foo;
$Other::Package::Foo;

#-----------------------------------------------------------------------------

## name Only cares about declarations
## failures 0
## cut
Foo();
$Foo = 42;

#-----------------------------------------------------------------------------

## name Constants must be all caps, passes
## failures 0
## cut

Readonly::Scalar my $CONSTANT = 23;

#-----------------------------------------------------------------------------

## name Constants must be all caps, failures
## TODO Detect whether a scalar is constant or not
## failures 4
## cut

Readonly::Scalar my $Foo = 23;
Readonly::Scalar my $foo = 23;
Readonly::Scalar my $fooBAR = 23;
my $CONSTANT = 23;
END_SIMPLE_TESTS

    return;
}


sub emit_footer {

    print {$test_file} <<'END_FOOTER';

#-----------------------------------------------------------------------------
# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 78
#   indent-tabs-mode: nil
#   c-indentation-style: bsd
# End:
# ex: set ts=8 sts=4 sw=4 tw=78 ft=perl expandtab shiftround :
END_FOOTER

    return;
}

#-----------------------------------------------------------------------------
# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 78
#   indent-tabs-mode: nil
#   c-indentation-style: bsd
# End:
# ex: set ts=8 sts=4 sw=4 tw=78 ft=perl expandtab shiftround :
