#!/usr/bin/perl -w 
#
# Test for IBPerl.
#
# Copyright 1998 Bill Karwin.

use strict;
use IBPerl;

my $DBPATH = 'employee.gdb';
my ($db, $tr, $st);

print "IBPerl version $IBPerl::VERSION\n";

print "Trying connect database...\n";
$db = new IBPerl::Connection(
    Path=>$DBPATH,
    User=>'sysdba',
    Password=>'masterkey'
);

if ($db->{Handle} < 0) { print STDERR "$db->{Error}\n"; exit 1; }

$tr = new IBPerl::Transaction(Database=>$db);
if ($tr->{Handle} < 0) { print "$tr->{Error}\n"; exit 1; }

$st = new IBPerl::Statement(Transaction=>$tr,
    Stmt=>"SELECT * FROM DEPARTMENT FOR UPDATE");
if ($st->{Handle} < 0) { print "$st->{Error}\n"; exit 1; }

print "Trying to execute SELECT FOR UPDATE stmt\n";
if ($st->open() < 0) { print "$st->{Error}\n"; exit 1; }

my %row;

while ($st->fetch(\%row) == 0)
{
    if ($row{DEPT_NO} == 672)
    {
	print "Deleting department #$row{DEPT_NO}, $row{DEPARTMENT}\n";
	$st->delete();
    }
}

if ($st->close() < 0) { print "$st->{Error}\n"; exit 1; }

print "Committing... ";
if ($tr->commit() < 0)
{
    print "Commit Error:\n$tr->{Error}\n";
    exit 1;
}
print "ok\n";

print "Disconnecting... ";
if ($db->disconnect() < 0)
{
    print "Disconnection Error:\n$db->{Error}\n";
    exit 1;
}
print "ok\n";

exit 0;
