#######################################################################
# $Id: Ti.t,v 1.2 2005/03/06 19:41:01 dpchrist Exp $
#
# Test script for Math::TriangularNumbers::Ti.
#
# Copyright 2005 by David Christensen <dpchrist@holgerdanske.com>
#######################################################################
# uses:
#----------------------------------------------------------------------

use Test::More tests => 51;

use Math::TriangularNumbers qw(Ti);

#######################################################################
# debugging:
#----------------------------------------------------------------------

# $Math::TriangularNumbers::debug = 1;

#######################################################################
# script:
#----------------------------------------------------------------------

ok(!defined(eval{ Ti('foo') }));				#  1
ok($@ =~ 'is not an integer');					#  2

ok(Ti(  0)  ==   0);						#  3

ok(Ti(  1)  ==   1);						#  4
ok(Ti(  2)  ==   2);						#  5
ok(Ti(  3)  ==   2);						#  6
ok(Ti(  4)  ==   3);						#  7
ok(Ti(  5)  ==   3);						#  8
ok(Ti(  6)  ==   3);						#  9
ok(Ti(  7)  ==   4);						# 10
ok(Ti(  8)  ==   4);						# 11
ok(Ti(  9)  ==   4);						# 12
ok(Ti( 10)  ==   4);						# 13
ok(Ti( 14)  ==   5);						# 14
ok(Ti( 15)  ==   5);						# 15
ok(Ti( 16)  ==   6);						# 16
ok(Ti( 21)  ==   6);						# 17
ok(Ti( 28)  ==   7);						# 18
ok(Ti( 36)  ==   8);						# 19
ok(Ti( 45)  ==   9);						# 20
ok(Ti( 55)  ==  10);						# 21
ok(Ti(210)  ==  20);						# 22
ok(Ti(465)  ==  30);						# 23
ok(Ti(820)  ==  40);						# 24
ok(Ti(5049) == 100);						# 25
ok(Ti(5050) == 100);						# 26
ok(Ti(5051) == 101);						# 27

ok(Ti(  -1)  ==   -1);						# 28
ok(Ti(  -2)  ==   -2);						# 29
ok(Ti(  -3)  ==   -2);						# 30
ok(Ti(  -4)  ==   -3);						# 31
ok(Ti(  -5)  ==   -3);						# 32
ok(Ti(  -6)  ==   -3);						# 33
ok(Ti(  -7)  ==   -4);						# 34
ok(Ti(  -8)  ==   -4);						# 35
ok(Ti(  -9)  ==   -4);						# 36
ok(Ti( -10)  ==   -4);						# 37
ok(Ti( -14)  ==   -5);						# 38
ok(Ti( -15)  ==   -5);						# 39
ok(Ti( -16)  ==   -6);						# 40
ok(Ti( -21)  ==   -6);						# 41
ok(Ti( -28)  ==   -7);						# 42
ok(Ti( -36)  ==   -8);						# 43
ok(Ti( -45)  ==   -9);						# 44
ok(Ti( -55)  ==  -10);						# 45
ok(Ti(-210)  ==  -20);						# 46
ok(Ti(-465)  ==  -30);						# 47
ok(Ti(-820)  ==  -40);						# 48
ok(Ti(-5049) == -100);						# 49
ok(Ti(-5050) == -100);						# 50
ok(Ti(-5051) == -101);						# 51

#######################################################################
