package Locales::DB::Language::mt;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::mt::VERSION = '0.09';

$Locales::DB::Language::mt::cldr_version = '2.0';

%Locales::DB::Language::mt::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Lingwa\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Reġjun\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ is\ 0\ or\ n\ mod\ 100\ in\ 2\.\.10",
            'many' => "n\ mod\ 100\ in\ 11\.\.19",
            'one'  => "n\ is\ 1"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( $_[0] == 0 ) ) || ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 2 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 10 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 11 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 19 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "le\:l",
        'yesstr' => "iva\:i"
    },
);

%Locales::DB::Language::mt::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkażjan',
    'ace'   => 'Aċiniż',
    'ach'   => 'Akoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikans',
    'afa'   => "Afro\-Asjatiku\ \(Oħra\)",
    'afh'   => 'Afriħili',
    'agq'   => 'Aghem',
    'ain'   => 'Ajnu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadjen',
    'ale'   => 'Aleut',
    'alg'   => "Lingwi\ Algonqwinjani",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amħariku',
    'an'    => 'Aragonese',
    'ang'   => "Ingliż\,\ Antik",
    'anp'   => 'Angika',
    'apa'   => "Lingwi\ Apaċi",
    'ar'    => 'Għarbi',
    'arc'   => 'Aramajk',
    'arn'   => 'Arawkanjan',
    'arp'   => 'Arapaħo',
    'art'   => "Artifiċjali\ \(Oħra\)",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Lingwi\ Atabaskani",
    'aus'   => "Lingwi\ Awstraljani",
    'av'    => 'Avarik',
    'awa'   => 'Awadħi',
    'ay'    => 'Ajmara',
    'az'    => 'Ażerbajġani',
    'ba'    => 'Baxkir',
    'bad'   => 'Banda',
    'bai'   => "Lingwi\ Bamileke",
    'bal'   => 'Baluċi',
    'ban'   => 'Baliniż',
    'bas'   => 'Basa',
    'bat'   => "Baltiku\ \(Oħra\)",
    'be'    => 'Belarussu',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Beber',
    'bez'   => 'Bena',
    'bg'    => 'Bulgaru',
    'bh'    => 'Biħari',
    'bho'   => 'Bojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetjan',
    'br'    => 'Brenton',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'Bosnijan',
    'btk'   => 'Batak',
    'bua'   => 'Burjat',
    'bug'   => 'Buginiż',
    'byn'   => 'Blin',
    'ca'    => 'Katalan',
    'cad'   => 'Kaddo',
    'cai'   => "Amerika\ Ċentrali\ \(Oħra\)",
    'car'   => 'Karib',
    'cau'   => "Kawkasu\ \(Oħra\)",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Ċeċen',
    'ceb'   => 'Sibwano',
    'cel'   => "Keltiku\ \(Oħra\)",
    'cgg'   => 'Chiga',
    'ch'    => 'Ċamorro',
    'chb'   => 'Ċibċa',
    'chg'   => 'Ċagataj',
    'chk'   => 'Ċukese',
    'chm'   => 'Mari',
    'chn'   => "Ġargon\ taċ\-Ċinuk",
    'cho'   => 'Ċostaw',
    'chp'   => 'Ċipewjan',
    'chr'   => 'Ċerokij',
    'chy'   => 'Xajenn',
    'cmc'   => "Lingwi\ Ċamiki",
    'co'    => 'Korsiku',
    'cop'   => 'Koptiku',
    'cpe'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ l\-Ingliż\ \(Oħra\)",
    'cpf'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ il\-Franċiż\ \(Oħra\)",
    'cpp'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ il\-Portugiż\ \(Oħra\)",
    'cr'    => 'Krij',
    'crh'   => "Crimean\ Turkish\;\ Crimean\ Tatar",
    'crp'   => "Kreoli\ u\ Piġini\ \(Oħra\)",
    'cs'    => 'Ċek',
    'csb'   => 'Kashubian',
    'cu'    => "Slaviku\ tal\-Knisja",
    'cus'   => "Kuxtiku\ \(Oħra\)",
    'cv'    => 'Ċuvax',
    'cy'    => 'Welx',
    'da'    => 'Daniż',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dajak',
    'de'    => 'Ġermaniż',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delawerjan',
    'den'   => 'Slav',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidjan\ \(Oħra\)",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Dwala',
    'dum'   => "Olandiż\,\ Medjevali",
    'dv'    => 'Diveħi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Djula',
    'dz'    => 'Dżongka',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Eġizzjan\ \(Antik\)",
    'eka'   => 'Ekajuk',
    'el'    => 'Grieg',
    'elx'   => 'Elamit',
    'en'    => 'Ingliż',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Ingliż\,\ Medjevali\ \(1100\-1500\)",
    'eo'    => 'Esperanto',
    'es'    => 'Spanjol',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'Estonjan',
    'eu'    => 'Bask',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persjan',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulaħ',
    'fi'    => 'Finlandiż',
    'fil'   => 'Filippino',
    'fiu'   => "Finno\ \-\ Ugrijan",
    'fj'    => 'Fiġi',
    'fo'    => 'Fawriż',
    'fon'   => 'Fon',
    'fr'    => 'Franċiż',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Franċiż\,\ Medjevali",
    'fro'   => "Franċiż\,\ Antik",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Frijuljan',
    'fy'    => 'Friżjan',
    'ga'    => 'Irlandiż',
    'gaa'   => 'Ga',
    'gay'   => 'Gajo',
    'gba'   => 'Gbaja',
    'gd'    => "Galliku\ Skoċċiż",
    'gem'   => "Ġermaniku\ \(Oħra\)",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertjan',
    'gl'    => 'Gallegjan',
    'gmh'   => "Ġermaniku\,\ Medjevali\ Pulit",
    'gn'    => 'Gwarani',
    'goh'   => "Ġermaniku\,\ Antik\ Pulit",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gotiku',
    'grb'   => 'Ġerbo',
    'grc'   => "Grieg\,\ Antik\ \(to\ 1453\)",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Guġarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manks',
    'gwi'   => 'Gwiċin',
    'ha'    => 'Ħawsa',
    'hai'   => 'Ħajda',
    'haw'   => 'Ħawajjan',
    'he'    => 'Ebrajk',
    'hi'    => 'Ħindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Ħimaċali',
    'hit'   => 'Ħittit',
    'hmn'   => 'Ħmong',
    'ho'    => "Ħiri\ Motu",
    'hr'    => 'Kroat',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Ungeriż',
    'hup'   => 'Ħupa',
    'hy'    => 'Armenjan',
    'hz'    => 'Ħerero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indoneżjan',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Iġo',
    'ik'    => 'Inupjak',
    'ilo'   => 'Iloko',
    'inc'   => "Indjan\ \(Oħra\)",
    'ine'   => "Indo\-Ewropew",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => 'Iranjan',
    'iro'   => "Lingwi\ Irogwjani",
    'is'    => 'Iżlandiż',
    'it'    => 'Taljan',
    'iu'    => 'Inukitut',
    'ja'    => 'Ġappuniż',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Lhudi\-Persjan",
    'jrb'   => "Lhudi\-Għarbi",
    'jv'    => 'Ġavaniż',
    'ka'    => 'Ġorġjan',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabuljan',
    'kac'   => 'Kaċin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Kasi',
    'khi'   => 'Kojsan',
    'kho'   => 'Kotaniż',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuju',
    'kj'    => 'Kuanyama',
    'kk'    => 'Każak',
    'kl'    => 'Kalallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Kmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korejan',
    'kok'   => 'Konkani',
    'kos'   => 'Kosrejan',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurusk',
    'ks'    => 'Kaxmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdiż',
    'kum'   => 'Kumiku',
    'kut'   => 'Kutenaj',
    'kv'    => 'Komi',
    'kw'    => 'Korniku',
    'ky'    => 'Kirgiż',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Landa',
    'lam'   => 'Lamba',
    'lb'    => 'Letżburgiż',
    'lez'   => 'Leżgjan',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingaljan',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lożi',
    'lt'    => 'Litwanjan',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Luluwa",
    'lui'   => 'Luwisinuż',
    'lun'   => 'Lunda',
    'luo'   => 'Luwa',
    'lus'   => 'Luxaj',
    'luy'   => 'Luyia',
    'lv'    => "Latvjan\ \(Lettix\)",
    'mad'   => 'Maduriż',
    'mag'   => 'Magaħi',
    'mai'   => 'Majtili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingwan',
    'map'   => 'Awstronesjan',
    'mas'   => 'Masaj',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagażi',
    'mga'   => "Irlandiż\,\ Medjevali\ \(900\-1200\)",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marxall',
    'mi'    => 'Maori',
    'mic'   => 'Mikmek',
    'min'   => 'Minangkabaw',
    'mis'   => "Lingwi\ Oħra",
    'mk'    => 'Maċedonjan',
    'mkh'   => "Mon\-Kmer\ \(Oħra\)",
    'ml'    => 'Malajalam',
    'mn'    => 'Mongoljan',
    'mnc'   => 'Manċurjan',
    'mni'   => 'Manipuri',
    'mno'   => "Lingwi\ Manobo",
    'mo'    => 'Moldavjan',
    'moh'   => 'Moħak',
    'mos'   => 'Mossi',
    'mr'    => 'Marati',
    'ms'    => 'Malajan',
    'mt'    => 'Malti',
    'mua'   => 'Mundang',
    'mul'   => "Lingwi\ Diversi",
    'mun'   => "Lingwi\ tal\-Munda",
    'mus'   => 'Kriek',
    'mwl'   => 'Mirandiż',
    'mwr'   => 'Marwari',
    'my'    => 'Burmiż',
    'myn'   => 'Majan',
    'myv'   => 'Erzya',
    'na'    => 'Nawuru',
    'nah'   => 'Naħwatil',
    'nai'   => "Indjan\ tal\-Amerika\ ta’\ Fuq\ \(Oħra\)",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Bokmahal\ Norveġiż",
    'nd'    => "Ndebele\,\ ta’\ Fuq",
    'nds'   => "Ġermaniż\ Komuni\;\ Sassonu\ Komuni",
    'ne'    => 'Nepaliż',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nijas',
    'nic'   => "Niġerjan\ \-\ Kordofanjan",
    'niu'   => 'Nijuwejan',
    'nl'    => 'Olandiż',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Ninorsk\ Norveġiż",
    'no'    => 'Norveġiż',
    'nog'   => 'Nogai',
    'non'   => "Skandinav\,\ Antik",
    'nqo'   => "N\â\\Ko",
    'nr'    => "Ndebele\,\ t’Isfel",
    'nso'   => "Soto\,\ ta’\ Fuq",
    'nub'   => "Lingwi\ Nubjani",
    'nus'   => 'Nuer',
    'nv'    => 'Navaħo',
    'nwc'   => "Classical\ Newari",
    'ny'    => "Ċiċewa\;\ Njanġa",
    'nym'   => 'Njamweżi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Njoro',
    'nzi'   => 'Nżima',
    'oc'    => 'Oċċitan',
    'oj'    => 'Oġibwa',
    'om'    => "Oromo\ \(Afan\)",
    'or'    => 'Orija',
    'os'    => 'Ossettiku',
    'osa'   => 'Osaġjan',
    'ota'   => "Tork\ \(Imperu\ Ottoman\)",
    'oto'   => "Lingwi\ Otomjani",
    'pa'    => 'Punġabi',
    'paa'   => "Papwan\ \(Oħra\)",
    'pag'   => 'Pangasinjan',
    'pal'   => 'Paħlavi',
    'pam'   => 'Pampamga',
    'pap'   => 'Papjamento',
    'pau'   => 'Palawjan',
    'peo'   => "Persjan\ Antik",
    'phi'   => "Filippin\ \(Oħra\)",
    'phn'   => 'Feniċju',
    'pi'    => 'Pali',
    'pl'    => 'Pollakk',
    'pon'   => 'Ponpejan',
    'pra'   => "Lingwi\ Prakriti",
    'pro'   => "Provenzal\,\ Antik\ \(sa\ l\-1500\)",
    'ps'    => 'Paxtun',
    'pt'    => 'Portugiż',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Keċwa',
    'raj'   => 'Raġastani',
    'rap'   => 'Rapanwi',
    'rar'   => 'Rarotongani',
    'rm'    => "Reto\-Romanz",
    'rn'    => 'Rundi',
    'ro'    => 'Rumen',
    'roa'   => "Romanz\ \(Oħra\)",
    'rof'   => 'Rombo',
    'rom'   => 'Żingaru',
    'ru'    => 'Russu',
    'rup'   => 'Aromanijan',
    'rw'    => 'Kinjarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Jakut',
    'sai'   => "Indjan\ tal\-Amerika\ t’Isfel\ \(Oħra\)",
    'sal'   => 'Salixan',
    'sam'   => 'Samritan',
    'saq'   => 'Samburu',
    'sas'   => 'Saska',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinjan',
    'scn'   => 'Sicilian',
    'sco'   => 'Skoċċiż',
    'sd'    => 'Sindi',
    'se'    => "Sami\ ta’\ Fuq",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => 'Semitiku',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Irlandiż\,\ Antik\ \(sa\ l\-900\)",
    'sgn'   => "Lingwa\ tas\-Sinjali",
    'sh'    => "Serbo\-Kroat",
    'shi'   => 'Tachelhit',
    'shn'   => 'Xan',
    'si'    => 'Sinħaliż',
    'sid'   => 'Sidamo',
    'sio'   => "Lingwi\ Suwjani",
    'sit'   => "Sino\-Tibetjani\ \(Oħra\)",
    'sk'    => 'Slovakk',
    'sl'    => 'Sloven',
    'sla'   => "Slavic\ \(Other\)",
    'sm'    => 'Samojan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ languages\ \(Other\)",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Xona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songaj',
    'sq'    => 'Albaniż',
    'sr'    => 'Serb',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saħaram",
    'ssy'   => 'Saho',
    'st'    => "Soto\,\ t’Isfel",
    'su'    => 'Sundaniż',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerjan',
    'sv'    => 'Svediż',
    'sw'    => 'Swaħili',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Sirjan',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ \(Oħra\)",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Taġik',
    'th'    => 'Tajlandiż',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeni',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaxek',
    'tn'    => 'Zwana',
    'to'    => "Tongan\ \(Gżejjer\ ta’\ Tonga\)",
    'tog'   => "Tonga\ \(Njasa\)",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Tork',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Zimxjan',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ languages",
    'tut'   => "Altajk\ \(Oħra\)",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Taħitjan',
    'tyv'   => 'Tuvinjan',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Wigur',
    'uga'   => 'Ugaritiku',
    'uk'    => 'Ukranjan',
    'umb'   => 'Umbundu',
    'und'   => 'Indeterminat',
    'ur'    => 'Urdu',
    'uz'    => 'Użbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vjetnamiż',
    'vo'    => 'Volapuk',
    'vot'   => 'Votik',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Lingwi\ Wakaxani",
    'wal'   => 'Walamo',
    'war'   => 'Waraj',
    'was'   => 'Waxo',
    'wen'   => "Lingwi\ Sorbjani",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Ħoża',
    'xog'   => 'Soga',
    'yao'   => 'Jao',
    'yap'   => 'Japese',
    'yav'   => 'Yangben',
    'yi'    => 'Jiddix',
    'yo'    => 'Joruba',
    'ypk'   => "Lingwi\ Jupiċi",
    'yue'   => 'Cantonese',
    'za'    => 'Żwang',
    'zap'   => 'Żapotek',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Żenaga',
    'zh'    => 'Ċiniż',
    'znd'   => 'Żande',
    'zu'    => 'Żulu',
    'zun'   => 'Żuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::mt::name_to_code = (
    'abkażjan'                                  => 'ab',
    'adangme'                                    => 'ada',
    'adyghe'                                     => 'ady',
    'afar'                                       => 'aa',
    'afrikans'                                   => 'af',
    'afriħili'                                  => 'afh',
    'afroasjatikuoħra'                          => 'afa',
    'aghem'                                      => 'agq',
    'ajmara'                                     => 'ay',
    'ajnu'                                       => 'ain',
    'akan'                                       => 'ak',
    'akkadjen'                                   => 'akk',
    'akoli'                                      => 'ach',
    'albaniż'                                   => 'sq',
    'aleut'                                      => 'ale',
    'altajkoħra'                                => 'tut',
    'amerikaĊentralioħra'                      => 'cai',
    'amħariku'                                  => 'am',
    'angika'                                     => 'anp',
    'aragonese'                                  => 'an',
    'aramajk'                                    => 'arc',
    'arapaħo'                                   => 'arp',
    'arawak'                                     => 'arw',
    'arawkanjan'                                 => 'arn',
    'armenjan'                                   => 'hy',
    'aromanijan'                                 => 'rup',
    'artifiċjalioħra'                          => 'art',
    'assamese'                                   => 'as',
    'asturian'                                   => 'ast',
    'asu'                                        => 'asa',
    'atsam'                                      => 'cch',
    'australianenglish'                          => 'en_au',
    'austriangerman'                             => 'de_at',
    'avarik'                                     => 'av',
    'avestan'                                    => 'ae',
    'awadħi'                                    => 'awa',
    'awstronesjan'                               => 'map',
    'aċiniż'                                   => 'ace',
    'ażerbajġani'                              => 'az',
    'bafia'                                      => 'ksf',
    'baliniż'                                   => 'ban',
    'baltikuoħra'                               => 'bat',
    'baluċi'                                    => 'bal',
    'bambara'                                    => 'bm',
    'banda'                                      => 'bad',
    'bantu'                                      => 'bnt',
    'basa'                                       => 'bas',
    'bask'                                       => 'eu',
    'batak'                                      => 'btk',
    'baxkir'                                     => 'ba',
    'beber'                                      => 'ber',
    'beja'                                       => 'bej',
    'belarussu'                                  => 'be',
    'bemba'                                      => 'bem',
    'bena'                                       => 'bez',
    'bengali'                                    => 'bn',
    'bikol'                                      => 'bik',
    'bini'                                       => 'bin',
    'bislama'                                    => 'bi',
    'biħari'                                    => 'bh',
    'blin'                                       => 'byn',
    'blissymbols'                                => 'zbl',
    'bodo'                                       => 'brx',
    'bojpuri'                                    => 'bho',
    'bokmahalnorveġiż'                         => 'nb',
    'bosnijan'                                   => 'bs',
    'braj'                                       => 'bra',
    'brazilianportuguese'                        => 'pt_br',
    'brenton'                                    => 'br',
    'britishenglish'                             => 'en_gb',
    'buginiż'                                   => 'bug',
    'bulgaru'                                    => 'bg',
    'burjat'                                     => 'bua',
    'burmiż'                                    => 'my',
    'canadianenglish'                            => 'en_ca',
    'canadianfrench'                             => 'fr_ca',
    'cantonese'                                  => 'yue',
    'cayuga'                                     => 'cay',
    'centralmoroccotamazight'                    => 'tzm',
    'chiga'                                      => 'cgg',
    'classicalnewari'                            => 'nwc',
    'classicalsyriac'                            => 'syc',
    'colognian'                                  => 'ksh',
    'comorian'                                   => 'swb',
    'congoswahili'                               => 'swc',
    "crimeanturkish\;crimeantatar"               => 'crh',
    'dajak'                                      => 'day',
    'dakota'                                     => 'dak',
    'daniż'                                     => 'da',
    'dargwa'                                     => 'dar',
    'delawerjan'                                 => 'del',
    'dinka'                                      => 'din',
    'diveħi'                                    => 'dv',
    'djula'                                      => 'dyu',
    'dogri'                                      => 'doi',
    'dogrib'                                     => 'dgr',
    'dravidjanoħra'                             => 'dra',
    'dwala'                                      => 'dua',
    'dżongka'                                   => 'dz',
    'easternfrisian'                             => 'frs',
    'ebrajk'                                     => 'he',
    'efik'                                       => 'efi',
    'ekajuk'                                     => 'eka',
    'elamit'                                     => 'elx',
    'embu'                                       => 'ebu',
    'erzya'                                      => 'myv',
    'esperanto'                                  => 'eo',
    'estonjan'                                   => 'et',
    'ewe'                                        => 'ee',
    'ewondo'                                     => 'ewo',
    'eġizzjanantik'                             => 'egy',
    'fang'                                       => 'fan',
    'fanti'                                      => 'fat',
    'fawriż'                                    => 'fo',
    'feniċju'                                   => 'phn',
    'filippino'                                  => 'fil',
    'filippinoħra'                              => 'phi',
    'finlandiż'                                 => 'fi',
    'finnougrijan'                               => 'fiu',
    'fiġi'                                      => 'fj',
    'flemish'                                    => 'nl_be',
    'fon'                                        => 'fon',
    'franċiż'                                  => 'fr',
    "franċiż\,antik"                           => 'fro',
    "franċiż\,medjevali"                       => 'frm',
    'frijuljan'                                  => 'fur',
    'friżjan'                                   => 'fy',
    'fulaħ'                                     => 'ff',
    'ga'                                         => 'gaa',
    'gajo'                                       => 'gay',
    'gallegjan'                                  => 'gl',
    'gallikuskoċċiż'                          => 'gd',
    'ganda'                                      => 'lg',
    'gbaja'                                      => 'gba',
    'geez'                                       => 'gez',
    'gilbertjan'                                 => 'gil',
    'gondi'                                      => 'gon',
    'gorontalo'                                  => 'gor',
    'gotiku'                                     => 'got',
    'grieg'                                      => 'el',
    "grieg\,antikto1453"                         => 'grc',
    'gusii'                                      => 'guz',
    'guġarati'                                  => 'gu',
    'gwarani'                                    => 'gn',
    'gwiċin'                                    => 'gwi',
    'għarbi'                                    => 'ar',
    'haitian'                                    => 'ht',
    'hiligaynon'                                 => 'hil',
    'iban'                                       => 'iba',
    'iberianportuguese'                          => 'pt_pt',
    'iberianspanish'                             => 'es_es',
    'ido'                                        => 'io',
    'igbo'                                       => 'ig',
    'iloko'                                      => 'ilo',
    'inarisami'                                  => 'smn',
    'indeterminat'                               => 'und',
    'indjanoħra'                                => 'inc',
    'indjantalamerikata’fuqoħra'              => 'nai',
    'indjantalamerikat’isfeloħra'             => 'sai',
    'indoewropew'                                => 'ine',
    'indoneżjan'                                => 'id',
    'ingliż'                                    => 'en',
    "ingliż\,antik"                             => 'ang',
    "ingliż\,medjevali11001500"                 => 'enm',
    'ingush'                                     => 'inh',
    'interlingua'                                => 'ia',
    'interlingue'                                => 'ie',
    'inukitut'                                   => 'iu',
    'inupjak'                                    => 'ik',
    'iranjan'                                    => 'ira',
    'irlandiż'                                  => 'ga',
    "irlandiż\,antiksal900"                     => 'sga',
    "irlandiż\,medjevali9001200"                => 'mga',
    'iġo'                                       => 'ijo',
    'iżlandiż'                                 => 'is',
    'jakut'                                      => 'sah',
    'jao'                                        => 'yao',
    'japese'                                     => 'yap',
    'jiddix'                                     => 'yi',
    'jju'                                        => 'kaj',
    'jolafonyi'                                  => 'dyo',
    'joruba'                                     => 'yo',
    'kabardian'                                  => 'kbd',
    'kabuljan'                                   => 'kab',
    'kabuverdianu'                               => 'kea',
    'kaddo'                                      => 'cad',
    'kalallisut'                                 => 'kl',
    'kalenjin'                                   => 'kln',
    'kalmyk'                                     => 'xal',
    'kamba'                                      => 'kam',
    'kannada'                                    => 'kn',
    'kanuri'                                     => 'kr',
    'karachaybalkar'                             => 'krc',
    'karakalpak'                                 => 'kaa',
    'karelian'                                   => 'krl',
    'karen'                                      => 'kar',
    'karib'                                      => 'car',
    'kashubian'                                  => 'csb',
    'kasi'                                       => 'kha',
    'katalan'                                    => 'ca',
    'kawi'                                       => 'kaw',
    'kawkasuoħra'                               => 'cau',
    'kaxmiri'                                    => 'ks',
    'kaċin'                                     => 'kac',
    'każak'                                     => 'kk',
    'keltikuoħra'                               => 'cel',
    'keċwa'                                     => 'qu',
    'kikuju'                                     => 'ki',
    'kimbundu'                                   => 'kmb',
    'kinjarwanda'                                => 'rw',
    'kirgiż'                                    => 'ky',
    'klingon'                                    => 'tlh',
    'kmer'                                       => 'km',
    'kojsan'                                     => 'khi',
    'komi'                                       => 'kv',
    'kongo'                                      => 'kg',
    'konkani'                                    => 'kok',
    'koptiku'                                    => 'cop',
    'korejan'                                    => 'ko',
    'korniku'                                    => 'kw',
    'koro'                                       => 'kfo',
    'korsiku'                                    => 'co',
    'kosrejan'                                   => 'kos',
    'kotaniż'                                   => 'kho',
    'koyraborosenni'                             => 'ses',
    'koyrachiini'                                => 'khq',
    'kpelle'                                     => 'kpe',
    "kreoliupiġini\,bbażatfuqilfranċiżoħra" => 'cpf',
    "kreoliupiġini\,bbażatfuqilportugiżoħra" => 'cpp',
    "kreoliupiġini\,bbażatfuqlingliżoħra"    => 'cpe',
    'kreoliupiġinioħra'                        => 'crp',
    'kriek'                                      => 'mus',
    'krij'                                       => 'cr',
    'kroat'                                      => 'hr',
    'kru'                                        => 'kro',
    'kuanyama'                                   => 'kj',
    'kumiku'                                     => 'kum',
    'kurdiż'                                    => 'ku',
    'kurusk'                                     => 'kru',
    'kutenaj'                                    => 'kut',
    'kuxtikuoħra'                               => 'cus',
    'kwasio'                                     => 'nmg',
    'ladino'                                     => 'lad',
    'lamba'                                      => 'lam',
    'landa'                                      => 'lah',
    'langi'                                      => 'lag',
    'lao'                                        => 'lo',
    'latin'                                      => 'la',
    'latvjanlettix'                              => 'lv',
    'letżburgiż'                               => 'lb',
    'leżgjan'                                   => 'lez',
    'lhudigħarbi'                               => 'jrb',
    'lhudipersjan'                               => 'jpr',
    'limburgish'                                 => 'li',
    'lingaljan'                                  => 'ln',
    'lingwatassinjali'                           => 'sgn',
    'lingwialgonqwinjani'                        => 'alg',
    'lingwiapaċi'                               => 'apa',
    'lingwiatabaskani'                           => 'ath',
    'lingwiawstraljani'                          => 'aus',
    'lingwibamileke'                             => 'bai',
    'lingwidiversi'                              => 'mul',
    'lingwiirogwjani'                            => 'iro',
    'lingwijupiċi'                              => 'ypk',
    'lingwimanobo'                               => 'mno',
    'lingwinubjani'                              => 'nub',
    'lingwiotomjani'                             => 'oto',
    'lingwioħra'                                => 'mis',
    'lingwiprakriti'                             => 'pra',
    'lingwisorbjani'                             => 'wen',
    'lingwisuwjani'                              => 'sio',
    'lingwitalmunda'                             => 'mun',
    'lingwiwakaxani'                             => 'wak',
    'lingwiĊamiki'                              => 'cmc',
    'litwanjan'                                  => 'lt',
    'lojban'                                     => 'jbo',
    'lowersorbian'                               => 'dsb',
    'lożi'                                      => 'loz',
    'lubakatanga'                                => 'lu',
    'lubaluluwa'                                 => 'lua',
    'lulesami'                                   => 'smj',
    'lunda'                                      => 'lun',
    'luwa'                                       => 'luo',
    'luwisinuż'                                 => 'lui',
    'luxaj'                                      => 'lus',
    'luyia'                                      => 'luy',
    'machame'                                    => 'jmc',
    'maduriż'                                   => 'mad',
    'magaħi'                                    => 'mag',
    'majan'                                      => 'myn',
    'majtili'                                    => 'mai',
    'makasar'                                    => 'mak',
    'makhuwameetto'                              => 'mgh',
    'makonde'                                    => 'kde',
    'malagażi'                                  => 'mg',
    'malajalam'                                  => 'ml',
    'malajan'                                    => 'ms',
    'malti'                                      => 'mt',
    'mandar'                                     => 'mdr',
    'mandingwan'                                 => 'man',
    'manipuri'                                   => 'mni',
    'manks'                                      => 'gv',
    'manċurjan'                                 => 'mnc',
    'maori'                                      => 'mi',
    'marati'                                     => 'mr',
    'mari'                                       => 'chm',
    'marwari'                                    => 'mwr',
    'marxall'                                    => 'mh',
    'masaj'                                      => 'mas',
    'maċedonjan'                                => 'mk',
    'mende'                                      => 'men',
    'meru'                                       => 'mer',
    'mikmek'                                     => 'mic',
    'minangkabaw'                                => 'min',
    'mirandiż'                                  => 'mwl',
    'moksha'                                     => 'mdf',
    'moldavjan'                                  => 'mo',
    'mongo'                                      => 'lol',
    'mongoljan'                                  => 'mn',
    'monkmeroħra'                               => 'mkh',
    'morisyen'                                   => 'mfe',
    'mossi'                                      => 'mos',
    'moħak'                                     => 'moh',
    'mundang'                                    => 'mua',
    'nama'                                       => 'naq',
    'navaħo'                                    => 'nv',
    'nawuru'                                     => 'na',
    'naħwatil'                                  => 'nah',
    "ndebele\,ta’fuq"                          => 'nd',
    "ndebele\,t’isfel"                         => 'nr',
    'ndonga'                                     => 'ng',
    'neapolitan'                                 => 'nap',
    'nepaliż'                                   => 'ne',
    'newari'                                     => 'new',
    'nijas'                                      => 'nia',
    'nijuwejan'                                  => 'niu',
    'nilosaħaram'                               => 'ssa',
    'ninorsknorveġiż'                          => 'nn',
    'niġerjankordofanjan'                       => 'nic',
    'njamweżi'                                  => 'nym',
    'njoro'                                      => 'nyo',
    'nogai'                                      => 'nog',
    'nolinguisticcontent'                        => 'zxx',
    'northernfrisian'                            => 'frr',
    'norveġiż'                                 => 'no',
    'nuer'                                       => 'nus',
    'nyankole'                                   => 'nyn',
    "n\â\\ko"                               => 'nqo',
    'nżima'                                     => 'nzi',
    'olandiż'                                   => 'nl',
    "olandiż\,medjevali"                        => 'dum',
    'orija'                                      => 'or',
    'oromoafan'                                  => 'om',
    'osaġjan'                                   => 'osa',
    'ossettiku'                                  => 'os',
    'oċċitan'                                  => 'oc',
    'oġibwa'                                    => 'oj',
    'palawjan'                                   => 'pau',
    'pali'                                       => 'pi',
    'pampamga'                                   => 'pam',
    'pangasinjan'                                => 'pag',
    'papjamento'                                 => 'pap',
    'papwanoħra'                                => 'paa',
    'paxtun'                                     => 'ps',
    'paħlavi'                                   => 'pal',
    'persjan'                                    => 'fa',
    'persjanantik'                               => 'peo',
    'pollakk'                                    => 'pl',
    'ponpejan'                                   => 'pon',
    'portugiż'                                  => 'pt',
    "provenzal\,antiksal1500"                    => 'pro',
    'punġabi'                                   => 'pa',
    'rapanwi'                                    => 'rap',
    'rarotongani'                                => 'rar',
    'raġastani'                                 => 'raj',
    'retoromanz'                                 => 'rm',
    'romanzoħra'                                => 'roa',
    'rombo'                                      => 'rof',
    'rumen'                                      => 'ro',
    'rundi'                                      => 'rn',
    'russu'                                      => 'ru',
    'rwa'                                        => 'rwk',
    'saho'                                       => 'ssy',
    'salixan'                                    => 'sal',
    'samburu'                                    => 'saq',
    'samilanguagesother'                         => 'smi',
    'samita’fuq'                               => 'se',
    'samojan'                                    => 'sm',
    'samritan'                                   => 'sam',
    'sandawe'                                    => 'sad',
    'sango'                                      => 'sg',
    'sangu'                                      => 'sbp',
    'sanskrit'                                   => 'sa',
    'santali'                                    => 'sat',
    'sardinjan'                                  => 'sc',
    'saska'                                      => 'sas',
    'selkup'                                     => 'sel',
    'semitiku'                                   => 'sem',
    'sena'                                       => 'seh',
    'seneca'                                     => 'see',
    'serb'                                       => 'sr',
    'serbokroat'                                 => 'sh',
    'serer'                                      => 'srr',
    'shambala'                                   => 'ksb',
    'sibwano'                                    => 'ceb',
    'sichuanyi'                                  => 'ii',
    'sicilian'                                   => 'scn',
    'sidamo'                                     => 'sid',
    'siksika'                                    => 'bla',
    'sindi'                                      => 'sd',
    'sinotibetjanioħra'                         => 'sit',
    'sinħaliż'                                 => 'si',
    'sirjan'                                     => 'syr',
    "skandinav\,antik"                           => 'non',
    'skoltsami'                                  => 'sms',
    'skoċċiż'                                 => 'sco',
    'slav'                                       => 'den',
    'slavicother'                                => 'sla',
    'slavikutalknisja'                           => 'cu',
    'slovakk'                                    => 'sk',
    'sloven'                                     => 'sl',
    'soga'                                       => 'xog',
    'sogdien'                                    => 'sog',
    'somali'                                     => 'so',
    'songaj'                                     => 'son',
    'soninke'                                    => 'snk',
    "soto\,ta’fuq"                             => 'nso',
    "soto\,t’isfel"                            => 'st',
    'southernaltai'                              => 'alt',
    'southernsami'                               => 'sma',
    'spanjol'                                    => 'es',
    'sranantongo'                                => 'srn',
    'sukuma'                                     => 'suk',
    'sumerjan'                                   => 'sux',
    'sundaniż'                                  => 'su',
    'susu'                                       => 'sus',
    'svediż'                                    => 'sv',
    'swati'                                      => 'ss',
    'swaħili'                                   => 'sw',
    'swissfrench'                                => 'fr_ch',
    'swissgerman'                                => 'gsw',
    'swisshighgerman'                            => 'de_ch',
    'tachelhit'                                  => 'shi',
    'tagalog'                                    => 'tl',
    'taioħra'                                   => 'tai',
    'taita'                                      => 'dav',
    'tajlandiż'                                 => 'th',
    'taljan'                                     => 'it',
    'tamaxek'                                    => 'tmh',
    'tamil'                                      => 'ta',
    'taroko'                                     => 'trv',
    'tasawaq'                                    => 'twq',
    'tatar'                                      => 'tt',
    'taġik'                                     => 'tg',
    'taħitjan'                                  => 'ty',
    'telugu'                                     => 'te',
    'tereno'                                     => 'ter',
    'teso'                                       => 'teo',
    'tetum'                                      => 'tet',
    'tibetjan'                                   => 'bo',
    'tigre'                                      => 'tig',
    'tigrinja'                                   => 'ti',
    'timne'                                      => 'tem',
    'tiv'                                        => 'tiv',
    'tlingit'                                    => 'tli',
    'tokelau'                                    => 'tkl',
    'tokpisin'                                   => 'tpi',
    'tongangżejjerta’tonga'                   => 'to',
    'tonganjasa'                                 => 'tog',
    'tork'                                       => 'tr',
    'torkimperuottoman'                          => 'ota',
    'tsonga'                                     => 'ts',
    'tumbuka'                                    => 'tum',
    'tupilanguages'                              => 'tup',
    'turkmeni'                                   => 'tk',
    'tuvalu'                                     => 'tvl',
    'tuvinjan'                                   => 'tyv',
    'twi'                                        => 'tw',
    'tyap'                                       => 'kcg',
    "u\.s\.english"                              => 'en_us',
    'udmurt'                                     => 'udm',
    'ugaritiku'                                  => 'uga',
    'ukranjan'                                   => 'uk',
    'umbundu'                                    => 'umb',
    'ungeriż'                                   => 'hu',
    'uppersorbian'                               => 'hsb',
    'urdu'                                       => 'ur',
    'użbek'                                     => 'uz',
    'vai'                                        => 'vai',
    'venda'                                      => 've',
    'vjetnamiż'                                 => 'vi',
    'volapuk'                                    => 'vo',
    'votik'                                      => 'vot',
    'vunjo'                                      => 'vun',
    'walamo'                                     => 'wal',
    'walloon'                                    => 'wa',
    'walser'                                     => 'wae',
    'waraj'                                      => 'war',
    'waxo'                                       => 'was',
    'welx'                                       => 'cy',
    'wigur'                                      => 'ug',
    'wolof'                                      => 'wo',
    'xajenn'                                     => 'chy',
    'xan'                                        => 'shn',
    'xona'                                       => 'sn',
    'yangben'                                    => 'yav',
    'zarma'                                      => 'dje',
    'zaza'                                       => 'zza',
    'zimxjan'                                    => 'tsi',
    'zwana'                                      => 'tn',
    'Ċagataj'                                   => 'chg',
    'Ċamorro'                                   => 'ch',
    'Ċek'                                       => 'cs',
    'Ċerokij'                                   => 'chr',
    'Ċeċen'                                    => 'ce',
    'Ċibċa'                                    => 'chb',
    'Ċiniż'                                    => 'zh',
    'Ċipewjan'                                  => 'chp',
    "Ċiċewa\;njanġa"                          => 'ny',
    'Ċostaw'                                    => 'cho',
    'Ċukese'                                    => 'chk',
    'Ċuvax'                                     => 'cv',
    'Ġappuniż'                                 => 'ja',
    'ĠargontaċĊinuk'                          => 'chn',
    'Ġavaniż'                                  => 'jv',
    'Ġerbo'                                     => 'grb',
    "Ġermaniku\,antikpulit"                     => 'goh',
    "Ġermaniku\,medjevalipulit"                 => 'gmh',
    'Ġermanikuoħra'                            => 'gem',
    'Ġermaniż'                                 => 'de',
    "Ġermaniżkomuni\;sassonukomuni"            => 'nds',
    'Ġorġjan'                                  => 'ka',
    'Ħajda'                                     => 'hai',
    'Ħawajjan'                                  => 'haw',
    'Ħawsa'                                     => 'ha',
    'Ħerero'                                    => 'hz',
    'Ħimaċali'                                 => 'him',
    'Ħindi'                                     => 'hi',
    'Ħirimotu'                                  => 'ho',
    'Ħittit'                                    => 'hit',
    'Ħmong'                                     => 'hmn',
    'Ħoża'                                     => 'xh',
    'Ħupa'                                      => 'hup',
    'Żande'                                     => 'znd',
    'Żapotek'                                   => 'zap',
    'Żenaga'                                    => 'zen',
    'Żingaru'                                   => 'rom',
    'Żulu'                                      => 'zu',
    'Żuni'                                      => 'zun',
    'Żwang'                                     => 'za',
);

1;
