package Locales::DB::Language::az;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::az::VERSION = '0.09';

$Locales::DB::Language::az::cldr_version = '2.0';

%Locales::DB::Language::az::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Dil\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Rayon\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr' => {
            'content' => "yox\:y",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "hə\:h",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::az::code_to_name = (
    'aa'    => 'afarca',
    'ab'    => 'abxazca',
    'ace'   => "akin\ dili",
    'ach'   => "akoli\ dili",
    'ada'   => "adangme\ dili",
    'ady'   => "aduge\ dili",
    'ae'    => 'avestanca',
    'af'    => 'Afrikaanca',
    'afa'   => "afro\-aziat\ dili",
    'afh'   => "afrihili\ dili",
    'agq'   => 'Aghem',
    'ain'   => 'aynuca',
    'ak'    => 'akanca',
    'akk'   => 'akadianca',
    'ale'   => 'aleutca',
    'alg'   => "algonguyan\ dili",
    'alt'   => "cənub\ altay\ dili",
    'am'    => 'amarikcə',
    'an'    => 'aragonca',
    'ang'   => "qədimi\ ingiliscə",
    'anp'   => "angikə\ dili",
    'apa'   => "apaçi\ dili",
    'ar'    => 'Ərəbcə',
    'arc'   => "aramik\ dili",
    'arn'   => 'araukanca',
    'arp'   => "arapaho\ dili",
    'art'   => "suni\ dil",
    'arw'   => 'aravakça',
    'as'    => 'as',
    'asa'   => 'Asu',
    'ast'   => 'asturicə',
    'ath'   => 'atapaskanca',
    'aus'   => 'avstraliyca',
    'av'    => 'avarikcə',
    'awa'   => 'avadicə',
    'ay'    => 'aymarca',
    'az'    => 'azərbaycanca',
    'ba'    => "başkir\ dili",
    'bad'   => "banda\ dili",
    'bai'   => "bamilek\ dili",
    'bal'   => "baluc\ dili",
    'ban'   => 'balincə',
    'bas'   => "basa\ dili",
    'bat'   => "baltik\ dili",
    'be'    => 'belarusca',
    'bej'   => "beja\ dili",
    'bem'   => "bemba\ dili",
    'ber'   => "berber\ dili",
    'bez'   => 'Bena',
    'bg'    => 'bolqarca',
    'bh'    => 'biharicə',
    'bho'   => "bxoçpuri\ dili",
    'bi'    => "bislama\ dili",
    'bik'   => 'bikolca',
    'bin'   => "bini\ dili",
    'bla'   => "siksikə\ dili",
    'bm'    => "bambara\ dili",
    'bn'    => "Benqal\ dili",
    'bnt'   => "bantu\ dili",
    'bo'    => "tibet\ dili",
    'br'    => 'Bretonca',
    'bra'   => "braj\ dili",
    'brx'   => 'Bodo',
    'bs'    => "bosniya\ dili",
    'btk'   => "batak\ dili",
    'bua'   => "buryat\ dili",
    'bug'   => "bugin\ dili",
    'byn'   => 'bilincə',
    'ca'    => 'katalanca',
    'cad'   => "kado\ dili",
    'cai'   => "mərkəzi\ amerika\ indus\ dili",
    'car'   => "karib\ dili",
    'cau'   => "qavqaz\ dili",
    'cay'   => 'Cayuga',
    'cch'   => 'atsamca',
    'ce'    => "çeçen\ dili",
    'ceb'   => "kebuano\ dili",
    'cel'   => "kelt\ dili",
    'cgg'   => 'Chiga',
    'ch'    => "çamoro\ dili",
    'chb'   => "çibçə\ dili",
    'chg'   => "çağatay\ dili",
    'chk'   => "çukiz\ dili",
    'chm'   => "mari\ dili",
    'chn'   => "çinuk\ ləhçəsi",
    'cho'   => "çoktau\ dili",
    'chp'   => "çipevyan\ dili",
    'chr'   => "çiroki\ dili",
    'chy'   => "çeyen\ dili",
    'cmc'   => "çamik\ dili",
    'co'    => "korsikan\ dili",
    'cop'   => "kopt\ dili",
    'cpe'   => "inglis\ kreol\ dili",
    'cpf'   => "fransız\ kreol\ dili",
    'cpp'   => "portugal\ kreol\ dili",
    'cr'    => "kri\ dili",
    'crh'   => "krım\ türkçə",
    'crp'   => "kreol\ dili",
    'cs'    => "çex\ dili",
    'csb'   => "kaşubyan\ dili",
    'cu'    => "kilsə\ slav\ dili",
    'cus'   => "kuşitik\ dili",
    'cv'    => "çuvaş\ dili",
    'cy'    => 'uelscə',
    'da'    => "danimarka\ dili",
    'dak'   => "dakota\ dili",
    'dar'   => "darqva\ dili",
    'dav'   => 'Taita',
    'day'   => "dayak\ dili",
    'de'    => 'almanca',
    'de_at' => "almanca\ \(AT\)",
    'de_ch' => "isveç\ yüksək\ almancası",
    'del'   => "delaver\ dili",
    'den'   => 'slavey',
    'dgr'   => "doqrib\ dili",
    'din'   => "dinka\ dili",
    'dje'   => 'Zarma',
    'doi'   => "doqri\ dili",
    'dra'   => "dravid\ dili",
    'dsb'   => "aşağı\ sorbca",
    'dua'   => "duala\ dili",
    'dum'   => "ortacaq\ hollandca",
    'dv'    => "diveh\ dili",
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => "dyula\ dili",
    'dz'    => "dzonqa\ dili",
    'ebu'   => 'Embu',
    'ee'    => "eve\ dili",
    'efi'   => "efik\ dili",
    'egy'   => "qədimi\ misir\ dili",
    'eka'   => "ekacuk\ dili",
    'el'    => 'yunanca',
    'elx'   => "elamit\ dili",
    'en'    => 'ingiliscə',
    'en_au' => "ingiliscə\ \(AU\)",
    'en_ca' => "ingiliscə\ \(CA\)",
    'en_gb' => "ingiliscə\ \(GB\)",
    'en_us' => "ingiliscə\ \(ABŞ\)",
    'enm'   => "ortacaq\ ingiliscə",
    'eo'    => "esperanto\ dili",
    'es'    => 'ispanca',
    'es_es' => "iber\-ispanca",
    'et'    => 'estonca',
    'eu'    => "bask\ dili",
    'ewo'   => "evondo\ dili",
    'fa'    => 'farsca',
    'fan'   => "fang\ dili",
    'fat'   => "fanti\ dili",
    'ff'    => "fula\ dili",
    'fi'    => 'fincə',
    'fil'   => 'taqaloqca',
    'fiu'   => "fin\-uğri\ dili",
    'fj'    => "fiji\ dili",
    'fo'    => "farer\ dili",
    'fon'   => "fon\ dili",
    'fr'    => 'fransızca',
    'fr_ca' => "fransızca\ \(CA\)",
    'fr_ch' => "isveç\ fransızca",
    'frm'   => "ortacaq\ fransızca",
    'fro'   => "qədimi\ fransızca",
    'frr'   => "şimal\ fris\ dili",
    'frs'   => "Eastern\ Frisian",
    'fur'   => "friul\ dili",
    'fy'    => "frisk\ dili",
    'ga'    => 'irlandca',
    'gaa'   => "qa\ dili",
    'gay'   => "qayo\ dili",
    'gba'   => "qabaya\ dili",
    'gd'    => "skot\ gaelik\ dili",
    'gem'   => "Alman\ dili",
    'gez'   => "qez\ dili",
    'gil'   => "qilbert\ gili",
    'gl'    => "qalisian\ dili",
    'gmh'   => "ortacaq\ yüksək\ almanca",
    'gn'    => 'quaranicə',
    'goh'   => "qədimi\ almanca",
    'gon'   => "qondi\ dili",
    'gor'   => "qorontalo\ dili",
    'got'   => 'gotça',
    'grb'   => "qrebo\ dili",
    'grc'   => "qədimi\ yunanca",
    'gsw'   => "isveç\ almanca",
    'gu'    => "gujarati\ dili",
    'guz'   => 'Gusii',
    'gv'    => "manks\ dili",
    'gwi'   => "qviçin\ dili",
    'ha'    => "Hausa\ dili",
    'hai'   => "hayda\ dili",
    'haw'   => 'Qavayca',
    'he'    => 'ivritcə',
    'hi'    => "hindi\ dili",
    'hil'   => "hiliqaynon\ dili",
    'him'   => "himaçali\ dili",
    'hit'   => "hittit\ dili",
    'hmn'   => "monq\ dili",
    'ho'    => "hiri\ motu\ dili",
    'hr'    => 'xorvatca',
    'hsb'   => "yuxarı\ sorbca",
    'ht'    => "haiti\ dili",
    'hu'    => 'macarca',
    'hup'   => "hupa\ dili",
    'hy'    => 'Ermənicə',
    'hz'    => "Herer\ dili",
    'ia'    => "interlingua\ dili",
    'iba'   => "iban\ dili",
    'id'    => "indoneziya\ dili",
    'ie'    => "interlingue\ dili",
    'ig'    => "iqbo\ dili",
    'ii'    => "siçuan\ yi\ dili",
    'ijo'   => "ico\ dili",
    'ik'    => "inupiaq\ dili",
    'ilo'   => "iloko\ dili",
    'inc'   => "diqər\ hint\ dili",
    'ine'   => "hint\-yevropa\ dili",
    'inh'   => "inquş\ dili",
    'io'    => "ido\ dili",
    'ira'   => 'iranca',
    'iro'   => "irokuay\ dili",
    'is'    => 'isləndcə',
    'it'    => 'italyanca',
    'iu'    => "inuktikut\ dili",
    'ja'    => 'yaponca',
    'jbo'   => "loğban\ dili",
    'jmc'   => 'Machame',
    'jpr'   => "judo\-farsca",
    'jrb'   => "jude\-ərəbcə",
    'jv'    => "yavaca\ dili",
    'ka'    => "gürcü\ dili",
    'kaa'   => "qara\-qalpaq\ dili",
    'kab'   => "kabule\ dili",
    'kac'   => 'kaçinca',
    'kaj'   => "ju\ dili",
    'kam'   => "kamba\ dili",
    'kar'   => "karen\ dili",
    'kaw'   => "kavi\ dili",
    'kbd'   => 'kabardca',
    'kcg'   => "tiyap\ dili",
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => "koro\ dili",
    'kg'    => "konqo\ dili",
    'kha'   => "xazi\ dili",
    'khi'   => "xoyzan\ dili",
    'kho'   => "xotan\ dili",
    'khq'   => "Koyra\ Chiini",
    'ki'    => "kikuyu\ dili",
    'kj'    => "kuanyama\ dili",
    'kk'    => "qazax\ dili",
    'kl'    => "kalalisut\ dili",
    'kln'   => 'Kalenjin',
    'km'    => "kambodiya\ dili",
    'kmb'   => "kimbundu\ dili",
    'kn'    => "kannada\ dili",
    'ko'    => "koreya\ dili",
    'kok'   => "konkan\ dili",
    'kos'   => "kosreyan\ dili",
    'kpe'   => "kpelle\ dili",
    'kr'    => "kanur\ dili",
    'krc'   => "qaraçay\-balkar\ dili",
    'krl'   => "karelyan\ dili",
    'kro'   => "kru\ dili",
    'kru'   => "kurux\ dili",
    'ks'    => "kəşmir\ dili",
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kürdcə',
    'kum'   => "kumuk\ dili",
    'kut'   => "kutenay\ dili",
    'kv'    => "komi\ dili",
    'kw'    => "korniş\ dili",
    'ky'    => 'qırğızca',
    'la'    => 'latınca',
    'lad'   => "ladin\ dili",
    'lag'   => 'Langi',
    'lah'   => "laxnda\ dili",
    'lam'   => "lamba\ dili",
    'lb'    => "luksemburq\ dili",
    'lez'   => "ləzqi\ dili",
    'lg'    => "qanda\ dili",
    'li'    => "limburqiş\ dili",
    'ln'    => "Linqala\ dili",
    'lo'    => "laos\ dili",
    'lol'   => "monqo\ dili",
    'loz'   => "lozi\ dili",
    'lt'    => "litva\ dili",
    'lu'    => "luba\-katanqa\ dili",
    'lua'   => "luba\-lulua\ dili",
    'lui'   => "luyseno\ dili",
    'lun'   => "lunda\ dili",
    'luo'   => "luo\ dili",
    'lus'   => 'lushayca',
    'luy'   => 'Luyia',
    'lv'    => 'latışca',
    'mad'   => "maduriz\ dili",
    'mag'   => "maqahi\ dili",
    'mai'   => "maitili\ dili",
    'mak'   => "makasar\ dili",
    'man'   => "məndinqo\ dili",
    'map'   => 'avstronezicə',
    'mas'   => "masay\ dili",
    'mdf'   => "mokşa\ dili",
    'mdr'   => "mandar\ dili",
    'men'   => "mende\ dili",
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => "malaqas\ dili",
    'mga'   => "ortacaq\ irlandca",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => "marşal\ dili",
    'mi'    => "maori\ dili",
    'mic'   => "mikmak\ dili",
    'min'   => "minanqkaban\ dili",
    'mis'   => "çeşitli\ diller",
    'mk'    => "makedoniya\ dili",
    'mkh'   => "mon\-xmer\ dili",
    'ml'    => 'malayalamca',
    'mn'    => 'monqolca',
    'mnc'   => "mançu\ dili",
    'mni'   => "manipüri\ dili",
    'mno'   => "manobo\ dili",
    'mo'    => 'moldavca',
    'moh'   => "moxak\ dili",
    'mos'   => "mosi\ dili",
    'mr'    => "marati\ dili",
    'ms'    => 'malayca',
    'mt'    => "malta\ dili",
    'mua'   => 'Mundang',
    'mul'   => "digər\ dillər",
    'mun'   => "munda\ dili",
    'mus'   => "krik\ dili",
    'mwl'   => "mirand\ dili",
    'mwr'   => "maruari\ dili",
    'my'    => "burmis\ dili",
    'myn'   => "maya\ dili",
    'myv'   => "erzya\ dili",
    'na'    => "nauru\ dili",
    'nah'   => "nahuatl\ dili",
    'nai'   => "şimal\ amerika\ yerli\ dili",
    'nap'   => "neapolital\ dili",
    'naq'   => 'Nama',
    'nb'    => "norvec\ bokmal\ dili",
    'nd'    => "şimal\ ndebele\ dili",
    'nds'   => "aşağı\ almanca",
    'ne'    => 'nepalca',
    'new'   => "nevari\ dili",
    'ng'    => "nqonka\ dili",
    'nia'   => "nyas\ dili",
    'nic'   => "niger\-kordofyan\ dili",
    'niu'   => "niyuan\ dili",
    'nl'    => 'hollandca',
    'nl_be' => "flem\ dili",
    'nmg'   => 'Kwasio',
    'nn'    => "norveç\ ninorsk\ dili",
    'no'    => "norveç\ dili",
    'nog'   => "noqay\ dili",
    'non'   => "qədimi\ norsca",
    'nqo'   => "nqo\ dili",
    'nr'    => "cənub\ ndebele\ dili",
    'nso'   => "şimal\ soto\ dili",
    'nub'   => "nubiy\ dili",
    'nus'   => 'Nuer',
    'nv'    => "navayo\ dili",
    'nwc'   => "Classical\ Newari",
    'ny'    => "nyanca\ dili",
    'nym'   => "nyamvezi\ dili",
    'nyn'   => "nyankol\ dili",
    'nyo'   => "niyoro\ dili",
    'nzi'   => "nizima\ dili",
    'oc'    => 'oksitanca',
    'oj'    => "ocibva\ dili",
    'om'    => "oromo\ dili",
    'or'    => "Oriyə\ dili",
    'os'    => "osetik\ dili",
    'osa'   => "osage\ dili",
    'ota'   => "osman\ dili",
    'oto'   => "otomian\ dili",
    'pa'    => "puncab\ dili",
    'paa'   => "papua\ dili",
    'pag'   => "panqasinan\ dili",
    'pal'   => "paxlavi\ dili",
    'pam'   => "pampanqa\ dili",
    'pap'   => "papyamento\ dili",
    'pau'   => 'palayanca',
    'peo'   => "qədimi\ farsca",
    'phi'   => "filipin\ dili",
    'phn'   => "foyenik\ dili",
    'pi'    => "pali\ dili",
    'pl'    => "Polish\ dili",
    'pon'   => "ponpeyan\ dili",
    'pra'   => "prakrit\ dili",
    'pro'   => "qədimi\ provensialca",
    'ps'    => "Puştu\ dili",
    'pt'    => 'portuqalca',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "İber\ portuqalca",
    'qu'    => "kuechya\ dili",
    'raj'   => "racastan\ dili",
    'rap'   => "rapanu\ dili",
    'rar'   => "rarotonqan\ dili",
    'rm'    => 'Romansh',
    'rn'    => "rundi\ dili",
    'ro'    => 'rumın',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => "roman\ dili",
    'ru'    => 'rusca',
    'rup'   => 'aromanca',
    'rw'    => "kinyarvanda\ dili",
    'rwk'   => 'Rwa',
    'sa'    => "Sanskrit\ dili",
    'sad'   => "sandave\ dili",
    'sah'   => "yakut\ dili",
    'sai'   => "cənub\ amerika\ yerli\ dili",
    'sal'   => "salişan\ dili",
    'sam'   => "samaritan\ dili",
    'saq'   => 'Samburu',
    'sas'   => "sasak\ dili",
    'sat'   => "santal\ dili",
    'sbp'   => 'Sangu',
    'sc'    => "sardin\ dili",
    'scn'   => "sisili\ dili",
    'sco'   => "skots\ dili",
    'sd'    => "sindhi\ dili",
    'se'    => "şimal\ sami\ dili",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => "selkup\ dili",
    'sem'   => "ivrit\ dili",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => "sanqo\ dili",
    'sga'   => "qədimi\ irlandca",
    'sgn'   => "işarət\ dili",
    'sh'    => "serb\-xorvatca",
    'shi'   => 'Tachelhit',
    'shn'   => "şan\ dili",
    'si'    => 'sinhaliscə',
    'sid'   => "sidamo\ dili",
    'sio'   => "sioyan\ dili",
    'sit'   => "sino\-tibet\ dili",
    'sk'    => 'slovakca',
    'sl'    => 'slovencə',
    'sla'   => "slav\ dili",
    'sm'    => "samoa\ dili",
    'sma'   => "cənub\ sami\ dili",
    'smi'   => "səmi\ dili",
    'smj'   => "lule\ sami\ dili",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ dili",
    'sn'    => "şona\ dili",
    'snk'   => "soninke\ dili",
    'so'    => "somali\ dili",
    'sog'   => "soqdiyen\ dili",
    'son'   => "sonqay\ dili",
    'sq'    => 'Albanca',
    'sr'    => "serb\ dili",
    'srn'   => "sranan\ tonqo\ dili",
    'srr'   => "serer\ dilii",
    'ss'    => "svati\ dili",
    'ssa'   => "nilo\-sahara\ dili",
    'ssy'   => 'Saho',
    'st'    => "Sesoto\ dili",
    'su'    => 'sundanca',
    'suk'   => "sukuma\ dili",
    'sus'   => "susu\ dili",
    'sux'   => "sumeryan\ dili",
    'sv'    => 'isveçcə',
    'sw'    => 'suahilicə',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => "siryak\ dili",
    'ta'    => 'tamilcə',
    'tai'   => "tay\ dili",
    'te'    => "teluqu\ dili",
    'tem'   => "timne\ dili",
    'teo'   => 'Teso',
    'ter'   => "tereno\ dili",
    'tet'   => "tetum\ dili",
    'tg'    => "tacik\ dili",
    'th'    => 'tayca',
    'ti'    => "tiqrin\ dili",
    'tig'   => "tiqre\ dili",
    'tiv'   => "tiv\ dili",
    'tk'    => 'türkməncə',
    'tkl'   => "tokelay\ dili",
    'tl'    => "taqaloq\ dili",
    'tlh'   => 'klinqon',
    'tli'   => "tlinqit\ dili",
    'tmh'   => "tamaşek\ dili",
    'tn'    => "svana\ dili",
    'to'    => "tonqa\ dili",
    'tog'   => "niyasa\ tonga\ dili",
    'tpi'   => "tok\ pisin\ dili",
    'tr'    => 'türkcə',
    'trv'   => 'Taroko',
    'ts'    => "sonqa\ dili",
    'tsi'   => "simşyan\ dili",
    'tt'    => 'tatarca',
    'tum'   => "tumbuka\ dili",
    'tup'   => "tupi\ dili",
    'tut'   => "altaik\ dili",
    'tvl'   => "tuvalu\ dili",
    'tw'    => "Tvi\ dili",
    'twq'   => 'Tasawaq',
    'ty'    => "taxiti\ dili",
    'tyv'   => "tuvinyan\ dili",
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => "udmurt\ dili",
    'ug'    => 'uyğurca',
    'uga'   => "uqaritik\ dili",
    'uk'    => 'ukraynaca',
    'umb'   => "umbundu\ dili",
    'und'   => "bilinməyən\ vəya\ gəcərsiz\ dil",
    'ur'    => 'urduca',
    'uz'    => 'özbəkcə',
    'vai'   => "vay\ dili",
    've'    => "venda\ dili",
    'vi'    => 'vyetnamca',
    'vo'    => "volapük\ dili",
    'vot'   => "votik\ dili",
    'vun'   => 'Vunjo',
    'wa'    => "valun\ dili",
    'wae'   => 'Walser',
    'wak'   => "vakaşan\ dili",
    'wal'   => "valamo\ dili",
    'war'   => "varay\ dili",
    'was'   => "vaşo\ dili",
    'wen'   => "sorb\ dili",
    'wo'    => "volof\ dili",
    'xal'   => 'kalmıqca',
    'xh'    => "xosa\ dili",
    'xog'   => 'Soga',
    'yao'   => "yao\ dili",
    'yap'   => "yapiz\ dili",
    'yav'   => 'Yangben',
    'yi'    => "Yahudi\ dili",
    'yo'    => "yoruba\ dili",
    'ypk'   => "yupik\ dili",
    'yue'   => 'Cantonese',
    'za'    => "juənq\ dili",
    'zap'   => "zapotek\ dili",
    'zbl'   => "blisimbols\ dili",
    'zen'   => "zenaqa\ dili",
    'zh'    => 'çincə',
    'znd'   => "zande\ dili",
    'zu'    => "zulu\ dili",
    'zun'   => "zuni\ dili",
    'zxx'   => "No\ linguistic\ content",
    'zza'   => "zaza\ dili",
);

%Locales::DB::Language::az::name_to_code = (
    'abxazca'                        => 'ab',
    'adangmedili'                    => 'ada',
    'adugedili'                      => 'ady',
    'afarca'                         => 'aa',
    'afrihilidili'                   => 'afh',
    'afrikaanca'                     => 'af',
    'afroaziatdili'                  => 'afa',
    'aghem'                          => 'agq',
    'akadianca'                      => 'akk',
    'akanca'                         => 'ak',
    'akindili'                       => 'ace',
    'akolidili'                      => 'ach',
    'albanca'                        => 'sq',
    'aleutca'                        => 'ale',
    'algonguyandili'                 => 'alg',
    'almanca'                        => 'de',
    'almancaat'                      => 'de_at',
    'almandili'                      => 'gem',
    'altaikdili'                     => 'tut',
    'amarikcə'                      => 'am',
    'angikədili'                    => 'anp',
    'apaçidili'                     => 'apa',
    'aragonca'                       => 'an',
    'aramikdili'                     => 'arc',
    'arapahodili'                    => 'arp',
    'araukanca'                      => 'arn',
    'aravakça'                      => 'arw',
    'aromanca'                       => 'rup',
    'as'                             => 'as',
    'asturicə'                      => 'ast',
    'asu'                            => 'asa',
    'atapaskanca'                    => 'ath',
    'atsamca'                        => 'cch',
    'avadicə'                       => 'awa',
    'avarikcə'                      => 'av',
    'avestanca'                      => 'ae',
    'avstraliyca'                    => 'aus',
    'avstronezicə'                  => 'map',
    'aymarca'                        => 'ay',
    'aynuca'                         => 'ain',
    'azərbaycanca'                  => 'az',
    'aşağıalmanca'                => 'nds',
    'aşağısorbca'                 => 'dsb',
    'bafia'                          => 'ksf',
    'balincə'                       => 'ban',
    'baltikdili'                     => 'bat',
    'balucdili'                      => 'bal',
    'bambaradili'                    => 'bm',
    'bamilekdili'                    => 'bai',
    'bandadili'                      => 'bad',
    'bantudili'                      => 'bnt',
    'basadili'                       => 'bas',
    'baskdili'                       => 'eu',
    'batakdili'                      => 'btk',
    'başkirdili'                    => 'ba',
    'bejadili'                       => 'bej',
    'belarusca'                      => 'be',
    'bembadili'                      => 'bem',
    'bena'                           => 'bez',
    'benqaldili'                     => 'bn',
    'berberdili'                     => 'ber',
    'biharicə'                      => 'bh',
    'bikolca'                        => 'bik',
    'bilincə'                       => 'byn',
    'bilinməyənvəyagəcərsizdil' => 'und',
    'binidili'                       => 'bin',
    'bislamadili'                    => 'bi',
    'blisimbolsdili'                 => 'zbl',
    'bodo'                           => 'brx',
    'bolqarca'                       => 'bg',
    'bosniyadili'                    => 'bs',
    'brajdili'                       => 'bra',
    'brazilianportuguese'            => 'pt_br',
    'bretonca'                       => 'br',
    'bugindili'                      => 'bug',
    'burmisdili'                     => 'my',
    'buryatdili'                     => 'bua',
    'bxoçpuridili'                  => 'bho',
    'cantonese'                      => 'yue',
    'cayuga'                         => 'cay',
    'centralmoroccotamazight'        => 'tzm',
    'chiga'                          => 'cgg',
    'classicalnewari'                => 'nwc',
    'classicalsyriac'                => 'syc',
    'colognian'                      => 'ksh',
    'comorian'                       => 'swb',
    'congoswahili'                   => 'swc',
    'cənubaltaydili'                => 'alt',
    'cənubamerikayerlidili'         => 'sai',
    'cənubndebeledili'              => 'nr',
    'cənubsamidili'                 => 'sma',
    'dakotadili'                     => 'dak',
    'danimarkadili'                  => 'da',
    'darqvadili'                     => 'dar',
    'dayakdili'                      => 'day',
    'delaverdili'                    => 'del',
    'digərdillər'                  => 'mul',
    'dinkadili'                      => 'din',
    'diqərhintdili'                 => 'inc',
    'divehdili'                      => 'dv',
    'doqribdili'                     => 'dgr',
    'doqridili'                      => 'doi',
    'draviddili'                     => 'dra',
    'dualadili'                      => 'dua',
    'dyuladili'                      => 'dyu',
    'dzonqadili'                     => 'dz',
    'easternfrisian'                 => 'frs',
    'efikdili'                       => 'efi',
    'ekacukdili'                     => 'eka',
    'elamitdili'                     => 'elx',
    'embu'                           => 'ebu',
    'ermənicə'                     => 'hy',
    'erzyadili'                      => 'myv',
    'esperantodili'                  => 'eo',
    'estonca'                        => 'et',
    'evedili'                        => 'ee',
    'evondodili'                     => 'ewo',
    'fangdili'                       => 'fan',
    'fantidili'                      => 'fat',
    'farerdili'                      => 'fo',
    'farsca'                         => 'fa',
    'fijidili'                       => 'fj',
    'filipindili'                    => 'phi',
    'fincə'                         => 'fi',
    'finuğridili'                   => 'fiu',
    'flemdili'                       => 'nl_be',
    'fondili'                        => 'fon',
    'foyenikdili'                    => 'phn',
    'fransızca'                     => 'fr',
    'fransızcaca'                   => 'fr_ca',
    'fransızkreoldili'              => 'cpf',
    'friskdili'                      => 'fy',
    'friuldili'                      => 'fur',
    'fuladili'                       => 'ff',
    'gotça'                         => 'got',
    'gujaratidili'                   => 'gu',
    'gusii'                          => 'guz',
    'gürcüdili'                    => 'ka',
    'haitidili'                      => 'ht',
    'hausadili'                      => 'ha',
    'haydadili'                      => 'hai',
    'hererdili'                      => 'hz',
    'hiliqaynondili'                 => 'hil',
    'himaçalidili'                  => 'him',
    'hindidili'                      => 'hi',
    'hintyevropadili'                => 'ine',
    'hirimotudili'                   => 'ho',
    'hittitdili'                     => 'hit',
    'hollandca'                      => 'nl',
    'hupadili'                       => 'hup',
    'ibandili'                       => 'iba',
    'iberispanca'                    => 'es_es',
    'icodili'                        => 'ijo',
    'idodili'                        => 'io',
    'ilokodili'                      => 'ilo',
    'inarisami'                      => 'smn',
    'indoneziyadili'                 => 'id',
    'ingiliscə'                     => 'en',
    'ingiliscəabŞ'                 => 'en_us',
    'ingiliscəau'                   => 'en_au',
    'ingiliscəca'                   => 'en_ca',
    'ingiliscəgb'                   => 'en_gb',
    'ingliskreoldili'                => 'cpe',
    'inquşdili'                     => 'inh',
    'interlinguadili'                => 'ia',
    'interlinguedili'                => 'ie',
    'inuktikutdili'                  => 'iu',
    'inupiaqdili'                    => 'ik',
    'iqbodili'                       => 'ig',
    'iranca'                         => 'ira',
    'irlandca'                       => 'ga',
    'irokuaydili'                    => 'iro',
    'isləndcə'                     => 'is',
    'ispanca'                        => 'es',
    'isveçalmanca'                  => 'gsw',
    'isveçcə'                      => 'sv',
    'isveçfransızca'               => 'fr_ch',
    'isveçyüksəkalmancası'       => 'de_ch',
    'italyanca'                      => 'it',
    'ivritcə'                       => 'he',
    'ivritdili'                      => 'sem',
    'işarətdili'                   => 'sgn',
    'jolafonyi'                      => 'dyo',
    'judeərəbcə'                  => 'jrb',
    'judili'                         => 'kaj',
    'judofarsca'                     => 'jpr',
    'juənqdili'                     => 'za',
    'kabardca'                       => 'kbd',
    'kabuledili'                     => 'kab',
    'kabuverdianu'                   => 'kea',
    'kadodili'                       => 'cad',
    'kalalisutdili'                  => 'kl',
    'kalenjin'                       => 'kln',
    'kalmıqca'                      => 'xal',
    'kambadili'                      => 'kam',
    'kambodiyadili'                  => 'km',
    'kannadadili'                    => 'kn',
    'kanurdili'                      => 'kr',
    'karelyandili'                   => 'krl',
    'karendili'                      => 'kar',
    'karibdili'                      => 'car',
    'katalanca'                      => 'ca',
    'kavidili'                       => 'kaw',
    'kaçinca'                       => 'kac',
    'kaşubyandili'                  => 'csb',
    'kebuanodili'                    => 'ceb',
    'keltdili'                       => 'cel',
    'kikuyudili'                     => 'ki',
    'kilsəslavdili'                 => 'cu',
    'kimbundudili'                   => 'kmb',
    'kinyarvandadili'                => 'rw',
    'klinqon'                        => 'tlh',
    'komidili'                       => 'kv',
    'konkandili'                     => 'kok',
    'konqodili'                      => 'kg',
    'koptdili'                       => 'cop',
    'koreyadili'                     => 'ko',
    'kornişdili'                    => 'kw',
    'korodili'                       => 'kfo',
    'korsikandili'                   => 'co',
    'kosreyandili'                   => 'kos',
    'koyraborosenni'                 => 'ses',
    'koyrachiini'                    => 'khq',
    'kpelledili'                     => 'kpe',
    'kreoldili'                      => 'crp',
    'kridili'                        => 'cr',
    'krikdili'                       => 'mus',
    'krudili'                        => 'kro',
    'krımtürkçə'                 => 'crh',
    'kuanyamadili'                   => 'kj',
    'kuechyadili'                    => 'qu',
    'kumukdili'                      => 'kum',
    'kuruxdili'                      => 'kru',
    'kutenaydili'                    => 'kut',
    'kuşitikdili'                   => 'cus',
    'kwasio'                         => 'nmg',
    'kürdcə'                       => 'ku',
    'kəşmirdili'                   => 'ks',
    'ladindili'                      => 'lad',
    'lambadili'                      => 'lam',
    'langi'                          => 'lag',
    'laosdili'                       => 'lo',
    'latınca'                       => 'la',
    'latışca'                      => 'lv',
    'laxndadili'                     => 'lah',
    'limburqişdili'                 => 'li',
    'linqaladili'                    => 'ln',
    'litvadili'                      => 'lt',
    'lozidili'                       => 'loz',
    'loğbandili'                    => 'jbo',
    'lubakatanqadili'                => 'lu',
    'lubaluluadili'                  => 'lua',
    'luksemburqdili'                 => 'lb',
    'lulesamidili'                   => 'smj',
    'lundadili'                      => 'lun',
    'luodili'                        => 'luo',
    'lushayca'                       => 'lus',
    'luyia'                          => 'luy',
    'luysenodili'                    => 'lui',
    'ləzqidili'                     => 'lez',
    'macarca'                        => 'hu',
    'machame'                        => 'jmc',
    'madurizdili'                    => 'mad',
    'maitilidili'                    => 'mai',
    'makasardili'                    => 'mak',
    'makedoniyadili'                 => 'mk',
    'makhuwameetto'                  => 'mgh',
    'makonde'                        => 'kde',
    'malaqasdili'                    => 'mg',
    'malayalamca'                    => 'ml',
    'malayca'                        => 'ms',
    'maltadili'                      => 'mt',
    'mandardili'                     => 'mdr',
    'manipüridili'                  => 'mni',
    'manksdili'                      => 'gv',
    'manobodili'                     => 'mno',
    'mançudili'                     => 'mnc',
    'maoridili'                      => 'mi',
    'maqahidili'                     => 'mag',
    'maratidili'                     => 'mr',
    'maridili'                       => 'chm',
    'maruaridili'                    => 'mwr',
    'marşaldili'                    => 'mh',
    'masaydili'                      => 'mas',
    'mayadili'                       => 'myn',
    'mendedili'                      => 'men',
    'meru'                           => 'mer',
    'mikmakdili'                     => 'mic',
    'minanqkabandili'                => 'min',
    'miranddili'                     => 'mwl',
    'mokşadili'                     => 'mdf',
    'moldavca'                       => 'mo',
    'monqdili'                       => 'hmn',
    'monqodili'                      => 'lol',
    'monqolca'                       => 'mn',
    'monxmerdili'                    => 'mkh',
    'morisyen'                       => 'mfe',
    'mosidili'                       => 'mos',
    'moxakdili'                      => 'moh',
    'mundadili'                      => 'mun',
    'mundang'                        => 'mua',
    'məndinqodili'                  => 'man',
    'mərkəziamerikaindusdili'      => 'cai',
    'nahuatldili'                    => 'nah',
    'nama'                           => 'naq',
    'naurudili'                      => 'na',
    'navayodili'                     => 'nv',
    'neapolitaldili'                 => 'nap',
    'nepalca'                        => 'ne',
    'nevaridili'                     => 'new',
    'nigerkordofyandili'             => 'nic',
    'nilosaharadili'                 => 'ssa',
    'niyasatongadili'                => 'tog',
    'niyorodili'                     => 'nyo',
    'niyuandili'                     => 'niu',
    'nizimadili'                     => 'nzi',
    'nolinguisticcontent'            => 'zxx',
    'noqaydili'                      => 'nog',
    'norvecbokmaldili'               => 'nb',
    'norveçdili'                    => 'no',
    'norveçninorskdili'             => 'nn',
    'nqodili'                        => 'nqo',
    'nqonkadili'                     => 'ng',
    'nubiydili'                      => 'nub',
    'nuer'                           => 'nus',
    'nyamvezidili'                   => 'nym',
    'nyancadili'                     => 'ny',
    'nyankoldili'                    => 'nyn',
    'nyasdili'                       => 'nia',
    'ocibvadili'                     => 'oj',
    'oksitanca'                      => 'oc',
    'oriyədili'                     => 'or',
    'oromodili'                      => 'om',
    'ortacaqfransızca'              => 'frm',
    'ortacaqhollandca'               => 'dum',
    'ortacaqingiliscə'              => 'enm',
    'ortacaqirlandca'                => 'mga',
    'ortacaqyüksəkalmanca'         => 'gmh',
    'osagedili'                      => 'osa',
    'osetikdili'                     => 'os',
    'osmandili'                      => 'ota',
    'otomiandili'                    => 'oto',
    'palayanca'                      => 'pau',
    'palidili'                       => 'pi',
    'pampanqadili'                   => 'pam',
    'panqasinandili'                 => 'pag',
    'papuadili'                      => 'paa',
    'papyamentodili'                 => 'pap',
    'paxlavidili'                    => 'pal',
    'polishdili'                     => 'pl',
    'ponpeyandili'                   => 'pon',
    'portugalkreoldili'              => 'cpp',
    'portuqalca'                     => 'pt',
    'prakritdili'                    => 'pra',
    'puncabdili'                     => 'pa',
    'puştudili'                     => 'ps',
    'qabayadili'                     => 'gba',
    'qadili'                         => 'gaa',
    'qalisiandili'                   => 'gl',
    'qandadili'                      => 'lg',
    'qaraqalpaqdili'                 => 'kaa',
    'qaraçaybalkardili'             => 'krc',
    'qavayca'                        => 'haw',
    'qavqazdili'                     => 'cau',
    'qayodili'                       => 'gay',
    'qazaxdili'                      => 'kk',
    'qezdili'                        => 'gez',
    'qilbertgili'                    => 'gil',
    'qondidili'                      => 'gon',
    'qorontalodili'                  => 'gor',
    'qrebodili'                      => 'grb',
    'quaranicə'                     => 'gn',
    'qviçindili'                    => 'gwi',
    'qırğızca'                    => 'ky',
    'qədimialmanca'                 => 'goh',
    'qədimifarsca'                  => 'peo',
    'qədimifransızca'              => 'fro',
    'qədimiingiliscə'              => 'ang',
    'qədimiirlandca'                => 'sga',
    'qədimimisirdili'               => 'egy',
    'qədiminorsca'                  => 'non',
    'qədimiprovensialca'            => 'pro',
    'qədimiyunanca'                 => 'grc',
    'racastandili'                   => 'raj',
    'rapanudili'                     => 'rap',
    'rarotonqandili'                 => 'rar',
    'romancelanguage'                => 'roa',
    'romandili'                      => 'rom',
    'romansh'                        => 'rm',
    'rombo'                          => 'rof',
    'rumın'                         => 'ro',
    'rundidili'                      => 'rn',
    'rusca'                          => 'ru',
    'rwa'                            => 'rwk',
    'saho'                           => 'ssy',
    'salişandili'                   => 'sal',
    'samaritandili'                  => 'sam',
    'samburu'                        => 'saq',
    'samoadili'                      => 'sm',
    'sandavedili'                    => 'sad',
    'sangu'                          => 'sbp',
    'sanqodili'                      => 'sg',
    'sanskritdili'                   => 'sa',
    'santaldili'                     => 'sat',
    'sardindili'                     => 'sc',
    'sasakdili'                      => 'sas',
    'selkupdili'                     => 'sel',
    'sena'                           => 'seh',
    'seneca'                         => 'see',
    'serbdili'                       => 'sr',
    'serbxorvatca'                   => 'sh',
    'sererdilii'                     => 'srr',
    'sesotodili'                     => 'st',
    'shambala'                       => 'ksb',
    'sidamodili'                     => 'sid',
    'siksikədili'                   => 'bla',
    'simşyandili'                   => 'tsi',
    'sindhidili'                     => 'sd',
    'sinhaliscə'                    => 'si',
    'sinotibetdili'                  => 'sit',
    'sioyandili'                     => 'sio',
    'siryakdili'                     => 'syr',
    'sisilidili'                     => 'scn',
    'siçuanyidili'                  => 'ii',
    'skoltdili'                      => 'sms',
    'skotgaelikdili'                 => 'gd',
    'skotsdili'                      => 'sco',
    'slavdili'                       => 'sla',
    'slavey'                         => 'den',
    'slovakca'                       => 'sk',
    'slovencə'                      => 'sl',
    'soga'                           => 'xog',
    'somalidili'                     => 'so',
    'soninkedili'                    => 'snk',
    'sonqadili'                      => 'ts',
    'sonqaydili'                     => 'son',
    'soqdiyendili'                   => 'sog',
    'sorbdili'                       => 'wen',
    'sranantonqodili'                => 'srn',
    'suahilicə'                     => 'sw',
    'sukumadili'                     => 'suk',
    'sumeryandili'                   => 'sux',
    'sundanca'                       => 'su',
    'sunidil'                        => 'art',
    'susudili'                       => 'sus',
    'svanadili'                      => 'tn',
    'svatidili'                      => 'ss',
    'səmidili'                      => 'smi',
    'tachelhit'                      => 'shi',
    'tacikdili'                      => 'tg',
    'taita'                          => 'dav',
    'tamaşekdili'                   => 'tmh',
    'tamilcə'                       => 'ta',
    'taqaloqca'                      => 'fil',
    'taqaloqdili'                    => 'tl',
    'taroko'                         => 'trv',
    'tasawaq'                        => 'twq',
    'tatarca'                        => 'tt',
    'taxitidili'                     => 'ty',
    'tayca'                          => 'th',
    'taydili'                        => 'tai',
    'teluqudili'                     => 'te',
    'terenodili'                     => 'ter',
    'teso'                           => 'teo',
    'tetumdili'                      => 'tet',
    'tibetdili'                      => 'bo',
    'timnedili'                      => 'tem',
    'tiqredili'                      => 'tig',
    'tiqrindili'                     => 'ti',
    'tivdili'                        => 'tiv',
    'tiyapdili'                      => 'kcg',
    'tlinqitdili'                    => 'tli',
    'tokelaydili'                    => 'tkl',
    'tokpisindili'                   => 'tpi',
    'tonqadili'                      => 'to',
    'tumbukadili'                    => 'tum',
    'tupidili'                       => 'tup',
    'tuvaludili'                     => 'tvl',
    'tuvinyandili'                   => 'tyv',
    'tvidili'                        => 'tw',
    'türkcə'                       => 'tr',
    'türkməncə'                   => 'tk',
    'udmurtdili'                     => 'udm',
    'uelscə'                        => 'cy',
    'ukraynaca'                      => 'uk',
    'umbundudili'                    => 'umb',
    'uqaritikdili'                   => 'uga',
    'urduca'                         => 'ur',
    'uyğurca'                       => 'ug',
    'vakaşandili'                   => 'wak',
    'valamodili'                     => 'wal',
    'valundili'                      => 'wa',
    'varaydili'                      => 'war',
    'vaydili'                        => 'vai',
    'vaşodili'                      => 'was',
    'vendadili'                      => 've',
    'volapükdili'                   => 'vo',
    'volofdili'                      => 'wo',
    'votikdili'                      => 'vot',
    'vunjo'                          => 'vun',
    'vyetnamca'                      => 'vi',
    'walser'                         => 'wae',
    'xazidili'                       => 'kha',
    'xorvatca'                       => 'hr',
    'xosadili'                       => 'xh',
    'xotandili'                      => 'kho',
    'xoyzandili'                     => 'khi',
    'yahudidili'                     => 'yi',
    'yakutdili'                      => 'sah',
    'yangben'                        => 'yav',
    'yaodili'                        => 'yao',
    'yapizdili'                      => 'yap',
    'yaponca'                        => 'ja',
    'yavacadili'                     => 'jv',
    'yorubadili'                     => 'yo',
    'yunanca'                        => 'el',
    'yupikdili'                      => 'ypk',
    'yuxarısorbca'                  => 'hsb',
    'zandedili'                      => 'znd',
    'zapotekdili'                    => 'zap',
    'zarma'                          => 'dje',
    'zazadili'                       => 'zza',
    'zenaqadili'                     => 'zen',
    'zuludili'                       => 'zu',
    'zunidili'                       => 'zun',
    'çamikdili'                     => 'cmc',
    'çamorodili'                    => 'ch',
    'çağataydili'                  => 'chg',
    'çexdili'                       => 'cs',
    'çeyendili'                     => 'chy',
    'çeçendili'                    => 'ce',
    'çeşitlidiller'                => 'mis',
    'çibçədili'                   => 'chb',
    'çincə'                        => 'zh',
    'çinukləhçəsi'               => 'chn',
    'çipevyandili'                  => 'chp',
    'çirokidili'                    => 'chr',
    'çoktaudili'                    => 'cho',
    'çukizdili'                     => 'chk',
    'çuvaşdili'                    => 'cv',
    'özbəkcə'                     => 'uz',
    'İberportuqalca'                => 'pt_pt',
    'şandili'                       => 'shn',
    'şimalamerikayerlidili'         => 'nai',
    'şimalfrisdili'                 => 'frr',
    'şimalndebeledili'              => 'nd',
    'şimalsamidili'                 => 'se',
    'şimalsotodili'                 => 'nso',
    'şonadili'                      => 'sn',
    'Ərəbcə'                      => 'ar',
);

1;
