package Locales::DB::Language::km;

# Auto generated from CLDR

$Locales::DB::Language::km::VERSION = '0.09';

$Locales::DB::Language::km::cldr_version = '2.0';

%Locales::DB::Language::km::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::km::code_to_name = (
    'aa'    => 'ភាសាអាហ្វារ',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'ភាសាអាវែស្តង់',
    'af'    => 'ភាសាអាហ្វ្រីកាអាន',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'អំហារិក',
    'an'    => 'ភាសាអារ៉ាហ្គោន',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'ភាសាអារ៉ាប់',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ភាសាអីម៉ារ៉ា',
    'az'    => 'ភាសាអាហ៊្សែរបែហ្សង់',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'ភាសាបេឡារុស្ស',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'ភាសាប៊ុលហ្ការី',
    'bh'    => 'ភាសាបិហារ',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'ភាសាបាម្បារា',
    'bn'    => 'ភាសាបេន្កាលី',
    'bnt'   => 'Bantu',
    'bo'    => 'ភាសាទីបេ',
    'br'    => 'ប្រីស្តុន',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'ប៊ូស្នៀរ',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'ភាសាកាតាឡាន',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ភាសាឆេក',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'វេល',
    'da'    => 'ភាសាដាណឺម៉ាក',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'ភាសាអាល្លឺម៉ង់',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'ភាសាប៊ូតាន',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ភាសាក្រិច',
    'elx'   => 'Elamite',
    'en'    => 'ភាសាអង់គ្លេស',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'ភាសាអេស្ពេរ៉ាន្ទោ',
    'es'    => 'ភាសាអេស្ប៉ាញ',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'ភាសាអេស្តូនី',
    'eu'    => 'ភាសាបាស្កេ',
    'ewo'   => 'Ewondo',
    'fa'    => 'ភឺសៀន',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ភាសាហ្វាំងឡង់',
    'fil'   => 'ពីលីពីន',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ហ្វ៉ីហ្ស៉ី',
    'fo'    => 'ហ្វារូស',
    'fon'   => 'Fon',
    'fr'    => 'ភាសាបារាំង',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'ហ្រីសង់',
    'ga'    => 'ភាសាហ្កែលិគ',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "ភាសាហ្កែលិគ\ \[gd\]",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'ភាសាហ្កាលីស៉ី',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ភាសាហ្កួរ៉ានី',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'ភាសាហ្កុយ៉ារាទី',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'ភាសាហេប្រិ',
    'hi'    => 'ភាសាហ៉ិនឌី',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ក្រូអាទៀន',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ភាសាហុងគ្រី',
    'hup'   => 'Hupa',
    'hy'    => 'ភាសាអារមេនី',
    'hz'    => 'Herero',
    'ia'    => 'អីនធើលីង',
    'iba'   => 'Iban',
    'id'    => 'ភាសាឥណ្ឌូនេស៊ី',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'ភាសាអ៉ីស្លង់',
    'it'    => 'ភាសាអ៊ីតាលី',
    'iu'    => 'Inuktitut',
    'ja'    => 'ភាសាជប៉ុន',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ភាសាយ៉ាវា',
    'ka'    => 'ភាសាហ្សកហ្ស៉ី',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'ភាសាកាហ្សាក់ស្តង់់',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'ភាសាខ្មែរ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ភាសាកិណាដា',
    'ko'    => 'ភាសាកូរ៉េ',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'ភាសាឃឺដ',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'ភាសាគៀរហ្គីស្តង់',
    'la'    => 'ភាសាឡាតំាង',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'លីនកាឡា',
    'lo'    => 'ភាសាឡាវ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ភាសាលីទុយអានី',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'ភាសាឡាតវីយ៉ា',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'ភាសាម៉ាដាហ្កាសការ',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'ភាសាម៉ោរី',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ភាសាម៉ាសេដូនី',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'ភាសាម៉ាឡាឡាយ៉ាន',
    'mn'    => 'ភាសាម៉ុងហ្គោលី',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'ភាសាម៉ុលដាវី',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ភាសាម៉ារាធី',
    'ms'    => 'ភាសាម៉ាលេស៉ី',
    'mt'    => 'ភាសាម៉ាល់តា',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'ភាសានេប៉ាល់',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ភាសាហុល្លង់',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => 'ន័រវេ',
    'no'    => 'ភាសាន័រវែស',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'អូសីតាន់',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'ភាសាអូរីយ៉ា',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ភាសាពូនយ៉ាប៊ី',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'ភាសាប៉ូឡូញ',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'បាស្តូ',
    'pt'    => 'ភាសាព័រទុយហ្កាល់',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'ភាសាកេទ្ជូអា',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'ភាសារូន្ឌី',
    'ro'    => 'ភាសារូម៉ានី',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ភាសាรัរូស្ស៉ី',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'ភាសាសំស្ក្រឹត',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'ភាសាស៉ីន្ដី',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'សើបូក្រូទៀន',
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'សីនហាលិស',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ភាសាស្លូវ៉ាគី',
    'sl'    => 'ភាសាស្លូវ៉ានី',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ភាសាសាមូអា',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'ភាសាសូម៉ាលី',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ភាសាអាល់បានី',
    'sr'    => 'សើបៀន',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'សេសូដូ',
    'su'    => 'ភាំសាស៊ូដង់',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ភាសាស៊ុយអែដ',
    'sw'    => 'ភាសាស្វាហ៉ីលី',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'ភាសាតាមីល',
    'tai'   => "Tai\ Language",
    'te'    => 'ភាសាតេលូហ្គូ',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'ភាសាតាដហ្ស៉ីគីស្តង់',
    'th'    => 'ភាសាថៃ',
    'ti'    => 'ទីរិនយា',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'ភាសាទួគមេនីស្តង់',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'ខ្លិងសុន',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'ភាសាតុងហ្គោ',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'ភាសាទួរគី',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'ភាសាតាតារ',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'ទ្វី',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ភាសាអ៊ុយក្រែន',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ Language",
    'ur'    => 'ភាសាអ៊ូរ្ឌូ',
    'uz'    => 'ភាសាអ៊ូហ្សបេគីស្តង់',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ភាសាវៀតណាម',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'ភាសាឃសា',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'ភាសាយីឌីហ្ស',
    'yo'    => 'ភាសាយរូបា',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'ភាសាចួង',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ភាសាចិន',
    'znd'   => 'Zande',
    'zu'    => 'ភាសាហ្ស៉ូលូ',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::km::name_to_code = (
    'abkhazian'                                                 => 'ab',
    'achinese'                                                  => 'ace',
    'acoli'                                                     => 'ach',
    'adangme'                                                   => 'ada',
    'adyghe'                                                    => 'ady',
    'afrihili'                                                  => 'afh',
    'afroasiaticlanguage'                                       => 'afa',
    'aghem'                                                     => 'agq',
    'ainu'                                                      => 'ain',
    'akan'                                                      => 'ak',
    'akkadian'                                                  => 'akk',
    'aleut'                                                     => 'ale',
    'algonquianlanguage'                                        => 'alg',
    'altaiclanguage'                                            => 'tut',
    'ancientegyptian'                                           => 'egy',
    'ancientgreek'                                              => 'grc',
    'angika'                                                    => 'anp',
    'apachelanguage'                                            => 'apa',
    'aramaic'                                                   => 'arc',
    'arapaho'                                                   => 'arp',
    'araucanian'                                                => 'arn',
    'arawak'                                                    => 'arw',
    'aromanian'                                                 => 'rup',
    'artificiallanguage'                                        => 'art',
    'assamese'                                                  => 'as',
    'asturian'                                                  => 'ast',
    'asu'                                                       => 'asa',
    'athapascanlanguage'                                        => 'ath',
    'atsam'                                                     => 'cch',
    'australianenglish'                                         => 'en_au',
    'australianlanguage'                                        => 'aus',
    'austriangerman'                                            => 'de_at',
    'austronesianlanguage'                                      => 'map',
    'avaric'                                                    => 'av',
    'awadhi'                                                    => 'awa',
    'bafia'                                                     => 'ksf',
    'balinese'                                                  => 'ban',
    'balticlanguage'                                            => 'bat',
    'baluchi'                                                   => 'bal',
    'bamilekelanguage'                                          => 'bai',
    'banda'                                                     => 'bad',
    'bantu'                                                     => 'bnt',
    'basaa'                                                     => 'bas',
    'bashkir'                                                   => 'ba',
    'batak'                                                     => 'btk',
    'beja'                                                      => 'bej',
    'bemba'                                                     => 'bem',
    'bena'                                                      => 'bez',
    'berber'                                                    => 'ber',
    'bhojpuri'                                                  => 'bho',
    'bikol'                                                     => 'bik',
    'bini'                                                      => 'bin',
    'bislama'                                                   => 'bi',
    'blin'                                                      => 'byn',
    'blissymbols'                                               => 'zbl',
    'bodo'                                                      => 'brx',
    'braj'                                                      => 'bra',
    'brazilianportuguese'                                       => 'pt_br',
    'britishenglish'                                            => 'en_gb',
    'buginese'                                                  => 'bug',
    'buriat'                                                    => 'bua',
    'burmese'                                                   => 'my',
    'caddo'                                                     => 'cad',
    'canadianenglish'                                           => 'en_ca',
    'canadianfrench'                                            => 'fr_ca',
    'cantonese'                                                 => 'yue',
    'carib'                                                     => 'car',
    'caucasianlanguage'                                         => 'cau',
    'cayuga'                                                    => 'cay',
    'cebuano'                                                   => 'ceb',
    'celticlanguage'                                            => 'cel',
    'centralamericanindianlanguage'                             => 'cai',
    'centralmoroccotamazight'                                   => 'tzm',
    'chagatai'                                                  => 'chg',
    'chamiclanguage'                                            => 'cmc',
    'chamorro'                                                  => 'ch',
    'chechen'                                                   => 'ce',
    'cherokee'                                                  => 'chr',
    'cheyenne'                                                  => 'chy',
    'chibcha'                                                   => 'chb',
    'chiga'                                                     => 'cgg',
    'chinookjargon'                                             => 'chn',
    'chipewyan'                                                 => 'chp',
    'choctaw'                                                   => 'cho',
    'churchslavic'                                              => 'cu',
    'chuukese'                                                  => 'chk',
    'chuvash'                                                   => 'cv',
    'classicalnewari'                                           => 'nwc',
    'classicalsyriac'                                           => 'syc',
    'colognian'                                                 => 'ksh',
    'comorian'                                                  => 'swb',
    'congoswahili'                                              => 'swc',
    'coptic'                                                    => 'cop',
    'cornish'                                                   => 'kw',
    'corsican'                                                  => 'co',
    'cree'                                                      => 'cr',
    'creek'                                                     => 'mus',
    'creoleorpidgin'                                            => 'crp',
    'crimeanturkish'                                            => 'crh',
    'cushiticlanguage'                                          => 'cus',
    'dakota'                                                    => 'dak',
    'dargwa'                                                    => 'dar',
    'dayak'                                                     => 'day',
    'delaware'                                                  => 'del',
    'dinka'                                                     => 'din',
    'divehi'                                                    => 'dv',
    'dogri'                                                     => 'doi',
    'dogrib'                                                    => 'dgr',
    'dravidianlanguage'                                         => 'dra',
    'duala'                                                     => 'dua',
    'dyula'                                                     => 'dyu',
    'easternfrisian'                                            => 'frs',
    'efik'                                                      => 'efi',
    'ekajuk'                                                    => 'eka',
    'elamite'                                                   => 'elx',
    'embu'                                                      => 'ebu',
    'englishbasedcreoleorpidgin'                                => 'cpe',
    'erzya'                                                     => 'myv',
    'ewe'                                                       => 'ee',
    'ewondo'                                                    => 'ewo',
    'fang'                                                      => 'fan',
    'fanti'                                                     => 'fat',
    'finnougrianlanguage'                                       => 'fiu',
    'flemish'                                                   => 'nl_be',
    'fon'                                                       => 'fon',
    'frenchbasedcreoleorpidgin'                                 => 'cpf',
    'friulian'                                                  => 'fur',
    'fulah'                                                     => 'ff',
    'ga'                                                        => 'gaa',
    'ganda'                                                     => 'lg',
    'gayo'                                                      => 'gay',
    'gbaya'                                                     => 'gba',
    'geez'                                                      => 'gez',
    'germaniclanguage'                                          => 'gem',
    'gilbertese'                                                => 'gil',
    'gondi'                                                     => 'gon',
    'gorontalo'                                                 => 'gor',
    'gothic'                                                    => 'got',
    'grebo'                                                     => 'grb',
    'gusii'                                                     => 'guz',
    "gwich\Ê\¼in"                                             => 'gwi',
    'haida'                                                     => 'hai',
    'haitian'                                                   => 'ht',
    'hausa'                                                     => 'ha',
    'hawaiian'                                                  => 'haw',
    'herero'                                                    => 'hz',
    'hiligaynon'                                                => 'hil',
    'himachali'                                                 => 'him',
    'hirimotu'                                                  => 'ho',
    'hittite'                                                   => 'hit',
    'hmong'                                                     => 'hmn',
    'hupa'                                                      => 'hup',
    'iban'                                                      => 'iba',
    'iberianportuguese'                                         => 'pt_pt',
    'iberianspanish'                                            => 'es_es',
    'ido'                                                       => 'io',
    'igbo'                                                      => 'ig',
    'ijo'                                                       => 'ijo',
    'iloko'                                                     => 'ilo',
    'inarisami'                                                 => 'smn',
    'indiclanguage'                                             => 'inc',
    'indoeuropeanlanguage'                                      => 'ine',
    'ingush'                                                    => 'inh',
    'interlingue'                                               => 'ie',
    'inuktitut'                                                 => 'iu',
    'inupiaq'                                                   => 'ik',
    'iranianlanguage'                                           => 'ira',
    'iroquoianlanguage'                                         => 'iro',
    'jju'                                                       => 'kaj',
    'jolafonyi'                                                 => 'dyo',
    'judeoarabic'                                               => 'jrb',
    'judeopersian'                                              => 'jpr',
    'kabardian'                                                 => 'kbd',
    'kabuverdianu'                                              => 'kea',
    'kabyle'                                                    => 'kab',
    'kachin'                                                    => 'kac',
    'kalaallisut'                                               => 'kl',
    'kalenjin'                                                  => 'kln',
    'kalmyk'                                                    => 'xal',
    'kamba'                                                     => 'kam',
    'kanuri'                                                    => 'kr',
    'karachaybalkar'                                            => 'krc',
    'karakalpak'                                                => 'kaa',
    'karelian'                                                  => 'krl',
    'karen'                                                     => 'kar',
    'kashmiri'                                                  => 'ks',
    'kashubian'                                                 => 'csb',
    'kawi'                                                      => 'kaw',
    'khasi'                                                     => 'kha',
    'khoisanlanguage'                                           => 'khi',
    'khotanese'                                                 => 'kho',
    'kikuyu'                                                    => 'ki',
    'kimbundu'                                                  => 'kmb',
    'kinyarwanda'                                               => 'rw',
    'komi'                                                      => 'kv',
    'kongo'                                                     => 'kg',
    'konkani'                                                   => 'kok',
    'koro'                                                      => 'kfo',
    'kosraean'                                                  => 'kos',
    'koyraborosenni'                                            => 'ses',
    'koyrachiini'                                               => 'khq',
    'kpelle'                                                    => 'kpe',
    'kru'                                                       => 'kro',
    'kuanyama'                                                  => 'kj',
    'kumyk'                                                     => 'kum',
    'kurukh'                                                    => 'kru',
    'kutenai'                                                   => 'kut',
    'kwasio'                                                    => 'nmg',
    'ladino'                                                    => 'lad',
    'lahnda'                                                    => 'lah',
    'lamba'                                                     => 'lam',
    'langi'                                                     => 'lag',
    'lezghian'                                                  => 'lez',
    'limburgish'                                                => 'li',
    'lojban'                                                    => 'jbo',
    'lowersorbian'                                              => 'dsb',
    'lowgerman'                                                 => 'nds',
    'lozi'                                                      => 'loz',
    'lubakatanga'                                               => 'lu',
    'lubalulua'                                                 => 'lua',
    'luiseno'                                                   => 'lui',
    'lulesami'                                                  => 'smj',
    'lunda'                                                     => 'lun',
    'luo'                                                       => 'luo',
    'lushai'                                                    => 'lus',
    'luxembourgish'                                             => 'lb',
    'luyia'                                                     => 'luy',
    'machame'                                                   => 'jmc',
    'madurese'                                                  => 'mad',
    'magahi'                                                    => 'mag',
    'maithili'                                                  => 'mai',
    'makasar'                                                   => 'mak',
    'makhuwameetto'                                             => 'mgh',
    'makonde'                                                   => 'kde',
    'manchu'                                                    => 'mnc',
    'mandar'                                                    => 'mdr',
    'mandingo'                                                  => 'man',
    'manipuri'                                                  => 'mni',
    'manobolanguage'                                            => 'mno',
    'manx'                                                      => 'gv',
    'mari'                                                      => 'chm',
    'marshallese'                                               => 'mh',
    'marwari'                                                   => 'mwr',
    'masai'                                                     => 'mas',
    'mayanlanguage'                                             => 'myn',
    'mende'                                                     => 'men',
    'meru'                                                      => 'mer',
    'micmac'                                                    => 'mic',
    'middledutch'                                               => 'dum',
    'middleenglish'                                             => 'enm',
    'middlefrench'                                              => 'frm',
    'middlehighgerman'                                          => 'gmh',
    'middleirish'                                               => 'mga',
    'minangkabau'                                               => 'min',
    'mirandese'                                                 => 'mwl',
    'miscellaneouslanguage'                                     => 'mis',
    'mohawk'                                                    => 'moh',
    'moksha'                                                    => 'mdf',
    'mongo'                                                     => 'lol',
    'monkhmerlanguage'                                          => 'mkh',
    'morisyen'                                                  => 'mfe',
    'mossi'                                                     => 'mos',
    'multiplelanguages'                                         => 'mul',
    'mundalanguage'                                             => 'mun',
    'mundang'                                                   => 'mua',
    'nahuatl'                                                   => 'nah',
    'nama'                                                      => 'naq',
    'nauru'                                                     => 'na',
    'navajo'                                                    => 'nv',
    'ndonga'                                                    => 'ng',
    'neapolitan'                                                => 'nap',
    'newari'                                                    => 'new',
    'nias'                                                      => 'nia',
    'nigerkordofanianlanguage'                                  => 'nic',
    'nilosaharanlanguage'                                       => 'ssa',
    'niuean'                                                    => 'niu',
    'nogai'                                                     => 'nog',
    'nolinguisticcontent'                                       => 'zxx',
    'northamericanindianlanguage'                               => 'nai',
    'northernfrisian'                                           => 'frr',
    'northernsami'                                              => 'se',
    'northernsotho'                                             => 'nso',
    'northndebele'                                              => 'nd',
    "norwegianbokm\Ã\¥l"                                      => 'nb',
    'nubianlanguage'                                            => 'nub',
    'nuer'                                                      => 'nus',
    'nyamwezi'                                                  => 'nym',
    'nyanja'                                                    => 'ny',
    'nyankole'                                                  => 'nyn',
    'nyasatonga'                                                => 'tog',
    'nyoro'                                                     => 'nyo',
    'nzima'                                                     => 'nzi',
    "n\â\\ko"                                              => 'nqo',
    'ojibwa'                                                    => 'oj',
    'oldenglish'                                                => 'ang',
    'oldfrench'                                                 => 'fro',
    'oldhighgerman'                                             => 'goh',
    'oldirish'                                                  => 'sga',
    'oldnorse'                                                  => 'non',
    'oldpersian'                                                => 'peo',
    "oldproven\Ã\§al"                                         => 'pro',
    'oromo'                                                     => 'om',
    'osage'                                                     => 'osa',
    'ossetic'                                                   => 'os',
    'otomianlanguage'                                           => 'oto',
    'ottomanturkish'                                            => 'ota',
    'pahlavi'                                                   => 'pal',
    'palauan'                                                   => 'pau',
    'pali'                                                      => 'pi',
    'pampanga'                                                  => 'pam',
    'pangasinan'                                                => 'pag',
    'papiamento'                                                => 'pap',
    'papuanlanguage'                                            => 'paa',
    'philippinelanguage'                                        => 'phi',
    'phoenician'                                                => 'phn',
    'pohnpeian'                                                 => 'pon',
    'portuguesebasedcreoleorpidgin'                             => 'cpp',
    'prakritlanguage'                                           => 'pra',
    'rajasthani'                                                => 'raj',
    'rapanui'                                                   => 'rap',
    'rarotongan'                                                => 'rar',
    'romancelanguage'                                           => 'roa',
    'romansh'                                                   => 'rm',
    'romany'                                                    => 'rom',
    'rombo'                                                     => 'rof',
    'rwa'                                                       => 'rwk',
    'saho'                                                      => 'ssy',
    'sakha'                                                     => 'sah',
    'salishanlanguage'                                          => 'sal',
    'samaritanaramaic'                                          => 'sam',
    'samburu'                                                   => 'saq',
    'samilanguage'                                              => 'smi',
    'sandawe'                                                   => 'sad',
    'sango'                                                     => 'sg',
    'sangu'                                                     => 'sbp',
    'santali'                                                   => 'sat',
    'sardinian'                                                 => 'sc',
    'sasak'                                                     => 'sas',
    'scots'                                                     => 'sco',
    'selkup'                                                    => 'sel',
    'semiticlanguage'                                           => 'sem',
    'sena'                                                      => 'seh',
    'seneca'                                                    => 'see',
    'serer'                                                     => 'srr',
    'shambala'                                                  => 'ksb',
    'shan'                                                      => 'shn',
    'shona'                                                     => 'sn',
    'sichuanyi'                                                 => 'ii',
    'sicilian'                                                  => 'scn',
    'sidamo'                                                    => 'sid',
    'signlanguage'                                              => 'sgn',
    'siksika'                                                   => 'bla',
    'sinotibetanlanguage'                                       => 'sit',
    'siouanlanguage'                                            => 'sio',
    'skoltsami'                                                 => 'sms',
    'slave'                                                     => 'den',
    'slaviclanguage'                                            => 'sla',
    'soga'                                                      => 'xog',
    'sogdien'                                                   => 'sog',
    'songhai'                                                   => 'son',
    'soninke'                                                   => 'snk',
    'sorbianlanguage'                                           => 'wen',
    'southamericanindianlanguage'                               => 'sai',
    'southernaltai'                                             => 'alt',
    'southernsami'                                              => 'sma',
    'southndebele'                                              => 'nr',
    'sranantongo'                                               => 'srn',
    'sukuma'                                                    => 'suk',
    'sumerian'                                                  => 'sux',
    'susu'                                                      => 'sus',
    'swati'                                                     => 'ss',
    'swissfrench'                                               => 'fr_ch',
    'swissgerman'                                               => 'gsw',
    'swisshighgerman'                                           => 'de_ch',
    'syriac'                                                    => 'syr',
    'tachelhit'                                                 => 'shi',
    'tagalog'                                                   => 'tl',
    'tahitian'                                                  => 'ty',
    'tailanguage'                                               => 'tai',
    'taita'                                                     => 'dav',
    'tamashek'                                                  => 'tmh',
    'taroko'                                                    => 'trv',
    'tasawaq'                                                   => 'twq',
    'tereno'                                                    => 'ter',
    'teso'                                                      => 'teo',
    'tetum'                                                     => 'tet',
    'tigre'                                                     => 'tig',
    'timne'                                                     => 'tem',
    'tiv'                                                       => 'tiv',
    'tlingit'                                                   => 'tli',
    'tokelau'                                                   => 'tkl',
    'tokpisin'                                                  => 'tpi',
    'tsimshian'                                                 => 'tsi',
    'tsonga'                                                    => 'ts',
    'tswana'                                                    => 'tn',
    'tumbuka'                                                   => 'tum',
    'tupilanguage'                                              => 'tup',
    'tuvalu'                                                    => 'tvl',
    'tuvinian'                                                  => 'tyv',
    'tyap'                                                      => 'kcg',
    "u\.s\.english"                                             => 'en_us',
    'udmurt'                                                    => 'udm',
    'ugaritic'                                                  => 'uga',
    'umbundu'                                                   => 'umb',
    'unknownlanguage'                                           => 'und',
    'uppersorbian'                                              => 'hsb',
    'uyghur'                                                    => 'ug',
    'vai'                                                       => 'vai',
    'venda'                                                     => 've',
    "volap\Ã\¼k"                                              => 'vo',
    'votic'                                                     => 'vot',
    'vunjo'                                                     => 'vun',
    'wakashanlanguage'                                          => 'wak',
    'walamo'                                                    => 'wal',
    'walloon'                                                   => 'wa',
    'walser'                                                    => 'wae',
    'waray'                                                     => 'war',
    'washo'                                                     => 'was',
    'wolof'                                                     => 'wo',
    'yangben'                                                   => 'yav',
    'yao'                                                       => 'yao',
    'yapese'                                                    => 'yap',
    'yupiklanguage'                                             => 'ypk',
    'zande'                                                     => 'znd',
    'zapotec'                                                   => 'zap',
    'zarma'                                                     => 'dje',
    'zaza'                                                      => 'zza',
    'zenaga'                                                    => 'zen',
    'zuni'                                                      => 'zun',
    'ក្រូអាទៀន'                               => 'hr',
    'ខ្លិងសុន'                                  => 'tlh',
    'ទីរិនយា'                                     => 'ti',
    'ទ្វី'                                              => 'tw',
    'ន័រវេ'                                           => 'nn',
    'បាស្តូ'                                        => 'ps',
    'ប៊ូស្នៀរ'                                  => 'bs',
    'ប្រីស្តុន'                               => 'br',
    'ពីលីពីន'                                     => 'fil',
    'ភាសាรัរូស្ស៉ី'                   => 'ru',
    'ភាសាកាតាឡាន'                         => 'ca',
    'ភាសាកាហ្សាក់ស្តង់់'    => 'kk',
    'ភាសាកិណាដា'                            => 'kn',
    'ភាសាកូរ៉េ'                               => 'ko',
    'ភាសាកេទ្ជូអា'                      => 'qu',
    'ភាសាក្រិច'                               => 'el',
    'ភាសាខ្មែរ'                               => 'km',
    'ភាសាគៀរហ្គីស្តង់'          => 'ky',
    'ភាសាឃសា'                                     => 'xh',
    'ភាសាឃឺដ'                                     => 'ku',
    'ភាសាចិន'                                     => 'zh',
    'ភាសាចួង'                                     => 'za',
    'ភាសាឆេក'                                     => 'cs',
    'ភាសាជប៉ុន'                               => 'ja',
    'ភាសាដាណឺម៉ាក'                      => 'da',
    'ភាសាតាដហ្ស៉ីគីស្តង់' => 'tg',
    'ភាសាតាតារ'                               => 'tt',
    'ភាសាតាមីល'                               => 'ta',
    'ភាសាតុងហ្គោ'                         => 'to',
    'ភាសាតេលូហ្គូ'                      => 'te',
    'ភាសាថៃ'                                        => 'th',
    'ភាសាទីបេ'                                  => 'bo',
    'ភាសាទួគមេនីស្តង់'          => 'tk',
    'ភាសាទួរគី'                               => 'tr',
    'ភាសានេប៉ាល់'                         => 'ne',
    'ភាសាន័រវែស'                            => 'no',
    'ភាសាបាម្បារា'                      => 'bm',
    'ភាសាបារាំង'                            => 'fr',
    'ភាសាបាស្កេ'                            => 'eu',
    'ភាសាបិហារ'                               => 'bh',
    'ភាសាបេន្កាលី'                      => 'bn',
    'ភាសាបេឡារុស្ស'                   => 'be',
    'ភាសាប៉ូឡូញ'                            => 'pl',
    'ភាសាប៊ុលហ្ការី'                => 'bg',
    'ភាសាប៊ូតាន'                            => 'dz',
    'ភាសាពូនយ៉ាប៊ី'                   => 'pa',
    'ភាសាព័រទុយហ្កាល់'          => 'pt',
    'ភាសាម៉ាដាហ្កាសការ'       => 'mg',
    'ភាសាម៉ារាធី'                         => 'mr',
    'ភាសាម៉ាលេស៉ី'                      => 'ms',
    'ភាសាម៉ាល់តា'                         => 'mt',
    'ភាសាម៉ាសេដូនី'                   => 'mk',
    'ភាសាម៉ាឡាឡាយ៉ាន'             => 'ml',
    'ភាសាម៉ុងហ្គោលី'                => 'mn',
    'ភាសាម៉ុលដាវី'                      => 'mo',
    'ភាសាម៉ោរី'                               => 'mi',
    'ភាសាយរូបា'                               => 'yo',
    'ភាសាយីឌីហ្ស'                         => 'yi',
    'ភាសាយ៉ាវា'                               => 'jv',
    'ភាសារូន្ឌី'                            => 'rn',
    'ភាសារូម៉ានី'                         => 'ro',
    'ភាសាលីទុយអានី'                   => 'lt',
    'ភាសាវៀតណាម'                            => 'vi',
    'ភាសាសាមូអា'                            => 'sm',
    'ភាសាសូម៉ាលី'                         => 'so',
    'ភាសាសំស្ក្រឹត'                   => 'sa',
    'ភាសាស៉ីន្ដី'                         => 'sd',
    'ភាសាស៊ុយអែដ'                         => 'sv',
    'ភាសាស្លូវ៉ាគី'                   => 'sk',
    'ភាសាស្លូវ៉ានី'                   => 'sl',
    'ភាសាស្វាហ៉ីលី'                   => 'sw',
    'ភាសាហុងគ្រី'                         => 'hu',
    'ភាសាហុល្លង់'                         => 'nl',
    'ភាសាហេប្រិ'                            => 'he',
    'ភាសាហ៉ិនឌី'                            => 'hi',
    'ភាសាហ្កាលីស៉ី'                   => 'gl',
    'ភាសាហ្កុយ៉ារាទី'             => 'gu',
    'ភាសាហ្កួរ៉ានី'                   => 'gn',
    'ភាសាហ្កែលិគ'                         => 'ga',
    'ភាសាហ្កែលិគgd'                       => 'gd',
    'ភាសាហ្វាំងឡង់'                   => 'fi',
    'ភាសាហ្សកហ្ស៉ី'                   => 'ka',
    'ភាសាហ្ស៉ូលូ'                         => 'zu',
    'ភាសាឡាតវីយ៉ា'                      => 'lv',
    'ភាសាឡាតំាង'                            => 'la',
    'ភាសាឡាវ'                                     => 'lo',
    'ភាសាអង់គ្លេស'                      => 'en',
    'ភាសាអារមេនី'                         => 'hy',
    'ភាសាអារ៉ាប់'                         => 'ar',
    'ភាសាអារ៉ាហ្គោន'                => 'an',
    'ភាសាអាល់បានី'                      => 'sq',
    'ភាសាអាល្លឺម៉ង់'                => 'de',
    'ភាសាអាវែស្តង់'                   => 'ae',
    'ភាសាអាហ៊្សែរបែហ្សង់' => 'az',
    'ភាសាអាហ្វារ'                         => 'aa',
    'ភាសាអាហ្វ្រីកាអាន'       => 'af',
    'ភាសាអីម៉ារ៉ា'                      => 'ay',
    'ភាសាអូរីយ៉ា'                         => 'or',
    'ភាសាអេស្តូនី'                      => 'et',
    'ភាសាអេស្ប៉ាញ'                      => 'es',
    'ភាសាអេស្ពេរ៉ាន្ទោ'       => 'eo',
    'ភាសាអ៉ីស្លង់'                      => 'is',
    'ភាសាអ៊ីតាលី'                         => 'it',
    'ភាសាអ៊ុយក្រែន'                   => 'uk',
    'ភាសាអ៊ូរ្ឌូ'                         => 'ur',
    'ភាសាអ៊ូហ្សបេគីស្តង់' => 'uz',
    'ភាសាឥណ្ឌូនេស៊ី'                => 'id',
    'ភាំសាស៊ូដង់'                         => 'su',
    'ភឺសៀន'                                           => 'fa',
    'លីនកាឡា'                                     => 'ln',
    'វេល'                                                 => 'cy',
    'សីនហាលិស'                                  => 'si',
    'សើបូក្រូទៀន'                         => 'sh',
    'សើបៀន'                                           => 'sr',
    'សេសូដូ'                                        => 'st',
    'ហ្រីសង់'                                     => 'fy',
    'ហ្វារូស'                                     => 'fo',
    'ហ្វ៉ីហ្ស៉ី'                            => 'fj',
    'អីនធើលីង'                                  => 'ia',
    'អូសីតាន់'                                  => 'oc',
    'អំហារិក'                                     => 'am',
);

1;
