package Locales::DB::Language::am;

# Auto generated from CLDR

$Locales::DB::Language::am::VERSION = '0.02';

$Locales::DB::Language::am::cldr_version = '1.7.1';

%Locales::DB::Language::am::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "አይ\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "አዎን\:y",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::am::code_to_name = (
    'aa'    => 'አፋርኛ',
    'ab'    => 'አብሐዚኛ',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'አፍሪካንስኛ',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'አማርኛ',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'ዐርቢኛ',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'አሳሜዛዊ',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'አያማርኛ',
    'az'    => 'አዜርባይጃንኛ',
    'ba'    => 'ባስኪርኛ',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'ቤላራሻኛ',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'ቡልጋሪኛ',
    'bh'    => 'ቢሃሪ',
    'bho'   => 'Bhojpuri',
    'bi'    => 'ቢስላምኛ',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'በንጋሊኛ',
    'bnt'   => 'Bantu',
    'bo'    => 'ትበትንኛ',
    'br'    => 'ብሬቶንኛ',
    'bra'   => 'Braj',
    'bs'    => 'ቦስኒያንኛ',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'ብሊን',
    'ca'    => 'ካታላንኛ',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'ኮርሲካኛ',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ቼክኛ',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ወልሽ',
    'da'    => 'ዴኒሽ',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'ጀርመን',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'ድዞንግኻኛ',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ግሪክኛ',
    'elx'   => 'Elamite',
    'en'    => 'እንግሊዝኛ',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'ኤስፐራንቶ',
    'es'    => 'ስፓኒሽ',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'ኤስቶኒአን',
    'eu'    => 'ባስክኛ',
    'ewo'   => 'Ewondo',
    'fa'    => 'ፐርሲያኛ',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ፊኒሽ',
    'fil'   => 'ፊሊፕንኛ',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ፊጂኛ',
    'fo'    => 'ፋሮኛ',
    'fon'   => 'Fon',
    'fr'    => 'ፈረንሳይኛ',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'ፍሪስኛ',
    'ga'    => 'አይሪሽ',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "እስኮትስ\ ጌልክኛ",
    'gem'   => "Germanic\ Language",
    'gez'   => 'ግዕዝኛ',
    'gil'   => 'Gilbertese',
    'gl'    => 'ጋለጋኛ',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ጓራኒኛ',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'ጉጃርቲኛ',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'ሃውሳኛ',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'ዕብራስጥ',
    'hi'    => 'ሐንድኛ',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ክሮሽያንኛ',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ሀንጋሪኛ',
    'hup'   => 'Hupa',
    'hy'    => 'አርመናዊ',
    'hz'    => 'Herero',
    'ia'    => 'ኢንቴርሊንጓ',
    'iba'   => 'Iban',
    'id'    => 'እንዶኒሲኛ',
    'ie'    => 'እንተርሊንግወ',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'እኑፒያቅኛ',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'አይስላንድኛ',
    'it'    => 'ጣሊያንኛ',
    'iu'    => 'እኑክቲቱትኛ',
    'ja'    => 'ጃፓንኛ',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ጃቫንኛ',
    'ka'    => 'ጊዮርጊያን',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'ካዛክኛ',
    'kl'    => 'ካላሊሱትኛ',
    'km'    => 'ክመርኛ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ካናዳኛ',
    'ko'    => 'ኮሪያኛ',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'ካሽሚርኛ',
    'ku'    => 'ኩርድሽኛ',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'ኪርጊዝኛ',
    'la'    => 'ላቲንኛ',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'ሊንጋላኛ',
    'lo'    => 'ላውስኛ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ሊቱአኒያን',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'ላትቪያን',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'ማላጋስኛ',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'ማዮሪኛ',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ማከዶኒኛ',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'ማላያላምኛ',
    'mn'    => 'ሞንጎላዊኛ',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'ሞልዳቫዊና',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ማራዚኛ',
    'ms'    => 'ማላይኛ',
    'mt'    => 'ማልቲስኛ',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'ቡርማኛ',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'ናኡሩ',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'ኔፓሊኛ',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ደች',
    'nl_be' => 'Flemish',
    'nn'    => "የኖርዌ\ አዲሱ\ ኖርዌጅያንኛ",
    'no'    => 'ኖርዌጂያን',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ኦኪታንኛ',
    'oj'    => 'Ojibwa',
    'om'    => 'ኦሮምኛ',
    'or'    => 'ኦሪያኛ',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ፓንጃቢኛ',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'ፖሊሽ',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'ፑሽቶኛ',
    'pt'    => 'ፖርቱጋሊኛ',
    'pt_br' => "ፖርቱጋሊኛ\ \(የብራዚል\)",
    'pt_pt' => "ፖርቱጋሊኛ\ \(የፖርቱጋል\)",
    'qu'    => 'ኵቿኛ',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'ሮማንስ',
    'rn'    => 'ሩንዲኛ',
    'ro'    => 'ሮማኒያን',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'ራሽኛ',
    'rup'   => 'Aromanian',
    'rw'    => 'ኪንያርዋንድኛ',
    'sa'    => 'ሳንስክሪትኛ',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'ሲንድሂኛ',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'ሳንጎኛ',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "ሰርቦ\-ክሮኤሽያኛ",
    'shn'   => 'Shan',
    'si'    => 'ስንሃልኛ',
    'sid'   => 'ሲዳምኛ',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ስሎቫክኛ',
    'sl'    => 'ስሎቪኛ',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ሳሞአኛ',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'ሾናኛ',
    'snk'   => 'Soninke',
    'so'    => 'ሱማልኛ',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ልቤኒኛ',
    'sr'    => 'ሰርቢኛ',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'ስዋቲኛ',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'ሶዞኛ',
    'su'    => 'ሱዳንኛ',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ስዊድንኛ',
    'sw'    => 'ስዋሂሊኛ',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'ታሚልኛ',
    'tai'   => "Tai\ Language",
    'te'    => 'ተሉጉኛ',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'ታጂኪኛ',
    'th'    => 'ታይኛ',
    'ti'    => 'ትግርኛ',
    'tig'   => 'ትግረ',
    'tiv'   => 'Tiv',
    'tk'    => 'ቱርክመንኛ',
    'tkl'   => 'Tokelau',
    'tl'    => 'ታጋሎገኛ',
    'tlh'   => 'ክሊንግኦንኛ',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'ጽዋናዊኛ',
    'to'    => 'ቶንጋ',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'ቱርክኛ',
    'trv'   => 'Taroko',
    'ts'    => 'ጾንጋኛ',
    'tsi'   => 'Tsimshian',
    'tt'    => 'ታታርኛ',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'ትዊኛ',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ኡዊግሁርኛ',
    'uga'   => 'Ugaritic',
    'uk'    => 'ዩክረኒኛ',
    'umb'   => 'Umbundu',
    'und'   => 'ያልተወሰነ',
    'ur'    => 'ኡርዱኛ',
    'uz'    => 'ኡዝበክኛ',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ቪትናምኛ',
    'vo'    => 'ቮላፑክኛ',
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'ዎሎፍኛ',
    'xal'   => 'Kalmyk',
    'xh'    => 'ዞሳኛ',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'ይዲሻዊኛ',
    'yo'    => 'ዮሩባዊኛ',
    'ypk'   => "Yupik\ Language",
    'za'    => 'ዡዋንግኛ',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ቻይንኛ',
    'znd'   => 'Zande',
    'zu'    => 'ዙሉኛ',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::am::name_to_code = (
    'achinese'                                   => 'ace',
    'acoli'                                      => 'ach',
    'adangme'                                    => 'ada',
    'adyghe'                                     => 'ady',
    'afrihili'                                   => 'afh',
    'afroasiaticlanguage'                        => 'afa',
    'ainu'                                       => 'ain',
    'akan'                                       => 'ak',
    'akkadian'                                   => 'akk',
    'aleut'                                      => 'ale',
    'algonquianlanguage'                         => 'alg',
    'altaiclanguage'                             => 'tut',
    'ancientegyptian'                            => 'egy',
    'ancientgreek'                               => 'grc',
    'angika'                                     => 'anp',
    'apachelanguage'                             => 'apa',
    'aragonese'                                  => 'an',
    'aramaic'                                    => 'arc',
    'arapaho'                                    => 'arp',
    'araucanian'                                 => 'arn',
    'arawak'                                     => 'arw',
    'aromanian'                                  => 'rup',
    'artificiallanguage'                         => 'art',
    'asturian'                                   => 'ast',
    'athapascanlanguage'                         => 'ath',
    'atsam'                                      => 'cch',
    'australianenglish'                          => 'en_au',
    'australianlanguage'                         => 'aus',
    'austriangerman'                             => 'de_at',
    'austronesianlanguage'                       => 'map',
    'avaric'                                     => 'av',
    'avestan'                                    => 'ae',
    'awadhi'                                     => 'awa',
    'balinese'                                   => 'ban',
    'balticlanguage'                             => 'bat',
    'baluchi'                                    => 'bal',
    'bambara'                                    => 'bm',
    'bamilekelanguage'                           => 'bai',
    'banda'                                      => 'bad',
    'bantu'                                      => 'bnt',
    'basa'                                       => 'bas',
    'batak'                                      => 'btk',
    'beja'                                       => 'bej',
    'bemba'                                      => 'bem',
    'berber'                                     => 'ber',
    'bhojpuri'                                   => 'bho',
    'bikol'                                      => 'bik',
    'bini'                                       => 'bin',
    'blissymbols'                                => 'zbl',
    'braj'                                       => 'bra',
    'britishenglish'                             => 'en_gb',
    'buginese'                                   => 'bug',
    'buriat'                                     => 'bua',
    'caddo'                                      => 'cad',
    'canadianenglish'                            => 'en_ca',
    'canadianfrench'                             => 'fr_ca',
    'carib'                                      => 'car',
    'caucasianlanguage'                          => 'cau',
    'cebuano'                                    => 'ceb',
    'celticlanguage'                             => 'cel',
    'centralamericanindianlanguage'              => 'cai',
    'chagatai'                                   => 'chg',
    'chamiclanguage'                             => 'cmc',
    'chamorro'                                   => 'ch',
    'chechen'                                    => 'ce',
    'cherokee'                                   => 'chr',
    'cheyenne'                                   => 'chy',
    'chibcha'                                    => 'chb',
    'chinookjargon'                              => 'chn',
    'chipewyan'                                  => 'chp',
    'choctaw'                                    => 'cho',
    'churchslavic'                               => 'cu',
    'chuukese'                                   => 'chk',
    'chuvash'                                    => 'cv',
    'classicalnewari'                            => 'nwc',
    'classicalsyriac'                            => 'syc',
    'coptic'                                     => 'cop',
    'cornish'                                    => 'kw',
    'cree'                                       => 'cr',
    'creek'                                      => 'mus',
    'creoleorpidgin'                             => 'crp',
    'crimeanturkish'                             => 'crh',
    'cushiticlanguage'                           => 'cus',
    'dakota'                                     => 'dak',
    'dargwa'                                     => 'dar',
    'dayak'                                      => 'day',
    'delaware'                                   => 'del',
    'dinka'                                      => 'din',
    'divehi'                                     => 'dv',
    'dogri'                                      => 'doi',
    'dogrib'                                     => 'dgr',
    'dravidianlanguage'                          => 'dra',
    'duala'                                      => 'dua',
    'dyula'                                      => 'dyu',
    'easternfrisian'                             => 'frs',
    'efik'                                       => 'efi',
    'ekajuk'                                     => 'eka',
    'elamite'                                    => 'elx',
    'englishbasedcreoleorpidgin'                 => 'cpe',
    'erzya'                                      => 'myv',
    'ewe'                                        => 'ee',
    'ewondo'                                     => 'ewo',
    'fang'                                       => 'fan',
    'fanti'                                      => 'fat',
    'finnougrianlanguage'                        => 'fiu',
    'flemish'                                    => 'nl_be',
    'fon'                                        => 'fon',
    'frenchbasedcreoleorpidgin'                  => 'cpf',
    'friulian'                                   => 'fur',
    'fulah'                                      => 'ff',
    'ga'                                         => 'gaa',
    'ganda'                                      => 'lg',
    'gayo'                                       => 'gay',
    'gbaya'                                      => 'gba',
    'germaniclanguage'                           => 'gem',
    'gilbertese'                                 => 'gil',
    'gondi'                                      => 'gon',
    'gorontalo'                                  => 'gor',
    'gothic'                                     => 'got',
    'grebo'                                      => 'grb',
    "gwich\Ê\¼in"                              => 'gwi',
    'haida'                                      => 'hai',
    'haitian'                                    => 'ht',
    'hawaiian'                                   => 'haw',
    'herero'                                     => 'hz',
    'hiligaynon'                                 => 'hil',
    'himachali'                                  => 'him',
    'hirimotu'                                   => 'ho',
    'hittite'                                    => 'hit',
    'hmong'                                      => 'hmn',
    'hupa'                                       => 'hup',
    'iban'                                       => 'iba',
    'iberianspanish'                             => 'es_es',
    'ido'                                        => 'io',
    'igbo'                                       => 'ig',
    'ijo'                                        => 'ijo',
    'iloko'                                      => 'ilo',
    'inarisami'                                  => 'smn',
    'indiclanguage'                              => 'inc',
    'indoeuropeanlanguage'                       => 'ine',
    'ingush'                                     => 'inh',
    'iranianlanguage'                            => 'ira',
    'iroquoianlanguage'                          => 'iro',
    'jju'                                        => 'kaj',
    'judeoarabic'                                => 'jrb',
    'judeopersian'                               => 'jpr',
    'kabardian'                                  => 'kbd',
    'kabyle'                                     => 'kab',
    'kachin'                                     => 'kac',
    'kalmyk'                                     => 'xal',
    'kamba'                                      => 'kam',
    'kanuri'                                     => 'kr',
    'karachaybalkar'                             => 'krc',
    'karakalpak'                                 => 'kaa',
    'karelian'                                   => 'krl',
    'karen'                                      => 'kar',
    'kashubian'                                  => 'csb',
    'kawi'                                       => 'kaw',
    'khasi'                                      => 'kha',
    'khoisanlanguage'                            => 'khi',
    'khotanese'                                  => 'kho',
    'kikuyu'                                     => 'ki',
    'kimbundu'                                   => 'kmb',
    'komi'                                       => 'kv',
    'kongo'                                      => 'kg',
    'konkani'                                    => 'kok',
    'koro'                                       => 'kfo',
    'kosraean'                                   => 'kos',
    'kpelle'                                     => 'kpe',
    'kru'                                        => 'kro',
    'kuanyama'                                   => 'kj',
    'kumyk'                                      => 'kum',
    'kurukh'                                     => 'kru',
    'kutenai'                                    => 'kut',
    'ladino'                                     => 'lad',
    'lahnda'                                     => 'lah',
    'lamba'                                      => 'lam',
    'lezghian'                                   => 'lez',
    'limburgish'                                 => 'li',
    'lojban'                                     => 'jbo',
    'lowersorbian'                               => 'dsb',
    'lowgerman'                                  => 'nds',
    'lozi'                                       => 'loz',
    'lubakatanga'                                => 'lu',
    'lubalulua'                                  => 'lua',
    'luiseno'                                    => 'lui',
    'lulesami'                                   => 'smj',
    'lunda'                                      => 'lun',
    'luo'                                        => 'luo',
    'lushai'                                     => 'lus',
    'luxembourgish'                              => 'lb',
    'madurese'                                   => 'mad',
    'magahi'                                     => 'mag',
    'maithili'                                   => 'mai',
    'makasar'                                    => 'mak',
    'manchu'                                     => 'mnc',
    'mandar'                                     => 'mdr',
    'mandingo'                                   => 'man',
    'manipuri'                                   => 'mni',
    'manobolanguage'                             => 'mno',
    'manx'                                       => 'gv',
    'mari'                                       => 'chm',
    'marshallese'                                => 'mh',
    'marwari'                                    => 'mwr',
    'masai'                                      => 'mas',
    'mayanlanguage'                              => 'myn',
    'mende'                                      => 'men',
    'micmac'                                     => 'mic',
    'middledutch'                                => 'dum',
    'middleenglish'                              => 'enm',
    'middlefrench'                               => 'frm',
    'middlehighgerman'                           => 'gmh',
    'middleirish'                                => 'mga',
    'minangkabau'                                => 'min',
    'mirandese'                                  => 'mwl',
    'miscellaneouslanguage'                      => 'mis',
    'mohawk'                                     => 'moh',
    'moksha'                                     => 'mdf',
    'mongo'                                      => 'lol',
    'monkhmerlanguage'                           => 'mkh',
    'morisyen'                                   => 'mfe',
    'mossi'                                      => 'mos',
    'multiplelanguages'                          => 'mul',
    'mundalanguage'                              => 'mun',
    'nahuatl'                                    => 'nah',
    'navajo'                                     => 'nv',
    'ndonga'                                     => 'ng',
    'neapolitan'                                 => 'nap',
    'newari'                                     => 'new',
    'nias'                                       => 'nia',
    'nigerkordofanianlanguage'                   => 'nic',
    'nilosaharanlanguage'                        => 'ssa',
    'niuean'                                     => 'niu',
    'nogai'                                      => 'nog',
    'nolinguisticcontent'                        => 'zxx',
    'northamericanindianlanguage'                => 'nai',
    'northernfrisian'                            => 'frr',
    'northernsami'                               => 'se',
    'northernsotho'                              => 'nso',
    'northndebele'                               => 'nd',
    "norwegianbokm\Ã\¥l"                       => 'nb',
    'nubianlanguage'                             => 'nub',
    'nyamwezi'                                   => 'nym',
    'nyanja'                                     => 'ny',
    'nyankole'                                   => 'nyn',
    'nyasatonga'                                 => 'tog',
    'nyoro'                                      => 'nyo',
    'nzima'                                      => 'nzi',
    "n\â\\ko"                               => 'nqo',
    'ojibwa'                                     => 'oj',
    'oldenglish'                                 => 'ang',
    'oldfrench'                                  => 'fro',
    'oldhighgerman'                              => 'goh',
    'oldirish'                                   => 'sga',
    'oldnorse'                                   => 'non',
    'oldpersian'                                 => 'peo',
    "oldproven\Ã\§al"                          => 'pro',
    'osage'                                      => 'osa',
    'ossetic'                                    => 'os',
    'otomianlanguage'                            => 'oto',
    'ottomanturkish'                             => 'ota',
    'pahlavi'                                    => 'pal',
    'palauan'                                    => 'pau',
    'pali'                                       => 'pi',
    'pampanga'                                   => 'pam',
    'pangasinan'                                 => 'pag',
    'papiamento'                                 => 'pap',
    'papuanlanguage'                             => 'paa',
    'philippinelanguage'                         => 'phi',
    'phoenician'                                 => 'phn',
    'pohnpeian'                                  => 'pon',
    'portuguesebasedcreoleorpidgin'              => 'cpp',
    'prakritlanguage'                            => 'pra',
    'rajasthani'                                 => 'raj',
    'rapanui'                                    => 'rap',
    'rarotongan'                                 => 'rar',
    'romancelanguage'                            => 'roa',
    'romany'                                     => 'rom',
    'salishanlanguage'                           => 'sal',
    'samaritanaramaic'                           => 'sam',
    'samilanguage'                               => 'smi',
    'sandawe'                                    => 'sad',
    'santali'                                    => 'sat',
    'sardinian'                                  => 'sc',
    'sasak'                                      => 'sas',
    'scots'                                      => 'sco',
    'selkup'                                     => 'sel',
    'semiticlanguage'                            => 'sem',
    'serer'                                      => 'srr',
    'shan'                                       => 'shn',
    'sichuanyi'                                  => 'ii',
    'sicilian'                                   => 'scn',
    'signlanguage'                               => 'sgn',
    'siksika'                                    => 'bla',
    'sinotibetanlanguage'                        => 'sit',
    'siouanlanguage'                             => 'sio',
    'skoltsami'                                  => 'sms',
    'slave'                                      => 'den',
    'slaviclanguage'                             => 'sla',
    'sogdien'                                    => 'sog',
    'songhai'                                    => 'son',
    'soninke'                                    => 'snk',
    'sorbianlanguage'                            => 'wen',
    'southamericanindianlanguage'                => 'sai',
    'southernaltai'                              => 'alt',
    'southernsami'                               => 'sma',
    'southndebele'                               => 'nr',
    'sranantongo'                                => 'srn',
    'sukuma'                                     => 'suk',
    'sumerian'                                   => 'sux',
    'susu'                                       => 'sus',
    'swissfrench'                                => 'fr_ch',
    'swissgerman'                                => 'gsw',
    'swisshighgerman'                            => 'de_ch',
    'syriac'                                     => 'syr',
    'tahitian'                                   => 'ty',
    'tailanguage'                                => 'tai',
    'tamashek'                                   => 'tmh',
    'taroko'                                     => 'trv',
    'tereno'                                     => 'ter',
    'tetum'                                      => 'tet',
    'timne'                                      => 'tem',
    'tiv'                                        => 'tiv',
    'tlingit'                                    => 'tli',
    'tokelau'                                    => 'tkl',
    'tokpisin'                                   => 'tpi',
    'tsimshian'                                  => 'tsi',
    'tumbuka'                                    => 'tum',
    'tupilanguage'                               => 'tup',
    'tuvalu'                                     => 'tvl',
    'tuvinian'                                   => 'tyv',
    'tyap'                                       => 'kcg',
    "u\.s\.english"                              => 'en_us',
    'udmurt'                                     => 'udm',
    'ugaritic'                                   => 'uga',
    'umbundu'                                    => 'umb',
    'uppersorbian'                               => 'hsb',
    'vai'                                        => 'vai',
    'venda'                                      => 've',
    'votic'                                      => 'vot',
    'wakashanlanguage'                           => 'wak',
    'walamo'                                     => 'wal',
    'walloon'                                    => 'wa',
    'waray'                                      => 'war',
    'washo'                                      => 'was',
    'yakut'                                      => 'sah',
    'yao'                                        => 'yao',
    'yapese'                                     => 'yap',
    'yupiklanguage'                              => 'ypk',
    'zande'                                      => 'znd',
    'zapotec'                                    => 'zap',
    'zaza'                                       => 'zza',
    'zenaga'                                     => 'zen',
    'zuni'                                       => 'zun',
    'ሀንጋሪኛ'                            => 'hu',
    'ሃውሳኛ'                               => 'ha',
    'ሊቱአኒያን'                         => 'lt',
    'ሊንጋላኛ'                            => 'ln',
    'ላቲንኛ'                               => 'la',
    'ላትቪያን'                            => 'lv',
    'ላውስኛ'                               => 'lo',
    'ልቤኒኛ'                               => 'sq',
    'ሐንድኛ'                               => 'hi',
    'ማላያላምኛ'                         => 'ml',
    'ማላይኛ'                               => 'ms',
    'ማላጋስኛ'                            => 'mg',
    'ማልቲስኛ'                            => 'mt',
    'ማራዚኛ'                               => 'mr',
    'ማከዶኒኛ'                            => 'mk',
    'ማዮሪኛ'                               => 'mi',
    'ሞልዳቫዊና'                         => 'mo',
    'ሞንጎላዊኛ'                         => 'mn',
    'ሩንዲኛ'                               => 'rn',
    'ራሽኛ'                                  => 'ru',
    'ሮማኒያን'                            => 'ro',
    'ሮማንስ'                               => 'rm',
    'ሰርቢኛ'                               => 'sr',
    'ሰርቦክሮኤሽያኛ'                => 'sh',
    'ሱማልኛ'                               => 'so',
    'ሱዳንኛ'                               => 'su',
    'ሲንድሂኛ'                            => 'sd',
    'ሲዳምኛ'                               => 'sid',
    'ሳሞአኛ'                               => 'sm',
    'ሳንስክሪትኛ'                      => 'sa',
    'ሳንጎኛ'                               => 'sg',
    'ስሎቪኛ'                               => 'sl',
    'ስሎቫክኛ'                            => 'sk',
    'ስንሃልኛ'                            => 'si',
    'ስዊድንኛ'                            => 'sv',
    'ስዋሂሊኛ'                            => 'sw',
    'ስዋቲኛ'                               => 'ss',
    'ስፓኒሽ'                               => 'es',
    'ሶዞኛ'                                  => 'st',
    'ሾናኛ'                                  => 'sn',
    'በንጋሊኛ'                            => 'bn',
    'ቡልጋሪኛ'                            => 'bg',
    'ቡርማኛ'                               => 'my',
    'ቢሃሪ'                                  => 'bh',
    'ቢስላምኛ'                            => 'bi',
    'ባስኪርኛ'                            => 'ba',
    'ባስክኛ'                               => 'eu',
    'ቤላራሻኛ'                            => 'be',
    'ብሊን'                                  => 'byn',
    'ብሬቶንኛ'                            => 'br',
    'ቦስኒያንኛ'                         => 'bs',
    'ቪትናምኛ'                            => 'vi',
    'ቮላፑክኛ'                            => 'vo',
    'ተሉጉኛ'                               => 'te',
    'ቱርክመንኛ'                         => 'tk',
    'ቱርክኛ'                               => 'tr',
    'ታሚልኛ'                               => 'ta',
    'ታታርኛ'                               => 'tt',
    'ታይኛ'                                  => 'th',
    'ታጂኪኛ'                               => 'tg',
    'ታጋሎገኛ'                            => 'tl',
    'ትበትንኛ'                            => 'bo',
    'ትዊኛ'                                  => 'tw',
    'ትግረ'                                  => 'tig',
    'ትግርኛ'                               => 'ti',
    'ቶንጋ'                                  => 'to',
    'ቻይንኛ'                               => 'zh',
    'ቼክኛ'                                  => 'cs',
    'ናኡሩ'                                  => 'na',
    'ኔፓሊኛ'                               => 'ne',
    'ኖርዌጂያን'                         => 'no',
    'አማርኛ'                               => 'am',
    'አርመናዊ'                            => 'hy',
    'አሳሜዛዊ'                            => 'as',
    'አብሐዚኛ'                            => 'ab',
    'አዜርባይጃንኛ'                   => 'az',
    'አያማርኛ'                            => 'ay',
    'አይሪሽ'                               => 'ga',
    'አይስላንድኛ'                      => 'is',
    'አፋርኛ'                               => 'aa',
    'አፍሪካንስኛ'                      => 'af',
    'ኡርዱኛ'                               => 'ur',
    'ኡዊግሁርኛ'                         => 'ug',
    'ኡዝበክኛ'                            => 'uz',
    'ኢንቴርሊንጓ'                      => 'ia',
    'ኤስቶኒአን'                         => 'et',
    'ኤስፐራንቶ'                         => 'eo',
    'እስኮትስጌልክኛ'                => 'gd',
    'እኑክቲቱትኛ'                      => 'iu',
    'እኑፒያቅኛ'                         => 'ik',
    'እንተርሊንግወ'                   => 'ie',
    'እንዶኒሲኛ'                         => 'id',
    'እንግሊዝኛ'                         => 'en',
    'ኦሪያኛ'                               => 'or',
    'ኦሮምኛ'                               => 'om',
    'ኦኪታንኛ'                            => 'oc',
    'ኩርድሽኛ'                            => 'ku',
    'ኪርጊዝኛ'                            => 'ky',
    'ኪንያርዋንድኛ'                   => 'rw',
    'ካላሊሱትኛ'                         => 'kl',
    'ካሽሚርኛ'                            => 'ks',
    'ካታላንኛ'                            => 'ca',
    'ካናዳኛ'                               => 'kn',
    'ካዛክኛ'                               => 'kk',
    'ክሊንግኦንኛ'                      => 'tlh',
    'ክመርኛ'                               => 'km',
    'ክሮሽያንኛ'                         => 'hr',
    'ኮሪያኛ'                               => 'ko',
    'ኮርሲካኛ'                            => 'co',
    'ኵቿኛ'                                  => 'qu',
    'ወልሽ'                                  => 'cy',
    'ዎሎፍኛ'                               => 'wo',
    'ዐርቢኛ'                               => 'ar',
    'ዕብራስጥ'                            => 'he',
    'ዙሉኛ'                                  => 'zu',
    'ዞሳኛ'                                  => 'xh',
    'ዡዋንግኛ'                            => 'za',
    'የኖርዌአዲሱኖርዌጅያንኛ' => 'nn',
    'ዩክረኒኛ'                            => 'uk',
    'ያልተወሰነ'                         => 'und',
    'ይዲሻዊኛ'                            => 'yi',
    'ዮሩባዊኛ'                            => 'yo',
    'ደች'                                     => 'nl',
    'ዴኒሽ'                                  => 'da',
    'ድዞንግኻኛ'                         => 'dz',
    'ጀርመን'                               => 'de',
    'ጃቫንኛ'                               => 'jv',
    'ጃፓንኛ'                               => 'ja',
    'ጉጃርቲኛ'                            => 'gu',
    'ጊዮርጊያን'                         => 'ka',
    'ጋለጋኛ'                               => 'gl',
    'ግሪክኛ'                               => 'el',
    'ግዕዝኛ'                               => 'gez',
    'ጓራኒኛ'                               => 'gn',
    'ጣሊያንኛ'                            => 'it',
    'ጽዋናዊኛ'                            => 'tn',
    'ጾንጋኛ'                               => 'ts',
    'ፈረንሳይኛ'                         => 'fr',
    'ፊሊፕንኛ'                            => 'fil',
    'ፊኒሽ'                                  => 'fi',
    'ፊጂኛ'                                  => 'fj',
    'ፋሮኛ'                                  => 'fo',
    'ፍሪስኛ'                               => 'fy',
    'ፐርሲያኛ'                            => 'fa',
    'ፑሽቶኛ'                               => 'ps',
    'ፓንጃቢኛ'                            => 'pa',
    'ፖሊሽ'                                  => 'pl',
    'ፖርቱጋሊኛ'                         => 'pt',
    'ፖርቱጋሊኛየብራዚል'          => 'pt_br',
    'ፖርቱጋሊኛየፖርቱጋል'       => 'pt_pt',
);

1;
