package Locales::DB::Language::ca;

# Auto generated from CLDR

$Locales::DB::Language::ca::VERSION = '0.02';

$Locales::DB::Language::ca::cldr_version = '1.7.1';

%Locales::DB::Language::ca::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Idioma\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regió\:\ \{0\}"
    },
    'fallback'    => [ 'es_ES' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sí\:s"
    },
);

%Locales::DB::Language::ca::code_to_name = (
    'aa'    => 'àfar',
    'ab'    => 'abkhaz',
    'ace'   => 'atjeh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigué',
    'ae'    => 'avèstic',
    'af'    => 'afrikaans',
    'afa'   => "llengua\ afroasiàtica",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'àkan',
    'akk'   => 'accadi',
    'ale'   => 'aleuta',
    'alg'   => "llengua\ algonquina",
    'alt'   => "altaic\ meridional",
    'am'    => 'amhàric',
    'an'    => 'aragonès',
    'ang'   => "anglès\ antic",
    'anp'   => 'angika',
    'apa'   => "llengua\ apatxe",
    'ar'    => 'àrab',
    'arc'   => 'arameu',
    'arn'   => 'araucà',
    'arp'   => 'arapaho',
    'art'   => "llengua\ artificial",
    'arw'   => 'arauac',
    'as'    => 'assamès',
    'ast'   => 'asturià',
    'ath'   => "llengua\ atapascana",
    'aus'   => "llengua\ australiana",
    'av'    => 'àvar',
    'awa'   => 'awadhi',
    'ay'    => 'aimara',
    'az'    => 'àzeri',
    'ba'    => 'baixkir',
    'bad'   => 'banda',
    'bai'   => 'bamileké',
    'bal'   => 'balutxi',
    'ban'   => 'balinès',
    'bas'   => 'basa',
    'bat'   => "llengua\ bàltica",
    'be'    => 'bielorús',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bg'    => 'búlgar',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'blackfoot',
    'bm'    => 'bambara',
    'bn'    => 'bengalí',
    'bnt'   => 'bantu',
    'bo'    => 'tibetà',
    'br'    => 'bretó',
    'bra'   => 'braj',
    'bs'    => 'bosnià',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugui',
    'byn'   => 'bilin',
    'ca'    => 'català',
    'cad'   => 'caddo',
    'cai'   => "llengua\ ameríndia\ d\'Amèrica\ Central",
    'car'   => 'carib',
    'cau'   => "llengua\ caucàsica",
    'cch'   => 'atsam',
    'ce'    => 'txetxè',
    'ceb'   => 'cebuano',
    'cel'   => "llengua\ cèltica",
    'ch'    => 'chamorro',
    'chb'   => 'txibtxa',
    'chg'   => 'txagatai',
    'chk'   => 'chuuk',
    'chm'   => 'mari',
    'chn'   => "pidgin\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'xeienne',
    'cmc'   => 'txam',
    'co'    => 'cors',
    'cop'   => 'copte',
    'cpe'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ l\'anglès",
    'cpf'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ francès",
    'cpp'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ portuguès",
    'cr'    => 'cree',
    'crh'   => "tàtar\ de\ Crimea",
    'crp'   => "llengua\ criolla\ o\ pidgin",
    'cs'    => 'txec',
    'csb'   => 'caixubi',
    'cu'    => "eslau\ eclesiàstic",
    'cus'   => "llengua\ cuixítica",
    'cv'    => 'txuvaix',
    'cy'    => 'gal·lès',
    'da'    => 'danès',
    'dak'   => 'dakota',
    'dar'   => 'darguà',
    'day'   => 'daiak',
    'de'    => 'alemany',
    'de_at' => "alemany\ austríac",
    'de_ch' => "alt\ alemany\ suís",
    'del'   => 'delaware',
    'den'   => 'slavey',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "llengua\ dravídica",
    'dsb'   => "baix\ sòrab",
    'dua'   => 'duala',
    'dum'   => "neerlandès\ mitjà",
    'dv'    => 'divehi',
    'dyu'   => 'jula',
    'dz'    => 'dzongka',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipci\ antic",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'elamita',
    'en'    => 'anglès',
    'en_au' => "anglès\ australià",
    'en_ca' => "anglès\ canadenc",
    'en_gb' => "anglès\ britànic",
    'en_us' => "anglès\ americà",
    'enm'   => "anglès\ mitjà",
    'eo'    => 'esperanto',
    'es'    => 'espanyol',
    'es_es' => "espanyol\ d\'Espanya",
    'et'    => 'estonià',
    'eu'    => 'basc',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'ful',
    'fi'    => 'finès',
    'fil'   => 'filipí',
    'fiu'   => "llengua\ finoúgrica",
    'fj'    => 'fijià',
    'fo'    => 'feroès',
    'fon'   => 'fon',
    'fr'    => 'francès',
    'fr_ca' => "francès\ canadenc",
    'fr_ch' => "francès\ suís",
    'frm'   => "francès\ mitjà",
    'fro'   => "francès\ antic",
    'frr'   => "frisó\ septentrional",
    'frs'   => "frisó\ occidental",
    'fur'   => 'friülà',
    'fy'    => "frisó\ oriental",
    'ga'    => 'irlandès',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaèlic\ escocès",
    'gem'   => "llengua\ germànica",
    'gez'   => 'gueez',
    'gil'   => 'gilbertès',
    'gl'    => 'gallec',
    'gmh'   => "alt\ alemany\ mitjà",
    'gn'    => 'guaraní',
    'goh'   => "alt\ alemany\ antic",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gòtic',
    'grb'   => 'grebo',
    'grc'   => "grec\ antic",
    'gsw'   => "alemany\ suís",
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaià',
    'he'    => 'hebreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligainon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croat',
    'hsb'   => "alt\ sòrab",
    'ht'    => 'haitià',
    'hu'    => 'hongarès',
    'hup'   => 'hupa',
    'hy'    => 'armeni',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesi',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocà',
    'inc'   => "llengua\ índica",
    'ine'   => "llengua\ indoeuropea",
    'inh'   => 'ingúix',
    'io'    => 'ido',
    'ira'   => "llengua\ irànica",
    'iro'   => 'iroquès',
    'is'    => 'islandès',
    'it'    => 'italià',
    'iu'    => 'inuktitut',
    'ja'    => 'japonès',
    'jbo'   => 'lojban',
    'jpr'   => 'judeopersa',
    'jrb'   => 'judeoàrab',
    'jv'    => 'javanès',
    'ka'    => 'georgià',
    'kaa'   => 'karakalpak',
    'kab'   => 'cabilenc',
    'kac'   => 'katxin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardí',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "llengua\ khoisan",
    'kho'   => 'khotanès',
    'ki'    => 'kikuiu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'grenlandès',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'coreà',
    'kok'   => 'konkani',
    'kos'   => 'kosraeà',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => 'karatxai',
    'krl'   => 'carelià',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'caixmiri',
    'ku'    => 'kurd',
    'kum'   => 'kúmik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'còrnic',
    'ky'    => 'kirguís',
    'la'    => 'llatí',
    'lad'   => 'ladí',
    'lah'   => "panjabi\ occidental",
    'lam'   => 'lamba',
    'lb'    => 'luxemburguès',
    'lez'   => 'lesguià',
    'lg'    => 'ganda',
    'li'    => 'limburguès',
    'ln'    => 'lingala',
    'lo'    => 'laosià',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituà',
    'lu'    => "luba\ katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luisenyo',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'mizo',
    'lv'    => 'letó',
    'mad'   => 'madurès',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandinga',
    'map'   => "llengua\ austronèsia",
    'mas'   => 'massai',
    'mdf'   => "mordovià\ moksa",
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaix',
    'mga'   => "gaèlic\ irlandès\ mitjà",
    'mh'    => 'marshallès',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "llengua\ miscel·lània",
    'mk'    => 'macedoni',
    'mkh'   => "llengua\ monkhmer",
    'ml'    => 'malaialam',
    'mn'    => 'mongol',
    'mnc'   => 'manxú',
    'mni'   => 'manipurí',
    'mno'   => "llengua\ manobo",
    'mo'    => 'moldau',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathi',
    'ms'    => 'malai',
    'mt'    => 'maltès',
    'mul'   => "llengües\ vàries",
    'mun'   => "llengua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandès',
    'mwr'   => 'marwari',
    'my'    => 'birmà',
    'myn'   => "llengua\ maia",
    'myv'   => "mordovià\ erza",
    'na'    => 'nauruà',
    'nah'   => 'nàhuatl',
    'nai'   => "llengua\ ameríndia\ septentrional",
    'nap'   => 'napolità',
    'nb'    => "noruec\ bokmål",
    'nd'    => "ndebele\ septentrional",
    'nds'   => "baix\ alemany",
    'ne'    => 'nepalès',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "llengua\ nigerokurdufaniana",
    'niu'   => 'niueà',
    'nl'    => 'neerlandès',
    'nl_be' => 'flamenc',
    'nn'    => "noruec\ nynorsk",
    'no'    => 'noruec',
    'nog'   => 'nogai',
    'non'   => "nòrdic\ antic",
    'nqo'   => 'n’Ko',
    'nr'    => "ndebele\ meridional",
    'nso'   => "sotho\ septentrional",
    'nub'   => "llengua\ nubiana",
    'nv'    => 'navaho',
    'nwc'   => "newari\ clàssic",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwesi',
    'nyn'   => 'nyankore',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occità',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'osset',
    'osa'   => 'osage',
    'ota'   => "turc\ otomà",
    'oto'   => "llengua\ otomangueana",
    'pa'    => 'panjabi',
    'paa'   => "llengua\ papú",
    'pag'   => 'pangasi',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangà',
    'pap'   => 'papiamento',
    'pau'   => 'palauà',
    'peo'   => "persa\ antic",
    'phi'   => "llengua\ filipina",
    'phn'   => 'fenici',
    'pi'    => 'pali',
    'pl'    => 'polonès',
    'pon'   => 'ponapeà',
    'pra'   => 'pràcrit',
    'pro'   => "provençal\ antic",
    'ps'    => 'paixto',
    'pt'    => 'portuguès',
    'pt_br' => "portuguès\ de\ Brasil",
    'pt_pt' => "portuguès\ de\ Portugal",
    'qu'    => 'quètxua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongà',
    'rm'    => 'retoromànic',
    'rn'    => 'rundi',
    'ro'    => 'romanès',
    'roa'   => "llengua\ romànica",
    'rom'   => 'romaní',
    'ru'    => 'rus',
    'rup'   => 'aromanès',
    'rw'    => 'ruandès',
    'sa'    => 'sànscrit',
    'sad'   => 'sandawe',
    'sah'   => 'iacut',
    'sai'   => "llengua\ ameríndia\ meridional",
    'sal'   => "llengua\ salish",
    'sam'   => "arameu\ samarità",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sard',
    'scn'   => 'sicilià',
    'sco'   => 'escocès',
    'sd'    => 'sindhi',
    'se'    => "sami\ septentrional",
    'sel'   => 'selkup',
    'sem'   => "llengua\ semítica",
    'sg'    => 'sango',
    'sga'   => "irlandès\ antic",
    'sgn'   => "llengua\ de\ signes",
    'sh'    => 'serbocroat',
    'shn'   => 'xan',
    'si'    => 'singalès',
    'sid'   => 'sidamo',
    'sio'   => "llengua\ sioux",
    'sit'   => "llengua\ sinotibetana",
    'sk'    => 'eslovac',
    'sl'    => 'eslovè',
    'sla'   => "llengua\ eslava",
    'sm'    => 'samoà',
    'sma'   => "sami\ meridional",
    'smi'   => "llengua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ d\'Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somali',
    'sog'   => 'sogdià',
    'son'   => 'songhai',
    'sq'    => 'albanès',
    'sr'    => 'serbi',
    'srn'   => 'sranan',
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "llengua\ nilosahariana",
    'st'    => "sotho\ meridional",
    'su'    => 'sundanès',
    'suk'   => 'sukuma',
    'sus'   => 'susú',
    'sux'   => 'sumeri',
    'sv'    => 'suec',
    'sw'    => 'suahili',
    'syc'   => "siríac\ clàssic",
    'syr'   => 'siríac',
    'ta'    => 'tàmil',
    'tai'   => "llengua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'terena',
    'tet'   => 'tetun',
    'tg'    => 'tadjik',
    'th'    => 'thai',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turcman',
    'tkl'   => 'tokelauès',
    'tl'    => 'tagàlog',
    'tlh'   => 'klingonià',
    'tli'   => 'tlingit',
    'tmh'   => 'tamazight',
    'tn'    => 'tswana',
    'to'    => 'tongalès',
    'tog'   => 'tonga',
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshià',
    'tt'    => 'tàtar',
    'tum'   => 'tumbuka',
    'tup'   => "llengua\ tupí",
    'tut'   => "llengua\ altaica",
    'tvl'   => 'tuvaluà',
    'tw'    => 'twi',
    'ty'    => 'tahitià',
    'tyv'   => 'tuvinià',
    'udm'   => 'udmurt',
    'ug'    => 'uigur',
    'uga'   => 'ugarític',
    'uk'    => 'ucraïnès',
    'umb'   => 'umbundu',
    'und'   => "idioma\ desconegut\ o\ no\ vàlid",
    'ur'    => 'urdú',
    'uz'    => 'uzbek',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'vòtic',
    'wa'    => 'való',
    'wak'   => "llengua\ wakash",
    'wal'   => 'ameto',
    'war'   => "waray\-waray",
    'was'   => 'washo',
    'wen'   => 'sòrab',
    'wo'    => 'wòlof',
    'xal'   => 'calmuc',
    'xh'    => 'xosa',
    'yao'   => 'yao',
    'yap'   => 'yapeà',
    'yi'    => 'jiddisch',
    'yo'    => 'ioruba',
    'ypk'   => "llengua\ iupik",
    'za'    => 'zhuang',
    'zap'   => 'zapoteca',
    'zbl'   => "símbols\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'xinès',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "sense\ contingut\ lingüístic",
    'zza'   => 'zaza',
);

%Locales::DB::Language::ca::name_to_code = (
    'abkhaz'                                    => 'ab',
    'accadi'                                    => 'akk',
    'acoli'                                     => 'ach',
    'adangme'                                   => 'ada',
    'adigué'                                   => 'ady',
    'afrihili'                                  => 'afh',
    'afrikaans'                                 => 'af',
    'aimara'                                    => 'ay',
    'ainu'                                      => 'ain',
    'albanès'                                  => 'sq',
    'alemany'                                   => 'de',
    'alemanyaustríac'                          => 'de_at',
    'alemanysuís'                              => 'gsw',
    'aleuta'                                    => 'ale',
    'altaicmeridional'                          => 'alt',
    'altalemanyantic'                           => 'goh',
    'altalemanymitjà'                          => 'gmh',
    'altalemanysuís'                           => 'de_ch',
    'altsòrab'                                 => 'hsb',
    'ameto'                                     => 'wal',
    'amhàric'                                  => 'am',
    'angika'                                    => 'anp',
    'anglès'                                   => 'en',
    'anglèsamericà'                           => 'en_us',
    'anglèsantic'                              => 'ang',
    'anglèsaustralià'                         => 'en_au',
    'anglèsbritànic'                          => 'en_gb',
    'anglèscanadenc'                           => 'en_ca',
    'anglèsmitjà'                             => 'enm',
    'aragonès'                                 => 'an',
    'arameu'                                    => 'arc',
    'arameusamarità'                           => 'sam',
    'arapaho'                                   => 'arp',
    'arauac'                                    => 'arw',
    'araucà'                                   => 'arn',
    'armeni'                                    => 'hy',
    'aromanès'                                 => 'rup',
    'assamès'                                  => 'as',
    'asturià'                                  => 'ast',
    'atjeh'                                     => 'ace',
    'atsam'                                     => 'cch',
    'avèstic'                                  => 'ae',
    'awadhi'                                    => 'awa',
    'baixalemany'                               => 'nds',
    'baixkir'                                   => 'ba',
    'baixsòrab'                                => 'dsb',
    'balinès'                                  => 'ban',
    'balutxi'                                   => 'bal',
    'bambara'                                   => 'bm',
    'bamileké'                                 => 'bai',
    'banda'                                     => 'bad',
    'bantu'                                     => 'bnt',
    'basa'                                      => 'bas',
    'basc'                                      => 'eu',
    'batak'                                     => 'btk',
    'beja'                                      => 'bej',
    'bemba'                                     => 'bem',
    'bengalí'                                  => 'bn',
    'berber'                                    => 'ber',
    'bhojpuri'                                  => 'bho',
    'bicol'                                     => 'bik',
    'bielorús'                                 => 'be',
    'bihari'                                    => 'bh',
    'bilin'                                     => 'byn',
    'bini'                                      => 'bin',
    'birmà'                                    => 'my',
    'bislama'                                   => 'bi',
    'blackfoot'                                 => 'bla',
    'bosnià'                                   => 'bs',
    'braj'                                      => 'bra',
    'bretó'                                    => 'br',
    'bugui'                                     => 'bug',
    'buriat'                                    => 'bua',
    'búlgar'                                   => 'bg',
    'cabilenc'                                  => 'kab',
    'caddo'                                     => 'cad',
    'caixmiri'                                  => 'ks',
    'caixubi'                                   => 'csb',
    'calmuc'                                    => 'xal',
    'carelià'                                  => 'krl',
    'carib'                                     => 'car',
    'català'                                   => 'ca',
    'cebuano'                                   => 'ceb',
    'chamorro'                                  => 'ch',
    'cherokee'                                  => 'chr',
    'chipewyan'                                 => 'chp',
    'choctaw'                                   => 'cho',
    'chuuk'                                     => 'chk',
    'copte'                                     => 'cop',
    'coreà'                                    => 'ko',
    'cors'                                      => 'co',
    'cree'                                      => 'cr',
    'creek'                                     => 'mus',
    'croat'                                     => 'hr',
    'còrnic'                                   => 'kw',
    'daiak'                                     => 'day',
    'dakota'                                    => 'dak',
    'danès'                                    => 'da',
    'darguà'                                   => 'dar',
    'delaware'                                  => 'del',
    'dinka'                                     => 'din',
    'divehi'                                    => 'dv',
    'dogri'                                     => 'doi',
    'dogrib'                                    => 'dgr',
    'duala'                                     => 'dua',
    'dzongka'                                   => 'dz',
    'efik'                                      => 'efi',
    'egipciantic'                               => 'egy',
    'ekajuk'                                    => 'eka',
    'elamita'                                   => 'elx',
    'escocès'                                  => 'sco',
    'eslaueclesiàstic'                         => 'cu',
    'eslovac'                                   => 'sk',
    'eslovè'                                   => 'sl',
    'espanyol'                                  => 'es',
    'espanyoldespanya'                          => 'es_es',
    'esperanto'                                 => 'eo',
    'estonià'                                  => 'et',
    'ewe'                                       => 'ee',
    'ewondo'                                    => 'ewo',
    'fang'                                      => 'fan',
    'fanti'                                     => 'fat',
    'fenici'                                    => 'phn',
    'feroès'                                   => 'fo',
    'fijià'                                    => 'fj',
    'filipí'                                   => 'fil',
    'finès'                                    => 'fi',
    'flamenc'                                   => 'nl_be',
    'fon'                                       => 'fon',
    'francès'                                  => 'fr',
    'francèsantic'                             => 'fro',
    'francèscanadenc'                          => 'fr_ca',
    'francèsmitjà'                            => 'frm',
    'francèssuís'                             => 'fr_ch',
    'frisóoccidental'                          => 'frs',
    'frisóoriental'                            => 'fy',
    'frisóseptentrional'                       => 'frr',
    'friülà'                                  => 'fur',
    'ful'                                       => 'ff',
    'ga'                                        => 'gaa',
    'gallec'                                    => 'gl',
    'gal·lès'                                 => 'cy',
    'ganda'                                     => 'lg',
    'gayo'                                      => 'gay',
    'gaèlicescocès'                           => 'gd',
    'gaèlicirlandèsmitjà'                    => 'mga',
    'gbaya'                                     => 'gba',
    'georgià'                                  => 'ka',
    'gilbertès'                                => 'gil',
    'gondi'                                     => 'gon',
    'gorontalo'                                 => 'gor',
    'grebo'                                     => 'grb',
    'grec'                                      => 'el',
    'grecantic'                                 => 'grc',
    'grenlandès'                               => 'kl',
    'guaraní'                                  => 'gn',
    'gueez'                                     => 'gez',
    'gujarati'                                  => 'gu',
    'gwichin'                                   => 'gwi',
    'gòtic'                                    => 'got',
    'haida'                                     => 'hai',
    'haitià'                                   => 'ht',
    'haussa'                                    => 'ha',
    'hawaià'                                   => 'haw',
    'hebreu'                                    => 'he',
    'herero'                                    => 'hz',
    'hiligainon'                                => 'hil',
    'himachali'                                 => 'him',
    'hindi'                                     => 'hi',
    'hirimotu'                                  => 'ho',
    'hitita'                                    => 'hit',
    'hmong'                                     => 'hmn',
    'hongarès'                                 => 'hu',
    'hupa'                                      => 'hup',
    'iacut'                                     => 'sah',
    'iban'                                      => 'iba',
    'idiomadesconegutonovàlid'                 => 'und',
    'ido'                                       => 'io',
    'igbo'                                      => 'ig',
    'ijo'                                       => 'ijo',
    'ilocà'                                    => 'ilo',
    'indonesi'                                  => 'id',
    'ingúix'                                   => 'inh',
    'interlingua'                               => 'ia',
    'interlingue'                               => 'ie',
    'inuktitut'                                 => 'iu',
    'inupiak'                                   => 'ik',
    'ioruba'                                    => 'yo',
    'irlandès'                                 => 'ga',
    'irlandèsantic'                            => 'sga',
    'iroquès'                                  => 'iro',
    'islandès'                                 => 'is',
    'italià'                                   => 'it',
    'japonès'                                  => 'ja',
    'javanès'                                  => 'jv',
    'jiddisch'                                  => 'yi',
    'jju'                                       => 'kaj',
    'judeopersa'                                => 'jpr',
    'judeoàrab'                                => 'jrb',
    'jula'                                      => 'dyu',
    'kabardí'                                  => 'kbd',
    'kamba'                                     => 'kam',
    'kannada'                                   => 'kn',
    'kanuri'                                    => 'kr',
    'karakalpak'                                => 'kaa',
    'karatxai'                                  => 'krc',
    'karen'                                     => 'kar',
    'katxin'                                    => 'kac',
    'kawi'                                      => 'kaw',
    'kazakh'                                    => 'kk',
    'khasi'                                     => 'kha',
    'khmer'                                     => 'km',
    'khotanès'                                 => 'kho',
    'kikuiu'                                    => 'ki',
    'kimbundu'                                  => 'kmb',
    'kirguís'                                  => 'ky',
    'klingonià'                                => 'tlh',
    'komi'                                      => 'kv',
    'kongo'                                     => 'kg',
    'konkani'                                   => 'kok',
    'koro'                                      => 'kfo',
    'kosraeà'                                  => 'kos',
    'kpelle'                                    => 'kpe',
    'kru'                                       => 'kro',
    'kuanyama'                                  => 'kj',
    'kurd'                                      => 'ku',
    'kurukh'                                    => 'kru',
    'kutenai'                                   => 'kut',
    'kúmik'                                    => 'kum',
    'ladí'                                     => 'lad',
    'lamba'                                     => 'lam',
    'laosià'                                   => 'lo',
    'lesguià'                                  => 'lez',
    'letó'                                     => 'lv',
    'limburguès'                               => 'li',
    'lingala'                                   => 'ln',
    'lituà'                                    => 'lt',
    'llatí'                                    => 'la',
    'llenguaafroasiàtica'                      => 'afa',
    'llenguaalgonquina'                         => 'alg',
    'llenguaaltaica'                            => 'tut',
    'llenguaameríndiadamèricacentral'         => 'cai',
    'llenguaameríndiameridional'               => 'sai',
    'llenguaameríndiaseptentrional'            => 'nai',
    'llenguaapatxe'                             => 'apa',
    'llenguaartificial'                         => 'art',
    'llenguaatapascana'                         => 'ath',
    'llenguaaustraliana'                        => 'aus',
    'llenguaaustronèsia'                       => 'map',
    'llenguabàltica'                           => 'bat',
    'llenguacaucàsica'                         => 'cau',
    'llenguacriollaopidgin'                     => 'crp',
    'llenguacriollaopidginbasadaenelfrancès'   => 'cpf',
    'llenguacriollaopidginbasadaenelportuguès' => 'cpp',
    'llenguacriollaopidginbasadaenlanglès'     => 'cpe',
    'llenguacuixítica'                         => 'cus',
    'llenguacèltica'                           => 'cel',
    'llenguadesignes'                           => 'sgn',
    'llenguadravídica'                         => 'dra',
    'llenguaeslava'                             => 'sla',
    'llenguafilipina'                           => 'phi',
    'llenguafinoúgrica'                        => 'fiu',
    'llenguagermànica'                         => 'gem',
    'llenguaindoeuropea'                        => 'ine',
    'llenguairànica'                           => 'ira',
    'llenguaiupik'                              => 'ypk',
    'llenguakhoisan'                            => 'khi',
    'llenguamaia'                               => 'myn',
    'llenguamanobo'                             => 'mno',
    'llenguamiscel·lània'                     => 'mis',
    'llenguamonkhmer'                           => 'mkh',
    'llenguamunda'                              => 'mun',
    'llenguanigerokurdufaniana'                 => 'nic',
    'llenguanilosahariana'                      => 'ssa',
    'llenguanubiana'                            => 'nub',
    'llenguaotomangueana'                       => 'oto',
    'llenguapapú'                              => 'paa',
    'llenguaromànica'                          => 'roa',
    'llenguasalish'                             => 'sal',
    'llenguasami'                               => 'smi',
    'llenguasemítica'                          => 'sem',
    'llenguasinotibetana'                       => 'sit',
    'llenguasioux'                              => 'sio',
    'llenguatai'                                => 'tai',
    'llenguatupí'                              => 'tup',
    'llenguawakash'                             => 'wak',
    'llenguaíndica'                            => 'inc',
    'llengüesvàries'                          => 'mul',
    'lojban'                                    => 'jbo',
    'lozi'                                      => 'loz',
    'lubakatanga'                               => 'lu',
    'lubalulua'                                 => 'lua',
    'luisenyo'                                  => 'lui',
    'lunda'                                     => 'lun',
    'luo'                                       => 'luo',
    'luxemburguès'                             => 'lb',
    'macedoni'                                  => 'mk',
    'madurès'                                  => 'mad',
    'magahi'                                    => 'mag',
    'maithili'                                  => 'mai',
    'makassar'                                  => 'mak',
    'malai'                                     => 'ms',
    'malaialam'                                 => 'ml',
    'malgaix'                                   => 'mg',
    'maltès'                                   => 'mt',
    'mandar'                                    => 'mdr',
    'mandinga'                                  => 'man',
    'manipurí'                                 => 'mni',
    'manx'                                      => 'gv',
    'manxú'                                    => 'mnc',
    'maori'                                     => 'mi',
    'marathi'                                   => 'mr',
    'mari'                                      => 'chm',
    'marshallès'                               => 'mh',
    'marwari'                                   => 'mwr',
    'massai'                                    => 'mas',
    'mende'                                     => 'men',
    'micmac'                                    => 'mic',
    'minangkabau'                               => 'min',
    'mirandès'                                 => 'mwl',
    'mizo'                                      => 'lus',
    'mohawk'                                    => 'moh',
    'moldau'                                    => 'mo',
    'mongo'                                     => 'lol',
    'mongol'                                    => 'mn',
    'mordoviàerza'                             => 'myv',
    'mordoviàmoksa'                            => 'mdf',
    'morisyen'                                  => 'mfe',
    'moré'                                     => 'mos',
    'napolità'                                 => 'nap',
    'nauruà'                                   => 'na',
    'navaho'                                    => 'nv',
    'ndebelemeridional'                         => 'nr',
    'ndebeleseptentrional'                      => 'nd',
    'ndonga'                                    => 'ng',
    'neerlandès'                               => 'nl',
    'neerlandèsmitjà'                         => 'dum',
    'nepalès'                                  => 'ne',
    'newari'                                    => 'new',
    'newariclàssic'                            => 'nwc',
    'nias'                                      => 'nia',
    'niueà'                                    => 'niu',
    'nogai'                                     => 'nog',
    'noruec'                                    => 'no',
    'noruecbokmål'                             => 'nb',
    'noruecnynorsk'                             => 'nn',
    'nyamwesi'                                  => 'nym',
    'nyanja'                                    => 'ny',
    'nyankore'                                  => 'nyn',
    'nyoro'                                     => 'nyo',
    'nzema'                                     => 'nzi',
    'nàhuatl'                                  => 'nah',
    'nòrdicantic'                              => 'non',
    'n’ko'                                    => 'nqo',
    'occità'                                   => 'oc',
    'ojibwa'                                    => 'oj',
    'oriya'                                     => 'or',
    'oromo'                                     => 'om',
    'osage'                                     => 'osa',
    'osset'                                     => 'os',
    'pahlavi'                                   => 'pal',
    'paixto'                                    => 'ps',
    'palauà'                                   => 'pau',
    'pali'                                      => 'pi',
    'pampangà'                                 => 'pam',
    'pangasi'                                   => 'pag',
    'panjabi'                                   => 'pa',
    'panjabioccidental'                         => 'lah',
    'papiamento'                                => 'pap',
    'persa'                                     => 'fa',
    'persaantic'                                => 'peo',
    'pidginchinook'                             => 'chn',
    'polonès'                                  => 'pl',
    'ponapeà'                                  => 'pon',
    'portuguès'                                => 'pt',
    'portuguèsdebrasil'                        => 'pt_br',
    'portuguèsdeportugal'                      => 'pt_pt',
    'provençalantic'                           => 'pro',
    'pràcrit'                                  => 'pra',
    'quètxua'                                  => 'qu',
    'rajasthani'                                => 'raj',
    'rapanui'                                   => 'rap',
    'rarotongà'                                => 'rar',
    'retoromànic'                              => 'rm',
    'romanès'                                  => 'ro',
    'romaní'                                   => 'rom',
    'ruandès'                                  => 'rw',
    'rundi'                                     => 'rn',
    'rus'                                       => 'ru',
    'samidinari'                                => 'smn',
    'samilule'                                  => 'smj',
    'samimeridional'                            => 'sma',
    'samiseptentrional'                         => 'se',
    'samiskolt'                                 => 'sms',
    'samoà'                                    => 'sm',
    'sandawe'                                   => 'sad',
    'sango'                                     => 'sg',
    'santali'                                   => 'sat',
    'sard'                                      => 'sc',
    'sasak'                                     => 'sas',
    'selkup'                                    => 'sel',
    'sensecontingutlingüístic'                => 'zxx',
    'serbi'                                     => 'sr',
    'serbocroat'                                => 'sh',
    'serer'                                     => 'srr',
    'shona'                                     => 'sn',
    'sicilià'                                  => 'scn',
    'sidamo'                                    => 'sid',
    'sindhi'                                    => 'sd',
    'singalès'                                 => 'si',
    'siríac'                                   => 'syr',
    'siríacclàssic'                           => 'syc',
    'siswati'                                   => 'ss',
    'slavey'                                    => 'den',
    'sogdià'                                   => 'sog',
    'somali'                                    => 'so',
    'songhai'                                   => 'son',
    'soninke'                                   => 'snk',
    'sothomeridional'                           => 'st',
    'sothoseptentrional'                        => 'nso',
    'sranan'                                    => 'srn',
    'suahili'                                   => 'sw',
    'suec'                                      => 'sv',
    'sukuma'                                    => 'suk',
    'sumeri'                                    => 'sux',
    'sundanès'                                 => 'su',
    'susú'                                     => 'sus',
    'sànscrit'                                 => 'sa',
    'símbolsbliss'                             => 'zbl',
    'sòrab'                                    => 'wen',
    'tadjik'                                    => 'tg',
    'tagàlog'                                  => 'tl',
    'tahitià'                                  => 'ty',
    'tamazight'                                 => 'tmh',
    'taroko'                                    => 'trv',
    'telugu'                                    => 'te',
    'temne'                                     => 'tem',
    'terena'                                    => 'ter',
    'tetun'                                     => 'tet',
    'thai'                                      => 'th',
    'tibetà'                                   => 'bo',
    'tigre'                                     => 'tig',
    'tigrinya'                                  => 'ti',
    'tiv'                                       => 'tiv',
    'tlingit'                                   => 'tli',
    'tokelauès'                                => 'tkl',
    'tokpisin'                                  => 'tpi',
    'tonga'                                     => 'tog',
    'tongalès'                                 => 'to',
    'tsimshià'                                 => 'tsi',
    'tsonga'                                    => 'ts',
    'tswana'                                    => 'tn',
    'tumbuka'                                   => 'tum',
    'turc'                                      => 'tr',
    'turcman'                                   => 'tk',
    'turcotomà'                                => 'ota',
    'tuvaluà'                                  => 'tvl',
    'tuvinià'                                  => 'tyv',
    'twi'                                       => 'tw',
    'txagatai'                                  => 'chg',
    'txam'                                      => 'cmc',
    'txec'                                      => 'cs',
    'txetxè'                                   => 'ce',
    'txibtxa'                                   => 'chb',
    'txuvaix'                                   => 'cv',
    'tyap'                                      => 'kcg',
    'tàmil'                                    => 'ta',
    'tàtar'                                    => 'tt',
    'tàtardecrimea'                            => 'crh',
    'ucraïnès'                                => 'uk',
    'udmurt'                                    => 'udm',
    'ugarític'                                 => 'uga',
    'uigur'                                     => 'ug',
    'umbundu'                                   => 'umb',
    'urdú'                                     => 'ur',
    'uzbek'                                     => 'uz',
    'vai'                                       => 'vai',
    'való'                                     => 'wa',
    'venda'                                     => 've',
    'vietnamita'                                => 'vi',
    'volapük'                                  => 'vo',
    'vòtic'                                    => 'vot',
    'waraywaray'                                => 'war',
    'washo'                                     => 'was',
    'wòlof'                                    => 'wo',
    'xan'                                       => 'shn',
    'xeienne'                                   => 'chy',
    'xinès'                                    => 'zh',
    'xosa'                                      => 'xh',
    'yao'                                       => 'yao',
    'yapeà'                                    => 'yap',
    'yisichuan'                                 => 'ii',
    'zande'                                     => 'znd',
    'zapoteca'                                  => 'zap',
    'zaza'                                      => 'zza',
    'zenaga'                                    => 'zen',
    'zhuang'                                    => 'za',
    'zulu'                                      => 'zu',
    'zuni'                                      => 'zun',
    'àfar'                                     => 'aa',
    'àkan'                                     => 'ak',
    'àrab'                                     => 'ar',
    'àvar'                                     => 'av',
    'àzeri'                                    => 'az',
);

1;
