package Locales::DB::Language::pt_pt;

# Auto generated from CLDR

$Locales::DB::Language::pt_pt::VERSION = '0.01';

$Locales::DB::Language::pt_pt::cldr_version = '1.7.1';

%Locales::DB::Language::pt_pt::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::pt_pt::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arabic',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "idioma\ artifical",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "bamileke\ Languages",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Belarusian',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgarian',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'bs'    => 'Bosnian',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalan',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'chechene',
    'ceb'   => 'Cebuano',
    'cel'   => "idioma\ céltico",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "jargão\ chinook",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "crioulo\ ou\ pidgin\ do\ inglês",
    'cpf'   => "crioulo\ ou\ pidgin\ do\ francês",
    'cpp'   => "crioulo\ ou\ pidgin\ do\ português",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'checo',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "idioma\ cuchita",
    'cv'    => 'Chuvash',
    'cy'    => 'Welsh',
    'da'    => 'Danish',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'German',
    'de_at' => "Austrian\ German",
    'de_ch' => "alemão\ alto\ \(Suíça\)",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "idioma\ dravítico",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'diula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "egípcio\ clássico",
    'eka'   => 'Ekajuk',
    'el'    => 'Greek',
    'elx'   => 'Elamite',
    'en'    => 'Inglês',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "inglês\ medieval",
    'eo'    => 'Esperanto',
    'es'    => 'Spanish',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estónio',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persian',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finnish',
    'fil'   => 'Filipino',
    'fiu'   => "idioma\ ugro\-finês",
    'fj'    => 'Fijian',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'French',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "francês\ medieval",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "frísio\ oriental",
    'fur'   => 'Friulian',
    'fy'    => "Western\ Frisian",
    'ga'    => 'Irish',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galician',
    'gmh'   => "alemão\ medieval\ alto",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "grego\ clássico",
    'gsw'   => "alemão\ da\ Suíça",
    'gu'    => 'Gujarati',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Hebrew',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Croatian',
    'hsb'   => "sorbiano\ superior",
    'ht'    => 'Haitian',
    'hu'    => 'Hungarian',
    'hup'   => 'Hupa',
    'hy'    => 'arménio',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesian',
    'ie'    => 'Interlingue',
    'ig'    => 'igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Icelandic',
    'it'    => 'Italian',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japanese',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'jv',
    'ka'    => 'Georgian',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => 'khoisan',
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korean',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'lezghiano',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuanian',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Latvian',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "irlandês\,\ medieval\ \(900\-1200\)",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'macedónio',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'Maltese',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nauatle',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "baixo\ alemão",
    'ne'    => 'Nepali',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "nigeriano\ \-\ cordofano",
    'niu'   => 'Niuean',
    'nl'    => 'Dutch',
    'nl_be' => "flamengo\ \(Bélgica\)",
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'Norwegian',
    'nog'   => 'Nogai',
    'non'   => "norse\,\ old",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'provençal',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'ossético',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "persa\ arcaico\ \(aprox\.\ 600\-400\ a\.C\.\)",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'polaco',
    'pon'   => 'Pohnpeian',
    'pra'   => "idioma\ prácito",
    'pro'   => "provençal\,\ arcaico\ \(até\ 1500\)",
    'ps'    => 'Pushto',
    'pt'    => 'Portuguese',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "português\ europeu",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "reto\-romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romanian',
    'roa'   => "Romance\ Language",
    'rom'   => 'romanês',
    'ru'    => 'Russian',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "idioma\ indígeno\ sul\-americano",
    'sal'   => "salishan\ languages",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "linguages\ de\ sinais",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slovak',
    'sl'    => 'Slovenian',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanian',
    'sr'    => 'Serbian',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "idioma\ nilo\-sariano",
    'st'    => "Southern\ Sotho",
    'su'    => 'Sundanese',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Swedish',
    'sw'    => 'Swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamil',
    'tai'   => "idioma\ tailândes",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'tetum',
    'tg'    => 'tajique',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagalogue',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'tonga',
    'tog'   => 'toganês',
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'tuviniano',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Ukrainian',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamese',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "idioma\ sórbio",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::pt_pt::name_to_code = (
    'abkhazian'                       => 'ab',
    'achinese'                        => 'ace',
    'acoli'                           => 'ach',
    'adangme'                         => 'ada',
    'adyghe'                          => 'ady',
    'afar'                            => 'aa',
    'afrihili'                        => 'afh',
    'afrikaans'                       => 'af',
    'afroasiaticlanguage'             => 'afa',
    'ainu'                            => 'ain',
    'akan'                            => 'ak',
    'akkadian'                        => 'akk',
    'albanian'                        => 'sq',
    'alemãoaltosuíça'              => 'de_ch',
    'alemãodasuíça'                => 'gsw',
    'alemãomedievalalto'             => 'gmh',
    'aleut'                           => 'ale',
    'algonquianlanguage'              => 'alg',
    'altaiclanguage'                  => 'tut',
    'amharic'                         => 'am',
    'angika'                          => 'anp',
    'apachelanguage'                  => 'apa',
    'arabic'                          => 'ar',
    'aragonese'                       => 'an',
    'aramaic'                         => 'arc',
    'arapaho'                         => 'arp',
    'araucanian'                      => 'arn',
    'arawak'                          => 'arw',
    'arménio'                        => 'hy',
    'aromanian'                       => 'rup',
    'assamese'                        => 'as',
    'asturian'                        => 'ast',
    'athapascanlanguage'              => 'ath',
    'atsam'                           => 'cch',
    'australianenglish'               => 'en_au',
    'australianlanguage'              => 'aus',
    'austriangerman'                  => 'de_at',
    'austronesianlanguage'            => 'map',
    'avaric'                          => 'av',
    'avestan'                         => 'ae',
    'awadhi'                          => 'awa',
    'aymara'                          => 'ay',
    'azeri'                           => 'az',
    'baixoalemão'                    => 'nds',
    'balinese'                        => 'ban',
    'balticlanguage'                  => 'bat',
    'baluchi'                         => 'bal',
    'bambara'                         => 'bm',
    'bamilekelanguages'               => 'bai',
    'banda'                           => 'bad',
    'bantu'                           => 'bnt',
    'basa'                            => 'bas',
    'bashkir'                         => 'ba',
    'basque'                          => 'eu',
    'batak'                           => 'btk',
    'beja'                            => 'bej',
    'belarusian'                      => 'be',
    'bemba'                           => 'bem',
    'bengali'                         => 'bn',
    'berber'                          => 'ber',
    'bhojpuri'                        => 'bho',
    'bihari'                          => 'bh',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'bislama'                         => 'bi',
    'blin'                            => 'byn',
    'blissymbols'                     => 'zbl',
    'bosnian'                         => 'bs',
    'braj'                            => 'bra',
    'brazilianportuguese'             => 'pt_br',
    'breton'                          => 'br',
    'britishenglish'                  => 'en_gb',
    'buginese'                        => 'bug',
    'bulgarian'                       => 'bg',
    'buriat'                          => 'bua',
    'burmese'                         => 'my',
    'caddo'                           => 'cad',
    'canadianenglish'                 => 'en_ca',
    'canadianfrench'                  => 'fr_ca',
    'carib'                           => 'car',
    'catalan'                         => 'ca',
    'caucasianlanguage'               => 'cau',
    'cebuano'                         => 'ceb',
    'centralamericanindianlanguage'   => 'cai',
    'chagatai'                        => 'chg',
    'chamiclanguage'                  => 'cmc',
    'chamorro'                        => 'ch',
    'chechene'                        => 'ce',
    'checo'                           => 'cs',
    'cherokee'                        => 'chr',
    'cheyenne'                        => 'chy',
    'chibcha'                         => 'chb',
    'chinese'                         => 'zh',
    'chipewyan'                       => 'chp',
    'choctaw'                         => 'cho',
    'churchslavic'                    => 'cu',
    'chuukese'                        => 'chk',
    'chuvash'                         => 'cv',
    'classicalnewari'                 => 'nwc',
    'classicalsyriac'                 => 'syc',
    'coptic'                          => 'cop',
    'cornish'                         => 'kw',
    'corsican'                        => 'co',
    'cree'                            => 'cr',
    'creek'                           => 'mus',
    'creoleorpidgin'                  => 'crp',
    'crimeanturkish'                  => 'crh',
    'crioulooupidgindofrancês'       => 'cpf',
    'crioulooupidgindoinglês'        => 'cpe',
    'crioulooupidgindoportuguês'     => 'cpp',
    'croatian'                        => 'hr',
    'dakota'                          => 'dak',
    'danish'                          => 'da',
    'dargwa'                          => 'dar',
    'dayak'                           => 'day',
    'delaware'                        => 'del',
    'dinka'                           => 'din',
    'diula'                           => 'dyu',
    'divehi'                          => 'dv',
    'dogri'                           => 'doi',
    'dogrib'                          => 'dgr',
    'duala'                           => 'dua',
    'dutch'                           => 'nl',
    'dzongkha'                        => 'dz',
    'efik'                            => 'efi',
    'egípcioclássico'               => 'egy',
    'ekajuk'                          => 'eka',
    'elamite'                         => 'elx',
    'erzya'                           => 'myv',
    'esperanto'                       => 'eo',
    'estónio'                        => 'et',
    'ewe'                             => 'ee',
    'ewondo'                          => 'ewo',
    'fang'                            => 'fan',
    'fanti'                           => 'fat',
    'faroese'                         => 'fo',
    'fijian'                          => 'fj',
    'filipino'                        => 'fil',
    'finnish'                         => 'fi',
    'flamengobélgica'                => 'nl_be',
    'fon'                             => 'fon',
    'francêsmedieval'                => 'frm',
    'french'                          => 'fr',
    'friulian'                        => 'fur',
    'frísiooriental'                 => 'frs',
    'fulah'                           => 'ff',
    'ga'                              => 'gaa',
    'galician'                        => 'gl',
    'ganda'                           => 'lg',
    'gayo'                            => 'gay',
    'gbaya'                           => 'gba',
    'geez'                            => 'gez',
    'georgian'                        => 'ka',
    'german'                          => 'de',
    'germaniclanguage'                => 'gem',
    'gilbertese'                      => 'gil',
    'gondi'                           => 'gon',
    'gorontalo'                       => 'gor',
    'gothic'                          => 'got',
    'grebo'                           => 'grb',
    'greek'                           => 'el',
    'gregoclássico'                  => 'grc',
    'guarani'                         => 'gn',
    'gujarati'                        => 'gu',
    "gwich\Ê\¼in"                   => 'gwi',
    'haida'                           => 'hai',
    'haitian'                         => 'ht',
    'hausa'                           => 'ha',
    'hawaiian'                        => 'haw',
    'hebrew'                          => 'he',
    'herero'                          => 'hz',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindi'                           => 'hi',
    'hirimotu'                        => 'ho',
    'hittite'                         => 'hit',
    'hmong'                           => 'hmn',
    'hungarian'                       => 'hu',
    'hupa'                            => 'hup',
    'iban'                            => 'iba',
    'iberianspanish'                  => 'es_es',
    'icelandic'                       => 'is',
    'idiomaartifical'                 => 'art',
    'idiomacuchita'                   => 'cus',
    'idiomacéltico'                  => 'cel',
    'idiomadravítico'                => 'dra',
    'idiomaindígenosulamericano'     => 'sai',
    'idiomanilosariano'               => 'ssa',
    'idiomaprácito'                  => 'pra',
    'idiomasórbio'                   => 'wen',
    'idiomatailândes'                => 'tai',
    'idiomaugrofinês'                => 'fiu',
    'ido'                             => 'io',
    'igbo'                            => 'ig',
    'ijo'                             => 'ijo',
    'iloko'                           => 'ilo',
    'inarisami'                       => 'smn',
    'indiclanguage'                   => 'inc',
    'indoeuropeanlanguage'            => 'ine',
    'indonesian'                      => 'id',
    'inglês'                         => 'en',
    'inglêsmedieval'                 => 'enm',
    'ingush'                          => 'inh',
    'interlingua'                     => 'ia',
    'interlingue'                     => 'ie',
    'inuktitut'                       => 'iu',
    'inupiaq'                         => 'ik',
    'iranianlanguage'                 => 'ira',
    'irish'                           => 'ga',
    "irlandês\,medieval9001200"      => 'mga',
    'iroquoianlanguage'               => 'iro',
    'italian'                         => 'it',
    'japanese'                        => 'ja',
    'jargãochinook'                  => 'chn',
    'jju'                             => 'kaj',
    'judeoarabic'                     => 'jrb',
    'judeopersian'                    => 'jpr',
    'jv'                              => 'jv',
    'kabardian'                       => 'kbd',
    'kabyle'                          => 'kab',
    'kachin'                          => 'kac',
    'kalaallisut'                     => 'kl',
    'kalmyk'                          => 'xal',
    'kamba'                           => 'kam',
    'kannada'                         => 'kn',
    'kanuri'                          => 'kr',
    'karachaybalkar'                  => 'krc',
    'karakalpak'                      => 'kaa',
    'karelian'                        => 'krl',
    'karen'                           => 'kar',
    'kashmiri'                        => 'ks',
    'kashubian'                       => 'csb',
    'kawi'                            => 'kaw',
    'kazakh'                          => 'kk',
    'khasi'                           => 'kha',
    'khmer'                           => 'km',
    'khoisan'                         => 'khi',
    'khotanese'                       => 'kho',
    'kikuyu'                          => 'ki',
    'kimbundu'                        => 'kmb',
    'kinyarwanda'                     => 'rw',
    'kirghiz'                         => 'ky',
    'klingon'                         => 'tlh',
    'komi'                            => 'kv',
    'kongo'                           => 'kg',
    'konkani'                         => 'kok',
    'korean'                          => 'ko',
    'koro'                            => 'kfo',
    'kosraean'                        => 'kos',
    'kpelle'                          => 'kpe',
    'kru'                             => 'kro',
    'kuanyama'                        => 'kj',
    'kumyk'                           => 'kum',
    'kurdish'                         => 'ku',
    'kurukh'                          => 'kru',
    'kutenai'                         => 'kut',
    'ladino'                          => 'lad',
    'lahnda'                          => 'lah',
    'lamba'                           => 'lam',
    'lao'                             => 'lo',
    'latin'                           => 'la',
    'latvian'                         => 'lv',
    'lezghiano'                       => 'lez',
    'limburgish'                      => 'li',
    'lingala'                         => 'ln',
    'linguagesdesinais'               => 'sgn',
    'lithuanian'                      => 'lt',
    'lojban'                          => 'jbo',
    'lowersorbian'                    => 'dsb',
    'lozi'                            => 'loz',
    'lubakatanga'                     => 'lu',
    'lubalulua'                       => 'lua',
    'luiseno'                         => 'lui',
    'lulesami'                        => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luxembourgish'                   => 'lb',
    'macedónio'                      => 'mk',
    'madurese'                        => 'mad',
    'magahi'                          => 'mag',
    'maithili'                        => 'mai',
    'makasar'                         => 'mak',
    'malagasy'                        => 'mg',
    'malay'                           => 'ms',
    'malayalam'                       => 'ml',
    'maltese'                         => 'mt',
    'manchu'                          => 'mnc',
    'mandar'                          => 'mdr',
    'mandingo'                        => 'man',
    'manipuri'                        => 'mni',
    'manobolanguage'                  => 'mno',
    'manx'                            => 'gv',
    'maori'                           => 'mi',
    'marathi'                         => 'mr',
    'mari'                            => 'chm',
    'marshallese'                     => 'mh',
    'marwari'                         => 'mwr',
    'masai'                           => 'mas',
    'mayanlanguage'                   => 'myn',
    'mende'                           => 'men',
    'micmac'                          => 'mic',
    'middledutch'                     => 'dum',
    'minangkabau'                     => 'min',
    'mirandese'                       => 'mwl',
    'miscellaneouslanguage'           => 'mis',
    'mohawk'                          => 'moh',
    'moksha'                          => 'mdf',
    'moldavian'                       => 'mo',
    'mongo'                           => 'lol',
    'mongolian'                       => 'mn',
    'monkhmerlanguage'                => 'mkh',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'multiplelanguages'               => 'mul',
    'mundalanguage'                   => 'mun',
    'nauatle'                         => 'nah',
    'nauru'                           => 'na',
    'navajo'                          => 'nv',
    'ndonga'                          => 'ng',
    'neapolitan'                      => 'nap',
    'nepali'                          => 'ne',
    'newari'                          => 'new',
    'nias'                            => 'nia',
    'nigerianocordofano'              => 'nic',
    'niuean'                          => 'niu',
    'nogai'                           => 'nog',
    'nolinguisticcontent'             => 'zxx',
    "norse\,old"                      => 'non',
    'northamericanindianlanguage'     => 'nai',
    'northernfrisian'                 => 'frr',
    'northernsami'                    => 'se',
    'northernsotho'                   => 'nso',
    'northndebele'                    => 'nd',
    'norwegian'                       => 'no',
    "norwegianbokm\Ã\¥l"            => 'nb',
    'norwegiannynorsk'                => 'nn',
    'nubianlanguage'                  => 'nub',
    'nyamwezi'                        => 'nym',
    'nyanja'                          => 'ny',
    'nyankole'                        => 'nyn',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    "n\â\\ko"                    => 'nqo',
    'ojibwa'                          => 'oj',
    'oldenglish'                      => 'ang',
    'oldfrench'                       => 'fro',
    'oldhighgerman'                   => 'goh',
    'oldirish'                        => 'sga',
    'oriya'                           => 'or',
    'oromo'                           => 'om',
    'osage'                           => 'osa',
    'ossético'                       => 'os',
    'otomianlanguage'                 => 'oto',
    'ottomanturkish'                  => 'ota',
    'pahlavi'                         => 'pal',
    'palauan'                         => 'pau',
    'pali'                            => 'pi',
    'pampanga'                        => 'pam',
    'pangasinan'                      => 'pag',
    'papiamento'                      => 'pap',
    'papuanlanguage'                  => 'paa',
    "persaarcaicoaprox\.600400a\.c\." => 'peo',
    'persian'                         => 'fa',
    'philippinelanguage'              => 'phi',
    'phoenician'                      => 'phn',
    'pohnpeian'                       => 'pon',
    'polaco'                          => 'pl',
    'portuguese'                      => 'pt',
    'portuguêseuropeu'               => 'pt_pt',
    'provençal'                      => 'oc',
    "provençal\,arcaicoaté1500"     => 'pro',
    'punjabi'                         => 'pa',
    'pushto'                          => 'ps',
    'quechua'                         => 'qu',
    'rajasthani'                      => 'raj',
    'rapanui'                         => 'rap',
    'rarotongan'                      => 'rar',
    'retoromance'                     => 'rm',
    'romancelanguage'                 => 'roa',
    'romanian'                        => 'ro',
    'romanês'                        => 'rom',
    'rundi'                           => 'rn',
    'russian'                         => 'ru',
    'salishanlanguages'               => 'sal',
    'samaritanaramaic'                => 'sam',
    'samilanguage'                    => 'smi',
    'samoan'                          => 'sm',
    'sandawe'                         => 'sad',
    'sango'                           => 'sg',
    'sanskrit'                        => 'sa',
    'santali'                         => 'sat',
    'sardinian'                       => 'sc',
    'sasak'                           => 'sas',
    'scots'                           => 'sco',
    'scottishgaelic'                  => 'gd',
    'selkup'                          => 'sel',
    'semiticlanguage'                 => 'sem',
    'serbian'                         => 'sr',
    'serbocroatian'                   => 'sh',
    'serer'                           => 'srr',
    'shan'                            => 'shn',
    'shona'                           => 'sn',
    'sichuanyi'                       => 'ii',
    'sicilian'                        => 'scn',
    'sidamo'                          => 'sid',
    'siksika'                         => 'bla',
    'sindhi'                          => 'sd',
    'sinhala'                         => 'si',
    'sinotibetanlanguage'             => 'sit',
    'siouanlanguage'                  => 'sio',
    'skoltsami'                       => 'sms',
    'slave'                           => 'den',
    'slaviclanguage'                  => 'sla',
    'slovak'                          => 'sk',
    'slovenian'                       => 'sl',
    'sogdien'                         => 'sog',
    'somali'                          => 'so',
    'songhai'                         => 'son',
    'soninke'                         => 'snk',
    'sorbianosuperior'                => 'hsb',
    'southernaltai'                   => 'alt',
    'southernsami'                    => 'sma',
    'southernsotho'                   => 'st',
    'southndebele'                    => 'nr',
    'spanish'                         => 'es',
    'sranantongo'                     => 'srn',
    'sukuma'                          => 'suk',
    'sumerian'                        => 'sux',
    'sundanese'                       => 'su',
    'susu'                            => 'sus',
    'swahili'                         => 'sw',
    'swati'                           => 'ss',
    'swedish'                         => 'sv',
    'swissfrench'                     => 'fr_ch',
    'syriac'                          => 'syr',
    'tagalogue'                       => 'tl',
    'tahitian'                        => 'ty',
    'tajique'                         => 'tg',
    'tamashek'                        => 'tmh',
    'tamil'                           => 'ta',
    'taroko'                          => 'trv',
    'tatar'                           => 'tt',
    'telugu'                          => 'te',
    'tereno'                          => 'ter',
    'tetum'                           => 'tet',
    'thai'                            => 'th',
    'tibetan'                         => 'bo',
    'tigre'                           => 'tig',
    'tigrinya'                        => 'ti',
    'timne'                           => 'tem',
    'tiv'                             => 'tiv',
    'tlingit'                         => 'tli',
    'toganês'                        => 'tog',
    'tokelau'                         => 'tkl',
    'tokpisin'                        => 'tpi',
    'tonga'                           => 'to',
    'tsimshian'                       => 'tsi',
    'tsonga'                          => 'ts',
    'tswana'                          => 'tn',
    'tumbuka'                         => 'tum',
    'tupilanguage'                    => 'tup',
    'turkish'                         => 'tr',
    'turkmen'                         => 'tk',
    'tuvalu'                          => 'tvl',
    'tuviniano'                       => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    "u\.s\.english"                   => 'en_us',
    'udmurt'                          => 'udm',
    'ugaritic'                        => 'uga',
    'ukrainian'                       => 'uk',
    'umbundu'                         => 'umb',
    'unknownorinvalidlanguage'        => 'und',
    'urdu'                            => 'ur',
    'uyghur'                          => 'ug',
    'uzbek'                           => 'uz',
    'vai'                             => 'vai',
    'venda'                           => 've',
    'vietnamese'                      => 'vi',
    "volap\Ã\¼k"                    => 'vo',
    'votic'                           => 'vot',
    'wakashanlanguage'                => 'wak',
    'walamo'                          => 'wal',
    'walloon'                         => 'wa',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'welsh'                           => 'cy',
    'westernfrisian'                  => 'fy',
    'wolof'                           => 'wo',
    'xhosa'                           => 'xh',
    'yakut'                           => 'sah',
    'yao'                             => 'yao',
    'yapese'                          => 'yap',
    'yiddish'                         => 'yi',
    'yoruba'                          => 'yo',
    'yupiklanguage'                   => 'ypk',
    'zande'                           => 'znd',
    'zapotec'                         => 'zap',
    'zazaki'                          => 'zza',
    'zenaga'                          => 'zen',
    'zhuang'                          => 'za',
    'zulu'                            => 'zu',
    'zuni'                            => 'zun',
);

1;
