package Locales::DB::Language::ar;

# Auto generated from CLDR

$Locales::DB::Language::ar::VERSION = '0.01';

$Locales::DB::Language::ar::cldr_version = '1.7.1';

%Locales::DB::Language::ar::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#\;\#\,\#\#0\.\#\#\#\-",
        'language'  => "اللغة\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "المنطقة\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "لا\:ل",
        'yesstr' => "نعم\:ن"
    },
);

%Locales::DB::Language::ar::code_to_name = (
    'aa'    => 'الأفارية',
    'ab'    => 'الأبخازية',
    'ace'   => 'الأتشينيزية',
    'ach'   => 'الأكولية',
    'ada'   => 'الأدانجمية',
    'ady'   => 'الأديجه',
    'ae'    => 'الأفستية',
    'af'    => 'الأفريقية',
    'afa'   => "لغة\ أفرو\ آسيوية",
    'afh'   => 'الأفريهيلية',
    'ain'   => 'الآينوية',
    'ak'    => 'الأكانية',
    'akk'   => 'الأكادية',
    'ale'   => 'الأليوتية',
    'alg'   => "اللغات\ الأمريكية\ الهندية",
    'alt'   => "الألطائية\ الجنوبية",
    'am'    => 'الأمهرية',
    'an'    => 'الأراجونية',
    'ang'   => "الانجليزية\ القديمة",
    'anp'   => 'الأنجيكا',
    'apa'   => "اللغات\ الأباتشية",
    'ar'    => 'العربية',
    'arc'   => 'الآرامية',
    'arn'   => 'الأروكانية',
    'arp'   => 'الأراباهو',
    'art'   => "الصناعية\ \-\ أخرى",
    'arw'   => 'الأراواكية',
    'as'    => 'الأسامية',
    'ast'   => 'الأسترية',
    'ath'   => "اللغات\ الأزباسكانية",
    'aus'   => "اللغات\ الأسترالية",
    'av'    => 'الأفاريكية',
    'awa'   => 'الأوادية',
    'ay'    => 'الأيمارا',
    'az'    => 'الأذرية',
    'ba'    => 'الباشكيرية',
    'bad'   => 'الباندا',
    'bai'   => "اللغات\ الباميليكية",
    'bal'   => 'البلوشية',
    'ban'   => "اللغة\ البالية",
    'bas'   => 'الباسا',
    'bat'   => "البلطيقية\ \-\ أخرى",
    'be'    => 'البيلوروسية',
    'bej'   => 'البيجا',
    'bem'   => 'البيمبا',
    'ber'   => 'البربرية',
    'bg'    => 'البلغارية',
    'bh'    => 'البيهارية',
    'bho'   => 'البهوجبرية',
    'bi'    => 'البيسلامية',
    'bik'   => 'البيكولية',
    'bin'   => 'البينية',
    'bla'   => 'السيكسيكية',
    'bm'    => 'البامبارا',
    'bn'    => 'البنغالية',
    'bnt'   => 'البانتو',
    'bo'    => 'التبتية',
    'br'    => 'البريتونية',
    'bra'   => 'البراجية',
    'bs'    => 'البوسنية',
    'btk'   => 'الباتاكية',
    'bua'   => 'البرياتية',
    'bug'   => 'البجينيزية',
    'byn'   => 'البلينية',
    'ca'    => 'الكتالونية',
    'cad'   => 'الكادو',
    'cai'   => "لغة\ هند\ أمريكية\ وسطى",
    'car'   => 'الكاريبية',
    'cau'   => "لغة\ قوقازية",
    'cch'   => 'الأتسام',
    'ce'    => 'الشيشانية',
    'ceb'   => 'السيبيونو',
    'cel'   => "لغة\ كلتية",
    'ch'    => 'التشامورو',
    'chb'   => 'التشيبشا',
    'chg'   => 'التشاجاتاى',
    'chk'   => 'التشكيزية',
    'chm'   => 'الماري',
    'chn'   => "الشينوك\ جارجون",
    'cho'   => 'الشوكتو',
    'chp'   => 'الشيباوايان',
    'chr'   => 'الشيروكى',
    'chy'   => 'الشايان',
    'cmc'   => "لغة\ تشاميكية",
    'co'    => 'الكورسيكية',
    'cop'   => 'قبطية',
    'cpe'   => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ الأنجليزية",
    'cpf'   => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ الفرنسية",
    'cpp'   => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ البرتغالية",
    'cr'    => 'الكرى',
    'crh'   => "تركية\ كريمينية",
    'crp'   => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ \-\ أخرى",
    'cs'    => 'التشيكية',
    'csb'   => 'الكاشبايان',
    'cu'    => "سلافية\ كنسية",
    'cus'   => "لغة\ كشيتيكية",
    'cv'    => 'التشفاش',
    'cy'    => 'الولزية',
    'da'    => 'الدانماركية',
    'dak'   => 'الداكوتا',
    'dar'   => 'الدارجوا',
    'day'   => 'الدياك',
    'de'    => 'الألمانية',
    'de_at' => "الألمانية\ النمساوية",
    'de_ch' => "الألمانية\ العليا\ السويسرية",
    'del'   => 'الديلوير',
    'den'   => 'السلافية',
    'dgr'   => 'الدوجريب',
    'din'   => 'الدنكا',
    'doi'   => 'الدوجرى',
    'dra'   => "لغة\ درافيدينية",
    'dsb'   => "الصربية\ السفلى",
    'dua'   => 'الديولا',
    'dum'   => "الهولندية\ الوسطى",
    'dv'    => 'المالديفية',
    'dyu'   => 'الدايلا',
    'dz'    => 'الزونخاية',
    'ee'    => 'الايوي',
    'efi'   => 'الافيك',
    'egy'   => "المصرية\ القديمة",
    'eka'   => 'الاكاجك',
    'el'    => 'اليونانية',
    'elx'   => 'الامايت',
    'en'    => 'الإنجليزية',
    'en_au' => "الانجليزية\ الأسترالية",
    'en_ca' => "الإنجليزية\ الكندية",
    'en_gb' => "الانجليزية\ البريطانية",
    'en_us' => "إنجليزية\ الولايات\ المتحدة",
    'enm'   => "الإنجليزية\ الوسطى",
    'eo'    => 'إسبرانتو',
    'es'    => 'الأسبانية',
    'es_es' => "الأسبانية\ الأيبيرية",
    'et'    => 'الإستونية',
    'eu'    => "لغة\ الباسك",
    'ewo'   => 'الايوندو',
    'fa'    => 'الفارسية',
    'fan'   => 'الفانج',
    'fat'   => 'الفانتى',
    'ff'    => 'الفلة',
    'fi'    => 'الفنلندية',
    'fil'   => 'الفلبينية',
    'fiu'   => "لغة\ فينو\ أجريانية",
    'fj'    => 'الفيجية',
    'fo'    => 'الفارويز',
    'fon'   => 'الفون',
    'fr'    => 'الفرنسية',
    'fr_ca' => "الفرنسية\ الكندية",
    'fr_ch' => "الفرنسية\ السويسرية",
    'frm'   => "الفرنسية\ الوسطى",
    'fro'   => "الفرنسية\ القديمة",
    'frr'   => "الفريزينية\ الشمالية",
    'frs'   => "الفريزينية\ الشرقية",
    'fur'   => 'الفريلايان',
    'fy'    => 'الفريزيان',
    'ga'    => 'الأيرلندية',
    'gaa'   => 'الجا',
    'gay'   => 'الجايو',
    'gba'   => 'الجبيا',
    'gd'    => "الغيلية\ الأسكتلندية",
    'gem'   => "لغة\ جرمانية",
    'gez'   => 'الجيز',
    'gil'   => "لغة\ أهل\ جبل\ طارق",
    'gl'    => 'الجاليكية',
    'gmh'   => "الألمانية\ العليا\ الوسطى",
    'gn'    => 'الجوارانى',
    'goh'   => "الألمانية\ العليا\ القديمة",
    'gon'   => 'الجندى',
    'gor'   => 'الجورونتالو',
    'got'   => 'القوطية',
    'grb'   => 'الجريبو',
    'grc'   => "اليونانية\ القديمة",
    'gsw'   => "الألمانية\ السويسرية",
    'gu'    => 'الغوجاراتية',
    'gv'    => 'المنكية',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'الهوسا',
    'hai'   => 'الهيدا',
    'haw'   => "لغة\ أهل\ الهاواى",
    'he'    => 'العبرية',
    'hi'    => 'الهندية',
    'hil'   => 'الهيليجينون',
    'him'   => 'الهيماتشالى',
    'hit'   => 'الحثية',
    'hmn'   => 'الهمونجية',
    'ho'    => "الهيرى\ موتو",
    'hr'    => 'الكرواتية',
    'hsb'   => "الصربية\ العليا",
    'ht'    => 'الهايتية',
    'hu'    => 'الهنغارية',
    'hup'   => 'الهبا',
    'hy'    => 'الأرمينية',
    'hz'    => 'الهيريرو',
    'ia'    => "اللّغة\ الوسيطة",
    'iba'   => 'الايبان',
    'id'    => 'الإندونيسية',
    'ie'    => 'الانترلينج',
    'ig'    => 'الايجبو',
    'ii'    => "السيتشيون\ يى",
    'ijo'   => 'الايجو',
    'ik'    => 'الاينبياك',
    'ilo'   => 'الايلوكو',
    'inc'   => "لغة\ هندية",
    'ine'   => "لغة\ هندوأوربية",
    'inh'   => 'الإنجوشية',
    'io'    => 'الايدو',
    'ira'   => "لغة\ إيرانية",
    'iro'   => "لغة\ إيروكويانية",
    'is'    => 'الأيسلاندية',
    'it'    => 'الإيطالية',
    'iu'    => 'الاينكتيتت',
    'ja'    => 'اليابانية',
    'jbo'   => 'اللوجبان',
    'jpr'   => "اليهودية\ \-\ الفارسية",
    'jrb'   => "اليهودية\ \-\ العربية",
    'jv'    => 'الجاوية',
    'ka'    => 'الجورجية',
    'kaa'   => "الكارا\-كالباك",
    'kab'   => 'القبيلية',
    'kac'   => 'الكاتشين',
    'kaj'   => 'الجو',
    'kam'   => 'الكامبا',
    'kar'   => 'الكاريين',
    'kaw'   => 'الكوي',
    'kbd'   => 'الكاباردايان',
    'kcg'   => 'Tyap',
    'kfo'   => 'الكورو',
    'kg'    => 'الكونغو',
    'kha'   => 'الكازية',
    'khi'   => "لغة\ خويسانية",
    'kho'   => 'الخوتانيز',
    'ki'    => 'الكيكيو',
    'kj'    => 'الكيونياما',
    'kk'    => 'الكازاخستانية',
    'kl'    => 'الكالاليست',
    'km'    => 'الخميرية',
    'kmb'   => 'الكيمبندو',
    'kn'    => 'الكانادا',
    'ko'    => 'الكورية',
    'kok'   => 'الكونكانية',
    'kos'   => 'الكوسراين',
    'kpe'   => 'الكبيل',
    'kr'    => 'الكانيوري',
    'krc'   => "الكاراتشاي\-بالكار",
    'krl'   => 'الكريلية',
    'kro'   => 'الكرو',
    'kru'   => 'Kurukh',
    'ks'    => 'الكاشميرية',
    'ku'    => 'الكردية',
    'kum'   => 'الكميك',
    'kut'   => 'الكتيناي',
    'kv'    => 'الكومي',
    'kw'    => 'الكورنية',
    'ky'    => 'القيرغستانية',
    'la'    => 'اللاتينية',
    'lad'   => 'الاسباعبرية',
    'lah'   => 'اللاهندا',
    'lam'   => 'اللامبا',
    'lb'    => 'اللوكسمبرجية',
    'lez'   => 'الليزجهايانية',
    'lg'    => 'الجاندا',
    'li'    => 'الليمبرجيشية',
    'ln'    => 'اللينجالا',
    'lo'    => 'اللاوية',
    'lol'   => 'مونجو',
    'loz'   => 'اللوزى',
    'lt'    => 'اللتوانية',
    'lu'    => "اللبا\-كاتانجا",
    'lua'   => "اللبا\-لؤلؤ",
    'lui'   => 'اللوسينو',
    'lun'   => 'اللوندا',
    'luo'   => 'اللو',
    'lus'   => 'اللشاي',
    'lv'    => 'اللاتفية',
    'mad'   => 'المادريز',
    'mag'   => 'الماجا',
    'mai'   => 'المايثيلي',
    'mak'   => 'الماكاسار',
    'man'   => 'الماندينغ',
    'map'   => 'الأوسترونيسيان',
    'mas'   => 'الماساي',
    'mdf'   => 'الموكشا',
    'mdr'   => 'الماندار',
    'men'   => 'الميند',
    'mfe'   => 'Morisyen',
    'mg'    => 'المالاجاشية',
    'mga'   => "الأيرلندية\ الوسطى",
    'mh'    => 'المارشالية',
    'mi'    => 'الماورية',
    'mic'   => 'الميكماكيونية',
    'min'   => 'المينانجكاباو',
    'mis'   => "لغات\ متنوعة",
    'mk'    => 'المقدونية',
    'mkh'   => "لغة\ مون\ \-\ خمير",
    'ml'    => 'الماليالام',
    'mn'    => 'المنغولية',
    'mnc'   => 'المانشو',
    'mni'   => 'المانيبرى',
    'mno'   => "لغات\ مانوبو",
    'mo'    => 'المولدوفية',
    'moh'   => 'الموهوك',
    'mos'   => 'الموسي',
    'mr'    => 'الماراثى',
    'ms'    => "لغة\ الملايو",
    'mt'    => 'المالطية',
    'mul'   => "لغات\ متعددة",
    'mun'   => "لغات\ المندا",
    'mus'   => 'الكريك',
    'mwl'   => 'الميرانديز',
    'mwr'   => 'الماروارى',
    'my'    => 'البورمية',
    'myn'   => "لغة\ مايا",
    'myv'   => "اللغة\ الارزية",
    'na'    => 'النورو',
    'nah'   => 'الناهيوتل',
    'nai'   => "لغة\ هند\ أمريكية\ شمالية",
    'nap'   => "اللغة\ النابولية",
    'nb'    => "البوكمالية\ النرويجية",
    'nd'    => "النديبيل\ الشمالى",
    'nds'   => "الألمانية\ السفلى",
    'ne'    => 'النيبالية',
    'new'   => 'النيواري',
    'ng'    => 'الندونجا',
    'nia'   => 'النياس',
    'nic'   => "النيجر\ \-\ كوردوفانايان",
    'niu'   => 'النيوي',
    'nl'    => 'الهولندية',
    'nl_be' => 'Flemish',
    'nn'    => "النينورسك\ النرويجي",
    'no'    => 'النرويجية',
    'nog'   => 'النوجاى',
    'non'   => "النورس\ القديم",
    'nqo'   => 'انكو',
    'nr'    => "النديبيل\ الجنوبى",
    'nso'   => "السوتو\ الشمالية",
    'nub'   => "لغة\ نوبية",
    'nv'    => 'النافاجو',
    'nwc'   => "النوارية\ التقليدية",
    'ny'    => "النيانجا،\ التشيتشوا،\ التشوا",
    'nym'   => 'النيامويزى',
    'nyn'   => 'النيانكول',
    'nyo'   => 'النيورو',
    'nzi'   => 'النزيما',
    'oc'    => 'الأوكيتانية',
    'oj'    => 'الأوجيبوا',
    'om'    => 'الأورومو',
    'or'    => 'الأورييا',
    'os'    => 'الأوسيتيك',
    'osa'   => 'الأوساج',
    'ota'   => "التركية\ العثمانية",
    'oto'   => "اللغات\ الأوتومية",
    'pa'    => 'البنجابية',
    'paa'   => "الغينية\ \-\ أخرى",
    'pag'   => 'البانجاسينان',
    'pal'   => 'البهلوية',
    'pam'   => 'البامبانجا',
    'pap'   => 'البابيامينتو',
    'pau'   => 'البالوان',
    'peo'   => "الفارسية\ القديمة",
    'phi'   => "الفليبينية\ \-\ أخرى",
    'phn'   => 'الفينيقية',
    'pi'    => 'البالية',
    'pl'    => 'البولندية',
    'pon'   => 'البوهنبيايان',
    'pra'   => "اللغات\ البراقريطية",
    'pro'   => "البروفانسية\ القديمة",
    'ps'    => 'البشتونية',
    'pt'    => 'البرتغالية',
    'pt_br' => "البرتغالية\ البرازيلية",
    'pt_pt' => "البرتغالية\ الأيبيرية",
    'qu'    => 'الكويتشوا',
    'raj'   => 'الراجاسثانية',
    'rap'   => 'الرابانى',
    'rar'   => 'الراروتونجانى',
    'rm'    => "الرهايتو\-رومانس",
    'rn'    => 'الرندى',
    'ro'    => 'الرومانية',
    'roa'   => "الرومانسية\ \-\ أخرى",
    'rom'   => "الرومانية\ \[rom\]",
    'ru'    => 'الروسية',
    'rup'   => 'الأرومانيان',
    'rw'    => 'الكينيارواندا',
    'sa'    => 'السنسكريتية',
    'sad'   => 'السانداوى',
    'sah'   => 'الياكت',
    'sai'   => "الهندية\ الأمريكية\ الجنوبية\ \-\ أخرى",
    'sal'   => "لغات\ ساليشان",
    'sam'   => "الآرامية\ السومارية",
    'sas'   => 'الساساك',
    'sat'   => 'السانتالى',
    'sc'    => 'السردينية',
    'scn'   => 'الصقلية',
    'sco'   => 'الأسكتلندية',
    'sd'    => 'السيندى',
    'se'    => "السامي\ الشمالى",
    'sel'   => 'السيلكب',
    'sem'   => "السامية\ \-\ أخرى",
    'sg'    => 'السانجو',
    'sga'   => "الأيرلندية\ القديمة",
    'sgn'   => "لغات\ الإشارة",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'الشانية',
    'si'    => 'السريلانكية',
    'sid'   => 'السيدامو',
    'sio'   => "لغات\ السيويون",
    'sit'   => "الصينية\ التيبتية\ \-\ أخرى",
    'sk'    => 'السلوفاكية',
    'sl'    => 'السلوفانية',
    'sla'   => "السلافية\ \-\ أخرى",
    'sm'    => 'الساموائية',
    'sma'   => "السامي\ الجنوبى",
    'smi'   => "اللغات\ السامية\ \-\ أخرى",
    'smj'   => "اللول\ سامى",
    'smn'   => "الاينارى\ سامى",
    'sms'   => "السكولت\ سامى",
    'sn'    => 'الشونا',
    'snk'   => 'السونينك',
    'so'    => 'الصومالية',
    'sog'   => 'السوجدين',
    'son'   => 'السونجهاى',
    'sq'    => 'الألبانية',
    'sr'    => 'الصربية',
    'srn'   => "السرانان\ تونجو",
    'srr'   => 'السرر',
    'ss'    => 'السواتى',
    'ssa'   => "لغة\ نيلية\ صحراوية",
    'st'    => "السوتو\ الجنوبية",
    'su'    => 'السودانية',
    'suk'   => 'السوكوما',
    'sus'   => 'السوسو',
    'sux'   => 'السومارية',
    'sv'    => 'السويدية',
    'sw'    => 'السواحلية',
    'syc'   => "سريانية\ تقليدية",
    'syr'   => 'السريانية',
    'ta'    => 'التاميلية',
    'tai'   => "تاى\ \-\ أخرى",
    'te'    => 'التيلجو',
    'tem'   => 'التيمن',
    'ter'   => 'التيرينو',
    'tet'   => 'التيتم',
    'tg'    => 'الطاجيكية',
    'th'    => 'التايلاندية',
    'ti'    => 'التيجرينيا',
    'tig'   => 'التيجر',
    'tiv'   => 'التيف',
    'tk'    => 'التركمانية',
    'tkl'   => 'التوكيلاو',
    'tl'    => 'التاغالوغية',
    'tlh'   => 'الكلينجون',
    'tli'   => 'التلينغيتية',
    'tmh'   => 'التاماشيك',
    'tn'    => 'التسوانية',
    'to'    => "تونجا\ \-\ جزر\ تونجا",
    'tog'   => "تونجا\ \-\ نياسا",
    'tpi'   => "التوك\ بيسين",
    'tr'    => 'التركية',
    'trv'   => 'Taroko',
    'ts'    => 'السونجا',
    'tsi'   => 'التسيمشيان',
    'tt'    => 'التتارية',
    'tum'   => 'التامبوكا',
    'tup'   => "اللغات\ التوبية",
    'tut'   => "الألطائية\ \-\ أخرى",
    'tvl'   => 'التوفالو',
    'tw'    => 'التوي',
    'ty'    => 'التاهيتية',
    'tyv'   => 'Tuvinian',
    'udm'   => 'الأدمرت',
    'ug'    => 'الأغورية',
    'uga'   => 'اليجاريتيك',
    'uk'    => 'الأوكرانية',
    'umb'   => 'الأمبندو',
    'und'   => "غير\ محدده",
    'ur'    => 'الأردية',
    'uz'    => 'الاوزباكية',
    'vai'   => 'الفاى',
    've'    => 'الفيندا',
    'vi'    => 'الفيتنامية',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'الفوتيك',
    'wa'    => 'الولونية',
    'wak'   => "لغات\ الواكاشان",
    'wal'   => 'الوالامو',
    'war'   => 'الواراى',
    'was'   => 'الواشو',
    'wen'   => "اللغات\ الصربية",
    'wo'    => 'الولوف',
    'xal'   => 'الكالميك',
    'xh'    => 'Xhosa',
    'yao'   => 'الياو',
    'yap'   => 'اليابيز',
    'yi'    => 'اليديشية',
    'yo'    => 'اليوروبية',
    'ypk'   => "اللغات\ اليوبيكية",
    'za'    => 'الزهيونج',
    'zap'   => 'الزابوتيك',
    'zbl'   => 'Blissymbols',
    'zen'   => 'الزيناجا',
    'zh'    => 'الصينية',
    'znd'   => 'الزاند',
    'zu'    => 'الزولو',
    'zun'   => 'الزونية',
    'zxx'   => "بدون\ محتوى\ لغوي",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ar::name_to_code = (
    'blissymbols'                                                                                                                  => 'zbl',
    'flemish'                                                                                                                      => 'nl_be',
    "gwich\Ê\¼in"                                                                                                                => 'gwi',
    'kurukh'                                                                                                                       => 'kru',
    'morisyen'                                                                                                                     => 'mfe',
    'serbocroatian'                                                                                                                => 'sh',
    'taroko'                                                                                                                       => 'trv',
    'tuvinian'                                                                                                                     => 'tyv',
    'tyap'                                                                                                                         => 'kcg',
    "volap\Ã\¼k"                                                                                                                 => 'vo',
    'xhosa'                                                                                                                        => 'xh',
    'zaza'                                                                                                                         => 'zza',
    'إسبرانتو'                                                                                                             => 'eo',
    'إنجليزيةالولاياتالمتحدة'                                                                               => 'en_us',
    'الآرامية'                                                                                                             => 'arc',
    'الآراميةالسومارية'                                                                                           => 'sam',
    'الآينوية'                                                                                                             => 'ain',
    'الأبخازية'                                                                                                           => 'ab',
    'الأتسام'                                                                                                               => 'cch',
    'الأتشينيزية'                                                                                                       => 'ace',
    'الأدانجمية'                                                                                                         => 'ada',
    'الأدمرت'                                                                                                               => 'udm',
    'الأديجه'                                                                                                               => 'ady',
    'الأذرية'                                                                                                               => 'az',
    'الأراباهو'                                                                                                           => 'arp',
    'الأراجونية'                                                                                                         => 'an',
    'الأراواكية'                                                                                                         => 'arw',
    'الأردية'                                                                                                               => 'ur',
    'الأرمينية'                                                                                                           => 'hy',
    'الأروكانية'                                                                                                         => 'arn',
    'الأرومانيان'                                                                                                       => 'rup',
    'الأسامية'                                                                                                             => 'as',
    'الأسبانية'                                                                                                           => 'es',
    'الأسبانيةالأيبيرية'                                                                                         => 'es_es',
    'الأسترية'                                                                                                             => 'ast',
    'الأسكتلندية'                                                                                                       => 'sco',
    'الأغورية'                                                                                                             => 'ug',
    'الأفارية'                                                                                                             => 'aa',
    'الأفاريكية'                                                                                                         => 'av',
    'الأفريقية'                                                                                                           => 'af',
    'الأفريهيلية'                                                                                                       => 'afh',
    'الأفستية'                                                                                                             => 'ae',
    'الأكادية'                                                                                                             => 'akk',
    'الأكانية'                                                                                                             => 'ak',
    'الأكولية'                                                                                                             => 'ach',
    'الألبانية'                                                                                                           => 'sq',
    'الألطائيةأخرى'                                                                                                   => 'tut',
    'الألطائيةالجنوبية'                                                                                           => 'alt',
    'الألمانية'                                                                                                           => 'de',
    'الألمانيةالسفلى'                                                                                               => 'nds',
    'الألمانيةالسويسرية'                                                                                         => 'gsw',
    'الألمانيةالعلياالسويسرية'                                                                             => 'de_ch',
    'الألمانيةالعلياالقديمة'                                                                                 => 'goh',
    'الألمانيةالعلياالوسطى'                                                                                   => 'gmh',
    'الألمانيةالنمساوية'                                                                                         => 'de_at',
    'الأليوتية'                                                                                                           => 'ale',
    'الأمبندو'                                                                                                             => 'umb',
    'الأمهرية'                                                                                                             => 'am',
    'الأنجيكا'                                                                                                             => 'anp',
    'الأوادية'                                                                                                             => 'awa',
    'الأوجيبوا'                                                                                                           => 'oj',
    'الأورومو'                                                                                                             => 'om',
    'الأورييا'                                                                                                             => 'or',
    'الأوساج'                                                                                                               => 'osa',
    'الأوسترونيسيان'                                                                                                 => 'map',
    'الأوسيتيك'                                                                                                           => 'os',
    'الأوكرانية'                                                                                                         => 'uk',
    'الأوكيتانية'                                                                                                       => 'oc',
    'الأيرلندية'                                                                                                         => 'ga',
    'الأيرلنديةالقديمة'                                                                                           => 'sga',
    'الأيرلنديةالوسطى'                                                                                             => 'mga',
    'الأيسلاندية'                                                                                                       => 'is',
    'الأيمارا'                                                                                                             => 'ay',
    'الإستونية'                                                                                                           => 'et',
    'الإنجليزية'                                                                                                         => 'en',
    'الإنجليزيةالكندية'                                                                                           => 'en_ca',
    'الإنجليزيةالوسطى'                                                                                             => 'enm',
    'الإنجوشية'                                                                                                           => 'inh',
    'الإندونيسية'                                                                                                       => 'id',
    'الإيطالية'                                                                                                           => 'it',
    'الاسباعبرية'                                                                                                       => 'lad',
    'الافيك'                                                                                                                 => 'efi',
    'الاكاجك'                                                                                                               => 'eka',
    'الامايت'                                                                                                               => 'elx',
    'الانترلينج'                                                                                                         => 'ie',
    'الانجليزيةالأسترالية'                                                                                     => 'en_au',
    'الانجليزيةالبريطانية'                                                                                     => 'en_gb',
    'الانجليزيةالقديمة'                                                                                           => 'ang',
    'الاوزباكية'                                                                                                         => 'uz',
    'الايبان'                                                                                                               => 'iba',
    'الايجبو'                                                                                                               => 'ig',
    'الايجو'                                                                                                                 => 'ijo',
    'الايدو'                                                                                                                 => 'io',
    'الايلوكو'                                                                                                             => 'ilo',
    'الاينارىسامى'                                                                                                     => 'smn',
    'الاينبياك'                                                                                                           => 'ik',
    'الاينكتيتت'                                                                                                         => 'iu',
    'الايوندو'                                                                                                             => 'ewo',
    'الايوي'                                                                                                                 => 'ee',
    'البابيامينتو'                                                                                                     => 'pap',
    'الباتاكية'                                                                                                           => 'btk',
    'الباسا'                                                                                                                 => 'bas',
    'الباشكيرية'                                                                                                         => 'ba',
    'البالوان'                                                                                                             => 'pau',
    'البالية'                                                                                                               => 'pi',
    'البامبارا'                                                                                                           => 'bm',
    'البامبانجا'                                                                                                         => 'pam',
    'البانتو'                                                                                                               => 'bnt',
    'البانجاسينان'                                                                                                     => 'pag',
    'الباندا'                                                                                                               => 'bad',
    'البجينيزية'                                                                                                         => 'bug',
    'البراجية'                                                                                                             => 'bra',
    'البربرية'                                                                                                             => 'ber',
    'البرتغالية'                                                                                                         => 'pt',
    'البرتغاليةالأيبيرية'                                                                                       => 'pt_pt',
    'البرتغاليةالبرازيلية'                                                                                     => 'pt_br',
    'البروفانسيةالقديمة'                                                                                         => 'pro',
    'البرياتية'                                                                                                           => 'bua',
    'البريتونية'                                                                                                         => 'br',
    'البشتونية'                                                                                                           => 'ps',
    'البلطيقيةأخرى'                                                                                                   => 'bat',
    'البلغارية'                                                                                                           => 'bg',
    'البلوشية'                                                                                                             => 'bal',
    'البلينية'                                                                                                             => 'byn',
    'البنجابية'                                                                                                           => 'pa',
    'البنغالية'                                                                                                           => 'bn',
    'البهلوية'                                                                                                             => 'pal',
    'البهوجبرية'                                                                                                         => 'bho',
    'البورمية'                                                                                                             => 'my',
    'البوسنية'                                                                                                             => 'bs',
    'البوكماليةالنرويجية'                                                                                       => 'nb',
    'البولندية'                                                                                                           => 'pl',
    'البوهنبيايان'                                                                                                     => 'pon',
    'البيجا'                                                                                                                 => 'bej',
    'البيسلامية'                                                                                                         => 'bi',
    'البيكولية'                                                                                                           => 'bik',
    'البيلوروسية'                                                                                                       => 'be',
    'البيمبا'                                                                                                               => 'bem',
    'البينية'                                                                                                               => 'bin',
    'البيهارية'                                                                                                           => 'bh',
    'التاغالوغية'                                                                                                       => 'tl',
    'التاماشيك'                                                                                                           => 'tmh',
    'التامبوكا'                                                                                                           => 'tum',
    'التاميلية'                                                                                                           => 'ta',
    'التاهيتية'                                                                                                           => 'ty',
    'التايلاندية'                                                                                                       => 'th',
    'التبتية'                                                                                                               => 'bo',
    'التتارية'                                                                                                             => 'tt',
    'التركمانية'                                                                                                         => 'tk',
    'التركية'                                                                                                               => 'tr',
    'التركيةالعثمانية'                                                                                             => 'ota',
    'التسوانية'                                                                                                           => 'tn',
    'التسيمشيان'                                                                                                         => 'tsi',
    'التشاجاتاى'                                                                                                         => 'chg',
    'التشامورو'                                                                                                           => 'ch',
    'التشفاش'                                                                                                               => 'cv',
    'التشكيزية'                                                                                                           => 'chk',
    'التشيبشا'                                                                                                             => 'chb',
    'التشيكية'                                                                                                             => 'cs',
    'التلينغيتية'                                                                                                       => 'tli',
    'التوفالو'                                                                                                             => 'tvl',
    'التوكبيسين'                                                                                                         => 'tpi',
    'التوكيلاو'                                                                                                           => 'tkl',
    'التوي'                                                                                                                   => 'tw',
    'التيتم'                                                                                                                 => 'tet',
    'التيجر'                                                                                                                 => 'tig',
    'التيجرينيا'                                                                                                         => 'ti',
    'التيرينو'                                                                                                             => 'ter',
    'التيف'                                                                                                                   => 'tiv',
    'التيلجو'                                                                                                               => 'te',
    'التيمن'                                                                                                                 => 'tem',
    'الجا'                                                                                                                     => 'gaa',
    'الجاليكية'                                                                                                           => 'gl',
    'الجاندا'                                                                                                               => 'lg',
    'الجاوية'                                                                                                               => 'jv',
    'الجايو'                                                                                                                 => 'gay',
    'الجبيا'                                                                                                                 => 'gba',
    'الجريبو'                                                                                                               => 'grb',
    'الجندى'                                                                                                                 => 'gon',
    'الجو'                                                                                                                     => 'kaj',
    'الجوارانى'                                                                                                           => 'gn',
    'الجورجية'                                                                                                             => 'ka',
    'الجورونتالو'                                                                                                       => 'gor',
    'الجيز'                                                                                                                   => 'gez',
    'الحثية'                                                                                                                 => 'hit',
    'الخميرية'                                                                                                             => 'km',
    'الخوتانيز'                                                                                                           => 'kho',
    'الدارجوا'                                                                                                             => 'dar',
    'الداكوتا'                                                                                                             => 'dak',
    'الدانماركية'                                                                                                       => 'da',
    'الدايلا'                                                                                                               => 'dyu',
    'الدنكا'                                                                                                                 => 'din',
    'الدوجرى'                                                                                                               => 'doi',
    'الدوجريب'                                                                                                             => 'dgr',
    'الدياك'                                                                                                                 => 'day',
    'الديلوير'                                                                                                             => 'del',
    'الديولا'                                                                                                               => 'dua',
    'الرابانى'                                                                                                             => 'rap',
    'الراجاسثانية'                                                                                                     => 'raj',
    'الراروتونجانى'                                                                                                   => 'rar',
    'الرندى'                                                                                                                 => 'rn',
    'الرهايتورومانس'                                                                                                 => 'rm',
    'الروسية'                                                                                                               => 'ru',
    'الرومانسيةأخرى'                                                                                                 => 'roa',
    'الرومانية'                                                                                                           => 'ro',
    'الرومانيةrom'                                                                                                        => 'rom',
    'الزابوتيك'                                                                                                           => 'zap',
    'الزاند'                                                                                                                 => 'znd',
    'الزهيونج'                                                                                                             => 'za',
    'الزولو'                                                                                                                 => 'zu',
    'الزونخاية'                                                                                                           => 'dz',
    'الزونية'                                                                                                               => 'zun',
    'الزيناجا'                                                                                                             => 'zen',
    'الساساك'                                                                                                               => 'sas',
    'الساموائية'                                                                                                         => 'sm',
    'الساميالجنوبى'                                                                                                   => 'sma',
    'الساميالشمالى'                                                                                                   => 'se',
    'الساميةأخرى'                                                                                                       => 'sem',
    'السانتالى'                                                                                                           => 'sat',
    'السانجو'                                                                                                               => 'sg',
    'السانداوى'                                                                                                           => 'sad',
    'السرانانتونجو'                                                                                                   => 'srn',
    'السردينية'                                                                                                           => 'sc',
    'السرر'                                                                                                                   => 'srr',
    'السريانية'                                                                                                           => 'syr',
    'السريلانكية'                                                                                                       => 'si',
    'السكولتسامى'                                                                                                       => 'sms',
    'السلافية'                                                                                                             => 'den',
    'السلافيةأخرى'                                                                                                     => 'sla',
    'السلوفاكية'                                                                                                         => 'sk',
    'السلوفانية'                                                                                                         => 'sl',
    'السنسكريتية'                                                                                                       => 'sa',
    'السواتى'                                                                                                               => 'ss',
    'السواحلية'                                                                                                           => 'sw',
    'السوتوالجنوبية'                                                                                                 => 'st',
    'السوتوالشمالية'                                                                                                 => 'nso',
    'السوجدين'                                                                                                             => 'sog',
    'السودانية'                                                                                                           => 'su',
    'السوسو'                                                                                                                 => 'sus',
    'السوكوما'                                                                                                             => 'suk',
    'السومارية'                                                                                                           => 'sux',
    'السونجا'                                                                                                               => 'ts',
    'السونجهاى'                                                                                                           => 'son',
    'السونينك'                                                                                                             => 'snk',
    'السويدية'                                                                                                             => 'sv',
    'السيبيونو'                                                                                                           => 'ceb',
    'السيتشيونيى'                                                                                                       => 'ii',
    'السيدامو'                                                                                                             => 'sid',
    'السيكسيكية'                                                                                                         => 'bla',
    'السيلكب'                                                                                                               => 'sel',
    'السيندى'                                                                                                               => 'sd',
    'الشانية'                                                                                                               => 'shn',
    'الشايان'                                                                                                               => 'chy',
    'الشوكتو'                                                                                                               => 'cho',
    'الشونا'                                                                                                                 => 'sn',
    'الشيباوايان'                                                                                                       => 'chp',
    'الشيروكى'                                                                                                             => 'chr',
    'الشيشانية'                                                                                                           => 'ce',
    'الشينوكجارجون'                                                                                                   => 'chn',
    'الصربية'                                                                                                               => 'sr',
    'الصربيةالسفلى'                                                                                                   => 'dsb',
    'الصربيةالعليا'                                                                                                   => 'hsb',
    'الصقلية'                                                                                                               => 'scn',
    'الصناعيةأخرى'                                                                                                     => 'art',
    'الصومالية'                                                                                                           => 'so',
    'الصينية'                                                                                                               => 'zh',
    'الصينيةالتيبتيةأخرى'                                                                                       => 'sit',
    'الطاجيكية'                                                                                                           => 'tg',
    'العبرية'                                                                                                               => 'he',
    'العربية'                                                                                                               => 'ar',
    'الغوجاراتية'                                                                                                       => 'gu',
    'الغيليةالأسكتلندية'                                                                                         => 'gd',
    'الغينيةأخرى'                                                                                                       => 'paa',
    'الفارسية'                                                                                                             => 'fa',
    'الفارسيةالقديمة'                                                                                               => 'peo',
    'الفارويز'                                                                                                             => 'fo',
    'الفانتى'                                                                                                               => 'fat',
    'الفانج'                                                                                                                 => 'fan',
    'الفاى'                                                                                                                   => 'vai',
    'الفرنسية'                                                                                                             => 'fr',
    'الفرنسيةالسويسرية'                                                                                           => 'fr_ch',
    'الفرنسيةالقديمة'                                                                                               => 'fro',
    'الفرنسيةالكندية'                                                                                               => 'fr_ca',
    'الفرنسيةالوسطى'                                                                                                 => 'frm',
    'الفريزيان'                                                                                                           => 'fy',
    'الفريزينيةالشرقية'                                                                                           => 'frs',
    'الفريزينيةالشمالية'                                                                                         => 'frr',
    'الفريلايان'                                                                                                         => 'fur',
    'الفلبينية'                                                                                                           => 'fil',
    'الفلة'                                                                                                                   => 'ff',
    'الفليبينيةأخرى'                                                                                                 => 'phi',
    'الفنلندية'                                                                                                           => 'fi',
    'الفوتيك'                                                                                                               => 'vot',
    'الفون'                                                                                                                   => 'fon',
    'الفيتنامية'                                                                                                         => 'vi',
    'الفيجية'                                                                                                               => 'fj',
    'الفيندا'                                                                                                               => 've',
    'الفينيقية'                                                                                                           => 'phn',
    'القبيلية'                                                                                                             => 'kab',
    'القوطية'                                                                                                               => 'got',
    'القيرغستانية'                                                                                                     => 'ky',
    'الكاباردايان'                                                                                                     => 'kbd',
    'الكاتشين'                                                                                                             => 'kac',
    'الكادو'                                                                                                                 => 'cad',
    'الكاراتشايبالكار'                                                                                             => 'krc',
    'الكاراكالباك'                                                                                                     => 'kaa',
    'الكاريبية'                                                                                                           => 'car',
    'الكاريين'                                                                                                             => 'kar',
    'الكازاخستانية'                                                                                                   => 'kk',
    'الكازية'                                                                                                               => 'kha',
    'الكاشبايان'                                                                                                         => 'csb',
    'الكاشميرية'                                                                                                         => 'ks',
    'الكالاليست'                                                                                                         => 'kl',
    'الكالميك'                                                                                                             => 'xal',
    'الكامبا'                                                                                                               => 'kam',
    'الكانادا'                                                                                                             => 'kn',
    'الكانيوري'                                                                                                           => 'kr',
    'الكبيل'                                                                                                                 => 'kpe',
    'الكتالونية'                                                                                                         => 'ca',
    'الكتيناي'                                                                                                             => 'kut',
    'الكردية'                                                                                                               => 'ku',
    'الكرو'                                                                                                                   => 'kro',
    'الكرواتية'                                                                                                           => 'hr',
    'الكرى'                                                                                                                   => 'cr',
    'الكريك'                                                                                                                 => 'mus',
    'الكريلية'                                                                                                             => 'krl',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبأخرى'                           => 'crp',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالأنجليزية' => 'cpe',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالبرتغالية' => 'cpp',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالفرنسية'     => 'cpf',
    'الكلينجون'                                                                                                           => 'tlh',
    'الكميك'                                                                                                                 => 'kum',
    'الكورسيكية'                                                                                                         => 'co',
    'الكورنية'                                                                                                             => 'kw',
    'الكورو'                                                                                                                 => 'kfo',
    'الكورية'                                                                                                               => 'ko',
    'الكوسراين'                                                                                                           => 'kos',
    'الكومي'                                                                                                                 => 'kv',
    'الكونغو'                                                                                                               => 'kg',
    'الكونكانية'                                                                                                         => 'kok',
    'الكوي'                                                                                                                   => 'kaw',
    'الكويتشوا'                                                                                                           => 'qu',
    'الكيكيو'                                                                                                               => 'ki',
    'الكيمبندو'                                                                                                           => 'kmb',
    'الكينيارواندا'                                                                                                   => 'rw',
    'الكيونياما'                                                                                                         => 'kj',
    'اللاتفية'                                                                                                             => 'lv',
    'اللاتينية'                                                                                                           => 'la',
    'اللامبا'                                                                                                               => 'lam',
    'اللاهندا'                                                                                                             => 'lah',
    'اللاوية'                                                                                                               => 'lo',
    'اللباكاتانجا'                                                                                                     => 'lu',
    'اللبالؤلؤ'                                                                                                           => 'lua',
    'اللتوانية'                                                                                                           => 'lt',
    'اللشاي'                                                                                                                 => 'lus',
    'اللغاتالأباتشية'                                                                                               => 'apa',
    'اللغاتالأزباسكانية'                                                                                         => 'ath',
    'اللغاتالأسترالية'                                                                                             => 'aus',
    'اللغاتالأمريكيةالهندية'                                                                                 => 'alg',
    'اللغاتالأوتومية'                                                                                               => 'oto',
    'اللغاتالباميليكية'                                                                                           => 'bai',
    'اللغاتالبراقريطية'                                                                                           => 'pra',
    'اللغاتالتوبية'                                                                                                   => 'tup',
    'اللغاتالساميةأخرى'                                                                                           => 'smi',
    'اللغاتالصربية'                                                                                                   => 'wen',
    'اللغاتاليوبيكية'                                                                                               => 'ypk',
    'اللغةالارزية'                                                                                                     => 'myv',
    'اللغةالبالية'                                                                                                     => 'ban',
    'اللغةالنابولية'                                                                                                 => 'nap',
    'اللو'                                                                                                                     => 'luo',
    'اللوجبان'                                                                                                             => 'jbo',
    'اللوزى'                                                                                                                 => 'loz',
    'اللوسينو'                                                                                                             => 'lui',
    'اللوكسمبرجية'                                                                                                     => 'lb',
    'اللولسامى'                                                                                                           => 'smj',
    'اللوندا'                                                                                                               => 'lun',
    'الليزجهايانية'                                                                                                   => 'lez',
    'الليمبرجيشية'                                                                                                     => 'li',
    'اللينجالا'                                                                                                           => 'ln',
    'اللّغةالوسيطة'                                                                                                   => 'ia',
    'الماجا'                                                                                                                 => 'mag',
    'المادريز'                                                                                                             => 'mad',
    'الماراثى'                                                                                                             => 'mr',
    'المارشالية'                                                                                                         => 'mh',
    'الماروارى'                                                                                                           => 'mwr',
    'الماري'                                                                                                                 => 'chm',
    'الماساي'                                                                                                               => 'mas',
    'الماكاسار'                                                                                                           => 'mak',
    'المالاجاشية'                                                                                                       => 'mg',
    'المالديفية'                                                                                                         => 'dv',
    'المالطية'                                                                                                             => 'mt',
    'الماليالام'                                                                                                         => 'ml',
    'الماندار'                                                                                                             => 'mdr',
    'الماندينغ'                                                                                                           => 'man',
    'المانشو'                                                                                                               => 'mnc',
    'المانيبرى'                                                                                                           => 'mni',
    'الماورية'                                                                                                             => 'mi',
    'المايثيلي'                                                                                                           => 'mai',
    'المصريةالقديمة'                                                                                                 => 'egy',
    'المقدونية'                                                                                                           => 'mk',
    'المنغولية'                                                                                                           => 'mn',
    'المنكية'                                                                                                               => 'gv',
    'الموسي'                                                                                                                 => 'mos',
    'الموكشا'                                                                                                               => 'mdf',
    'المولدوفية'                                                                                                         => 'mo',
    'الموهوك'                                                                                                               => 'moh',
    'الميرانديز'                                                                                                         => 'mwl',
    'الميكماكيونية'                                                                                                   => 'mic',
    'المينانجكاباو'                                                                                                   => 'min',
    'الميند'                                                                                                                 => 'men',
    'النافاجو'                                                                                                             => 'nv',
    'الناهيوتل'                                                                                                           => 'nah',
    'الندونجا'                                                                                                             => 'ng',
    'النديبيلالجنوبى'                                                                                               => 'nr',
    'النديبيلالشمالى'                                                                                               => 'nd',
    'النرويجية'                                                                                                           => 'no',
    'النزيما'                                                                                                               => 'nzi',
    'النواريةالتقليدية'                                                                                           => 'nwc',
    'النوجاى'                                                                                                               => 'nog',
    'النورسالقديم'                                                                                                     => 'non',
    'النورو'                                                                                                                 => 'na',
    'النياس'                                                                                                                 => 'nia',
    'النيامويزى'                                                                                                         => 'nym',
    'النيانجا،التشيتشوا،التشوا'                                                                           => 'ny',
    'النيانكول'                                                                                                           => 'nyn',
    'النيبالية'                                                                                                           => 'ne',
    'النيجركوردوفانايان'                                                                                         => 'nic',
    'النينورسكالنرويجي'                                                                                           => 'nn',
    'النيواري'                                                                                                             => 'new',
    'النيورو'                                                                                                               => 'nyo',
    'النيوي'                                                                                                                 => 'niu',
    'الهايتية'                                                                                                             => 'ht',
    'الهبا'                                                                                                                   => 'hup',
    'الهمونجية'                                                                                                           => 'hmn',
    'الهندية'                                                                                                               => 'hi',
    'الهنديةالأمريكيةالجنوبيةأخرى'                                                                     => 'sai',
    'الهنغارية'                                                                                                           => 'hu',
    'الهوسا'                                                                                                                 => 'ha',
    'الهولندية'                                                                                                           => 'nl',
    'الهولنديةالوسطى'                                                                                               => 'dum',
    'الهيدا'                                                                                                                 => 'hai',
    'الهيرىموتو'                                                                                                         => 'ho',
    'الهيريرو'                                                                                                             => 'hz',
    'الهيليجينون'                                                                                                       => 'hil',
    'الهيماتشالى'                                                                                                       => 'him',
    'الواراى'                                                                                                               => 'war',
    'الواشو'                                                                                                                 => 'was',
    'الوالامو'                                                                                                             => 'wal',
    'الولزية'                                                                                                               => 'cy',
    'الولوف'                                                                                                                 => 'wo',
    'الولونية'                                                                                                             => 'wa',
    'اليابانية'                                                                                                           => 'ja',
    'اليابيز'                                                                                                               => 'yap',
    'الياكت'                                                                                                                 => 'sah',
    'الياو'                                                                                                                   => 'yao',
    'اليجاريتيك'                                                                                                         => 'uga',
    'اليديشية'                                                                                                             => 'yi',
    'اليهوديةالعربية'                                                                                               => 'jrb',
    'اليهوديةالفارسية'                                                                                             => 'jpr',
    'اليوروبية'                                                                                                           => 'yo',
    'اليونانية'                                                                                                           => 'el',
    'اليونانيةالقديمة'                                                                                             => 'grc',
    'انكو'                                                                                                                     => 'nqo',
    'بدونمحتوىلغوي'                                                                                                   => 'zxx',
    'تاىأخرى'                                                                                                               => 'tai',
    'تركيةكريمينية'                                                                                                   => 'crh',
    'تونجاجزرتونجا'                                                                                                   => 'to',
    'تونجانياسا'                                                                                                         => 'tog',
    'سريانيةتقليدية'                                                                                                 => 'syc',
    'سلافيةكنسية'                                                                                                       => 'cu',
    'غيرمحدده'                                                                                                             => 'und',
    'قبطية'                                                                                                                   => 'cop',
    'لغاتالإشارة'                                                                                                       => 'sgn',
    'لغاتالسيويون'                                                                                                     => 'sio',
    'لغاتالمندا'                                                                                                         => 'mun',
    'لغاتالواكاشان'                                                                                                   => 'wak',
    'لغاتساليشان'                                                                                                       => 'sal',
    'لغاتمانوبو'                                                                                                         => 'mno',
    'لغاتمتعددة'                                                                                                         => 'mul',
    'لغاتمتنوعة'                                                                                                         => 'mis',
    'لغةأفروآسيوية'                                                                                                   => 'afa',
    'لغةأهلالهاواى'                                                                                                   => 'haw',
    'لغةأهلجبلطارق'                                                                                                   => 'gil',
    'لغةإيرانية'                                                                                                         => 'ira',
    'لغةإيروكويانية'                                                                                                 => 'iro',
    'لغةالباسك'                                                                                                           => 'eu',
    'لغةالملايو'                                                                                                         => 'ms',
    'لغةتشاميكية'                                                                                                       => 'cmc',
    'لغةجرمانية'                                                                                                         => 'gem',
    'لغةخويسانية'                                                                                                       => 'khi',
    'لغةدرافيدينية'                                                                                                   => 'dra',
    'لغةفينوأجريانية'                                                                                               => 'fiu',
    'لغةقوقازية'                                                                                                         => 'cau',
    'لغةكشيتيكية'                                                                                                       => 'cus',
    'لغةكلتية'                                                                                                             => 'cel',
    'لغةمايا'                                                                                                               => 'myn',
    'لغةمونخمير'                                                                                                         => 'mkh',
    'لغةنوبية'                                                                                                             => 'nub',
    'لغةنيليةصحراوية'                                                                                               => 'ssa',
    'لغةهندأمريكيةشمالية'                                                                                       => 'nai',
    'لغةهندأمريكيةوسطى'                                                                                           => 'cai',
    'لغةهندوأوربية'                                                                                                   => 'ine',
    'لغةهندية'                                                                                                             => 'inc',
    'مونجو'                                                                                                                   => 'lol',
);

1;
