package Locales::DB::Language::he;

# Auto generated from CLDR

$Locales::DB::Language::he::VERSION = '0.01';

$Locales::DB::Language::he::cldr_version = '1.7.1';

%Locales::DB::Language::he::misc_info = (
    'cldr_formats' => {
        'decimal'  => "\#\,\#\#0\.\#\#\#",
        'language' => "\{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent'   => "\#\,\#\#0\%",
        'territory' => "\{0\}"
    },
    'fallback'    => [ 'en' ],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "לא\:ל",
        'yesstr' => "כן\:כ"
    },
);

%Locales::DB::Language::he::code_to_name = (
    'aa'    => 'אפארית',
    'ab'    => 'אבחזית',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'אדיגית',
    'ae'    => 'אבסטן',
    'af'    => 'אפריקאנס',
    'afa'   => "שפה\ אפרו\-אסייתית",
    'afh'   => 'אפריהילי',
    'ain'   => 'אינו',
    'ak'    => 'אקאן',
    'akk'   => 'אכדית',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'אמהרית',
    'an'    => 'Aragonese',
    'ang'   => "אנגלית\ עתיקה",
    'anp'   => 'Angika',
    'apa'   => "שפה\ אפאצ׳ית",
    'ar'    => 'ערבית',
    'arc'   => 'ארמית',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "שפה\ מלאכותית\ אחרת",
    'arw'   => 'Arawak',
    'as'    => 'אסאמית',
    'ast'   => 'אסטורית',
    'ath'   => "Athapascan\ Language",
    'aus'   => "שפה\ אוסטרלית",
    'av'    => 'Avaric',
    'awa'   => 'אוואדית',
    'ay'    => 'איימארית',
    'az'    => 'אזרית',
    'ba'    => 'בשקירית',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => "באלוצ\'י",
    'ban'   => 'בלינזית',
    'bas'   => 'Basa',
    'bat'   => "שפות\ בלטיות",
    'be'    => 'בלארוסית',
    'bej'   => "בז\'ה",
    'bem'   => 'Bemba',
    'ber'   => 'ברברית',
    'bg'    => 'בולגרית',
    'bh'    => 'ביהארי',
    'bho'   => 'Bhojpuri',
    'bi'    => 'ביסלמה',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'בנגלית',
    'bnt'   => 'בנטו',
    'bo'    => 'טיבטית',
    'br'    => 'ברטונית',
    'bra'   => 'Braj',
    'bs'    => 'בוסנית',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'קטלאנית',
    'cad'   => 'קאדו',
    'cai'   => "אינדיאנית\ מרכז\ אמריקאית\ אחרת",
    'car'   => 'Carib',
    'cau'   => "שפה\ קווקזית\ אחרת",
    'cch'   => 'Atsam',
    'ce'    => "צ\'צ\'נית",
    'ceb'   => 'קבואנו',
    'cel'   => "שפה\ קלטית",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => "צ\'אגאטאי",
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => "צ\'רוקי",
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'קורסיקאית',
    'cop'   => 'קופטית',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "טטרית\ של\ קרים",
    'crp'   => "שפה\ קראולית\ או\ פידג\'אנית",
    'cs'    => 'צ׳כית',
    'csb'   => 'Kashubian',
    'cu'    => "סלאבית\ כנסייתית\ עתיקה",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'וולשית',
    'da'    => 'דנית',
    'dak'   => 'דקוטה',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'גרמנית',
    'de_at' => "גרמנית\ אוסטרית",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'דלאוור',
    'den'   => 'סלאבית',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'דוגרי',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "הולנדית\ תיכונה",
    'dv'    => 'דיבהי',
    'dyu'   => 'Dyula',
    'dz'    => 'דזונקה',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "מצרית\ עתיקה",
    'eka'   => 'Ekajuk',
    'el'    => 'יוונית',
    'elx'   => 'עילמית',
    'en'    => 'אנגלית',
    'en_au' => "אנגלית\ אוסטרלית",
    'en_ca' => "אנגלית\ קנדית",
    'en_gb' => "אנגלית\ בריטית",
    'en_us' => "אנגלית\ אמריקנית",
    'enm'   => "אנגלית\ תיכונה",
    'eo'    => 'אספרנטו',
    'es'    => 'ספרדית',
    'es_es' => "ספרדית\ איברית",
    'et'    => 'אסטונית',
    'eu'    => 'בסקית',
    'ewo'   => 'Ewondo',
    'fa'    => 'פרסית',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'פינית',
    'fil'   => 'פיליפינית',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => "פיג\'ית",
    'fo'    => 'פארואזית',
    'fon'   => 'Fon',
    'fr'    => 'צרפתית',
    'fr_ca' => "צרפתית\ קנדית",
    'fr_ch' => "צרפתית\ שוויצרית",
    'frm'   => "צרפתית\ תיכונה",
    'fro'   => "צרפתית\ עתיקה",
    'frr'   => "פריזית\ צפונית",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'פריזית',
    'ga'    => 'אירית',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "גאלית\ סקוטית",
    'gem'   => "גרמאנית\ אחרת",
    'gez'   => 'געז',
    'gil'   => 'Gilbertese',
    'gl'    => 'גליציאנית',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'גוארני',
    'goh'   => "Old\ High\ German",
    'gon'   => 'גונדי',
    'gor'   => 'Gorontalo',
    'got'   => 'גותית',
    'grb'   => 'Grebo',
    'grc'   => "יוונית\ עתיקה",
    'gsw'   => "גרמנית\ שוויצרית",
    'gu'    => "גוג\'ראטית",
    'gv'    => 'מאנית',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'האוסה',
    'hai'   => 'Haida',
    'haw'   => 'הוואית',
    'he'    => 'עברית',
    'hi'    => 'הינדי',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'חיתית',
    'hmn'   => 'Hmong',
    'ho'    => "הארי\ מוטו",
    'hr'    => 'קרואטית',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'האיטית',
    'hu'    => 'הונגרית',
    'hup'   => 'Hupa',
    'hy'    => 'ארמנית',
    'hz'    => 'Herero',
    'ia'    => '‏אינטרלינגואה',
    'iba'   => 'Iban',
    'id'    => 'אינדונזית',
    'ie'    => 'אינטרלינגה',
    'ig'    => 'איגבו',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'יופיק',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "אינדו\-אירופית\ אחרת",
    'inh'   => 'אינגושית',
    'io'    => 'אידו',
    'ira'   => "שפה\ איראנית",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'איסלנדית',
    'it'    => 'איטלקית',
    'iu'    => 'אינוקטיטוט',
    'ja'    => 'יפנית',
    'jbo'   => 'Lojban',
    'jpr'   => "פרסית\ יהודית",
    'jrb'   => "ערבית\ יהודית",
    'jv'    => 'יאוונית',
    'ka'    => 'גיאורגית',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'קבילה',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'קזחית',
    'kl'    => 'קאלאליסוטית',
    'km'    => 'קמרית',
    'kmb'   => 'Kimbundu',
    'kn'    => 'קנאדה',
    'ko'    => 'קוריאנית',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'קשמירית',
    'ku'    => 'כורדית',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'קורנית',
    'ky'    => 'קירגיזית',
    'la'    => 'לטינית',
    'lad'   => 'לדינו',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'לוקסמבורגית',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'לינגלה',
    'lo'    => 'לאית',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ליטאית',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'לטבית',
    'mad'   => 'Madurese',
    'mag'   => 'מאגאהית',
    'mai'   => 'מאיטילית',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => 'אוסטרונזית',
    'mas'   => 'מאסאית',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'מלגשית',
    'mga'   => "אירית\ תיכונה",
    'mh'    => 'Marshallese',
    'mi'    => 'מאורית',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "שפה\ שונה",
    'mk'    => 'מקדונית',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'מלאיאלם',
    'mn'    => 'מונגולית',
    'mnc'   => 'Manchu',
    'mni'   => 'מניפורית',
    'mno'   => "Manobo\ Language",
    'mo'    => 'מולדבית',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'מרטהי',
    'ms'    => 'מלאית',
    'mt'    => 'מלטזית',
    'mul'   => "מספר\ שפות",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'בורמזית',
    'myn'   => 'מאיה',
    'myv'   => 'Erzya',
    'na'    => 'נאורית',
    'nah'   => 'נאהואטל',
    'nai'   => "אינדיאנית\ צפון\ אמריקאית\ אחרת",
    'nap'   => 'נפוליטנית',
    'nb'    => "‏נורבגית\ ספרותית",
    'nd'    => "North\ Ndebele",
    'nds'   => "גרמנית\ תחתית",
    'ne'    => 'נפאלית',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'הולנדית',
    'nl_be' => 'פלמית',
    'nn'    => "נורבגית\ חדשה\ \-\ נינורשק",
    'no'    => 'נורווגית',
    'nog'   => 'Nogai',
    'non'   => "‏נורדית\ עתיקה",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "שפות\ נבטיות",
    'nv'    => 'נבחו',
    'nwc'   => "נווארית\ קלאסית",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'אוקסיטנית',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'אוריה',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "טורקית\ עותומנית",
    'oto'   => "Otomian\ Language",
    'pa'    => "פנג\'אבית",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "פרסית\ עתיקה",
    'phi'   => "פיליפינית\ אחרת",
    'phn'   => 'פניקית',
    'pi'    => 'Pali',
    'pl'    => 'פולנית',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'פאשטו',
    'pt'    => 'פורטוגלית',
    'pt_br' => "פורטוגזית\ ברזילאית",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => "ראג\'סטן",
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'קירונדי',
    'ro'    => 'רומנית',
    'roa'   => "Romance\ Language",
    'rom'   => 'רומאנית',
    'ru'    => 'רוסית',
    'rup'   => 'ארומנית',
    'rw'    => 'קינירואנדה',
    'sa'    => 'סנסקריט',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "שפה\ אינדיאנית\ דרום\ אמריקאית",
    'sal'   => "Salishan\ Language",
    'sam'   => "ארמית\ שומרונית",
    'sas'   => 'Sasak',
    'sat'   => 'סאנטלי',
    'sc'    => 'סרדינית',
    'scn'   => 'סיציליאנית',
    'sco'   => 'סקוטית',
    'sd'    => 'סינדהית',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "שפה\ שמית",
    'sg'    => 'Sango',
    'sga'   => "אירית\ עתיקה",
    'sgn'   => "שפת\ סימנים",
    'sh'    => "סרבו\-קרואטית",
    'shn'   => 'Shan',
    'si'    => 'סינהלה',
    'sid'   => 'סידמו',
    'sio'   => "Siouan\ Language",
    'sit'   => "שפה\ סינו־טיבטית",
    'sk'    => 'סלובקית',
    'sl'    => 'סלובנית',
    'sla'   => "שפה\ סלאבית",
    'sm'    => 'סמואית',
    'sma'   => "Southern\ Sami",
    'smi'   => "שפות\ סאמיות\ אחרות",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'סומלית',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'אלבנית',
    'sr'    => 'סרבית',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'סיסוואטי',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "ססות\'ו",
    'su'    => 'סודנית',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'שומרית',
    'sv'    => 'שוודית',
    'sw'    => 'סווהילית',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'סורית',
    'ta'    => 'טמילית',
    'tai'   => "Tai\ Language",
    'te'    => 'טלוגו',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => "טג\'יקית",
    'th'    => 'תאי',
    'ti'    => 'טיגרינאית',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'טורקמנית',
    'tkl'   => 'Tokelau',
    'tl'    => 'טגלוג',
    'tlh'   => 'קלינגון',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'צוואנה',
    'to'    => 'טונגאית',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'טורקית',
    'trv'   => 'Taroko',
    'ts'    => 'טסונגה',
    'tsi'   => 'Tsimshian',
    'tt'    => 'טטרית',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'טווי',
    'ty'    => 'טהיטית',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'אויגהור',
    'uga'   => 'אוגריתית',
    'uk'    => 'אוקראינית',
    'umb'   => 'Umbundu',
    'und'   => "שפה\ לא\ ידועה\ או\ לא\ תקפה",
    'ur'    => 'אורדו',
    'uz'    => 'אוזבקית',
    'vai'   => 'Vai',
    've'    => 'וונדה',
    'vi'    => 'ויאטנמית',
    'vo'    => '‏וולאפיק',
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => "ג\'ולוף",
    'xal'   => 'Kalmyk',
    'xh'    => 'קסוסה',
    'yao'   => 'Yao',
    'yap'   => 'יאפזית',
    'yi'    => 'יידיש',
    'yo'    => 'יורובה',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'זאפוטק',
    'zbl'   => 'Blissymbols',
    'zen'   => 'זנאגה',
    'zh'    => 'סינית',
    'znd'   => 'Zande',
    'zu'    => 'זולו',
    'zun'   => 'Zuni',
    'zxx'   => "ללא\ תוכן\ לשוני",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::he::name_to_code = (
    ''                                    => 'zu',
    "\ "                                  => 'sla',
    "\ \ "                                => 'zxx',
    "\ \ \ "                              => 'sai',
    "\ \ \ \ \ "                          => 'und',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    'angika'                              => 'anp',
    'aragonese'                           => 'an',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    'avaric'                              => 'av',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'basa'                                => 'bas',
    'batak'                               => 'btk',
    'bemba'                               => 'bem',
    'bhojpuri'                            => 'bho',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'braj'                                => 'bra',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'carib'                               => 'car',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ syriac"                   => 'syc',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "cushitic\ language"                  => 'cus',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'dinka'                               => 'din',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    "finnougrian\ language"               => 'fiu',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'gilbertese'                          => 'gil',
    'gorontalo'                           => 'gor',
    'grebo'                               => 'grb',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ portuguese"                 => 'pt_pt',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "iroquoian\ language"                 => 'iro',
    'jju'                                 => 'kaj',
    'kabardian'                           => 'kbd',
    'kachin'                              => 'kac',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lojban'                              => 'jbo',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'madurese'                            => 'mad',
    'makasar'                             => 'mak',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    "manobo\ language"                    => 'mno',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ high\ german"                => 'gmh',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "munda\ language"                     => 'mun',
    'ndonga'                              => 'ng',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    'nogai'                               => 'nog',
    "north\ ndebele"                      => 'nd',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    "old\ high\ german"                   => 'goh',
    "old\ provenal"                       => 'pro',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'pohnpeian'                           => 'pon',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'quechua'                             => 'qu',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    "romance\ language"                   => 'roa',
    "salishan\ language"                  => 'sal',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sasak'                               => 'sas',
    'selkup'                              => 'sel',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'siksika'                             => 'bla',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'sogdien'                             => 'sog',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'susu'                                => 'sus',
    "swiss\ high\ german"                 => 'de_ch',
    "tai\ language"                       => 'tai',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tsimshian'                           => 'tsi',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'umbundu'                             => 'umb',
    "upper\ sorbian"                      => 'hsb',
    'vai'                                 => 'vai',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zaza'                                => 'zza',
    'zhuang'                              => 'za',
    'zuni'                                => 'zun',
);

1;
