package Locales::DB::Language::gl;

# Auto generated from CLDR

$Locales::DB::Language::gl::VERSION = '0.01';

$Locales::DB::Language::gl::cldr_version = '1.7.1';

%Locales::DB::Language::gl::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'contributed'
        },
        'language' => "Idioma\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent' => {
            'content' => "\#\,\#\#0\%",
            'draft'   => 'contributed'
        },
        'territory' => "Rexión\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "non\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "si\:s",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::gl::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Lingua\ afro\-asiática",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Lingua\ algonquina",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amárico',
    'an'    => 'Aragonés',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Lingua\ apache",
    'ar'    => 'Árabe',
    'arc'   => 'Arameo',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Lingua\ artificial",
    'arw'   => 'Arawak',
    'as'    => 'Assamés',
    'ast'   => 'Asturiano',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Lingua\ australiana",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaiano',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Lingua\ báltica",
    'be'    => 'Bielorruso',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Búlgaro',
    'bh'    => 'Bihariano',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengalí',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Bretón',
    'bra'   => 'Braj',
    'bs'    => 'Bosnio',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalán',
    'cad'   => 'Caddo',
    'cai'   => "Lingua\ india\ centroamericana",
    'car'   => 'Carib',
    'cau'   => "Lingua\ caucásica",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Lingua\ céltica",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Checo',
    'csb'   => 'Kashubian',
    'cu'    => "Eslavo\ eclesiástico",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Galés',
    'da'    => 'Dinamarqués',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Alemán',
    'de_at' => "Alemán\ de\ Austria",
    'de_ch' => "Alemán\ suízo",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Exipcio\ antigo",
    'eka'   => 'Ekajuk',
    'el'    => 'Grego',
    'elx'   => 'Elamite',
    'en'    => 'Inglés',
    'en_au' => "Inglés\ australiano",
    'en_ca' => "Inglés\ canadiano",
    'en_gb' => "Inglés\ británico",
    'en_us' => "Inglés\ americano",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Español',
    'es_es' => 'Castelán',
    'et'    => 'Estoniano',
    'eu'    => 'Éuscaro',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persa',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finés',
    'fil'   => 'Filipino',
    'fiu'   => "Lingua\ finno\-úgrica",
    'fj'    => 'Fijian',
    'fo'    => 'Faroés',
    'fon'   => 'Fon',
    'fr'    => 'Francés',
    'fr_ca' => "Francés\ canadiano",
    'fr_ch' => "Francés\ suízo",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'Frisón',
    'ga'    => 'Irlandés',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaélico\ escocés",
    'gem'   => "Lingua\ xermánica",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galego',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guaraní',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Grego\ antigo",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Guxaratiano',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Hebreo',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Croata',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Húngaro',
    'hup'   => 'Hupa',
    'hy'    => 'Armenio',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesio',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Lingua\ índica",
    'ine'   => "Lingua\ indoeuropea",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Islandés',
    'it'    => 'Italiano',
    'iu'    => 'Inuktitut',
    'ja'    => 'Xaponés',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Xavanés',
    'ka'    => 'Xeorxiano',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Cambodiano',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Coreano',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdo',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgiz',
    'la'    => 'Latín',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Laotiano',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lituano',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Letón',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Lingua\ miscelánea",
    'mk'    => 'Macedonio',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malaialam',
    'mn'    => 'Mongol',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malaio',
    'mt'    => 'Maltés',
    'mul'   => "Varias\ linguas",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "Lingua\ india\ norteamericana",
    'nap'   => 'Neapolitan',
    'nb'    => "Noruegués\ Bokmal",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepalí',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Holandés',
    'nl_be' => 'Flamenco',
    'nn'    => "Noruegués\ nynorsk",
    'no'    => 'Noruegués',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Lingua\ nubia",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitano',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Orissa',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Lingua\ filipina",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Polaco',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => 'Portugués',
    'pt_br' => "Portugués\ brasileiro",
    'pt_pt' => "Portugués\ ibérico",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Romanés',
    'roa'   => "Lingua\ románica",
    'rom'   => 'Romany',
    'ru'    => 'Ruso',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sánscrito',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "Lingua\ india\ sudamericana",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Lingua\ semita",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Lingua\ de\ signos",
    'sh'    => 'Serbocroata',
    'shn'   => 'Shan',
    'si'    => 'Sinhalés',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Eslovaco',
    'sl'    => 'Esloveno',
    'sla'   => "Lingua\ eslávica",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somalí',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanés',
    'sr'    => 'Serbio',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Lingua\ do\ Nilo\-Sáhara",
    'st'    => 'Sesotho',
    'su'    => 'Sondanés',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sueco',
    'sw'    => 'Suaxili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Tailandés',
    'ti'    => 'Tigriña',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalo',
    'tlh'   => 'Clingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turco',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Lingua\ altaica",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Ucraíno',
    'umb'   => 'Umbundu',
    'und'   => "Lingua\ descoñecida\ ou\ non\ válida",
    'ur'    => 'Urdú',
    'uz'    => 'Uzbeco',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamita',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinés',
    'znd'   => 'Zande',
    'zu'    => 'Zulú',
    'zun'   => 'Zuni',
    'zxx'   => "Sen\ contido\ lingüístico",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::gl::name_to_code = (
    'abkhazian'                           => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'albans'                              => 'sq',
    'alemn'                               => 'de',
    "alemn\ de\ austria"                  => 'de_at',
    "alemn\ suzo"                         => 'de_ch',
    'aleut'                               => 'ale',
    'amrico'                              => 'am',
    'angika'                              => 'anp',
    'aragons'                             => 'an',
    'arameo'                              => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'armenio'                             => 'hy',
    'aromanian'                           => 'rup',
    'assams'                              => 'as',
    'asturiano'                           => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'azerbaiano'                          => 'az',
    'balinese'                            => 'ban',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'bashkir'                             => 'ba',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'bengal'                              => 'bn',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bielorruso'                          => 'be',
    'bihariano'                           => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blgaro'                              => 'bg',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'bosnio'                              => 'bs',
    'braj'                                => 'bra',
    'bretn'                               => 'br',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'burmese'                             => 'my',
    'caddo'                               => 'cad',
    'cambodiano'                          => 'km',
    'carib'                               => 'car',
    'casteln'                             => 'es_es',
    'cataln'                              => 'ca',
    'cebuano'                             => 'ceb',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'checo'                               => 'cs',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chins'                               => 'zh',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'clingon'                             => 'tlh',
    'coptic'                              => 'cop',
    'coreano'                             => 'ko',
    'cornish'                             => 'kw',
    'corsican'                            => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    'croata'                              => 'hr',
    "cushitic\ language"                  => 'cus',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinamarqus'                          => 'da',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    "eslavo\ eclesistico"                 => 'cu',
    'eslovaco'                            => 'sk',
    'esloveno'                            => 'sl',
    'espaol'                              => 'es',
    'esperanto'                           => 'eo',
    'estoniano'                           => 'et',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    "exipcio\ antigo"                     => 'egy',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'faros'                               => 'fo',
    'fijian'                              => 'fj',
    'filipino'                            => 'fil',
    'fins'                                => 'fi',
    'flamenco'                            => 'nl_be',
    'fon'                                 => 'fon',
    'francs'                              => 'fr',
    "francs\ canadiano"                   => 'fr_ca',
    "francs\ suzo"                        => 'fr_ch',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'frisn'                               => 'fy',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'galego'                              => 'gl',
    "galico\ escocs"                      => 'gd',
    'gals'                                => 'cy',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'grego'                               => 'el',
    "grego\ antigo"                       => 'grc',
    'guaran'                              => 'gn',
    'guxaratiano'                         => 'gu',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'hawaiian'                            => 'haw',
    'hebreo'                              => 'he',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hngaro'                              => 'hu',
    'holands'                             => 'nl',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    'indonesio'                           => 'id',
    'ingls'                               => 'en',
    "ingls\ americano"                    => 'en_us',
    "ingls\ australiano"                  => 'en_au',
    "ingls\ britnico"                     => 'en_gb',
    "ingls\ canadiano"                    => 'en_ca',
    'ingush'                              => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    "iranian\ language"                   => 'ira',
    'irlands'                             => 'ga',
    "iroquoian\ language"                 => 'iro',
    'islands'                             => 'is',
    'italiano'                            => 'it',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kannada'                             => 'kn',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashmiri'                            => 'ks',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'kazakh'                              => 'kk',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurdo'                               => 'ku',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'kyrgiz'                              => 'ky',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'laotiano'                            => 'lo',
    'latn'                                => 'la',
    'letn'                                => 'lv',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lingala'                             => 'ln',
    "lingua\ afroasitica"                 => 'afa',
    "lingua\ algonquina"                  => 'alg',
    "lingua\ altaica"                     => 'tut',
    "lingua\ apache"                      => 'apa',
    "lingua\ artificial"                  => 'art',
    "lingua\ australiana"                 => 'aus',
    "lingua\ bltica"                      => 'bat',
    "lingua\ caucsica"                    => 'cau',
    "lingua\ cltica"                      => 'cel',
    "lingua\ de\ signos"                  => 'sgn',
    "lingua\ descoecida\ ou\ non\ vlida"  => 'und',
    "lingua\ do\ niloshara"               => 'ssa',
    "lingua\ eslvica"                     => 'sla',
    "lingua\ filipina"                    => 'phi',
    "lingua\ finnogrica"                  => 'fiu',
    "lingua\ india\ centroamericana"      => 'cai',
    "lingua\ india\ norteamericana"       => 'nai',
    "lingua\ india\ sudamericana"         => 'sai',
    "lingua\ indoeuropea"                 => 'ine',
    "lingua\ miscelnea"                   => 'mis',
    "lingua\ ndica"                       => 'inc',
    "lingua\ nubia"                       => 'nub',
    "lingua\ romnica"                     => 'roa',
    "lingua\ semita"                      => 'sem',
    "lingua\ xermnica"                    => 'gem',
    'lituano'                             => 'lt',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'macedonio'                           => 'mk',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malagasy'                            => 'mg',
    'malaialam'                           => 'ml',
    'malaio'                              => 'ms',
    'malts'                               => 'mt',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavian'                           => 'mo',
    'mongo'                               => 'lol',
    'mongol'                              => 'mn',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'nepal'                               => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    'nogai'                               => 'nog',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    'noruegus'                            => 'no',
    "noruegus\ bokmal"                    => 'nb',
    "noruegus\ nynorsk"                   => 'nn',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'occitano'                            => 'oc',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'orissa'                              => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'pashto'                              => 'ps',
    'persa'                               => 'fa',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    'polaco'                              => 'pl',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    'portugus'                            => 'pt',
    "portugus\ brasileiro"                => 'pt_br',
    "portugus\ ibrico"                    => 'pt_pt',
    "prakrit\ language"                   => 'pra',
    'punjabi'                             => 'pa',
    'quechua'                             => 'qu',
    'rabe'                                => 'ar',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    'romans'                              => 'ro',
    'romany'                              => 'rom',
    'rundi'                               => 'rn',
    'ruso'                                => 'ru',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samoan'                              => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "sen\ contido\ lingstico"             => 'zxx',
    'serbio'                              => 'sr',
    'serbocroata'                         => 'sh',
    'serer'                               => 'srr',
    'sesotho'                             => 'st',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    'sinhals'                             => 'si',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    'snscrito'                            => 'sa',
    'sogdien'                             => 'sog',
    'somal'                               => 'so',
    'sondans'                             => 'su',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'suaxili'                             => 'sw',
    'sueco'                               => 'sv',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'susu'                                => 'sus',
    'swati'                               => 'ss',
    "swiss\ german"                       => 'gsw',
    'syriac'                              => 'syr',
    'tagalo'                              => 'tl',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tailands'                            => 'th',
    'tajik'                               => 'tg',
    'tamashek'                            => 'tmh',
    'tamil'                               => 'ta',
    'taroko'                              => 'trv',
    'tatar'                               => 'tt',
    'telugu'                              => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tibetan'                             => 'bo',
    'tigre'                               => 'tig',
    'tigria'                              => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'turco'                               => 'tr',
    'turkmen'                             => 'tk',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'ucrano'                              => 'uk',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'uighur'                              => 'ug',
    'umbundu'                             => 'umb',
    "upper\ sorbian"                      => 'hsb',
    'urd'                                 => 'ur',
    'uscaro'                              => 'eu',
    'uzbeco'                              => 'uz',
    'vai'                                 => 'vai',
    "varias\ linguas"                     => 'mul',
    'venda'                               => 've',
    'vietnamita'                          => 'vi',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'xapons'                              => 'ja',
    'xavans'                              => 'jv',
    'xeorxiano'                           => 'ka',
    'xhosa'                               => 'xh',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    'yiddish'                             => 'yi',
    'yoruba'                              => 'yo',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zul'                                 => 'zu',
    'zuni'                                => 'zun',
);

1;
