package DateTime::Format::Japanese::Era;
use strict;
use DateTime::Calendar::Japanese::Era;
use Encode();

our %ERA_NAME2ID;
our %ERA_ID2NAME;

# we go through this interface to automatically detect duplicates
sub register_era
{
    my($jp, $id) = @_;

    my $utf8 = Encode::is_utf8($jp) ? $jp : Encode::decode('euc-jp', $jp);

    if (exists $ERA_NAME2ID{$utf8}) {
        Carp::croak("Era name '$jp' already exists. Cowardly refusing to proceed");
    }
    if (exists $ERA_ID2NAME{$id}) {
        Carp::croak("Era id '$id' already exists. Cowardly refusing to proceed");
    }
    $ERA_NAME2ID{$utf8} = $id;
    $ERA_ID2NAME{$id} = $utf8;
}

sub lookup_by_name
{
    my $era_name = shift;
    return
        DateTime::Calendar::Japanese::Era->lookup_by_id(id => $ERA_NAME2ID{ $era_name});
}

sub lookup_name_by_id
{
    my $era_id = shift;
    return $ERA_ID2NAME{ $era_id };
}

BEGIN
{

    register_era("粽", DateTime::Calendar::Japanese::Era::TAIKA());
    register_era("", DateTime::Calendar::Japanese::Era::HAKUCHI());
    register_era("Ļ", DateTime::Calendar::Japanese::Era::SHUCHOU());
    register_era("", DateTime::Calendar::Japanese::Era::TAIHOU());
    register_era("ı", DateTime::Calendar::Japanese::Era::KEIUN());
    register_era("Ƽ", DateTime::Calendar::Japanese::Era::WADOU());
    register_era("", DateTime::Calendar::Japanese::Era::REIKI());
    register_era("Ϸ", DateTime::Calendar::Japanese::Era::YOUROU());
    register_era("", DateTime::Calendar::Japanese::Era::JINKI());
    register_era("ŷʿ", DateTime::Calendar::Japanese::Era::TENPYOU());
    register_era("ŷʿ", DateTime::Calendar::Japanese::Era::TENPYOUKANPOU());
    register_era("ŷʿ", DateTime::Calendar::Japanese::Era::TENPYOUSHOUHOU());
    register_era("ŷʿ", DateTime::Calendar::Japanese::Era::TENPYOUJOUJI());
    register_era("ŷʿ", DateTime::Calendar::Japanese::Era::TENPYOUJINGO());
    register_era("ʱ", DateTime::Calendar::Japanese::Era::JINGOKEIUN());
    register_era("", DateTime::Calendar::Japanese::Era::HOUKI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNOU());
    register_era("", DateTime::Calendar::Japanese::Era::ENRYAKU());
    register_era("Ʊ", DateTime::Calendar::Japanese::Era::DAIDOU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUNIN());
    register_era("ŷĹ", DateTime::Calendar::Japanese::Era::TENCHOU());
    register_era("", DateTime::Calendar::Japanese::Era::JOUWA1());
    register_era("ž", DateTime::Calendar::Japanese::Era::KASHOU());
    register_era("μ", DateTime::Calendar::Japanese::Era::NINJU());
    register_era("ƹ", DateTime::Calendar::Japanese::Era::SAIKOU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNAN());
    register_era("", DateTime::Calendar::Japanese::Era::JOUGAN());
    register_era("", DateTime::Calendar::Japanese::Era::GANGYOU());
    register_era("", DateTime::Calendar::Japanese::Era::NINNA());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::KANPYOU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUTAI());
    register_era("", DateTime::Calendar::Japanese::Era::ENGI());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::ENCHOU());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::JOUHEI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENGYOU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENRYAKU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::OUWA());
    register_era("", DateTime::Calendar::Japanese::Era::KOUHOU());
    register_era("", DateTime::Calendar::Japanese::Era::ANNA());
    register_era("ŷϽ", DateTime::Calendar::Japanese::Era::TENROKU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNEN());
    register_era("縵", DateTime::Calendar::Japanese::Era::JOUGEN1());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENGEN());
    register_era("ʴ", DateTime::Calendar::Japanese::Era::EIKAN());
    register_era("", DateTime::Calendar::Japanese::Era::KANNA());
    register_era("ʱ", DateTime::Calendar::Japanese::Era::EIEN());
    register_era("", DateTime::Calendar::Japanese::Era::EISO());
    register_era("", DateTime::Calendar::Japanese::Era::SHOURYAKU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUTOKU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUHOU());
    register_era("", DateTime::Calendar::Japanese::Era::KANKOU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUWA());
    register_era("", DateTime::Calendar::Japanese::Era::KANNIN());
    register_era("", DateTime::Calendar::Japanese::Era::JIAN());
    register_era("", DateTime::Calendar::Japanese::Era::MANJU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUGEN());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOURYAKU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUKYU());
    register_era("", DateTime::Calendar::Japanese::Era::KANTOKU());
    register_era("ʾ", DateTime::Calendar::Japanese::Era::EISHOU1());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENGI());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::KOUHEI());
    register_era("", DateTime::Calendar::Japanese::Era::JIRYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::ENKYUU());
    register_era("", DateTime::Calendar::Japanese::Era::JOUHOU());
    register_era("", DateTime::Calendar::Japanese::Era::JOURYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::EIHOU());
    register_era("", DateTime::Calendar::Japanese::Era::OUTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::KANJI());
    register_era("", DateTime::Calendar::Japanese::Era::KAHOU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::EICHOU());
    register_era("", DateTime::Calendar::Japanese::Era::JOUTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUWA());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUJI());
    register_era("ž", DateTime::Calendar::Japanese::Era::KAJOU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNIN());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNEI());
    register_era("ʵ", DateTime::Calendar::Japanese::Era::EIKYU());
    register_era("", DateTime::Calendar::Japanese::Era::GENNEI());
    register_era("ݰ", DateTime::Calendar::Japanese::Era::HOUAN());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENJI());
    register_era("缣", DateTime::Calendar::Japanese::Era::DAIJI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENSHOU1());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUSHOU());
    register_era("ݱ", DateTime::Calendar::Japanese::Era::HOUEN());
    register_era("ʼ", DateTime::Calendar::Japanese::Era::EIJI());
    register_era("", DateTime::Calendar::Japanese::Era::KOUJI1());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNYOU());
    register_era("װ", DateTime::Calendar::Japanese::Era::KYUAN());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::NINPEI());
    register_era("׼", DateTime::Calendar::Japanese::Era::KYUJU());
    register_era("ݸ", DateTime::Calendar::Japanese::Era::HOUGEN());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::HEIJI());
    register_era("", DateTime::Calendar::Japanese::Era::EIRYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::OUHOU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUKAN());
    register_era("", DateTime::Calendar::Japanese::Era::EIMAN());
    register_era("ΰ", DateTime::Calendar::Japanese::Era::NINNAN());
    register_era("ű", DateTime::Calendar::Japanese::Era::KAOU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUAN1());
    register_era("¸", DateTime::Calendar::Japanese::Era::ANGEN());
    register_era("", DateTime::Calendar::Japanese::Era::JISHOU());
    register_era("", DateTime::Calendar::Japanese::Era::YOUWA());
    register_era("", DateTime::Calendar::Japanese::Era::JUEI());
    register_era("", DateTime::Calendar::Japanese::Era::GENRYAKU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNJI());
    register_era("", DateTime::Calendar::Japanese::Era::KENKYU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUJI());
    register_era("", DateTime::Calendar::Japanese::Era::KENNIN());
    register_era("", DateTime::Calendar::Japanese::Era::GENKYU());
    register_era("", DateTime::Calendar::Japanese::Era::KENNEI());
    register_era("", DateTime::Calendar::Japanese::Era::JOUGEN2());
    register_era("", DateTime::Calendar::Japanese::Era::KENRYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::KENPOU());
    register_era("", DateTime::Calendar::Japanese::Era::JOUKYU());
    register_era("", DateTime::Calendar::Japanese::Era::JOUOU1());
    register_era("", DateTime::Calendar::Japanese::Era::GENNIN());
    register_era("Ͻ", DateTime::Calendar::Japanese::Era::KAROKU());
    register_era("", DateTime::Calendar::Japanese::Era::ANTEI());
    register_era("", DateTime::Calendar::Japanese::Era::KANKI());
    register_era("", DateTime::Calendar::Japanese::Era::JOUEI());
    register_era("ŷʡ", DateTime::Calendar::Japanese::Era::TENPUKU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNRYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::KATEI());
    register_era("", DateTime::Calendar::Japanese::Era::RYAKUNIN());
    register_era("", DateTime::Calendar::Japanese::Era::ENNOU());
    register_era("μ", DateTime::Calendar::Japanese::Era::NINJI());
    register_era("", DateTime::Calendar::Japanese::Era::KANGEN());
    register_era("", DateTime::Calendar::Japanese::Era::HOUJI());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::KENCHOU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUGEN());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUKA());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUGEN());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNNOU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::KOUCHOU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNNEI());
    register_era("", DateTime::Calendar::Japanese::Era::KENJI());
    register_era("", DateTime::Calendar::Japanese::Era::KOUAN1());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUOU());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::EININ());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUAN2());
    register_era("", DateTime::Calendar::Japanese::Era::KENGEN());
    register_era("Ÿ", DateTime::Calendar::Japanese::Era::KAGEN());
    register_era("", DateTime::Calendar::Japanese::Era::TOKUJI());
    register_era("", DateTime::Calendar::Japanese::Era::ENKYOU1());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::OUCHOU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUWA1());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNPOU());
    register_era("", DateTime::Calendar::Japanese::Era::GENNOU());
    register_era("", DateTime::Calendar::Japanese::Era::GENKOU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUCHU());
    register_era("", DateTime::Calendar::Japanese::Era::KARYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::GENTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUKEI());
    register_era("", DateTime::Calendar::Japanese::Era::RYAKUOU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUEI());
    register_era("", DateTime::Calendar::Japanese::Era::JOUWA2());
    register_era("ѱ", DateTime::Calendar::Japanese::Era::KANNOU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNNNA());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::ENBUN());
    register_era("", DateTime::Calendar::Japanese::Era::KOUAN2());
    register_era("缣", DateTime::Calendar::Japanese::Era::JOUJI());
    register_era("", DateTime::Calendar::Japanese::Era::OUAN());
    register_era("", DateTime::Calendar::Japanese::Era::EIWA());
    register_era("", DateTime::Calendar::Japanese::Era::KOURYAKU());
    register_era("", DateTime::Calendar::Japanese::Era::EITOKU());
    register_era("", DateTime::Calendar::Japanese::Era::SHITOKU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::KAKEI());
    register_era("", DateTime::Calendar::Japanese::Era::KOUOU());
    register_era("", DateTime::Calendar::Japanese::Era::MEITOKU());
    register_era("", DateTime::Calendar::Japanese::Era::OUEI());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::SHOUCHOU());
    register_era("ʵ", DateTime::Calendar::Japanese::Era::EIKYOU());
    register_era("ŵ", DateTime::Calendar::Japanese::Era::KAKITSU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNNAN());
    register_era("", DateTime::Calendar::Japanese::Era::HOUTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::KYOUTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUSHOU());
    register_era("ĹϽ", DateTime::Calendar::Japanese::Era::CHOUROKU());
    register_era("", DateTime::Calendar::Japanese::Era::KANSHOU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNSHOU());
    register_era("", DateTime::Calendar::Japanese::Era::OUNIN());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNMEI());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::CHOUKYOU());
    register_era("", DateTime::Calendar::Japanese::Era::ENTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::MEIOU());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNKI());
    register_era("", DateTime::Calendar::Japanese::Era::EISHOU2());
    register_era("", DateTime::Calendar::Japanese::Era::DAIEI());
    register_era("Ͻ", DateTime::Calendar::Japanese::Era::KYOUROKU());
    register_era("ŷʸ", DateTime::Calendar::Japanese::Era::TENBUN());
    register_era("", DateTime::Calendar::Japanese::Era::KOUJI2());
    register_era("Ͻ", DateTime::Calendar::Japanese::Era::EIROKU());
    register_era("", DateTime::Calendar::Japanese::Era::GENKI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENSHOU2());
    register_era("ʸϽ", DateTime::Calendar::Japanese::Era::BUNROKU());
    register_era("Ĺ", DateTime::Calendar::Japanese::Era::KEICHOU());
    register_era("", DateTime::Calendar::Japanese::Era::GENNA());
    register_era("", DateTime::Calendar::Japanese::Era::KANNEI());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUHOU());
    register_era("İ", DateTime::Calendar::Japanese::Era::KEIAN());
    register_era("", DateTime::Calendar::Japanese::Era::JOUOU2());
    register_era("", DateTime::Calendar::Japanese::Era::MEIREKI());
    register_era("", DateTime::Calendar::Japanese::Era::MANJI());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::KANBUN());
    register_era("", DateTime::Calendar::Japanese::Era::ENPOU());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENNA());
    register_era("", DateTime::Calendar::Japanese::Era::JOUKYOU());
    register_era("Ͻ", DateTime::Calendar::Japanese::Era::GENROKU());
    register_era("", DateTime::Calendar::Japanese::Era::HOUEI());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUTOKU());
    register_era("", DateTime::Calendar::Japanese::Era::KYOUHO());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::GENBUN());
    register_era("", DateTime::Calendar::Japanese::Era::KANPOU());
    register_era("", DateTime::Calendar::Japanese::Era::ENKYOU2());
    register_era("", DateTime::Calendar::Japanese::Era::KANNEN());
    register_era("", DateTime::Calendar::Japanese::Era::HOUREKI());
    register_era("", DateTime::Calendar::Japanese::Era::MEIWA());
    register_era("±", DateTime::Calendar::Japanese::Era::ANNEI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENMEI());
    register_era("", DateTime::Calendar::Japanese::Era::KANSEI());
    register_era("", DateTime::Calendar::Japanese::Era::KYOUWA());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNKA());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNSEI());
    register_era("ŷ", DateTime::Calendar::Japanese::Era::TENPOU());
    register_era("", DateTime::Calendar::Japanese::Era::KOUKA());
    register_era("ű", DateTime::Calendar::Japanese::Era::KAEI());
    register_era("", DateTime::Calendar::Japanese::Era::ANSEI());
    register_era("", DateTime::Calendar::Japanese::Era::MANNEI());
    register_era("ʸ", DateTime::Calendar::Japanese::Era::BUNKYU());
    register_era("", DateTime::Calendar::Japanese::Era::GENJI());
    register_era("ı", DateTime::Calendar::Japanese::Era::KEIOU());
    register_era("", DateTime::Calendar::Japanese::Era::MEIJI());
    register_era("", DateTime::Calendar::Japanese::Era::TAISHO());
    register_era("", DateTime::Calendar::Japanese::Era::SHOUWA2());
    register_era("ʿ", DateTime::Calendar::Japanese::Era::HEISEI());
}

1;
