# ABSTRACT: A Net::Object::Peer Subscription for an ephemeral peer
package Net::Object::Peer::Subscription::Ephemeral;

use 5.10.0;
use strict;
use warnings;

our $VERSION = '0.05'; # TRIAL

use Moo;
extends 'Net::Object::Peer::Subscription';

has '+peer' => ( is => 'ro', weak_ref => 0 );

1;
#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::Subscription::Ephemeral - A Net::Object::Peer Subscription for an ephemeral peer

=head1 VERSION

version 0.05

=head1 DESCRIPTION

A B<Net::Object::Peer::Subscription::Ephemeral> object manages a
node's subscription to an ephemeral emitter.  It keeps a strong
reference to the emitter so that the emitter does not disappear after
it's defining scope is been destroyed.

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod A B<Net::Object::Peer::Subscription::Ephemeral> object manages a
#pod node's subscription to an ephemeral emitter.  It keeps a strong
#pod reference to the emitter so that the emitter does not disappear after
#pod it's defining scope is been destroyed.
#pod
#pod
