# ABSTRACT: A Net::Object::Peer Subscription
package Net::Object::Peer::Subscription;

use 5.10.0;
use strict;
use warnings;

our $VERSION = '0.02'; # TRIAL

use Types::Standard qw[ ConsumerOf Str CodeRef ];
use namespace::clean;

use Moo;


#pod =attr peer
#pod
#pod =cut

has peer => (
    is       => 'ro',
    weak_ref => 1,
    required => 1,
    isa      => ConsumerOf ['Net::Object::Peer'],
);

#pod =attr name
#pod
#pod =cut

has name => (
    is       => 'ro',
    isa      => Str,
    required => 1,
);

has _unsubscribe => (
    is       => 'ro',
    init_arg => 'unsubscribe',
    isa      => CodeRef,
    required => 1,
);

#pod =method unsubscribe
#pod
#pod =cut

sub unsubscribe { $_[0]->_unsubscribe->() }

1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::Subscription - A Net::Object::Peer Subscription

=head1 VERSION

version 0.02

=head1 DESCRIPTION

A B<Net::Object::Peer::Subscription> object manages a node's
subscription to an emitter.

=head1 ATTRIBUTES

=head2 peer

=head2 name

=head1 METHODS

=head2 unsubscribe

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod A B<Net::Object::Peer::Subscription> object manages a node's
#pod subscription to an emitter.
