/*                                                                
**  Copyright (C) 1996,2007,2010,2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* range.h
**/

#ifndef _RANGE_H
#define _RANGE_H


typedef struct _Check
{
  union
  {
    double dalign;
    char valu[144];
  } v;
  int oper;
} Check;

typedef struct _Range
{
  VType type;
  int nval;
  int nalo;
  char *str;
  Check check[1];
} Range;


#define PRange_EQ	1
#define PRange_NE	2
#define PRange_GT	3
#define PRange_GE	4
#define PRange_LT	5
#define PRange_LE	6

Value *VRange (ParamFile pfile, Parameter * param, Value * value);

Value *VInRange (Range * range, Value * value);

Value *PRangeMinMax (Value * value, Value * min, Value * max);

int VIsNotRange (Value * value);

Range *RangeNew (VType type);

Range *RangeAdd (Range * range, void *value, int oper);

void *Range2String (Range * range, char *string);

#endif /* ! _RANGE_H */
