package MyApp;
use Mojo::Base 'Mojolicious';

use MyApp::Model::Users;

use File::Basename 'dirname';
use File::Spec::Functions 'catdir';

# Every CPAN module needs a version
our $VERSION = '0.01';

sub startup {
    my $self = shift;

    $self->secrets( ['Mojolicious rocks'] );
    $self->helper( users => sub { state $users = MyApp::Model::Users->new } );

    # Switch to installable home directory
    $self->home->parse( catdir( dirname(__FILE__), 'MyApp' ) );

    # Switch to installable "public" directory
    $self->static->paths->[0] = $self->home->rel_dir('public');

    # Switch to installable "templates" directory
    $self->renderer->paths->[0] = $self->home->rel_dir('templates');

    $self->plugin('PODRenderer');

    my $r = $self->routes;
    $r->any('/')->to('login#index')->name('index');

    my $logged_in = $r->under('/')->to('login#logged_in');
    $logged_in->get('/protected')->to('login#protected');

    $r->get('/logout')->to('login#logout');
}

1;
