package Catan::Event::Monopoly;
$Catan::Event::Monopoly::VERSION = '0.03';
use strict;
use warnings;
use Catan::Game::Trade;

sub new { bless {}, shift }

sub calculate
{
  my ($self, $player_number, $code, $players, $bank) = @_;
  die 'calculate requires a player number, resource code and players arrayref'
    unless $player_number && $code && $players && ref $players eq 'ARRAY';

  # loop through all other players and trade away their resource to the player
  my %resources_summary = ();
  for my $losing_player (@$players)
  {
    next if $losing_player->number == $player_number;
    if (my $amount = $losing_player->resources->{$code})
    {
      my $trade = Catan::Game::Trade->new($bank, $players, {
        $player_number => { $code => $amount },
        $losing_player->number => { $code => -$amount },
      });
      my $resources = $trade->execute;
      for my $k (keys %$resources)
      {
        $resources_summary{$k}{$code} += $resources->{$k}{$code};
      }
    }
  }
  return \%resources_summary;
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Event::Monopoly

=head1 VERSION

version 0.03

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
