package Catan::Asset::City;
$Catan::Asset::City::VERSION = '0.03';
use strict;
use warnings;
use Catan::Resource::Ore;
use Catan::Resource::Grain;

sub new
{
  my ($class, $location) = @_;

  die __PACKAGE__ . 'new requires a location argument'
    unless $location && $location->isa('Catan::Map::Intersection');

  return bless {
    location => $location,
    code     => 'C',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Catan::Resource::Ore->new(-3),
    Catan::Resource::Grain->new(-2),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Asset::City

=head1 VERSION

version 0.03

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
