use strict;
use warnings;
use utf8;

package SDK::SoundCloud::HTTP;

use Moo::Role;
use namespace::clean;

use LWP::UserAgent;
use HTTP::Headers;
use URI::Query;
use JSON;

requires 'client_id';

has 'url' => (
    is      => 'ro',
    default => sub {
        return 'https://api.soundcloud.com';
    }
);

has 'lwp' => (
    is      => 'ro',
    builder => sub {
        return LWP::UserAgent->new();
    }
);

has 'token' => ( is => 'rw' );

sub build_query {
    my ( $self, $params ) = @_;

    my $q_string = eval { URI::Query->new($params)->stringify };

    warn $@ if $@;

    return '?' . $q_string;
}

sub _build_headers {
    my ( $self, $length, $extra_headers ) = @_;

    $length ||= 0;

    my $headers = HTTP::Headers->new;

    $headers->header( 'Content-Type' => 'Application/json' );

    $headers->header( 'Content-Length' => $length );

    $headers->header( 'Authorization' => "OAuth " . $self->token )
      if $self->token;

    map { $headers->header( $_ => $extra_headers->{$_} ) } %$extra_headers
      if ref $extra_headers eq 'HASH';

    return $headers;
}

sub req {
    my ( $self, $params ) = @_;

    #method, path, query, headers, data
    $params->{method} ||= 'GET';

    $params->{url} ||= $self->url;

    $params->{path} = $params->{url} . $params->{path};

    $params->{path} .= $self->build_query( $params->{query} )
      if $params->{query};

    $params->{data} = to_json $params->{data} if $params->{data};

    my $headers = $self->_build_headers( length($params->{data}), $params->{headers} );

    my $request = HTTP::Request->new(
        $params->{method}, $params->{path}, $headers, $params->{data}
    );

    my $response = $self->lwp->request($request);

    return $response->is_success
      ? from_json $response->content
      : { error => $response->message . ' ' . $response->code };

}

1;
