#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;
use Time::Zone::Olson();
use POSIX();
use Config;
use Time::Local();
use Encode();

$ENV{PATH} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

my $perl_date = 0;
my $bsd_date = 0;
my $test_gnu_date = `TZ="Australia/Melbourne" date -d "2015/02/28 11:00:00" +"%Y/%m/%d %H:%M:%S" 2>&1`;
chomp $test_gnu_date;
if (($test_gnu_date) && ($test_gnu_date eq '2015/02/28 11:00:00')) {
} else {
	my $test_bsd_date = `TZ="Australia/Melbourne" date -r 1425081600 +"%Y/%m/%d %H:%M:%S" 2>&1`;
	chomp $test_bsd_date;
	if (($test_bsd_date) && ($test_bsd_date eq '2015/02/28 11:00:00')) {
		$bsd_date = 1;
	} else {
		$perl_date = 1;
	}
}

$ENV{TZ} ||= 'Australia/Melbourne';
my $zoneinfo = Time::Zone::Olson->new();
ok($zoneinfo, "Time::Zone::Olson->new() generates an object");
ok($zoneinfo->directory() eq '/usr/share/zoneinfo', "\$zoneinfo->directory() returns the correct directory");
ok($zoneinfo->timezone() =~ /^\w+(\/\w+)?$/, "\$zoneinfo->timezone() parses correctly");
ok((grep /^Australia$/, $zoneinfo->areas()), "Found 'Australia' in \$zoneinfo->areas()");
ok((grep /^Melbourne$/, $zoneinfo->locations('Australia')), "Found 'Melbourne' in \$zoneinfo->areas('Australia')");
ok($zoneinfo->comment('Australia/Melbourne') eq 'Victoria', "\$zoneinfo->comment('Australia/Melbourne') returns 'Victoria'");
foreach my $area ($zoneinfo->areas()) {
	foreach my $location ($zoneinfo->locations($area)) {
		if ( $ENV{RELEASE_TESTING} ) {
		} else {
			next if ("$area/$location" ne $ENV{TZ});
		}
		$zoneinfo->timezone("$area/$location");
		my $transition_time_index = 0;
		foreach my $transition_time ($zoneinfo->transition_times()) {
			if (($Config{archname} !~ /64/) && ($transition_time > (2 ** 31) - 1)) {
			} elsif (($Config{archname} !~ /64/) && ($transition_time < -2 ** 31)) {
			} else {
				eval { gmtime $transition_time } or do { next };
				my $correct_date = get_external_date($area, $location, $transition_time);
				my $test_date = POSIX::strftime("%Y/%m/%d %H:%M:%S", $zoneinfo->local_time($transition_time));
				ok($test_date eq $correct_date, "Matched $test_date to $correct_date for $area/$location for \$zoneinfo->local_time");
				my $revert_time = $zoneinfo->time_local($zoneinfo->local_time($transition_time));
				my $revert_date = get_external_date($area, $location, $revert_time);
				ok($revert_date eq $correct_date, "Matched $revert_date to $correct_date for $area/$location for \$zoneinfo->time_local");
				$transition_time -= 1;
				$correct_date = get_external_date($area, $location, $transition_time);
				$test_date = POSIX::strftime("%Y/%m/%d %H:%M:%S", $zoneinfo->local_time($transition_time));
				ok($test_date eq $correct_date, "Matched $test_date to $correct_date for $area/$location for \$zoneinfo->local_time - 1");
				$revert_time = $zoneinfo->time_local($zoneinfo->local_time($transition_time));
				$revert_date = get_external_date($area, $location, $revert_time);
				ok($revert_date eq $correct_date, "Matched $revert_date to $correct_date for $area/$location for \$zoneinfo->time_local - 1");
				$transition_time += 2;
				$correct_date = get_external_date($area, $location, $transition_time);
				$test_date = POSIX::strftime("%Y/%m/%d %H:%M:%S", $zoneinfo->local_time($transition_time));
				ok($test_date eq $correct_date, "Matched $test_date to $correct_date for $area/$location for \$zoneinfo->local_time + 1");
				$revert_time = $zoneinfo->time_local($zoneinfo->local_time($transition_time));
				$revert_date = get_external_date($area, $location, $revert_time);
				ok($revert_date eq $correct_date, "Matched $revert_date to $correct_date for $area/$location for \$zoneinfo->time_local + 1");
				$transition_time_index += 1;
			}
		}
	}
}

sub get_external_date {
	my ($area, $location, $unix_time) = @_;
	my $untainted_unix_time;
	if ($unix_time =~ /^(\-?\d+)$/) {
		($untainted_unix_time) = ($1);
	} else {
		die "Failed to parse transition time $unix_time";
	}
	my $formatted_date;
	if ($perl_date) {
		$formatted_date = `TZ="$area/$location" perl -MPOSIX -e 'print POSIX::strftime("%Y/%m/%d %H:%M:%S", localtime($untainted_unix_time))'`;
	} elsif ($bsd_date) {
		$formatted_date = `TZ="$area/$location" date -r $untainted_unix_time +"%Y/%m/%d %H:%M:%S"`;
	} else {
		my $gm_strftime = POSIX::strftime("%Y/%m/%d %H:%M:%S GMT", gmtime $untainted_unix_time);
		$formatted_date = `TZ="$area/$location" date -d "$gm_strftime" +"%Y/%m/%d %H:%M:%S"`;
	}
	chomp $formatted_date;
	return $formatted_date;
}

Test::More::done_testing();
