package Net::SSLLabs::EndpointDetails;

use strict;
use warnings;
use Net::SSLLabs::Cert();
use Net::SSLLabs::Suites();
use Net::SSLLabs::SimDetails();
use Net::SSLLabs::Protocol();
use Net::SSLLabs::Chain();
use Net::SSLLabs::Key();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    $self->{key}  = Net::SSLLabs::Key->new( $self->{key} );
    $self->{cert} = Net::SSLLabs::Cert->new( $self->{cert} );
    my @protocols = @{ $self->{protocols} };
    $self->{protocols} = [];
    foreach my $protocol (@protocols) {
        push @{ $self->{protocols} }, Net::SSLLabs::Protocol->new($protocol);
    }
    $self->{suites} = Net::SSLLabs::Suites->new( $self->{suites} );
    $self->{sims}   = Net::SSLLabs::SimDetails->new( $self->{sims} );
    $self->{chain}  = Net::SSLLabs::Chain->new( $self->{chain} );
    return $self;
}

sub hostStartTime {
    my ($self) = @_;
    return $self->{hostStartTime};
}

sub key {
    my ($self) = @_;
    return $self->{key};
}

sub cert {
    my ($self) = @_;
    return $self->{cert};
}

sub chain {
    my ($self) = @_;
    return $self->{chain};
}

sub protocols {
    my ($self) = @_;
    return @{ $self->{protocols} };
}

sub suites {
    my ($self) = @_;
    return $self->{suites};
}

sub serverSignature {
    my ($self) = @_;
    return $self->{serverSignature};
}

sub prefixDelegation {
    my ($self) = @_;
    return $self->{prefixDelegation};
}

sub nonPrefixDelegation {
    my ($self) = @_;
    return $self->{nonPrefixDelegation};
}

sub vulnBeast {
    my ($self) = @_;
    return $self->{vulnBeast};
}

sub renegSupport {
    my ($self) = @_;
    return $self->{renegSupport};
}

sub stsResponseHeader {
    my ($self) = @_;
    return $self->{stsResponseHeader};
}

sub stsMaxAge {
    my ($self) = @_;
    return $self->{stsMaxAge};
}

sub stsSubdomains {
    my ($self) = @_;
    return $self->{stsSubdomains};
}

sub pkpResponseHeader {
    my ($self) = @_;
    return $self->{pkpResponseHeader};
}

sub sessionResumption {
    my ($self) = @_;
    return $self->{sessionResumption};
}

sub compressionMethods {
    my ($self) = @_;
    return $self->{compressionMethods};
}

sub supportsNpn {
    my ($self) = @_;
    return $self->{supportsNpn};
}

sub npnProtocols {
    my ($self) = @_;
    return $self->{npnProtocols};
}

sub sessionTickets {
    my ($self) = @_;
    return $self->{sessionTickets};
}

sub ocspStapling {
    my ($self) = @_;
    return $self->{ocspStaplings};
}

sub staplingRevocationStatus {
    my ($self) = @_;
    return $self->{staplingRevocationStatus};
}

sub staplingRevocationErrorMessage {
    my ($self) = @_;
    return $self->{staplingRevocationErrorMessage};
}

sub sniRequired {
    my ($self) = @_;
    return $self->{sniRequired};
}

sub httpStatusCode {
    my ($self) = @_;
    return $self->{httpStatusCode};
}

sub supportsRc4 {
    my ($self) = @_;
    return $self->{supportsRc4};
}

sub forwardSecrecy {
    my ($self) = @_;
    return $self->{forwardSecrecy};
}

sub rc4WithModern {
    my ($self) = @_;
    return $self->{rc4WithModern};
}

sub sims {
    my ($self) = @_;
    return $self->{sims};
}

sub heartbleed {
    my ($self) = @_;
    return $self->{heartbleed};
}

sub heartbeat {
    my ($self) = @_;
    return $self->{heartbeat};
}

sub openSslCcs {
    my ($self) = @_;
    return $self->{openSslCcs};
}

sub poodle {
    my ($self) = @_;
    return $self->{poodle};
}

sub poodleTls {
    my ($self) = @_;
    return $self->{poodleTls};
}

sub fallbackScsv {
    my ($self) = @_;
    return $self->{fallbackScsv};
}

sub freak {
    my ($self) = @_;
    return $self->{freak};
}

sub hasSct {
    my ($self) = @_;
    return $self->{hasSct};
}

sub dhPrimes {
    my ($self) = @_;
    return @{ $self->{dhPrimes} };
}

sub dhUsesKnownPrimes {
    my ($self) = @_;
    return $self->{dhUsesKnownPrimes};
}

sub dhYsReuse {
    my ($self) = @_;
    return $self->{dhYsReuse};
}

sub logjam {
    my ($self) = @_;
    return $self->{logjam};
}

1;
__END__

=head1 NAME

Net::SSLLabs::EndpointDetails - EndpointDetails object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::EndpointDetails> object, accepts a JSON object as it's parameter.

=head2 hostStartTime

endpoint assessment starting time, in milliseconds since 1970. This field is useful when test results are retrieved in several HTTP invocations. Then, you should check that the hostStartTime value matches the startTime value of the host.

=head2 key

returns the connected L<Net::SSLLabs::Key|Net::SSLLabs::Key> object

=head2 cert

returns the connected L<Net::SSLLabs::Cert|Net::SSLLabs::Cert> object

=head2 chain

returns the connected L<Net::SSLLabs::Chain|Net::SSLLabs::Chain> object

=head2 protocols

returns the list of supported protocols as L<Net::SSLLabs::Protocol|Net::SSLLabs::Protocol> objects

=head2 suites

returns the L<Net::SSLLabs::Suites|Net::SSLLabs::Suites> object

=head2 serverSignature

Contents of the HTTP Server response header when known. This field could be absent for one of two reasons: 1) the HTTP request failed (check httpStatusCode) or 2) there was no Server response header returned.

=head2 prefixDelegation

true if this endpoint is reachable via a hostname with the www prefix

=head2 nonPrefixDelegation

true if this endpoint is reachable via a hostname without the www prefix

=head2 vulnBeast

true if the endpoint is vulnerable to the BEAST attack

=head2 renegSupport

this is an integer value that describes the endpoint support for renegotiation:

=over 2

=item bit 0 (1) - set if insecure client-initiated renegotiation is supported

=item bit 1 (2) - set if secure renegotiation is supported

=item bit 2 (4) - set if secure client-initiated renegotiation is supported

=item bit 3 (8) - set if the server requires secure renegotiation support

=back

=head2 stsResponseHeader

the contents of the Strict-Transport-Security (STS) response header, if seen

=head2 stsMaxAge

the maxAge parameter extracted from the STS parameters;
 
=over 2

=item undef if STS not seen, 

=item -1 if the specified value is invalid (e.g., not a zero or a positive integer; the maximum value currently supported is 2,147,483,647)

=back

=head2 stsSubdomains

true if the includeSubDomains STS parameter is set; undef if STS not seen

=head2 pkpResponseHeader

the contents of the Public-Key-Pinning response header, if seen

=head2 sessionResumption

this is an integer value that describes endpoint support for session resumption. The possible values are:

=over 2

=item 0 - session resumption is not enabled and we're seeing empty session IDs

=item 1 - endpoint returns session IDs, but sessions are not resumed

=item 2 - session resumption is enabled

=back

=head2 compressionMethods

integer value that describes supported compression methods

=over 2

=item bit 0 is set for DEFLATE

=back

=head2 supportsNpn

true if the server supports NPN

=head2 npnProtocols

space separated list of supported protocols

=head2 sessionTickets

indicates support for Session Tickets

=over 2

=item bit 0 (1) - set if session tickets are supported

=item bit 1 (2) - set if the implementation is faulty [not implemented]

=item bit 2 (4) - set if the server is intolerant to the extension

=back

=head2 ocspStapling

true if OCSP stapling is deployed on the server

=head2 staplingRevocationStatus

same as Cert.revocationStatus, but for the stapled OCSP response.

=head2 staplingRevocationErrorMessage

description of the problem with the stapled OCSP response, if any.

=head2 sniRequired

if SNI support is required to access the web site.

=head2 httpStatusCode

status code of the final HTTP response seen. When submitting HTTP requests, redirections are followed, but only if they lead to the same hostname. If this field is not available, that means the HTTP request failed.

=head2 httpForwarding

available on a server that responded with a redirection to some other hostname.

=head2 supportsRc4

true if the server supports at least one RC4 suite.

=head2 forwardSecrecy

indicates support for Forward Secrecy

=over 2

=item bit 0 (1) - set if at least one browser from our simulations negotiated a Forward Secrecy suite.

=item bit 1 (2) - set based on Simulator results if FS is achieved with modern clients. For example, the server supports ECDHE suites, but not DHE.

=item bit 2 (4) - set if all simulated clients achieve FS. In other words, this requires an ECDHE + DHE combination to be supported.

=back

=head2 rc4WithModern

true if RC4 is used with modern clients.

=head2 sims

instance of L<Net::SSLLabs::SimDetails|Net::SSLLabs::SimDetails>.

=head2 heartbleed

true if the server is vulnerable to the Heartbleed attack.

=head2 heartbeat

true if the server supports the Heartbeat extension.

=head2 openSslCcs

results of the CVE-2014-0224 test:

=over 2

=item -1 - test failed

=item 0 - unknown

=item 1 - not vulnerable

=item 2 - possibly vulnerable, but not exploitable

=item 3 - vulnerable and exploitable

=back

=head2 poodle

true if the endpoint is vulnerable to POODLE; false otherwise

=head2 poodleTls

results of the POODLE TLS test:

=over 2

=item -1 - test failed

=item 0 - unknown

=item 1 - not vulnerable

=item 2 - vulnerable

=back

=head2 fallbackScsv

true if the server supports TLS_FALLBACK_SCSV, false if it doesn't. This field will not be available if the server's support for TLS_FALLBACK_SCSV can't be tested because it supports only one protocol version (e.g., only TLS 1.2).

=head2 freak

true of the server is vulnerable to the FREAK attack, meaning it supports 512-bit key exchange.

=head2 hasSct

information about the availability of certificate transparency information (embedded SCTs):

=over 2

=item bit 0 (1) - SCT in certificate

=item bit 1 (2) - SCT in the stapled OCSP response

=item bit 2 (4) - SCT in the TLS extension (ServerHello)

=back

=head2 dhPrimes

list of hex-encoded DH primes used by the server

=head2 dhUsesKnownPrimes

whether the server uses known DH primes:

=over 2

=item 0 - no

=item 1 - yes, but they're not weak

=item 2 - yes and they're weak

=back

=head2 dhYsReuse

true if the DH ephemeral server value is reused.

=head2 logjam

true if the server uses DH parameters weaker than 1024 bits.
