# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: IO-File-Cached.spec.PL,v 1.3 2004/04/01 19:11:23 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/IO/File/Cached.pm')
  {
      if ($@) { die $@ };
      die "lib/IO/File/Cached.pm: $!";
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$IO::File::Cached::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by IO-File-Cached.spec.PL

%define perlsitearch %(perl -e 'use Config; print $Config{installsitearch}')
%define perlsitelib %(perl -e 'use Config; print $Config{installsitelib}')
%define perlman1dir %(perl -e 'use Config; print "$Config{siteprefix}/man/man1"')
%define perlman3dir %(perl -e 'use Config; print "$Config{siteprefix}/man/man3"')
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname IO-File-Cached

Summary: IO::File::Cached - On demand file caching
Name: perl-%{appname}
Version: @VERSION@
Release: 1
Copyright: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl = %{perlversion}

%description
IO::File::Cached is a subclass of IO::Scalar that uses IO::File
and Cache::Cache for load on demand caching of files.
 
%prep
%setup -q -n %{appname}-%{version}

%build
perl Makefile.PL
make


%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT/usr install
find $RPM_BUILD_ROOT%{perlsitearch} -name perllocal.pod -exec rm -f {} \;


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc COPYING
%doc README
%{perlman3dir}/*
%{perlsitelib}/IO/File/Cached.pm
%{perlsitearch}/auto/IO/File/Cached/
