#
# This file is part of PerlIO-via-Timeout
#
# This software is copyright (c) 2013 by Damien "dams" Krotkine.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
package PerlIO::via::Timeout::Strategy::NoTimeout;
{
  $PerlIO::via::Timeout::Strategy::NoTimeout::VERSION = '0.19';
}

# ABSTRACT: a L<PerlIO::via::Timeout> strategy that don't do any timeout


require 5.008;
use strict;
use warnings;

use PerlIO::via::Timeout::Strategy;
our @ISA = qw(PerlIO::via::Timeout::Strategy);

sub READ {
    my ($self, undef, $len, $fh, $fd) = @_;
    my $rv = sysread($fh, $_[1], $len);
    if (! defined $rv) {
        # There is a bug in PerlIO::via (possibly in PerlIO ?). We would like
        # to return -1 to signify error, but doing so doesn't work (it usually
        # segfault), it looks like the implementation is not complete. So we
        # return 0.
        $rv = 0;
    }
    return $rv;
}

sub WRITE {
    my ($self, undef, $fh, $fd) = @_;
    my $rv = syswrite($fh, $_[1]);
    defined $rv
      or return -1;
    return $rv;
}

1;

__END__
=pod

=head1 NAME

PerlIO::via::Timeout::Strategy::NoTimeout - a L<PerlIO::via::Timeout> strategy that don't do any timeout

=head1 VERSION

version 0.19

=DESCRIPTION

This class is the default strategy used by L<PerlIO::via::Timeout> if none is
provided. It inherits L<PerlIO::via::Timeout::Strategy>. This strategy does
B<not> apply any timeout on the filehandle.

This strategy is only useful for other strategies to inherit from. It should B<not>
be used directly.

=head1 CONSTRUCTOR

See L<PerlIO::via::Timeout::Strategy>.

=head1 METHODS

See L<PerlIO::via::Timeout::Strategy>.

=head1 AUTHOR

Damien "dams" Krotkine

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Damien "dams" Krotkine.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

