package OpenInteract2::User::LDAP;

# $Id: LDAP.pm,v 1.1 2003/03/26 12:05:43 lachoy Exp $

use strict;
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );
use OpenInteract2::Exception qw( oi_error );

$OpenInteract2::User::LDAP::VERSION = sprintf("%d.%02d", q$Revision: 1.1 $ =~ /(\d+)\.(\d+)/);

########################################
# Normal
########################################

sub full_name {
    return $_[0]->{cn};
}

# To check the password for this user, we try to bind with the
# password in the object and the object's DN. First we need to grab a
# new connection...

sub check_password {
    my ( $self, $check_passwd ) = @_;

    # If we're using multiple datasources
    # (SPOPS::LDAP::MultiDatasource) then the name of the datasource
    # should be stored in the object. Otherwise we just use the
    # default for this class.

    my $datasource = $self->{_datasource} || $self->get_connect_key;
    DEBUG && LOG( LDEBUG, "Trying to check password for user", $self->dn,
                  "against datasource ($datasource)" );
    my $connect_info = $self->connection_info( $datasource );

    require OpenInteract2::LDAP;
    my $ldap = eval { OpenInteract2::LDAP->connect( $connect_info ) };
    if ( $@ ) {
        LOG( LERROR, "Failed to connect to LDAP directory: $@" );
        oi_error "Cannot connect to LDAP directory to check password: $@";
    }
    my $bind_info = { bind_dn       => $self->dn,
                      bind_password => $check_passwd };
    eval { OpenInteract2::LDAP->bind( $ldap, $bind_info ) };
    my $error = $@;
    DEBUG && LOG( LDEBUG, "Result of password check (empty = ok): $error" );
    return ( ! $error );
}

# Cheating because 'fetch_by' isn't done yet and we need this for
# OpenInteract2::Auth...

sub fetch_by_login_name {
    my ( $class, $login_name, $p ) = @_;
    my $login_field = $class->CONFIG->{field_map}{login_name}
                      || 'login_name';
    $p->{filter} = "$login_field=$login_name";
    return $class->fetch( undef, $p )
}

1;
