package OpenInteract2::SQLInstall::Group;

# $Id: Group.pm,v 1.3 2003/04/22 12:29:31 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );
use SPOPS::SQLInterface;

my @TABLES = ( 'sys_group.sql', 'sys_group_user.sql' );

my %FILES = (
    oracle => [ 'sys_group_oracle.sql',
                'sys_group_user.sql',
                'sys_group_sequence.sql' ],
    pg     => [ @TABLES,
                'sys_group_sequence.sql' ],
    ib     => [ @TABLES,
                'sys_group_generator.sql' ],
);

sub get_structure_set {
    return 'group';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return $FILES{oracle};
    }
    elsif ( $type eq 'Pg' ) {
        return $FILES{pg};
    }
    elsif ( $type eq 'InterBase' ) {
        return $FILES{ib};
    }
    else {
        return [ @TABLES ];
    }
}

sub get_security_file {
    return 'install_security.dat';
}

sub install_data {
    my ( $self ) = @_;
    $self->_create_initial_groups;
    $self->_create_link_groups;
}


# Create the admin, site admin and public groups

sub _create_initial_groups {
    my ( $self ) = @_;
    my $server_config = CTX->server_config;
    my $group_class = CTX->lookup_object( 'group' );
    my @DATA = (
        [ $server_config->{default_objects}{supergroup},
          'admin',      'Super group, can do anything' ],
        [ $server_config->{default_objects}{public_group},
          'public',     'All users should be part of this group' ],
        [ $server_config->{default_objects}{site_admin_group},
          'site admin', 'Group for site administrators' ],
    );

    foreach my $data ( @DATA ) {
        my $this_state = "create group $data->[1]";
        DEBUG && LOG( LDEBUG, "Trying to create group [ID: $data->[0]] ",
                              "[Name: $data->[1]]" );
        eval { $group_class->new({ group_id => $data->[0],
                                   name     => $data->[1],
                                   notes    => $data->[2] })
                           ->save({ is_add        => 1,
                                    skip_security => 1,
                                    skip_cache    => 1,
                                    skip_log      => 1 }) };
        if ( $@ ) {
            $self->_set_state( $this_state,
                               undef,
                               "Failed to create group: $@",
                               undef );
            DEBUG && LOG( LDEBUG, "Group create failed: $@" );
        }
        else {
            $self->_set_state( $this_state, 1, undef, undef );
        }
    }
}


sub _create_link_groups {
    my ( $self ) = @_;
    my $action_name = 'create superuser group link';
    my $server_config = CTX->server_config;
    my $dbh = CTX->lookup_object( 'group' )
                 ->global_datasource_handle();
    my $sql = qq/
      INSERT INTO sys_group_user ( group_id, user_id )
      VALUES ( ?, ? )
    /;
    my ( $sth );
    eval {
        $sth = $dbh->prepare( $sql );
        $sth->execute( $server_config->{default_objects}{supergroup},
                       $server_config->{default_objects}{superuser} );
    };
    if ( $@ ) {
        LOG( LERROR, "Failed to create user/group link: $@" );
        $self->_set_state( $action_name,
                           undef, "Failed to create link: $@", $sql );
    }
    else {
        $self->_set_state( $action_name, 1, undef, $sql );

    }
}

1;
