$spops = {
      'page' => {
        class        => 'OpenInteract::Page',
        code_class   => [ 'OpenInteract::Page' ],

# Uncomment this if you have the 'full_text' package installed and
# want to have your pages indexed for searching
#        rules_from   => [ 'OpenInteract::FullText' ],

        isa          => [ qw/ OpenInteract::SPOPS::DBI
                              SPOPS::Secure::Hierarchy 
                              SPOPS::Utility SPOPS::DBI / ],
        field_discover => 'yes',
        field        => [],
        fulltext_field => [ qw/ title author keywords content / ],  
        column_group => {},
        id_field     => 'location',
        no_insert    => [],
        skip_undef   => [ qw/ template_parse is_active storage / ],
        no_update    => [],
        base_table   => 'page',
        sql_defaults => [ qw/ template_parse is_active storage / ],

# Only uncomment this (and comment out the next line) after you've
# moved all the data over
#        alias        => [ 'static_page', 'basicpage' ],
        alias        => [], 

        has_a        => { 'OpenInteract::PageContent' => 'location' },
        links_to     => {},
        track        => { create => 1, update => 1, remove => 1 },
        display      => { url => '/Page/show/' },
        name         => 'title',
        object_name  => 'Document',
        default_storage     => 'file',
        hierarchy_separator => '/',
        hierarchy_field     => 'location',
      },

      'page_content' => {
        class        => 'OpenInteract::PageContent',
        isa          => [ 'OpenInteract::SPOPS::DBI', 'SPOPS::DBI' ],
        field        => [ qw/ location content / ],
        id_field     => 'location',
        base_table   => 'page_content',
        has_a        => { 'OpenInteract::Page' => 'location' },
        object_name  => 'Document',
      },

      'content_type' => {
        class        => 'OpenInteract::ContentType',
        code_class   => [ 'OpenInteract::ContentType' ],
        isa          => [ qw/ OpenInteract::SPOPS::DBI SPOPS::DBI::MySQL SPOPS::DBI / ],
        field        => [ qw/ content_type_id mime_type extensions description image_source / ],
        id_field     => 'content_type_id',
        no_insert    => [ 'content_type_id' ],
        increment_field => 1,
        sequence_name => 'content_type_content_type_i_seq',
        base_table   => 'content_type',
        name         => 'mime_type',
        object_name  => 'Content Type',
        display      => { url => '/Lookups/' },
      },

      'page_directory' => {
        class        => 'OpenInteract::PageDirectory',
        code_class   => [ 'OpenInteract::PageDirectory' ],
        isa          => [ qw/ OpenInteract::SPOPS::DBI SPOPS::DBI / ],
        field        => [ qw/ directory action subdirs_inherit / ],
        id_field     => 'directory',
        skip_undef   => [ 'subdirs_inherit' ],
        sql_defaults => [ 'subdirs_inherit' ],
        base_table   => 'page_directory',
        name         => 'directory',
        object_name  => 'Directory',
        display      => { url => '/PageDirectory/show/' },
        hierarchy_separator => '/',
        hierarchy_field     => 'directory',
      }
};