package OpenInteract::ObjectActivity;

# $Id: ObjectActivity.pm,v 1.2 2001/10/18 13:47:44 lachoy Exp $

use strict;
use Class::Date qw( -DateParse );

my @SEARCH_FIELDS = qw( class object_id action action_by action_on );
my @RECORD_FIELDS = qw( class object_id action action_by action_on notes );

use constant OBJECT_ACTIVITY_TABLE => 'object_track';


# Check hashref and GET/POST parameters for search criteria, build a
# search and run it, returning an arrayref of hashrefs. Keys of each
# hashref map to the fieldnames in 'object_track'.

sub fetch_activity {
    my ( $class, $p ) = @_;
    $p ||= {};
    my $R     = OpenInteract::Request->instance;
    my $apr   = $R->apache;

    my @where = ();
    my @value = ();

    # Do the easy criteria

    foreach my $field ( @SEARCH_FIELDS ) {
        my $this_value = $p->{ $field } || $apr->param( $field );
        next unless $this_value;
        push @where, " $field = ? ";
        push @value, $this_value;
        $R->DEBUG && $R->scrib( 1, "Setting criteria ($field) to ($this_value)" );
    }

    # Now the dates...

    my $exact_date = $class->read_date( 'action_on', $p );
    my $date_fmt = '%Y-%m-%d';
    if ( $exact_date ) {
        push @where, " ( action_on > ? AND action_on < ? ) ";
        my $date_before = $exact_date - '1D';
        my $date_after  = $exact_date + '1D';
        push @value, $date_before->strftime( $date_fmt ), $date_after->strftime( $date_fmt );
    }

    else {
        my $start_date = $class->read_date( 'action_on_start', $p );
        my $end_date   = $class->read_date( 'action_on_end', $p );
        if ( $start_date ) {
            push @where, " action_on >= ? ";
            push @value, $start_date->strftime( $date_fmt );
        }
        if ( $end_date ) {
            push @where, " action_on <= ?";
            push @value, $end_date->strftime( $date_fmt );
        }
    }

    my $order = $p->{order} || $apr->param( 'order' ) || 'action_on DESC';
    return SPOPS::SQLInterface->db_select({ db     => $R->db,
                                            select => \@RECORD_FIELDS,
                                            from   => [ OBJECT_ACTIVITY_TABLE ],
                                            where  => join( ' AND ', @where ),
                                            order  => $order,
                                            return => 'hash',
                                            value  => \@value });
}


# Takes a list of hashrefs (like that returned by 'fetch_activity()'
# above) and adds:

#  'type'       - Type of object
#  'title'      - Title of this object
#  'login_name' - Name of user who created activity record

sub add_object_information {
    my ( $class, $activity_list ) = @_;
    my $R = OpenInteract::Request->instance;
    my ( %user_cache );
    foreach my $rec ( @{ $activity_list } ) {
        my $object_class = $rec->{class};
        my $object = eval { $object_class->fetch( $rec->{object_id} ) };
        if ( $@ or ! $object ) {
            $rec->{object_type} = 'unknown';
            $rec->{title}       = 'n/a';
        }
        else {
            my $info = $object->object_description;
            $rec->{object_type} = $info->{name};
            $rec->{title}       = $info->{title};
            $rec->{display_url} = $info->{url};
        }

        unless ( $user_cache{ $rec->{action_by} } ) {
            my $user = eval { $R->user->fetch( $rec->{action_by} ) };
            if ( $@ or ! $user ) {
                $rec->{login_name} = 'unknown';
            }
            else {
                $user_cache{ $rec->{action_by} } = $user->object_description;
            }
        }
        if ( my $user = $user_cache{ $rec->{action_by} } ) {
            $rec->{login_name}       = $user->{title};
            $rec->{user_display_url} = $user->{url};
        }
    }
    return $activity_list;
}


sub read_date {
    my ( $class, $field, $p ) = @_;
    if ( $p->{ $field } ) {
        my $date_string = $p->{ $field };
        return Class::Date::date( $date_string );
    }
    my $apr = OpenInteract::Request->instance->apache;
    my ( $y, $m, $d ) = ( $apr->param( "${field}_year" ),
                          $apr->param( "${field}_month" ),
                          $apr->param( "${field}_day" ) );
    return undef unless ( $y and $m and $d );
    return Class::Date->new([ $y, $m, $d ]);
}

1;
