package Lingua::StopWords::PT;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] ); 
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our $VERSION = 0.05;

sub getStopWords {
    if ( @_ and $_[0] eq 'UTF-8' ) {
        # adding U0 causes the result to be flagged as UTF-8
        my %stoplist = map { ( pack("U0a*", $_), 1 ) } qw( 
            de a o que e do da em um para com não uma os no se na por mais
            as dos como mas ao ele das à seu sua ou quando muito nos já
            eu também só pelo pela até isso ela entre depois sem mesmo
            aos seus quem nas me esse eles você essa num nem suas meu às
            minha numa pelos elas qual nós lhe deles essas esses pelas
            este dele tu te vocês vos lhes meus minhas teu tua teus tuas
            nosso nossa nossos nossas dela delas esta estes estas aquele
            aquela aqueles aquelas isto aquilo estou está estamos estão
            estive esteve estivemos estiveram estava estávamos estavam
            estivera estivéramos esteja estejamos estejam estivesse
            estivéssemos estivessem estiver estivermos estiverem hei há
            havemos hão houve houvemos houveram houvera houvéramos haja
            hajamos hajam houvesse houvéssemos houvessem houver houvermos
            houverem houverei houverá houveremos houverão houveria
            houveríamos houveriam sou somos são era éramos eram fui foi
            fomos foram fora fôramos seja sejamos sejam fosse fôssemos
            fossem for formos forem serei será seremos serão seria
            seríamos seriam tenho tem temos tém tinha tínhamos tinham
            tive teve tivemos tiveram tivera tivéramos tenha tenhamos
            tenham tivesse tivéssemos tivessem tiver tivermos tiverem
            terei terá teremos terão teria teríamos teriam 
        );
        return \%stoplist;
    }
    else {
        my %stoplist = map { ( $_, 1 ) } qw( 
            de a o que e do da em um para com no uma os no se na por mais
            as dos como mas ao ele das  seu sua ou quando muito nos j eu
            tambm s pelo pela at isso ela entre depois sem mesmo aos
            seus quem nas me esse eles voc essa num nem suas meu s minha
            numa pelos elas qual ns lhe deles essas esses pelas este dele
            tu te vocs vos lhes meus minhas teu tua teus tuas nosso nossa
            nossos nossas dela delas esta estes estas aquele aquela aqueles
            aquelas isto aquilo estou est estamos esto estive esteve
            estivemos estiveram estava estvamos estavam estivera
            estivramos esteja estejamos estejam estivesse estivssemos
            estivessem estiver estivermos estiverem hei h havemos ho
            houve houvemos houveram houvera houvramos haja hajamos hajam
            houvesse houvssemos houvessem houver houvermos houverem
            houverei houver houveremos houvero houveria houveramos
            houveriam sou somos so era ramos eram fui foi fomos foram
            fora framos seja sejamos sejam fosse fssemos fossem for
            formos forem serei ser seremos sero seria seramos seriam
            tenho tem temos tm tinha tnhamos tinham tive teve tivemos
            tiveram tivera tivramos tenha tenhamos tenham tivesse
            tivssemos tivessem tiver tivermos tiverem terei ter teremos
            tero teria teramos teriam 
        );
        return \%stoplist;
    }
}

1;
