use strict;
use warnings;
package Sumu::Perl::Modules;
$Sumu::Perl::Modules::VERSION = '0.001';
# ABSTRACT: Perl Modules

=head1 NAME
    Perl Modules
=cut

=head1 VERSION

version 0.001

use ExtUtils::Installed;

sub _extutils {

    my $c = shift;
    
    my $inst = ExtUtils::Installed->new();

    my @modules = $inst->modules();

    my $out;

    my $mods; 
    my $serial = '0';
    $mods .= qq{};
    for (@modules) {
        #
        chomp;
        #
        my $module_version = $inst->version("$_");
        #
        my $module_files = $inst->files("$_");
        #
        my $mod_dirs = $inst->directories("$_");
        #
        my $mod_packlist = $inst->packlist("$_"); # shows hash error 

        $serial++ if $_;

        $mods .= qq{<tr> 
            <td>$serial</td> 
            <td> <a href="/perl/_modules/_dirs/$_" title="$_">$_</a> </td> 
            <td>$module_version</td> 
            <td>$module_files</td> 
            <td> $mod_dirs </td> 
        </tr>
        };
    }
    $mods .= qq{};

    return $mods;

}
# end 


=head3 Show Dirs 
    in a module 
=cut

sub _dirs  {

    my %in = (
        current_user => '',
        module => '',
        @_,
    );

    #
    my $current_user = $in{current_user};

    my $module = $in{module};
    chomp $module; 

    my $inst = ExtUtils::Installed->new();

    #
    my @mod_dirs = $inst->directories("$module");

    # files 
    my @mod_files = $inst->files("$module");

    my $dirs; 
    $dirs .= qq{<ol>};
    for (@mod_dirs) {
        chomp;
        next if $_ =~ /man3$/;
        #
        my $cust_filename = $_;
        $cust_filename =~ s!^\/home\/$current_user!!g;
        #
        $dirs .= qq{<li> $cust_filename </li>};
    }
    $dirs .= qq{</ol>};

    my $files;
    $files .= qq{<ol>};
    for (@mod_files) {
        chomp;
        next if $_ =~ /\.3$/;
        #
        my $cust_filename = $_;
        $cust_filename =~ s!^\/home\/$current_user!!g;
        #
        $files .= qq{<li> <a href="/perl/_modules/_doc/$_" title="$cust_filename">$cust_filename</a> </li>};
    }
    $files .= qq{</ol>};

    #
    return ($module, $dirs, $files);

}
# end 

=head3 Show Doc 
    for a module 
=cut

sub _doc {

    my %in = (
        module => '',
        @_,
    );
    
    #
    my $module = $in{module};
        chomp $module;
    
    my @doc = `perldoc $module`;

    my $out;

    for (@doc) {
        $_ =~ s!\<!&lt;!g;
        $_ =~ s!\>!&gt;!g;
        $out .= qq{$_<br>};
    }

    return($module, $out);

    #

}
# end _doc 


1;
