/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.dom.xcs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.ttt.salt.XCSDocument;
import org.ttt.salt.dom.xcs.XCSElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XCSParser
implements ContentHandler,
DTDHandler,
EntityResolver,
ErrorHandler {
    public static final String RCSID = "$Id: XCSParser.java 147 2012-06-02 14:37:43Z lanhel $";
    public static final Set<String> KNOWN_MISSING = new TreeSet<String>(Arrays.asList("header", "title", "languages", "langInfo", "langCode", "langName", "datCatSet", "datCatDoc", "datCatMap", "datCatToken", "datCatDisplay", "termNoteSpec", "descripSpec", "adminSpec", "descripNoteSpec", "xrefSpec", "refSpec", "termCompListSpec", "termCompListSpec", "transacNoteSpec", "adminNoteSpec", "transacSpec", "hiSpec", "refObjectDefSet", "refObjectDef", "refObjectType", "contents", "levels", "itemSpec", "itemSpecSet"));
    private static final Logger LOGGER = Logger.getLogger("org.ttt.salt.dom.xcs");
    private XMLReader reader;
    private EntityResolver resolver;
    private Map<String, URI> namespace = new HashMap<String, URI>();
    private XCSDocument document;
    private XCSElement current;
    private Stack<XCSElement> stack = new Stack();
    private Locator locator;
    private boolean collapseWhitespace;

    public XCSParser(EntityResolver r) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.resolver = r;
        try {
            this.reader = new SAXParser();
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setContentHandler(this);
            this.reader.setDTDHandler(this);
            this.reader.setEntityResolver(this.resolver);
            this.reader.setErrorHandler(this);
        }
        catch (SAXNotRecognizedException err) {
            LOGGER.log(Level.SEVERE, "Required parser feature is unavailable.", err);
            throw err;
        }
        catch (SAXNotSupportedException err) {
            LOGGER.log(Level.SEVERE, "Could not set required parser feature.", err);
            throw err;
        }
    }

    public XCSDocument parse(InputSource src) throws SAXException, IOException {
        XCSDocument ret = new XCSDocument();
        this.parse(ret, src);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XCSDocument doc, InputSource src) throws SAXException, IOException {
        XCSParser xCSParser = this;
        synchronized (xCSParser) {
            if (this.document != null) {
                throw new IllegalStateException("XCSParser is already parsing a document.");
            }
            this.document = doc;
        }
        this.reader.parse(src);
        this.document = null;
    }

    public void setDocumentLocator(Locator loc) {
        LOGGER.entering("XCSParser", "setDocumentLocator", String.format("Line=%d Col=%d", loc.getLineNumber(), loc.getColumnNumber()));
        this.locator = loc;
    }

    public void startDocument() throws SAXException {
        LOGGER.entering("XCSParser", "startDocument");
        assert (this.stack.isEmpty()) : "XCSParser stack is not empty.";
    }

    public void endDocument() throws SAXException {
        LOGGER.entering("XCSParser", "endDocument");
        assert (this.stack.isEmpty()) : "XCSParser stack is not empty.";
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        LOGGER.entering("XCSParser", "startPrefixMapping", String.format("prefix='%s' uri='%s'", prefix, uri));
        try {
            this.namespace.put(prefix, new URI(uri));
        }
        catch (URISyntaxException err) {
            throw new SAXParseException("Invalid URI", this.locator, err);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        LOGGER.entering("XCSParser", "endPrefixMapping", String.format("prefix='%s'", prefix));
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        LOGGER.entering("XCSParser", "startElement", String.format("%d: uri='%s' local='%s' qName='%s'", this.locator.getLineNumber(), uri, localName, qName));
        this.stack.push(this.current);
        this.current = this.document.createXCSElement(localName, this.locator);
        for (int i = 0; i < atts.getLength(); ++i) {
            LOGGER.finer(String.format("Attribute: qname='%s' local='%s' type='%s' uri='%s' value='%s'", atts.getQName(i), atts.getLocalName(i), atts.getType(i), atts.getURI(i), atts.getValue(i)));
            try {
                this.current.setAttribute(atts.getQName(i), atts.getValue(i));
                continue;
            }
            catch (DOMException err) {
                LOGGER.severe(String.format("<%s %s='%s'> line %d\n\t%s", localName, atts.getQName(i), atts.getValue(i), this.locator.getLineNumber(), err.getLocalizedMessage()));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        LOGGER.entering("XCSParser", "endElement", String.format("%d: uri='%s' local='%s' qName='%s'", this.locator.getLineNumber(), uri, localName, qName));
        this.current.endElement(this.locator);
        XCSElement child = this.current;
        this.current = this.stack.pop();
        if (this.current != null) {
            this.current.appendChild(child);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        LOGGER.entering("XCSParser", "characters", String.format("'%s'", new String(ch, start, length)));
        String data = new String(ch, start, length);
        if (this.collapseWhitespace) {
            data = data.replaceAll("\\s+", " ");
        }
        Text text = this.document.createTextNode(data);
        this.current.appendChild(text);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        LOGGER.entering("XCSParser", "ignorableWhitespace", String.format("'%s'", new String(ch, start, length)));
        if (!this.collapseWhitespace) {
            String data = new String(ch, start, length);
            Text text = this.document.createTextNode(data);
            this.current.appendChild(text);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        LOGGER.entering("XCSParser", "processingInstruction", String.format("target='%s' data='%s'", target, data));
    }

    public void skippedEntity(String name) throws SAXException {
        LOGGER.entering("XCSParser", "skippedEntity", name);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        LOGGER.entering("XCSParser", "notationDecl", String.format("name='%s' publicId='%s' systemId='%s'", name, publicId, systemId));
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        LOGGER.entering("XCSParser", "unparsedEntityDecl", String.format("name='%s' publicId='%s' systemId='%s' notationName='%s'", name, publicId, systemId, notationName));
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOGGER.entering("XCSParser", "resolvedEntity", String.format("publicId='%s' systemId='%s'", publicId, systemId));
        return this.resolver.resolveEntity(publicId, systemId);
    }

    public void warning(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.WARNING, "XCSParser SAX Warning", exception);
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.SEVERE, "XCSParser SAX Error", exception);
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.SEVERE, "XCSParser SAX Fatal", exception);
        throw exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestAccess {
        TestAccess() {
        }

        XMLReader reader() {
            return XCSParser.this.reader;
        }

        XCSDocument document() {
            return XCSParser.this.document;
        }

        void document(XCSDocument doc) {
            XCSParser.this.document = doc;
        }

        XCSElement current() {
            return XCSParser.this.current;
        }

        Stack<XCSElement> stack() {
            return XCSParser.this.stack;
        }

        Locator locator() {
            return XCSParser.this.locator;
        }
    }
}

