/**
 * @file
 * @ingroup workerframeenc
 * @brief Dicop Project - Character encoding tables for UTF-8
 *  
 * @english
 *
 * <b>This file has been automatically generated by <code>build/gen_tables.pl</code>.
 * Do not edit, all changes are lost!</b>
 *
 * @endenglish
 *
 * @deutsch
 *
 * <b>Diese Datei wurde automatisch generiert von <code>build/gen_tables.pl</code>.
 * Hier nicht editieren, da alle &Auml;nderungen verloren gehen!</b>
 *
 * @enddeutsch
 *
 * Used: ##VERSION##
 *  
 * @version 0.02 
 * @date Mon Sep 10 15:22:47 2007
 *  
 * @copydoc copyrighttext
*/

#ifndef DICOP_UTF8_H
#define DICOP_UTF8_H

/** Map start byte to number of continuation bytes for UTF-8 */
unsigned long utf8_followers[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5
  };
/** How many entries are in the case folding map? */
#define CASE_FOLDINGS 1868

/** Map UPPERCASE to lowercase for UTF-8 */
unsigned long utf8_to_lower[CASE_FOLDINGS] = {
  0x41, 0x61, 0x42, 0x62, 0x43, 0x63, 0x44, 0x64, 0x45, 0x65, 0x46, 0x66, 0x47, 
  0x67, 0x48, 0x68, 0x49, 0x69, 0x4a, 0x6a, 0x4b, 0x6b, 0x4c, 0x6c, 0x4d, 0x6d, 
  0x4e, 0x6e, 0x4f, 0x6f, 0x50, 0x70, 0x51, 0x71, 0x52, 0x72, 0x53, 0x73, 0x54, 
  0x74, 0x55, 0x75, 0x56, 0x76, 0x57, 0x77, 0x58, 0x78, 0x59, 0x79, 0x5a, 0x7a, 
  0xb5c2, 0xbcce, 0x80c3, 0xa0c3, 0x81c3, 0xa1c3, 0x82c3, 0xa2c3, 0x83c3, 0xa3c3, 
  0x84c3, 0xa4c3, 0x85c3, 0xa5c3, 0x86c3, 0xa6c3, 0x87c3, 0xa7c3, 0x88c3, 0xa8c3, 
  0x89c3, 0xa9c3, 0x8ac3, 0xaac3, 0x8bc3, 0xabc3, 0x8cc3, 0xacc3, 0x8dc3, 0xadc3, 
  0x8ec3, 0xaec3, 0x8fc3, 0xafc3, 0x90c3, 0xb0c3, 0x91c3, 0xb1c3, 0x92c3, 0xb2c3, 
  0x93c3, 0xb3c3, 0x94c3, 0xb4c3, 0x95c3, 0xb5c3, 0x96c3, 0xb6c3, 0x98c3, 0xb8c3, 
  0x99c3, 0xb9c3, 0x9ac3, 0xbac3, 0x9bc3, 0xbbc3, 0x9cc3, 0xbcc3, 0x9dc3, 0xbdc3, 
  0x9ec3, 0xbec3, 0x80c4, 0x81c4, 0x82c4, 0x83c4, 0x84c4, 0x85c4, 0x86c4, 0x87c4, 
  0x88c4, 0x89c4, 0x8ac4, 0x8bc4, 0x8cc4, 0x8dc4, 0x8ec4, 0x8fc4, 0x90c4, 0x91c4, 
  0x92c4, 0x93c4, 0x94c4, 0x95c4, 0x96c4, 0x97c4, 0x98c4, 0x99c4, 0x9ac4, 0x9bc4, 
  0x9cc4, 0x9dc4, 0x9ec4, 0x9fc4, 0xa0c4, 0xa1c4, 0xa2c4, 0xa3c4, 0xa4c4, 0xa5c4, 
  0xa6c4, 0xa7c4, 0xa8c4, 0xa9c4, 0xaac4, 0xabc4, 0xacc4, 0xadc4, 0xaec4, 0xafc4, 
  0xb2c4, 0xb3c4, 0xb4c4, 0xb5c4, 0xb6c4, 0xb7c4, 0xb9c4, 0xbac4, 0xbbc4, 0xbcc4, 
  0xbdc4, 0xbec4, 0xbfc4, 0x80c5, 0x81c5, 0x82c5, 0x83c5, 0x84c5, 0x85c5, 0x86c5, 
  0x87c5, 0x88c5, 0x8ac5, 0x8bc5, 0x8cc5, 0x8dc5, 0x8ec5, 0x8fc5, 0x90c5, 0x91c5, 
  0x92c5, 0x93c5, 0x94c5, 0x95c5, 0x96c5, 0x97c5, 0x98c5, 0x99c5, 0x9ac5, 0x9bc5, 
  0x9cc5, 0x9dc5, 0x9ec5, 0x9fc5, 0xa0c5, 0xa1c5, 0xa2c5, 0xa3c5, 0xa4c5, 0xa5c5, 
  0xa6c5, 0xa7c5, 0xa8c5, 0xa9c5, 0xaac5, 0xabc5, 0xacc5, 0xadc5, 0xaec5, 0xafc5, 
  0xb0c5, 0xb1c5, 0xb2c5, 0xb3c5, 0xb4c5, 0xb5c5, 0xb6c5, 0xb7c5, 0xb8c5, 0xbfc3, 
  0xb9c5, 0xbac5, 0xbbc5, 0xbcc5, 0xbdc5, 0xbec5, 0xbfc5, 0x73, 0x81c6, 0x93c9, 
  0x82c6, 0x83c6, 0x84c6, 0x85c6, 0x86c6, 0x94c9, 0x87c6, 0x88c6, 0x89c6, 0x96c9, 
  0x8ac6, 0x97c9, 0x8bc6, 0x8cc6, 0x8ec6, 0x9dc7, 0x8fc6, 0x99c9, 0x90c6, 0x9bc9, 
  0x91c6, 0x92c6, 0x93c6, 0xa0c9, 0x94c6, 0xa3c9, 0x96c6, 0xa9c9, 0x97c6, 0xa8c9, 
  0x98c6, 0x99c6, 0x9cc6, 0xafc9, 0x9dc6, 0xb2c9, 0x9fc6, 0xb5c9, 0xa0c6, 0xa1c6, 
  0xa2c6, 0xa3c6, 0xa4c6, 0xa5c6, 0xa6c6, 0x80ca, 0xa7c6, 0xa8c6, 0xa9c6, 0x83ca, 
  0xacc6, 0xadc6, 0xaec6, 0x88ca, 0xafc6, 0xb0c6, 0xb1c6, 0x8aca, 0xb2c6, 0x8bca, 
  0xb3c6, 0xb4c6, 0xb5c6, 0xb6c6, 0xb7c6, 0x92ca, 0xb8c6, 0xb9c6, 0xbcc6, 0xbdc6, 
  0x84c7, 0x86c7, 0x85c7, 0x86c7, 0x87c7, 0x89c7, 0x88c7, 0x89c7, 0x8ac7, 0x8cc7, 
  0x8bc7, 0x8cc7, 0x8dc7, 0x8ec7, 0x8fc7, 0x90c7, 0x91c7, 0x92c7, 0x93c7, 0x94c7, 
  0x95c7, 0x96c7, 0x97c7, 0x98c7, 0x99c7, 0x9ac7, 0x9bc7, 0x9cc7, 0x9ec7, 0x9fc7, 
  0xa0c7, 0xa1c7, 0xa2c7, 0xa3c7, 0xa4c7, 0xa5c7, 0xa6c7, 0xa7c7, 0xa8c7, 0xa9c7, 
  0xaac7, 0xabc7, 0xacc7, 0xadc7, 0xaec7, 0xafc7, 0xb1c7, 0xb3c7, 0xb2c7, 0xb3c7, 
  0xb4c7, 0xb5c7, 0xb6c7, 0x95c6, 0xb7c7, 0xbfc6, 0xb8c7, 0xb9c7, 0xbac7, 0xbbc7, 
  0xbcc7, 0xbdc7, 0xbec7, 0xbfc7, 0x80c8, 0x81c8, 0x82c8, 0x83c8, 0x84c8, 0x85c8, 
  0x86c8, 0x87c8, 0x88c8, 0x89c8, 0x8ac8, 0x8bc8, 0x8cc8, 0x8dc8, 0x8ec8, 0x8fc8, 
  0x90c8, 0x91c8, 0x92c8, 0x93c8, 0x94c8, 0x95c8, 0x96c8, 0x97c8, 0x98c8, 0x99c8, 
  0x9ac8, 0x9bc8, 0x9cc8, 0x9dc8, 0x9ec8, 0x9fc8, 0xa0c8, 0x9ec6, 0xa2c8, 0xa3c8, 
  0xa4c8, 0xa5c8, 0xa6c8, 0xa7c8, 0xa8c8, 0xa9c8, 0xaac8, 0xabc8, 0xacc8, 0xadc8, 
  0xaec8, 0xafc8, 0xb0c8, 0xb1c8, 0xb2c8, 0xb3c8, 0xbac8, 0xa5b1e2, 0xbbc8, 0xbcc8, 
  0xbdc8, 0x9ac6, 0xbec8, 0xa6b1e2, 0x81c9, 0x82c9, 0x83c9, 0x80c6, 0x84c9, 0x89ca, 
  0x85c9, 0x8cca, 0x86c9, 0x87c9, 0x88c9, 0x89c9, 0x8ac9, 0x8bc9, 0x8cc9, 0x8dc9, 
  0x8ec9, 0x8fc9, 0x85cd, 0xb9ce, 0x86ce, 0xacce, 0x88ce, 0xadce, 0x89ce, 0xaece, 
  0x8ace, 0xafce, 0x8cce, 0x8ccf, 0x8ece, 0x8dcf, 0x8fce, 0x8ecf, 0x91ce, 0xb1ce, 
  0x92ce, 0xb2ce, 0x93ce, 0xb3ce, 0x94ce, 0xb4ce, 0x95ce, 0xb5ce, 0x96ce, 0xb6ce, 
  0x97ce, 0xb7ce, 0x98ce, 0xb8ce, 0x99ce, 0xb9ce, 0x9ace, 0xbace, 0x9bce, 0xbbce, 
  0x9cce, 0xbcce, 0x9dce, 0xbdce, 0x9ece, 0xbece, 0x9fce, 0xbfce, 0xa0ce, 0x80cf, 
  0xa1ce, 0x81cf, 0xa3ce, 0x83cf, 0xa4ce, 0x84cf, 0xa5ce, 0x85cf, 0xa6ce, 0x86cf, 
  0xa7ce, 0x87cf, 0xa8ce, 0x88cf, 0xa9ce, 0x89cf, 0xaace, 0x8acf, 0xabce, 0x8bcf, 
  0x82cf, 0x83cf, 0x90cf, 0xb2ce, 0x91cf, 0xb8ce, 0x95cf, 0x86cf, 0x96cf, 0x80cf, 
  0x98cf, 0x99cf, 0x9acf, 0x9bcf, 0x9ccf, 0x9dcf, 0x9ecf, 0x9fcf, 0xa0cf, 0xa1cf, 
  0xa2cf, 0xa3cf, 0xa4cf, 0xa5cf, 0xa6cf, 0xa7cf, 0xa8cf, 0xa9cf, 0xaacf, 0xabcf, 
  0xaccf, 0xadcf, 0xaecf, 0xafcf, 0xb0cf, 0xbace, 0xb1cf, 0x81cf, 0xb4cf, 0xb8ce, 
  0xb5cf, 0xb5ce, 0xb7cf, 0xb8cf, 0xb9cf, 0xb2cf, 0xbacf, 0xbbcf, 0xbdcf, 0xbbcd, 
  0xbecf, 0xbccd, 0xbfcf, 0xbdcd, 0x80d0, 0x90d1, 0x81d0, 0x91d1, 0x82d0, 0x92d1, 
  0x83d0, 0x93d1, 0x84d0, 0x94d1, 0x85d0, 0x95d1, 0x86d0, 0x96d1, 0x87d0, 0x97d1, 
  0x88d0, 0x98d1, 0x89d0, 0x99d1, 0x8ad0, 0x9ad1, 0x8bd0, 0x9bd1, 0x8cd0, 0x9cd1, 
  0x8dd0, 0x9dd1, 0x8ed0, 0x9ed1, 0x8fd0, 0x9fd1, 0x90d0, 0xb0d0, 0x91d0, 0xb1d0, 
  0x92d0, 0xb2d0, 0x93d0, 0xb3d0, 0x94d0, 0xb4d0, 0x95d0, 0xb5d0, 0x96d0, 0xb6d0, 
  0x97d0, 0xb7d0, 0x98d0, 0xb8d0, 0x99d0, 0xb9d0, 0x9ad0, 0xbad0, 0x9bd0, 0xbbd0, 
  0x9cd0, 0xbcd0, 0x9dd0, 0xbdd0, 0x9ed0, 0xbed0, 0x9fd0, 0xbfd0, 0xa0d0, 0x80d1, 
  0xa1d0, 0x81d1, 0xa2d0, 0x82d1, 0xa3d0, 0x83d1, 0xa4d0, 0x84d1, 0xa5d0, 0x85d1, 
  0xa6d0, 0x86d1, 0xa7d0, 0x87d1, 0xa8d0, 0x88d1, 0xa9d0, 0x89d1, 0xaad0, 0x8ad1, 
  0xabd0, 0x8bd1, 0xacd0, 0x8cd1, 0xadd0, 0x8dd1, 0xaed0, 0x8ed1, 0xafd0, 0x8fd1, 
  0xa0d1, 0xa1d1, 0xa2d1, 0xa3d1, 0xa4d1, 0xa5d1, 0xa6d1, 0xa7d1, 0xa8d1, 0xa9d1, 
  0xaad1, 0xabd1, 0xacd1, 0xadd1, 0xaed1, 0xafd1, 0xb0d1, 0xb1d1, 0xb2d1, 0xb3d1, 
  0xb4d1, 0xb5d1, 0xb6d1, 0xb7d1, 0xb8d1, 0xb9d1, 0xbad1, 0xbbd1, 0xbcd1, 0xbdd1, 
  0xbed1, 0xbfd1, 0x80d2, 0x81d2, 0x8ad2, 0x8bd2, 0x8cd2, 0x8dd2, 0x8ed2, 0x8fd2, 
  0x90d2, 0x91d2, 0x92d2, 0x93d2, 0x94d2, 0x95d2, 0x96d2, 0x97d2, 0x98d2, 0x99d2, 
  0x9ad2, 0x9bd2, 0x9cd2, 0x9dd2, 0x9ed2, 0x9fd2, 0xa0d2, 0xa1d2, 0xa2d2, 0xa3d2, 
  0xa4d2, 0xa5d2, 0xa6d2, 0xa7d2, 0xa8d2, 0xa9d2, 0xaad2, 0xabd2, 0xacd2, 0xadd2, 
  0xaed2, 0xafd2, 0xb0d2, 0xb1d2, 0xb2d2, 0xb3d2, 0xb4d2, 0xb5d2, 0xb6d2, 0xb7d2, 
  0xb8d2, 0xb9d2, 0xbad2, 0xbbd2, 0xbcd2, 0xbdd2, 0xbed2, 0xbfd2, 0x80d3, 0x8fd3, 
  0x81d3, 0x82d3, 0x83d3, 0x84d3, 0x85d3, 0x86d3, 0x87d3, 0x88d3, 0x89d3, 0x8ad3, 
  0x8bd3, 0x8cd3, 0x8dd3, 0x8ed3, 0x90d3, 0x91d3, 0x92d3, 0x93d3, 0x94d3, 0x95d3, 
  0x96d3, 0x97d3, 0x98d3, 0x99d3, 0x9ad3, 0x9bd3, 0x9cd3, 0x9dd3, 0x9ed3, 0x9fd3, 
  0xa0d3, 0xa1d3, 0xa2d3, 0xa3d3, 0xa4d3, 0xa5d3, 0xa6d3, 0xa7d3, 0xa8d3, 0xa9d3, 
  0xaad3, 0xabd3, 0xacd3, 0xadd3, 0xaed3, 0xafd3, 0xb0d3, 0xb1d3, 0xb2d3, 0xb3d3, 
  0xb4d3, 0xb5d3, 0xb6d3, 0xb7d3, 0xb8d3, 0xb9d3, 0xbad3, 0xbbd3, 0xbcd3, 0xbdd3, 
  0xbed3, 0xbfd3, 0x80d4, 0x81d4, 0x82d4, 0x83d4, 0x84d4, 0x85d4, 0x86d4, 0x87d4, 
  0x88d4, 0x89d4, 0x8ad4, 0x8bd4, 0x8cd4, 0x8dd4, 0x8ed4, 0x8fd4, 0x90d4, 0x91d4, 
  0x92d4, 0x93d4, 0xb1d4, 0xa1d5, 0xb2d4, 0xa2d5, 0xb3d4, 0xa3d5, 0xb4d4, 0xa4d5, 
  0xb5d4, 0xa5d5, 0xb6d4, 0xa6d5, 0xb7d4, 0xa7d5, 0xb8d4, 0xa8d5, 0xb9d4, 0xa9d5, 
  0xbad4, 0xaad5, 0xbbd4, 0xabd5, 0xbcd4, 0xacd5, 0xbdd4, 0xadd5, 0xbed4, 0xaed5, 
  0xbfd4, 0xafd5, 0x80d5, 0xb0d5, 0x81d5, 0xb1d5, 0x82d5, 0xb2d5, 0x83d5, 0xb3d5, 
  0x84d5, 0xb4d5, 0x85d5, 0xb5d5, 0x86d5, 0xb6d5, 0x87d5, 0xb7d5, 0x88d5, 0xb8d5, 
  0x89d5, 0xb9d5, 0x8ad5, 0xbad5, 0x8bd5, 0xbbd5, 0x8cd5, 0xbcd5, 0x8dd5, 0xbdd5, 
  0x8ed5, 0xbed5, 0x8fd5, 0xbfd5, 0x90d5, 0x80d6, 0x91d5, 0x81d6, 0x92d5, 0x82d6, 
  0x93d5, 0x83d6, 0x94d5, 0x84d6, 0x95d5, 0x85d6, 0x96d5, 0x86d6, 0xa082e1, 0x80b4e2, 
  0xa182e1, 0x81b4e2, 0xa282e1, 0x82b4e2, 0xa382e1, 0x83b4e2, 0xa482e1, 0x84b4e2, 
  0xa582e1, 0x85b4e2, 0xa682e1, 0x86b4e2, 0xa782e1, 0x87b4e2, 0xa882e1, 0x88b4e2, 
  0xa982e1, 0x89b4e2, 0xaa82e1, 0x8ab4e2, 0xab82e1, 0x8bb4e2, 0xac82e1, 0x8cb4e2, 
  0xad82e1, 0x8db4e2, 0xae82e1, 0x8eb4e2, 0xaf82e1, 0x8fb4e2, 0xb082e1, 0x90b4e2, 
  0xb182e1, 0x91b4e2, 0xb282e1, 0x92b4e2, 0xb382e1, 0x93b4e2, 0xb482e1, 0x94b4e2, 
  0xb582e1, 0x95b4e2, 0xb682e1, 0x96b4e2, 0xb782e1, 0x97b4e2, 0xb882e1, 0x98b4e2, 
  0xb982e1, 0x99b4e2, 0xba82e1, 0x9ab4e2, 0xbb82e1, 0x9bb4e2, 0xbc82e1, 0x9cb4e2, 
  0xbd82e1, 0x9db4e2, 0xbe82e1, 0x9eb4e2, 0xbf82e1, 0x9fb4e2, 0x8083e1, 0xa0b4e2, 
  0x8183e1, 0xa1b4e2, 0x8283e1, 0xa2b4e2, 0x8383e1, 0xa3b4e2, 0x8483e1, 0xa4b4e2, 
  0x8583e1, 0xa5b4e2, 0x80b8e1, 0x81b8e1, 0x82b8e1, 0x83b8e1, 0x84b8e1, 0x85b8e1, 
  0x86b8e1, 0x87b8e1, 0x88b8e1, 0x89b8e1, 0x8ab8e1, 0x8bb8e1, 0x8cb8e1, 0x8db8e1, 
  0x8eb8e1, 0x8fb8e1, 0x90b8e1, 0x91b8e1, 0x92b8e1, 0x93b8e1, 0x94b8e1, 0x95b8e1, 
  0x96b8e1, 0x97b8e1, 0x98b8e1, 0x99b8e1, 0x9ab8e1, 0x9bb8e1, 0x9cb8e1, 0x9db8e1, 
  0x9eb8e1, 0x9fb8e1, 0xa0b8e1, 0xa1b8e1, 0xa2b8e1, 0xa3b8e1, 0xa4b8e1, 0xa5b8e1, 
  0xa6b8e1, 0xa7b8e1, 0xa8b8e1, 0xa9b8e1, 0xaab8e1, 0xabb8e1, 0xacb8e1, 0xadb8e1, 
  0xaeb8e1, 0xafb8e1, 0xb0b8e1, 0xb1b8e1, 0xb2b8e1, 0xb3b8e1, 0xb4b8e1, 0xb5b8e1, 
  0xb6b8e1, 0xb7b8e1, 0xb8b8e1, 0xb9b8e1, 0xbab8e1, 0xbbb8e1, 0xbcb8e1, 0xbdb8e1, 
  0xbeb8e1, 0xbfb8e1, 0x80b9e1, 0x81b9e1, 0x82b9e1, 0x83b9e1, 0x84b9e1, 0x85b9e1, 
  0x86b9e1, 0x87b9e1, 0x88b9e1, 0x89b9e1, 0x8ab9e1, 0x8bb9e1, 0x8cb9e1, 0x8db9e1, 
  0x8eb9e1, 0x8fb9e1, 0x90b9e1, 0x91b9e1, 0x92b9e1, 0x93b9e1, 0x94b9e1, 0x95b9e1, 
  0x96b9e1, 0x97b9e1, 0x98b9e1, 0x99b9e1, 0x9ab9e1, 0x9bb9e1, 0x9cb9e1, 0x9db9e1, 
  0x9eb9e1, 0x9fb9e1, 0xa0b9e1, 0xa1b9e1, 0xa2b9e1, 0xa3b9e1, 0xa4b9e1, 0xa5b9e1, 
  0xa6b9e1, 0xa7b9e1, 0xa8b9e1, 0xa9b9e1, 0xaab9e1, 0xabb9e1, 0xacb9e1, 0xadb9e1, 
  0xaeb9e1, 0xafb9e1, 0xb0b9e1, 0xb1b9e1, 0xb2b9e1, 0xb3b9e1, 0xb4b9e1, 0xb5b9e1, 
  0xb6b9e1, 0xb7b9e1, 0xb8b9e1, 0xb9b9e1, 0xbab9e1, 0xbbb9e1, 0xbcb9e1, 0xbdb9e1, 
  0xbeb9e1, 0xbfb9e1, 0x80bae1, 0x81bae1, 0x82bae1, 0x83bae1, 0x84bae1, 0x85bae1, 
  0x86bae1, 0x87bae1, 0x88bae1, 0x89bae1, 0x8abae1, 0x8bbae1, 0x8cbae1, 0x8dbae1, 
  0x8ebae1, 0x8fbae1, 0x90bae1, 0x91bae1, 0x92bae1, 0x93bae1, 0x94bae1, 0x95bae1, 
  0x9bbae1, 0xa1b9e1, 0xa0bae1, 0xa1bae1, 0xa2bae1, 0xa3bae1, 0xa4bae1, 0xa5bae1, 
  0xa6bae1, 0xa7bae1, 0xa8bae1, 0xa9bae1, 0xaabae1, 0xabbae1, 0xacbae1, 0xadbae1, 
  0xaebae1, 0xafbae1, 0xb0bae1, 0xb1bae1, 0xb2bae1, 0xb3bae1, 0xb4bae1, 0xb5bae1, 
  0xb6bae1, 0xb7bae1, 0xb8bae1, 0xb9bae1, 0xbabae1, 0xbbbae1, 0xbcbae1, 0xbdbae1, 
  0xbebae1, 0xbfbae1, 0x80bbe1, 0x81bbe1, 0x82bbe1, 0x83bbe1, 0x84bbe1, 0x85bbe1, 
  0x86bbe1, 0x87bbe1, 0x88bbe1, 0x89bbe1, 0x8abbe1, 0x8bbbe1, 0x8cbbe1, 0x8dbbe1, 
  0x8ebbe1, 0x8fbbe1, 0x90bbe1, 0x91bbe1, 0x92bbe1, 0x93bbe1, 0x94bbe1, 0x95bbe1, 
  0x96bbe1, 0x97bbe1, 0x98bbe1, 0x99bbe1, 0x9abbe1, 0x9bbbe1, 0x9cbbe1, 0x9dbbe1, 
  0x9ebbe1, 0x9fbbe1, 0xa0bbe1, 0xa1bbe1, 0xa2bbe1, 0xa3bbe1, 0xa4bbe1, 0xa5bbe1, 
  0xa6bbe1, 0xa7bbe1, 0xa8bbe1, 0xa9bbe1, 0xaabbe1, 0xabbbe1, 0xacbbe1, 0xadbbe1, 
  0xaebbe1, 0xafbbe1, 0xb0bbe1, 0xb1bbe1, 0xb2bbe1, 0xb3bbe1, 0xb4bbe1, 0xb5bbe1, 
  0xb6bbe1, 0xb7bbe1, 0xb8bbe1, 0xb9bbe1, 0x88bce1, 0x80bce1, 0x89bce1, 0x81bce1, 
  0x8abce1, 0x82bce1, 0x8bbce1, 0x83bce1, 0x8cbce1, 0x84bce1, 0x8dbce1, 0x85bce1, 
  0x8ebce1, 0x86bce1, 0x8fbce1, 0x87bce1, 0x98bce1, 0x90bce1, 0x99bce1, 0x91bce1, 
  0x9abce1, 0x92bce1, 0x9bbce1, 0x93bce1, 0x9cbce1, 0x94bce1, 0x9dbce1, 0x95bce1, 
  0xa8bce1, 0xa0bce1, 0xa9bce1, 0xa1bce1, 0xaabce1, 0xa2bce1, 0xabbce1, 0xa3bce1, 
  0xacbce1, 0xa4bce1, 0xadbce1, 0xa5bce1, 0xaebce1, 0xa6bce1, 0xafbce1, 0xa7bce1, 
  0xb8bce1, 0xb0bce1, 0xb9bce1, 0xb1bce1, 0xbabce1, 0xb2bce1, 0xbbbce1, 0xb3bce1, 
  0xbcbce1, 0xb4bce1, 0xbdbce1, 0xb5bce1, 0xbebce1, 0xb6bce1, 0xbfbce1, 0xb7bce1, 
  0x88bde1, 0x80bde1, 0x89bde1, 0x81bde1, 0x8abde1, 0x82bde1, 0x8bbde1, 0x83bde1, 
  0x8cbde1, 0x84bde1, 0x8dbde1, 0x85bde1, 0x99bde1, 0x91bde1, 0x9bbde1, 0x93bde1, 
  0x9dbde1, 0x95bde1, 0x9fbde1, 0x97bde1, 0xa8bde1, 0xa0bde1, 0xa9bde1, 0xa1bde1, 
  0xaabde1, 0xa2bde1, 0xabbde1, 0xa3bde1, 0xacbde1, 0xa4bde1, 0xadbde1, 0xa5bde1, 
  0xaebde1, 0xa6bde1, 0xafbde1, 0xa7bde1, 0x88bee1, 0x80bee1, 0x89bee1, 0x81bee1, 
  0x8abee1, 0x82bee1, 0x8bbee1, 0x83bee1, 0x8cbee1, 0x84bee1, 0x8dbee1, 0x85bee1, 
  0x8ebee1, 0x86bee1, 0x8fbee1, 0x87bee1, 0x98bee1, 0x90bee1, 0x99bee1, 0x91bee1, 
  0x9abee1, 0x92bee1, 0x9bbee1, 0x93bee1, 0x9cbee1, 0x94bee1, 0x9dbee1, 0x95bee1, 
  0x9ebee1, 0x96bee1, 0x9fbee1, 0x97bee1, 0xa8bee1, 0xa0bee1, 0xa9bee1, 0xa1bee1, 
  0xaabee1, 0xa2bee1, 0xabbee1, 0xa3bee1, 0xacbee1, 0xa4bee1, 0xadbee1, 0xa5bee1, 
  0xaebee1, 0xa6bee1, 0xafbee1, 0xa7bee1, 0xb8bee1, 0xb0bee1, 0xb9bee1, 0xb1bee1, 
  0xbabee1, 0xb0bde1, 0xbbbee1, 0xb1bde1, 0xbcbee1, 0xb3bee1, 0xbebee1, 0xb9ce, 
  0x88bfe1, 0xb2bde1, 0x89bfe1, 0xb3bde1, 0x8abfe1, 0xb4bde1, 0x8bbfe1, 0xb5bde1, 
  0x8cbfe1, 0x83bfe1, 0x98bfe1, 0x90bfe1, 0x99bfe1, 0x91bfe1, 0x9abfe1, 0xb6bde1, 
  0x9bbfe1, 0xb7bde1, 0xa8bfe1, 0xa0bfe1, 0xa9bfe1, 0xa1bfe1, 0xaabfe1, 0xbabde1, 
  0xabbfe1, 0xbbbde1, 0xacbfe1, 0xa5bfe1, 0xb8bfe1, 0xb8bde1, 0xb9bfe1, 0xb9bde1, 
  0xbabfe1, 0xbcbde1, 0xbbbfe1, 0xbdbde1, 0xbcbfe1, 0xb3bfe1, 0xa684e2, 0x89cf, 
  0xaa84e2, 0x6b, 0xab84e2, 0xa5c3, 0xb284e2, 0x8e85e2, 0xa085e2, 0xb085e2, 0xa185e2, 
  0xb185e2, 0xa285e2, 0xb285e2, 0xa385e2, 0xb385e2, 0xa485e2, 0xb485e2, 0xa585e2, 
  0xb585e2, 0xa685e2, 0xb685e2, 0xa785e2, 0xb785e2, 0xa885e2, 0xb885e2, 0xa985e2, 
  0xb985e2, 0xaa85e2, 0xba85e2, 0xab85e2, 0xbb85e2, 0xac85e2, 0xbc85e2, 0xad85e2, 
  0xbd85e2, 0xae85e2, 0xbe85e2, 0xaf85e2, 0xbf85e2, 0x8386e2, 0x8486e2, 0xb692e2, 
  0x9093e2, 0xb792e2, 0x9193e2, 0xb892e2, 0x9293e2, 0xb992e2, 0x9393e2, 0xba92e2, 
  0x9493e2, 0xbb92e2, 0x9593e2, 0xbc92e2, 0x9693e2, 0xbd92e2, 0x9793e2, 0xbe92e2, 
  0x9893e2, 0xbf92e2, 0x9993e2, 0x8093e2, 0x9a93e2, 0x8193e2, 0x9b93e2, 0x8293e2, 
  0x9c93e2, 0x8393e2, 0x9d93e2, 0x8493e2, 0x9e93e2, 0x8593e2, 0x9f93e2, 0x8693e2, 
  0xa093e2, 0x8793e2, 0xa193e2, 0x8893e2, 0xa293e2, 0x8993e2, 0xa393e2, 0x8a93e2, 
  0xa493e2, 0x8b93e2, 0xa593e2, 0x8c93e2, 0xa693e2, 0x8d93e2, 0xa793e2, 0x8e93e2, 
  0xa893e2, 0x8f93e2, 0xa993e2, 0x80b0e2, 0xb0b0e2, 0x81b0e2, 0xb1b0e2, 0x82b0e2, 
  0xb2b0e2, 0x83b0e2, 0xb3b0e2, 0x84b0e2, 0xb4b0e2, 0x85b0e2, 0xb5b0e2, 0x86b0e2, 
  0xb6b0e2, 0x87b0e2, 0xb7b0e2, 0x88b0e2, 0xb8b0e2, 0x89b0e2, 0xb9b0e2, 0x8ab0e2, 
  0xbab0e2, 0x8bb0e2, 0xbbb0e2, 0x8cb0e2, 0xbcb0e2, 0x8db0e2, 0xbdb0e2, 0x8eb0e2, 
  0xbeb0e2, 0x8fb0e2, 0xbfb0e2, 0x90b0e2, 0x80b1e2, 0x91b0e2, 0x81b1e2, 0x92b0e2, 
  0x82b1e2, 0x93b0e2, 0x83b1e2, 0x94b0e2, 0x84b1e2, 0x95b0e2, 0x85b1e2, 0x96b0e2, 
  0x86b1e2, 0x97b0e2, 0x87b1e2, 0x98b0e2, 0x88b1e2, 0x99b0e2, 0x89b1e2, 0x9ab0e2, 
  0x8ab1e2, 0x9bb0e2, 0x8bb1e2, 0x9cb0e2, 0x8cb1e2, 0x9db0e2, 0x8db1e2, 0x9eb0e2, 
  0x8eb1e2, 0x9fb0e2, 0x8fb1e2, 0xa0b0e2, 0x90b1e2, 0xa1b0e2, 0x91b1e2, 0xa2b0e2, 
  0x92b1e2, 0xa3b0e2, 0x93b1e2, 0xa4b0e2, 0x94b1e2, 0xa5b0e2, 0x95b1e2, 0xa6b0e2, 
  0x96b1e2, 0xa7b0e2, 0x97b1e2, 0xa8b0e2, 0x98b1e2, 0xa9b0e2, 0x99b1e2, 0xaab0e2, 
  0x9ab1e2, 0xabb0e2, 0x9bb1e2, 0xacb0e2, 0x9cb1e2, 0xadb0e2, 0x9db1e2, 0xaeb0e2, 
  0x9eb1e2, 0xa0b1e2, 0xa1b1e2, 0xa2b1e2, 0xabc9, 0xa3b1e2, 0xbdb5e1, 0xa4b1e2, 
  0xbdc9, 0xa7b1e2, 0xa8b1e2, 0xa9b1e2, 0xaab1e2, 0xabb1e2, 0xacb1e2, 0xb5b1e2, 
  0xb6b1e2, 0x80b2e2, 0x81b2e2, 0x82b2e2, 0x83b2e2, 0x84b2e2, 0x85b2e2, 0x86b2e2, 
  0x87b2e2, 0x88b2e2, 0x89b2e2, 0x8ab2e2, 0x8bb2e2, 0x8cb2e2, 0x8db2e2, 0x8eb2e2, 
  0x8fb2e2, 0x90b2e2, 0x91b2e2, 0x92b2e2, 0x93b2e2, 0x94b2e2, 0x95b2e2, 0x96b2e2, 
  0x97b2e2, 0x98b2e2, 0x99b2e2, 0x9ab2e2, 0x9bb2e2, 0x9cb2e2, 0x9db2e2, 0x9eb2e2, 
  0x9fb2e2, 0xa0b2e2, 0xa1b2e2, 0xa2b2e2, 0xa3b2e2, 0xa4b2e2, 0xa5b2e2, 0xa6b2e2, 
  0xa7b2e2, 0xa8b2e2, 0xa9b2e2, 0xaab2e2, 0xabb2e2, 0xacb2e2, 0xadb2e2, 0xaeb2e2, 
  0xafb2e2, 0xb0b2e2, 0xb1b2e2, 0xb2b2e2, 0xb3b2e2, 0xb4b2e2, 0xb5b2e2, 0xb6b2e2, 
  0xb7b2e2, 0xb8b2e2, 0xb9b2e2, 0xbab2e2, 0xbbb2e2, 0xbcb2e2, 0xbdb2e2, 0xbeb2e2, 
  0xbfb2e2, 0x80b3e2, 0x81b3e2, 0x82b3e2, 0x83b3e2, 0x84b3e2, 0x85b3e2, 0x86b3e2, 
  0x87b3e2, 0x88b3e2, 0x89b3e2, 0x8ab3e2, 0x8bb3e2, 0x8cb3e2, 0x8db3e2, 0x8eb3e2, 
  0x8fb3e2, 0x90b3e2, 0x91b3e2, 0x92b3e2, 0x93b3e2, 0x94b3e2, 0x95b3e2, 0x96b3e2, 
  0x97b3e2, 0x98b3e2, 0x99b3e2, 0x9ab3e2, 0x9bb3e2, 0x9cb3e2, 0x9db3e2, 0x9eb3e2, 
  0x9fb3e2, 0xa0b3e2, 0xa1b3e2, 0xa2b3e2, 0xa3b3e2, 0xa1bcef, 0x81bdef, 0xa2bcef, 
  0x82bdef, 0xa3bcef, 0x83bdef, 0xa4bcef, 0x84bdef, 0xa5bcef, 0x85bdef, 0xa6bcef, 
  0x86bdef, 0xa7bcef, 0x87bdef, 0xa8bcef, 0x88bdef, 0xa9bcef, 0x89bdef, 0xaabcef, 
  0x8abdef, 0xabbcef, 0x8bbdef, 0xacbcef, 0x8cbdef, 0xadbcef, 0x8dbdef, 0xaebcef, 
  0x8ebdef, 0xafbcef, 0x8fbdef, 0xb0bcef, 0x90bdef, 0xb1bcef, 0x91bdef, 0xb2bcef, 
  0x92bdef, 0xb3bcef, 0x93bdef, 0xb4bcef, 0x94bdef, 0xb5bcef, 0x95bdef, 0xb6bcef, 
  0x96bdef, 0xb7bcef, 0x97bdef, 0xb8bcef, 0x98bdef, 0xb9bcef, 0x99bdef, 0xbabcef, 
  0x9abdef, 0x809090f0, 0xa89090f0, 0x819090f0, 0xa99090f0, 0x829090f0, 0xaa9090f0, 
  0x839090f0, 0xab9090f0, 0x849090f0, 0xac9090f0, 0x859090f0, 0xad9090f0, 0x869090f0, 
  0xae9090f0, 0x879090f0, 0xaf9090f0, 0x889090f0, 0xb09090f0, 0x899090f0, 0xb19090f0, 
  0x8a9090f0, 0xb29090f0, 0x8b9090f0, 0xb39090f0, 0x8c9090f0, 0xb49090f0, 0x8d9090f0, 
  0xb59090f0, 0x8e9090f0, 0xb69090f0, 0x8f9090f0, 0xb79090f0, 0x909090f0, 0xb89090f0, 
  0x919090f0, 0xb99090f0, 0x929090f0, 0xba9090f0, 0x939090f0, 0xbb9090f0, 0x949090f0, 
  0xbc9090f0, 0x959090f0, 0xbd9090f0, 0x969090f0, 0xbe9090f0, 0x979090f0, 0xbf9090f0, 
  0x989090f0, 0x809190f0, 0x999090f0, 0x819190f0, 0x9a9090f0, 0x829190f0, 0x9b9090f0, 
  0x839190f0, 0x9c9090f0, 0x849190f0, 0x9d9090f0, 0x859190f0, 0x9e9090f0, 0x869190f0, 
  0x9f9090f0, 0x879190f0, 0xa09090f0, 0x889190f0, 0xa19090f0, 0x899190f0, 0xa29090f0, 
  0x8a9190f0, 0xa39090f0, 0x8b9190f0, 0xa49090f0, 0x8c9190f0, 0xa59090f0, 0x8d9190f0, 
  0xa69090f0, 0x8e9190f0, 0xa79090f0, 0x8f9190f0
  };

/** Map lowercase to UPPERCASE for UTF-8 */
unsigned long utf8_to_upper[CASE_FOLDINGS] = {
  0x61, 0x41, 0x62, 0x42, 0x63, 0x43, 0x64, 0x44, 0x65, 0x45, 0x66, 0x46, 0x67, 
  0x47, 0x68, 0x48, 0x69, 0x49, 0x6a, 0x4a, 0x6b, 0x4b, 0x6c, 0x4c, 0x6d, 0x4d, 
  0x6e, 0x4e, 0x6f, 0x4f, 0x70, 0x50, 0x71, 0x51, 0x72, 0x52, 0x73, 0x53, 0x74, 
  0x54, 0x75, 0x55, 0x76, 0x56, 0x77, 0x57, 0x78, 0x58, 0x79, 0x59, 0x7a, 0x5a, 
  0xbcce, 0xb5c2, 0xa0c3, 0x80c3, 0xa1c3, 0x81c3, 0xa2c3, 0x82c3, 0xa3c3, 0x83c3, 
  0xa4c3, 0x84c3, 0xa5c3, 0x85c3, 0xa6c3, 0x86c3, 0xa7c3, 0x87c3, 0xa8c3, 0x88c3, 
  0xa9c3, 0x89c3, 0xaac3, 0x8ac3, 0xabc3, 0x8bc3, 0xacc3, 0x8cc3, 0xadc3, 0x8dc3, 
  0xaec3, 0x8ec3, 0xafc3, 0x8fc3, 0xb0c3, 0x90c3, 0xb1c3, 0x91c3, 0xb2c3, 0x92c3, 
  0xb3c3, 0x93c3, 0xb4c3, 0x94c3, 0xb5c3, 0x95c3, 0xb6c3, 0x96c3, 0xb8c3, 0x98c3, 
  0xb9c3, 0x99c3, 0xbac3, 0x9ac3, 0xbbc3, 0x9bc3, 0xbcc3, 0x9cc3, 0xbdc3, 0x9dc3, 
  0xbec3, 0x9ec3, 0x81c4, 0x80c4, 0x83c4, 0x82c4, 0x85c4, 0x84c4, 0x87c4, 0x86c4, 
  0x89c4, 0x88c4, 0x8bc4, 0x8ac4, 0x8dc4, 0x8cc4, 0x8fc4, 0x8ec4, 0x91c4, 0x90c4, 
  0x93c4, 0x92c4, 0x95c4, 0x94c4, 0x97c4, 0x96c4, 0x99c4, 0x98c4, 0x9bc4, 0x9ac4, 
  0x9dc4, 0x9cc4, 0x9fc4, 0x9ec4, 0xa1c4, 0xa0c4, 0xa3c4, 0xa2c4, 0xa5c4, 0xa4c4, 
  0xa7c4, 0xa6c4, 0xa9c4, 0xa8c4, 0xabc4, 0xaac4, 0xadc4, 0xacc4, 0xafc4, 0xaec4, 
  0xb3c4, 0xb2c4, 0xb5c4, 0xb4c4, 0xb7c4, 0xb6c4, 0xbac4, 0xb9c4, 0xbcc4, 0xbbc4, 
  0xbec4, 0xbdc4, 0x80c5, 0xbfc4, 0x82c5, 0x81c5, 0x84c5, 0x83c5, 0x86c5, 0x85c5, 
  0x88c5, 0x87c5, 0x8bc5, 0x8ac5, 0x8dc5, 0x8cc5, 0x8fc5, 0x8ec5, 0x91c5, 0x90c5, 
  0x93c5, 0x92c5, 0x95c5, 0x94c5, 0x97c5, 0x96c5, 0x99c5, 0x98c5, 0x9bc5, 0x9ac5, 
  0x9dc5, 0x9cc5, 0x9fc5, 0x9ec5, 0xa1c5, 0xa0c5, 0xa3c5, 0xa2c5, 0xa5c5, 0xa4c5, 
  0xa7c5, 0xa6c5, 0xa9c5, 0xa8c5, 0xabc5, 0xaac5, 0xadc5, 0xacc5, 0xafc5, 0xaec5, 
  0xb1c5, 0xb0c5, 0xb3c5, 0xb2c5, 0xb5c5, 0xb4c5, 0xb7c5, 0xb6c5, 0xbfc3, 0xb8c5, 
  0xbac5, 0xb9c5, 0xbcc5, 0xbbc5, 0xbec5, 0xbdc5, 0x73, 0xbfc5, 0x93c9, 0x81c6, 
  0x83c6, 0x82c6, 0x85c6, 0x84c6, 0x94c9, 0x86c6, 0x88c6, 0x87c6, 0x96c9, 0x89c6, 
  0x97c9, 0x8ac6, 0x8cc6, 0x8bc6, 0x9dc7, 0x8ec6, 0x99c9, 0x8fc6, 0x9bc9, 0x90c6, 
  0x92c6, 0x91c6, 0xa0c9, 0x93c6, 0xa3c9, 0x94c6, 0xa9c9, 0x96c6, 0xa8c9, 0x97c6, 
  0x99c6, 0x98c6, 0xafc9, 0x9cc6, 0xb2c9, 0x9dc6, 0xb5c9, 0x9fc6, 0xa1c6, 0xa0c6, 
  0xa3c6, 0xa2c6, 0xa5c6, 0xa4c6, 0x80ca, 0xa6c6, 0xa8c6, 0xa7c6, 0x83ca, 0xa9c6, 
  0xadc6, 0xacc6, 0x88ca, 0xaec6, 0xb0c6, 0xafc6, 0x8aca, 0xb1c6, 0x8bca, 0xb2c6, 
  0xb4c6, 0xb3c6, 0xb6c6, 0xb5c6, 0x92ca, 0xb7c6, 0xb9c6, 0xb8c6, 0xbdc6, 0xbcc6, 
  0x86c7, 0x84c7, 0x86c7, 0x85c7, 0x89c7, 0x87c7, 0x89c7, 0x88c7, 0x8cc7, 0x8ac7, 
  0x8cc7, 0x8bc7, 0x8ec7, 0x8dc7, 0x90c7, 0x8fc7, 0x92c7, 0x91c7, 0x94c7, 0x93c7, 
  0x96c7, 0x95c7, 0x98c7, 0x97c7, 0x9ac7, 0x99c7, 0x9cc7, 0x9bc7, 0x9fc7, 0x9ec7, 
  0xa1c7, 0xa0c7, 0xa3c7, 0xa2c7, 0xa5c7, 0xa4c7, 0xa7c7, 0xa6c7, 0xa9c7, 0xa8c7, 
  0xabc7, 0xaac7, 0xadc7, 0xacc7, 0xafc7, 0xaec7, 0xb3c7, 0xb1c7, 0xb3c7, 0xb2c7, 
  0xb5c7, 0xb4c7, 0x95c6, 0xb6c7, 0xbfc6, 0xb7c7, 0xb9c7, 0xb8c7, 0xbbc7, 0xbac7, 
  0xbdc7, 0xbcc7, 0xbfc7, 0xbec7, 0x81c8, 0x80c8, 0x83c8, 0x82c8, 0x85c8, 0x84c8, 
  0x87c8, 0x86c8, 0x89c8, 0x88c8, 0x8bc8, 0x8ac8, 0x8dc8, 0x8cc8, 0x8fc8, 0x8ec8, 
  0x91c8, 0x90c8, 0x93c8, 0x92c8, 0x95c8, 0x94c8, 0x97c8, 0x96c8, 0x99c8, 0x98c8, 
  0x9bc8, 0x9ac8, 0x9dc8, 0x9cc8, 0x9fc8, 0x9ec8, 0x9ec6, 0xa0c8, 0xa3c8, 0xa2c8, 
  0xa5c8, 0xa4c8, 0xa7c8, 0xa6c8, 0xa9c8, 0xa8c8, 0xabc8, 0xaac8, 0xadc8, 0xacc8, 
  0xafc8, 0xaec8, 0xb1c8, 0xb0c8, 0xb3c8, 0xb2c8, 0xa5b1e2, 0xbac8, 0xbcc8, 0xbbc8, 
  0x9ac6, 0xbdc8, 0xa6b1e2, 0xbec8, 0x82c9, 0x81c9, 0x80c6, 0x83c9, 0x89ca, 0x84c9, 
  0x8cca, 0x85c9, 0x87c9, 0x86c9, 0x89c9, 0x88c9, 0x8bc9, 0x8ac9, 0x8dc9, 0x8cc9, 
  0x8fc9, 0x8ec9, 0xb9ce, 0x85cd, 0xacce, 0x86ce, 0xadce, 0x88ce, 0xaece, 0x89ce, 
  0xafce, 0x8ace, 0x8ccf, 0x8cce, 0x8dcf, 0x8ece, 0x8ecf, 0x8fce, 0xb1ce, 0x91ce, 
  0xb2ce, 0x92ce, 0xb3ce, 0x93ce, 0xb4ce, 0x94ce, 0xb5ce, 0x95ce, 0xb6ce, 0x96ce, 
  0xb7ce, 0x97ce, 0xb8ce, 0x98ce, 0xb9ce, 0x99ce, 0xbace, 0x9ace, 0xbbce, 0x9bce, 
  0xbcce, 0x9cce, 0xbdce, 0x9dce, 0xbece, 0x9ece, 0xbfce, 0x9fce, 0x80cf, 0xa0ce, 
  0x81cf, 0xa1ce, 0x83cf, 0xa3ce, 0x84cf, 0xa4ce, 0x85cf, 0xa5ce, 0x86cf, 0xa6ce, 
  0x87cf, 0xa7ce, 0x88cf, 0xa8ce, 0x89cf, 0xa9ce, 0x8acf, 0xaace, 0x8bcf, 0xabce, 
  0x83cf, 0x82cf, 0xb2ce, 0x90cf, 0xb8ce, 0x91cf, 0x86cf, 0x95cf, 0x80cf, 0x96cf, 
  0x99cf, 0x98cf, 0x9bcf, 0x9acf, 0x9dcf, 0x9ccf, 0x9fcf, 0x9ecf, 0xa1cf, 0xa0cf, 
  0xa3cf, 0xa2cf, 0xa5cf, 0xa4cf, 0xa7cf, 0xa6cf, 0xa9cf, 0xa8cf, 0xabcf, 0xaacf, 
  0xadcf, 0xaccf, 0xafcf, 0xaecf, 0xbace, 0xb0cf, 0x81cf, 0xb1cf, 0xb8ce, 0xb4cf, 
  0xb5ce, 0xb5cf, 0xb8cf, 0xb7cf, 0xb2cf, 0xb9cf, 0xbbcf, 0xbacf, 0xbbcd, 0xbdcf, 
  0xbccd, 0xbecf, 0xbdcd, 0xbfcf, 0x90d1, 0x80d0, 0x91d1, 0x81d0, 0x92d1, 0x82d0, 
  0x93d1, 0x83d0, 0x94d1, 0x84d0, 0x95d1, 0x85d0, 0x96d1, 0x86d0, 0x97d1, 0x87d0, 
  0x98d1, 0x88d0, 0x99d1, 0x89d0, 0x9ad1, 0x8ad0, 0x9bd1, 0x8bd0, 0x9cd1, 0x8cd0, 
  0x9dd1, 0x8dd0, 0x9ed1, 0x8ed0, 0x9fd1, 0x8fd0, 0xb0d0, 0x90d0, 0xb1d0, 0x91d0, 
  0xb2d0, 0x92d0, 0xb3d0, 0x93d0, 0xb4d0, 0x94d0, 0xb5d0, 0x95d0, 0xb6d0, 0x96d0, 
  0xb7d0, 0x97d0, 0xb8d0, 0x98d0, 0xb9d0, 0x99d0, 0xbad0, 0x9ad0, 0xbbd0, 0x9bd0, 
  0xbcd0, 0x9cd0, 0xbdd0, 0x9dd0, 0xbed0, 0x9ed0, 0xbfd0, 0x9fd0, 0x80d1, 0xa0d0, 
  0x81d1, 0xa1d0, 0x82d1, 0xa2d0, 0x83d1, 0xa3d0, 0x84d1, 0xa4d0, 0x85d1, 0xa5d0, 
  0x86d1, 0xa6d0, 0x87d1, 0xa7d0, 0x88d1, 0xa8d0, 0x89d1, 0xa9d0, 0x8ad1, 0xaad0, 
  0x8bd1, 0xabd0, 0x8cd1, 0xacd0, 0x8dd1, 0xadd0, 0x8ed1, 0xaed0, 0x8fd1, 0xafd0, 
  0xa1d1, 0xa0d1, 0xa3d1, 0xa2d1, 0xa5d1, 0xa4d1, 0xa7d1, 0xa6d1, 0xa9d1, 0xa8d1, 
  0xabd1, 0xaad1, 0xadd1, 0xacd1, 0xafd1, 0xaed1, 0xb1d1, 0xb0d1, 0xb3d1, 0xb2d1, 
  0xb5d1, 0xb4d1, 0xb7d1, 0xb6d1, 0xb9d1, 0xb8d1, 0xbbd1, 0xbad1, 0xbdd1, 0xbcd1, 
  0xbfd1, 0xbed1, 0x81d2, 0x80d2, 0x8bd2, 0x8ad2, 0x8dd2, 0x8cd2, 0x8fd2, 0x8ed2, 
  0x91d2, 0x90d2, 0x93d2, 0x92d2, 0x95d2, 0x94d2, 0x97d2, 0x96d2, 0x99d2, 0x98d2, 
  0x9bd2, 0x9ad2, 0x9dd2, 0x9cd2, 0x9fd2, 0x9ed2, 0xa1d2, 0xa0d2, 0xa3d2, 0xa2d2, 
  0xa5d2, 0xa4d2, 0xa7d2, 0xa6d2, 0xa9d2, 0xa8d2, 0xabd2, 0xaad2, 0xadd2, 0xacd2, 
  0xafd2, 0xaed2, 0xb1d2, 0xb0d2, 0xb3d2, 0xb2d2, 0xb5d2, 0xb4d2, 0xb7d2, 0xb6d2, 
  0xb9d2, 0xb8d2, 0xbbd2, 0xbad2, 0xbdd2, 0xbcd2, 0xbfd2, 0xbed2, 0x8fd3, 0x80d3, 
  0x82d3, 0x81d3, 0x84d3, 0x83d3, 0x86d3, 0x85d3, 0x88d3, 0x87d3, 0x8ad3, 0x89d3, 
  0x8cd3, 0x8bd3, 0x8ed3, 0x8dd3, 0x91d3, 0x90d3, 0x93d3, 0x92d3, 0x95d3, 0x94d3, 
  0x97d3, 0x96d3, 0x99d3, 0x98d3, 0x9bd3, 0x9ad3, 0x9dd3, 0x9cd3, 0x9fd3, 0x9ed3, 
  0xa1d3, 0xa0d3, 0xa3d3, 0xa2d3, 0xa5d3, 0xa4d3, 0xa7d3, 0xa6d3, 0xa9d3, 0xa8d3, 
  0xabd3, 0xaad3, 0xadd3, 0xacd3, 0xafd3, 0xaed3, 0xb1d3, 0xb0d3, 0xb3d3, 0xb2d3, 
  0xb5d3, 0xb4d3, 0xb7d3, 0xb6d3, 0xb9d3, 0xb8d3, 0xbbd3, 0xbad3, 0xbdd3, 0xbcd3, 
  0xbfd3, 0xbed3, 0x81d4, 0x80d4, 0x83d4, 0x82d4, 0x85d4, 0x84d4, 0x87d4, 0x86d4, 
  0x89d4, 0x88d4, 0x8bd4, 0x8ad4, 0x8dd4, 0x8cd4, 0x8fd4, 0x8ed4, 0x91d4, 0x90d4, 
  0x93d4, 0x92d4, 0xa1d5, 0xb1d4, 0xa2d5, 0xb2d4, 0xa3d5, 0xb3d4, 0xa4d5, 0xb4d4, 
  0xa5d5, 0xb5d4, 0xa6d5, 0xb6d4, 0xa7d5, 0xb7d4, 0xa8d5, 0xb8d4, 0xa9d5, 0xb9d4, 
  0xaad5, 0xbad4, 0xabd5, 0xbbd4, 0xacd5, 0xbcd4, 0xadd5, 0xbdd4, 0xaed5, 0xbed4, 
  0xafd5, 0xbfd4, 0xb0d5, 0x80d5, 0xb1d5, 0x81d5, 0xb2d5, 0x82d5, 0xb3d5, 0x83d5, 
  0xb4d5, 0x84d5, 0xb5d5, 0x85d5, 0xb6d5, 0x86d5, 0xb7d5, 0x87d5, 0xb8d5, 0x88d5, 
  0xb9d5, 0x89d5, 0xbad5, 0x8ad5, 0xbbd5, 0x8bd5, 0xbcd5, 0x8cd5, 0xbdd5, 0x8dd5, 
  0xbed5, 0x8ed5, 0xbfd5, 0x8fd5, 0x80d6, 0x90d5, 0x81d6, 0x91d5, 0x82d6, 0x92d5, 
  0x83d6, 0x93d5, 0x84d6, 0x94d5, 0x85d6, 0x95d5, 0x86d6, 0x96d5, 0x80b4e2, 0xa082e1, 
  0x81b4e2, 0xa182e1, 0x82b4e2, 0xa282e1, 0x83b4e2, 0xa382e1, 0x84b4e2, 0xa482e1, 
  0x85b4e2, 0xa582e1, 0x86b4e2, 0xa682e1, 0x87b4e2, 0xa782e1, 0x88b4e2, 0xa882e1, 
  0x89b4e2, 0xa982e1, 0x8ab4e2, 0xaa82e1, 0x8bb4e2, 0xab82e1, 0x8cb4e2, 0xac82e1, 
  0x8db4e2, 0xad82e1, 0x8eb4e2, 0xae82e1, 0x8fb4e2, 0xaf82e1, 0x90b4e2, 0xb082e1, 
  0x91b4e2, 0xb182e1, 0x92b4e2, 0xb282e1, 0x93b4e2, 0xb382e1, 0x94b4e2, 0xb482e1, 
  0x95b4e2, 0xb582e1, 0x96b4e2, 0xb682e1, 0x97b4e2, 0xb782e1, 0x98b4e2, 0xb882e1, 
  0x99b4e2, 0xb982e1, 0x9ab4e2, 0xba82e1, 0x9bb4e2, 0xbb82e1, 0x9cb4e2, 0xbc82e1, 
  0x9db4e2, 0xbd82e1, 0x9eb4e2, 0xbe82e1, 0x9fb4e2, 0xbf82e1, 0xa0b4e2, 0x8083e1, 
  0xa1b4e2, 0x8183e1, 0xa2b4e2, 0x8283e1, 0xa3b4e2, 0x8383e1, 0xa4b4e2, 0x8483e1, 
  0xa5b4e2, 0x8583e1, 0x81b8e1, 0x80b8e1, 0x83b8e1, 0x82b8e1, 0x85b8e1, 0x84b8e1, 
  0x87b8e1, 0x86b8e1, 0x89b8e1, 0x88b8e1, 0x8bb8e1, 0x8ab8e1, 0x8db8e1, 0x8cb8e1, 
  0x8fb8e1, 0x8eb8e1, 0x91b8e1, 0x90b8e1, 0x93b8e1, 0x92b8e1, 0x95b8e1, 0x94b8e1, 
  0x97b8e1, 0x96b8e1, 0x99b8e1, 0x98b8e1, 0x9bb8e1, 0x9ab8e1, 0x9db8e1, 0x9cb8e1, 
  0x9fb8e1, 0x9eb8e1, 0xa1b8e1, 0xa0b8e1, 0xa3b8e1, 0xa2b8e1, 0xa5b8e1, 0xa4b8e1, 
  0xa7b8e1, 0xa6b8e1, 0xa9b8e1, 0xa8b8e1, 0xabb8e1, 0xaab8e1, 0xadb8e1, 0xacb8e1, 
  0xafb8e1, 0xaeb8e1, 0xb1b8e1, 0xb0b8e1, 0xb3b8e1, 0xb2b8e1, 0xb5b8e1, 0xb4b8e1, 
  0xb7b8e1, 0xb6b8e1, 0xb9b8e1, 0xb8b8e1, 0xbbb8e1, 0xbab8e1, 0xbdb8e1, 0xbcb8e1, 
  0xbfb8e1, 0xbeb8e1, 0x81b9e1, 0x80b9e1, 0x83b9e1, 0x82b9e1, 0x85b9e1, 0x84b9e1, 
  0x87b9e1, 0x86b9e1, 0x89b9e1, 0x88b9e1, 0x8bb9e1, 0x8ab9e1, 0x8db9e1, 0x8cb9e1, 
  0x8fb9e1, 0x8eb9e1, 0x91b9e1, 0x90b9e1, 0x93b9e1, 0x92b9e1, 0x95b9e1, 0x94b9e1, 
  0x97b9e1, 0x96b9e1, 0x99b9e1, 0x98b9e1, 0x9bb9e1, 0x9ab9e1, 0x9db9e1, 0x9cb9e1, 
  0x9fb9e1, 0x9eb9e1, 0xa1b9e1, 0xa0b9e1, 0xa3b9e1, 0xa2b9e1, 0xa5b9e1, 0xa4b9e1, 
  0xa7b9e1, 0xa6b9e1, 0xa9b9e1, 0xa8b9e1, 0xabb9e1, 0xaab9e1, 0xadb9e1, 0xacb9e1, 
  0xafb9e1, 0xaeb9e1, 0xb1b9e1, 0xb0b9e1, 0xb3b9e1, 0xb2b9e1, 0xb5b9e1, 0xb4b9e1, 
  0xb7b9e1, 0xb6b9e1, 0xb9b9e1, 0xb8b9e1, 0xbbb9e1, 0xbab9e1, 0xbdb9e1, 0xbcb9e1, 
  0xbfb9e1, 0xbeb9e1, 0x81bae1, 0x80bae1, 0x83bae1, 0x82bae1, 0x85bae1, 0x84bae1, 
  0x87bae1, 0x86bae1, 0x89bae1, 0x88bae1, 0x8bbae1, 0x8abae1, 0x8dbae1, 0x8cbae1, 
  0x8fbae1, 0x8ebae1, 0x91bae1, 0x90bae1, 0x93bae1, 0x92bae1, 0x95bae1, 0x94bae1, 
  0xa1b9e1, 0x9bbae1, 0xa1bae1, 0xa0bae1, 0xa3bae1, 0xa2bae1, 0xa5bae1, 0xa4bae1, 
  0xa7bae1, 0xa6bae1, 0xa9bae1, 0xa8bae1, 0xabbae1, 0xaabae1, 0xadbae1, 0xacbae1, 
  0xafbae1, 0xaebae1, 0xb1bae1, 0xb0bae1, 0xb3bae1, 0xb2bae1, 0xb5bae1, 0xb4bae1, 
  0xb7bae1, 0xb6bae1, 0xb9bae1, 0xb8bae1, 0xbbbae1, 0xbabae1, 0xbdbae1, 0xbcbae1, 
  0xbfbae1, 0xbebae1, 0x81bbe1, 0x80bbe1, 0x83bbe1, 0x82bbe1, 0x85bbe1, 0x84bbe1, 
  0x87bbe1, 0x86bbe1, 0x89bbe1, 0x88bbe1, 0x8bbbe1, 0x8abbe1, 0x8dbbe1, 0x8cbbe1, 
  0x8fbbe1, 0x8ebbe1, 0x91bbe1, 0x90bbe1, 0x93bbe1, 0x92bbe1, 0x95bbe1, 0x94bbe1, 
  0x97bbe1, 0x96bbe1, 0x99bbe1, 0x98bbe1, 0x9bbbe1, 0x9abbe1, 0x9dbbe1, 0x9cbbe1, 
  0x9fbbe1, 0x9ebbe1, 0xa1bbe1, 0xa0bbe1, 0xa3bbe1, 0xa2bbe1, 0xa5bbe1, 0xa4bbe1, 
  0xa7bbe1, 0xa6bbe1, 0xa9bbe1, 0xa8bbe1, 0xabbbe1, 0xaabbe1, 0xadbbe1, 0xacbbe1, 
  0xafbbe1, 0xaebbe1, 0xb1bbe1, 0xb0bbe1, 0xb3bbe1, 0xb2bbe1, 0xb5bbe1, 0xb4bbe1, 
  0xb7bbe1, 0xb6bbe1, 0xb9bbe1, 0xb8bbe1, 0x80bce1, 0x88bce1, 0x81bce1, 0x89bce1, 
  0x82bce1, 0x8abce1, 0x83bce1, 0x8bbce1, 0x84bce1, 0x8cbce1, 0x85bce1, 0x8dbce1, 
  0x86bce1, 0x8ebce1, 0x87bce1, 0x8fbce1, 0x90bce1, 0x98bce1, 0x91bce1, 0x99bce1, 
  0x92bce1, 0x9abce1, 0x93bce1, 0x9bbce1, 0x94bce1, 0x9cbce1, 0x95bce1, 0x9dbce1, 
  0xa0bce1, 0xa8bce1, 0xa1bce1, 0xa9bce1, 0xa2bce1, 0xaabce1, 0xa3bce1, 0xabbce1, 
  0xa4bce1, 0xacbce1, 0xa5bce1, 0xadbce1, 0xa6bce1, 0xaebce1, 0xa7bce1, 0xafbce1, 
  0xb0bce1, 0xb8bce1, 0xb1bce1, 0xb9bce1, 0xb2bce1, 0xbabce1, 0xb3bce1, 0xbbbce1, 
  0xb4bce1, 0xbcbce1, 0xb5bce1, 0xbdbce1, 0xb6bce1, 0xbebce1, 0xb7bce1, 0xbfbce1, 
  0x80bde1, 0x88bde1, 0x81bde1, 0x89bde1, 0x82bde1, 0x8abde1, 0x83bde1, 0x8bbde1, 
  0x84bde1, 0x8cbde1, 0x85bde1, 0x8dbde1, 0x91bde1, 0x99bde1, 0x93bde1, 0x9bbde1, 
  0x95bde1, 0x9dbde1, 0x97bde1, 0x9fbde1, 0xa0bde1, 0xa8bde1, 0xa1bde1, 0xa9bde1, 
  0xa2bde1, 0xaabde1, 0xa3bde1, 0xabbde1, 0xa4bde1, 0xacbde1, 0xa5bde1, 0xadbde1, 
  0xa6bde1, 0xaebde1, 0xa7bde1, 0xafbde1, 0x80bee1, 0x88bee1, 0x81bee1, 0x89bee1, 
  0x82bee1, 0x8abee1, 0x83bee1, 0x8bbee1, 0x84bee1, 0x8cbee1, 0x85bee1, 0x8dbee1, 
  0x86bee1, 0x8ebee1, 0x87bee1, 0x8fbee1, 0x90bee1, 0x98bee1, 0x91bee1, 0x99bee1, 
  0x92bee1, 0x9abee1, 0x93bee1, 0x9bbee1, 0x94bee1, 0x9cbee1, 0x95bee1, 0x9dbee1, 
  0x96bee1, 0x9ebee1, 0x97bee1, 0x9fbee1, 0xa0bee1, 0xa8bee1, 0xa1bee1, 0xa9bee1, 
  0xa2bee1, 0xaabee1, 0xa3bee1, 0xabbee1, 0xa4bee1, 0xacbee1, 0xa5bee1, 0xadbee1, 
  0xa6bee1, 0xaebee1, 0xa7bee1, 0xafbee1, 0xb0bee1, 0xb8bee1, 0xb1bee1, 0xb9bee1, 
  0xb0bde1, 0xbabee1, 0xb1bde1, 0xbbbee1, 0xb3bee1, 0xbcbee1, 0xb9ce, 0xbebee1, 
  0xb2bde1, 0x88bfe1, 0xb3bde1, 0x89bfe1, 0xb4bde1, 0x8abfe1, 0xb5bde1, 0x8bbfe1, 
  0x83bfe1, 0x8cbfe1, 0x90bfe1, 0x98bfe1, 0x91bfe1, 0x99bfe1, 0xb6bde1, 0x9abfe1, 
  0xb7bde1, 0x9bbfe1, 0xa0bfe1, 0xa8bfe1, 0xa1bfe1, 0xa9bfe1, 0xbabde1, 0xaabfe1, 
  0xbbbde1, 0xabbfe1, 0xa5bfe1, 0xacbfe1, 0xb8bde1, 0xb8bfe1, 0xb9bde1, 0xb9bfe1, 
  0xbcbde1, 0xbabfe1, 0xbdbde1, 0xbbbfe1, 0xb3bfe1, 0xbcbfe1, 0x89cf, 0xa684e2, 
  0x6b, 0xaa84e2, 0xa5c3, 0xab84e2, 0x8e85e2, 0xb284e2, 0xb085e2, 0xa085e2, 0xb185e2, 
  0xa185e2, 0xb285e2, 0xa285e2, 0xb385e2, 0xa385e2, 0xb485e2, 0xa485e2, 0xb585e2, 
  0xa585e2, 0xb685e2, 0xa685e2, 0xb785e2, 0xa785e2, 0xb885e2, 0xa885e2, 0xb985e2, 
  0xa985e2, 0xba85e2, 0xaa85e2, 0xbb85e2, 0xab85e2, 0xbc85e2, 0xac85e2, 0xbd85e2, 
  0xad85e2, 0xbe85e2, 0xae85e2, 0xbf85e2, 0xaf85e2, 0x8486e2, 0x8386e2, 0x9093e2, 
  0xb692e2, 0x9193e2, 0xb792e2, 0x9293e2, 0xb892e2, 0x9393e2, 0xb992e2, 0x9493e2, 
  0xba92e2, 0x9593e2, 0xbb92e2, 0x9693e2, 0xbc92e2, 0x9793e2, 0xbd92e2, 0x9893e2, 
  0xbe92e2, 0x9993e2, 0xbf92e2, 0x9a93e2, 0x8093e2, 0x9b93e2, 0x8193e2, 0x9c93e2, 
  0x8293e2, 0x9d93e2, 0x8393e2, 0x9e93e2, 0x8493e2, 0x9f93e2, 0x8593e2, 0xa093e2, 
  0x8693e2, 0xa193e2, 0x8793e2, 0xa293e2, 0x8893e2, 0xa393e2, 0x8993e2, 0xa493e2, 
  0x8a93e2, 0xa593e2, 0x8b93e2, 0xa693e2, 0x8c93e2, 0xa793e2, 0x8d93e2, 0xa893e2, 
  0x8e93e2, 0xa993e2, 0x8f93e2, 0xb0b0e2, 0x80b0e2, 0xb1b0e2, 0x81b0e2, 0xb2b0e2, 
  0x82b0e2, 0xb3b0e2, 0x83b0e2, 0xb4b0e2, 0x84b0e2, 0xb5b0e2, 0x85b0e2, 0xb6b0e2, 
  0x86b0e2, 0xb7b0e2, 0x87b0e2, 0xb8b0e2, 0x88b0e2, 0xb9b0e2, 0x89b0e2, 0xbab0e2, 
  0x8ab0e2, 0xbbb0e2, 0x8bb0e2, 0xbcb0e2, 0x8cb0e2, 0xbdb0e2, 0x8db0e2, 0xbeb0e2, 
  0x8eb0e2, 0xbfb0e2, 0x8fb0e2, 0x80b1e2, 0x90b0e2, 0x81b1e2, 0x91b0e2, 0x82b1e2, 
  0x92b0e2, 0x83b1e2, 0x93b0e2, 0x84b1e2, 0x94b0e2, 0x85b1e2, 0x95b0e2, 0x86b1e2, 
  0x96b0e2, 0x87b1e2, 0x97b0e2, 0x88b1e2, 0x98b0e2, 0x89b1e2, 0x99b0e2, 0x8ab1e2, 
  0x9ab0e2, 0x8bb1e2, 0x9bb0e2, 0x8cb1e2, 0x9cb0e2, 0x8db1e2, 0x9db0e2, 0x8eb1e2, 
  0x9eb0e2, 0x8fb1e2, 0x9fb0e2, 0x90b1e2, 0xa0b0e2, 0x91b1e2, 0xa1b0e2, 0x92b1e2, 
  0xa2b0e2, 0x93b1e2, 0xa3b0e2, 0x94b1e2, 0xa4b0e2, 0x95b1e2, 0xa5b0e2, 0x96b1e2, 
  0xa6b0e2, 0x97b1e2, 0xa7b0e2, 0x98b1e2, 0xa8b0e2, 0x99b1e2, 0xa9b0e2, 0x9ab1e2, 
  0xaab0e2, 0x9bb1e2, 0xabb0e2, 0x9cb1e2, 0xacb0e2, 0x9db1e2, 0xadb0e2, 0x9eb1e2, 
  0xaeb0e2, 0xa1b1e2, 0xa0b1e2, 0xabc9, 0xa2b1e2, 0xbdb5e1, 0xa3b1e2, 0xbdc9, 
  0xa4b1e2, 0xa8b1e2, 0xa7b1e2, 0xaab1e2, 0xa9b1e2, 0xacb1e2, 0xabb1e2, 0xb6b1e2, 
  0xb5b1e2, 0x81b2e2, 0x80b2e2, 0x83b2e2, 0x82b2e2, 0x85b2e2, 0x84b2e2, 0x87b2e2, 
  0x86b2e2, 0x89b2e2, 0x88b2e2, 0x8bb2e2, 0x8ab2e2, 0x8db2e2, 0x8cb2e2, 0x8fb2e2, 
  0x8eb2e2, 0x91b2e2, 0x90b2e2, 0x93b2e2, 0x92b2e2, 0x95b2e2, 0x94b2e2, 0x97b2e2, 
  0x96b2e2, 0x99b2e2, 0x98b2e2, 0x9bb2e2, 0x9ab2e2, 0x9db2e2, 0x9cb2e2, 0x9fb2e2, 
  0x9eb2e2, 0xa1b2e2, 0xa0b2e2, 0xa3b2e2, 0xa2b2e2, 0xa5b2e2, 0xa4b2e2, 0xa7b2e2, 
  0xa6b2e2, 0xa9b2e2, 0xa8b2e2, 0xabb2e2, 0xaab2e2, 0xadb2e2, 0xacb2e2, 0xafb2e2, 
  0xaeb2e2, 0xb1b2e2, 0xb0b2e2, 0xb3b2e2, 0xb2b2e2, 0xb5b2e2, 0xb4b2e2, 0xb7b2e2, 
  0xb6b2e2, 0xb9b2e2, 0xb8b2e2, 0xbbb2e2, 0xbab2e2, 0xbdb2e2, 0xbcb2e2, 0xbfb2e2, 
  0xbeb2e2, 0x81b3e2, 0x80b3e2, 0x83b3e2, 0x82b3e2, 0x85b3e2, 0x84b3e2, 0x87b3e2, 
  0x86b3e2, 0x89b3e2, 0x88b3e2, 0x8bb3e2, 0x8ab3e2, 0x8db3e2, 0x8cb3e2, 0x8fb3e2, 
  0x8eb3e2, 0x91b3e2, 0x90b3e2, 0x93b3e2, 0x92b3e2, 0x95b3e2, 0x94b3e2, 0x97b3e2, 
  0x96b3e2, 0x99b3e2, 0x98b3e2, 0x9bb3e2, 0x9ab3e2, 0x9db3e2, 0x9cb3e2, 0x9fb3e2, 
  0x9eb3e2, 0xa1b3e2, 0xa0b3e2, 0xa3b3e2, 0xa2b3e2, 0x81bdef, 0xa1bcef, 0x82bdef, 
  0xa2bcef, 0x83bdef, 0xa3bcef, 0x84bdef, 0xa4bcef, 0x85bdef, 0xa5bcef, 0x86bdef, 
  0xa6bcef, 0x87bdef, 0xa7bcef, 0x88bdef, 0xa8bcef, 0x89bdef, 0xa9bcef, 0x8abdef, 
  0xaabcef, 0x8bbdef, 0xabbcef, 0x8cbdef, 0xacbcef, 0x8dbdef, 0xadbcef, 0x8ebdef, 
  0xaebcef, 0x8fbdef, 0xafbcef, 0x90bdef, 0xb0bcef, 0x91bdef, 0xb1bcef, 0x92bdef, 
  0xb2bcef, 0x93bdef, 0xb3bcef, 0x94bdef, 0xb4bcef, 0x95bdef, 0xb5bcef, 0x96bdef, 
  0xb6bcef, 0x97bdef, 0xb7bcef, 0x98bdef, 0xb8bcef, 0x99bdef, 0xb9bcef, 0x9abdef, 
  0xbabcef, 0xa89090f0, 0x809090f0, 0xa99090f0, 0x819090f0, 0xaa9090f0, 0x829090f0, 
  0xab9090f0, 0x839090f0, 0xac9090f0, 0x849090f0, 0xad9090f0, 0x859090f0, 0xae9090f0, 
  0x869090f0, 0xaf9090f0, 0x879090f0, 0xb09090f0, 0x889090f0, 0xb19090f0, 0x899090f0, 
  0xb29090f0, 0x8a9090f0, 0xb39090f0, 0x8b9090f0, 0xb49090f0, 0x8c9090f0, 0xb59090f0, 
  0x8d9090f0, 0xb69090f0, 0x8e9090f0, 0xb79090f0, 0x8f9090f0, 0xb89090f0, 0x909090f0, 
  0xb99090f0, 0x919090f0, 0xba9090f0, 0x929090f0, 0xbb9090f0, 0x939090f0, 0xbc9090f0, 
  0x949090f0, 0xbd9090f0, 0x959090f0, 0xbe9090f0, 0x969090f0, 0xbf9090f0, 0x979090f0, 
  0x809190f0, 0x989090f0, 0x819190f0, 0x999090f0, 0x829190f0, 0x9a9090f0, 0x839190f0, 
  0x9b9090f0, 0x849190f0, 0x9c9090f0, 0x859190f0, 0x9d9090f0, 0x869190f0, 0x9e9090f0, 
  0x879190f0, 0x9f9090f0, 0x889190f0, 0xa09090f0, 0x899190f0, 0xa19090f0, 0x8a9190f0, 
  0xa29090f0, 0x8b9190f0, 0xa39090f0, 0x8c9190f0, 0xa49090f0, 0x8d9190f0, 0xa59090f0, 
  0x8e9190f0, 0xa69090f0, 0x8f9190f0, 0xa79090f0
  };


#define UTF_8_FOLLOWERS(cur,i,pwd,input) followers = utf8_followers[cur]; \
  if (followers == -1)\
    {\
    printf (" Error: Unexpected continuation byte 0x%02X at pos %lu in UTF-8 string.\n",\
            cur, (unsigned long)i);\
    return pwdgen_make_string_invalid(pwd, input);\
    }
#define UTF_8_SKIP(cur,i,pwd,input) UTF_8_FOLLOWERS(cur,i,pwd,input); i+=followers+1;

#endif
