package HPCD::SGE::JobGroup;

### INCLUDES ##################################################################

# safe Perl
use warnings;
use strict;
use Carp;
use File::Path qw(make_path remove_tree);
use DateTime;
use MooseX::Types::Path::Class qw(Dir File);

use Moose::Role;

with 'HPCI::JobGroup' => { theDriver => 'HPCD::SGE' };

sub _get_submit_command {
    my $self         = shift;
    my $run          = shift;
    my $shell_script = shift;

    my $stage     = $run->stage;
    my $name      = $run->unique_id;
    my $extras    = $stage->extra_sge_args_string;
    my $res       = $stage->_use_resources_required;
    my $resources = join( ",", map { "$_=$res->{$_}" } sort keys %$res );
    $resources = "-l $resources" if $resources;

    my $qsub_command = join( ' ',
        "qsub", ( length($extras) ? $extras : () ),
        ( length($resources) ? $resources : () ),
        "-N '$name'",
        "-o",      $run->_stdout,
        "-e",      $run->_stderr,
        "-sync y", "-cwd",
        "-b y",    "'$shell_script'" );

    return $qsub_command;
}

1;
