#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#include "compress-huffman-binary-perl.c"

typedef compress_huffman_binary_t * Compress__Huffman__Binary;

MODULE=Compress::Huffman::Binary PACKAGE=Compress::Huffman::Binary

PROTOTYPES: DISABLE

BOOT:
	/* Compress__Huffman__Binary_error_handler = perl_error_handler; */

SV *
huffman_encode (in)
	SV * in;
PREINIT:
	unsigned char * cin;
	STRLEN cinlen;
	unsigned char * out;
	unsigned int outlen;
CODE:
	cin = (unsigned char *) SvPV (in, cinlen);
	huffman_encode_memory (cin, (unsigned int) cinlen, & out, & outlen);
	RETVAL = newSVpv ((char *) out, (STRLEN) outlen);
OUTPUT:
	RETVAL

SV *
huffman_decode (in)
	SV * in;
PREINIT:
	unsigned char * cin;
	STRLEN cinlen;
	unsigned char * out;
	unsigned int outlen;
CODE:
	cin = (unsigned char *) SvPV (in, cinlen);
	huffman_decode_memory (cin, (unsigned int) cinlen, & out, & outlen);
	RETVAL = newSVpv ((char *) out, (STRLEN) outlen);
OUTPUT:
	RETVAL
