package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '1.78';
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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==',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBPcmlnaW5hbGx5IGNvbnRyaWJ1dGVkIGJ5OiAgTWFyayBLZXR0ZW5p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=',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv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',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v
cmcgYmVmb3JlIG1ha2luZyBtb2RpZmljYXRpb25zCiMgdG8gdGhpcyBmaWxlLgoKY2FzZSAiJGFy
Y2huYW1lIiBpbgonJykKICAgIGFyY2huYW1lPWB1bmFtZSAtbWAtJHtvc25hbWV9CiAgICA7Owpl
c2FjCgojIE5ldEJTRCBrZWVwcyBkeW5hbWljIGxvYWRpbmcgZGwqKCkgZnVuY3Rpb25zIGluIC91
c3IvbGliL2NydDAubywKIyBzbyBDb25maWd1cmUgZG9lc24ndCBmaW5kIHRoZW0gKHVubGVzcyB5
b3UgYWJhbmRvbiB0aGUgbm0gc2NhbikuCiMgQWxzbywgTmV0QlNEIDAuOWEgd2FzIHRoZSBmaXJz
dCByZWxlYXNlIHRvIGludHJvZHVjZSBzaGFyZWQKIyBsaWJyYXJpZXMuCiMKY2FzZSAiJG9zdmVy
cyIgaW4KMC45fDAuOCopCgl1c2VkbD0iJHVuZGVmIgoJOzsKKikKCWNhc2UgYHVuYW1lIC1tYCBp
bgoJcG1heCkKCQkjIE5ldEJTRCAxLjMgYW5kIDEuMy4xIG9uIHBtYXggc2hpcHBlZCBhbiBgb2xk
JyBsZC5zbywKCQkjIHdoaWNoIHdpbGwgbm90IHdvcmsuCgkJY2FzZSAiJG9zdmVycyIgaW4KCQkx
LjN8MS4zLjEpCgkJCWRfZGxvcGVuPSR1bmRlZgoJCQk7OwoJCWVzYWMKCQk7OwoJZXNhYwoJaWYg
dGVzdCAtZiAvdXNyL2xpYmV4ZWMvbGQuZWxmX3NvOyB0aGVuCgkJIyBFTEYKCQlkX2Rsb3Blbj0k
ZGVmaW5lCgkJZF9kbGVycm9yPSRkZWZpbmUKCQljY2NkbGZsYWdzPSItRFBJQyAtZlBJQyAkY2Nj
ZGxmbGFncyIKCQlsZGRsZmxhZ3M9Ii1zaGFyZWQgJGxkZGxmbGFncyIKCQljYXQgPlVVL2NjLmNi
dSA8PCdFT0NCVScKIyBnY2MgNC42IGRvZXNuJ3Qgc3VwcG9ydCAtLXdob2xlLWFyY2hpdmUsIGJ1
dCBpdCdzIHJlcXVpcmVkIGZvciB0aGUKIyBzeXN0ZW0gZ2NjIHRvIGJ1aWxkIGNvcnJlY3RseSwg
c28gY2hlY2sgZm9yIGl0CmVjaG8gJ2ludCBmKHZvaWQpIHsgcmV0dXJuIDA7IH0nID50cnkuYwpp
ZiAke2NjOi1jY30gJGNjY2RsZmxhZ3MgLWMgdHJ5LmMgLW90cnkubyAyPiYxICYmCiAgICR7Y2M6
LWNjfSAtLXdob2xlLWFyY2hpdmUgJGxkZGxmbGFncyB0cnkubyAtb3RyeS5zbyAyPiYxIDsgdGhl
bgogICAgbGRkbGZsYWdzPSItLXdob2xlLWFyY2hpdmUgJGxkZGxmbGFncyIKZmkKcm0gdHJ5LmMg
dHJ5Lm8gdHJ5LnNvIDI+L2Rldi9udWxsCkVPQ0JVCgkJcnBhdGhmbGFnPSItV2wsLXJwYXRoLCIK
CQljYXNlICIkb3N2ZXJzIiBpbgoJCTEuWzAtNV0qKQoJCQkjCgkJCSMgSW5jbHVkZSB0aGUgd2hv
bGUgbGliZ2NjLmEgaW50byB0aGUgcGVybCBleGVjdXRhYmxlCgkJCSMgc28gdGhhdCBjZXJ0YWlu
IHN5bWJvbHMgbmVlZGVkIGJ5IGxvYWRhYmxlIG1vZHVsZXMKCQkJIyBidWlsdCBhcyBDKysgb2Jq
ZWN0cyAoX19laF9hbGxvYywgX19wdXJlX3ZpcnR1YWwsCgkJCSMgZXRjLikgd2lsbCBhbHdheXMg
YmUgZGVmaW5lZC4KCQkJIwoJCQljY2RsZmxhZ3M9Ii1XbCwtd2hvbGUtYXJjaGl2ZSAtbGdjYyBc
CgkJCQktV2wsLW5vLXdob2xlLWFyY2hpdmUgLVdsLC1FICRjY2RsZmxhZ3MiCgkJCTs7CgkJKikK
CQkJY2NkbGZsYWdzPSItV2wsLUUgJGNjZGxmbGFncyIKCQkJOzsKCQllc2FjCgllbGlmIHRlc3Qg
LWYgL3Vzci9saWJleGVjL2xkLnNvOyB0aGVuCgkJIyBhLm91dAoJCWRfZGxvcGVuPSRkZWZpbmUK
CQlkX2RsZXJyb3I9JGRlZmluZQoJCWNjY2RsZmxhZ3M9Ii1EUElDIC1mUElDICRjY2NkbGZsYWdz
IgoJCWxkZGxmbGFncz0iLUJzaGFyZWFibGUgJGxkZGxmbGFncyIKCQlycGF0aGZsYWc9Ii1SIgoJ
ZWxzZQoJCWRfZGxvcGVuPSR1bmRlZgoJCXJwYXRoZmxhZz0KCWZpCgk7Owplc2FjCgojIG5ldGJz
ZCBoYWQgdGhlc2UgYnV0IHRoZXkgZG9uJ3QgcmVhbGx5IHdvcmsgYXMgYWR2ZXJ0aXNlZCwgaW4g
dGhlCiMgdmVyc2lvbnMgbGlzdGVkIGJlbG93LiAgaWYgdGhleSBhcmUgZGVmaW5lZCwgdGhlbiB0
aGVyZSBpc24ndCBhCiMgd2F5IHRvIG1ha2UgcGVybCBjYWxsIHNldHVpZCgpIG9yIHNldGdpZCgp
LiAgaWYgdGhleSBhcmVuJ3QsIHRoZW4KIyAoJDwsICQ+KSA9ICgkdSwgJHUpOyB3aWxsIHdvcmsg
KHNhbWUgZm9yICQoLyQpKS4gIHRoaXMgaXMgYmVjYXVzZQojIHlvdSBjYW4gbm90IGNoYW5nZSB0
aGUgcmVhbCB1c2VyaWQgb2YgYSBwcm9jZXNzIHVuZGVyIDQuNEJTRC4KIyBuZXRic2QgZml4ZWQg
dGhpcyBpbiAxLjMuMi4KY2FzZSAiJG9zdmVycyIgaW4KMC45KnwxLlswMTJdKnwxLjN8MS4zLjEp
CglkX3NldHJlZ2lkPSIkdW5kZWYiCglkX3NldHJldWlkPSIkdW5kZWYiCgk7Owplc2FjCmNhc2Ug
IiRvc3ZlcnMiIGluCjAuOCopCgk7OwoqKQoJZF9nZXRwcm90b2VudF9yPSIkdW5kZWYiCglkX2dl
dHByb3RvYnluYW1lX3I9IiR1bmRlZiIKCWRfZ2V0cHJvdG9ieW51bWJlcl9yPSIkdW5kZWYiCglk
X3NldHByb3RvZW50X3I9IiR1bmRlZiIKCWRfZW5kcHJvdG9lbnRfcj0iJHVuZGVmIgoJZF9nZXRz
ZXJ2ZW50X3I9IiR1bmRlZiIKCWRfZ2V0c2VydmJ5bmFtZV9yPSIkdW5kZWYiCglkX2dldHNlcnZi
eXBvcnRfcj0iJHVuZGVmIgoJZF9zZXRzZXJ2ZW50X3I9IiR1bmRlZiIKCWRfZW5kc2VydmVudF9y
PSIkdW5kZWYiCglkX2dldGhvc3RieW5hbWVfcj0iJHVuZGVmIgoJZF9nZXRob3N0YnlhZGRyMl9y
PSIkdW5kZWYiCglkX2dldGhvc3RieWFkZHJfcj0iJHVuZGVmIgoJZF9zZXRob3N0ZW50X3I9IiR1
bmRlZiIKCWRfZ2V0aG9zdGVudF9yPSIkdW5kZWYiCglkX2VuZGhvc3RlbnRfcj0iJHVuZGVmIgoJ
ZF9nZXRwcm90b2VudF9yX3Byb3RvPSIwIgoJZF9nZXRwcm90b2J5bmFtZV9yX3Byb3RvPSIwIgoJ
ZF9nZXRwcm90b2J5bnVtYmVyX3JfcHJvdG89IjAiCglkX3NldHByb3RvZW50X3JfcHJvdG89IjAi
CglkX2VuZHByb3RvZW50X3JfcHJvdG89IjAiCglkX2dldHNlcnZlbnRfcl9wcm90bz0iMCIKCWRf
Z2V0c2VydmJ5bmFtZV9yX3Byb3RvPSIwIgoJZF9nZXRzZXJ2Ynlwb3J0X3JfcHJvdG89IjAiCglk
X3NldHNlcnZlbnRfcl9wcm90bz0iMCIKCWRfZW5kc2VydmVudF9yX3Byb3RvPSIwIgoJZF9nZXRo
b3N0YnluYW1lX3JfcHJvdG89IjAiCglkX2dldGhvc3RieWFkZHIyX3JfcHJvdG89IjAiCglkX2dl
dGhvc3RieWFkZHJfcl9wcm90bz0iMCIKCWRfc2V0aG9zdGVudF9yX3Byb3RvPSIwIgoJZF9lbmRo
b3N0ZW50X3JfcHJvdG89IjAiCglkX2dldGhvc3RlbnRfcl9wcm90bz0iMCIKCTs7CmVzYWMKCiMg
VGhlc2UgYXJlIG9ic29sZXRlIGluIGFueSBuZXRic2QuCmRfc2V0cmdpZD0iJHVuZGVmIgpkX3Nl
dHJ1aWQ9IiR1bmRlZiIKCiMgdGhlcmUncyBubyBwcm9ibGVtIHdpdGggdmZvcmsuCnVzZXZmb3Jr
PXRydWUKCiMgVGhpcyBpcyB0aGVyZSBidXQgaW4gbWFjaGluZS9pZWVlZnBfaC4KaWVlZWZwX2g9
ImRlZmluZSIKCiMgVGhpcyBzY3JpcHQgVVUvdXNldGhyZWFkcy5jYnUgd2lsbCBnZXQgJ2NhbGxl
ZC1iYWNrJyBieSBDb25maWd1cmUKIyBhZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9y
IHdoZXRoZXIgdG8gdXNlIHRocmVhZHMuCmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JV
JwpjYXNlICIkdXNldGhyZWFkcyIgaW4KJGRlZmluZXx0cnVlfFt5WV0qKQoJbHB0aHJlYWQ9Cglm
b3IgeHh4IGluIHB0aHJlYWQ7IGRvCgkJZm9yIHl5eSBpbiAkbG9jbGlicHRoICRwbGlicHRoICRn
bGlicHRoIGR1bW15OyBkbwoJCQl6eno9JHl5eS9saWIkeHh4LmEKCQkJaWYgdGVzdCAtZiAiJHp6
eiI7IHRoZW4KCQkJCWxwdGhyZWFkPSR4eHgKCQkJCWJyZWFrOwoJCQlmaQoJCQl6eno9JHl5eS9s
aWIkeHh4LnNvCgkJCWlmIHRlc3QgLWYgIiR6enoiOyB0aGVuCgkJCQlscHRocmVhZD0keHh4CgkJ
CQlicmVhazsKCQkJZmkKCQkJenp6PWBscyAkeXl5L2xpYiR4eHguc28uKiAyPi9kZXYvbnVsbGAK
CQkJaWYgdGVzdCAiWCR6enoiICE9IFg7IHRoZW4KCQkJCWxwdGhyZWFkPSR4eHgKCQkJCWJyZWFr
OwoJCQlmaQoJCWRvbmUKCQlpZiB0ZXN0ICJYJGxwdGhyZWFkIiAhPSBYOyB0aGVuCgkJCWJyZWFr
OwoJCWZpCglkb25lCglpZiB0ZXN0ICJYJGxwdGhyZWFkIiAhPSBYOyB0aGVuCgkJIyBBZGQgLWxw
dGhyZWFkLgoJCWxpYnN3YW50ZWQ9IiRsaWJzd2FudGVkICRscHRocmVhZCIKCQkjIFRoZXJlIGlz
IG5vIGxpYmNfciBhcyBvZiBOZXRCU0QgMS41LjIsIHNvIG5vIGMgLT4gY19yLgoJCSMgVGhpcyB3
aWxsIGJlIHJldmlzaXRlZCB3aGVuIE5ldEJTRCBnYWlucyBhIG5hdGl2ZSBwdGhyZWFkcwoJCSMg
aW1wbGVtZW50YXRpb24uCgllbHNlCgkJZWNobyAiJDA6IE5vIFBPU0lYIHRocmVhZHMgbGlicmFy
eSAoLWxwdGhyZWFkKSBmb3VuZC4gICIgXAoJCSAgICAgIllvdSBtYXkgd2FudCB0byBpbnN0YWxs
IEdOVSBwdGguICBBYm9ydGluZy4iID4mNAoJCWV4aXQgMQoJZmkKCXVuc2V0IGxwdGhyZWFkCgoJ
IyBzZXZlcmFsIHJlZW50cmFudCBmdW5jdGlvbnMgYXJlIGVtYmVkZGVkIGluIGxpYmMsIGJ1dCBo
YXZlbid0CgkjIGJlZW4gYWRkZWQgdG8gdGhlIGhlYWRlciBmaWxlcyB5ZXQuICBMZXQncyBob2xk
IG9mZiBvbiB1c2luZwoJIyB0aGVtIHVudGlsIHRoZXkgYXJlIGEgdmFsaWQgcGFydCBvZiB0aGUg
QVBJCgljYXNlICIkb3N2ZXJzIiBpbgoJWzAxMl0uKnwzLlswLTFdKQoJCWRfZ2V0cHJvdG9ieW5h
bWVfcj0kdW5kZWYKCQlkX2dldHByb3RvYnludW1iZXJfcj0kdW5kZWYKCQlkX2dldHByb3RvZW50
X3I9JHVuZGVmCgkJZF9nZXRzZXJ2YnluYW1lX3I9JHVuZGVmCgkJZF9nZXRzZXJ2Ynlwb3J0X3I9
JHVuZGVmCgkJZF9nZXRzZXJ2ZW50X3I9JHVuZGVmCgkJZF9zZXRwcm90b2VudF9yPSR1bmRlZgoJ
CWRfc2V0c2VydmVudF9yPSR1bmRlZgoJCWRfZW5kcHJvdG9lbnRfcj0kdW5kZWYKCQlkX2VuZHNl
cnZlbnRfcj0kdW5kZWYgOzsKCWVzYWMKCTs7Cgplc2FjCkVPQ0JVCgojIFNldCBzZW5zaWJsZSBk
ZWZhdWx0cyBmb3IgTmV0QlNEOiBsb29rIGZvciBsb2NhbCBzb2Z0d2FyZSBpbgojIC91c3IvcGtn
IChOZXRCU0QgUGFja2FnZXMgQ29sbGVjdGlvbikgYW5kIGluIC91c3IvbG9jYWwuCiMKbG9jbGli
cHRoPSIvdXNyL3BrZy9saWIgL3Vzci9sb2NhbC9saWIiCmxvY2luY3B0aD0iL3Vzci9wa2cvaW5j
bHVkZSAvdXNyL2xvY2FsL2luY2x1ZGUiCmNhc2UgIiRycGF0aGZsYWciIGluCicnKQoJbGRmbGFn
cz0KCTs7CiopCglsZGZsYWdzPQoJZm9yIHl5eSBpbiAkbG9jbGlicHRoOyBkbwoJCWxkZmxhZ3M9
IiRsZGZsYWdzICRycGF0aGZsYWckeXl5IgoJZG9uZQoJOzsKZXNhYwoKY2FzZSBgdW5hbWUgLW1g
IGluCmFscGhhKQogICAgZWNobyAnaW50IG1haW4oKSB7fScgPiB0cnkuYwogICAgZ2NjPWAke2Nj
Oi1jY30gLXYgLWMgdHJ5LmMgMj4mMXxncmVwICdnY2MgdmVyc2lvbiBlZ2NzLTInYAogICAgY2Fz
ZSAiJGdjYyIgaW4KICAgICcnIHwgImdjYyB2ZXJzaW9uIGVnY3MtMi45NS4iWzMtOV0qKSA7OyAj
IDIuOTUuMyBvciBiZXR0ZXIgb2theQogICAgKikJY2F0ID4mNCA8PEVPRgoqKioKKioqIFlvdXIg
Z2NjICgkZ2NjKSBpcyBrbm93biB0byBiZQoqKiogdG9vIGJ1Z2d5IG9uIG5ldGJzZC9hbHBoYSB0
byBjb21waWxlIFBlcmwgd2l0aCBvcHRpbWl6YXRpb24uCioqKiBJdCBpcyBzdWdnZXN0ZWQgeW91
IGluc3RhbGwgdGhlIGxhbmcvZ2NjIHBhY2thZ2Ugd2hpY2ggc2hvdWxkCioqKiBoYXZlIGF0IGxl
YXN0IGdjYyAyLjk1LjMgd2hpY2ggc2hvdWxkIHdvcmsgb2theTogdXNlIGZvciBleGFtcGxlCioq
KiBDb25maWd1cmUgLURjYz0vdXNyL3BrZy9nY2MtMi45NS4zL2Jpbi9jYy4gIFlvdSBjb3VsZCBh
bHNvCioqKiBDb25maWd1cmUgLURvcHRpbWl6ZT0tTzAgdG8gY29tcGlsZSBQZXJsIHdpdGhvdXQg
YW55IG9wdGltaXphdGlvbgoqKiogYnV0IHRoYXQgaXMgbm90IHJlY29tbWVuZGVkLgoqKioKRU9G
CglleGl0IDEKCTs7CiAgICBlc2FjCiAgICBybSAtZiB0cnkuKgogICAgOzsKZXNhYwoKIyBOZXRC
U0Qvc3BhcmMgMS41LjMvMS42LjEgZHVtcHMgY29yZSBpbiB0aGUgc2VtaWRfZHMgdGVzdCBvZiBD
b25maWd1cmUuCmNhc2UgYHVuYW1lIC1tYCBpbgpzcGFyYykgZF9zZW1jdGxfc2VtaWRfZHM9dW5k
ZWYgOzsKZXNhYwoKIyBtYWxsb2Mgd3JhcCB3b3JrcwpjYXNlICIkdXNlbWFsbG9jd3JhcCIgaW4K
JycpIHVzZW1hbGxvY3dyYXA9J2RlZmluZScgOzsKZXNhYwoKIyBkb24ndCB1c2UgcGVybCBtYWxs
b2MgYnkgZGVmYXVsdApjYXNlICIkdXNlbXltYWxsb2MiIGluCicnKSB1c2VteW1hbGxvYz1uIDs7
CmVzYWMKCiMgTmV0QlNEIDYgZGVmaW5lcyB0aGUgKmF0KCkgZnVuY3Rpb25zIGluIGxpYmMsIGJ1
dCBlaXRoZXIgZG9lc24ndAojIGltcGxlbWVudCB0aGVtLCBvciBpbXBsZW1lbnRzIHRoZW0gb25s
eSBmb3IgQVRfRkRDV0QKY2FzZSAiJG9zdmVyIiBpbgpbMS02XS4qKQogICAgICAgIGRfdW5saW5r
YXQ9IiR1bmRlZiIKICAgICAgICBkX3JlbmFtZWF0PSIkdW5kZWYiCiAgICAgICAgZF9saW5rYXQ9
IiR1bmRlZiIKICAgICAgICBkX2ZjaG1vZGF0PSIkdW5kZWYiCiAgICAgICAgOzsKZXNhYwo=',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg
b3JkZXIpIEFsYW4gQnVybGlzb24sIEFuZHkgRG91Z2hlcnR5LAojIERlYW4gUm9laHJpY2gsIEph
cmtrbyBIaWV0YW5pZW1pLCBMdXBlIENocmlzdG9waCwgUmljaGFyZCBTb2RlcmJlcmcgYW5kCiMg
bWFueSBvdGhlcnMuCiMKIyBTZWUgUkVBRE1FLnNvbGFyaXMgZm9yIGFkZGl0aW9uYWwgaW5mb3Jt
YXRpb24uCiMKIyBGb3IgY29uc2lzdGVuY3kgd2l0aCBnY2MsIHdlIGRvIG5vdCBhZG9wdCBTdW4g
TWFya2V0aW5nJ3MKIyByZW1vdmFsIG9mIHRoZSAnMi4nIHByZWZpeCBmcm9tIHRoZSBTb2xhcmlz
IHZlcnNpb24gbnVtYmVyLgojIChDb25maWd1cmUgdHJpZXMgdG8gZGV0ZWN0IGFuIG9sZCBmaXhp
bmNsdWRlcyBhbmQgbmVlZHMKIyB0aGlzIGluZm9ybWF0aW9uLikKCiMgSWYgcGVybCBmYWlscyB0
ZXN0cyB0aGF0IGludm9sdmUgZHluYW1pYyBsb2FkaW5nIG9mIGV4dGVuc2lvbnMsIGFuZAojIHlv
dSBhcmUgdXNpbmcgZ2NjLCBiZSBzdXJlIHRoYXQgeW91IGFyZSBOT1QgdXNpbmcgR05VIGFzIGFu
ZCBsZC4gIE9uZQojIHdheSB0byBkbyB0aGF0IGlzIHRvIGludm9rZSBDb25maWd1cmUgd2l0aAoj
CiMgICAgIHNoIENvbmZpZ3VyZSAtRGNjPSdnY2MgLUIvdXNyL2Njcy9iaW4vJwojCiMgIChOb3Rl
IHRoYXQgdGhlIHRyYWlsaW5nIHNsYXNoIGlzICpyZXF1aXJlZCouKQojICBnY2Mgd2lsbCBvY2Nh
c2lvbmFsbHkgZW1pdCB3YXJuaW5ncyBhYm91dCAidW51c2VkIHByZWZpeCIsIGJ1dAojICB0aGVz
ZSBvdWdodCB0byBiZSBoYXJtbGVzcy4gIFNlZSBiZWxvdyBmb3IgbW9yZSBkZXRhaWxzLgoKIyBT
b2xhcmlzIGhhcyBzZWN1cmUgU1VJRCBzY3JpcHRzCmRfc3VpZHNhZmU9JHtkX3N1aWRzYWZlOi1k
ZWZpbmV9CgojIEJlIHBhcmFub2lkIGFib3V0IG5tIGZhaWxpbmcgdG8gZmluZCBzeW1ib2xzCm1p
c3RydXN0bm09JHttaXN0cnVzdG5tOi1ydW59CgojIFNldmVyYWwgcGVvcGxlIHJlcG9ydGVkIHBy
b2JsZW1zIHdpdGggcGVybCdzIG1hbGxvYywgZXNwZWNpYWxseQojIHdoZW4gdXNlNjRiaXRhbGwg
aXMgZGVmaW5lZCBvciB3aGVuIHVzaW5nIGdjYy4KIyAgICAgaHR0cDovL3d3dy54cmF5Lm1wZS5t
cGcuZGUvbWFpbGluZy1saXN0cy9wZXJsNS1wb3J0ZXJzLzIwMDEtMDEvbXNnMDEzMTguaHRtbAoj
ICAgICBodHRwOi8vd3d3LnhyYXkubXBlLm1wZy5kZS9tYWlsaW5nLWxpc3RzL3Blcmw1LXBvcnRl
cnMvMjAwMS0wMS9tc2cwMDQ2NS5odG1sCnVzZW15bWFsbG9jPSR7dXNlbXltYWxsb2M6LWZhbHNl
fQoKIyBtYWxsb2Mgd3JhcCB3b3JrcwpjYXNlICIkdXNlbWFsbG9jd3JhcCIgaW4KJycpIHVzZW1h
bGxvY3dyYXA9J2RlZmluZScgOzsKZXNhYwoKIyBBdm9pZCBhbGwgbGlicmFyaWVzIGluIC91c3Iv
dWNibGliLgojIC9saWIgaXMganVzdCBhIHN5bWxpbmsgdG8gL3Vzci9saWIKc2V0IGBlY2hvICRn
bGlicHRoIHwgc2VkIC1lICdzQC91c3IvdWNibGliQEAnIC1lICdzQCAvbGliIEAgQCdgCmdsaWJw
dGg9IiQqIgoKIyBTdGFydGluZyB3aXRoIFNvbGFyaXMgMTAsIHdlIGRvbid0IHdhbnQgdmVyc2lv
bmVkIHNoYXJlZCBsaWJyYXJpZXMgYmVjYXVzZQojIHRob3NlIG9mdGVuIGluZGljYXRlIGEgcHJp
dmF0ZSB1c2Ugb25seSBsaWJyYXJ5LiAgRXNwZWNpYWxseSBiYWRseSB0aGF0IHdvdWxkCiMgYnJl
YWsgdGhpbmdzIHdpdGggU1VOV2JkYiAoQmVya2VsZXkgREIpIGJlaW5nIGluc3RhbGxlZCwgd2hp
Y2ggYnJpbmdzIGluCiMgL3Vzci9saWIvbGliZGIuc28uMSwgYnV0IHRoYXQgaXMgbm90IHJlYWxs
eSBtZWFudCBmb3IgcHVibGljIGNvbnN1bXB0aW9uLgojICBYWFggUmV2aXNpdCBhZnRlciBwZXJs
IDUuMTAgLS0gc2hvdWxkIHdlIGFwcGx5IHRoaXMgdG8gb2xkZXIgU29sYXJpcwojIHZlcnNpb25z
IHRvbz8gIChBLkQuIDExLzIwMDcpLgpjYXNlICJgJHJ1biB1bmFtZSAtcmAiIGluCjUuWzAtOV0p
IDs7CiopIGlnbm9yZV92ZXJzaW9uZWRfc29saWJzPXkgOzsKZXNhYwoKIyBSZW1vdmUgdW53YW50
ZWQgbGlicmFyaWVzLiAgLWx1Y2IgY29udGFpbnMgaW5jb21wYXRpYmxlIHJvdXRpbmVzLgojIC1s
bGQgYW5kIC1sc2VjIGRvbid0IGRvIGFueXRoaW5nIHVzZWZ1bC4gLWxjcnlwdCBkb2VzIG5vdAoj
IHJlYWxseSBwcm92aWRlIGFueXRoaW5nIHdlIG5lZWQgb3ZlciAtbGMsIHNvIHdlIGRyb3AgaXQs
IHRvby4KIyAtbG1hbGxvYyBjYW4gY2F1c2UgYSBwcm9ibGVtIHdpdGggR05VIENDICYgU29sYXJp
cy4gIFNwZWNpZmljYWxseSwKIyBsaWJtYWxsb2MuYSBtYXkgYWxsb2NhdGUgbWVtb3J5IHRoYXQg
aXMgb25seSA0IGJ5dGUgYWxpZ25lZCwgYnV0CiMgR05VIENDIG9uIHRoZSBTcGFyYyBhc3N1bWVz
IHRoYXQgZG91YmxlcyBhcmUgOCBieXRlIGFsaWduZWQuCiMgVGhhbmtzIHRvICBIYWxsdmFyZCBC
LiBGdXJ1c2V0aCA8aC5iLmZ1cnVzZXRoQHVzaXQudWlvLm5vPgpzZXQgYGVjaG8gIiAkbGlic3dh
bnRlZCAiIHwgc2VkIC1lICdzQCBsZCBAIEAnIC1lICdzQCBtYWxsb2MgQCBAJyAtZSAnc0AgdWNi
IEAgQCcgLWUgJ3NAIHNlYyBAIEAnIC1lICdzQCBjcnlwdCBAIEAnYApsaWJzd2FudGVkPSIkKiIK
CiMgTG9vayBmb3IgYXJjaGl0ZWN0dXJlIG5hbWUuICBXZSB3YW50IHRvIHN1Z2dlc3QgYSB1c2Vm
dWwgZGVmYXVsdC4KY2FzZSAiJGFyY2huYW1lIiBpbgonJykKICAgIGlmIHRlc3QgLWYgL3Vzci9i
aW4vYXJjaDsgdGhlbgoJYXJjaG5hbWU9YC91c3IvYmluL2FyY2hgCglhcmNobmFtZT0iJHthcmNo
bmFtZX0tJHtvc25hbWV9IgogICAgZWxpZiB0ZXN0IC1mIC91c3IvdWNiL2FyY2g7IHRoZW4KCWFy
Y2huYW1lPWAvdXNyL3VjYi9hcmNoYAoJYXJjaG5hbWU9IiR7YXJjaG5hbWV9LSR7b3NuYW1lfSIK
ICAgIGZpCiAgICA7Owplc2FjCgojCiMgVGhpcyBleHRyYWN0cyB0aGUgbGlicmFyeSBkaXJlY3Rv
cmllcyB0aGF0IHdpbGwgYmUgc2VhcmNoZWQgYnkgdGhlIFN1bgojIFdvcmtzaG9wIGNvbXBpbGVy
LCBnaXZlbiB0aGUgY29tbWFuZC1saW5lIHN1cHBsaWVkIGluICR0cnl3b3Jrc2hvcGNjLgojIFVz
ZSB0aHVzbHk6IGxvY2xpYnB0aD0iYCRnZXR3b3Jrc2hvcGxpYnNgICRsb2NsaWJwdGgiCiMKCWdl
dHdvcmtzaG9wbGlicz1gY2F0IDw8J0VORCcKZXZhbCAkdHJ5d29ya3Nob3BjYyAtIyMjIDI+JjEg
fCBcCnNlZCAtbiAnLyAtWSAvcyEuKiAtWSAiUCxcKFteIl0qXCkiLiohXDEhcCcgfCB0ciAnOicg
JyAnIHwgXApzZWQgLWUgJ3MhL3Vzci9saWIvc3BhcmN2OSEhJyAtZSAncyEvdXNyL2Njcy9saWIv
c3BhcmN2OSEhJyBcCiAgICAtZSAncyEvdXNyL2xpYiEhZycgLWUgJ3MhL3Vzci9jY3MvbGliISFn
JwpFTkQKYAoKY2FzZSAiJGNjIiBpbgonJykgICAgZm9yIGkgaW4gYGxzIC1yIC9vcHQvc29sKnN0
dWRpbyovYmluL2NjYCAvb3B0L1NVTldzcHJvL2Jpbi9jYwogICAgICAgZG8KCSAgICAgICBpZiB0
ZXN0IC1mICIkaSI7IHRoZW4KCQkgICAgICAgY2M9JGkKCQkgICAgICAgY2F0IDw8RU9GID4mNAoK
WW91IHNwZWNpZmllZCBubyBjYyBidXQgeW91IHNlZW0gdG8gaGF2ZSB0aGUgV29ya3Nob3AgY29t
cGlsZXIKKCRjYykgaW5zdGFsbGVkLCB1c2luZyB0aGF0LgpJZiB5b3Ugd2FudCBzb21ldGhpbmcg
ZWxzZSwgc3BlY2lmeSB0aGF0IGluIHRoZSBjb21tYW5kIGxpbmUsCmUuZy4gQ29uZmlndXJlIC1E
Y2M9Z2NjCgpFT0YKCQkJYnJlYWsKCQlmaQoJZG9uZQoJOzsKZXNhYwoKIyMjIyMjIyMjIyMjIyMj
IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjCiMgR2VuZXJhbCBzYW5pdHkg
dGVzdGluZy4gIFNlZSBiZWxvdyBmb3IgZXhjZXJwdHMgZnJvbSB0aGUgU29sYXJpcyBGQVEuCiMK
IyBGcm9tIHJvZWhyaWNoQGlyb253b29kLWZkZGkuY3JheS5jb20gV2VkIFNlcCAyNyAxMjo1MTo0
NiAxOTk1CiMgRGF0ZTogVGh1LCA3IFNlcCAxOTk1IDE2OjMxOjQwIC0wNTAwCiMgRnJvbTogRGVh
biBSb2VocmljaCA8cm9laHJpY2hAaXJvbndvb2QtZmRkaS5jcmF5LmNvbT4KIyBUbzogcGVybDUt
cG9ydGVyc0BhZnJpY2Eubmljb2guY29tCiMgU3ViamVjdDogUmU6IE9uIHBlcmw1L3NvbGFyaXMv
Z2NjCiMKIyBIZXJlJ3MgYW5vdGhlciBkcmFmdCBvZiB0aGUgcGVybDUvc29sYXJpcy9nY2Mgc2Fu
aXR5LWNoZWNrZXIuCgpjYXNlIGB0eXBlICR7Y2M6LWNjfWAgaW4KKi91c3IvdWNiL2NjKikgY2F0
IDw8RU5EID4mNAoKTk9URTogIFNvbWUgcGVvcGxlIGhhdmUgcmVwb3J0ZWQgcHJvYmxlbXMgd2l0
aCAvdXNyL3VjYi9jYy4KSWYgeW91IGhhdmUgZGlmZmljdWx0aWVzLCBwbGVhc2UgbWFrZSBzdXJl
IHRoZSBkaXJlY3RvcnkKY29udGFpbmluZyB5b3VyIEMgY29tcGlsZXIgaXMgYmVmb3JlIC91c3Iv
dWNiIGluIHlvdXIgUEFUSC4KCkVORAo7Owplc2FjCgoKIyBDaGVjayB0aGF0IC9kZXYvZmQgaXMg
bW91bnRlZC4gIElmIGl0IGlzIG5vdCBtb3VudGVkLCBsZXQgdGhlCiMgdXNlciBrbm93IHRoYXQg
c3VpZCBzY3JpcHRzIG1heSBub3Qgd29yay4KJHJ1biBtb3VudCB8IGdyZXAgJ14vZGV2L2ZkICcg
Mj4mMSA+IC9kZXYvbnVsbApjYXNlICQ/IGluCjApIDs7CiopCgljYXQgPDxFTkQgPiY0CgpOT1RF
OiBZb3VyIHN5c3RlbSBkb2VzIG5vdCBoYXZlIC9kZXYvZmQgbW91bnRlZC4gIElmIHlvdSB3YW50
IHRvCmJlIGFibGUgdG8gdXNlIHNldC11aWQgc2NyaXB0cyB5b3UgbXVzdCBhc2sgeW91ciBzeXN0
ZW0gYWRtaW5pc3RyYXRvcgp0byBtb3VudCAvZGV2L2ZkLgoKRU5ECgk7Owplc2FjCgoKIyBTZWUg
aWYgbGlidWNiIGNhbiBiZSBmb3VuZCBpbiAvdXNyL2xpYi4gIElmIGl0IGlzLCB3YXJuIHRoZSB1
c2VyCiMgdGhhdCB0aGlzIG1heSBjYXVzZSBwcm9ibGVtcyB3aGlsZSBidWlsZGluZyBQZXJsIGV4
dGVuc2lvbnMuCmZvdW5kX2xpYnVjYj0nJwpjYXNlICIkcnVuIiBpbgonJykgL3Vzci9iaW4vbHMg
L3Vzci9saWIvbGlidWNiKiA+L2Rldi9udWxsIDI+JjEKICAgIGZvdW5kX2xpYnVjYj0kPwogICAg
OzsKKikgICRydW4gL3Vzci9iaW4vbHMgJy91c3IvbGliL2xpYnVjYionID4vZGV2L251bGwgMj4m
MQogICAgZm91bmRfbGlidWNiPSQ/CiAgICA7Owplc2FjCgpjYXNlICRmb3VuZF9saWJ1Y2IgaW4K
MCkKCWNhdCA8PEVORCA+JjQKCk5PVEU6IGxpYnVjYiBoYXMgYmVlbiBmb3VuZCBpbiAvdXNyL2xp
Yi4gIGxpYnVjYiBzaG91bGQgcmVzaWRlIGluCi91c3IvdWNibGliLiAgWW91IG1heSBoYXZlIHRy
b3VibGUgd2hpbGUgYnVpbGRpbmcgUGVybCBleHRlbnNpb25zLgoKRU5ECjs7CmVzYWMKCiMgVXNl
IHNoZWxsIGJ1aWx0LWluICd0eXBlJyBjb21tYW5kIGluc3RlYWQgb2YgL3Vzci9iaW4vd2hpY2gg
dG8KIyBhdm9pZCBwb3NzaWJsZSBjc2ggc3RhcnQtdXAgcHJvYmxlbXMgYW5kIGFsc28gdG8gdXNl
IHRoZSBzYW1lIHNoZWxsCiMgd2UnbGwgYmUgdXNpbmcgdG8gQ29uZmlndXJlIGFuZCBtYWtlIHBl
cmwuCiMgVGhlIHBhdGggbmFtZSBpcyB0aGUgbGFzdCBmaWVsZCBpbiB0aGUgb3V0cHV0LCBidXQg
dGhlIHR5cGUgY29tbWFuZAojIGhhcyBhbiBhbm5veWluZyBhcnJheSBvZiBwb3NzaWJsZSBvdXRw
dXRzLCBlLmcuOgojCW1ha2UgaXMgaGFzaGVkICgvb3B0L2dudS9iaW4vbWFrZSkKIwljYyBpcyAv
dXNyL3VjYi9jYwojCWZvbyBub3QgZm91bmQKIyB1c2UgYSBjb21tYW5kIGxpa2UgdHlwZSBtYWtl
IHwgYXdrICd7cHJpbnQgJE5GfScgfCBzZWQgJ3MvWygpXS8vZycKCiMgU2VlIGlmIG1ha2UoMSkg
aXMgR05VIG1ha2UoMSkuCiMgSWYgaXQgaXMsIG1ha2Ugc3VyZSB0aGUgc2V0Z2lkIGJpdCBpcyBu
b3Qgc2V0LgptYWtlIC12ID4gbWFrZS52ZXJzIDI+JjEKaWYgZ3JlcCBHTlUgbWFrZS52ZXJzID4g
L2Rldi9udWxsIDI+JjE7IHRoZW4KICAgIHRtcD1gdHlwZSBtYWtlIHwgYXdrICd7cHJpbnQgJE5G
fScgfCBzZWQgJ3MvWygpXS8vZydgCiAgICBjYXNlICJgJHtsczotJy91c3IvYmluL2xzJ30gLWxM
ICR0bXBgIiBpbgogICAgPz8/Pz8/cyopCgkgICAgY2F0IDw8RU5EID4mMgoKTk9URTogWW91ciBQ
QVRIIHBvaW50cyB0byBHTlUgbWFrZSwgYW5kIHlvdXIgR05VIG1ha2UgaGFzIHRoZSBzZXQtZ3Jv
dXAtaWQKYml0IHNldC4gIFlvdSBtdXN0IGVpdGhlciByZWFycmFuZ2UgeW91ciBQQVRIIHRvIHB1
dCAvdXNyL2Njcy9iaW4gYmVmb3JlIHRoZQpHTlUgdXRpbGl0aWVzIG9yIHlvdSBtdXN0IGFzayB5
b3VyIHN5c3RlbSBhZG1pbmlzdHJhdG9yIHRvIGRpc2FibGUgdGhlCnNldC1ncm91cC1pZCBiaXQg
b24gR05VIG1ha2UuCgpFTkQKCSAgICA7OwogICAgZXNhYwpmaQpybSAtZiBtYWtlLnZlcnMKCmNh
dCA+IFVVL2NjLmNidSA8PCdFT0NCVScKIyBUaGlzIHNjcmlwdCBVVS9jYy5jYnUgd2lsbCBnZXQg
J2NhbGxlZC1iYWNrJyBieSBDb25maWd1cmUgYWZ0ZXIgaXQKIyBoYXMgcHJvbXB0ZWQgdGhlIHVz
ZXIgZm9yIHRoZSBDIGNvbXBpbGVyIHRvIHVzZS4KCiMgSWYgdGhlIEMgY29tcGlsZXIgaXMgZ2Nj
OgojICAgLSBjaGVjayB0aGUgZml4ZWQtaW5jbHVkZXMKIyAgIC0gY2hlY2sgYXMoMSkgYW5kIGxk
KDEpLCB0aGV5IHNob3VsZCBub3QgYmUgR05VCiMJKEdOVSBhcyBhbmQgbGQgMi44LjEgYW5kIGxh
dGVyIGFyZSByZXBvcnRlZGx5IG9rLCBob3dldmVyLikKIyBJZiB0aGUgQyBjb21waWxlciBpcyBu
b3QgZ2NjOgojICAgLSBDaGVjayBpZiBpdCBpcyB0aGUgV29ya3Nob3AvRm9ydGUgY29tcGlsZXIu
CiMgICAgIElmIGl0IGlzLCBwcmVwYXJlIGZvciA2NCBiaXQgYW5kIGxvbmcgZG91Ymxlcy4KIyAg
IC0gY2hlY2sgYXMoMSkgYW5kIGxkKDEpLCB0aGV5IHNob3VsZCBub3QgYmUgR05VCiMJKEdOVSBh
cyBhbmQgbGQgMi44LjEgYW5kIGxhdGVyIGFyZSByZXBvcnRlZGx5IG9rLCBob3dldmVyLikKIwoj
IFdhdGNoIG91dCBpbiBjYXNlIHRoZXkgaGF2ZSBub3Qgc2V0ICRjYy4KCiMgUGVybCBjb21waWxl
ZCB3aXRoIHNvbWUgY29tYmluYXRpb25zIG9mIEdOVSBhcyBhbmQgbGQgbWF5IG5vdAojIGJlIGFi
bGUgdG8gcGVyZm9ybSBkeW5hbWljIGxvYWRpbmcgb2YgZXh0ZW5zaW9ucy4gIElmIHlvdSBoYXZl
IGEKIyBwcm9ibGVtIHdpdGggZHluYW1pYyBsb2FkaW5nLCBiZSBzdXJlIHRoYXQgeW91IGFyZSB1
c2luZyB0aGUgU29sYXJpcwojIC91c3IvY2NzL2Jpbi9hcyBhbmQgL3Vzci9jY3MvYmluL2xkLiAg
WW91IGNhbiBkbyB0aGF0IHdpdGgKIwlzaCBDb25maWd1cmUgLURjYz0nZ2NjIC1CL3Vzci9jY3Mv
YmluLycKIyAobm90ZSB0aGUgdHJhaWxpbmcgc2xhc2ggaXMgcmVxdWlyZWQpLgojIENvbWJpbmF0
aW9ucyB0aGF0IGFyZSBrbm93biB0byB3b3JrIHdpdGggdGhlIGZvbGxvd2luZyBoaW50czoKIwoj
ICBnY2MtMi43LjIsIEdOVSBhcyAyLjcsIEdOVSBsZCAyLjcKIyAgZWdjcy0xLjAuMywgR05VIGFz
IDIuOS4xIGFuZCBHTlUgbGQgMi45LjEKIwktLUFuZHkgRG91Z2hlcnR5ICA8ZG91Z2hlcmFAbGFm
YXlldHRlLmVkdT4KIwlUdWUgQXByIDEzIDE3OjE5OjQzIEVEVCAxOTk5CgojIEdldCBnY2MgdG8g
c2hhcmUgaXRzIHNlY3JldHMuCmVjaG8gJ2ludCBtYWluKCkgeyByZXR1cm4gMDsgfScgPiB0cnku
YwoJIyBJbmRlbnQgdG8gYXZvaWQgcHJvcGFnYXRpb24gdG8gY29uZmlnLnNoCgl2ZXJib3NlPWAk
e2NjOi1jY30gJGNjZmxhZ3MgLXYgLW8gdHJ5IHRyeS5jIDI+JjFgCgojIFhYWCBUT0RPOiAgJ3Nw
ZWNzJyBvdXRwdXQgY2hhbmdlZCBmcm9tICdSZWFkaW5nIHNwZWNzIGZyb20nIGluIGdjYy1bMjNd
IHRvICdVc2luZwojIGJ1aWx0LWluIHNwZWNzJyBpbiBnY2MtNC4gIFBlcmhhcHMgd2Ugc2hvdWxk
IGp1c3QgdXNlIHRoZSBzYW1lIGdjYyB0ZXN0IGFzCiMgaW4gQ29uZmlndXJlIHRvIHNlZSBpZiB3
ZSdyZSB1c2luZyBnY2MuCmlmIGVjaG8gIiR2ZXJib3NlIiB8IGVncmVwICcoUmVhZGluZyBzcGVj
cyBmcm9tKXwoVXNpbmcgYnVpbHQtaW4gc3BlY3MpJyA+L2Rldi9udWxsIDI+JjE7IHRoZW4KCSMK
CSMgVXNpbmcgZ2NjLgoJIwoJY2NfbmFtZT0nZ2NjJwoKCSMgU2VlIGlmIGFzKDEpIGlzIEdOVSBh
cygxKS4gIEdOVSBhcygxKSBtaWdodCBub3Qgd29yayBmb3IgdGhpcyBqb2IuCglpZiBlY2hvICIk
dmVyYm9zZSIgfCBncmVwICcgL3Vzci9jY3MvYmluL2FzICcgPi9kZXYvbnVsbCAyPiYxOyB0aGVu
CgkgICAgOgoJZWxzZQoJICAgIGNhdCA8PEVORCA+JjIKCk5PVEU6IFlvdSBhcmUgdXNpbmcgR05V
IGFzKDEpLiAgR05VIGFzKDEpIG1pZ2h0IG5vdCBidWlsZCBQZXJsLiAgSWYgeW91CmhhdmUgdHJv
dWJsZSwgeW91IGNhbiB1c2UgL3Vzci9jY3MvYmluL2FzIGJ5IGluY2x1ZGluZyAtQi91c3IvY2Nz
L2Jpbi8KaW4geW91ciAke2NjOi1jY30gY29tbWFuZC4gIChOb3RlIHRoYXQgdGhlIHRyYWlsaW5n
ICIvIiBpcyByZXF1aXJlZC4pCgpFTkQKCSAgICAjIEFwcGFyZW50bHkgbm90IG5lZWRlZCwgYXQg
bGVhc3QgZm9yIGFzIDIuNyBhbmQgbGF0ZXIuCgkgICAgIyBjYz0iJHtjYzotY2N9ICRjY2ZsYWdz
IC1CL3Vzci9jY3MvYmluLyIKCWZpCgoJIyBTZWUgaWYgbGQoMSkgaXMgR05VIGxkKDEpLiAgR05V
IGxkKDEpIG1pZ2h0IG5vdCB3b3JrIGZvciB0aGlzIGpvYi4KCSMgUmVjb21wdXRlICR2ZXJib3Nl
IHNpbmNlIHdlIG1heSBoYXZlIGp1c3QgY2hhbmdlZCAkY2MuCgl2ZXJib3NlPWAke2NjOi1jY30g
JGNjZmxhZ3MgLXYgLW8gdHJ5IHRyeS5jIDI+JjEgfCBncmVwIGxkIDI+JjFgCgoJaWYgZWNobyAi
JHZlcmJvc2UiIHwgZ3JlcCAnIC91c3IvY2NzL2Jpbi9sZCAnID4vZGV2L251bGwgMj4mMTsgdGhl
bgoJICAgICMgT2ssIGdjYyBkaXJlY3RseSBjYWxscyB0aGUgU29sYXJpcyAvdXNyL2Njcy9iaW4v
bGQuCgkgICAgOgoJZWxpZiBlY2hvICIkdmVyYm9zZSIgfCBncmVwICJsZDogU29mdHdhcmUgR2Vu
ZXJhdGlvbiBVdGlsaXRpZXMiID4vZGV2L251bGwgMj4mMTsgdGhlbgoJICAgICMgSG1tLiAgZ2Nj
IGRvZXNuJ3QgY2FsbCAvdXNyL2Njcy9iaW4vbGQgZGlyZWN0bHksIGJ1dCBpdAoJICAgICMgZG9l
cyBhcHBlYXIgdG8gYmUgdXNpbmcgaXQgZXZlbnR1YWxseS4gIGVnY3MtMS4wLjMncyBsZAoJICAg
ICMgd3JhcHBlciBkb2VzIHRoaXMuCgkgICAgIyBNb3N0IFNvbGFyaXMgdmVyc2lvbnMgb2YgbGQg
SSd2ZSBzZWVuIGNvbnRhaW4gdGhlIG1hZ2ljCgkgICAgIyBzdHJpbmcgdXNlZCBpbiB0aGUgZ3Jl
cC4KCSAgICA6CgllbGlmIGVjaG8gIiR2ZXJib3NlIiB8IGdyZXAgIlNvbGFyaXMgTGluayBFZGl0
b3JzIiA+L2Rldi9udWxsIDI+JjE7IHRoZW4KCSAgICAjIEhvd2V2ZXIgc29tZSBTb2xhcmlzIDgg
dmVyc2lvbnMgcHJpb3IgdG8gbGQgNS44LTEuMjg2IGNvbnRhaW4KCSAgICAjIHRoaXMgc3RyaW5n
IGluc3RlYWQuCgkgICAgOgoJZWxzZQoJICAgICMgTm8gZXZpZGVuY2UgeWV0IG9mIC91c3IvY2Nz
L2Jpbi9sZC4gIFNvbWUgdmVyc2lvbnMKCSAgICAjIG9mIGVnY3MncyBsZCB3cmFwcGVyIGNhbGwg
L3Vzci9jY3MvYmluL2xkIGluIHR1cm4gYnV0CgkgICAgIyBhcHBhcmVudGx5IGRvbid0IHJldmVh
bCB0aGF0IHVubGVzcyB5b3UgcGFzcyBpbiAtVi4KCSAgICAjIChUaGlzIG1heSBhbGwgZGVwZW5k
IG9uIGxvY2FsIGNvbmZpZ3VyYXRpb25zIHRvby4pCgoJICAgICMgUmVjb21wdXRlIHZlcmJvc2Ug
d2l0aCAtV2wsLXYgdG8gZmluZCBHTlUgbGQgaWYgcHJlc2VudAoJICAgIHZlcmJvc2U9YCR7Y2M6
LWNjfSAkY2NmbGFncyAtV2wsLXYgLW8gdHJ5IHRyeS5jIDI+JjEgfCBncmVwIC9sZCAyPiYxYAoK
CSAgICBteWxkPWBlY2hvICR2ZXJib3NlIHwgYXdrICcvXC9sZC8ge3ByaW50ICQxfSdgCgkgICAg
IyBUaGlzIGFzc3VtZXMgdGhhdCBnY2MncyBvdXRwdXQgd2lsbCBub3QgY2hhbmdlLCBhbmQgdGhh
dAoJICAgICMgL2Z1bGwvcGF0aC90by9sZCB3aWxsIGJlIHRoZSBmaXJzdCB3b3JkIG9mIHRoZSBv
dXRwdXQuCgkgICAgIyBUaHVzIG15bGQgaXMgc29tZXRoaW5nIGxpa2UgL29wdC9nbnUvc3BhcmMt
c3VuLXNvbGFyaXMyLjUvYmluL2xkCgoJICAgICMgQWxsb3cgdGhhdCAkbXlsZCBtYXkgYmUgJycs
IGR1ZSB0byBjaGFuZ2VzIGluIGdjYydzIG91dHB1dAoJICAgIGlmICR7bXlsZDotbGR9IC1WIDI+
JjEgfAoJCWdyZXAgImxkOiBTb2Z0d2FyZSBHZW5lcmF0aW9uIFV0aWxpdGllcyIgPi9kZXYvbnVs
bCAyPiYxOyB0aGVuCgkJIyBPaywgL3Vzci9jY3MvYmluL2xkIGV2ZW50dWFsbHkgZG9lcyBnZXQg
Y2FsbGVkLgoJCToKCSAgICBlbGlmICR7bXlsZDotbGR9IC1WIDI+JjEgfAoJCWdyZXAgIlNvbGFy
aXMgTGluayBFZGl0b3JzIiA+L2Rldi9udWxsIDI+JjE7IHRoZW4KCQkjIE9rLCAvdXNyL2Njcy9i
aW4vbGQgZXZlbnR1YWxseSBkb2VzIGdldCBjYWxsZWQuCgkJOgoJICAgIGVsc2UKCQllY2hvICJG
b3VuZCBHTlUgbGQ9JyRteWxkJyIgPiY0CgkJY2F0IDw8RU5EID4mMgoKTk9URTogWW91IGFyZSB1
c2luZyBHTlUgbGQoMSkuICBHTlUgbGQoMSkgbWlnaHQgbm90IGJ1aWxkIFBlcmwuICBJZiB5b3UK
aGF2ZSB0cm91YmxlLCB5b3UgY2FuIHVzZSAvdXNyL2Njcy9iaW4vbGQgYnkgaW5jbHVkaW5nIC1C
L3Vzci9jY3MvYmluLwppbiB5b3VyICR7Y2M6LWNjfSBjb21tYW5kLiAgKE5vdGUgdGhhdCB0aGUg
dHJhaWxpbmcgIi8iIGlzIHJlcXVpcmVkLikKCkkgd2lsbCB0cnkgdG8gdXNlIEdOVSBsZCBieSBw
YXNzaW5nIGluIHRoZSAtV2wsLUUgZmxhZywgYnV0IGlmIHRoYXQKZG9lc24ndCB3b3JrLCB5b3Ug
c2hvdWxkIHVzZSAtQi91c3IvY2NzL2Jpbi8gaW5zdGVhZC4KCkVORAoJCWNjZGxmbGFncz0iJGNj
ZGxmbGFncyAtV2wsLUUiCgkJbGRkbGZsYWdzPSIkbGRkbGZsYWdzIC1XbCwtRSAtc2hhcmVkIgoJ
ICAgIGZpCglmaQoKZWxzZQoJIwoJIyBOb3QgdXNpbmcgZ2NjLgoJIwoJY2F0ID4gdHJ5LmMgPDwg
J0VPTScKI2luY2x1ZGUgPHN0ZGlvLmg+CmludCBtYWluKCkgewojaWYgZGVmaW5lZChfX1NVTlBS
T19DKQoJcHJpbnRmKCJ3b3Jrc2hvcFxuIik7CiNlbHNlCiNpZiBkZWZpbmVkKF9fU1VOUFJPX0ND
KQoJcHJpbnRmKCJ3b3Jrc2hvcCBDQ1xuIik7CiNlbHNlCglwcmludGYoIlxuIik7CiNlbmRpZgoj
ZW5kaWYKcmV0dXJuKDApOwp9CkVPTQoJdHJ5d29ya3Nob3BjYz0iJHtjYzotY2N9ICRjY2ZsYWdz
IHRyeS5jIC1vIHRyeSIKCWlmICR0cnl3b3Jrc2hvcGNjID4vZGV2L251bGwgMj4mMTsgdGhlbgoJ
CWNjX25hbWU9YCRydW4gLi90cnlgCgkJaWYgdGVzdCAiJGNjX25hbWUiID0gIndvcmtzaG9wIjsg
dGhlbgoJCQljY3ZlcnNpb249ImAke2NjOi1jY30gLVYgMj4mMXxzZWQgLW4gLWUgJzFzL15bQ2Nd
W0NjOV05KjogLy9wJ2AiCgkJZmkKCQlpZiB0ZXN0ICIkY2NfbmFtZSIgPSAid29ya3Nob3AgQ0Mi
OyB0aGVuCgkJCWNjdmVyc2lvbj0iYCR7Y2M6LUNDfSAtViAyPiYxfHNlZCAtbiAtZSAnMXMvXltD
Y11bQ106IC8vcCdgIgoJCWZpCgkJY2FzZSAiJGNjX25hbWUiIGluCgkJd29ya3Nob3AqKQoJCQkj
IFNldHRpbmdzIGZvciBlaXRoZXIgY2Mgb3IgQ0MKCQkJaWYgdGVzdCAhICIkdXNlNjRiaXRhbGxf
ZG9uZSI7IHRoZW4KCQkJCWxvY2xpYnB0aD0iL3Vzci9saWIgL3Vzci9jY3MvbGliIGAkZ2V0d29y
a3Nob3BsaWJzYCAkbG9jbGlicHRoIgoJCQlmaQoJCQkjIFN1biBDQy9jYyBkb24ndCBzdXBwb3J0
IGdjYyBhdHRyaWJ1dGVzCgkJCWRfYXR0cmlidXRlX2Zvcm1hdD0ndW5kZWYnCgkJCWRfYXR0cmli
dXRlX21hbGxvYz0ndW5kZWYnCgkJCWRfYXR0cmlidXRlX25vbm51bGw9J3VuZGVmJwoJCQlkX2F0
dHJpYnV0ZV9ub3JldHVybj0ndW5kZWYnCgkJCWRfYXR0cmlidXRlX3B1cmU9J3VuZGVmJwoJCQlk
X2F0dHJpYnV0ZV91bnVzZWQ9J3VuZGVmJwoJCQlkX2F0dHJpYnV0ZV93YXJuX3VudXNlZF9yZXN1
bHQ9J3VuZGVmJwoJCQljYXNlICIkY2MiIGluCgkJCSpjOTkpCSMgYzk5IHJlamVjdHMgYmFyZSAn
LU8nLgoJCQkJY2FzZSAiJG9wdGltaXplIiBpbgoJCQkJJyd8LU8pIG9wdGltaXplPS1PMyA7OwoJ
CQkJZXNhYwoJCQkJIyBXaXRob3V0IC1YYSBjOTkgZG9lc24ndCBzZWUKCQkJCSMgbWFueSBPUyBp
bnRlcmZhY2VzLgoJCQkJY2FzZSAiJGNjZmxhZ3MiIGluCgkJCQkqLVhhKikJOzsKCQkJCSopIGNj
ZmxhZ3M9IiRjY2ZsYWdzIC1YYSIgOzsKCQkJCWVzYWMKCQkJCTs7CgkJCWVzYWMKCQkJOzsKCQll
c2FjCglmaQoKCSMgU2VlIGlmIGFzKDEpIGlzIEdOVSBhcygxKS4gIEdOVSBtaWdodCBub3Qgd29y
ayBmb3IgdGhpcyBqb2IuCgljYXNlIGBhcyAtLXZlcnNpb24gPCAvZGV2L251bGwgMj4mMWAgaW4K
CSpHTlUqKQoJCWNhdCA8PEVORCA+JjIKCk5PVEU6IFlvdSBhcmUgdXNpbmcgR05VIGFzKDEpLiAg
R05VIGFzKDEpIG1pZ2h0IG5vdCBidWlsZCBQZXJsLgpZb3UgbXVzdCBhcnJhbmdlIHRvIHVzZSAv
dXNyL2Njcy9iaW4vYXMsIHBlcmhhcHMgYnkgYWRkaW5nIC91c3IvY2NzL2Jpbgp0byB0aGUgYmVn
aW5uaW5nIG9mIHlvdXIgUEFUSC4KCkVORAoJCTs7Cgllc2FjCgoJIyBTZWUgaWYgbGQoMSkgaXMg
R05VIGxkKDEpLiAgR05VIGxkKDEpIG1pZ2h0IG5vdCB3b3JrIGZvciB0aGlzIGpvYi4KCSMgbGQg
LS12ZXJzaW9uIGRvZXNuJ3QgcHJvcGVybHkgcmVwb3J0IGl0c2VsZiBhcyBhIEdOVSB0b29sLAoJ
IyBhcyBvZiBsZCB2ZXJzaW9uIDIuNiwgc28gd2UgbmVlZCB0byBiZSBtb3JlIHN0cmljdC4gVFdQ
IDkvNS85NgoJIyBTdW4ncyBsZCBhbHdheXMgZW1pdHMgdGhlICJTb2Z0d2FyZSBHZW5lcmF0aW9u
IFV0aWxpdGllcyIgc3RyaW5nLgoJaWYgbGQgLVYgMj4mMSB8IGdyZXAgImxkOiBTb2Z0d2FyZSBH
ZW5lcmF0aW9uIFV0aWxpdGllcyIgPi9kZXYvbnVsbCAyPiYxOyB0aGVuCgkgICAgIyBPaywgbGQg
aXMgL3Vzci9jY3MvYmluL2xkLgoJICAgIDoKCWVsc2UKCSAgICBjYXQgPDxFTkQgPiYyCgpOT1RF
OiBZb3UgYXJlIGFwcGFyZW50bHkgdXNpbmcgR05VIGxkKDEpLiAgR05VIGxkKDEpIG1pZ2h0IG5v
dCBidWlsZCBQZXJsLgpZb3Ugc2hvdWxkIGFycmFuZ2UgdG8gdXNlIC91c3IvY2NzL2Jpbi9sZCwg
cGVyaGFwcyBieSBhZGRpbmcgL3Vzci9jY3MvYmluCnRvIHRoZSBiZWdpbm5pbmcgb2YgeW91ciBQ
QVRILgoKRU5ECglmaQpmaQoKIyBhcyAtLXZlcnNpb24gb3IgbGQgLS12ZXJzaW9uIG1pZ2h0IGR1
bXAgY29yZS4Kcm0gLWYgdHJ5IHRyeS5jIGNvcmUKRU9DQlUKCmNhdCA+IFVVL3VzZXRocmVhZHMu
Y2J1IDw8J0VPQ0JVJwojIFRoaXMgc2NyaXB0IFVVL3VzZXRocmVhZHMuY2J1IHdpbGwgZ2V0ICdj
YWxsZWQtYmFjaycgYnkgQ29uZmlndXJlCiMgYWZ0ZXIgaXQgaGFzIHByb21wdGVkIHRoZSB1c2Vy
IGZvciB3aGV0aGVyIHRvIHVzZSB0aHJlYWRzLgpjYXNlICIkdXNldGhyZWFkcyIgaW4KJGRlZmlu
ZXx0cnVlfFt5WV0qKQoJY2NmbGFncz0iLURfUkVFTlRSQU5UICRjY2ZsYWdzIgoKCSMgLWxwdGhy
ZWFkIG92ZXJyaWRlcyBzb21lIGxpYiBDIGZ1bmN0aW9ucywgc28gcHV0IGl0IGJlZm9yZSBjLgoJ
c2V0IGBlY2hvIFggIiRsaWJzd2FudGVkICJ8IHNlZCAtZSAicy8gYyAvIHB0aHJlYWQgYyAvImAK
CXNoaWZ0CglsaWJzd2FudGVkPSIkKiIKCgkjIHNjaGVkX3lpZWxkIGlzIGF2YWlsYWJsZSBpbiB0
aGUgLWxydCBsaWJyYXJ5LiAgSG93ZXZlciwKCSMgd2UgY2FuIGFsc28gcGljayB1cCB0aGUgZXF1
aXZhbGVudCB5aWVsZCgpIGZ1bmN0aW9uIGluIHRoZQoJIyBub3JtYWwgQyBsaWJyYXJ5LiAgVG8g
YXZvaWQgcHVsbGluZyBpbiB1bm5lY2Vzc2FyeQoJIyBsaWJyYXJpZXMsIHdlJ2xsIG5vcm1hbGx5
IGF2b2lkIHNjaGVkX3lpZWxkKCkvLWxydCBhbmQKCSMganVzdCB1c2UgeWllbGQoKS4gIEhvd2V2
ZXIsIHdlJ2xsIGhvbm9yIGEgY29tbWFuZC1saW5lCgkjIG92ZXJyaWRlIDogIi1Ec2NoZWRfeWll
bGQ9c2NoZWRfeWllbGQiLgoJIyBJZiB3ZSBlbmQgdXAgdXNpbmcgc2NoZWRfeWllbGQsIHdlJ3Jl
IGdvaW5nIHRvIG5lZWQgLWxydC4KCXNjaGVkX3lpZWxkPSR7c2NoZWRfeWllbGQ6LXlpZWxkfQoJ
aWYgdGVzdCAiJHNjaGVkX3lpZWxkIiA9ICJzY2hlZF95aWVsZCI7IHRoZW4KCSAgICBzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICJzLyBwdGhyZWFkIC8gcnQgcHRocmVhZCAvImAK
CSAgICBzaGlmdAoJICAgIGxpYnN3YW50ZWQ9IiQqIgoJZmkKCgkjIE9uIFNvbGFyaXMgMi42IHg4
NiB0aGVyZSBpcyBhIGJ1ZyB3aXRoIHNpZ3NldGptcCgpIGFuZCBzaWdsb25nam1wKCkKCSMgd2hl
biBsaW5rZWQgd2l0aCB0aGUgdGhyZWFkcyBsaWJyYXJ5LCBzdWNoIHRoYXQgd2hhdGV2ZXIgcG9z
aXRpdmUKCSMgdmFsdWUgeW91IHBhc3MgdG8gc2lnbG9uZ2ptcCgpLCBzaWdzZXRqbXAoKSByZXR1
cm5zIDEuCgkjIFRoYW5rcyB0byBTaW1vbiBQYXJzb25zIDxTLlBhcnNvbnNAZnRlbC5jby51az4g
Zm9yIHRoaXMgcmVwb3J0LgoJIyBTdW4gQnVnSUQgaXMgNDExNzk0NiwgInNpZ3NldGptcCBhbHdh
eXMgcmV0dXJucyAxIHdoZW4gY2FsbGVkIGJ5CgkjIHNpZ2xvbmdqbXAgaW4gYSBNVCBwcm9ncmFt
Ii4gQXMgb2YgMTk5ODA2MjIsIHRoZXJlIGlzIG5vIHBhdGNoCgkjIGF2YWlsYWJsZS4KCWNhdCA+
dHJ5LmMgPDwnRU9NJwoJLyogVGVzdCBmb3Igc2lnKHNldHxsb25nKWptcCBidWcuICovCgkjaW5j
bHVkZSA8c2V0am1wLmg+CgoJaW50IG1haW4oKQoJewoJICAgIHNpZ2ptcF9idWYgZW52OwoJICAg
IGludCByZXQ7CgoJICAgIHJldCA9IHNpZ3NldGptcChlbnYsIDEpOwoJICAgIGlmIChyZXQpIHsg
cmV0dXJuIHJldCA9PSAyOyB9CgkgICAgc2lnbG9uZ2ptcChlbnYsIDIpOwoJfQpFT00KCWlmIHRl
c3QgImBhcmNoYCIgPSBpODZwYyAtYSBgdW5hbWUgLXJgID0gNS42ICYmIFwKCSAgICR7Y2M6LWNj
fSB0cnkuYyAtbHB0aHJlYWQgPi9kZXYvbnVsbCAyPiYxICYmIC4vYS5vdXQ7IHRoZW4KCSAgICBk
X3NpZ3NldGptcD0kdW5kZWYKCWZpCgoJIyBUaGVzZSBwcm90b3R5cGVzIHNob3VsZCBiZSB2aXNp
YmxlIHNpbmNlIHdlIHVzaW5nCgkjIC1EX1JFRU5UUkFOVCwgYnV0IHRoYXQgZG9lcyBub3Qgc2Vl
bSB0byB3b3JrLgoJIyBJdCBkb2VzIHNlZW0gdG8gd29yayBmb3IgZ2V0bmV0YnlhZGRyX3IsIHdl
aXJkbHkgZW5vdWdoLAoJIyBhbmQgb3RoZXIgX3IgZnVuY3Rpb25zLiAoU29sYXJpcyA4KQoKCWRf
Y3Rlcm1pZF9yX3Byb3RvPSIkZGVmaW5lIgoJZF9nZXRob3N0YnlhZGRyX3JfcHJvdG89IiRkZWZp
bmUiCglkX2dldGhvc3RieW5hbWVfcl9wcm90bz0iJGRlZmluZSIKCWRfZ2V0bmV0YnluYW1lX3Jf
cHJvdG89IiRkZWZpbmUiCglkX2dldHByb3RvYnluYW1lX3JfcHJvdG89IiRkZWZpbmUiCglkX2dl
dHByb3RvYnludW1iZXJfcl9wcm90bz0iJGRlZmluZSIKCWRfZ2V0c2VydmJ5bmFtZV9yX3Byb3Rv
PSIkZGVmaW5lIgoJZF9nZXRzZXJ2Ynlwb3J0X3JfcHJvdG89IiRkZWZpbmUiCgoJIyBEaXR0by4g
KFNvbGFyaXMgNykKCWRfcmVhZGRpcl9yX3Byb3RvPSIkZGVmaW5lIgoJZF9yZWFkZGlyNjRfcl9w
cm90bz0iJGRlZmluZSIKCWRfdG1wbmFtX3JfcHJvdG89IiRkZWZpbmUiCglkX3R0eW5hbWVfcl9w
cm90bz0iJGRlZmluZSIKCgk7Owplc2FjCkVPQ0JVCgpjYXQgPiBVVS91c2VsYXJnZWZpbGVzLmNi
dSA8PCdFT0NCVScKIyBUaGlzIHNjcmlwdCBVVS91c2VsYXJnZWZpbGVzLmNidSB3aWxsIGdldCAn
Y2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZQojIGFmdGVyIGl0IGhhcyBwcm9tcHRlZCB0aGUgdXNl
ciBmb3Igd2hldGhlciB0byB1c2UgbGFyZ2UgZmlsZXMuCmNhc2UgIiR1c2VsYXJnZWZpbGVzIiBp
bgonJ3wkZGVmaW5lfHRydWV8W3lZXSopCgojIEtlZXAgdGhlc2UgaW4gdGhlIGxlZnQgbWFyZ2lu
LgpjY2ZsYWdzX3VzZWxhcmdlZmlsZXM9ImAkcnVuIGdldGNvbmYgTEZTX0NGTEFHUyAyPi9kZXYv
bnVsbGAiCmxkZmxhZ3NfdXNlbGFyZ2VmaWxlcz0iYCRydW4gZ2V0Y29uZiBMRlNfTERGTEFHUyAy
Pi9kZXYvbnVsbGAiCmxpYnN3YW50ZWRfdXNlbGFyZ2VmaWxlcz0iYCRydW4gZ2V0Y29uZiBMRlNf
TElCUyAyPi9kZXYvbnVsbHxzZWQgLWUgJ3NAXi1sQEAnIC1lICdzQCAtbEAgQGcnYCIKCiAgICBj
Y2ZsYWdzPSIkY2NmbGFncyAkY2NmbGFnc191c2VsYXJnZWZpbGVzIgogICAgbGRmbGFncz0iJGxk
ZmxhZ3MgJGxkZmxhZ3NfdXNlbGFyZ2VmaWxlcyIKICAgIGxpYnN3YW50ZWQ9IiRsaWJzd2FudGVk
ICRsaWJzd2FudGVkX3VzZWxhcmdlZmlsZXMiCiAgICA7Owplc2FjCkVPQ0JVCgojIFRoaXMgaXMg
dHJ1bHkgYSBtZXNzLgpjYXNlICIkdXNlbW9yZWJpdHMiIGluCiIkZGVmaW5lInx0cnVlfFt5WV0q
KQoJdXNlNjRiaXRpbnQ9IiRkZWZpbmUiCgl1c2Vsb25nZG91YmxlPSIkZGVmaW5lIgoJOzsKZXNh
YwoKaWYgdGVzdCBgJHJ1biB1bmFtZSAtcGAgPSBpMzg2OyB0aGVuCiAgICBjYXNlICIkdXNlNjRi
aXRpbnQiIGluCiAgICAiJGRlZmluZSJ8dHJ1ZXxbeVldKikKICAgICAgICAgICAgY2NmbGFncz0i
JGNjZmxhZ3MgLURQVFJfSVNfTE9ORyIKICAgICAgICAgICAgOzsKICAgIGVzYWMKZmkKCmlmIHRl
c3QgYCRydW4gdW5hbWUgLXBgID0gc3BhcmMgLW8gYCRydW4gdW5hbWUgLXBgID0gaTM4NjsgdGhl
bgogICAgY2F0ID4gVVUvdXNlNjRiaXRpbnQuY2J1IDw8J0VPQ0JVJwojIFRoaXMgc2NyaXB0IFVV
L3VzZTY0Yml0aW50LmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZQojIGFm
dGVyIGl0IGhhcyBwcm9tcHRlZCB0aGUgdXNlciBmb3Igd2hldGhlciB0byB1c2UgNjQgYml0IGlu
dGVnZXJzLgpjYXNlICIkdXNlNjRiaXRpbnQiIGluCiIkZGVmaW5lInx0cnVlfFt5WV0qKQoJICAg
IGNhc2UgImAkcnVuIHVuYW1lIC1yYCIgaW4KCSAgICA1LlswLTRdKQoJCWNhdCA+JjQgPDxFT00K
U29sYXJpcyBgdW5hbWUgLXJ8c2VkIC1lICdzL141XC4vMi4vJ2AgZG9lcyBub3Qgc3VwcG9ydCA2
NC1iaXQgaW50ZWdlcnMuCllvdSBzaG91bGQgdXBncmFkZSB0byBhdCBsZWFzdCBTb2xhcmlzIDIu
NS4KRU9NCgkJZXhpdCAxCgkJOzsKCSAgICBlc2FjCgojIGdjYy0yLjguMSBvbiBTb2xhcmlzIDgg
d2l0aCAtRHVzZTY0Yml0aW50IGZhaWxzIG9wL3BhdC50IHRlc3QgODIyCiMgaWYgd2UgY29tcGls
ZSByZWdleGVjLmMgd2l0aCAtTy4gIFR1cm4gb2ZmIG9wdGltaXphdGlvbiBmb3IgdGhhdCBvbmUK
IyBmaWxlLiAgU2VlIGhpbnRzL1JFQURNRS5oaW50cyAsIGVzcGVjaWFsbHkKIyA9aGVhZDIgUHJv
cGFnYXRpbmcgdmFyaWFibGVzIHRvIGNvbmZpZy5zaCwgbWV0aG9kIDMuCiMgIEEuIERvdWdoZXJ0
eSAgTWF5IDI0LCAyMDAyCiAgICBjYXNlICIke2djY3ZlcnNpb259LSR7b3B0aW1pemV9IiBpbgog
ICAgMi44Ki1PKikKCSMgSG9ub3IgYSBjb21tYW5kLWxpbmUgb3ZlcnJpZGUgKHJhdGhlciB1bmxp
a2VseSkKCWNhc2UgIiRyZWdleGVjX2NmbGFncyIgaW4KCScnKSBlY2hvICJEaXNhYmxpbmcgb3B0
aW1pemF0aW9uIG9uIHJlZ2V4ZWMuYyBmb3IgZ2NjICRnY2N2ZXJzaW9uIiA+JjQKCSAgICByZWdl
eGVjX2NmbGFncz0nb3B0aW1pemU9JwoJICAgIGVjaG8gInJlZ2V4ZWNfY2ZsYWdzPSdvcHRpbWl6
ZT1cIlwiJyIgPj4gY29uZmlnLnNoCgkgICAgOzsKCWVzYWMKCTs7CiAgICBlc2FjCiAgICA7Owpl
c2FjCkVPQ0JVCgogICAgY2F0ID4gVVUvdXNlNjRiaXRhbGwuY2J1IDw8J0VPQ0JVJwojIFRoaXMg
c2NyaXB0IFVVL3VzZTY0Yml0YWxsLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZp
Z3VyZQojIGFmdGVyIGl0IGhhcyBwcm9tcHRlZCB0aGUgdXNlciBmb3Igd2hldGhlciB0byBiZSBt
YXhpbWFsbHkgNjQgYml0dHkuCmNhc2UgIiR1c2U2NGJpdGFsbC0kdXNlNjRiaXRhbGxfZG9uZSIg
aW4KIiRkZWZpbmUtInx0cnVlLXxbeVldKi0pCgkgICAgY2FzZSAiYCRydW4gdW5hbWUgLXJgIiBp
bgoJICAgIDUuWzAtNl0pCgkJY2F0ID4mNCA8PEVPTQpTb2xhcmlzIGB1bmFtZSAtcnxzZWQgLWUg
J3MvXjVcLi8yLi8nYCBkb2VzIG5vdCBzdXBwb3J0IDY0LWJpdCBwb2ludGVycy4KWW91IHNob3Vs
ZCB1cGdyYWRlIHRvIGF0IGxlYXN0IFNvbGFyaXMgMi43LgpFT00KCQlleGl0IDEKCQk7OwoJICAg
IGVzYWMKCSAgICBwcm9jZXNzb3I9YCRydW4gdW5hbWUgLXBgOwoJICAgIGlmIHRlc3QgIiRwcm9j
ZXNzb3IiID0gc3BhcmM7IHRoZW4KCQlsaWJjPScvdXNyL2xpYi9zcGFyY3Y5L2xpYmMuc28nCgkJ
aWYgdGVzdCAhIC1mICRsaWJjOyB0aGVuCgkJICAgIGNhdCA+JjQgPDxFT00KCkkgZG8gbm90IHNl
ZSB0aGUgNjQtYml0IGxpYmMsICRsaWJjLgpDYW5ub3QgY29udGludWUsIGFib3J0aW5nLgoKRU9N
CgkJICAgIGV4aXQgMQoJCWZpCgkgICAgZmkKCSAgICBjYXNlICIke2NjOi1jY30gLXYgMj4vZGV2
L251bGwiIGluCgkgICAgKmdjYyopCgkJZWNobyAnaW50IG1haW4oKSB7IHJldHVybiAwOyB9JyA+
IHRyeS5jCgkJY2FzZSAiYCR7Y2M6LWNjfSAkY2NmbGFncyAtbWNwdT12OSAtbTY0IC1TIHRyeS5j
IDI+JjEgfCBncmVwICdtNjQgaXMgbm90IHN1cHBvcnRlZCBieSB0aGlzIGNvbmZpZ3VyYXRpb24n
YCIgaW4KCQkqIm02NCBpcyBub3Qgc3VwcG9ydGVkIiopCgkJICAgIGNhdCA+JjQgPDxFT00KCkZ1
bGwgNjQtYml0IGJ1aWxkIGlzIG5vdCBzdXBwb3J0ZWQgYnkgdGhpcyBnY2MgY29uZmlndXJhdGlv
bi4KQ2hlY2sgaHR0cDovL2djYy5nbnUub3JnLyBmb3IgdGhlIGxhdGVzdCBuZXdzIG9mIGF2YWls
YWJpbGl0eQpvZiBnY2MgZm9yIDY0LWJpdCBTcGFyYy4KCkNhbm5vdCBjb250aW51ZSwgYWJvcnRp
bmcuCgpFT00KCQkgICAgZXhpdCAxCgkJICAgIDs7CgkJZXNhYwoJCWlmIHRlc3QgIiRwcm9jZXNz
b3IiID0gc3BhcmM7IHRoZW4KCQkgICAgbG9jbGlicHRoPSIvdXNyL2xpYi9zcGFyY3Y5ICRsb2Ns
aWJwdGgiCgkJICAgIGNjZmxhZ3M9IiRjY2ZsYWdzIC1tY3B1PXY5IgoJCWZpCgkJY2NmbGFncz0i
JGNjZmxhZ3MgLW02NCIKCgkJIyBUaGlzIGFkZHMgaW4gLVdhLC14YXJjaD12OS4gIEkgc3VzcGVj
dCB0aGF0J3Mgc3VwZXJmbHVvdXMsCgkJIyBzaW5jZSB0aGUgLW02NCBhYm92ZSBzaG91bGQgZG8g
dGhhdCBhbHJlYWR5LiAgU29tZW9uZQoJCSMgd2l0aCBnY2MtMy54LngsIHBsZWFzZSB0ZXN0IHdp
dGggZ2NjIC12LiAgIEEuRC4gMjAtTm92LTIwMDMKIwkJaWYgdGVzdCAkcHJvY2Vzc29yID0gc3Bh
cmMgLWEgWGAkcnVuIGdldGNvbmYgWEJTNV9MUDY0X09GRjY0X0NGTEFHUyAyPi9kZXYvbnVsbGAg
IT0gWDsgdGhlbgojCQkgICAgY2NmbGFncz0iJGNjZmxhZ3MgLVdhLGAkcnVuIGdldGNvbmYgWEJT
NV9MUDY0X09GRjY0X0NGTEFHUyAyPi9kZXYvbnVsbGAiCiMJCWZpCgkJbGRmbGFncz0iJGxkZmxh
Z3MgLW02NCIKCgkJIyBTZWUgW3BlcmwgIzY2NjA0XTogIE9uIFNvbGFyaXMgMTEsIGdjYyAtbTY0
IG9uIGFtZDY0CgkJIyBhcHBlYXJzIG5vdCB0byB1bmRlcnN0YW5kIC1HLiAgKGdjYyAtRyBoYXMg
bm90IGNhdXNlZAoJCSMgcHJvYmxlbXMgb24gb3RoZXIgcGxhdGZvcm1zIGluIHRoZSBwYXN0Likg
IGdjYyB2ZXJzaW9ucwoJCSMgYXQgbGVhc3QgYXMgb2xkIGFzIDMuNC4zIHN1cHBvcnQgLXNoYXJl
ZCwgc28ganVzdAoJCSMgdXNlIHRoYXQgd2l0aCBTb2xhcmlzIDExIGFuZCBsYXRlciwgYnV0IGtl
ZXAKCQkjIHRoZSBvbGQgYmVoYXZpb3IgZm9yIG9sZGVyIFNvbGFyaXMgdmVyc2lvbnMuCgkJY2Fz
ZSAiJG9zdmVycyIgaW4KCQkJMi4/fDIuMTApIGxkZGxmbGFncz0iJGxkZGxmbGFncyAtRyAtbTY0
IiA7OwoJCQkqKSBsZGRsZmxhZ3M9IiRsZGRsZmxhZ3MgLXNoYXJlZCAtbTY0IiA7OwoJCWVzYWMK
CQk7OwoJICAgICopCgkJZ2V0Y29uZmNjZmxhZ3M9ImAkcnVuIGdldGNvbmYgWEJTNV9MUDY0X09G
RjY0X0NGTEFHUyAyPi9kZXYvbnVsbGAiCgkJZ2V0Y29uZmxkZmxhZ3M9ImAkcnVuIGdldGNvbmYg
WEJTNV9MUDY0X09GRjY0X0xERkxBR1MgMj4vZGV2L251bGxgIgoJCWdldGNvbmZsZGRsZmxhZ3M9
ImAkcnVuIGdldGNvbmYgWEJTNV9MUDY0X09GRjY0X0xERkxBR1MgMj4vZGV2L251bGxgIgoJCWVj
aG8gImludCBtYWluKCkgeyByZXR1cm4oMCk7IH0gIiA+IHRyeS5jCgkJY2FzZSAiYCR7Y2M6LWNj
fSAkZ2V0Y29uZmNjZmxhZ3MgdHJ5LmMgMj4mMSB8IGdyZXAgJ2RlcHJlY2F0ZWQnYCIgaW4KCQkq
IiAteGFyY2g9Z2VuZXJpYzY0IGlzIGRlcHJlY2F0ZWQsIHVzZSAtbTY0ICIqKQoJCSAgICBnZXRj
b25mY2NmbGFncz1gZWNobyAkZ2V0Y29uZmNjZmxhZ3MgfCBzZWQgLWUgJ3MveGFyY2g9Z2VuZXJp
YzY0L202NC8nYAoJCSAgICBnZXRjb25mbGRmbGFncz1gZWNobyAkZ2V0Y29uZmxkZmxhZ3MgfCBz
ZWQgLWUgJ3MveGFyY2g9Z2VuZXJpYzY0L202NC8nYAoJCSAgICBnZXRjb25mbGRkbGZsYWdzPWBl
Y2hvICRnZXRjb25mbGRkbGZsYWdzIHwgc2VkIC1lICdzL3hhcmNoPWdlbmVyaWM2NC9tNjQvJ2AK
CQkgICAgOzsKCQllc2FjCgkJY2NmbGFncz0iJGNjZmxhZ3MgJGdldGNvbmZjY2ZsYWdzIgoJCWxk
ZmxhZ3M9IiRsZGZsYWdzICRnZXRjb25mbGRmbGFncyIKCQlsZGRsZmxhZ3M9IiRsZGRsZmxhZ3Mg
LUcgJGdldGNvbmZsZGRsZmxhZ3MiCgoJCWVjaG8gImludCBtYWluKCkgeyByZXR1cm4oMCk7IH0g
IiA+IHRyeS5jCgkJdHJ5d29ya3Nob3BjYz0iJHtjYzotY2N9IHRyeS5jIC1vIHRyeSAkY2NmbGFn
cyIKCQlpZiB0ZXN0ICIkcHJvY2Vzc29yIiA9IHNwYXJjOyB0aGVuCgkJICAgIGxvY2xpYnB0aD0i
L3Vzci9saWIvc3BhcmN2OSAvdXNyL2Njcy9saWIvc3BhcmN2OSAkbG9jbGlicHRoIgoJCWZpCgkJ
bG9jbGlicHRoPSJgJGdldHdvcmtzaG9wbGlic2AgJGxvY2xpYnB0aCIKCQk7OwoJICAgIGVzYWMK
CSAgICB1bnNldCBwcm9jZXNzb3IKCSAgICB1c2U2NGJpdGFsbF9kb25lPXllcwoJICAgIGFyY2hu
YW1lNjQ9NjQKCSAgICA7Owplc2FjCkVPQ0JVCgogICAgIyBBY3R1YWxseSwgd2Ugd2FudCB0byBy
dW4gdGhpcyBhbHJlYWR5IG5vdywgaWYgc28gcmVxdWVzdGVkLAogICAgIyBiZWNhdXNlIHdlIG5l
ZWQgdG8gZml4IHVwIHRoaW5ncyByaWdodCBub3cuCiAgICBjYXNlICIkdXNlNjRiaXRhbGwiIGlu
CiAgICAiJGRlZmluZSJ8dHJ1ZXxbeVldKikKCSMgQ0JVcyBleHBlY3QgdG8gYmUgcnVuIGluIFVV
CgljZCBVVTsgLiAuL3VzZTY0Yml0YWxsLmNidTsgY2QgLi4KCTs7CiAgICBlc2FjCmZpCgpjYXQg
PiBVVS91c2Vsb25nZG91YmxlLmNidSA8PCdFT0NCVScKIyBUaGlzIHNjcmlwdCBVVS91c2Vsb25n
ZG91YmxlLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZQojIGFmdGVyIGl0
IGhhcyBwcm9tcHRlZCB0aGUgdXNlciBmb3Igd2hldGhlciB0byB1c2UgbG9uZyBkb3VibGVzLgpj
YXNlICIkdXNlbG9uZ2RvdWJsZSIgaW4KIiRkZWZpbmUifHRydWV8W3lZXSopCglpZiB0ZXN0ICIk
Y2NfbmFtZSIgPSAid29ya3Nob3AiOyB0aGVuCgkJY2F0ID4gdHJ5LmMgPDwgJ0VPTScKI2luY2x1
ZGUgPHN1bm1hdGguaD4KaW50IG1haW4oKSB7ICh2b2lkKSBwb3dsKDIsIDI1Nik7IHJldHVybigw
KTsgfQpFT00KCQlpZiAke2NjOi1jY30gdHJ5LmMgLWxzdW5tYXRoIC1vIHRyeSA+IC9kZXYvbnVs
bCAyPiYxICYmIC4vdHJ5OyB0aGVuCgkJCWxpYnN3YW50ZWQ9IiRsaWJzd2FudGVkIHN1bm1hdGgi
CgkJZmkKCWVsc2UKCQljYXQgPiY0IDw8RU9NCgpUaGUgU3VuIFdvcmtzaG9wIG1hdGggbGlicmFy
eSBpcyBlaXRoZXIgbm90IGF2YWlsYWJsZSBvciBub3Qgd29ya2luZywKc28gSSBkbyBub3Qga25v
dyBob3cgdG8gZG8gbG9uZyBkb3VibGVzLCBzb3JyeS4KSSdtIHRoZXJlZm9yZSBkaXNhYmxpbmcg
dGhlIHVzZSBvZiBsb25nIGRvdWJsZXMuCkVPTQoJCXVzZWxvbmdkb3VibGU9IiR1bmRlZiIKCWZp
Cgk7Owplc2FjCkVPQ0JVCgojCiMgSWYgdW5zZXRlbnYgaXMgYXZhaWxhYmxlLCB1c2UgaXQgaW4g
Y29uanVuY3Rpb24gd2l0aCBQRVJMX1VTRV9TQUZFX1BVVEVOViB0bwojIHdvcmsgYXJvdW5kIFN1
biBidWdpZCA2MzMzODMwLiAgQm90aCB1bnNldGVudiBhbmQgNjMzMzgzMCBvbmx5IGFwcGVhciBp
bgojIFNvbGFyaXMgMTAsIHNvIHdlIGRvbid0IG5lZWQgdG8gcHJvYmUgZXhwbGljaXRseSBmb3Ig
YW4gT1MgdmVyc2lvbi4gIFdlIGhhdmUKIyB0byBhcHBlbmQgdGhpcyB0ZXN0IHRvIHRoZSBlbmQg
b2YgY29uZmlnLm92ZXIgYXMgaXQgbmVlZHMgdG8gcnVuIGFmdGVyCiMgQ29uZmlndXJlIGhhcyBw
cm9iZWQgZm9yIHVuc2V0ZW52LCBhbmQgdGhpcyBoaW50cyBmaWxlIGlzIHByb2Nlc3NlZCBiZWZv
cmUKIyB0aGF0IGhhcyBoYXBwZW5lZC4KIwpjYXQgPj4gY29uZmlnLm92ZXIgPDwnRU9PVkVSJwpp
ZiB0ZXN0ICIkZF91bnNldGVudiIgPSAiJGRlZmluZSIgLWEgXAogICAgYGV4cHIgIiRjY2ZsYWdz
IiA6ICcuKi1EUEVSTF9VU0VfU0FGRV9QVVRFTlYnYCAtZXEgMDsgdGhlbgogICAgICAgIGNjZmxh
Z3M9IiRjY2ZsYWdzIC1EUEVSTF9VU0VfU0FGRV9QVVRFTlYiCmZpCkVPT1ZFUgoKcm0gLWYgdHJ5
LmMgdHJ5Lm8gdHJ5IGEub3V0CgojIElmIHVzaW5nIEMrKywgdGhlIENvbmZpZ3VyZSBzY2FuIGZv
ciBkbG9wZW4oKSB3aWxsIGZhaWwgaW4gU29sYXJpcwojIGJlY2F1c2Ugb25lIG9mIHRoZSB0d28g
KDEpIGFuIGV4dGVybiAiQyIgbGlua2FnZSBkZWZpbml0aW9uIGlzIG5lZWRlZAojICgyKSAjaW5j
bHVkZSA8ZGxmY24uaD4gaXMgbmVlZGVkLCAqYW5kKiBhIGNhc3QgdG8gKHZvaWQqKCopKCkpCiMg
aXMgbmVlZGVkIGZvciB0aGUgJmRsb3Blbi4gIEFkZGluZyBhbnkgb2YgdGhlc2Ugd291bGQgcmVx
dWlyZSBjaGFuZ2luZwojIGEgZGVsaWNhdGUgc3BvdCBpbiBDb25maWd1cmUsIHNvIGVhc2llciBq
dXN0IHRvIGZvcmNlIG91ciBndWVzcyBoZXJlCiMgZm9yIFNvbGFyaXMuICBNdWNoIHRoZSBzYW1l
IGdvZXMgZm9yIGRsZXJyb3IoKS4KY2FzZSAiJGNjIiBpbgoqZysrKnwqQ0MqKQogIGRfZGxvcGVu
PSdkZWZpbmUnCiAgZF9kbGVycm9yPSdkZWZpbmUnCiAgOzsKZXNhYwoKIyBPcmFjbGUvU3VuIGJ1
aWxkcyB0aGVpciBQZXJsIHNoYXJlZCBzaW5jZSA1LjYuMSwgYW5kIHRoZXkgYWxzbwojIHN0cm9u
Z2x5IHJlY29tbWVuZCB1c2luZyBzaGFyZWQgbGlicmFyaWVzIGluIGdlbmVyYWwuCiMKIyBGdXJ0
aGVybW9yZSwgT3BlbkluZGlhbmEgc2VlbXMgdG8gZWZmZWN0aXZlbHkgcmVxdWlyZSBidWlsZGlu
ZyBwZXJsCiMgc2hhcmVkLCBvciBvdGhlcndpc2UgcGVybCBzY3JpcHRzIHdvbid0IGV2ZW4gZmlu
ZCB0aGUgUGVybCBsaWJyYXJ5Lgp1c2VzaHJwbGliPSd0cnVlJwo=',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 1.78

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
