package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '1.30';
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp
bnMuaW5mb25ldC5uZXQ+CiMgRGF0ZTogVGh1LCAyOCBKdWwgMTk5NCAxOToxNzowNSAtMDUwMCAo
Q0RUKQojCiMgQWRkaXRpb25hbCAxLjEuNSBkZWZpbmVzIGZyb20gCiMgT2xsaXZpZXIgUm9iZXJ0
IDxPbGxpdmllci5Sb2JlcnRAa2VsdGlhLmZybXVnLmZyLm5ldD4KIyBEYXRlOiBXZWQsIDI4IFNl
cCAxOTk0IDAwOjM3OjQ2ICswMTAwIChNRVQpCiMKIyBBZGRpdGlvbmFsIDIuKiBkZWZpbmVzIGZy
b20KIyBPbGxpdmllciBSb2JlcnQgPE9sbGl2aWVyLlJvYmVydEBrZWx0aWEuZnJtdWcuZnIubmV0
PgojIERhdGU6IFNhdCwgOCBBcHIgMTk5NSAyMDo1Mzo0MSArMDIwMCAoTUVUIERTVCkKIwojIEFk
ZGl0aW9uYWwgMi4wLjUgYW5kIDIuMSBkZWZpbmVkIGZyb20KIyBPbGxpdmllciBSb2JlcnQgPE9s
bGl2aWVyLlJvYmVydEBrZWx0aWEuZnJtdWcuZnIubmV0PgojIERhdGU6IEZyaSwgMTIgTWF5IDE5
OTUgMTQ6MzA6MzggKzAyMDAgKE1FVCBEU1QpCiMKIyBBZGRpdGlvbmFsIDIuMiBkZWZpbmVzIGZy
b20KIyBNYXJrIE11cnJheSA8bWFya0Bncm9uZGFyLnphPgojIERhdGU6IFdlZCwgNiBOb3YgMTk5
NiAwOTo0NDo1OCArMDIwMCAoTUVUKQojCiMgTW9kaWZpZWQgdG8gZW5zdXJlIHdlIHJlcGxhY2Ug
LWxjIHdpdGggLWxjX3IsIGFuZAojIHRvIHB1dCBpbiBwbGFjZS1ob2xkZXJzIGZvciB2YXJpb3Vz
IHNwZWNpZmljIGhpbnRzLgojIEFuZHkgRG91Z2hlcnR5IDxkb3VnaGVyYUBsYWZheWV0dGUuZWR1
PgojIERhdGU6IFR1ZSBNYXIgMTAgMTY6MDc6MDAgRVNUIDE5OTgKIwojIFN1cHBvcnQgZm9yIEZy
ZWVCU0QvRUxGCiMgT2xsaXZpZXIgUm9iZXJ0IDxyb2JlcnRvQGtlbHRpYS5mcmVlbml4LmZyPgoj
IERhdGU6IFdlZCBTZXAgIDIgMTY6MjI6MTIgQ0VTVCAxOTk4CiMKIyBUaGUgdHdvIGZsYWdzICIt
ZnBpYyAtRFBJQyIgYXJlIHVzZWQgdG8gaW5kaWNhdGUgYQojIHdpbGwtYmUtc2hhcmVkIG9iamVj
dC4gIENvbmZpZ3VyZSB3aWxsIGd1ZXNzIHRoZSAtZnBpYywgKGFuZCB0aGUKIyAtRFBJQyBpcyBu
b3QgdXNlZCBieSBwZXJsIHByb3BlcikgYnV0IHRoZSBmdWxsIGRlZmluZSBpcyBpbmNsdWRlZCB0
byAKIyBiZSBjb25zaXN0ZW50IHdpdGggdGhlIEZyZWVCU0QgZ2VuZXJhbCBzaGFyZWQgbGlicyBi
dWlsZGluZyBwcm9jZXNzLgojCiMgc2V0cmV1aWQgYW5kIGZyaWVuZHMgYXJlIGluaGVyZW50bHkg
YnJva2VuIGluIGFsbCB2ZXJzaW9ucyBvZiBGcmVlQlNECiMgYmVmb3JlIDIuMS1jdXJyZW50IChi
ZWZvcmUgYXBwcm94IGRhdGUgNC8xNS85NSkuIEl0IGlzIGZpeGVkIGluIDIuMC41CiMgYW5kIHdo
YXQtd2lsbC1iZS0yLjEKIwoKY2FzZSAiJG9zdmVycyIgaW4KMC4qfDEuMCopCgl1c2VkbD0iJHVu
ZGVmIgoJOzsKMS4xKikKCW1hbGxvY3R5cGU9J3ZvaWQgKicKCWdyb3Vwc3R5cGU9J2ludCcKCWRf
c2V0cmVnaWQ9J3VuZGVmJwoJZF9zZXRyZXVpZD0ndW5kZWYnCglkX3NldHJnaWQ9J3VuZGVmJwoJ
ZF9zZXRydWlkPSd1bmRlZicKCTs7CjIuMC1yZWxlYXNlKikKCWRfc2V0cmVnaWQ9J3VuZGVmJwoJ
ZF9zZXRyZXVpZD0ndW5kZWYnCglkX3NldHJnaWQ9J3VuZGVmJwoJZF9zZXRydWlkPSd1bmRlZicK
CTs7CiMKIyBUcnlpbmcgdG8gY292ZXIgMi4wLjUsIDIuMS1jdXJyZW50IGFuZCBmdXR1cmUgMi4x
LzIuMgojIEl0IGRvZXMgbm90IGNvdmVydCBhbGwgMi4xLWN1cnJlbnQgdmVyc2lvbnMgYXMgdGhl
IG91dHB1dCBvZiB1bmFtZQojIGNoYW5nZWQgYSBmZXcgdGltZXMuCiMKIyBFdmVuIHRob3VnaCBz
ZXRldWlkL3NldGVnaWQgYXJlIGF2YWlsYWJsZSwgdGhleSd2ZSBiZWVuIHR1cm5lZCBvZmYKIyBi
ZWNhdXNlIHBlcmwgaXNuJ3QgY29kZWQgd2l0aCBzYXZlZCBzZXRbdWddaWQgdmFyaWFibGVzIGlu
IG1pbmQuCiMgSW4gYWRkaXRpb24sIGEgc21hbGwgcGF0Y2ggaXMgcmVxdWlyZWQgdG8gc3VpZHBl
cmwgdG8gYXZvaWQgYSBzZWN1cml0eQojIHByb2JsZW0gd2l0aCBGcmVlQlNELgojCjIuMC41Knwy
LjAtYnVpbHQqfDIuMSopCiAJdXNldmZvcms9J3RydWUnCgljYXNlICIkdXNlbXltYWxsb2MiIGlu
CgkgICAgIiIpIHVzZW15bWFsbG9jPSduJwoJICAgICAgICA7OwoJZXNhYwoJZF9zZXRyZWdpZD0n
ZGVmaW5lJwoJZF9zZXRyZXVpZD0nZGVmaW5lJwoJZF9zZXRlZ2lkPSd1bmRlZicKCWRfc2V0ZXVp
ZD0ndW5kZWYnCgl0ZXN0IC1yIC4vYnJva2VuLWRiLm1zZyAmJiAuIC4vYnJva2VuLWRiLm1zZwoJ
OzsKIwojIDIuMiBhbmQgYWJvdmUgaGF2ZSBwaGttYWxsb2MoMykuCiMgZG9uJ3QgdXNlIC1sbWFs
bG9jIChtYXliZSB0aGVyZSdzIGFuIG9sZCBvbmUgZnJvbSAxLjEuNS4xIGZsb2F0aW5nIGFyb3Vu
ZCkKMi4yKikKIAl1c2V2Zm9yaz0ndHJ1ZScKCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4KCSAgICAi
IikgdXNlbXltYWxsb2M9J24nCgkgICAgICAgIDs7Cgllc2FjCglsaWJzd2FudGVkPWBlY2hvICRs
aWJzd2FudGVkIHwgc2VkICdzLyBtYWxsb2MgLyAvJ2AKCWxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3
YW50ZWQgfCBzZWQgJ3MvIGJpbmQgLyAvJ2AKCSMgaWNvbnYgZ29uZSBpbiBQZXJsIDUuOC4xLCBi
dXQgaWYgc29tZW9uZSBjb21waWxlcyA1LjguMCBvciBlYXJsaWVyLgoJbGlic3dhbnRlZD1gZWNo
byAkbGlic3dhbnRlZCB8IHNlZCAncy8gaWNvbnYgLyAvJ2AKCWRfc2V0cmVnaWQ9J2RlZmluZScK
CWRfc2V0cmV1aWQ9J2RlZmluZScKCWRfc2V0ZWdpZD0nZGVmaW5lJwoJZF9zZXRldWlkPSdkZWZp
bmUnCgkjIGRfZG9zdWlkPSdkZWZpbmUnICMgT2Jzb2xldGUuCgk7OwoqKQl1c2V2Zm9yaz0ndHJ1
ZScKCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4KCSAgICAiIikgdXNlbXltYWxsb2M9J24nCgkgICAg
ICAgIDs7Cgllc2FjCglsaWJzd2FudGVkPWBlY2hvICRsaWJzd2FudGVkIHwgc2VkICdzLyBtYWxs
b2MgLyAvJ2AKCTs7CmVzYWMKCiMgRHluYW1pYyBMb2FkaW5nIGZsYWdzIGhhdmUgbm90IGNoYW5n
ZWQgbXVjaCwgc28gdGhleSBhcmUgc2VwYXJhdGVkCiMgb3V0IGhlcmUgdG8gYXZvaWQgZHVwbGlj
YXRpbmcgdGhlbSBldmVyeXdoZXJlLgpjYXNlICIkb3N2ZXJzIiBpbgowLip8MS4wKikgOzsKCjEu
KnwyLiopCgljY2NkbGZsYWdzPSctRFBJQyAtZnBpYycKCWxkZGxmbGFncz0iLUJzaGFyZWFibGUg
JGxkZGxmbGFncyIKCTs7CgozKnw0Knw1Knw2KikKICAgICAgICBvYmpmb3JtYXQ9YC91c3IvYmlu
L29iamZvcm1hdGAKICAgICAgICBpZiBbIHgkb2JqZm9ybWF0ID0geGFvdXQgXTsgdGhlbgogICAg
ICAgICAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhlbgogICAgICAgICAgICAgICAgbGli
cHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgogICAgICAgICAgICAg
ICAgZ2xpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIKICAgICAg
ICAgICAgZmkKICAgICAgICAgICAgbGRkbGZsYWdzPSctQnNoYXJlYWJsZScKICAgICAgICBlbHNl
CiAgICAgICAgICAgIGxpYnB0aD0iL3Vzci9saWIgL3Vzci9sb2NhbC9saWIiCiAgICAgICAgICAg
IGdsaWJwdGg9Ii91c3IvbGliIC91c3IvbG9jYWwvbGliIgogICAgICAgICAgICBsZGZsYWdzPSIt
V2wsLUUgIgogICAgICAgICAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgogICAgICAgIGZpCiAgICAg
ICAgY2NjZGxmbGFncz0nLURQSUMgLWZQSUMnCiAgICAgICAgOzsKKikKICAgICAgIGxpYnB0aD0i
L3Vzci9saWIgL3Vzci9sb2NhbC9saWIiCiAgICAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xv
Y2FsL2xpYiIKICAgICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICAgICAgbGRkbGZsYWdzPSItc2hh
cmVkICIKICAgICAgICBjY2NkbGZsYWdzPSctRFBJQyAtZlBJQycKICAgICAgIDs7CmVzYWMKCmNh
c2UgIiRvc3ZlcnMiIGluCjAuKnwxLip8Mi4qfDMuKikgOzsKCiopCgljY2ZsYWdzPSIke2NjZmxh
Z3N9IC1ESEFTX0ZQU0VUTUFTSyAtREhBU19GTE9BVElOR1BPSU5UX0giCglpZiAvdXNyL2Jpbi9m
aWxlIC1MIC91c3IvbGliL2xpYmMuc28gfCAvdXNyL2Jpbi9ncmVwIC12cSAibm90IHN0cmlwcGVk
IiA7IHRoZW4KCSAgICB1c2VubT1mYWxzZQoJZmkKICAgICAgICA7Owplc2FjCgpjYXQgPDwnRU9N
JyA+JjQKClNvbWUgdXNlcnMgaGF2ZSByZXBvcnRlZCB0aGF0IENvbmZpZ3VyZSBoYWx0cyB3aGVu
IHRlc3RpbmcgZm9yCnRoZSBPX05PTkJMT0NLIHN5bWJvbCB3aXRoIGEgc3ludGF4IGVycm9yLiAg
VGhpcyBpcyBhcHBhcmVudGx5IGEKc2ggZXJyb3IuICBSZXJ1bm5pbmcgQ29uZmlndXJlIHdpdGgg
a3NoIGFwcGFyZW50bHkgZml4ZXMgdGhlCnByb2JsZW0uICBUcnkKCWtzaCBDb25maWd1cmUgW3lv
dXIgb3B0aW9uc10KCkVPTQoKIyBGcm9tOiBBbnRvbiBCZXJlemluIDx0b2JlekBwbGFiLmt1LmRr
PgojIFRvOiBwZXJsNS1wb3J0ZXJzQHBlcmwub3JnCiMgU3ViamVjdDogW1BBVENIIDUuMDA1XzU0
XSBDb25maWd1cmUgLSBoaW50cy9mcmVlYnNkLnNoIHNpZ25hbCBoYW5kbGVyIHR5cGUKIyBEYXRl
OiAzMCBOb3YgMTk5OCAxOTo0NjoyNCArMDEwMAojIE1lc3NhZ2UtSUQ6IDw4NjRzcmhodmN2LmZz
ZkBsaW9uLnBsYWIua3UuZGs+CgpzaWduYWxfdD0ndm9pZCcKZF92b2lkc2lnPSdkZWZpbmUnCgoj
IHNldCBsaWJwZXJsLnNvLlguWCBmb3IgMi4yLlgKY2FzZSAiJG9zdmVycyIgaW4KMi4yKikKICAg
ICMgdW5mb3J0dW5hdGVseSB0aGlzIGNvZGUgZ2V0cyBleGVjdXRlZCBiZWZvcmUKICAgICMgdGhl
IGVxdWl2YWxlbnQgaW4gdGhlIG1haW4gQ29uZmlndXJlIHNvIHdlIGNvcHkgYSBsaXR0bGUKICAg
ICMgZnJvbSBDb25maWd1cmUgWFhYIENvbmZpZ3VyZSBzaG91bGQgYmUgZml4ZWQuCiAgICBpZiAk
dGVzdCAtciAkc3JjL3BhdGNobGV2ZWwuaDt0aGVuCiAgICAgICBwYXRjaGxldmVsPWBhd2sgJy9k
ZWZpbmVbIAldK1BFUkxfVkVSU0lPTi8ge3ByaW50ICQzfScgJHNyYy9wYXRjaGxldmVsLmhgCiAg
ICAgICBzdWJ2ZXJzaW9uPWBhd2sgJy9kZWZpbmVbIAldK1BFUkxfU1VCVkVSU0lPTi8ge3ByaW50
ICQzfScgJHNyYy9wYXRjaGxldmVsLmhgCiAgICBlbHNlCiAgICAgICBwYXRjaGxldmVsPTAKICAg
ICAgIHN1YnZlcnNpb249MAogICAgZmkKICAgIGxpYnBlcmw9ImxpYnBlcmwuc28uJHBhdGNobGV2
ZWwuJHN1YnZlcnNpb24iCiAgICB1bnNldCBwYXRjaGxldmVsCiAgICB1bnNldCBzdWJ2ZXJzaW9u
CiAgICA7Owplc2FjCgojIFRoaXMgc2NyaXB0IFVVL3VzZXRocmVhZHMuY2J1IHdpbGwgZ2V0ICdj
YWxsZWQtYmFjaycgYnkgQ29uZmlndXJlIAojIGFmdGVyIGl0IGhhcyBwcm9tcHRlZCB0aGUgdXNl
ciBmb3Igd2hldGhlciB0byB1c2UgdGhyZWFkcy4KY2F0ID4gVVUvdXNldGhyZWFkcy5jYnUgPDwn
RU9DQlUnCmNhc2UgIiR1c2V0aHJlYWRzIiBpbgokZGVmaW5lfHRydWV8W3lZXSopCiAgICAgICAg
bGNfcj1gL3NiaW4vbGRjb25maWcgLXJ8Z3JlcCAnOi1sY19yJ3xhd2sgJ3twcmludCAkTkZ9J3xz
ZWQgLW4gJyRwJ2AKICAgICAgICBjYXNlICIkb3N2ZXJzIiBpbiAgCgkwLip8MS4qfDIuMCp8Mi4x
KikgICBjYXQgPDxFT00gPiY0CkkgZGlkIG5vdCBrbm93IHRoYXQgRnJlZUJTRCAkb3N2ZXJzIHN1
cHBvcnRzIFBPU0lYIHRocmVhZHMuCgpGZWVsIGZyZWUgdG8gdGVsbCBwZXJsYnVnQHBlcmwub3Jn
IG90aGVyd2lzZS4KRU9NCgkgICAgICBleGl0IDEKCSAgICAgIDs7CgogICAgICAgIDIuMi5bMC03
XSopCiAgICAgICAgICAgICAgY2F0IDw8RU9NID4mNApQT1NJWCB0aHJlYWRzIGFyZSBub3Qgc3Vw
cG9ydGVkIHdlbGwgYnkgRnJlZUJTRCAkb3N2ZXJzLgoKUGxlYXNlIGNvbnNpZGVyIHVwZ3JhZGlu
ZyB0byBhdCBsZWFzdCBGcmVlQlNEIDIuMi44LApvciBwcmVmZXJhYmx5IHRvIHRoZSBtb3N0IHJl
Y2VudCAtUkVMRUFTRSBvciAtU1RBQkxFCnZlcnNpb24gKHNlZSBodHRwOi8vd3d3LmZyZWVic2Qu
b3JnL3JlbGVhc2VzLykuCgooV2hpbGUgMi4yLjcgZG9lcyBoYXZlIHB0aHJlYWRzLCBpdCBoYXMg
c29tZSBwcm9ibGVtcwogd2l0aCB0aGUgY29tYmluYXRpb24gb2YgdGhyZWFkcyBhbmQgcGlwZXMg
YW5kIHRoZXJlZm9yZQogbWFueSBQZXJsIHRlc3RzIHdpbGwgZWl0aGVyIGhhbmcgb3IgZmFpbC4p
CkVPTQoJICAgICAgZXhpdCAxCgkgICAgICA7OwoKCVszLTVdLiopCgkgICAgICBpZiBbICEgLXIg
IiRsY19yIiBdOyB0aGVuCgkgICAgICBjYXQgPDxFT00gPiY0ClBPU0lYIHRocmVhZHMgc2hvdWxk
IGJlIHN1cHBvcnRlZCBieSBGcmVlQlNEICRvc3ZlcnMgLS0KYnV0IHlvdXIgc3lzdGVtIGlzIG1p
c3NpbmcgdGhlIHNoYXJlZCBsaWJjX3IuCigvc2Jpbi9sZGNvbmZpZyAtciBkb2Vzbid0IGZpbmQg
YW55KS4KCkNvbnNpZGVyIHVzaW5nIHRoZSBsYXRlc3QgU1RBQkxFIHJlbGVhc2UuCkVPTQoJCSBl
eGl0IDEKCSAgICAgIGZpCgkgICAgICAjIDUwMDAxNiBpcyB0aGUgZmlyc3Qgb3NyZWxkYXRlIGlu
IHdoaWNoIG9uZSBjb3VsZAoJICAgICAgIyBqdXN0IGxpbmsgYWdhaW5zdCBsaWJjX3Igd2l0aG91
dCBkaXNwb3Npbmcgb2YgbGliYwoJICAgICAgIyBhdCB0aGUgc2FtZSB0aW1lLiAgNTAwMDE2IC4u
LiB1cCB0byB3aGF0ZXZlciBpdCB3YXMKCSAgICAgICMgb24gdGhlIDMxc3Qgb2YgQXVndXN0IDIw
MDMgY2FuIHN0aWxsIGJlIHVzZWQgd2l0aCAtcHRocmVhZCwKCSAgICAgICMgYnV0IGl0IGlzIG5v
dCBuZWNlc3NhcnkuCgoJICAgICAgIyBBbnRvbiBCZXJlemluIHNheXMgdGhhdCBwb3N0IDUwMHNv
bWV0aGluZyB3ZSdyZSB3cm9uZyB0byBiZQoJICAgICAgIyB0byBiZSB1c2luZyAtbGNfciwgYW5k
IHNob3VsZCBqdXN0IGJlIHVzaW5nIC1wdGhyZWFkIG9uIHRoZQoJICAgICAgIyBsaW5rZXIgbGlu
ZS4KCSAgICAgICMgU28gcHJlc3VtYWJseSByZWFsbHkgd2Ugc2hvdWxkIGJlIGNoZWNraW5nIHRo
YXQgJG9zdmVyIGlzIDUuKikKCSAgICAgICMgYW5kIHRoYXQgYC9zYmluL3N5c2N0bCAtbiBrZXJu
Lm9zcmVsZGF0ZWAgLWdlIDUwMDAxNgoJICAgICAgIyBvciAtbHQgNTAwc29tZXRoaW5nIGFuZCBv
bmx5IGluIHRoYXQgcmFuZ2Ugbm90IGRvaW5nIHRoaXM6CgkgICAgICBsZGZsYWdzPSItcHRocmVh
ZCAkbGRmbGFncyIKCgkgICAgICAjIEJvdGggaW4gNC54IGFuZCA1LnggZ2V0aG9zdGJ5YWRkcl9y
IGV4aXN0cyBidXQKCSAgICAgICMgaXQgaXMgIlRlbXBvcmFyeSBmdW5jdGlvbiwgbm90IHRocmVh
ZHNhZmUiLi4uCgkgICAgICAjIFByZXN1bWFibHkgZWFybGllciBpdCBkaWRuJ3QgZXZlbiBleGlz
dC4KCSAgICAgIGRfZ2V0aG9zdGJ5YWRkcl9yPSJ1bmRlZiIKCSAgICAgIGRfZ2V0aG9zdGJ5YWRk
cl9yX3Byb3RvPSIwIgoJICAgICAgOzsKCgkqKQoJICAgICAgIyA3LnggZG9lc24ndCBpbnN0YWxs
IGxpYmNfciBieSBkZWZhdWx0LCBhbmQgQ29uZmlndXJlCgkgICAgICAjIHdvdWxkIGZhaWwgaW4g
dGhlIGNvZGUgZm9sbG93aW5nCgkgICAgICAjCgkgICAgICAjIGdldGhvc3RieWFkZHJfcigpIGFw
cGVhcnMgdG8gaGF2ZSBiZWVuIGltcGxlbWVudGVkIGluIDYueCsKCSAgICAgIGxkZmxhZ3M9Ii1w
dGhyZWFkICRsZGZsYWdzIgoJICAgICAgOzsKCgllc2FjCgogICAgICAgIGNhc2UgIiRvc3ZlcnMi
IGluCiAgICAgICAgWzEtNF0qKQoJICAgIHNldCBgZWNobyBYICIkbGlic3dhbnRlZCAifCBzZWQg
LWUgJ3MvIGMgLyBjX3IgLydgCgkgICAgc2hpZnQKCSAgICBsaWJzd2FudGVkPSIkKiIKCSAgICA7
OwogICAgICAgICopCgkgICAgc2V0IGBlY2hvIFggIiRsaWJzd2FudGVkICJ8IHNlZCAtZSAncy8g
YyAvLydgCgkgICAgc2hpZnQKCSAgICBsaWJzd2FudGVkPSIkKiIKCSAgICA7OwoJZXNhYwoJICAg
IAoJIyBDb25maWd1cmUgd2lsbCBwcm9iYWJseSBwaWNrIHRoZSB3cm9uZyBsaWJjIHRvIHVzZSBm
b3Igbm0gc2Nhbi4KCSMgVGhlIHNhZmVzdCBxdWljay1maXggaXMganVzdCB0byBub3QgdXNlIG5t
IGF0IGFsbC4uLgoJdXNlbm09ZmFsc2UKCiAgICAgICAgY2FzZSAiJG9zdmVycyIgaW4KICAgICAg
ICAyLjIuOCopCiAgICAgICAgICAgICMgLi4uIGJ1dCB0aGlzIGRvZXMgbm90IGFwcGx5IGZvciAy
LjIuOCAtIHdlIGtub3cgaXQncyBzYWZlCiAgICAgICAgICAgIGxpYmM9IiRsY19yIgogICAgICAg
ICAgICB1c2VubT10cnVlCiAgICAgICAgICAgOzsKICAgICAgICBlc2FjCgogICAgICAgIHVuc2V0
IGxjX3IKCgkjIEV2ZW4gd2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRv
ZXMgbm90CgkjIHNlZW0gdG8gYmUgdGhyZWFkc2FmZSBpbiBGcmVlQlNEPwoJY2FzZSAiJHVzZW15
bWFsbG9jIiBpbgoJJycpIHVzZW15bWFsbG9jPW4gOzsKCWVzYWMKZXNhYwpFT0NCVQoKIyBtYWxs
b2Mgd3JhcCB3b3JrcwpjYXNlICIkdXNlbWFsbG9jd3JhcCIgaW4KJycpIHVzZW1hbGxvY3dyYXA9
J2RlZmluZScgOzsKZXNhYwoKIyBYWFggVW5kZXIgRnJlZUJTRCA2LjAgKGFuZCBwcm9iYWJseSBt
b3N0IG90aGVyIHNpbWlsYXIgdmVyc2lvbnMpCiMgUGVybF9kaWUoTlVMTCkgZ2VuZXJhdGVzIGEg
d2FybmluZzoKIyAgICBwcF9zeXMuYzo0OTE6IHdhcm5pbmc6IG51bGwgZm9ybWF0IHN0cmluZwoj
IENvbmZpZ3VyZSBzdXBwb3NlZGVseSB0ZXN0cyBmb3IgdGhpcywgYnV0IGFwcGFyZW50bHkgdGhl
IHRlc3QgZG9lc24ndAojIHdvcmsuICBWb2x1bnRlZXJzIHdpdGggRnJlZUJTRCBhcmUgbmVlZGVk
IHRvIGltcHJvdmluZyB0aGUgQ29uZmlndXJlIHRlc3QuCiMgTWVhbndoaWxlLCB0aGUgZm9sbG93
aW5nIHdvcmthcm91bmQgc2hvdWxkIGJlIHNhZmUgb24gYWxsIHZlcnNpb25zCiMgb2YgRnJlZUJT
RC4KZF9wcmludGZfZm9ybWF0X251bGw9J3VuZGVmJwo=',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBMYXN0IG1vZGlmaWVkOiBUaHUgRGVjIDEwIDIwOjQ3OjI4IENFVCAx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',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv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',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 1.30

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
