# Copyright (C) 2002 Rob Brown (bbb@cpan.org)
# default rpm SPEC file generator

use strict;

my $output = $0;
my $p = $1 if $output =~ m%([^/]*)$%;
$output =~ s/\.PL$//;

unless (do "./lib/Net/DNAT.pm") {
  die $@ if $@;
  die "./lib/Net/DNAT.pm: $!";
}

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Net::DNAT::VERSION/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC "# Automatically generated by $p\n";
print SPEC;
close SPEC;

__DATA__
%define perlmod Net-DNAT
Summary:	%{perlmod} perl module
Name:		perl-%{perlmod}
Version:	@VERSION@
Release:	1
License:	GPL
Group:		Development/Languages/Perl
Source0:	http://www.cpan.org./authors/id/B/BB/BBB/%{perlmod}-%{version}.tar.gz
Packager:	Rob Brown <bbb@cpan.org>
Prefix: 	/usr
BuildRequires:	perl
Requires:	perl
BuildRoot:	/var/tmp/%{name}-%{version}-root
Provides:	%{perlmod}

%description
%{perlmod} Perl Module

%prep
%setup -q -n %{perlmod}-%{version}

%build
perl Makefile.PL
make
make test

%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT%{prefix} install
find $RPM_BUILD_ROOT%{prefix} -type f -print | perl -p -e "s@^$RPM_BUILD_ROOT(.*)@\$1*@g" | grep -v perllocal.pod | grep -v packlist > %{name}-filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-filelist
%defattr(-,root,root)

%post

%changelog
* Sat Apr 06 2002 Rob Brown <bbb@cpan.org>
- initial creation
