/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSelect
extends HtmlElement
implements DisabledElement,
SubmittableElement,
FormFieldWithNameHistory {
    public static final String TAG_NAME = "select";
    private String originalName_;
    private Collection<String> previousNames_ = Collections.emptySet();

    HtmlSelect(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        List<HtmlOption> options;
        int size;
        try {
            size = Integer.parseInt(this.getSizeAttribute());
            if (size < 0) {
                this.removeAttribute("size");
                size = 0;
            }
        }
        catch (NumberFormatException e) {
            this.removeAttribute("size");
            size = 0;
        }
        if (this.getSelectedOptions().isEmpty() && size <= 1 && !this.isMultipleSelectEnabled() && !(options = this.getOptions()).isEmpty()) {
            HtmlOption first = options.get(0);
            first.setSelectedInternal(true);
        }
    }

    public List<HtmlOption> getSelectedOptions() {
        ArrayList<HtmlOption> result;
        if (this.isMultipleSelectEnabled()) {
            result = new ArrayList<HtmlOption>();
            for (HtmlElement element : this.getHtmlElementDescendants()) {
                if (!(element instanceof HtmlOption) || !((HtmlOption)element).isSelected()) continue;
                result.add((HtmlOption)element);
            }
        } else {
            result = new ArrayList(1);
            HtmlOption lastSelected = null;
            for (HtmlElement element : this.getHtmlElementDescendants()) {
                HtmlOption option;
                if (!(element instanceof HtmlOption) || !(option = (HtmlOption)element).isSelected()) continue;
                lastSelected = option;
            }
            if (lastSelected != null) {
                result.add(lastSelected);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<HtmlOption> getOptions() {
        return Collections.unmodifiableList(this.getHtmlElementsByTagName("option"));
    }

    public HtmlOption getOption(int index) {
        return (HtmlOption)this.getHtmlElementsByTagName("option").get(index);
    }

    public int getOptionSize() {
        return this.getHtmlElementsByTagName("option").size();
    }

    public void setOptionSize(int newLength) {
        List elementList = this.getHtmlElementsByTagName("option");
        for (int i = elementList.size() - 1; i >= newLength; --i) {
            ((HtmlElement)elementList.get(i)).remove();
        }
    }

    public void removeOption(int index) {
        HtmlElement.ChildElementsIterator iterator = new HtmlElement.ChildElementsIterator();
        int i = 0;
        while (iterator.hasNext()) {
            HtmlElement element = iterator.nextElement();
            if (!(element instanceof HtmlOption)) continue;
            if (i == index) {
                element.remove();
                return;
            }
            ++i;
        }
    }

    public void replaceOption(int index, HtmlOption newOption) {
        HtmlElement.ChildElementsIterator iterator = new HtmlElement.ChildElementsIterator();
        int i = 0;
        while (iterator.hasNext()) {
            HtmlElement element = iterator.nextElement();
            if (!(element instanceof HtmlOption)) continue;
            if (i == index) {
                element.replace(newOption);
                return;
            }
            ++i;
        }
        if (newOption.isSelected()) {
            this.setSelectedAttribute(newOption, true);
        }
    }

    public void appendOption(HtmlOption newOption) {
        this.appendChild(newOption);
    }

    @Override
    public DomNode appendChild(Node node) {
        HtmlOption option;
        DomNode response = super.appendChild(node);
        if (node instanceof HtmlOption && (option = (HtmlOption)node).isSelected()) {
            this.doSelectOption(option, true);
        }
        return response;
    }

    public <P extends Page> P setSelectedAttribute(String optionValue, boolean isSelected) {
        try {
            return this.setSelectedAttribute(this.getOptionByValue(optionValue), isSelected);
        }
        catch (ElementNotFoundException e) {
            if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.SELECT_DESELECT_ALL_IF_SWITCHING_UNKNOWN)) {
                for (HtmlOption o : this.getSelectedOptions()) {
                    o.setSelected(false);
                }
            }
            return (P)this.getPage();
        }
    }

    public <P extends Page> P setSelectedAttribute(HtmlOption selectedOption, boolean isSelected) {
        return this.setSelectedAttribute(selectedOption, isSelected, true);
    }

    public <P extends Page> P setSelectedAttribute(HtmlOption selectedOption, boolean isSelected, boolean invokeOnFocus) {
        boolean changeSelectedState;
        if (isSelected && invokeOnFocus) {
            ((HtmlPage)this.getPage()).setFocusedElement(this);
        }
        boolean bl = changeSelectedState = selectedOption.isSelected() != isSelected;
        if (changeSelectedState) {
            this.doSelectOption(selectedOption, isSelected);
            HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        }
        return (P)this.getPage().getWebClient().getCurrentWindow().getEnclosedPage();
    }

    private void doSelectOption(HtmlOption selectedOption, boolean isSelected) {
        if (this.isMultipleSelectEnabled()) {
            selectedOption.setSelectedInternal(isSelected);
        } else {
            for (HtmlOption option : this.getOptions()) {
                option.setSelectedInternal(option == selectedOption && isSelected);
            }
        }
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String name = this.getNameAttribute();
        List<HtmlOption> selectedOptions = this.getSelectedOptions();
        NameValuePair[] pairs = new NameValuePair[selectedOptions.size()];
        int i = 0;
        for (HtmlOption option : selectedOptions) {
            pairs[i++] = new NameValuePair(name, option.getValueAttribute());
        }
        return pairs;
    }

    boolean isValidForSubmission() {
        return this.getOptionSize() > 0;
    }

    @Override
    public void reset() {
        for (HtmlOption option : this.getOptions()) {
            option.reset();
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setSelectedAttribute(defaultValue, true);
    }

    @Override
    public String getDefaultValue() {
        List<HtmlOption> options = this.getSelectedOptions();
        if (options.size() > 0) {
            return options.get(0).getValueAttribute();
        }
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public boolean isMultipleSelectEnabled() {
        return this.getAttribute("multiple") != ATTRIBUTE_NOT_DEFINED;
    }

    public HtmlOption getOptionByValue(String value) throws ElementNotFoundException {
        WebAssert.notNull("value", value);
        for (HtmlOption option : this.getOptions()) {
            if (!option.getValueAttribute().equals(value)) continue;
            return option;
        }
        throw new ElementNotFoundException("option", "value", value);
    }

    public HtmlOption getOptionByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlOption option : this.getOptions()) {
            if (!option.getText().equals(text)) continue;
            return option;
        }
        throw new ElementNotFoundException("option", "text", text);
    }

    @Override
    public String asText() {
        List<HtmlOption> options = this.isMultipleSelectEnabled() ? this.getOptions() : this.getSelectedOptions();
        StringBuilder buffer = new StringBuilder();
        Iterator<HtmlOption> i = options.iterator();
        while (i.hasNext()) {
            HtmlOption currentOption = i.next();
            if (currentOption != null) {
                buffer.append(currentOption.asText());
            }
            if (!i.hasNext()) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getSizeAttribute() {
        return this.getAttribute("size");
    }

    public final String getMultipleAttribute() {
        return this.getAttribute("multiple");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getOnChangeAttribute() {
        return this.getAttribute("onchange");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("name".equals(qualifiedName)) {
            if (this.previousNames_.isEmpty()) {
                this.previousNames_ = new HashSet<String>();
            }
            this.previousNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getPreviousNames() {
        return this.previousNames_;
    }
}

