/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSFontFaceRuleImpl
extends AbstractCSSRuleImpl
implements CSSFontFaceRule,
Serializable {
    private static final long serialVersionUID = -3604191834588759088L;
    private CSSStyleDeclarationImpl style = null;

    public CSSFontFaceRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule) {
        super(parentStyleSheet, parentRule);
    }

    public CSSFontFaceRuleImpl() {
    }

    public short getType() {
        return 5;
    }

    public String getCssText() {
        return "@font-face {" + this.getStyle().getCssText() + "}";
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 5) {
                throw new DOMExceptionImpl(13, 8);
            }
            this.style = ((CSSFontFaceRuleImpl)r).style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style = style;
    }
}

