/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.Namespace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang.StringUtils;

public class NamespaceCollection
extends SimpleScriptable {
    private static final long serialVersionUID = 3414897723813218653L;
    private final HTMLDocument doc_;
    private final List<Namespace> namespaces_;

    public NamespaceCollection() {
        this.doc_ = null;
        this.namespaces_ = new ArrayList<Namespace>();
    }

    public NamespaceCollection(HTMLDocument doc) {
        this.doc_ = doc;
        this.namespaces_ = new ArrayList<Namespace>();
        this.setParentScope(doc);
        this.setPrototype(this.getPrototype(this.getClass()));
        Map<String, String> namespacesMap = this.doc_.getHtmlPage().getNamespaces();
        for (String key : namespacesMap.keySet()) {
            if (key.length() == 0) continue;
            this.namespaces_.add(new Namespace(this.doc_, key, namespacesMap.get(key)));
        }
    }

    public final Namespace jsxFunction_add(String namespace, String urn, String url) {
        Namespace n = new Namespace(this.doc_, namespace, urn);
        this.namespaces_.add(n);
        return n;
    }

    public final int jsxGet_length() {
        return this.namespaces_.size();
    }

    public final Object jsxFunction_item(Object index) {
        if (index instanceof Number) {
            Number n = (Number)index;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(index);
        return this.get(key, (Scriptable)this);
    }

    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.namespaces_.size()) {
            return this.namespaces_.get(index);
        }
        return super.get(index, start);
    }

    public Object get(String name, Scriptable start) {
        for (Namespace n : this.namespaces_) {
            if (!StringUtils.equals((String)n.jsxGet_name(), (String)name)) continue;
            return n;
        }
        return super.get(name, start);
    }
}

