# ABSTRACT: A Generic Class Famework for Perl 5
package Data::Object::Class;

use 5.010;
use parent 'Moo';

our $VERSION = '0.33'; # VERSION

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Object::Class - A Generic Class Famework for Perl 5

=head1 VERSION

version 0.33

=head1 SYNOPSIS

    package Person;

    use Data::Object::Class;

    extends 'Entity';
    with    'Identity';

    has firstname => ( is => 'ro' );
    has lastname  => ( is => 'ro' );

    1;

=head1 DESCRIPTION

Data::Object::Class inherits all methods and behaviour from L<Moo>. Please see
that documentation for more usage information. Additionally, see
L<Data::Object::Class::Syntax> which provides a DSL that makes declaring
classes easier and more fun.

=head1 AUTHOR

Al Newkirk <anewkirk@ana.io>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Al Newkirk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
