use Test::More;
use Bubblegum::Syntax;

my @typelib = qw(
    aref arrayref bool boolean class classname cref coderef def defined fh
    filehandle glob globref href hashref int integer num number obj object ref
    reference rref regexpref sref scalarref str string nil null undef undefined
    val value
);
{
    package isas;
    use Bubblegum::Syntax -isas;
    use Test::More;
    my @exports = map "isa_$_", @typelib;
    can_ok 'isas', $_ for @exports;
    ok isa_aref [];
    ok !isa_aref '';
    ok isa_arrayref [];
    ok !isa_arrayref '';
    ok isa_bool 1;
    ok isa_bool 0;
    ok isa_bool '';
    ok isa_bool undef;
    ok !isa_bool 100;
    ok isa_boolean 1;
    ok isa_boolean 0;
    ok isa_boolean '';
    ok isa_boolean undef;
    ok !isa_boolean 100;
    ok isa_class 'Test::More';
    ok !isa_class 'Acme::Widget';
    ok isa_classname 'Test::More';
    ok !isa_classname 'Acme::Widget';
    ok isa_cref sub {};
    ok !isa_cref undef;
    ok isa_coderef sub {};
    ok !isa_coderef undef;
    ok isa_def '';
    ok isa_def 0;
    ok !isa_def undef;
    ok isa_defined '';
    ok isa_defined 0;
    ok !isa_defined undef;
    ok isa_fh do { open my $fh, '<', '/'; $fh };
    ok !isa_fh \'';
    ok isa_filehandle do { open my $fh, '<', '/'; $fh };
    ok !isa_filehandle \'';
    ok isa_glob \*Test::More::EXPORT;
    ok !isa_glob \'';
    ok isa_globref \*Test::More::EXPORT;
    ok !isa_globref \'';
    ok isa_href {};
    ok !isa_href \'';
    ok isa_hashref {};
    ok !isa_hashref \'';
    ok isa_int 12345;
    ok !isa_int 123.45;
    ok isa_integer 12345;
    ok !isa_integer 123.45;
    ok isa_num 12345;
    ok isa_num 123.45;
    ok isa_num 0;
    ok !isa_num '';
    ok isa_number 12345;
    ok isa_number 123.45;
    ok isa_number 0;
    ok !isa_number '';
    ok isa_obj bless {}, main;
    ok !isa_obj {};
    ok isa_object bless {}, main;
    ok !isa_object {};
    ok isa_ref \'';
    ok isa_ref {};
    ok isa_ref [];
    ok !isa_ref '';
    ok isa_reference \'';
    ok isa_reference {};
    ok isa_reference [];
    ok !isa_reference '';
    ok isa_rref qr//;
    ok !isa_rref \'';
    ok isa_regexpref qr//;
    ok !isa_regexpref \'';
    ok isa_sref \'';
    ok !isa_sref {};
    ok !isa_sref '';
    ok isa_scalarref \'';
    ok !isa_scalarref {};
    ok !isa_scalarref '';
    ok isa_str '';
    ok isa_str 0;
    ok !isa_str undef;
    ok isa_string '';
    ok isa_string 0;
    ok !isa_string undef;
    ok isa_nil undef;
    ok !isa_nil '';
    ok !isa_nil 0;
    ok isa_null undef;
    ok !isa_null '';
    ok !isa_null 0;
    ok isa_undef undef;
    ok !isa_undef '';
    ok !isa_undef 0;
    ok isa_undefined undef;
    ok !isa_undefined '';
    ok !isa_undefined 0;
}
{
    package nots;
    use Bubblegum::Syntax -nots;
    use Test::More;
    my @exports = map "not_$_", @typelib;
    can_ok 'nots', $_ for @exports;
    ok !not_aref [];
    ok not_aref '';
    ok !not_arrayref [];
    ok not_arrayref '';
    ok !not_bool 1;
    ok !not_bool 0;
    ok !not_bool '';
    ok !not_bool undef;
    ok not_bool 100;
    ok !not_boolean 1;
    ok !not_boolean 0;
    ok !not_boolean '';
    ok !not_boolean undef;
    ok not_boolean 100;
    ok !not_class 'Test::More';
    ok not_class 'Acme::Widget';
    ok !not_classname 'Test::More';
    ok not_classname 'Acme::Widget';
    ok !not_cref sub {};
    ok not_cref undef;
    ok !not_coderef sub {};
    ok not_coderef undef;
    ok !not_def '';
    ok !not_def 0;
    ok not_def undef;
    ok !not_defined '';
    ok !not_defined 0;
    ok not_defined undef;
    ok !not_fh do { open my $fh, '<', '/'; $fh };
    ok not_fh \'';
    ok !not_filehandle do { open my $fh, '<', '/'; $fh };
    ok not_filehandle \'';
    ok !not_glob \*Test::More::EXPORT;
    ok not_glob \'';
    ok !not_globref \*Test::More::EXPORT;
    ok not_globref \'';
    ok !not_href {};
    ok not_href \'';
    ok !not_hashref {};
    ok not_hashref \'';
    ok !not_int 12345;
    ok not_int 123.45;
    ok !not_integer 12345;
    ok not_integer 123.45;
    ok !not_num 12345;
    ok !not_num 123.45;
    ok !not_num 0;
    ok not_num '';
    ok !not_number 12345;
    ok !not_number 123.45;
    ok !not_number 0;
    ok not_number '';
    ok !not_obj bless {}, main;
    ok not_obj {};
    ok !not_object bless {}, main;
    ok not_object {};
    ok !not_ref \'';
    ok !not_ref {};
    ok !not_ref [];
    ok not_ref '';
    ok !not_reference \'';
    ok !not_reference {};
    ok !not_reference [];
    ok not_reference '';
    ok !not_rref qr//;
    ok not_rref \'';
    ok !not_regexpref qr//;
    ok not_regexpref \'';
    ok !not_sref \'';
    ok not_sref {};
    ok not_sref '';
    ok !not_scalarref \'';
    ok not_scalarref {};
    ok not_scalarref '';
    ok !not_str '';
    ok !not_str 0;
    ok not_str undef;
    ok !not_string '';
    ok !not_string 0;
    ok not_string undef;
    ok !not_nil undef;
    ok not_nil '';
    ok not_nil 0;
    ok !not_null undef;
    ok not_null '';
    ok not_null 0;
    ok !not_undef undef;
    ok not_undef '';
    ok not_undef 0;
    ok !not_undefined undef;
    ok not_undefined '';
    ok not_undefined 0;
}
{
    package types;
    use Bubblegum::Syntax -types;
    use Test::More;
    my @exports = map "type_$_", @typelib;
    can_ok 'types', $_ for @exports;
    ok type_aref [];
    ok do { eval {type_aref ''}; $@ };
    ok type_arrayref [];
    ok do { eval {type_arrayref ''}; $@ };
    ok defined type_bool 1;
    ok defined type_bool 0;
    ok defined type_bool '';
    ok !type_bool undef;
    ok do { eval {type_bool 100}; $@ };
    ok defined type_boolean 1;
    ok defined type_boolean 0;
    ok defined type_boolean '';
    ok !type_boolean undef;
    ok do { eval {type_boolean 100}; $@ };
    ok type_class 'Test::More';
    ok do { eval {type_class 'Acme::Widget'}; $@ };
    ok type_classname 'Test::More';
    ok do { eval {type_classname 'Acme::Widget'}; $@ };
    ok type_cref sub {};
    ok do { eval {type_cref undef}; $@ };
    ok type_coderef sub {};
    ok do { eval {type_coderef undef}; $@ };
    ok defined type_def '';
    ok defined type_def 0;
    ok do { eval {type_def undef}; $@ };
    ok defined type_defined '';
    ok defined type_defined 0;
    ok do { eval {type_defined undef}; $@ };
    ok type_fh do { open my $fh, '<', '/'; $fh };
    ok do { eval {type_fh \''}; $@ };
    ok type_filehandle do { open my $fh, '<', '/'; $fh };
    ok do { eval {type_filehandle \''}; $@ };
    ok type_glob \*Test::More::EXPORT;
    ok do { eval {type_glob \''}; $@ };
    ok type_globref \*Test::More::EXPORT;
    ok do { eval {type_globref \''}; $@ };
    ok type_href {};
    ok do { eval {type_href \''}; $@ };
    ok type_hashref {};
    ok do { eval {type_hashref \''}; $@ };
    ok type_int 12345;
    ok do { eval {type_int 123.45}; $@ };
    ok type_integer 12345;
    ok do { eval {type_integer 123.45}; $@ };
    ok type_num 12345;
    ok type_num 123.45;
    ok defined type_num 0;
    ok do { eval {type_num ''}; $@ };
    ok type_number 12345;
    ok type_number 123.45;
    ok defined type_number 0;
    ok do { eval {type_number ''}; $@ };
    ok type_obj bless {}, main;
    ok do { eval {type_obj {}}; $@ };
    ok type_object bless {}, main;
    ok do { eval {type_object {}}; $@ };
    ok type_ref \'';
    ok type_ref {};
    ok type_ref [];
    ok do { eval {type_ref ''}; $@ };
    ok type_reference \'';
    ok type_reference {};
    ok type_reference [];
    ok do { eval {type_reference ''}; $@ };
    ok type_rref qr//;
    ok do { eval {type_rref \''}; $@ };
    ok type_regexpref qr//;
    ok do { eval {type_regexpref \''}; $@ };
    ok type_sref \'';
    ok do { eval {type_sref {}}; $@ };
    ok do { eval {type_sref ''}; $@ };
    ok type_scalarref \'';
    ok do { eval {type_scalarref {}}; $@ };
    ok do { eval {type_scalarref ''}; $@ };
    ok defined type_str '';
    ok defined type_str 0;
    ok do { eval {type_str undef}; $@ };
    ok defined type_string '';
    ok defined type_string 0;
    ok do { eval {type_string undef}; $@ };
    ok !type_nil undef;
    ok do { eval {type_nil ''}; $@ };
    ok do { eval {type_nil 0}; $@ };
    ok !type_null undef;
    ok do { eval {type_null ''}; $@ };
    ok do { eval {type_null 0}; $@ };
    ok !type_undef undef;
    ok do { eval {type_undef ''}; $@ };
    ok do { eval {type_undef 0}; $@ };
    ok !type_undefined undef;
    ok do { eval {type_undefined ''}; $@ };
    ok do { eval {type_undefined 0}; $@ };
}
{
    package typesof;
    use Bubblegum::Syntax -typesof;
    use Test::More;
    my @exports = map "typeof_$_", @typelib;
    can_ok 'typesof', $_ for @exports;
    ok 'CODE' eq ref typeof_aref;
    ok 'CODE' eq ref typeof_arrayref;
    ok 'CODE' eq ref typeof_bool;
    ok 'CODE' eq ref typeof_boolean;
    ok 'CODE' eq ref typeof_class;
    ok 'CODE' eq ref typeof_classname;
    ok 'CODE' eq ref typeof_cref;
    ok 'CODE' eq ref typeof_coderef;
    ok 'CODE' eq ref typeof_def;
    ok 'CODE' eq ref typeof_defined;
    ok 'CODE' eq ref typeof_fh;
    ok 'CODE' eq ref typeof_filehandle;
    ok 'CODE' eq ref typeof_glob;
    ok 'CODE' eq ref typeof_globref;
    ok 'CODE' eq ref typeof_href;
    ok 'CODE' eq ref typeof_hashref;
    ok 'CODE' eq ref typeof_int;
    ok 'CODE' eq ref typeof_integer;
    ok 'CODE' eq ref typeof_num;
    ok 'CODE' eq ref typeof_number;
    ok 'CODE' eq ref typeof_obj;
    ok 'CODE' eq ref typeof_object;
    ok 'CODE' eq ref typeof_ref;
    ok 'CODE' eq ref typeof_reference;
    ok 'CODE' eq ref typeof_rref;
    ok 'CODE' eq ref typeof_regexpref;
    ok 'CODE' eq ref typeof_sref;
    ok 'CODE' eq ref typeof_scalarref;
    ok 'CODE' eq ref typeof_str;
    ok 'CODE' eq ref typeof_string;
    ok 'CODE' eq ref typeof_nil;
    ok 'CODE' eq ref typeof_null;
    ok 'CODE' eq ref typeof_undef;
    ok 'CODE' eq ref typeof_undefined;
}
{
    package attrs;
    use Bubblegum::Class;
    use Bubblegum::Syntax -attr, -typesof;
    use Test::More;
    # has [name];
    has 'id';
    # has [name], default;
    has name => sub {'harry'};
    # has type, [name];
    has typeof_str, 'email';
    # has type, [name], default;
    has typeof_bool, employed => sub {1};
    # has (normal interface)
    has position => (
        is       => 'rw',
        required => 1
    );
    ok do { eval {attrs->new}; $@ };
    ok do { eval {attrs->new(email => 12345)}; $@ };
    ok do { eval {attrs->new(employed => 'yes')}; $@ };
    ok !do { eval {attrs->new(position => 'janitor')}; $@ };
    my $attrs = attrs->new(position => 'janitor');
    is $attrs->position, 'janitor';
    is $attrs->employed, 1;
    is $attrs->name, 'harry';
    ok !$attrs->email;
    ok !$attrs->id;
    ok do { eval {$attrs->email(undef)}; $@ };
    ok do { eval {$attrs->name('sally')}; $@ }; # read-only default
    ok do { eval {$attrs->email('root@local')}; $@ }; # read-only default
}
{
    package utils;
    use Bubblegum::Syntax -utils;
    use Test::More;
    can_ok 'utils', 'cwd';
    can_ok 'utils', 'date';
    can_ok 'utils', 'date_epoch';
    can_ok 'utils', 'date_format';
    can_ok 'utils', 'dump';
    can_ok 'utils', 'file';
    can_ok 'utils', 'find';
    can_ok 'utils', 'home';
    can_ok 'utils', 'load';
    can_ok 'utils', 'merge';
    can_ok 'utils', 'path';
    can_ok 'utils', 'quote';
    can_ok 'utils', 'raise';
    can_ok 'utils', 'script';
    can_ok 'utils', 'unquote';
    can_ok 'utils', 'user';
    can_ok 'utils', 'user_info';
    can_ok 'utils', 'which';
    is 'Bubblegum::Exception', ref do { eval {raise 'wtf'}; $@ };
}

done_testing;
