package PROP::SQL::SelectTest;

use strict;
use base qw/Test::Unit::TestCase/;
use PROP::SQL::Select;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    $self->set_statement(new PROP::SQL::Select);

    return $self;
}

sub get_statement {
    my ($self) = @_;
    return $self->{-statement};
}

sub set_statement {
    my ($self, $statement) = @_;
    $self->{-statement} = $statement;
}

sub test_simple {
    my ($self) = @_;

    my $stmt = $self->get_statement();

    $stmt->add_table('foo');

    $stmt->push_field('bar');
    
    $self->assert_equals($stmt->stringify(), 'select bar from foo');
}

sub test_complex {
    my ($self) = @_;

    my $stmt = $self->get_statement();

    $stmt->add_table('baz');
    $stmt->add_table('foo');

    $stmt->push_field('baz.biz');
    $stmt->push_field('foo.bar');

    $stmt->push_conditional_expression('baz.biz > foo.bar');
    $stmt->push_conditional_expression('baz.biz < ?');

    $stmt->push_ordering('baz.biz');

    $self->assert_equals($stmt->stringify,
			 'select baz.biz, foo.bar from baz, foo ' .
			 'where baz.biz > foo.bar and baz.biz < ? ' .
			 'order by baz.biz');
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
