#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebMod::Err.
#
#  WebMod::Err is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Constant.pm,v 1.7 2003/11/03 02:45:28 aspeer Exp $

#
#  Webmod::Err Constants file
#
package WebMod::Err::Constant ;


#  Version Info, must be all one line for MakeMaker, CPAN.
#
$VERSION = eval { require WebMod::Err::VERSION; do $INC{'WebMod/Err/VERSION.pm'}};


#  Compiler Pragma
#
use strict qw(vars);
local $^W=0;


#  Exteral Modules. Use file spec for Win32 platforms
#
use IO::File;
use File::Spec;


#  Var for temp params we need to reuse
#
my %temp;



#  Config hash
#
%_=(

    'linux'	=>	{

	FILE_LOGFILE		  =>  do {

	    $temp{'file_logfile'} =   File::Spec->canonpath('/var/log/errstr.log'),

	},

	LOG_SHORT_PARAM_HR	  =>  {

	    handler		  =>  'WebMod::Log::Syslog',

	    ident		  =>  'warn',

	    facility		  =>  'LOG_LOCAL0',

	    priority		  =>  'LOG_INFO'

	   },


	LOG_LONG_PARAM_HR	  =>  {

	    handler		  =>  'WebMod::Log::File',

	    filename		  =>  $temp{'file_logfile'},

	    mode		  =>  O_WRONLY|O_CREAT|O_APPEND,

	    perms		  =>  0644,


	},


    },


    'MSWin32'	=>	{

	FILE_LOGFILE		  =>  do {

	    $temp{'file_logfile'} =   File::Spec->canonpath(
		File::Spec->catfile($ENV{'windir'}, 'errstr.log')),

	},

	LOG_SHORT_PARAM_HR	  =>  {

	    handler		  =>  'WebMod::Log::Null',


	   },


	LOG_LONG_PARAM_HR	  =>  {

	    handler		  =>  'WebMod::Log::File',

	    filename		  =>  $temp{'file_logfile'},

	    mode		  =>  O_WRONLY|O_CREAT|O_APPEND,

	    perms		  =>  0644,


	},


    },

);


#  Return set appropriate for OS or linux by
#  default
#
return $_{$^O} || $_{'linux'}
