package Geo::Postcodes::NO;

use Geo::Postcodes 0.02;
use base qw(Geo::Postcodes);

# my @ISA = ('Geo::Postcodes', 'Exporter');

use strict;
use warnings;

## Which methods are available ##################################################

my @valid_methods = qw(postcode location borough borough_number county type selection);
  # Used by the 'methods' method.

my %valid_methods;

foreach (@valid_methods)
{
  $valid_methods{$_} = 1;
}

## Exporter #####################################################################

require Exporter;

my %EXPORT_TAGS = ( 'all' => [ qw(legal valid postnr2poststed borough_number_of kommunenr2kommune
  postnr2kommune postnr2fylke kommunenr2fylke postnr2kategori) ] );

my @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

my @EXPORT = qw( );

our $VERSION = '0.02';

## Private Variables ############################################################

my(%location, %borough_number, %borough, %type);

my @counties = (undef,      # 00 
  "STFOLD",                # 01
  "AKERSHUS",               # 02
  "OSLO",                   # 03
  "HEDMARK",                # 04
  "OPPLAND",                # 05
  "BUSKERUD",               # 06
  "VESTFOLD",               # 07
  "TELEMARK",               # 08
  "AUST-AGDER",             # 09
  "VEST-AGDER",             # 10
  "ROGALAND",               # 11
  "HORDALAND",              # 12
  undef,                    # 13
  "SOGN OG FJORDANE",       # 14
  "MRE OG ROMSDAL",        # 15
  "SR-TRNDELAG",          # 16
  "NORD-TRNDELAG",         # 17
  "NORDLAND",               # 18
  "TROMS",                  # 19
  "FINNMARK",               # 20
  "SVALBARD",               # 21
  "JAN MAYEN",              # 22
  "KONTINENTALSOKKELEN"  ); # 23

my %kategorinavn;

$kategorinavn{B} = 'Bde gateadresser og postbokser';
$kategorinavn{F} = 'Flere bruksomrder (felles)';
$kategorinavn{G} = 'Gateadresser';
$kategorinavn{K} = 'Kunde med eget postnummer';
$kategorinavn{P} = 'Postbokser';
$kategorinavn{S} = 'Serviceboks';


## OO Methods ###################################################################

my %borough_number_of;

sub new
{
  my $class    = shift;
  my $postcode = shift;

  return undef unless valid($postcode);

  my $self = bless \(my $dummy), $class;

  $Geo::Postcodes::postcode_of  {$self} = $postcode;
  $Geo::Postcodes::location_of  {$self} = location_of($postcode);
  $Geo::Postcodes::borough_of   {$self} = borough_of ($postcode);
  $Geo::Postcodes::county_of    {$self} = county_of  ($postcode);
  $Geo::Postcodes::type_of      {$self} = type_of    ($postcode);
 #$Geo::Postcodes::owner_of     {$self} = owner_of   ($postcode);
 #$Geo::Postcodes::address_of   {$self} = address_of ($postcode);

  $borough_number_of            {$self} = borough_number_of($postcode);
 #$pab_of                       {$self} = postadressebok_of($postcode);

  # my $super = $class->can("SUPER::new");
  # goto &$super($class, $postcode, $self) if $super;
  # These two lines should make the 5 Geo-lines superfluous.

  return $self;
}

sub DESTROY {
  my $dead_body = $_[0];

  delete $Geo::Postcodes::postcode_of  {$dead_body};
  delete $Geo::Postcodes::location_of  {$dead_body};
  delete $Geo::Postcodes::borough_of   {$dead_body};
  delete $Geo::Postcodes::county_of    {$dead_body};
  delete $Geo::Postcodes::type_of      {$dead_body};
 #delete $Geo::Postcodes::owner_of     {$dead_body};
 #delete $Geo::Postcodes::address_of   {$dead_body};

  delete $borough_number_of            {$dead_body};
 #delete $pab_of                       {$dead_body};

  ## my $super = $dead_body->can("SUPER::DESTROY");
  ## goto &$super if $super;
}

sub borough_number
{
  my $self = shift;
  return $borough_number_of{$self};
}

sub methods
{
  return @valid_methods;
}

sub is_method
{
  my $method = shift;
  $method    = shift if $method =~ /Geo::Postcodes/; # Called on an object.

  return 1 if $valid_methods{$method};
  return 0;
}

## Global Procedures ############################################################

sub legal # Is it a legal code, i.e. something that follows the syntax rule.
{
  my $postcode = shift;
  return 0 unless defined $postcode;
  return 0 unless $postcode =~ /^\d\d\d\d$/;
  return 1;
}

sub valid # Is the code in actual use.
{
  my $postcode = shift;
  return 0 unless legal($postcode);

  return 1 if exists $location{$postcode};
  return 0;
}

sub postcode_of # So that 'selection' does not choke.
{
  my $postcode = shift;
  return $postcode;
}

sub location_of
{
  my $postcode = shift;
  return unless defined $postcode;

  return $location{$postcode} if exists $location{$postcode};
  return;
}

sub borough_number_of
{
  my $postcode = shift;
  return unless defined $postcode;

  exists $borough_number{$postcode} ? $borough_number{$postcode} : undef;
}

sub kommunenr2kommune
{
  my $kommunenr = shift;
  return unless defined $kommunenr;

  exists $borough{$kommunenr} ? $borough{$kommunenr} : undef;
}

sub borough_of
{
  my $postcode    = shift;
  return unless defined $postcode;

  my $kommunenr = borough_number_of($postcode);
  return unless $kommunenr; # Ulovlig kommunenummer.

  return kommunenr2kommune($kommunenr);
}

sub county_of
{
  my $postcode    = shift;
  return unless defined $postcode;

  my $kommunenr = borough_number_of($postcode);
  return unless $kommunenr; # Ulovlig kommunenummer.

  return kommunenr2fylke($kommunenr);
}

sub kommunenr2fylke
{
  my $kommunenr = shift;
  return unless defined $kommunenr;
  return unless exists $borough{$kommunenr};

  $kommunenr =~ /(\d\d)/; # De to frste sifrene.
  my $fylkenr = $1;

  exists $counties[$fylkenr] ? $counties[$fylkenr] : undef;
}

sub type_of
{
  my $postcode    = shift;
  return unless defined $postcode;
  return unless exists $type{$postcode};
  
  my $kategorikode = $type{$postcode};

  return $kategorinavn{$kategorikode} if exists $kategorinavn{$kategorikode};
  return;
}

sub get_postcodes
{
  return keys %location;
}

## Returns a list of postcodes if called as a procedure; Geo::Postcodes::NO::selection(xx => 'yy')
## Returns a list of objects if called as a method;      Geo::Postcodes::NO->selection(xx => 'yy')

sub selection
{
  return Geo::Postcodes::_selection("Geo::Postcodes::NO", \%valid_methods, @_);
}

## bin/update begin
## This data structure was auto generated on Tue Jul 18 18:16:42 2006. Do NOT edit it!

$borough_number{'0001'} = '0301'; $type{'0001'} = 'K'; $location{'0001'} = 'OSLO';
$borough_number{'0010'} = '0301'; $type{'0010'} = 'F'; $location{'0010'} = 'OSLO';
$borough_number{'0014'} = '0301'; $type{'0014'} = 'K'; $location{'0014'} = 'OSLO';
$borough_number{'0015'} = '0301'; $type{'0015'} = 'K'; $location{'0015'} = 'OSLO';
$borough_number{'0016'} = '0301'; $type{'0016'} = 'K'; $location{'0016'} = 'OSLO';
$borough_number{'0017'} = '0301'; $type{'0017'} = 'K'; $location{'0017'} = 'OSLO';
$borough_number{'0018'} = '0301'; $type{'0018'} = 'K'; $location{'0018'} = 'OSLO';
$borough_number{'0020'} = '0301'; $type{'0020'} = 'K'; $location{'0020'} = 'OSLO';
$borough_number{'0021'} = '0301'; $type{'0021'} = 'K'; $location{'0021'} = 'OSLO';
$borough_number{'0022'} = '0301'; $type{'0022'} = 'K'; $location{'0022'} = 'OSLO';
$borough_number{'0023'} = '0301'; $type{'0023'} = 'F'; $location{'0023'} = 'OSLO';
$borough_number{'0024'} = '0301'; $type{'0024'} = 'K'; $location{'0024'} = 'OSLO';
$borough_number{'0025'} = '0301'; $type{'0025'} = 'K'; $location{'0025'} = 'OSLO';
$borough_number{'0026'} = '0301'; $type{'0026'} = 'F'; $location{'0026'} = 'OSLO';
$borough_number{'0027'} = '0301'; $type{'0027'} = 'F'; $location{'0027'} = 'OSLO';
$borough_number{'0028'} = '0301'; $type{'0028'} = 'P'; $location{'0028'} = 'OSLO';
$borough_number{'0030'} = '0301'; $type{'0030'} = 'P'; $location{'0030'} = 'OSLO';
$borough_number{'0031'} = '0301'; $type{'0031'} = 'P'; $location{'0031'} = 'OSLO';
$borough_number{'0032'} = '0301'; $type{'0032'} = 'P'; $location{'0032'} = 'OSLO';
$borough_number{'0033'} = '0301'; $type{'0033'} = 'P'; $location{'0033'} = 'OSLO';
$borough_number{'0034'} = '0301'; $type{'0034'} = 'P'; $location{'0034'} = 'OSLO';
$borough_number{'0037'} = '0301'; $type{'0037'} = 'K'; $location{'0037'} = 'OSLO';
$borough_number{'0040'} = '0301'; $type{'0040'} = 'K'; $location{'0040'} = 'OSLO';
$borough_number{'0041'} = '0301'; $type{'0041'} = 'K'; $location{'0041'} = 'OSLO';
$borough_number{'0042'} = '0301'; $type{'0042'} = 'K'; $location{'0042'} = 'OSLO';
$borough_number{'0043'} = '0301'; $type{'0043'} = 'K'; $location{'0043'} = 'OSLO';
$borough_number{'0045'} = '0301'; $type{'0045'} = 'K'; $location{'0045'} = 'OSLO';
$borough_number{'0046'} = '0301'; $type{'0046'} = 'K'; $location{'0046'} = 'OSLO';
$borough_number{'0047'} = '0301'; $type{'0047'} = 'K'; $location{'0047'} = 'OSLO';
$borough_number{'0048'} = '0301'; $type{'0048'} = 'K'; $location{'0048'} = 'OSLO';
$borough_number{'0050'} = '0301'; $type{'0050'} = 'G'; $location{'0050'} = 'OSLO';
$borough_number{'0051'} = '0301'; $type{'0051'} = 'P'; $location{'0051'} = 'OSLO';
$borough_number{'0055'} = '0301'; $type{'0055'} = 'K'; $location{'0055'} = 'OSLO';
$borough_number{'0080'} = '0301'; $type{'0080'} = 'K'; $location{'0080'} = 'OSLO';
$borough_number{'0081'} = '0301'; $type{'0081'} = 'K'; $location{'0081'} = 'OSLO';
$borough_number{'0101'} = '0301'; $type{'0101'} = 'P'; $location{'0101'} = 'OSLO';
$borough_number{'0102'} = '0301'; $type{'0102'} = 'P'; $location{'0102'} = 'OSLO';
$borough_number{'0103'} = '0301'; $type{'0103'} = 'P'; $location{'0103'} = 'OSLO';
$borough_number{'0104'} = '0301'; $type{'0104'} = 'P'; $location{'0104'} = 'OSLO';
$borough_number{'0105'} = '0301'; $type{'0105'} = 'P'; $location{'0105'} = 'OSLO';
$borough_number{'0106'} = '0301'; $type{'0106'} = 'P'; $location{'0106'} = 'OSLO';
$borough_number{'0107'} = '0301'; $type{'0107'} = 'P'; $location{'0107'} = 'OSLO';
$borough_number{'0110'} = '0301'; $type{'0110'} = 'P'; $location{'0110'} = 'OSLO';
$borough_number{'0111'} = '0301'; $type{'0111'} = 'P'; $location{'0111'} = 'OSLO';
$borough_number{'0112'} = '0301'; $type{'0112'} = 'P'; $location{'0112'} = 'OSLO';
$borough_number{'0113'} = '0301'; $type{'0113'} = 'P'; $location{'0113'} = 'OSLO';
$borough_number{'0114'} = '0301'; $type{'0114'} = 'P'; $location{'0114'} = 'OSLO';
$borough_number{'0115'} = '0301'; $type{'0115'} = 'P'; $location{'0115'} = 'OSLO';
$borough_number{'0116'} = '0301'; $type{'0116'} = 'P'; $location{'0116'} = 'OSLO';
$borough_number{'0117'} = '0301'; $type{'0117'} = 'P'; $location{'0117'} = 'OSLO';
$borough_number{'0118'} = '0301'; $type{'0118'} = 'P'; $location{'0118'} = 'OSLO';
$borough_number{'0119'} = '0301'; $type{'0119'} = 'P'; $location{'0119'} = 'OSLO';
$borough_number{'0120'} = '0301'; $type{'0120'} = 'P'; $location{'0120'} = 'OSLO';
$borough_number{'0121'} = '0301'; $type{'0121'} = 'P'; $location{'0121'} = 'OSLO';
$borough_number{'0122'} = '0301'; $type{'0122'} = 'P'; $location{'0122'} = 'OSLO';
$borough_number{'0123'} = '0301'; $type{'0123'} = 'P'; $location{'0123'} = 'OSLO';
$borough_number{'0124'} = '0301'; $type{'0124'} = 'P'; $location{'0124'} = 'OSLO';
$borough_number{'0125'} = '0301'; $type{'0125'} = 'P'; $location{'0125'} = 'OSLO';
$borough_number{'0128'} = '0301'; $type{'0128'} = 'K'; $location{'0128'} = 'OSLO';
$borough_number{'0129'} = '0301'; $type{'0129'} = 'P'; $location{'0129'} = 'OSLO';
$borough_number{'0130'} = '0301'; $type{'0130'} = 'P'; $location{'0130'} = 'OSLO';
$borough_number{'0131'} = '0301'; $type{'0131'} = 'P'; $location{'0131'} = 'OSLO';
$borough_number{'0133'} = '0301'; $type{'0133'} = 'P'; $location{'0133'} = 'OSLO';
$borough_number{'0134'} = '0301'; $type{'0134'} = 'P'; $location{'0134'} = 'OSLO';
$borough_number{'0135'} = '0301'; $type{'0135'} = 'P'; $location{'0135'} = 'OSLO';
$borough_number{'0136'} = '0301'; $type{'0136'} = 'P'; $location{'0136'} = 'OSLO';
$borough_number{'0137'} = '0301'; $type{'0137'} = 'P'; $location{'0137'} = 'OSLO';
$borough_number{'0138'} = '0301'; $type{'0138'} = 'P'; $location{'0138'} = 'OSLO';
$borough_number{'0139'} = '0301'; $type{'0139'} = 'G'; $location{'0139'} = 'OSLO';
$borough_number{'0150'} = '0301'; $type{'0150'} = 'G'; $location{'0150'} = 'OSLO';
$borough_number{'0151'} = '0301'; $type{'0151'} = 'G'; $location{'0151'} = 'OSLO';
$borough_number{'0152'} = '0301'; $type{'0152'} = 'G'; $location{'0152'} = 'OSLO';
$borough_number{'0153'} = '0301'; $type{'0153'} = 'G'; $location{'0153'} = 'OSLO';
$borough_number{'0154'} = '0301'; $type{'0154'} = 'G'; $location{'0154'} = 'OSLO';
$borough_number{'0155'} = '0301'; $type{'0155'} = 'G'; $location{'0155'} = 'OSLO';
$borough_number{'0157'} = '0301'; $type{'0157'} = 'G'; $location{'0157'} = 'OSLO';
$borough_number{'0158'} = '0301'; $type{'0158'} = 'G'; $location{'0158'} = 'OSLO';
$borough_number{'0159'} = '0301'; $type{'0159'} = 'G'; $location{'0159'} = 'OSLO';
$borough_number{'0160'} = '0301'; $type{'0160'} = 'G'; $location{'0160'} = 'OSLO';
$borough_number{'0161'} = '0301'; $type{'0161'} = 'G'; $location{'0161'} = 'OSLO';
$borough_number{'0162'} = '0301'; $type{'0162'} = 'G'; $location{'0162'} = 'OSLO';
$borough_number{'0164'} = '0301'; $type{'0164'} = 'G'; $location{'0164'} = 'OSLO';
$borough_number{'0165'} = '0301'; $type{'0165'} = 'G'; $location{'0165'} = 'OSLO';
$borough_number{'0166'} = '0301'; $type{'0166'} = 'G'; $location{'0166'} = 'OSLO';
$borough_number{'0167'} = '0301'; $type{'0167'} = 'G'; $location{'0167'} = 'OSLO';
$borough_number{'0168'} = '0301'; $type{'0168'} = 'G'; $location{'0168'} = 'OSLO';
$borough_number{'0169'} = '0301'; $type{'0169'} = 'G'; $location{'0169'} = 'OSLO';
$borough_number{'0170'} = '0301'; $type{'0170'} = 'G'; $location{'0170'} = 'OSLO';
$borough_number{'0171'} = '0301'; $type{'0171'} = 'G'; $location{'0171'} = 'OSLO';
$borough_number{'0172'} = '0301'; $type{'0172'} = 'G'; $location{'0172'} = 'OSLO';
$borough_number{'0173'} = '0301'; $type{'0173'} = 'G'; $location{'0173'} = 'OSLO';
$borough_number{'0174'} = '0301'; $type{'0174'} = 'G'; $location{'0174'} = 'OSLO';
$borough_number{'0175'} = '0301'; $type{'0175'} = 'G'; $location{'0175'} = 'OSLO';
$borough_number{'0176'} = '0301'; $type{'0176'} = 'G'; $location{'0176'} = 'OSLO';
$borough_number{'0177'} = '0301'; $type{'0177'} = 'G'; $location{'0177'} = 'OSLO';
$borough_number{'0178'} = '0301'; $type{'0178'} = 'G'; $location{'0178'} = 'OSLO';
$borough_number{'0179'} = '0301'; $type{'0179'} = 'G'; $location{'0179'} = 'OSLO';
$borough_number{'0180'} = '0301'; $type{'0180'} = 'G'; $location{'0180'} = 'OSLO';
$borough_number{'0181'} = '0301'; $type{'0181'} = 'G'; $location{'0181'} = 'OSLO';
$borough_number{'0182'} = '0301'; $type{'0182'} = 'G'; $location{'0182'} = 'OSLO';
$borough_number{'0183'} = '0301'; $type{'0183'} = 'G'; $location{'0183'} = 'OSLO';
$borough_number{'0184'} = '0301'; $type{'0184'} = 'G'; $location{'0184'} = 'OSLO';
$borough_number{'0185'} = '0301'; $type{'0185'} = 'G'; $location{'0185'} = 'OSLO';
$borough_number{'0186'} = '0301'; $type{'0186'} = 'G'; $location{'0186'} = 'OSLO';
$borough_number{'0187'} = '0301'; $type{'0187'} = 'G'; $location{'0187'} = 'OSLO';
$borough_number{'0188'} = '0301'; $type{'0188'} = 'G'; $location{'0188'} = 'OSLO';
$borough_number{'0190'} = '0301'; $type{'0190'} = 'G'; $location{'0190'} = 'OSLO';
$borough_number{'0191'} = '0301'; $type{'0191'} = 'G'; $location{'0191'} = 'OSLO';
$borough_number{'0192'} = '0301'; $type{'0192'} = 'G'; $location{'0192'} = 'OSLO';
$borough_number{'0193'} = '0301'; $type{'0193'} = 'G'; $location{'0193'} = 'OSLO';
$borough_number{'0196'} = '0301'; $type{'0196'} = 'G'; $location{'0196'} = 'OSLO';
$borough_number{'0198'} = '0301'; $type{'0198'} = 'G'; $location{'0198'} = 'OSLO';
$borough_number{'0201'} = '0301'; $type{'0201'} = 'P'; $location{'0201'} = 'OSLO';
$borough_number{'0202'} = '0301'; $type{'0202'} = 'P'; $location{'0202'} = 'OSLO';
$borough_number{'0203'} = '0301'; $type{'0203'} = 'P'; $location{'0203'} = 'OSLO';
$borough_number{'0204'} = '0301'; $type{'0204'} = 'P'; $location{'0204'} = 'OSLO';
$borough_number{'0207'} = '0301'; $type{'0207'} = 'P'; $location{'0207'} = 'OSLO';
$borough_number{'0208'} = '0301'; $type{'0208'} = 'P'; $location{'0208'} = 'OSLO';
$borough_number{'0211'} = '0301'; $type{'0211'} = 'P'; $location{'0211'} = 'OSLO';
$borough_number{'0212'} = '0301'; $type{'0212'} = 'P'; $location{'0212'} = 'OSLO';
$borough_number{'0213'} = '0301'; $type{'0213'} = 'P'; $location{'0213'} = 'OSLO';
$borough_number{'0214'} = '0301'; $type{'0214'} = 'P'; $location{'0214'} = 'OSLO';
$borough_number{'0215'} = '0301'; $type{'0215'} = 'P'; $location{'0215'} = 'OSLO';
$borough_number{'0216'} = '0301'; $type{'0216'} = 'P'; $location{'0216'} = 'OSLO';
$borough_number{'0218'} = '0301'; $type{'0218'} = 'P'; $location{'0218'} = 'OSLO';
$borough_number{'0230'} = '0301'; $type{'0230'} = 'P'; $location{'0230'} = 'OSLO';
$borough_number{'0240'} = '0301'; $type{'0240'} = 'K'; $location{'0240'} = 'OSLO';
$borough_number{'0242'} = '0301'; $type{'0242'} = 'K'; $location{'0242'} = 'OSLO';
$borough_number{'0244'} = '0301'; $type{'0244'} = 'K'; $location{'0244'} = 'OSLO';
$borough_number{'0245'} = '0301'; $type{'0245'} = 'K'; $location{'0245'} = 'OSLO';
$borough_number{'0246'} = '0301'; $type{'0246'} = 'K'; $location{'0246'} = 'OSLO';
$borough_number{'0247'} = '0301'; $type{'0247'} = 'K'; $location{'0247'} = 'OSLO';
$borough_number{'0250'} = '0301'; $type{'0250'} = 'G'; $location{'0250'} = 'OSLO';
$borough_number{'0251'} = '0301'; $type{'0251'} = 'G'; $location{'0251'} = 'OSLO';
$borough_number{'0253'} = '0301'; $type{'0253'} = 'G'; $location{'0253'} = 'OSLO';
$borough_number{'0254'} = '0301'; $type{'0254'} = 'G'; $location{'0254'} = 'OSLO';
$borough_number{'0255'} = '0301'; $type{'0255'} = 'G'; $location{'0255'} = 'OSLO';
$borough_number{'0256'} = '0301'; $type{'0256'} = 'G'; $location{'0256'} = 'OSLO';
$borough_number{'0257'} = '0301'; $type{'0257'} = 'G'; $location{'0257'} = 'OSLO';
$borough_number{'0258'} = '0301'; $type{'0258'} = 'G'; $location{'0258'} = 'OSLO';
$borough_number{'0259'} = '0301'; $type{'0259'} = 'G'; $location{'0259'} = 'OSLO';
$borough_number{'0260'} = '0301'; $type{'0260'} = 'G'; $location{'0260'} = 'OSLO';
$borough_number{'0262'} = '0301'; $type{'0262'} = 'G'; $location{'0262'} = 'OSLO';
$borough_number{'0263'} = '0301'; $type{'0263'} = 'G'; $location{'0263'} = 'OSLO';
$borough_number{'0264'} = '0301'; $type{'0264'} = 'G'; $location{'0264'} = 'OSLO';
$borough_number{'0265'} = '0301'; $type{'0265'} = 'G'; $location{'0265'} = 'OSLO';
$borough_number{'0266'} = '0301'; $type{'0266'} = 'G'; $location{'0266'} = 'OSLO';
$borough_number{'0267'} = '0301'; $type{'0267'} = 'G'; $location{'0267'} = 'OSLO';
$borough_number{'0268'} = '0301'; $type{'0268'} = 'G'; $location{'0268'} = 'OSLO';
$borough_number{'0270'} = '0301'; $type{'0270'} = 'G'; $location{'0270'} = 'OSLO';
$borough_number{'0271'} = '0301'; $type{'0271'} = 'G'; $location{'0271'} = 'OSLO';
$borough_number{'0272'} = '0301'; $type{'0272'} = 'G'; $location{'0272'} = 'OSLO';
$borough_number{'0273'} = '0301'; $type{'0273'} = 'G'; $location{'0273'} = 'OSLO';
$borough_number{'0274'} = '0301'; $type{'0274'} = 'G'; $location{'0274'} = 'OSLO';
$borough_number{'0275'} = '0301'; $type{'0275'} = 'G'; $location{'0275'} = 'OSLO';
$borough_number{'0276'} = '0301'; $type{'0276'} = 'G'; $location{'0276'} = 'OSLO';
$borough_number{'0277'} = '0301'; $type{'0277'} = 'G'; $location{'0277'} = 'OSLO';
$borough_number{'0278'} = '0301'; $type{'0278'} = 'G'; $location{'0278'} = 'OSLO';
$borough_number{'0279'} = '0301'; $type{'0279'} = 'G'; $location{'0279'} = 'OSLO';
$borough_number{'0280'} = '0301'; $type{'0280'} = 'G'; $location{'0280'} = 'OSLO';
$borough_number{'0281'} = '0301'; $type{'0281'} = 'G'; $location{'0281'} = 'OSLO';
$borough_number{'0282'} = '0301'; $type{'0282'} = 'G'; $location{'0282'} = 'OSLO';
$borough_number{'0283'} = '0301'; $type{'0283'} = 'G'; $location{'0283'} = 'OSLO';
$borough_number{'0284'} = '0301'; $type{'0284'} = 'G'; $location{'0284'} = 'OSLO';
$borough_number{'0286'} = '0301'; $type{'0286'} = 'G'; $location{'0286'} = 'OSLO';
$borough_number{'0287'} = '0301'; $type{'0287'} = 'G'; $location{'0287'} = 'OSLO';
$borough_number{'0301'} = '0301'; $type{'0301'} = 'P'; $location{'0301'} = 'OSLO';
$borough_number{'0302'} = '0301'; $type{'0302'} = 'P'; $location{'0302'} = 'OSLO';
$borough_number{'0303'} = '0301'; $type{'0303'} = 'P'; $location{'0303'} = 'OSLO';
$borough_number{'0304'} = '0301'; $type{'0304'} = 'P'; $location{'0304'} = 'OSLO';
$borough_number{'0305'} = '0301'; $type{'0305'} = 'P'; $location{'0305'} = 'OSLO';
$borough_number{'0306'} = '0301'; $type{'0306'} = 'P'; $location{'0306'} = 'OSLO';
$borough_number{'0307'} = '0301'; $type{'0307'} = 'P'; $location{'0307'} = 'OSLO';
$borough_number{'0308'} = '0301'; $type{'0308'} = 'P'; $location{'0308'} = 'OSLO';
$borough_number{'0309'} = '0301'; $type{'0309'} = 'P'; $location{'0309'} = 'OSLO';
$borough_number{'0310'} = '0301'; $type{'0310'} = 'F'; $location{'0310'} = 'OSLO';
$borough_number{'0311'} = '0301'; $type{'0311'} = 'P'; $location{'0311'} = 'OSLO';
$borough_number{'0313'} = '0301'; $type{'0313'} = 'B'; $location{'0313'} = 'OSLO';
$borough_number{'0314'} = '0301'; $type{'0314'} = 'P'; $location{'0314'} = 'OSLO';
$borough_number{'0315'} = '0301'; $type{'0315'} = 'P'; $location{'0315'} = 'OSLO';
$borough_number{'0316'} = '0301'; $type{'0316'} = 'P'; $location{'0316'} = 'OSLO';
$borough_number{'0317'} = '0301'; $type{'0317'} = 'P'; $location{'0317'} = 'OSLO';
$borough_number{'0318'} = '0301'; $type{'0318'} = 'P'; $location{'0318'} = 'OSLO';
$borough_number{'0319'} = '0301'; $type{'0319'} = 'P'; $location{'0319'} = 'OSLO';
$borough_number{'0320'} = '0301'; $type{'0320'} = 'G'; $location{'0320'} = 'OSLO';
$borough_number{'0323'} = '0301'; $type{'0323'} = 'P'; $location{'0323'} = 'OSLO';
$borough_number{'0330'} = '0301'; $type{'0330'} = 'P'; $location{'0330'} = 'OSLO';
$borough_number{'0340'} = '0301'; $type{'0340'} = 'F'; $location{'0340'} = 'OSLO';
$borough_number{'0341'} = '0301'; $type{'0341'} = 'K'; $location{'0341'} = 'OSLO';
$borough_number{'0342'} = '0301'; $type{'0342'} = 'K'; $location{'0342'} = 'OSLO';
$borough_number{'0349'} = '0301'; $type{'0349'} = 'F'; $location{'0349'} = 'OSLO';
$borough_number{'0350'} = '0301'; $type{'0350'} = 'G'; $location{'0350'} = 'OSLO';
$borough_number{'0351'} = '0301'; $type{'0351'} = 'G'; $location{'0351'} = 'OSLO';
$borough_number{'0352'} = '0301'; $type{'0352'} = 'G'; $location{'0352'} = 'OSLO';
$borough_number{'0353'} = '0301'; $type{'0353'} = 'G'; $location{'0353'} = 'OSLO';
$borough_number{'0354'} = '0301'; $type{'0354'} = 'G'; $location{'0354'} = 'OSLO';
$borough_number{'0355'} = '0301'; $type{'0355'} = 'G'; $location{'0355'} = 'OSLO';
$borough_number{'0356'} = '0301'; $type{'0356'} = 'G'; $location{'0356'} = 'OSLO';
$borough_number{'0357'} = '0301'; $type{'0357'} = 'G'; $location{'0357'} = 'OSLO';
$borough_number{'0358'} = '0301'; $type{'0358'} = 'G'; $location{'0358'} = 'OSLO';
$borough_number{'0359'} = '0301'; $type{'0359'} = 'G'; $location{'0359'} = 'OSLO';
$borough_number{'0360'} = '0301'; $type{'0360'} = 'G'; $location{'0360'} = 'OSLO';
$borough_number{'0361'} = '0301'; $type{'0361'} = 'G'; $location{'0361'} = 'OSLO';
$borough_number{'0362'} = '0301'; $type{'0362'} = 'G'; $location{'0362'} = 'OSLO';
$borough_number{'0363'} = '0301'; $type{'0363'} = 'G'; $location{'0363'} = 'OSLO';
$borough_number{'0364'} = '0301'; $type{'0364'} = 'G'; $location{'0364'} = 'OSLO';
$borough_number{'0365'} = '0301'; $type{'0365'} = 'G'; $location{'0365'} = 'OSLO';
$borough_number{'0366'} = '0301'; $type{'0366'} = 'G'; $location{'0366'} = 'OSLO';
$borough_number{'0367'} = '0301'; $type{'0367'} = 'G'; $location{'0367'} = 'OSLO';
$borough_number{'0368'} = '0301'; $type{'0368'} = 'G'; $location{'0368'} = 'OSLO';
$borough_number{'0369'} = '0301'; $type{'0369'} = 'G'; $location{'0369'} = 'OSLO';
$borough_number{'0370'} = '0301'; $type{'0370'} = 'G'; $location{'0370'} = 'OSLO';
$borough_number{'0371'} = '0301'; $type{'0371'} = 'G'; $location{'0371'} = 'OSLO';
$borough_number{'0372'} = '0301'; $type{'0372'} = 'G'; $location{'0372'} = 'OSLO';
$borough_number{'0373'} = '0301'; $type{'0373'} = 'G'; $location{'0373'} = 'OSLO';
$borough_number{'0374'} = '0301'; $type{'0374'} = 'G'; $location{'0374'} = 'OSLO';
$borough_number{'0375'} = '0301'; $type{'0375'} = 'G'; $location{'0375'} = 'OSLO';
$borough_number{'0376'} = '0301'; $type{'0376'} = 'G'; $location{'0376'} = 'OSLO';
$borough_number{'0377'} = '0301'; $type{'0377'} = 'G'; $location{'0377'} = 'OSLO';
$borough_number{'0378'} = '0301'; $type{'0378'} = 'G'; $location{'0378'} = 'OSLO';
$borough_number{'0379'} = '0301'; $type{'0379'} = 'G'; $location{'0379'} = 'OSLO';
$borough_number{'0380'} = '0301'; $type{'0380'} = 'G'; $location{'0380'} = 'OSLO';
$borough_number{'0381'} = '0301'; $type{'0381'} = 'G'; $location{'0381'} = 'OSLO';
$borough_number{'0382'} = '0301'; $type{'0382'} = 'G'; $location{'0382'} = 'OSLO';
$borough_number{'0383'} = '0301'; $type{'0383'} = 'G'; $location{'0383'} = 'OSLO';
$borough_number{'0401'} = '0301'; $type{'0401'} = 'P'; $location{'0401'} = 'OSLO';
$borough_number{'0402'} = '0301'; $type{'0402'} = 'P'; $location{'0402'} = 'OSLO';
$borough_number{'0403'} = '0301'; $type{'0403'} = 'P'; $location{'0403'} = 'OSLO';
$borough_number{'0404'} = '0301'; $type{'0404'} = 'P'; $location{'0404'} = 'OSLO';
$borough_number{'0405'} = '0301'; $type{'0405'} = 'P'; $location{'0405'} = 'OSLO';
$borough_number{'0406'} = '0301'; $type{'0406'} = 'P'; $location{'0406'} = 'OSLO';
$borough_number{'0407'} = '0301'; $type{'0407'} = 'K'; $location{'0407'} = 'OSLO';
$borough_number{'0408'} = '0301'; $type{'0408'} = 'P'; $location{'0408'} = 'OSLO';
$borough_number{'0409'} = '0301'; $type{'0409'} = 'P'; $location{'0409'} = 'OSLO';
$borough_number{'0410'} = '0301'; $type{'0410'} = 'P'; $location{'0410'} = 'OSLO';
$borough_number{'0411'} = '0301'; $type{'0411'} = 'P'; $location{'0411'} = 'OSLO';
$borough_number{'0412'} = '0301'; $type{'0412'} = 'P'; $location{'0412'} = 'OSLO';
$borough_number{'0413'} = '0301'; $type{'0413'} = 'P'; $location{'0413'} = 'OSLO';
$borough_number{'0415'} = '0301'; $type{'0415'} = 'P'; $location{'0415'} = 'OSLO';
$borough_number{'0421'} = '0301'; $type{'0421'} = 'P'; $location{'0421'} = 'OSLO';
$borough_number{'0422'} = '0301'; $type{'0422'} = 'P'; $location{'0422'} = 'OSLO';
$borough_number{'0423'} = '0301'; $type{'0423'} = 'P'; $location{'0423'} = 'OSLO';
$borough_number{'0426'} = '0301'; $type{'0426'} = 'P'; $location{'0426'} = 'OSLO';
$borough_number{'0440'} = '0301'; $type{'0440'} = 'K'; $location{'0440'} = 'OSLO';
$borough_number{'0441'} = '0301'; $type{'0441'} = 'K'; $location{'0441'} = 'OSLO';
$borough_number{'0442'} = '0301'; $type{'0442'} = 'K'; $location{'0442'} = 'OSLO';
$borough_number{'0445'} = '0301'; $type{'0445'} = 'K'; $location{'0445'} = 'OSLO';
$borough_number{'0450'} = '0301'; $type{'0450'} = 'G'; $location{'0450'} = 'OSLO';
$borough_number{'0451'} = '0301'; $type{'0451'} = 'G'; $location{'0451'} = 'OSLO';
$borough_number{'0452'} = '0301'; $type{'0452'} = 'G'; $location{'0452'} = 'OSLO';
$borough_number{'0454'} = '0301'; $type{'0454'} = 'G'; $location{'0454'} = 'OSLO';
$borough_number{'0455'} = '0301'; $type{'0455'} = 'G'; $location{'0455'} = 'OSLO';
$borough_number{'0456'} = '0301'; $type{'0456'} = 'G'; $location{'0456'} = 'OSLO';
$borough_number{'0457'} = '0301'; $type{'0457'} = 'G'; $location{'0457'} = 'OSLO';
$borough_number{'0458'} = '0301'; $type{'0458'} = 'G'; $location{'0458'} = 'OSLO';
$borough_number{'0459'} = '0301'; $type{'0459'} = 'G'; $location{'0459'} = 'OSLO';
$borough_number{'0460'} = '0301'; $type{'0460'} = 'G'; $location{'0460'} = 'OSLO';
$borough_number{'0461'} = '0301'; $type{'0461'} = 'G'; $location{'0461'} = 'OSLO';
$borough_number{'0462'} = '0301'; $type{'0462'} = 'G'; $location{'0462'} = 'OSLO';
$borough_number{'0463'} = '0301'; $type{'0463'} = 'G'; $location{'0463'} = 'OSLO';
$borough_number{'0464'} = '0301'; $type{'0464'} = 'G'; $location{'0464'} = 'OSLO';
$borough_number{'0465'} = '0301'; $type{'0465'} = 'G'; $location{'0465'} = 'OSLO';
$borough_number{'0467'} = '0301'; $type{'0467'} = 'G'; $location{'0467'} = 'OSLO';
$borough_number{'0468'} = '0301'; $type{'0468'} = 'G'; $location{'0468'} = 'OSLO';
$borough_number{'0469'} = '0301'; $type{'0469'} = 'G'; $location{'0469'} = 'OSLO';
$borough_number{'0470'} = '0301'; $type{'0470'} = 'G'; $location{'0470'} = 'OSLO';
$borough_number{'0472'} = '0301'; $type{'0472'} = 'G'; $location{'0472'} = 'OSLO';
$borough_number{'0473'} = '0301'; $type{'0473'} = 'G'; $location{'0473'} = 'OSLO';
$borough_number{'0474'} = '0301'; $type{'0474'} = 'G'; $location{'0474'} = 'OSLO';
$borough_number{'0475'} = '0301'; $type{'0475'} = 'G'; $location{'0475'} = 'OSLO';
$borough_number{'0476'} = '0301'; $type{'0476'} = 'G'; $location{'0476'} = 'OSLO';
$borough_number{'0477'} = '0301'; $type{'0477'} = 'G'; $location{'0477'} = 'OSLO';
$borough_number{'0478'} = '0301'; $type{'0478'} = 'G'; $location{'0478'} = 'OSLO';
$borough_number{'0479'} = '0301'; $type{'0479'} = 'G'; $location{'0479'} = 'OSLO';
$borough_number{'0480'} = '0301'; $type{'0480'} = 'G'; $location{'0480'} = 'OSLO';
$borough_number{'0481'} = '0301'; $type{'0481'} = 'G'; $location{'0481'} = 'OSLO';
$borough_number{'0482'} = '0301'; $type{'0482'} = 'G'; $location{'0482'} = 'OSLO';
$borough_number{'0483'} = '0301'; $type{'0483'} = 'G'; $location{'0483'} = 'OSLO';
$borough_number{'0484'} = '0301'; $type{'0484'} = 'G'; $location{'0484'} = 'OSLO';
$borough_number{'0485'} = '0301'; $type{'0485'} = 'G'; $location{'0485'} = 'OSLO';
$borough_number{'0486'} = '0301'; $type{'0486'} = 'G'; $location{'0486'} = 'OSLO';
$borough_number{'0487'} = '0301'; $type{'0487'} = 'G'; $location{'0487'} = 'OSLO';
$borough_number{'0488'} = '0301'; $type{'0488'} = 'G'; $location{'0488'} = 'OSLO';
$borough_number{'0489'} = '0301'; $type{'0489'} = 'G'; $location{'0489'} = 'OSLO';
$borough_number{'0490'} = '0301'; $type{'0490'} = 'G'; $location{'0490'} = 'OSLO';
$borough_number{'0491'} = '0301'; $type{'0491'} = 'G'; $location{'0491'} = 'OSLO';
$borough_number{'0492'} = '0301'; $type{'0492'} = 'G'; $location{'0492'} = 'OSLO';
$borough_number{'0493'} = '0301'; $type{'0493'} = 'G'; $location{'0493'} = 'OSLO';
$borough_number{'0494'} = '0301'; $type{'0494'} = 'G'; $location{'0494'} = 'OSLO';
$borough_number{'0495'} = '0301'; $type{'0495'} = 'G'; $location{'0495'} = 'OSLO';
$borough_number{'0496'} = '0301'; $type{'0496'} = 'G'; $location{'0496'} = 'OSLO';
$borough_number{'0501'} = '0301'; $type{'0501'} = 'P'; $location{'0501'} = 'OSLO';
$borough_number{'0502'} = '0301'; $type{'0502'} = 'P'; $location{'0502'} = 'OSLO';
$borough_number{'0503'} = '0301'; $type{'0503'} = 'P'; $location{'0503'} = 'OSLO';
$borough_number{'0504'} = '0301'; $type{'0504'} = 'P'; $location{'0504'} = 'OSLO';
$borough_number{'0505'} = '0301'; $type{'0505'} = 'P'; $location{'0505'} = 'OSLO';
$borough_number{'0506'} = '0301'; $type{'0506'} = 'P'; $location{'0506'} = 'OSLO';
$borough_number{'0508'} = '0301'; $type{'0508'} = 'P'; $location{'0508'} = 'OSLO';
$borough_number{'0509'} = '0301'; $type{'0509'} = 'P'; $location{'0509'} = 'OSLO';
$borough_number{'0510'} = '0301'; $type{'0510'} = 'P'; $location{'0510'} = 'OSLO';
$borough_number{'0511'} = '0301'; $type{'0511'} = 'P'; $location{'0511'} = 'OSLO';
$borough_number{'0512'} = '0301'; $type{'0512'} = 'P'; $location{'0512'} = 'OSLO';
$borough_number{'0513'} = '0301'; $type{'0513'} = 'P'; $location{'0513'} = 'OSLO';
$borough_number{'0514'} = '0301'; $type{'0514'} = 'F'; $location{'0514'} = 'OSLO';
$borough_number{'0515'} = '0301'; $type{'0515'} = 'P'; $location{'0515'} = 'OSLO';
$borough_number{'0516'} = '0301'; $type{'0516'} = 'P'; $location{'0516'} = 'OSLO';
$borough_number{'0517'} = '0301'; $type{'0517'} = 'P'; $location{'0517'} = 'OSLO';
$borough_number{'0518'} = '0301'; $type{'0518'} = 'P'; $location{'0518'} = 'OSLO';
$borough_number{'0520'} = '0301'; $type{'0520'} = 'P'; $location{'0520'} = 'OSLO';
$borough_number{'0540'} = '0301'; $type{'0540'} = 'K'; $location{'0540'} = 'OSLO';
$borough_number{'0550'} = '0301'; $type{'0550'} = 'G'; $location{'0550'} = 'OSLO';
$borough_number{'0551'} = '0301'; $type{'0551'} = 'G'; $location{'0551'} = 'OSLO';
$borough_number{'0552'} = '0301'; $type{'0552'} = 'G'; $location{'0552'} = 'OSLO';
$borough_number{'0553'} = '0301'; $type{'0553'} = 'G'; $location{'0553'} = 'OSLO';
$borough_number{'0554'} = '0301'; $type{'0554'} = 'G'; $location{'0554'} = 'OSLO';
$borough_number{'0555'} = '0301'; $type{'0555'} = 'G'; $location{'0555'} = 'OSLO';
$borough_number{'0556'} = '0301'; $type{'0556'} = 'G'; $location{'0556'} = 'OSLO';
$borough_number{'0557'} = '0301'; $type{'0557'} = 'G'; $location{'0557'} = 'OSLO';
$borough_number{'0558'} = '0301'; $type{'0558'} = 'G'; $location{'0558'} = 'OSLO';
$borough_number{'0559'} = '0301'; $type{'0559'} = 'G'; $location{'0559'} = 'OSLO';
$borough_number{'0560'} = '0301'; $type{'0560'} = 'G'; $location{'0560'} = 'OSLO';
$borough_number{'0561'} = '0301'; $type{'0561'} = 'G'; $location{'0561'} = 'OSLO';
$borough_number{'0562'} = '0301'; $type{'0562'} = 'G'; $location{'0562'} = 'OSLO';
$borough_number{'0563'} = '0301'; $type{'0563'} = 'G'; $location{'0563'} = 'OSLO';
$borough_number{'0564'} = '0301'; $type{'0564'} = 'G'; $location{'0564'} = 'OSLO';
$borough_number{'0565'} = '0301'; $type{'0565'} = 'G'; $location{'0565'} = 'OSLO';
$borough_number{'0566'} = '0301'; $type{'0566'} = 'G'; $location{'0566'} = 'OSLO';
$borough_number{'0567'} = '0301'; $type{'0567'} = 'G'; $location{'0567'} = 'OSLO';
$borough_number{'0568'} = '0301'; $type{'0568'} = 'G'; $location{'0568'} = 'OSLO';
$borough_number{'0569'} = '0301'; $type{'0569'} = 'G'; $location{'0569'} = 'OSLO';
$borough_number{'0570'} = '0301'; $type{'0570'} = 'G'; $location{'0570'} = 'OSLO';
$borough_number{'0571'} = '0301'; $type{'0571'} = 'G'; $location{'0571'} = 'OSLO';
$borough_number{'0572'} = '0301'; $type{'0572'} = 'G'; $location{'0572'} = 'OSLO';
$borough_number{'0573'} = '0301'; $type{'0573'} = 'G'; $location{'0573'} = 'OSLO';
$borough_number{'0574'} = '0301'; $type{'0574'} = 'G'; $location{'0574'} = 'OSLO';
$borough_number{'0575'} = '0301'; $type{'0575'} = 'G'; $location{'0575'} = 'OSLO';
$borough_number{'0576'} = '0301'; $type{'0576'} = 'G'; $location{'0576'} = 'OSLO';
$borough_number{'0577'} = '0301'; $type{'0577'} = 'G'; $location{'0577'} = 'OSLO';
$borough_number{'0578'} = '0301'; $type{'0578'} = 'G'; $location{'0578'} = 'OSLO';
$borough_number{'0579'} = '0301'; $type{'0579'} = 'G'; $location{'0579'} = 'OSLO';
$borough_number{'0580'} = '0301'; $type{'0580'} = 'G'; $location{'0580'} = 'OSLO';
$borough_number{'0581'} = '0301'; $type{'0581'} = 'G'; $location{'0581'} = 'OSLO';
$borough_number{'0582'} = '0301'; $type{'0582'} = 'G'; $location{'0582'} = 'OSLO';
$borough_number{'0583'} = '0301'; $type{'0583'} = 'G'; $location{'0583'} = 'OSLO';
$borough_number{'0584'} = '0301'; $type{'0584'} = 'G'; $location{'0584'} = 'OSLO';
$borough_number{'0585'} = '0301'; $type{'0585'} = 'G'; $location{'0585'} = 'OSLO';
$borough_number{'0586'} = '0301'; $type{'0586'} = 'G'; $location{'0586'} = 'OSLO';
$borough_number{'0587'} = '0301'; $type{'0587'} = 'G'; $location{'0587'} = 'OSLO';
$borough_number{'0588'} = '0301'; $type{'0588'} = 'G'; $location{'0588'} = 'OSLO';
$borough_number{'0589'} = '0301'; $type{'0589'} = 'G'; $location{'0589'} = 'OSLO';
$borough_number{'0590'} = '0301'; $type{'0590'} = 'G'; $location{'0590'} = 'OSLO';
$borough_number{'0591'} = '0301'; $type{'0591'} = 'G'; $location{'0591'} = 'OSLO';
$borough_number{'0592'} = '0301'; $type{'0592'} = 'G'; $location{'0592'} = 'OSLO';
$borough_number{'0593'} = '0301'; $type{'0593'} = 'G'; $location{'0593'} = 'OSLO';
$borough_number{'0594'} = '0301'; $type{'0594'} = 'G'; $location{'0594'} = 'OSLO';
$borough_number{'0595'} = '0301'; $type{'0595'} = 'G'; $location{'0595'} = 'OSLO';
$borough_number{'0596'} = '0301'; $type{'0596'} = 'G'; $location{'0596'} = 'OSLO';
$borough_number{'0597'} = '0301'; $type{'0597'} = 'G'; $location{'0597'} = 'OSLO';
$borough_number{'0598'} = '0301'; $type{'0598'} = 'G'; $location{'0598'} = 'OSLO';
$borough_number{'0601'} = '0301'; $type{'0601'} = 'P'; $location{'0601'} = 'OSLO';
$borough_number{'0602'} = '0301'; $type{'0602'} = 'P'; $location{'0602'} = 'OSLO';
$borough_number{'0603'} = '0301'; $type{'0603'} = 'P'; $location{'0603'} = 'OSLO';
$borough_number{'0604'} = '0301'; $type{'0604'} = 'P'; $location{'0604'} = 'OSLO';
$borough_number{'0605'} = '0301'; $type{'0605'} = 'P'; $location{'0605'} = 'OSLO';
$borough_number{'0606'} = '0301'; $type{'0606'} = 'P'; $location{'0606'} = 'OSLO';
$borough_number{'0607'} = '0301'; $type{'0607'} = 'P'; $location{'0607'} = 'OSLO';
$borough_number{'0608'} = '0301'; $type{'0608'} = 'P'; $location{'0608'} = 'OSLO';
$borough_number{'0609'} = '0301'; $type{'0609'} = 'P'; $location{'0609'} = 'OSLO';
$borough_number{'0610'} = '0301'; $type{'0610'} = 'K'; $location{'0610'} = 'OSLO';
$borough_number{'0611'} = '0301'; $type{'0611'} = 'P'; $location{'0611'} = 'OSLO';
$borough_number{'0612'} = '0301'; $type{'0612'} = 'P'; $location{'0612'} = 'OSLO';
$borough_number{'0613'} = '0301'; $type{'0613'} = 'P'; $location{'0613'} = 'OSLO';
$borough_number{'0614'} = '0301'; $type{'0614'} = 'P'; $location{'0614'} = 'OSLO';
$borough_number{'0616'} = '0301'; $type{'0616'} = 'P'; $location{'0616'} = 'OSLO';
$borough_number{'0617'} = '0301'; $type{'0617'} = 'P'; $location{'0617'} = 'OSLO';
$borough_number{'0618'} = '0301'; $type{'0618'} = 'P'; $location{'0618'} = 'OSLO';
$borough_number{'0619'} = '0301'; $type{'0619'} = 'P'; $location{'0619'} = 'OSLO';
$borough_number{'0620'} = '0301'; $type{'0620'} = 'P'; $location{'0620'} = 'OSLO';
$borough_number{'0621'} = '0301'; $type{'0621'} = 'P'; $location{'0621'} = 'OSLO';
$borough_number{'0622'} = '0301'; $type{'0622'} = 'P'; $location{'0622'} = 'OSLO';
$borough_number{'0623'} = '0301'; $type{'0623'} = 'P'; $location{'0623'} = 'OSLO';
$borough_number{'0624'} = '0301'; $type{'0624'} = 'P'; $location{'0624'} = 'OSLO';
$borough_number{'0626'} = '0301'; $type{'0626'} = 'P'; $location{'0626'} = 'OSLO';
$borough_number{'0630'} = '0301'; $type{'0630'} = 'K'; $location{'0630'} = 'OSLO';
$borough_number{'0640'} = '0301'; $type{'0640'} = 'K'; $location{'0640'} = 'OSLO';
$borough_number{'0650'} = '0301'; $type{'0650'} = 'G'; $location{'0650'} = 'OSLO';
$borough_number{'0651'} = '0301'; $type{'0651'} = 'G'; $location{'0651'} = 'OSLO';
$borough_number{'0652'} = '0301'; $type{'0652'} = 'G'; $location{'0652'} = 'OSLO';
$borough_number{'0653'} = '0301'; $type{'0653'} = 'G'; $location{'0653'} = 'OSLO';
$borough_number{'0654'} = '0301'; $type{'0654'} = 'G'; $location{'0654'} = 'OSLO';
$borough_number{'0655'} = '0301'; $type{'0655'} = 'G'; $location{'0655'} = 'OSLO';
$borough_number{'0656'} = '0301'; $type{'0656'} = 'G'; $location{'0656'} = 'OSLO';
$borough_number{'0657'} = '0301'; $type{'0657'} = 'G'; $location{'0657'} = 'OSLO';
$borough_number{'0658'} = '0301'; $type{'0658'} = 'G'; $location{'0658'} = 'OSLO';
$borough_number{'0659'} = '0301'; $type{'0659'} = 'G'; $location{'0659'} = 'OSLO';
$borough_number{'0660'} = '0301'; $type{'0660'} = 'G'; $location{'0660'} = 'OSLO';
$borough_number{'0661'} = '0301'; $type{'0661'} = 'G'; $location{'0661'} = 'OSLO';
$borough_number{'0662'} = '0301'; $type{'0662'} = 'G'; $location{'0662'} = 'OSLO';
$borough_number{'0663'} = '0301'; $type{'0663'} = 'G'; $location{'0663'} = 'OSLO';
$borough_number{'0664'} = '0301'; $type{'0664'} = 'G'; $location{'0664'} = 'OSLO';
$borough_number{'0665'} = '0301'; $type{'0665'} = 'G'; $location{'0665'} = 'OSLO';
$borough_number{'0666'} = '0301'; $type{'0666'} = 'G'; $location{'0666'} = 'OSLO';
$borough_number{'0667'} = '0301'; $type{'0667'} = 'G'; $location{'0667'} = 'OSLO';
$borough_number{'0668'} = '0301'; $type{'0668'} = 'G'; $location{'0668'} = 'OSLO';
$borough_number{'0669'} = '0301'; $type{'0669'} = 'G'; $location{'0669'} = 'OSLO';
$borough_number{'0670'} = '0301'; $type{'0670'} = 'G'; $location{'0670'} = 'OSLO';
$borough_number{'0671'} = '0301'; $type{'0671'} = 'G'; $location{'0671'} = 'OSLO';
$borough_number{'0672'} = '0301'; $type{'0672'} = 'G'; $location{'0672'} = 'OSLO';
$borough_number{'0673'} = '0301'; $type{'0673'} = 'G'; $location{'0673'} = 'OSLO';
$borough_number{'0674'} = '0301'; $type{'0674'} = 'G'; $location{'0674'} = 'OSLO';
$borough_number{'0675'} = '0301'; $type{'0675'} = 'G'; $location{'0675'} = 'OSLO';
$borough_number{'0676'} = '0301'; $type{'0676'} = 'G'; $location{'0676'} = 'OSLO';
$borough_number{'0677'} = '0301'; $type{'0677'} = 'G'; $location{'0677'} = 'OSLO';
$borough_number{'0678'} = '0301'; $type{'0678'} = 'G'; $location{'0678'} = 'OSLO';
$borough_number{'0679'} = '0301'; $type{'0679'} = 'G'; $location{'0679'} = 'OSLO';
$borough_number{'0680'} = '0301'; $type{'0680'} = 'G'; $location{'0680'} = 'OSLO';
$borough_number{'0681'} = '0301'; $type{'0681'} = 'G'; $location{'0681'} = 'OSLO';
$borough_number{'0682'} = '0301'; $type{'0682'} = 'G'; $location{'0682'} = 'OSLO';
$borough_number{'0683'} = '0301'; $type{'0683'} = 'G'; $location{'0683'} = 'OSLO';
$borough_number{'0684'} = '0301'; $type{'0684'} = 'G'; $location{'0684'} = 'OSLO';
$borough_number{'0685'} = '0301'; $type{'0685'} = 'G'; $location{'0685'} = 'OSLO';
$borough_number{'0686'} = '0301'; $type{'0686'} = 'G'; $location{'0686'} = 'OSLO';
$borough_number{'0687'} = '0301'; $type{'0687'} = 'G'; $location{'0687'} = 'OSLO';
$borough_number{'0688'} = '0301'; $type{'0688'} = 'G'; $location{'0688'} = 'OSLO';
$borough_number{'0689'} = '0301'; $type{'0689'} = 'G'; $location{'0689'} = 'OSLO';
$borough_number{'0690'} = '0301'; $type{'0690'} = 'G'; $location{'0690'} = 'OSLO';
$borough_number{'0691'} = '0301'; $type{'0691'} = 'G'; $location{'0691'} = 'OSLO';
$borough_number{'0692'} = '0301'; $type{'0692'} = 'G'; $location{'0692'} = 'OSLO';
$borough_number{'0693'} = '0301'; $type{'0693'} = 'G'; $location{'0693'} = 'OSLO';
$borough_number{'0694'} = '0301'; $type{'0694'} = 'G'; $location{'0694'} = 'OSLO';
$borough_number{'0701'} = '0301'; $type{'0701'} = 'P'; $location{'0701'} = 'OSLO';
$borough_number{'0702'} = '0301'; $type{'0702'} = 'P'; $location{'0702'} = 'OSLO';
$borough_number{'0705'} = '0301'; $type{'0705'} = 'P'; $location{'0705'} = 'OSLO';
$borough_number{'0710'} = '0301'; $type{'0710'} = 'P'; $location{'0710'} = 'OSLO';
$borough_number{'0712'} = '0301'; $type{'0712'} = 'P'; $location{'0712'} = 'OSLO';
$borough_number{'0750'} = '0301'; $type{'0750'} = 'G'; $location{'0750'} = 'OSLO';
$borough_number{'0751'} = '0301'; $type{'0751'} = 'G'; $location{'0751'} = 'OSLO';
$borough_number{'0752'} = '0301'; $type{'0752'} = 'G'; $location{'0752'} = 'OSLO';
$borough_number{'0753'} = '0301'; $type{'0753'} = 'G'; $location{'0753'} = 'OSLO';
$borough_number{'0754'} = '0301'; $type{'0754'} = 'G'; $location{'0754'} = 'OSLO';
$borough_number{'0755'} = '0301'; $type{'0755'} = 'G'; $location{'0755'} = 'OSLO';
$borough_number{'0756'} = '0301'; $type{'0756'} = 'G'; $location{'0756'} = 'OSLO';
$borough_number{'0757'} = '0301'; $type{'0757'} = 'G'; $location{'0757'} = 'OSLO';
$borough_number{'0758'} = '0301'; $type{'0758'} = 'G'; $location{'0758'} = 'OSLO';
$borough_number{'0759'} = '0301'; $type{'0759'} = 'G'; $location{'0759'} = 'OSLO';
$borough_number{'0760'} = '0301'; $type{'0760'} = 'G'; $location{'0760'} = 'OSLO';
$borough_number{'0763'} = '0301'; $type{'0763'} = 'G'; $location{'0763'} = 'OSLO';
$borough_number{'0764'} = '0301'; $type{'0764'} = 'G'; $location{'0764'} = 'OSLO';
$borough_number{'0765'} = '0301'; $type{'0765'} = 'G'; $location{'0765'} = 'OSLO';
$borough_number{'0766'} = '0301'; $type{'0766'} = 'G'; $location{'0766'} = 'OSLO';
$borough_number{'0767'} = '0301'; $type{'0767'} = 'G'; $location{'0767'} = 'OSLO';
$borough_number{'0768'} = '0301'; $type{'0768'} = 'G'; $location{'0768'} = 'OSLO';
$borough_number{'0770'} = '0301'; $type{'0770'} = 'G'; $location{'0770'} = 'OSLO';
$borough_number{'0771'} = '0301'; $type{'0771'} = 'G'; $location{'0771'} = 'OSLO';
$borough_number{'0772'} = '0301'; $type{'0772'} = 'G'; $location{'0772'} = 'OSLO';
$borough_number{'0773'} = '0301'; $type{'0773'} = 'G'; $location{'0773'} = 'OSLO';
$borough_number{'0774'} = '0301'; $type{'0774'} = 'G'; $location{'0774'} = 'OSLO';
$borough_number{'0775'} = '0301'; $type{'0775'} = 'G'; $location{'0775'} = 'OSLO';
$borough_number{'0776'} = '0301'; $type{'0776'} = 'G'; $location{'0776'} = 'OSLO';
$borough_number{'0777'} = '0301'; $type{'0777'} = 'G'; $location{'0777'} = 'OSLO';
$borough_number{'0778'} = '0301'; $type{'0778'} = 'G'; $location{'0778'} = 'OSLO';
$borough_number{'0779'} = '0301'; $type{'0779'} = 'G'; $location{'0779'} = 'OSLO';
$borough_number{'0781'} = '0301'; $type{'0781'} = 'G'; $location{'0781'} = 'OSLO';
$borough_number{'0782'} = '0301'; $type{'0782'} = 'G'; $location{'0782'} = 'OSLO';
$borough_number{'0783'} = '0301'; $type{'0783'} = 'G'; $location{'0783'} = 'OSLO';
$borough_number{'0784'} = '0301'; $type{'0784'} = 'G'; $location{'0784'} = 'OSLO';
$borough_number{'0785'} = '0301'; $type{'0785'} = 'G'; $location{'0785'} = 'OSLO';
$borough_number{'0786'} = '0301'; $type{'0786'} = 'G'; $location{'0786'} = 'OSLO';
$borough_number{'0787'} = '0301'; $type{'0787'} = 'G'; $location{'0787'} = 'OSLO';
$borough_number{'0788'} = '0301'; $type{'0788'} = 'G'; $location{'0788'} = 'OSLO';
$borough_number{'0789'} = '0301'; $type{'0789'} = 'G'; $location{'0789'} = 'OSLO';
$borough_number{'0790'} = '0301'; $type{'0790'} = 'G'; $location{'0790'} = 'OSLO';
$borough_number{'0791'} = '0301'; $type{'0791'} = 'G'; $location{'0791'} = 'OSLO';
$borough_number{'0801'} = '0301'; $type{'0801'} = 'P'; $location{'0801'} = 'OSLO';
$borough_number{'0805'} = '0301'; $type{'0805'} = 'P'; $location{'0805'} = 'OSLO';
$borough_number{'0806'} = '0301'; $type{'0806'} = 'P'; $location{'0806'} = 'OSLO';
$borough_number{'0807'} = '0301'; $type{'0807'} = 'P'; $location{'0807'} = 'OSLO';
$borough_number{'0840'} = '0301'; $type{'0840'} = 'K'; $location{'0840'} = 'OSLO';
$borough_number{'0850'} = '0301'; $type{'0850'} = 'G'; $location{'0850'} = 'OSLO';
$borough_number{'0851'} = '0301'; $type{'0851'} = 'G'; $location{'0851'} = 'OSLO';
$borough_number{'0852'} = '0301'; $type{'0852'} = 'G'; $location{'0852'} = 'OSLO';
$borough_number{'0853'} = '0301'; $type{'0853'} = 'G'; $location{'0853'} = 'OSLO';
$borough_number{'0854'} = '0301'; $type{'0854'} = 'G'; $location{'0854'} = 'OSLO';
$borough_number{'0855'} = '0301'; $type{'0855'} = 'G'; $location{'0855'} = 'OSLO';
$borough_number{'0856'} = '0301'; $type{'0856'} = 'G'; $location{'0856'} = 'OSLO';
$borough_number{'0857'} = '0301'; $type{'0857'} = 'G'; $location{'0857'} = 'OSLO';
$borough_number{'0858'} = '0301'; $type{'0858'} = 'G'; $location{'0858'} = 'OSLO';
$borough_number{'0860'} = '0301'; $type{'0860'} = 'G'; $location{'0860'} = 'OSLO';
$borough_number{'0861'} = '0301'; $type{'0861'} = 'G'; $location{'0861'} = 'OSLO';
$borough_number{'0862'} = '0301'; $type{'0862'} = 'G'; $location{'0862'} = 'OSLO';
$borough_number{'0863'} = '0301'; $type{'0863'} = 'G'; $location{'0863'} = 'OSLO';
$borough_number{'0864'} = '0301'; $type{'0864'} = 'G'; $location{'0864'} = 'OSLO';
$borough_number{'0870'} = '0301'; $type{'0870'} = 'G'; $location{'0870'} = 'OSLO';
$borough_number{'0871'} = '0301'; $type{'0871'} = 'G'; $location{'0871'} = 'OSLO';
$borough_number{'0872'} = '0301'; $type{'0872'} = 'G'; $location{'0872'} = 'OSLO';
$borough_number{'0873'} = '0301'; $type{'0873'} = 'G'; $location{'0873'} = 'OSLO';
$borough_number{'0874'} = '0301'; $type{'0874'} = 'G'; $location{'0874'} = 'OSLO';
$borough_number{'0875'} = '0301'; $type{'0875'} = 'G'; $location{'0875'} = 'OSLO';
$borough_number{'0876'} = '0301'; $type{'0876'} = 'G'; $location{'0876'} = 'OSLO';
$borough_number{'0877'} = '0301'; $type{'0877'} = 'G'; $location{'0877'} = 'OSLO';
$borough_number{'0880'} = '0301'; $type{'0880'} = 'G'; $location{'0880'} = 'OSLO';
$borough_number{'0881'} = '0301'; $type{'0881'} = 'G'; $location{'0881'} = 'OSLO';
$borough_number{'0882'} = '0301'; $type{'0882'} = 'G'; $location{'0882'} = 'OSLO';
$borough_number{'0883'} = '0301'; $type{'0883'} = 'G'; $location{'0883'} = 'OSLO';
$borough_number{'0884'} = '0301'; $type{'0884'} = 'G'; $location{'0884'} = 'OSLO';
$borough_number{'0890'} = '0301'; $type{'0890'} = 'G'; $location{'0890'} = 'OSLO';
$borough_number{'0891'} = '0301'; $type{'0891'} = 'G'; $location{'0891'} = 'OSLO';
$borough_number{'0901'} = '0301'; $type{'0901'} = 'P'; $location{'0901'} = 'OSLO';
$borough_number{'0902'} = '0301'; $type{'0902'} = 'P'; $location{'0902'} = 'OSLO';
$borough_number{'0903'} = '0301'; $type{'0903'} = 'P'; $location{'0903'} = 'OSLO';
$borough_number{'0904'} = '0301'; $type{'0904'} = 'P'; $location{'0904'} = 'OSLO';
$borough_number{'0905'} = '0301'; $type{'0905'} = 'P'; $location{'0905'} = 'OSLO';
$borough_number{'0907'} = '0301'; $type{'0907'} = 'P'; $location{'0907'} = 'OSLO';
$borough_number{'0908'} = '0301'; $type{'0908'} = 'P'; $location{'0908'} = 'OSLO';
$borough_number{'0913'} = '0301'; $type{'0913'} = 'P'; $location{'0913'} = 'OSLO';
$borough_number{'0915'} = '0301'; $type{'0915'} = 'P'; $location{'0915'} = 'OSLO';
$borough_number{'0950'} = '0301'; $type{'0950'} = 'G'; $location{'0950'} = 'OSLO';
$borough_number{'0951'} = '0301'; $type{'0951'} = 'G'; $location{'0951'} = 'OSLO';
$borough_number{'0952'} = '0301'; $type{'0952'} = 'G'; $location{'0952'} = 'OSLO';
$borough_number{'0953'} = '0301'; $type{'0953'} = 'G'; $location{'0953'} = 'OSLO';
$borough_number{'0954'} = '0301'; $type{'0954'} = 'G'; $location{'0954'} = 'OSLO';
$borough_number{'0955'} = '0301'; $type{'0955'} = 'G'; $location{'0955'} = 'OSLO';
$borough_number{'0956'} = '0301'; $type{'0956'} = 'G'; $location{'0956'} = 'OSLO';
$borough_number{'0957'} = '0301'; $type{'0957'} = 'G'; $location{'0957'} = 'OSLO';
$borough_number{'0958'} = '0301'; $type{'0958'} = 'G'; $location{'0958'} = 'OSLO';
$borough_number{'0959'} = '0301'; $type{'0959'} = 'G'; $location{'0959'} = 'OSLO';
$borough_number{'0960'} = '0301'; $type{'0960'} = 'G'; $location{'0960'} = 'OSLO';
$borough_number{'0962'} = '0301'; $type{'0962'} = 'G'; $location{'0962'} = 'OSLO';
$borough_number{'0963'} = '0301'; $type{'0963'} = 'G'; $location{'0963'} = 'OSLO';
$borough_number{'0964'} = '0301'; $type{'0964'} = 'G'; $location{'0964'} = 'OSLO';
$borough_number{'0968'} = '0301'; $type{'0968'} = 'G'; $location{'0968'} = 'OSLO';
$borough_number{'0969'} = '0301'; $type{'0969'} = 'G'; $location{'0969'} = 'OSLO';
$borough_number{'0970'} = '0301'; $type{'0970'} = 'G'; $location{'0970'} = 'OSLO';
$borough_number{'0971'} = '0301'; $type{'0971'} = 'G'; $location{'0971'} = 'OSLO';
$borough_number{'0972'} = '0301'; $type{'0972'} = 'G'; $location{'0972'} = 'OSLO';
$borough_number{'0973'} = '0301'; $type{'0973'} = 'G'; $location{'0973'} = 'OSLO';
$borough_number{'0975'} = '0301'; $type{'0975'} = 'G'; $location{'0975'} = 'OSLO';
$borough_number{'0976'} = '0301'; $type{'0976'} = 'G'; $location{'0976'} = 'OSLO';
$borough_number{'0977'} = '0301'; $type{'0977'} = 'G'; $location{'0977'} = 'OSLO';
$borough_number{'0978'} = '0301'; $type{'0978'} = 'G'; $location{'0978'} = 'OSLO';
$borough_number{'0979'} = '0301'; $type{'0979'} = 'G'; $location{'0979'} = 'OSLO';
$borough_number{'0980'} = '0301'; $type{'0980'} = 'G'; $location{'0980'} = 'OSLO';
$borough_number{'0981'} = '0301'; $type{'0981'} = 'G'; $location{'0981'} = 'OSLO';
$borough_number{'0982'} = '0301'; $type{'0982'} = 'G'; $location{'0982'} = 'OSLO';
$borough_number{'0983'} = '0301'; $type{'0983'} = 'G'; $location{'0983'} = 'OSLO';
$borough_number{'0984'} = '0301'; $type{'0984'} = 'G'; $location{'0984'} = 'OSLO';
$borough_number{'0985'} = '0301'; $type{'0985'} = 'G'; $location{'0985'} = 'OSLO';
$borough_number{'0986'} = '0301'; $type{'0986'} = 'G'; $location{'0986'} = 'OSLO';
$borough_number{'0987'} = '0301'; $type{'0987'} = 'G'; $location{'0987'} = 'OSLO';
$borough_number{'0988'} = '0301'; $type{'0988'} = 'G'; $location{'0988'} = 'OSLO';
$borough_number{'1001'} = '0301'; $type{'1001'} = 'P'; $location{'1001'} = 'OSLO';
$borough_number{'1003'} = '0301'; $type{'1003'} = 'P'; $location{'1003'} = 'OSLO';
$borough_number{'1005'} = '0301'; $type{'1005'} = 'P'; $location{'1005'} = 'OSLO';
$borough_number{'1006'} = '0301'; $type{'1006'} = 'P'; $location{'1006'} = 'OSLO';
$borough_number{'1007'} = '0301'; $type{'1007'} = 'P'; $location{'1007'} = 'OSLO';
$borough_number{'1008'} = '0301'; $type{'1008'} = 'P'; $location{'1008'} = 'OSLO';
$borough_number{'1009'} = '0301'; $type{'1009'} = 'P'; $location{'1009'} = 'OSLO';
$borough_number{'1011'} = '0301'; $type{'1011'} = 'P'; $location{'1011'} = 'OSLO';
$borough_number{'1051'} = '0301'; $type{'1051'} = 'G'; $location{'1051'} = 'OSLO';
$borough_number{'1052'} = '0301'; $type{'1052'} = 'G'; $location{'1052'} = 'OSLO';
$borough_number{'1053'} = '0301'; $type{'1053'} = 'G'; $location{'1053'} = 'OSLO';
$borough_number{'1054'} = '0301'; $type{'1054'} = 'G'; $location{'1054'} = 'OSLO';
$borough_number{'1055'} = '0301'; $type{'1055'} = 'G'; $location{'1055'} = 'OSLO';
$borough_number{'1056'} = '0301'; $type{'1056'} = 'G'; $location{'1056'} = 'OSLO';
$borough_number{'1061'} = '0301'; $type{'1061'} = 'G'; $location{'1061'} = 'OSLO';
$borough_number{'1062'} = '0301'; $type{'1062'} = 'G'; $location{'1062'} = 'OSLO';
$borough_number{'1063'} = '0301'; $type{'1063'} = 'G'; $location{'1063'} = 'OSLO';
$borough_number{'1064'} = '0301'; $type{'1064'} = 'G'; $location{'1064'} = 'OSLO';
$borough_number{'1065'} = '0301'; $type{'1065'} = 'G'; $location{'1065'} = 'OSLO';
$borough_number{'1067'} = '0301'; $type{'1067'} = 'G'; $location{'1067'} = 'OSLO';
$borough_number{'1068'} = '0301'; $type{'1068'} = 'G'; $location{'1068'} = 'OSLO';
$borough_number{'1069'} = '0301'; $type{'1069'} = 'G'; $location{'1069'} = 'OSLO';
$borough_number{'1071'} = '0301'; $type{'1071'} = 'G'; $location{'1071'} = 'OSLO';
$borough_number{'1081'} = '0301'; $type{'1081'} = 'G'; $location{'1081'} = 'OSLO';
$borough_number{'1083'} = '0301'; $type{'1083'} = 'G'; $location{'1083'} = 'OSLO';
$borough_number{'1084'} = '0301'; $type{'1084'} = 'G'; $location{'1084'} = 'OSLO';
$borough_number{'1086'} = '0301'; $type{'1086'} = 'G'; $location{'1086'} = 'OSLO';
$borough_number{'1087'} = '0301'; $type{'1087'} = 'G'; $location{'1087'} = 'OSLO';
$borough_number{'1088'} = '0301'; $type{'1088'} = 'G'; $location{'1088'} = 'OSLO';
$borough_number{'1089'} = '0301'; $type{'1089'} = 'G'; $location{'1089'} = 'OSLO';
$borough_number{'1101'} = '0301'; $type{'1101'} = 'P'; $location{'1101'} = 'OSLO';
$borough_number{'1109'} = '0301'; $type{'1109'} = 'P'; $location{'1109'} = 'OSLO';
$borough_number{'1112'} = '0301'; $type{'1112'} = 'P'; $location{'1112'} = 'OSLO';
$borough_number{'1150'} = '0301'; $type{'1150'} = 'G'; $location{'1150'} = 'OSLO';
$borough_number{'1151'} = '0301'; $type{'1151'} = 'G'; $location{'1151'} = 'OSLO';
$borough_number{'1152'} = '0301'; $type{'1152'} = 'G'; $location{'1152'} = 'OSLO';
$borough_number{'1153'} = '0301'; $type{'1153'} = 'G'; $location{'1153'} = 'OSLO';
$borough_number{'1154'} = '0301'; $type{'1154'} = 'G'; $location{'1154'} = 'OSLO';
$borough_number{'1155'} = '0301'; $type{'1155'} = 'G'; $location{'1155'} = 'OSLO';
$borough_number{'1156'} = '0301'; $type{'1156'} = 'G'; $location{'1156'} = 'OSLO';
$borough_number{'1157'} = '0301'; $type{'1157'} = 'G'; $location{'1157'} = 'OSLO';
$borough_number{'1158'} = '0301'; $type{'1158'} = 'G'; $location{'1158'} = 'OSLO';
$borough_number{'1160'} = '0301'; $type{'1160'} = 'G'; $location{'1160'} = 'OSLO';
$borough_number{'1161'} = '0301'; $type{'1161'} = 'G'; $location{'1161'} = 'OSLO';
$borough_number{'1162'} = '0301'; $type{'1162'} = 'G'; $location{'1162'} = 'OSLO';
$borough_number{'1163'} = '0301'; $type{'1163'} = 'G'; $location{'1163'} = 'OSLO';
$borough_number{'1164'} = '0301'; $type{'1164'} = 'G'; $location{'1164'} = 'OSLO';
$borough_number{'1165'} = '0301'; $type{'1165'} = 'G'; $location{'1165'} = 'OSLO';
$borough_number{'1166'} = '0301'; $type{'1166'} = 'G'; $location{'1166'} = 'OSLO';
$borough_number{'1167'} = '0301'; $type{'1167'} = 'G'; $location{'1167'} = 'OSLO';
$borough_number{'1168'} = '0301'; $type{'1168'} = 'G'; $location{'1168'} = 'OSLO';
$borough_number{'1169'} = '0301'; $type{'1169'} = 'G'; $location{'1169'} = 'OSLO';
$borough_number{'1170'} = '0301'; $type{'1170'} = 'G'; $location{'1170'} = 'OSLO';
$borough_number{'1172'} = '0301'; $type{'1172'} = 'G'; $location{'1172'} = 'OSLO';
$borough_number{'1176'} = '0301'; $type{'1176'} = 'G'; $location{'1176'} = 'OSLO';
$borough_number{'1177'} = '0301'; $type{'1177'} = 'G'; $location{'1177'} = 'OSLO';
$borough_number{'1178'} = '0301'; $type{'1178'} = 'G'; $location{'1178'} = 'OSLO';
$borough_number{'1179'} = '0301'; $type{'1179'} = 'G'; $location{'1179'} = 'OSLO';
$borough_number{'1181'} = '0301'; $type{'1181'} = 'G'; $location{'1181'} = 'OSLO';
$borough_number{'1182'} = '0301'; $type{'1182'} = 'G'; $location{'1182'} = 'OSLO';
$borough_number{'1184'} = '0301'; $type{'1184'} = 'G'; $location{'1184'} = 'OSLO';
$borough_number{'1185'} = '0301'; $type{'1185'} = 'G'; $location{'1185'} = 'OSLO';
$borough_number{'1187'} = '0301'; $type{'1187'} = 'G'; $location{'1187'} = 'OSLO';
$borough_number{'1188'} = '0301'; $type{'1188'} = 'G'; $location{'1188'} = 'OSLO';
$borough_number{'1189'} = '0301'; $type{'1189'} = 'G'; $location{'1189'} = 'OSLO';
$borough_number{'1201'} = '0301'; $type{'1201'} = 'P'; $location{'1201'} = 'OSLO';
$borough_number{'1202'} = '0301'; $type{'1202'} = 'P'; $location{'1202'} = 'OSLO';
$borough_number{'1203'} = '0301'; $type{'1203'} = 'P'; $location{'1203'} = 'OSLO';
$borough_number{'1204'} = '0301'; $type{'1204'} = 'P'; $location{'1204'} = 'OSLO';
$borough_number{'1205'} = '0301'; $type{'1205'} = 'P'; $location{'1205'} = 'OSLO';
$borough_number{'1206'} = '0301'; $type{'1206'} = 'P'; $location{'1206'} = 'OSLO';
$borough_number{'1207'} = '0301'; $type{'1207'} = 'P'; $location{'1207'} = 'OSLO';
$borough_number{'1214'} = '0301'; $type{'1214'} = 'P'; $location{'1214'} = 'OSLO';
$borough_number{'1215'} = '0301'; $type{'1215'} = 'P'; $location{'1215'} = 'OSLO';
$borough_number{'1250'} = '0301'; $type{'1250'} = 'G'; $location{'1250'} = 'OSLO';
$borough_number{'1251'} = '0301'; $type{'1251'} = 'G'; $location{'1251'} = 'OSLO';
$borough_number{'1252'} = '0301'; $type{'1252'} = 'G'; $location{'1252'} = 'OSLO';
$borough_number{'1253'} = '0301'; $type{'1253'} = 'G'; $location{'1253'} = 'OSLO';
$borough_number{'1254'} = '0301'; $type{'1254'} = 'G'; $location{'1254'} = 'OSLO';
$borough_number{'1255'} = '0301'; $type{'1255'} = 'G'; $location{'1255'} = 'OSLO';
$borough_number{'1256'} = '0301'; $type{'1256'} = 'G'; $location{'1256'} = 'OSLO';
$borough_number{'1257'} = '0301'; $type{'1257'} = 'G'; $location{'1257'} = 'OSLO';
$borough_number{'1258'} = '0301'; $type{'1258'} = 'G'; $location{'1258'} = 'OSLO';
$borough_number{'1259'} = '0301'; $type{'1259'} = 'G'; $location{'1259'} = 'OSLO';
$borough_number{'1262'} = '0301'; $type{'1262'} = 'G'; $location{'1262'} = 'OSLO';
$borough_number{'1263'} = '0301'; $type{'1263'} = 'G'; $location{'1263'} = 'OSLO';
$borough_number{'1266'} = '0301'; $type{'1266'} = 'G'; $location{'1266'} = 'OSLO';
$borough_number{'1270'} = '0301'; $type{'1270'} = 'G'; $location{'1270'} = 'OSLO';
$borough_number{'1271'} = '0301'; $type{'1271'} = 'G'; $location{'1271'} = 'OSLO';
$borough_number{'1272'} = '0301'; $type{'1272'} = 'G'; $location{'1272'} = 'OSLO';
$borough_number{'1273'} = '0301'; $type{'1273'} = 'G'; $location{'1273'} = 'OSLO';
$borough_number{'1274'} = '0301'; $type{'1274'} = 'G'; $location{'1274'} = 'OSLO';
$borough_number{'1275'} = '0301'; $type{'1275'} = 'G'; $location{'1275'} = 'OSLO';
$borough_number{'1277'} = '0301'; $type{'1277'} = 'G'; $location{'1277'} = 'OSLO';
$borough_number{'1278'} = '0301'; $type{'1278'} = 'G'; $location{'1278'} = 'OSLO';
$borough_number{'1279'} = '0301'; $type{'1279'} = 'G'; $location{'1279'} = 'OSLO';
$borough_number{'1281'} = '0301'; $type{'1281'} = 'G'; $location{'1281'} = 'OSLO';
$borough_number{'1283'} = '0301'; $type{'1283'} = 'G'; $location{'1283'} = 'OSLO';
$borough_number{'1284'} = '0301'; $type{'1284'} = 'G'; $location{'1284'} = 'OSLO';
$borough_number{'1285'} = '0301'; $type{'1285'} = 'G'; $location{'1285'} = 'OSLO';
$borough_number{'1286'} = '0301'; $type{'1286'} = 'G'; $location{'1286'} = 'OSLO';
$borough_number{'1290'} = '0301'; $type{'1290'} = 'G'; $location{'1290'} = 'OSLO';
$borough_number{'1291'} = '0301'; $type{'1291'} = 'G'; $location{'1291'} = 'OSLO';
$borough_number{'1294'} = '0301'; $type{'1294'} = 'G'; $location{'1294'} = 'OSLO';
$borough_number{'1295'} = '0301'; $type{'1295'} = 'G'; $location{'1295'} = 'OSLO';
$borough_number{'1300'} = '0219'; $type{'1300'} = 'P'; $location{'1300'} = 'SANDVIKA';
$borough_number{'1301'} = '0219'; $type{'1301'} = 'P'; $location{'1301'} = 'SANDVIKA';
$borough_number{'1302'} = '0219'; $type{'1302'} = 'P'; $location{'1302'} = 'SANDVIKA';
$borough_number{'1303'} = '0219'; $type{'1303'} = 'P'; $location{'1303'} = 'SANDVIKA';
$borough_number{'1304'} = '0219'; $type{'1304'} = 'K'; $location{'1304'} = 'SANDVIKA';
$borough_number{'1305'} = '0219'; $type{'1305'} = 'P'; $location{'1305'} = 'HASLUM';
$borough_number{'1306'} = '0219'; $type{'1306'} = 'P'; $location{'1306'} = 'BRUM POSTTERMINAL';
$borough_number{'1309'} = '0219'; $type{'1309'} = 'P'; $location{'1309'} = 'RUD';
$borough_number{'1311'} = '0219'; $type{'1311'} = 'K'; $location{'1311'} = 'KUNSTSENTRET HVIKODDEN';
$borough_number{'1312'} = '0219'; $type{'1312'} = 'P'; $location{'1312'} = 'SLEPENDEN';
$borough_number{'1313'} = '0219'; $type{'1313'} = 'P'; $location{'1313'} = 'VYENENGA';
$borough_number{'1314'} = '0219'; $type{'1314'} = 'P'; $location{'1314'} = 'VYENENGA';
$borough_number{'1316'} = '0219'; $type{'1316'} = 'P'; $location{'1316'} = 'EIKSMARKA';
$borough_number{'1317'} = '0219'; $type{'1317'} = 'P'; $location{'1317'} = 'BRUMS VERK';
$borough_number{'1318'} = '0219'; $type{'1318'} = 'P'; $location{'1318'} = 'BEKKESTUA';
$borough_number{'1319'} = '0219'; $type{'1319'} = 'P'; $location{'1319'} = 'BEKKESTUA';
$borough_number{'1321'} = '0219'; $type{'1321'} = 'P'; $location{'1321'} = 'STABEKK';
$borough_number{'1322'} = '0219'; $type{'1322'} = 'P'; $location{'1322'} = 'HVIK';
$borough_number{'1323'} = '0219'; $type{'1323'} = 'P'; $location{'1323'} = 'HVIK';
$borough_number{'1324'} = '0219'; $type{'1324'} = 'P'; $location{'1324'} = 'LYSAKER';
$borough_number{'1325'} = '0219'; $type{'1325'} = 'P'; $location{'1325'} = 'LYSAKER';
$borough_number{'1326'} = '0219'; $type{'1326'} = 'P'; $location{'1326'} = 'LYSAKER';
$borough_number{'1327'} = '0219'; $type{'1327'} = 'P'; $location{'1327'} = 'LYSAKER';
$borough_number{'1330'} = '0219'; $type{'1330'} = 'P'; $location{'1330'} = 'FORNEBU';
$borough_number{'1331'} = '0219'; $type{'1331'} = 'K'; $location{'1331'} = 'FORNEBU';
$borough_number{'1332'} = '0219'; $type{'1332'} = 'P'; $location{'1332'} = 'STERS';
$borough_number{'1333'} = '0219'; $type{'1333'} = 'P'; $location{'1333'} = 'KOLSS';
$borough_number{'1334'} = '0219'; $type{'1334'} = 'P'; $location{'1334'} = 'RYKKINN';
$borough_number{'1335'} = '0219'; $type{'1335'} = 'P'; $location{'1335'} = 'SNARYA';
$borough_number{'1336'} = '0219'; $type{'1336'} = 'G'; $location{'1336'} = 'SANDVIKA';
$borough_number{'1337'} = '0219'; $type{'1337'} = 'G'; $location{'1337'} = 'SANDVIKA';
$borough_number{'1338'} = '0219'; $type{'1338'} = 'G'; $location{'1338'} = 'SANDVIKA';
$borough_number{'1339'} = '0219'; $type{'1339'} = 'G'; $location{'1339'} = 'VYENENGA';
$borough_number{'1340'} = '0219'; $type{'1340'} = 'G'; $location{'1340'} = 'SKUI';
$borough_number{'1341'} = '0219'; $type{'1341'} = 'G'; $location{'1341'} = 'SLEPENDEN';
$borough_number{'1344'} = '0219'; $type{'1344'} = 'G'; $location{'1344'} = 'HASLUM';
$borough_number{'1346'} = '0219'; $type{'1346'} = 'G'; $location{'1346'} = 'GJETTUM';
$borough_number{'1348'} = '0219'; $type{'1348'} = 'G'; $location{'1348'} = 'RYKKINN';
$borough_number{'1349'} = '0219'; $type{'1349'} = 'G'; $location{'1349'} = 'RYKKINN';
$borough_number{'1350'} = '0219'; $type{'1350'} = 'B'; $location{'1350'} = 'LOMMEDALEN';
$borough_number{'1351'} = '0219'; $type{'1351'} = 'G'; $location{'1351'} = 'RUD';
$borough_number{'1352'} = '0219'; $type{'1352'} = 'G'; $location{'1352'} = 'KOLSS';
$borough_number{'1353'} = '0219'; $type{'1353'} = 'G'; $location{'1353'} = 'BRUMS VERK';
$borough_number{'1354'} = '0219'; $type{'1354'} = 'G'; $location{'1354'} = 'BRUMS VERK';
$borough_number{'1356'} = '0219'; $type{'1356'} = 'G'; $location{'1356'} = 'BEKKESTUA';
$borough_number{'1357'} = '0219'; $type{'1357'} = 'G'; $location{'1357'} = 'BEKKESTUA';
$borough_number{'1358'} = '0219'; $type{'1358'} = 'G'; $location{'1358'} = 'JAR';
$borough_number{'1359'} = '0219'; $type{'1359'} = 'G'; $location{'1359'} = 'EIKSMARKA';
$borough_number{'1361'} = '0219'; $type{'1361'} = 'G'; $location{'1361'} = 'STERS';
$borough_number{'1362'} = '0219'; $type{'1362'} = 'G'; $location{'1362'} = 'HOSLE';
$borough_number{'1363'} = '0219'; $type{'1363'} = 'G'; $location{'1363'} = 'HVIK';
$borough_number{'1365'} = '0219'; $type{'1365'} = 'G'; $location{'1365'} = 'BLOMMENHOLM';
$borough_number{'1366'} = '0219'; $type{'1366'} = 'G'; $location{'1366'} = 'LYSAKER';
$borough_number{'1367'} = '0219'; $type{'1367'} = 'G'; $location{'1367'} = 'SNARYA';
$borough_number{'1368'} = '0219'; $type{'1368'} = 'G'; $location{'1368'} = 'STABEKK';
$borough_number{'1369'} = '0219'; $type{'1369'} = 'G'; $location{'1369'} = 'STABEKK';
$borough_number{'1371'} = '0220'; $type{'1371'} = 'P'; $location{'1371'} = 'ASKER';
$borough_number{'1372'} = '0220'; $type{'1372'} = 'P'; $location{'1372'} = 'ASKER';
$borough_number{'1373'} = '0220'; $type{'1373'} = 'P'; $location{'1373'} = 'ASKER';
$borough_number{'1375'} = '0220'; $type{'1375'} = 'P'; $location{'1375'} = 'BILLINGSTAD';
$borough_number{'1376'} = '0220'; $type{'1376'} = 'P'; $location{'1376'} = 'BILLINGSTAD';
$borough_number{'1377'} = '0220'; $type{'1377'} = 'P'; $location{'1377'} = 'BILLINGSTAD';
$borough_number{'1378'} = '0220'; $type{'1378'} = 'P'; $location{'1378'} = 'NESBRU';
$borough_number{'1379'} = '0220'; $type{'1379'} = 'P'; $location{'1379'} = 'NESBRU';
$borough_number{'1380'} = '0220'; $type{'1380'} = 'P'; $location{'1380'} = 'HEGGEDAL';
$borough_number{'1381'} = '0220'; $type{'1381'} = 'P'; $location{'1381'} = 'VETTRE';
$borough_number{'1383'} = '0220'; $type{'1383'} = 'G'; $location{'1383'} = 'ASKER';
$borough_number{'1384'} = '0220'; $type{'1384'} = 'G'; $location{'1384'} = 'ASKER';
$borough_number{'1385'} = '0220'; $type{'1385'} = 'G'; $location{'1385'} = 'ASKER';
$borough_number{'1386'} = '0220'; $type{'1386'} = 'G'; $location{'1386'} = 'ASKER';
$borough_number{'1387'} = '0220'; $type{'1387'} = 'G'; $location{'1387'} = 'ASKER';
$borough_number{'1388'} = '0220'; $type{'1388'} = 'G'; $location{'1388'} = 'BORGEN';
$borough_number{'1389'} = '0220'; $type{'1389'} = 'G'; $location{'1389'} = 'HEGGEDAL';
$borough_number{'1390'} = '0220'; $type{'1390'} = 'G'; $location{'1390'} = 'VOLLEN';
$borough_number{'1391'} = '0220'; $type{'1391'} = 'G'; $location{'1391'} = 'VOLLEN';
$borough_number{'1392'} = '0220'; $type{'1392'} = 'G'; $location{'1392'} = 'VETTRE';
$borough_number{'1393'} = '0220'; $type{'1393'} = 'P'; $location{'1393'} = 'VOLLEN';
$borough_number{'1394'} = '0220'; $type{'1394'} = 'G'; $location{'1394'} = 'NESBRU';
$borough_number{'1395'} = '0220'; $type{'1395'} = 'G'; $location{'1395'} = 'HVALSTAD';
$borough_number{'1396'} = '0220'; $type{'1396'} = 'G'; $location{'1396'} = 'BILLINGSTAD';
$borough_number{'1397'} = '0220'; $type{'1397'} = 'G'; $location{'1397'} = 'NESYA';
$borough_number{'1399'} = '0220'; $type{'1399'} = 'P'; $location{'1399'} = 'ASKER';
$borough_number{'1400'} = '0213'; $type{'1400'} = 'G'; $location{'1400'} = 'SKI';
$borough_number{'1401'} = '0213'; $type{'1401'} = 'P'; $location{'1401'} = 'SKI';
$borough_number{'1402'} = '0213'; $type{'1402'} = 'P'; $location{'1402'} = 'SKI';
$borough_number{'1403'} = '0213'; $type{'1403'} = 'P'; $location{'1403'} = 'LANGHUS';
$borough_number{'1404'} = '0213'; $type{'1404'} = 'B'; $location{'1404'} = 'SIGGERUD';
$borough_number{'1405'} = '0213'; $type{'1405'} = 'G'; $location{'1405'} = 'LANGHUS';
$borough_number{'1406'} = '0213'; $type{'1406'} = 'G'; $location{'1406'} = 'SKI';
$borough_number{'1407'} = '0214'; $type{'1407'} = 'B'; $location{'1407'} = 'VINTERBRO';
$borough_number{'1408'} = '0213'; $type{'1408'} = 'G'; $location{'1408'} = 'KRKSTAD';
$borough_number{'1409'} = '0213'; $type{'1409'} = 'G'; $location{'1409'} = 'SKOTBU';
$borough_number{'1410'} = '0217'; $type{'1410'} = 'G'; $location{'1410'} = 'KOLBOTN';
$borough_number{'1411'} = '0217'; $type{'1411'} = 'P'; $location{'1411'} = 'KOLBOTN';
$borough_number{'1412'} = '0217'; $type{'1412'} = 'G'; $location{'1412'} = 'SOFIEMYR';
$borough_number{'1413'} = '0217'; $type{'1413'} = 'B'; $location{'1413'} = 'TRNSEN';
$borough_number{'1414'} = '0217'; $type{'1414'} = 'G'; $location{'1414'} = 'TROLLSEN';
$borough_number{'1415'} = '0217'; $type{'1415'} = 'G'; $location{'1415'} = 'OPPEGRD';
$borough_number{'1416'} = '0217'; $type{'1416'} = 'P'; $location{'1416'} = 'OPPEGRD';
$borough_number{'1417'} = '0217'; $type{'1417'} = 'P'; $location{'1417'} = 'SOFIEMYR';
$borough_number{'1419'} = '0217'; $type{'1419'} = 'P'; $location{'1419'} = 'OPPEGRD';
$borough_number{'1420'} = '0217'; $type{'1420'} = 'G'; $location{'1420'} = 'SVARTSKOG';
$borough_number{'1421'} = '0217'; $type{'1421'} = 'P'; $location{'1421'} = 'TROLLSEN';
$borough_number{'1430'} = '0214'; $type{'1430'} = 'G'; $location{'1430'} = 'S';
$borough_number{'1431'} = '0214'; $type{'1431'} = 'P'; $location{'1431'} = 'S';
$borough_number{'1432'} = '0214'; $type{'1432'} = 'F'; $location{'1432'} = 'S';
$borough_number{'1440'} = '0215'; $type{'1440'} = 'G'; $location{'1440'} = 'DRBAK';
$borough_number{'1441'} = '0215'; $type{'1441'} = 'P'; $location{'1441'} = 'DRBAK';
$borough_number{'1442'} = '0215'; $type{'1442'} = 'P'; $location{'1442'} = 'DRBAK';
$borough_number{'1443'} = '0215'; $type{'1443'} = 'G'; $location{'1443'} = 'OSCARSBORG';
$borough_number{'1444'} = '0215'; $type{'1444'} = 'K'; $location{'1444'} = 'SKIPHELLE';
$borough_number{'1445'} = '0215'; $type{'1445'} = 'G'; $location{'1445'} = 'HEER';
$borough_number{'1450'} = '0216'; $type{'1450'} = 'G'; $location{'1450'} = 'NESODDTANGEN';
$borough_number{'1451'} = '0216'; $type{'1451'} = 'P'; $location{'1451'} = 'NESODDTANGEN';
$borough_number{'1453'} = '0216'; $type{'1453'} = 'G'; $location{'1453'} = 'BJRNEMYR';
$borough_number{'1454'} = '0216'; $type{'1454'} = 'B'; $location{'1454'} = 'FAGERSTRAND';
$borough_number{'1455'} = '0215'; $type{'1455'} = 'G'; $location{'1455'} = 'NORDRE FROGN';
$borough_number{'1458'} = '0216'; $type{'1458'} = 'G'; $location{'1458'} = 'FJELLSTRAND';
$borough_number{'1459'} = '0216'; $type{'1459'} = 'P'; $location{'1459'} = 'FJELLSTRAND';
$borough_number{'1470'} = '0230'; $type{'1470'} = 'G'; $location{'1470'} = 'LRENSKOG';
$borough_number{'1471'} = '0230'; $type{'1471'} = 'P'; $location{'1471'} = 'LRENSKOG';
$borough_number{'1472'} = '0230'; $type{'1472'} = 'G'; $location{'1472'} = 'FJELLHAMAR';
$borough_number{'1473'} = '0230'; $type{'1473'} = 'G'; $location{'1473'} = 'LRENSKOG';
$borough_number{'1474'} = '0230'; $type{'1474'} = 'G'; $location{'1474'} = 'NORDBYHAGEN';
$borough_number{'1475'} = '0230'; $type{'1475'} = 'B'; $location{'1475'} = 'FINSTADJORDET';
$borough_number{'1476'} = '0230'; $type{'1476'} = 'B'; $location{'1476'} = 'RASTA';
$borough_number{'1477'} = '0230'; $type{'1477'} = 'P'; $location{'1477'} = 'FJELLHAMAR';
$borough_number{'1478'} = '0230'; $type{'1478'} = 'K'; $location{'1478'} = 'LRENSKOG';
$borough_number{'1480'} = '0233'; $type{'1480'} = 'G'; $location{'1480'} = 'SLATTUM';
$borough_number{'1481'} = '0233'; $type{'1481'} = 'G'; $location{'1481'} = 'HAGAN';
$borough_number{'1482'} = '0233'; $type{'1482'} = 'B'; $location{'1482'} = 'NITTEDAL';
$borough_number{'1483'} = '0233'; $type{'1483'} = 'P'; $location{'1483'} = 'SKYTTA';
$borough_number{'1484'} = '0233'; $type{'1484'} = 'G'; $location{'1484'} = 'HAKADAL';
$borough_number{'1485'} = '0233'; $type{'1485'} = 'P'; $location{'1485'} = 'HAKADAL';
$borough_number{'1487'} = '0233'; $type{'1487'} = 'B'; $location{'1487'} = 'HAKADAL';
$borough_number{'1488'} = '0233'; $type{'1488'} = 'G'; $location{'1488'} = 'HAKADAL';
$borough_number{'1501'} = '0104'; $type{'1501'} = 'P'; $location{'1501'} = 'MOSS';
$borough_number{'1502'} = '0104'; $type{'1502'} = 'P'; $location{'1502'} = 'MOSS';
$borough_number{'1503'} = '0104'; $type{'1503'} = 'P'; $location{'1503'} = 'MOSS';
$borough_number{'1506'} = '0104'; $type{'1506'} = 'P'; $location{'1506'} = 'MOSS';
$borough_number{'1509'} = '0104'; $type{'1509'} = 'P'; $location{'1509'} = 'MOSS';
$borough_number{'1510'} = '0104'; $type{'1510'} = 'P'; $location{'1510'} = 'MOSS';
$borough_number{'1511'} = '0104'; $type{'1511'} = 'G'; $location{'1511'} = 'MOSS';
$borough_number{'1512'} = '0104'; $type{'1512'} = 'G'; $location{'1512'} = 'MOSS';
$borough_number{'1513'} = '0104'; $type{'1513'} = 'G'; $location{'1513'} = 'MOSS';
$borough_number{'1514'} = '0104'; $type{'1514'} = 'G'; $location{'1514'} = 'MOSS';
$borough_number{'1515'} = '0104'; $type{'1515'} = 'G'; $location{'1515'} = 'MOSS';
$borough_number{'1516'} = '0104'; $type{'1516'} = 'G'; $location{'1516'} = 'MOSS';
$borough_number{'1517'} = '0104'; $type{'1517'} = 'G'; $location{'1517'} = 'MOSS';
$borough_number{'1518'} = '0104'; $type{'1518'} = 'G'; $location{'1518'} = 'MOSS';
$borough_number{'1519'} = '0104'; $type{'1519'} = 'G'; $location{'1519'} = 'MOSS';
$borough_number{'1520'} = '0136'; $type{'1520'} = 'P'; $location{'1520'} = 'MOSS';
$borough_number{'1521'} = '0136'; $type{'1521'} = 'P'; $location{'1521'} = 'MOSS';
$borough_number{'1522'} = '0136'; $type{'1522'} = 'P'; $location{'1522'} = 'MOSS';
$borough_number{'1523'} = '0104'; $type{'1523'} = 'G'; $location{'1523'} = 'MOSS';
$borough_number{'1524'} = '0104'; $type{'1524'} = 'G'; $location{'1524'} = 'MOSS';
$borough_number{'1525'} = '0136'; $type{'1525'} = 'G'; $location{'1525'} = 'MOSS';
$borough_number{'1526'} = '0136'; $type{'1526'} = 'G'; $location{'1526'} = 'MOSS';
$borough_number{'1528'} = '0136'; $type{'1528'} = 'G'; $location{'1528'} = 'MOSS';
$borough_number{'1529'} = '0136'; $type{'1529'} = 'G'; $location{'1529'} = 'MOSS';
$borough_number{'1530'} = '0104'; $type{'1530'} = 'G'; $location{'1530'} = 'MOSS';
$borough_number{'1531'} = '0104'; $type{'1531'} = 'G'; $location{'1531'} = 'MOSS';
$borough_number{'1532'} = '0104'; $type{'1532'} = 'G'; $location{'1532'} = 'MOSS';
$borough_number{'1533'} = '0104'; $type{'1533'} = 'G'; $location{'1533'} = 'MOSS';
$borough_number{'1534'} = '0104'; $type{'1534'} = 'G'; $location{'1534'} = 'MOSS';
$borough_number{'1535'} = '0104'; $type{'1535'} = 'G'; $location{'1535'} = 'MOSS';
$borough_number{'1536'} = '0104'; $type{'1536'} = 'G'; $location{'1536'} = 'MOSS';
$borough_number{'1537'} = '0104'; $type{'1537'} = 'G'; $location{'1537'} = 'MOSS';
$borough_number{'1538'} = '0104'; $type{'1538'} = 'G'; $location{'1538'} = 'MOSS';
$borough_number{'1539'} = '0104'; $type{'1539'} = 'G'; $location{'1539'} = 'MOSS';
$borough_number{'1540'} = '0211'; $type{'1540'} = 'G'; $location{'1540'} = 'VESTBY';
$borough_number{'1541'} = '0211'; $type{'1541'} = 'P'; $location{'1541'} = 'VESTBY';
$borough_number{'1545'} = '0211'; $type{'1545'} = 'G'; $location{'1545'} = 'HVITSTEN';
$borough_number{'1550'} = '0211'; $type{'1550'} = 'B'; $location{'1550'} = 'HLEN';
$borough_number{'1555'} = '0211'; $type{'1555'} = 'G'; $location{'1555'} = 'SON';
$borough_number{'1556'} = '0211'; $type{'1556'} = 'P'; $location{'1556'} = 'SON';
$borough_number{'1560'} = '0136'; $type{'1560'} = 'B'; $location{'1560'} = 'LARKOLLEN';
$borough_number{'1570'} = '0136'; $type{'1570'} = 'G'; $location{'1570'} = 'DILLING';
$borough_number{'1580'} = '0136'; $type{'1580'} = 'G'; $location{'1580'} = 'RYGGE';
$borough_number{'1581'} = '0136'; $type{'1581'} = 'P'; $location{'1581'} = 'RYGGE';
$borough_number{'1590'} = '0136'; $type{'1590'} = 'K'; $location{'1590'} = 'RYGGE FLYSTASJON';
$borough_number{'1591'} = '0137'; $type{'1591'} = 'G'; $location{'1591'} = 'SPERREBOTN';
$borough_number{'1592'} = '0137'; $type{'1592'} = 'B'; $location{'1592'} = 'VLER I STFOLD';
$borough_number{'1593'} = '0137'; $type{'1593'} = 'B'; $location{'1593'} = 'SVINNDAL';
$borough_number{'1596'} = '0104'; $type{'1596'} = 'G'; $location{'1596'} = 'MOSS';
$borough_number{'1597'} = '0104'; $type{'1597'} = 'G'; $location{'1597'} = 'MOSS';
$borough_number{'1598'} = '0104'; $type{'1598'} = 'G'; $location{'1598'} = 'MOSS';
$borough_number{'1599'} = '0104'; $type{'1599'} = 'G'; $location{'1599'} = 'MOSS';
$borough_number{'1601'} = '0106'; $type{'1601'} = 'P'; $location{'1601'} = 'FREDRIKSTAD';
$borough_number{'1602'} = '0106'; $type{'1602'} = 'S'; $location{'1602'} = 'FREDRIKSTAD';
$borough_number{'1603'} = '0106'; $type{'1603'} = 'K'; $location{'1603'} = 'FREDRIKSTAD';
$borough_number{'1604'} = '0106'; $type{'1604'} = 'G'; $location{'1604'} = 'FREDRIKSTAD';
$borough_number{'1605'} = '0106'; $type{'1605'} = 'G'; $location{'1605'} = 'FREDRIKSTAD';
$borough_number{'1606'} = '0106'; $type{'1606'} = 'G'; $location{'1606'} = 'FREDRIKSTAD';
$borough_number{'1607'} = '0106'; $type{'1607'} = 'G'; $location{'1607'} = 'FREDRIKSTAD';
$borough_number{'1608'} = '0106'; $type{'1608'} = 'G'; $location{'1608'} = 'FREDRIKSTAD';
$borough_number{'1609'} = '0106'; $type{'1609'} = 'P'; $location{'1609'} = 'FREDRIKSTAD';
$borough_number{'1610'} = '0106'; $type{'1610'} = 'G'; $location{'1610'} = 'FREDRIKSTAD';
$borough_number{'1612'} = '0106'; $type{'1612'} = 'P'; $location{'1612'} = 'FREDRIKSTAD';
$borough_number{'1613'} = '0106'; $type{'1613'} = 'G'; $location{'1613'} = 'FREDRIKSTAD';
$borough_number{'1614'} = '0106'; $type{'1614'} = 'G'; $location{'1614'} = 'FREDRIKSTAD';
$borough_number{'1615'} = '0106'; $type{'1615'} = 'G'; $location{'1615'} = 'FREDRIKSTAD';
$borough_number{'1616'} = '0106'; $type{'1616'} = 'P'; $location{'1616'} = 'FREDRIKSTAD';
$borough_number{'1617'} = '0106'; $type{'1617'} = 'G'; $location{'1617'} = 'FREDRIKSTAD';
$borough_number{'1618'} = '0106'; $type{'1618'} = 'G'; $location{'1618'} = 'FREDRIKSTAD';
$borough_number{'1619'} = '0106'; $type{'1619'} = 'G'; $location{'1619'} = 'FREDRIKSTAD';
$borough_number{'1620'} = '0106'; $type{'1620'} = 'P'; $location{'1620'} = 'GRESSVIK';
$borough_number{'1621'} = '0106'; $type{'1621'} = 'B'; $location{'1621'} = 'GRESSVIK';
$borough_number{'1624'} = '0106'; $type{'1624'} = 'G'; $location{'1624'} = 'GRESSVIK';
$borough_number{'1625'} = '0106'; $type{'1625'} = 'P'; $location{'1625'} = 'MANSTAD';
$borough_number{'1626'} = '0106'; $type{'1626'} = 'G'; $location{'1626'} = 'MANSTAD';
$borough_number{'1628'} = '0106'; $type{'1628'} = 'G'; $location{'1628'} = 'ENGELSVIKEN';
$borough_number{'1629'} = '0106'; $type{'1629'} = 'P'; $location{'1629'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1630'} = '0106'; $type{'1630'} = 'G'; $location{'1630'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1632'} = '0106'; $type{'1632'} = 'G'; $location{'1632'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1633'} = '0106'; $type{'1633'} = 'G'; $location{'1633'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1634'} = '0106'; $type{'1634'} = 'G'; $location{'1634'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1636'} = '0106'; $type{'1636'} = 'G'; $location{'1636'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1637'} = '0106'; $type{'1637'} = 'G'; $location{'1637'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1638'} = '0106'; $type{'1638'} = 'P'; $location{'1638'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1639'} = '0106'; $type{'1639'} = 'G'; $location{'1639'} = 'GAMLE FREDRIKSTAD';
$borough_number{'1640'} = '0135'; $type{'1640'} = 'G'; $location{'1640'} = 'RDE';
$borough_number{'1641'} = '0135'; $type{'1641'} = 'P'; $location{'1641'} = 'RDE';
$borough_number{'1642'} = '0135'; $type{'1642'} = 'B'; $location{'1642'} = 'SALTNES';
$borough_number{'1650'} = '0106'; $type{'1650'} = 'P'; $location{'1650'} = 'SELLEBAKK';
$borough_number{'1651'} = '0106'; $type{'1651'} = 'G'; $location{'1651'} = 'SELLEBAKK';
$borough_number{'1653'} = '0106'; $type{'1653'} = 'G'; $location{'1653'} = 'SELLEBAKK';
$borough_number{'1654'} = '0106'; $type{'1654'} = 'G'; $location{'1654'} = 'SELLEBAKK';
$borough_number{'1655'} = '0106'; $type{'1655'} = 'G'; $location{'1655'} = 'SELLEBAKK';
$borough_number{'1657'} = '0106'; $type{'1657'} = 'G'; $location{'1657'} = 'TORP';
$borough_number{'1658'} = '0106'; $type{'1658'} = 'G'; $location{'1658'} = 'TORP';
$borough_number{'1659'} = '0106'; $type{'1659'} = 'G'; $location{'1659'} = 'TORP';
$borough_number{'1661'} = '0106'; $type{'1661'} = 'G'; $location{'1661'} = 'ROLVSY';
$borough_number{'1662'} = '0106'; $type{'1662'} = 'P'; $location{'1662'} = 'ROLVSY';
$borough_number{'1663'} = '0106'; $type{'1663'} = 'G'; $location{'1663'} = 'ROLVSY';
$borough_number{'1664'} = '0106'; $type{'1664'} = 'G'; $location{'1664'} = 'ROLVSY';
$borough_number{'1665'} = '0106'; $type{'1665'} = 'G'; $location{'1665'} = 'ROLVSY';
$borough_number{'1666'} = '0106'; $type{'1666'} = 'G'; $location{'1666'} = 'ROLVSY';
$borough_number{'1667'} = '0106'; $type{'1667'} = 'G'; $location{'1667'} = 'ROLVSY';
$borough_number{'1670'} = '0106'; $type{'1670'} = 'P'; $location{'1670'} = 'KRKERY';
$borough_number{'1671'} = '0106'; $type{'1671'} = 'G'; $location{'1671'} = 'KRKERY';
$borough_number{'1672'} = '0106'; $type{'1672'} = 'G'; $location{'1672'} = 'KRKERY';
$borough_number{'1673'} = '0106'; $type{'1673'} = 'G'; $location{'1673'} = 'KRKERY';
$borough_number{'1675'} = '0106'; $type{'1675'} = 'G'; $location{'1675'} = 'KRKERY';
$borough_number{'1676'} = '0106'; $type{'1676'} = 'G'; $location{'1676'} = 'KRKERY';
$borough_number{'1678'} = '0106'; $type{'1678'} = 'G'; $location{'1678'} = 'KRKERY';
$borough_number{'1679'} = '0106'; $type{'1679'} = 'G'; $location{'1679'} = 'KRKERY';
$borough_number{'1680'} = '0111'; $type{'1680'} = 'G'; $location{'1680'} = 'SKJRHALLEN';
$borough_number{'1682'} = '0111'; $type{'1682'} = 'P'; $location{'1682'} = 'SKJRHALLEN';
$borough_number{'1683'} = '0111'; $type{'1683'} = 'P'; $location{'1683'} = 'VESTERY';
$borough_number{'1684'} = '0111'; $type{'1684'} = 'G'; $location{'1684'} = 'VESTERY';
$borough_number{'1690'} = '0111'; $type{'1690'} = 'G'; $location{'1690'} = 'HERFL';
$borough_number{'1692'} = '0111'; $type{'1692'} = 'G'; $location{'1692'} = 'NEDGRDEN';
$borough_number{'1701'} = '0105'; $type{'1701'} = 'P'; $location{'1701'} = 'SARPSBORG';
$borough_number{'1702'} = '0105'; $type{'1702'} = 'P'; $location{'1702'} = 'SARPSBORG';
$borough_number{'1703'} = '0105'; $type{'1703'} = 'P'; $location{'1703'} = 'SARPSBORG';
$borough_number{'1704'} = '0105'; $type{'1704'} = 'P'; $location{'1704'} = 'SARPSBORG';
$borough_number{'1705'} = '0105'; $type{'1705'} = 'P'; $location{'1705'} = 'SARPSBORG';
$borough_number{'1706'} = '0105'; $type{'1706'} = 'G'; $location{'1706'} = 'SARPSBORG';
$borough_number{'1707'} = '0105'; $type{'1707'} = 'G'; $location{'1707'} = 'SARPSBORG';
$borough_number{'1708'} = '0105'; $type{'1708'} = 'G'; $location{'1708'} = 'SARPSBORG';
$borough_number{'1709'} = '0105'; $type{'1709'} = 'G'; $location{'1709'} = 'SARPSBORG';
$borough_number{'1710'} = '0105'; $type{'1710'} = 'G'; $location{'1710'} = 'SARPSBORG';
$borough_number{'1711'} = '0105'; $type{'1711'} = 'G'; $location{'1711'} = 'SARPSBORG';
$borough_number{'1712'} = '0105'; $type{'1712'} = 'G'; $location{'1712'} = 'GRLUM';
$borough_number{'1713'} = '0105'; $type{'1713'} = 'P'; $location{'1713'} = 'GRLUM';
$borough_number{'1714'} = '0105'; $type{'1714'} = 'S'; $location{'1714'} = 'SARPSBORG';
$borough_number{'1715'} = '0105'; $type{'1715'} = 'G'; $location{'1715'} = 'YVEN';
$borough_number{'1718'} = '0105'; $type{'1718'} = 'G'; $location{'1718'} = 'GREKER';
$borough_number{'1719'} = '0105'; $type{'1719'} = 'G'; $location{'1719'} = 'GREKER';
$borough_number{'1720'} = '0105'; $type{'1720'} = 'P'; $location{'1720'} = 'GREKER';
$borough_number{'1721'} = '0105'; $type{'1721'} = 'G'; $location{'1721'} = 'SARPSBORG';
$borough_number{'1722'} = '0105'; $type{'1722'} = 'G'; $location{'1722'} = 'SARPSBORG';
$borough_number{'1723'} = '0105'; $type{'1723'} = 'G'; $location{'1723'} = 'SARPSBORG';
$borough_number{'1724'} = '0105'; $type{'1724'} = 'G'; $location{'1724'} = 'SARPSBORG';
$borough_number{'1725'} = '0105'; $type{'1725'} = 'G'; $location{'1725'} = 'SARPSBORG';
$borough_number{'1726'} = '0105'; $type{'1726'} = 'G'; $location{'1726'} = 'SARPSBORG';
$borough_number{'1727'} = '0105'; $type{'1727'} = 'G'; $location{'1727'} = 'SARPSBORG';
$borough_number{'1730'} = '0105'; $type{'1730'} = 'B'; $location{'1730'} = 'ISE';
$borough_number{'1733'} = '0105'; $type{'1733'} = 'P'; $location{'1733'} = 'HAFSLUNDSY';
$borough_number{'1734'} = '0105'; $type{'1734'} = 'G'; $location{'1734'} = 'HAFSLUNDSY';
$borough_number{'1735'} = '0105'; $type{'1735'} = 'G'; $location{'1735'} = 'VARTEIG';
$borough_number{'1738'} = '0105'; $type{'1738'} = 'G'; $location{'1738'} = 'BORGENHAUGEN';
$borough_number{'1739'} = '0105'; $type{'1739'} = 'G'; $location{'1739'} = 'BORGENHAUGEN';
$borough_number{'1740'} = '0105'; $type{'1740'} = 'P'; $location{'1740'} = 'BORGENHAUGEN';
$borough_number{'1742'} = '0105'; $type{'1742'} = 'P'; $location{'1742'} = 'KLAVESTADHAUGEN';
$borough_number{'1743'} = '0105'; $type{'1743'} = 'G'; $location{'1743'} = 'KLAVESTADHAUGEN';
$borough_number{'1745'} = '0105'; $type{'1745'} = 'P'; $location{'1745'} = 'SKJEBERG';
$borough_number{'1746'} = '0105'; $type{'1746'} = 'G'; $location{'1746'} = 'SKJEBERG';
$borough_number{'1747'} = '0105'; $type{'1747'} = 'G'; $location{'1747'} = 'SKJEBERG';
$borough_number{'1751'} = '0101'; $type{'1751'} = 'P'; $location{'1751'} = 'HALDEN';
$borough_number{'1752'} = '0101'; $type{'1752'} = 'P'; $location{'1752'} = 'HALDEN';
$borough_number{'1753'} = '0101'; $type{'1753'} = 'P'; $location{'1753'} = 'HALDEN';
$borough_number{'1754'} = '0101'; $type{'1754'} = 'P'; $location{'1754'} = 'HALDEN';
$borough_number{'1756'} = '0101'; $type{'1756'} = 'K'; $location{'1756'} = 'HALDEN';
$borough_number{'1757'} = '0101'; $type{'1757'} = 'K'; $location{'1757'} = 'HALDEN';
$borough_number{'1758'} = '0101'; $type{'1758'} = 'K'; $location{'1758'} = 'HALDEN';
$borough_number{'1760'} = '0101'; $type{'1760'} = 'P'; $location{'1760'} = 'HALDEN';
$borough_number{'1761'} = '0101'; $type{'1761'} = 'P'; $location{'1761'} = 'HALDEN';
$borough_number{'1763'} = '0101'; $type{'1763'} = 'G'; $location{'1763'} = 'HALDEN';
$borough_number{'1764'} = '0101'; $type{'1764'} = 'G'; $location{'1764'} = 'HALDEN';
$borough_number{'1765'} = '0101'; $type{'1765'} = 'G'; $location{'1765'} = 'HALDEN';
$borough_number{'1766'} = '0101'; $type{'1766'} = 'G'; $location{'1766'} = 'HALDEN';
$borough_number{'1767'} = '0101'; $type{'1767'} = 'G'; $location{'1767'} = 'HALDEN';
$borough_number{'1768'} = '0101'; $type{'1768'} = 'G'; $location{'1768'} = 'HALDEN';
$borough_number{'1769'} = '0101'; $type{'1769'} = 'G'; $location{'1769'} = 'HALDEN';
$borough_number{'1771'} = '0101'; $type{'1771'} = 'G'; $location{'1771'} = 'HALDEN';
$borough_number{'1772'} = '0101'; $type{'1772'} = 'G'; $location{'1772'} = 'HALDEN';
$borough_number{'1776'} = '0101'; $type{'1776'} = 'G'; $location{'1776'} = 'HALDEN';
$borough_number{'1777'} = '0101'; $type{'1777'} = 'G'; $location{'1777'} = 'HALDEN';
$borough_number{'1778'} = '0101'; $type{'1778'} = 'G'; $location{'1778'} = 'HALDEN';
$borough_number{'1779'} = '0101'; $type{'1779'} = 'G'; $location{'1779'} = 'HALDEN';
$borough_number{'1781'} = '0101'; $type{'1781'} = 'G'; $location{'1781'} = 'HALDEN';
$borough_number{'1782'} = '0101'; $type{'1782'} = 'G'; $location{'1782'} = 'HALDEN';
$borough_number{'1783'} = '0101'; $type{'1783'} = 'G'; $location{'1783'} = 'HALDEN';
$borough_number{'1784'} = '0101'; $type{'1784'} = 'G'; $location{'1784'} = 'HALDEN';
$borough_number{'1785'} = '0101'; $type{'1785'} = 'G'; $location{'1785'} = 'HALDEN';
$borough_number{'1786'} = '0101'; $type{'1786'} = 'G'; $location{'1786'} = 'HALDEN';
$borough_number{'1787'} = '0101'; $type{'1787'} = 'P'; $location{'1787'} = 'BERG I STFOLD';
$borough_number{'1788'} = '0101'; $type{'1788'} = 'G'; $location{'1788'} = 'BERG I STFOLD';
$borough_number{'1789'} = '0101'; $type{'1789'} = 'G'; $location{'1789'} = 'BERG I STFOLD';
$borough_number{'1790'} = '0101'; $type{'1790'} = 'P'; $location{'1790'} = 'TISTEDAL';
$borough_number{'1791'} = '0101'; $type{'1791'} = 'G'; $location{'1791'} = 'TISTEDAL';
$borough_number{'1792'} = '0101'; $type{'1792'} = 'G'; $location{'1792'} = 'TISTEDAL';
$borough_number{'1793'} = '0101'; $type{'1793'} = 'G'; $location{'1793'} = 'TISTEDAL';
$borough_number{'1794'} = '0101'; $type{'1794'} = 'G'; $location{'1794'} = 'SPONVIKA';
$borough_number{'1796'} = '0101'; $type{'1796'} = 'G'; $location{'1796'} = 'KORNSJ';
$borough_number{'1798'} = '0118'; $type{'1798'} = 'G'; $location{'1798'} = 'AREMARK';
$borough_number{'1799'} = '0118'; $type{'1799'} = 'P'; $location{'1799'} = 'AREMARK';
$borough_number{'1801'} = '0124'; $type{'1801'} = 'P'; $location{'1801'} = 'ASKIM';
$borough_number{'1802'} = '0124'; $type{'1802'} = 'P'; $location{'1802'} = 'ASKIM';
$borough_number{'1803'} = '0124'; $type{'1803'} = 'P'; $location{'1803'} = 'ASKIM';
$borough_number{'1804'} = '0123'; $type{'1804'} = 'P'; $location{'1804'} = 'SPYDEBERG';
$borough_number{'1805'} = '0138'; $type{'1805'} = 'P'; $location{'1805'} = 'TOMTER';
$borough_number{'1806'} = '0127'; $type{'1806'} = 'P'; $location{'1806'} = 'SKIPTVET';
$borough_number{'1807'} = '0124'; $type{'1807'} = 'G'; $location{'1807'} = 'ASKIM';
$borough_number{'1808'} = '0124'; $type{'1808'} = 'G'; $location{'1808'} = 'ASKIM';
$borough_number{'1809'} = '0124'; $type{'1809'} = 'G'; $location{'1809'} = 'ASKIM';
$borough_number{'1811'} = '0124'; $type{'1811'} = 'G'; $location{'1811'} = 'ASKIM';
$borough_number{'1812'} = '0124'; $type{'1812'} = 'G'; $location{'1812'} = 'ASKIM';
$borough_number{'1813'} = '0124'; $type{'1813'} = 'G'; $location{'1813'} = 'ASKIM';
$borough_number{'1814'} = '0124'; $type{'1814'} = 'G'; $location{'1814'} = 'ASKIM';
$borough_number{'1815'} = '0124'; $type{'1815'} = 'G'; $location{'1815'} = 'ASKIM';
$borough_number{'1816'} = '0127'; $type{'1816'} = 'G'; $location{'1816'} = 'SKIPTVET';
$borough_number{'1820'} = '0123'; $type{'1820'} = 'G'; $location{'1820'} = 'SPYDEBERG';
$borough_number{'1823'} = '0138'; $type{'1823'} = 'G'; $location{'1823'} = 'KNAPSTAD';
$borough_number{'1825'} = '0138'; $type{'1825'} = 'G'; $location{'1825'} = 'TOMTER';
$borough_number{'1827'} = '0138'; $type{'1827'} = 'B'; $location{'1827'} = 'HOBL';
$borough_number{'1830'} = '0124'; $type{'1830'} = 'G'; $location{'1830'} = 'ASKIM';
$borough_number{'1831'} = '0124'; $type{'1831'} = 'G'; $location{'1831'} = 'ASKIM';
$borough_number{'1832'} = '0124'; $type{'1832'} = 'G'; $location{'1832'} = 'ASKIM';
$borough_number{'1850'} = '0125'; $type{'1850'} = 'G'; $location{'1850'} = 'MYSEN';
$borough_number{'1851'} = '0125'; $type{'1851'} = 'P'; $location{'1851'} = 'MYSEN';
$borough_number{'1859'} = '0125'; $type{'1859'} = 'G'; $location{'1859'} = 'SLITU';
$borough_number{'1860'} = '0122'; $type{'1860'} = 'G'; $location{'1860'} = 'TRGSTAD';
$borough_number{'1861'} = '0122'; $type{'1861'} = 'P'; $location{'1861'} = 'TRGSTAD';
$borough_number{'1866'} = '0122'; $type{'1866'} = 'G'; $location{'1866'} = 'BSTAD';
$borough_number{'1867'} = '0122'; $type{'1867'} = 'P'; $location{'1867'} = 'BSTAD';
$borough_number{'1870'} = '0119'; $type{'1870'} = 'G'; $location{'1870'} = 'RJE';
$borough_number{'1871'} = '0119'; $type{'1871'} = 'P'; $location{'1871'} = 'RJE';
$borough_number{'1875'} = '0119'; $type{'1875'} = 'G'; $location{'1875'} = 'OTTEID';
$borough_number{'1878'} = '0125'; $type{'1878'} = 'G'; $location{'1878'} = 'HRLAND';
$borough_number{'1880'} = '0125'; $type{'1880'} = 'G'; $location{'1880'} = 'EIDSBERG';
$borough_number{'1890'} = '0128'; $type{'1890'} = 'G'; $location{'1890'} = 'RAKKESTAD';
$borough_number{'1891'} = '0128'; $type{'1891'} = 'P'; $location{'1891'} = 'RAKKESTAD';
$borough_number{'1892'} = '0128'; $type{'1892'} = 'G'; $location{'1892'} = 'DEGERNES';
$borough_number{'1893'} = '0128'; $type{'1893'} = 'P'; $location{'1893'} = 'DEGERNES';
$borough_number{'1900'} = '0227'; $type{'1900'} = 'G'; $location{'1900'} = 'FETSUND';
$borough_number{'1901'} = '0227'; $type{'1901'} = 'P'; $location{'1901'} = 'FETSUND';
$borough_number{'1903'} = '0227'; $type{'1903'} = 'G'; $location{'1903'} = 'GAN';
$borough_number{'1910'} = '0227'; $type{'1910'} = 'G'; $location{'1910'} = 'ENEBAKKNESET';
$borough_number{'1911'} = '0229'; $type{'1911'} = 'B'; $location{'1911'} = 'FLATEBY';
$borough_number{'1912'} = '0229'; $type{'1912'} = 'B'; $location{'1912'} = 'ENEBAKK';
$borough_number{'1914'} = '0229'; $type{'1914'} = 'B'; $location{'1914'} = 'YTRE ENEBAKK';
$borough_number{'1920'} = '0226'; $type{'1920'} = 'G'; $location{'1920'} = 'SRUMSAND';
$borough_number{'1921'} = '0226'; $type{'1921'} = 'P'; $location{'1921'} = 'SRUMSAND';
$borough_number{'1923'} = '0226'; $type{'1923'} = 'B'; $location{'1923'} = 'SRUM';
$borough_number{'1925'} = '0226'; $type{'1925'} = 'G'; $location{'1925'} = 'BLAKER';
$borough_number{'1927'} = '0226'; $type{'1927'} = 'G'; $location{'1927'} = 'RNSFOSS';
$borough_number{'1929'} = '0236'; $type{'1929'} = 'B'; $location{'1929'} = 'AULI';
$borough_number{'1930'} = '0221'; $type{'1930'} = 'B'; $location{'1930'} = 'AURSKOG';
$borough_number{'1940'} = '0221'; $type{'1940'} = 'G'; $location{'1940'} = 'BJRKELANGEN';
$borough_number{'1941'} = '0221'; $type{'1941'} = 'P'; $location{'1941'} = 'BJRKELANGEN';
$borough_number{'1950'} = '0121'; $type{'1950'} = 'G'; $location{'1950'} = 'RMSKOG';
$borough_number{'1954'} = '0221'; $type{'1954'} = 'G'; $location{'1954'} = 'SETSKOG';
$borough_number{'1960'} = '0221'; $type{'1960'} = 'B'; $location{'1960'} = 'LKEN';
$borough_number{'1963'} = '0221'; $type{'1963'} = 'G'; $location{'1963'} = 'FOSSER';
$borough_number{'1970'} = '0221'; $type{'1970'} = 'B'; $location{'1970'} = 'HEMNES';
$borough_number{'2000'} = '0231'; $type{'2000'} = 'G'; $location{'2000'} = 'LILLESTRM';
$borough_number{'2001'} = '0231'; $type{'2001'} = 'P'; $location{'2001'} = 'LILLESTRM';
$borough_number{'2003'} = '0231'; $type{'2003'} = 'G'; $location{'2003'} = 'LILLESTRM';
$borough_number{'2004'} = '0231'; $type{'2004'} = 'G'; $location{'2004'} = 'LILLESTRM';
$borough_number{'2005'} = '0228'; $type{'2005'} = 'B'; $location{'2005'} = 'RLINGEN';
$borough_number{'2006'} = '0228'; $type{'2006'} = 'B'; $location{'2006'} = 'LVENSTAD';
$borough_number{'2007'} = '0231'; $type{'2007'} = 'G'; $location{'2007'} = 'KJELLER';
$borough_number{'2008'} = '0228'; $type{'2008'} = 'G'; $location{'2008'} = 'FJERDINGBY';
$borough_number{'2009'} = '0228'; $type{'2009'} = 'G'; $location{'2009'} = 'NORDBY';
$borough_number{'2010'} = '0231'; $type{'2010'} = 'G'; $location{'2010'} = 'STRMMEN';
$borough_number{'2011'} = '0231'; $type{'2011'} = 'P'; $location{'2011'} = 'STRMMEN';
$borough_number{'2012'} = '0231'; $type{'2012'} = 'P'; $location{'2012'} = 'LILLESTRM';
$borough_number{'2013'} = '0231'; $type{'2013'} = 'G'; $location{'2013'} = 'SKJETTEN';
$borough_number{'2014'} = '0228'; $type{'2014'} = 'G'; $location{'2014'} = 'BLYSTADLIA';
$borough_number{'2015'} = '0231'; $type{'2015'} = 'G'; $location{'2015'} = 'LEIRSUND';
$borough_number{'2016'} = '0226'; $type{'2016'} = 'B'; $location{'2016'} = 'FROGNER';
$borough_number{'2019'} = '0231'; $type{'2019'} = 'G'; $location{'2019'} = 'SKEDSMOKORSET';
$borough_number{'2020'} = '0231'; $type{'2020'} = 'G'; $location{'2020'} = 'SKEDSMOKORSET';
$borough_number{'2021'} = '0231'; $type{'2021'} = 'P'; $location{'2021'} = 'SKEDSMOKORSET';
$borough_number{'2022'} = '0234'; $type{'2022'} = 'G'; $location{'2022'} = 'GJERDRUM';
$borough_number{'2024'} = '0234'; $type{'2024'} = 'P'; $location{'2024'} = 'GJERDRUM';
$borough_number{'2025'} = '0228'; $type{'2025'} = 'P'; $location{'2025'} = 'FJERDINGBY';
$borough_number{'2026'} = '0231'; $type{'2026'} = 'P'; $location{'2026'} = 'SKJETTEN';
$borough_number{'2027'} = '0231'; $type{'2027'} = 'P'; $location{'2027'} = 'KJELLER';
$borough_number{'2030'} = '0238'; $type{'2030'} = 'G'; $location{'2030'} = 'NANNESTAD';
$borough_number{'2031'} = '0238'; $type{'2031'} = 'P'; $location{'2031'} = 'NANNESTAD';
$borough_number{'2032'} = '0238'; $type{'2032'} = 'B'; $location{'2032'} = 'MAURA';
$borough_number{'2033'} = '0238'; $type{'2033'} = 'G'; $location{'2033'} = 'SGREINA';
$borough_number{'2034'} = '0238'; $type{'2034'} = 'B'; $location{'2034'} = 'HOLTER';
$borough_number{'2040'} = '0235'; $type{'2040'} = 'G'; $location{'2040'} = 'KLFTA';
$borough_number{'2041'} = '0235'; $type{'2041'} = 'P'; $location{'2041'} = 'KLFTA';
$borough_number{'2050'} = '0235'; $type{'2050'} = 'G'; $location{'2050'} = 'JESSHEIM';
$borough_number{'2051'} = '0235'; $type{'2051'} = 'P'; $location{'2051'} = 'JESSHEIM';
$borough_number{'2052'} = '0235'; $type{'2052'} = 'G'; $location{'2052'} = 'JESSHEIM';
$borough_number{'2054'} = '0235'; $type{'2054'} = 'G'; $location{'2054'} = 'MOGREINA';
$borough_number{'2055'} = '0235'; $type{'2055'} = 'G'; $location{'2055'} = 'NORDKISA';
$borough_number{'2056'} = '0235'; $type{'2056'} = 'G'; $location{'2056'} = 'ALGARHEIM';
$borough_number{'2057'} = '0235'; $type{'2057'} = 'P'; $location{'2057'} = 'JESSHEIM';
$borough_number{'2058'} = '0235'; $type{'2058'} = 'K'; $location{'2058'} = 'SESSVOLLMOEN';
$borough_number{'2059'} = '0235'; $type{'2059'} = 'K'; $location{'2059'} = 'TRANDUM';
$borough_number{'2060'} = '0235'; $type{'2060'} = 'G'; $location{'2060'} = 'GARDERMOEN';
$borough_number{'2061'} = '0235'; $type{'2061'} = 'P'; $location{'2061'} = 'GARDERMOEN';
$borough_number{'2065'} = '0235'; $type{'2065'} = 'P'; $location{'2065'} = 'GARDERMOEN';
$borough_number{'2070'} = '0237'; $type{'2070'} = 'G'; $location{'2070'} = 'RHOLT';
$borough_number{'2071'} = '0237'; $type{'2071'} = 'P'; $location{'2071'} = 'RHOLT';
$borough_number{'2072'} = '0237'; $type{'2072'} = 'G'; $location{'2072'} = 'DAL';
$borough_number{'2073'} = '0237'; $type{'2073'} = 'G'; $location{'2073'} = 'BN';
$borough_number{'2074'} = '0237'; $type{'2074'} = 'G'; $location{'2074'} = 'EIDSVOLL VERK';
$borough_number{'2076'} = '0237'; $type{'2076'} = 'P'; $location{'2076'} = 'DAL';
$borough_number{'2080'} = '0237'; $type{'2080'} = 'G'; $location{'2080'} = 'EIDSVOLL';
$borough_number{'2081'} = '0237'; $type{'2081'} = 'P'; $location{'2081'} = 'EIDSVOLL';
$borough_number{'2090'} = '0239'; $type{'2090'} = 'G'; $location{'2090'} = 'HURDAL';
$borough_number{'2091'} = '0239'; $type{'2091'} = 'P'; $location{'2091'} = 'HURDAL';
$borough_number{'2092'} = '0237'; $type{'2092'} = 'B'; $location{'2092'} = 'MINNESUND';
$borough_number{'2093'} = '0237'; $type{'2093'} = 'G'; $location{'2093'} = 'FEIRING';
$borough_number{'2100'} = '0419'; $type{'2100'} = 'G'; $location{'2100'} = 'SKARNES';
$borough_number{'2101'} = '0419'; $type{'2101'} = 'P'; $location{'2101'} = 'SKARNES';
$borough_number{'2110'} = '0419'; $type{'2110'} = 'G'; $location{'2110'} = 'SLSTAD';
$borough_number{'2114'} = '0419'; $type{'2114'} = 'G'; $location{'2114'} = 'DISEN';
$borough_number{'2116'} = '0419'; $type{'2116'} = 'G'; $location{'2116'} = 'SANDER';
$borough_number{'2120'} = '0418'; $type{'2120'} = 'B'; $location{'2120'} = 'SAGSTUA';
$borough_number{'2123'} = '0418'; $type{'2123'} = 'G'; $location{'2123'} = 'BRUVOLL';
$borough_number{'2130'} = '0418'; $type{'2130'} = 'B'; $location{'2130'} = 'KNAPPER';
$borough_number{'2133'} = '0418'; $type{'2133'} = 'B'; $location{'2133'} = 'GARDVIK';
$borough_number{'2134'} = '0418'; $type{'2134'} = 'G'; $location{'2134'} = 'AUSTVATN';
$borough_number{'2150'} = '0236'; $type{'2150'} = 'G'; $location{'2150'} = 'RNES';
$borough_number{'2151'} = '0236'; $type{'2151'} = 'P'; $location{'2151'} = 'RNES';
$borough_number{'2160'} = '0236'; $type{'2160'} = 'B'; $location{'2160'} = 'VORMSUND';
$borough_number{'2162'} = '0236'; $type{'2162'} = 'G'; $location{'2162'} = 'BRRUD';
$borough_number{'2164'} = '0236'; $type{'2164'} = 'B'; $location{'2164'} = 'SKOGBYGDA';
$borough_number{'2165'} = '0236'; $type{'2165'} = 'B'; $location{'2165'} = 'HVAM';
$borough_number{'2166'} = '0236'; $type{'2166'} = 'G'; $location{'2166'} = 'OPPAKER';
$borough_number{'2170'} = '0236'; $type{'2170'} = 'B'; $location{'2170'} = 'FENSTAD';
$borough_number{'2201'} = '0402'; $type{'2201'} = 'P'; $location{'2201'} = 'KONGSVINGER';
$borough_number{'2202'} = '0402'; $type{'2202'} = 'P'; $location{'2202'} = 'KONGSVINGER';
$borough_number{'2203'} = '0402'; $type{'2203'} = 'P'; $location{'2203'} = 'KONGSVINGER';
$borough_number{'2204'} = '0402'; $type{'2204'} = 'P'; $location{'2204'} = 'KONGSVINGER';
$borough_number{'2205'} = '0402'; $type{'2205'} = 'P'; $location{'2205'} = 'KONGSVINGER';
$borough_number{'2206'} = '0402'; $type{'2206'} = 'P'; $location{'2206'} = 'KONGSVINGER';
$borough_number{'2208'} = '0402'; $type{'2208'} = 'G'; $location{'2208'} = 'KONGSVINGER';
$borough_number{'2209'} = '0402'; $type{'2209'} = 'G'; $location{'2209'} = 'KONGSVINGER';
$borough_number{'2210'} = '0402'; $type{'2210'} = 'G'; $location{'2210'} = 'GRANLI';
$borough_number{'2211'} = '0402'; $type{'2211'} = 'G'; $location{'2211'} = 'KONGSVINGER';
$borough_number{'2212'} = '0402'; $type{'2212'} = 'G'; $location{'2212'} = 'KONGSVINGER';
$borough_number{'2213'} = '0402'; $type{'2213'} = 'G'; $location{'2213'} = 'KONGSVINGER';
$borough_number{'2214'} = '0402'; $type{'2214'} = 'G'; $location{'2214'} = 'KONGSVINGER';
$borough_number{'2216'} = '0402'; $type{'2216'} = 'B'; $location{'2216'} = 'ROVERUD';
$borough_number{'2217'} = '0402'; $type{'2217'} = 'G'; $location{'2217'} = 'HOKKSEN';
$borough_number{'2218'} = '0402'; $type{'2218'} = 'G'; $location{'2218'} = 'LUNDERSTER';
$borough_number{'2219'} = '0402'; $type{'2219'} = 'G'; $location{'2219'} = 'BRANDVAL';
$borough_number{'2220'} = '0420'; $type{'2220'} = 'G'; $location{'2220'} = 'BOGEN';
$borough_number{'2223'} = '0419'; $type{'2223'} = 'G'; $location{'2223'} = 'GALTERUD';
$borough_number{'2224'} = '0402'; $type{'2224'} = 'B'; $location{'2224'} = 'AUSTMARKA';
$borough_number{'2225'} = '0402'; $type{'2225'} = 'K'; $location{'2225'} = 'KONGSVINGER';
$borough_number{'2226'} = '0402'; $type{'2226'} = 'S'; $location{'2226'} = 'KONGSVINGER';
$borough_number{'2230'} = '0420'; $type{'2230'} = 'B'; $location{'2230'} = 'SKOTTERUD';
$borough_number{'2232'} = '0420'; $type{'2232'} = 'G'; $location{'2232'} = 'TOBL';
$borough_number{'2233'} = '0420'; $type{'2233'} = 'G'; $location{'2233'} = 'VESTMARKA';
$borough_number{'2235'} = '0420'; $type{'2235'} = 'G'; $location{'2235'} = 'MATRAND';
$borough_number{'2240'} = '0420'; $type{'2240'} = 'B'; $location{'2240'} = 'MAGNOR';
$borough_number{'2242'} = '0420'; $type{'2242'} = 'G'; $location{'2242'} = 'MOROKULIEN';
$borough_number{'2256'} = '0423'; $type{'2256'} = 'B'; $location{'2256'} = 'GRUE FINNSKOG';
$borough_number{'2260'} = '0423'; $type{'2260'} = 'G'; $location{'2260'} = 'KIRKENR';
$borough_number{'2261'} = '0423'; $type{'2261'} = 'P'; $location{'2261'} = 'KIRKENR';
$borough_number{'2264'} = '0423'; $type{'2264'} = 'G'; $location{'2264'} = 'GRINDER';
$borough_number{'2265'} = '0423'; $type{'2265'} = 'G'; $location{'2265'} = 'NAMN';
$borough_number{'2266'} = '0425'; $type{'2266'} = 'G'; $location{'2266'} = 'ARNEBERG';
$borough_number{'2270'} = '0425'; $type{'2270'} = 'G'; $location{'2270'} = 'FLISA';
$borough_number{'2271'} = '0425'; $type{'2271'} = 'P'; $location{'2271'} = 'FLISA';
$borough_number{'2280'} = '0425'; $type{'2280'} = 'G'; $location{'2280'} = 'GJESSEN';
$borough_number{'2283'} = '0425'; $type{'2283'} = 'G'; $location{'2283'} = 'SNES FINNSKOG';
$borough_number{'2301'} = '0403'; $type{'2301'} = 'P'; $location{'2301'} = 'HAMAR';
$borough_number{'2302'} = '0403'; $type{'2302'} = 'P'; $location{'2302'} = 'HAMAR';
$borough_number{'2303'} = '0403'; $type{'2303'} = 'P'; $location{'2303'} = 'HAMAR';
$borough_number{'2304'} = '0403'; $type{'2304'} = 'P'; $location{'2304'} = 'HAMAR';
$borough_number{'2305'} = '0403'; $type{'2305'} = 'P'; $location{'2305'} = 'HAMAR';
$borough_number{'2306'} = '0403'; $type{'2306'} = 'P'; $location{'2306'} = 'HAMAR';
$borough_number{'2307'} = '0403'; $type{'2307'} = 'P'; $location{'2307'} = 'HAMAR';
$borough_number{'2308'} = '0403'; $type{'2308'} = 'P'; $location{'2308'} = 'HAMAR';
$borough_number{'2309'} = '0403'; $type{'2309'} = 'P'; $location{'2309'} = 'HAMAR';
$borough_number{'2312'} = '0417'; $type{'2312'} = 'B'; $location{'2312'} = 'OTTESTAD';
$borough_number{'2315'} = '0403'; $type{'2315'} = 'G'; $location{'2315'} = 'HAMAR';
$borough_number{'2316'} = '0403'; $type{'2316'} = 'G'; $location{'2316'} = 'HAMAR';
$borough_number{'2317'} = '0403'; $type{'2317'} = 'G'; $location{'2317'} = 'HAMAR';
$borough_number{'2318'} = '0403'; $type{'2318'} = 'B'; $location{'2318'} = 'HAMAR';
$borough_number{'2319'} = '0403'; $type{'2319'} = 'G'; $location{'2319'} = 'HAMAR';
$borough_number{'2320'} = '0412'; $type{'2320'} = 'B'; $location{'2320'} = 'FURNES';
$borough_number{'2321'} = '0403'; $type{'2321'} = 'G'; $location{'2321'} = 'HAMAR';
$borough_number{'2322'} = '0403'; $type{'2322'} = 'B'; $location{'2322'} = 'RIDABU';
$borough_number{'2323'} = '0403'; $type{'2323'} = 'G'; $location{'2323'} = 'INGEBERG';
$borough_number{'2324'} = '0403'; $type{'2324'} = 'B'; $location{'2324'} = 'VANG P HEDMARK';
$borough_number{'2325'} = '0403'; $type{'2325'} = 'K'; $location{'2325'} = 'HAMAR';
$borough_number{'2326'} = '0403'; $type{'2326'} = 'S'; $location{'2326'} = 'HAMAR';
$borough_number{'2330'} = '0417'; $type{'2330'} = 'B'; $location{'2330'} = 'VALLSET';
$borough_number{'2332'} = '0417'; $type{'2332'} = 'G'; $location{'2332'} = 'SVANG';
$borough_number{'2334'} = '0417'; $type{'2334'} = 'B'; $location{'2334'} = 'ROMEDAL';
$borough_number{'2335'} = '0417'; $type{'2335'} = 'G'; $location{'2335'} = 'STANGE';
$borough_number{'2336'} = '0417'; $type{'2336'} = 'P'; $location{'2336'} = 'STANGE';
$borough_number{'2337'} = '0417'; $type{'2337'} = 'B'; $location{'2337'} = 'TANGEN';
$borough_number{'2338'} = '0417'; $type{'2338'} = 'G'; $location{'2338'} = 'ESPA';
$borough_number{'2340'} = '0415'; $type{'2340'} = 'G'; $location{'2340'} = 'LTEN';
$borough_number{'2341'} = '0415'; $type{'2341'} = 'P'; $location{'2341'} = 'LTEN';
$borough_number{'2344'} = '0417'; $type{'2344'} = 'B'; $location{'2344'} = 'ILSENG';
$borough_number{'2345'} = '0415'; $type{'2345'} = 'G'; $location{'2345'} = 'DALSBRUK';
$borough_number{'2350'} = '0412'; $type{'2350'} = 'B'; $location{'2350'} = 'NES P HEDMARK';
$borough_number{'2353'} = '0412'; $type{'2353'} = 'B'; $location{'2353'} = 'STAVSJ';
$borough_number{'2355'} = '0412'; $type{'2355'} = 'G'; $location{'2355'} = 'GAUPEN';
$borough_number{'2360'} = '0412'; $type{'2360'} = 'B'; $location{'2360'} = 'RUDSHGDA';
$borough_number{'2364'} = '0412'; $type{'2364'} = 'G'; $location{'2364'} = 'NROSET';
$borough_number{'2365'} = '0412'; $type{'2365'} = 'G'; $location{'2365'} = 'SMARKA';
$borough_number{'2372'} = '0412'; $type{'2372'} = 'B'; $location{'2372'} = 'BRTTUM';
$borough_number{'2380'} = '0412'; $type{'2380'} = 'G'; $location{'2380'} = 'BRUMUNDDAL';
$borough_number{'2381'} = '0412'; $type{'2381'} = 'P'; $location{'2381'} = 'BRUMUNDDAL';
$borough_number{'2390'} = '0412'; $type{'2390'} = 'G'; $location{'2390'} = 'MOELV';
$borough_number{'2391'} = '0412'; $type{'2391'} = 'P'; $location{'2391'} = 'MOELV';
$borough_number{'2401'} = '0427'; $type{'2401'} = 'P'; $location{'2401'} = 'ELVERUM';
$borough_number{'2402'} = '0427'; $type{'2402'} = 'P'; $location{'2402'} = 'ELVERUM';
$borough_number{'2403'} = '0427'; $type{'2403'} = 'P'; $location{'2403'} = 'ELVERUM';
$borough_number{'2405'} = '0427'; $type{'2405'} = 'P'; $location{'2405'} = 'ELVERUM';
$borough_number{'2406'} = '0427'; $type{'2406'} = 'G'; $location{'2406'} = 'ELVERUM';
$borough_number{'2407'} = '0427'; $type{'2407'} = 'B'; $location{'2407'} = 'ELVERUM';
$borough_number{'2408'} = '0427'; $type{'2408'} = 'G'; $location{'2408'} = 'ELVERUM';
$borough_number{'2409'} = '0427'; $type{'2409'} = 'B'; $location{'2409'} = 'ELVERUM';
$borough_number{'2410'} = '0427'; $type{'2410'} = 'B'; $location{'2410'} = 'HERNES';
$borough_number{'2411'} = '0427'; $type{'2411'} = 'G'; $location{'2411'} = 'ELVERUM';
$borough_number{'2412'} = '0427'; $type{'2412'} = 'G'; $location{'2412'} = 'SRSKOGBYGDA';
$borough_number{'2415'} = '0427'; $type{'2415'} = 'B'; $location{'2415'} = 'HERADSBYGD';
$borough_number{'2416'} = '0427'; $type{'2416'} = 'G'; $location{'2416'} = 'JMNA';
$borough_number{'2418'} = '0427'; $type{'2418'} = 'S'; $location{'2418'} = 'ELVERUM';
$borough_number{'2420'} = '0428'; $type{'2420'} = 'G'; $location{'2420'} = 'TRYSIL';
$borough_number{'2421'} = '0428'; $type{'2421'} = 'P'; $location{'2421'} = 'TRYSIL';
$borough_number{'2422'} = '0428'; $type{'2422'} = 'B'; $location{'2422'} = 'NYBERGSUND';
$borough_number{'2423'} = '0428'; $type{'2423'} = 'B'; $location{'2423'} = 'STBY';
$borough_number{'2425'} = '0428'; $type{'2425'} = 'B'; $location{'2425'} = 'LJRDALEN';
$borough_number{'2427'} = '0428'; $type{'2427'} = 'G'; $location{'2427'} = 'PLASSEN';
$borough_number{'2428'} = '0428'; $type{'2428'} = 'B'; $location{'2428'} = 'SRE OSEN';
$borough_number{'2429'} = '0428'; $type{'2429'} = 'G'; $location{'2429'} = 'TRBERGET';
$borough_number{'2430'} = '0428'; $type{'2430'} = 'B'; $location{'2430'} = 'JORDET';
$borough_number{'2432'} = '0428'; $type{'2432'} = 'G'; $location{'2432'} = 'SLETTS';
$borough_number{'2435'} = '0426'; $type{'2435'} = 'B'; $location{'2435'} = 'BRASKEREIDFOSS';
$borough_number{'2436'} = '0426'; $type{'2436'} = 'B'; $location{'2436'} = 'VLER I SOLR';
$borough_number{'2437'} = '0426'; $type{'2437'} = 'K'; $location{'2437'} = 'HASLEMOEN';
$borough_number{'2438'} = '0426'; $type{'2438'} = 'G'; $location{'2438'} = 'GRAVBERGET';
$borough_number{'2440'} = '0434'; $type{'2440'} = 'B'; $location{'2440'} = 'ENGERDAL';
$borough_number{'2443'} = '0434'; $type{'2443'} = 'B'; $location{'2443'} = 'DREVSJ';
$borough_number{'2446'} = '0434'; $type{'2446'} = 'G'; $location{'2446'} = 'ELG';
$borough_number{'2448'} = '0434'; $type{'2448'} = 'G'; $location{'2448'} = 'SMDALEN';
$borough_number{'2450'} = '0429'; $type{'2450'} = 'G'; $location{'2450'} = 'RENA';
$borough_number{'2451'} = '0429'; $type{'2451'} = 'P'; $location{'2451'} = 'RENA';
$borough_number{'2460'} = '0429'; $type{'2460'} = 'B'; $location{'2460'} = 'OSEN';
$borough_number{'2476'} = '0430'; $type{'2476'} = 'G'; $location{'2476'} = 'ATNA';
$borough_number{'2477'} = '0430'; $type{'2477'} = 'G'; $location{'2477'} = 'SOLLIA';
$borough_number{'2478'} = '0432'; $type{'2478'} = 'G'; $location{'2478'} = 'HANESTAD';
$borough_number{'2480'} = '0430'; $type{'2480'} = 'G'; $location{'2480'} = 'KOPPANG';
$borough_number{'2481'} = '0430'; $type{'2481'} = 'P'; $location{'2481'} = 'KOPPANG';
$borough_number{'2485'} = '0432'; $type{'2485'} = 'B'; $location{'2485'} = 'RENDALEN';
$borough_number{'2500'} = '0437'; $type{'2500'} = 'G'; $location{'2500'} = 'TYNSET';
$borough_number{'2501'} = '0437'; $type{'2501'} = 'P'; $location{'2501'} = 'TYNSET';
$borough_number{'2510'} = '0437'; $type{'2510'} = 'G'; $location{'2510'} = 'TYLLDALEN';
$borough_number{'2512'} = '0437'; $type{'2512'} = 'B'; $location{'2512'} = 'KVIKNE';
$borough_number{'2540'} = '0436'; $type{'2540'} = 'B'; $location{'2540'} = 'TOLGA';
$borough_number{'2542'} = '0436'; $type{'2542'} = 'G'; $location{'2542'} = 'VINGELEN';
$borough_number{'2544'} = '0436'; $type{'2544'} = 'G'; $location{'2544'} = 'VERSJDALEN';
$borough_number{'2550'} = '0441'; $type{'2550'} = 'B'; $location{'2550'} = 'OS I STERDALEN';
$borough_number{'2552'} = '0441'; $type{'2552'} = 'G'; $location{'2552'} = 'DALSBYGDA';
$borough_number{'2555'} = '0441'; $type{'2555'} = 'G'; $location{'2555'} = 'TUFSINGDALEN';
$borough_number{'2560'} = '0438'; $type{'2560'} = 'G'; $location{'2560'} = 'ALVDAL';
$borough_number{'2561'} = '0438'; $type{'2561'} = 'P'; $location{'2561'} = 'ALVDAL';
$borough_number{'2580'} = '0439'; $type{'2580'} = 'G'; $location{'2580'} = 'FOLLDAL';
$borough_number{'2581'} = '0439'; $type{'2581'} = 'P'; $location{'2581'} = 'FOLLDAL';
$borough_number{'2582'} = '0439'; $type{'2582'} = 'G'; $location{'2582'} = 'GRIMSBU';
$borough_number{'2584'} = '0439'; $type{'2584'} = 'G'; $location{'2584'} = 'DALHOLEN';
$borough_number{'2601'} = '0501'; $type{'2601'} = 'P'; $location{'2601'} = 'LILLEHAMMER';
$borough_number{'2602'} = '0501'; $type{'2602'} = 'P'; $location{'2602'} = 'LILLEHAMMER';
$borough_number{'2603'} = '0501'; $type{'2603'} = 'P'; $location{'2603'} = 'LILLEHAMMER';
$borough_number{'2604'} = '0501'; $type{'2604'} = 'P'; $location{'2604'} = 'LILLEHAMMER';
$borough_number{'2605'} = '0501'; $type{'2605'} = 'P'; $location{'2605'} = 'LILLEHAMMER';
$borough_number{'2606'} = '0501'; $type{'2606'} = 'P'; $location{'2606'} = 'LILLEHAMMER';
$borough_number{'2607'} = '0501'; $type{'2607'} = 'B'; $location{'2607'} = 'VINGROM';
$borough_number{'2608'} = '0501'; $type{'2608'} = 'B'; $location{'2608'} = 'LILLEHAMMER';
$borough_number{'2609'} = '0501'; $type{'2609'} = 'B'; $location{'2609'} = 'LILLEHAMMER';
$borough_number{'2610'} = '0412'; $type{'2610'} = 'B'; $location{'2610'} = 'MESNALI';
$borough_number{'2611'} = '0501'; $type{'2611'} = 'B'; $location{'2611'} = 'LILLEHAMMER';
$borough_number{'2612'} = '0412'; $type{'2612'} = 'B'; $location{'2612'} = 'SJUSJEN';
$borough_number{'2613'} = '0501'; $type{'2613'} = 'G'; $location{'2613'} = 'LILLEHAMMER';
$borough_number{'2614'} = '0501'; $type{'2614'} = 'G'; $location{'2614'} = 'LILLEHAMMER';
$borough_number{'2615'} = '0501'; $type{'2615'} = 'G'; $location{'2615'} = 'LILLEHAMMER';
$borough_number{'2616'} = '0412'; $type{'2616'} = 'G'; $location{'2616'} = 'LISMARKA';
$borough_number{'2617'} = '0501'; $type{'2617'} = 'K'; $location{'2617'} = 'LILLEHAMMER';
$borough_number{'2618'} = '0501'; $type{'2618'} = 'G'; $location{'2618'} = 'LILLEHAMMER';
$borough_number{'2619'} = '0501'; $type{'2619'} = 'G'; $location{'2619'} = 'LILLEHAMMER';
$borough_number{'2624'} = '0501'; $type{'2624'} = 'B'; $location{'2624'} = 'LILLEHAMMER';
$borough_number{'2625'} = '0501'; $type{'2625'} = 'B'; $location{'2625'} = 'FBERG';
$borough_number{'2626'} = '0501'; $type{'2626'} = 'S'; $location{'2626'} = 'LILLEHAMMER';
$borough_number{'2629'} = '0501'; $type{'2629'} = 'K'; $location{'2629'} = 'LILLEHAMMER';
$borough_number{'2630'} = '0520'; $type{'2630'} = 'G'; $location{'2630'} = 'RINGEBU';
$borough_number{'2631'} = '0520'; $type{'2631'} = 'P'; $location{'2631'} = 'RINGEBU';
$borough_number{'2632'} = '0520'; $type{'2632'} = 'G'; $location{'2632'} = 'VENABYGD';
$borough_number{'2633'} = '0520'; $type{'2633'} = 'P'; $location{'2633'} = 'FVANG';
$borough_number{'2634'} = '0520'; $type{'2634'} = 'G'; $location{'2634'} = 'FVANG';
$borough_number{'2635'} = '0521'; $type{'2635'} = 'B'; $location{'2635'} = 'TRETTEN';
$borough_number{'2636'} = '0521'; $type{'2636'} = 'G'; $location{'2636'} = 'YER';
$borough_number{'2637'} = '0521'; $type{'2637'} = 'P'; $location{'2637'} = 'YER';
$borough_number{'2639'} = '0516'; $type{'2639'} = 'P'; $location{'2639'} = 'VINSTRA';
$borough_number{'2640'} = '0516'; $type{'2640'} = 'G'; $location{'2640'} = 'VINSTRA';
$borough_number{'2642'} = '0516'; $type{'2642'} = 'B'; $location{'2642'} = 'KVAM';
$borough_number{'2643'} = '0516'; $type{'2643'} = 'B'; $location{'2643'} = 'SKBU';
$borough_number{'2645'} = '0519'; $type{'2645'} = 'P'; $location{'2645'} = 'SR-FRON';
$borough_number{'2646'} = '0519'; $type{'2646'} = 'G'; $location{'2646'} = 'GL';
$borough_number{'2647'} = '0519'; $type{'2647'} = 'G'; $location{'2647'} = 'SR-FRON';
$borough_number{'2648'} = '0519'; $type{'2648'} = 'P'; $location{'2648'} = 'SR-FRON';
$borough_number{'2649'} = '0522'; $type{'2649'} = 'P'; $location{'2649'} = 'STRE GAUSDAL';
$borough_number{'2651'} = '0522'; $type{'2651'} = 'G'; $location{'2651'} = 'STRE GAUSDAL';
$borough_number{'2652'} = '0522'; $type{'2652'} = 'G'; $location{'2652'} = 'SVINGVOLL';
$borough_number{'2653'} = '0522'; $type{'2653'} = 'B'; $location{'2653'} = 'VESTRE GAUSDAL';
$borough_number{'2656'} = '0522'; $type{'2656'} = 'B'; $location{'2656'} = 'FOLLEBU';
$borough_number{'2657'} = '0522'; $type{'2657'} = 'G'; $location{'2657'} = 'SVATSUM';
$borough_number{'2658'} = '0519'; $type{'2658'} = 'G'; $location{'2658'} = 'ESPEDALEN';
$borough_number{'2659'} = '0511'; $type{'2659'} = 'P'; $location{'2659'} = 'DOMBS';
$borough_number{'2660'} = '0511'; $type{'2660'} = 'G'; $location{'2660'} = 'DOMBS';
$borough_number{'2661'} = '0511'; $type{'2661'} = 'G'; $location{'2661'} = 'HJERKINN';
$borough_number{'2662'} = '0511'; $type{'2662'} = 'G'; $location{'2662'} = 'DOVRE';
$borough_number{'2663'} = '0511'; $type{'2663'} = 'G'; $location{'2663'} = 'DOVRESKOGEN';
$borough_number{'2664'} = '0511'; $type{'2664'} = 'P'; $location{'2664'} = 'DOVRE';
$borough_number{'2665'} = '0512'; $type{'2665'} = 'B'; $location{'2665'} = 'LESJA';
$borough_number{'2666'} = '0512'; $type{'2666'} = 'G'; $location{'2666'} = 'LORA';
$borough_number{'2667'} = '0512'; $type{'2667'} = 'G'; $location{'2667'} = 'LESJAVERK';
$borough_number{'2668'} = '0512'; $type{'2668'} = 'G'; $location{'2668'} = 'LESJASKOG';
$borough_number{'2669'} = '0512'; $type{'2669'} = 'G'; $location{'2669'} = 'BJORLI';
$borough_number{'2670'} = '0517'; $type{'2670'} = 'G'; $location{'2670'} = 'OTTA';
$borough_number{'2672'} = '0517'; $type{'2672'} = 'B'; $location{'2672'} = 'SEL';
$borough_number{'2673'} = '0517'; $type{'2673'} = 'G'; $location{'2673'} = 'HVRINGEN';
$borough_number{'2674'} = '0517'; $type{'2674'} = 'G'; $location{'2674'} = 'MYSUSTER';
$borough_number{'2675'} = '0517'; $type{'2675'} = 'P'; $location{'2675'} = 'OTTA';
$borough_number{'2676'} = '0517'; $type{'2676'} = 'B'; $location{'2676'} = 'HEIDAL';
$borough_number{'2677'} = '0517'; $type{'2677'} = 'G'; $location{'2677'} = 'NEDRE HEIDAL';
$borough_number{'2680'} = '0515'; $type{'2680'} = 'G'; $location{'2680'} = 'VG';
$borough_number{'2682'} = '0515'; $type{'2682'} = 'B'; $location{'2682'} = 'LALM';
$borough_number{'2683'} = '0515'; $type{'2683'} = 'G'; $location{'2683'} = 'TESSANDEN';
$borough_number{'2684'} = '0515'; $type{'2684'} = 'P'; $location{'2684'} = 'VG';
$borough_number{'2685'} = '0514'; $type{'2685'} = 'G'; $location{'2685'} = 'GARMO';
$borough_number{'2686'} = '0514'; $type{'2686'} = 'G'; $location{'2686'} = 'LOM';
$borough_number{'2687'} = '0514'; $type{'2687'} = 'G'; $location{'2687'} = 'BVERDALEN';
$borough_number{'2688'} = '0514'; $type{'2688'} = 'P'; $location{'2688'} = 'LOM';
$borough_number{'2690'} = '0513'; $type{'2690'} = 'G'; $location{'2690'} = 'SKJK';
$borough_number{'2693'} = '0513'; $type{'2693'} = 'G'; $location{'2693'} = 'NORDBERG';
$borough_number{'2694'} = '0513'; $type{'2694'} = 'P'; $location{'2694'} = 'SKJK';
$borough_number{'2695'} = '0513'; $type{'2695'} = 'G'; $location{'2695'} = 'GROTLI';
$borough_number{'2711'} = '0534'; $type{'2711'} = 'P'; $location{'2711'} = 'GRAN';
$borough_number{'2712'} = '0534'; $type{'2712'} = 'P'; $location{'2712'} = 'BRANDBU';
$borough_number{'2713'} = '0533'; $type{'2713'} = 'P'; $location{'2713'} = 'ROA';
$borough_number{'2714'} = '0534'; $type{'2714'} = 'P'; $location{'2714'} = 'JAREN';
$borough_number{'2715'} = '0533'; $type{'2715'} = 'P'; $location{'2715'} = 'LUNNER';
$borough_number{'2716'} = '0533'; $type{'2716'} = 'P'; $location{'2716'} = 'HARESTUA';
$borough_number{'2717'} = '0533'; $type{'2717'} = 'P'; $location{'2717'} = 'GRUA';
$borough_number{'2718'} = '0534'; $type{'2718'} = 'P'; $location{'2718'} = 'BRANDBU';
$borough_number{'2720'} = '0533'; $type{'2720'} = 'G'; $location{'2720'} = 'GRINDVOLL';
$borough_number{'2730'} = '0533'; $type{'2730'} = 'G'; $location{'2730'} = 'LUNNER';
$borough_number{'2740'} = '0533'; $type{'2740'} = 'G'; $location{'2740'} = 'ROA';
$borough_number{'2742'} = '0533'; $type{'2742'} = 'G'; $location{'2742'} = 'GRUA';
$borough_number{'2743'} = '0533'; $type{'2743'} = 'G'; $location{'2743'} = 'HARESTUA';
$borough_number{'2750'} = '0534'; $type{'2750'} = 'G'; $location{'2750'} = 'GRAN';
$borough_number{'2760'} = '0534'; $type{'2760'} = 'G'; $location{'2760'} = 'BRANDBU';
$borough_number{'2770'} = '0534'; $type{'2770'} = 'G'; $location{'2770'} = 'JAREN';
$borough_number{'2801'} = '0502'; $type{'2801'} = 'P'; $location{'2801'} = 'GJVIK';
$borough_number{'2802'} = '0502'; $type{'2802'} = 'P'; $location{'2802'} = 'GJVIK';
$borough_number{'2803'} = '0502'; $type{'2803'} = 'P'; $location{'2803'} = 'GJVIK';
$borough_number{'2804'} = '0502'; $type{'2804'} = 'P'; $location{'2804'} = 'GJVIK';
$borough_number{'2805'} = '0502'; $type{'2805'} = 'P'; $location{'2805'} = 'GJVIK';
$borough_number{'2806'} = '0502'; $type{'2806'} = 'P'; $location{'2806'} = 'GJVIK';
$borough_number{'2807'} = '0502'; $type{'2807'} = 'P'; $location{'2807'} = 'HUNNDALEN';
$borough_number{'2808'} = '0502'; $type{'2808'} = 'S'; $location{'2808'} = 'GJVIK';
$borough_number{'2809'} = '0502'; $type{'2809'} = 'S'; $location{'2809'} = 'GJVIK';
$borough_number{'2810'} = '0502'; $type{'2810'} = 'S'; $location{'2810'} = 'GJVIK';
$borough_number{'2811'} = '0502'; $type{'2811'} = 'P'; $location{'2811'} = 'HUNNDALEN';
$borough_number{'2815'} = '0502'; $type{'2815'} = 'G'; $location{'2815'} = 'GJVIK';
$borough_number{'2816'} = '0502'; $type{'2816'} = 'G'; $location{'2816'} = 'GJVIK';
$borough_number{'2817'} = '0502'; $type{'2817'} = 'G'; $location{'2817'} = 'GJVIK';
$borough_number{'2818'} = '0502'; $type{'2818'} = 'G'; $location{'2818'} = 'GJVIK';
$borough_number{'2819'} = '0502'; $type{'2819'} = 'B'; $location{'2819'} = 'GJVIK';
$borough_number{'2821'} = '0502'; $type{'2821'} = 'G'; $location{'2821'} = 'GJVIK';
$borough_number{'2822'} = '0502'; $type{'2822'} = 'G'; $location{'2822'} = 'BYBRUA';
$borough_number{'2825'} = '0502'; $type{'2825'} = 'G'; $location{'2825'} = 'GJVIK';
$borough_number{'2827'} = '0502'; $type{'2827'} = 'G'; $location{'2827'} = 'HUNNDALEN';
$borough_number{'2830'} = '0529'; $type{'2830'} = 'G'; $location{'2830'} = 'RAUFOSS';
$borough_number{'2831'} = '0529'; $type{'2831'} = 'P'; $location{'2831'} = 'RAUFOSS';
$borough_number{'2832'} = '0502'; $type{'2832'} = 'P'; $location{'2832'} = 'BIRI';
$borough_number{'2836'} = '0502'; $type{'2836'} = 'B'; $location{'2836'} = 'BIRI';
$borough_number{'2837'} = '0502'; $type{'2837'} = 'G'; $location{'2837'} = 'BIRISTRAND';
$borough_number{'2838'} = '0502'; $type{'2838'} = 'B'; $location{'2838'} = 'SNERTINGDAL';
$borough_number{'2839'} = '0502'; $type{'2839'} = 'G'; $location{'2839'} = 'VRE SNERTINGDAL';
$borough_number{'2840'} = '0529'; $type{'2840'} = 'G'; $location{'2840'} = 'REINSVOLL';
$borough_number{'2843'} = '0529'; $type{'2843'} = 'G'; $location{'2843'} = 'EINA';
$borough_number{'2846'} = '0529'; $type{'2846'} = 'B'; $location{'2846'} = 'BVERBRU';
$borough_number{'2847'} = '0528'; $type{'2847'} = 'B'; $location{'2847'} = 'KOLBU';
$borough_number{'2848'} = '0528'; $type{'2848'} = 'G'; $location{'2848'} = 'SKREIA';
$borough_number{'2849'} = '0528'; $type{'2849'} = 'G'; $location{'2849'} = 'KAPP';
$borough_number{'2850'} = '0528'; $type{'2850'} = 'G'; $location{'2850'} = 'LENA';
$borough_number{'2851'} = '0528'; $type{'2851'} = 'P'; $location{'2851'} = 'LENA';
$borough_number{'2853'} = '0529'; $type{'2853'} = 'P'; $location{'2853'} = 'REINSVOLL';
$borough_number{'2854'} = '0529'; $type{'2854'} = 'P'; $location{'2854'} = 'EINA';
$borough_number{'2857'} = '0528'; $type{'2857'} = 'P'; $location{'2857'} = 'SKREIA';
$borough_number{'2858'} = '0528'; $type{'2858'} = 'P'; $location{'2858'} = 'KAPP';
$borough_number{'2860'} = '0536'; $type{'2860'} = 'G'; $location{'2860'} = 'HOV';
$borough_number{'2861'} = '0536'; $type{'2861'} = 'G'; $location{'2861'} = 'LANDSBYGDA';
$borough_number{'2862'} = '0536'; $type{'2862'} = 'G'; $location{'2862'} = 'FLUBERG';
$borough_number{'2864'} = '0536'; $type{'2864'} = 'G'; $location{'2864'} = 'FALL';
$borough_number{'2866'} = '0536'; $type{'2866'} = 'G'; $location{'2866'} = 'ENGER';
$borough_number{'2867'} = '0536'; $type{'2867'} = 'P'; $location{'2867'} = 'HOV';
$borough_number{'2870'} = '0538'; $type{'2870'} = 'G'; $location{'2870'} = 'DOKKA';
$borough_number{'2879'} = '0536'; $type{'2879'} = 'G'; $location{'2879'} = 'ODNES';
$borough_number{'2880'} = '0538'; $type{'2880'} = 'B'; $location{'2880'} = 'NORD-TORPA';
$borough_number{'2881'} = '0538'; $type{'2881'} = 'G'; $location{'2881'} = 'AUST-TORPA';
$borough_number{'2882'} = '0538'; $type{'2882'} = 'P'; $location{'2882'} = 'DOKKA';
$borough_number{'2890'} = '0541'; $type{'2890'} = 'G'; $location{'2890'} = 'ETNEDAL';
$borough_number{'2893'} = '0541'; $type{'2893'} = 'P'; $location{'2893'} = 'ETNEDAL';
$borough_number{'2900'} = '0542'; $type{'2900'} = 'G'; $location{'2900'} = 'FAGERNES';
$borough_number{'2901'} = '0542'; $type{'2901'} = 'P'; $location{'2901'} = 'FAGERNES';
$borough_number{'2907'} = '0542'; $type{'2907'} = 'P'; $location{'2907'} = 'LEIRA I VALDRES';
$borough_number{'2910'} = '0542'; $type{'2910'} = 'B'; $location{'2910'} = 'AURDAL';
$borough_number{'2917'} = '0542'; $type{'2917'} = 'G'; $location{'2917'} = 'SKRAUTVL';
$borough_number{'2918'} = '0542'; $type{'2918'} = 'G'; $location{'2918'} = 'ULNES';
$borough_number{'2920'} = '0542'; $type{'2920'} = 'G'; $location{'2920'} = 'LEIRA I VALDRES';
$borough_number{'2923'} = '0542'; $type{'2923'} = 'G'; $location{'2923'} = 'TISLEIDALEN';
$borough_number{'2929'} = '0540'; $type{'2929'} = 'P'; $location{'2929'} = 'BAGN';
$borough_number{'2930'} = '0540'; $type{'2930'} = 'G'; $location{'2930'} = 'BAGN';
$borough_number{'2933'} = '0540'; $type{'2933'} = 'G'; $location{'2933'} = 'REINLI';
$borough_number{'2936'} = '0540'; $type{'2936'} = 'G'; $location{'2936'} = 'BEGNADALEN';
$borough_number{'2937'} = '0540'; $type{'2937'} = 'G'; $location{'2937'} = 'BEGNA';
$borough_number{'2939'} = '0544'; $type{'2939'} = 'P'; $location{'2939'} = 'HEGGENES';
$borough_number{'2940'} = '0544'; $type{'2940'} = 'G'; $location{'2940'} = 'HEGGENES';
$borough_number{'2943'} = '0544'; $type{'2943'} = 'G'; $location{'2943'} = 'ROGNE';
$borough_number{'2950'} = '0544'; $type{'2950'} = 'G'; $location{'2950'} = 'SKAMMESTEIN';
$borough_number{'2952'} = '0544'; $type{'2952'} = 'G'; $location{'2952'} = 'BEITO';
$borough_number{'2953'} = '0544'; $type{'2953'} = 'B'; $location{'2953'} = 'BEITOSTLEN';
$borough_number{'2959'} = '0543'; $type{'2959'} = 'P'; $location{'2959'} = 'RN';
$borough_number{'2960'} = '0543'; $type{'2960'} = 'G'; $location{'2960'} = 'RN';
$borough_number{'2966'} = '0543'; $type{'2966'} = 'B'; $location{'2966'} = 'SLIDRE';
$borough_number{'2967'} = '0543'; $type{'2967'} = 'G'; $location{'2967'} = 'LOMEN';
$borough_number{'2973'} = '0545'; $type{'2973'} = 'B'; $location{'2973'} = 'RYFOSS';
$borough_number{'2974'} = '0545'; $type{'2974'} = 'P'; $location{'2974'} = 'VANG I VALDRES';
$borough_number{'2975'} = '0545'; $type{'2975'} = 'G'; $location{'2975'} = 'VANG I VALDRES';
$borough_number{'2977'} = '0545'; $type{'2977'} = 'G'; $location{'2977'} = 'YE';
$borough_number{'2985'} = '0545'; $type{'2985'} = 'G'; $location{'2985'} = 'TYINKRYSSET';
$borough_number{'3001'} = '0602'; $type{'3001'} = 'P'; $location{'3001'} = 'DRAMMEN';
$borough_number{'3002'} = '0602'; $type{'3002'} = 'P'; $location{'3002'} = 'DRAMMEN';
$borough_number{'3003'} = '0602'; $type{'3003'} = 'P'; $location{'3003'} = 'DRAMMEN';
$borough_number{'3004'} = '0602'; $type{'3004'} = 'F'; $location{'3004'} = 'DRAMMEN';
$borough_number{'3005'} = '0602'; $type{'3005'} = 'P'; $location{'3005'} = 'DRAMMEN';
$borough_number{'3006'} = '0602'; $type{'3006'} = 'P'; $location{'3006'} = 'DRAMMEN';
$borough_number{'3007'} = '0602'; $type{'3007'} = 'P'; $location{'3007'} = 'DRAMMEN';
$borough_number{'3008'} = '0602'; $type{'3008'} = 'F'; $location{'3008'} = 'DRAMMEN';
$borough_number{'3011'} = '0602'; $type{'3011'} = 'G'; $location{'3011'} = 'DRAMMEN';
$borough_number{'3012'} = '0602'; $type{'3012'} = 'G'; $location{'3012'} = 'DRAMMEN';
$borough_number{'3013'} = '0602'; $type{'3013'} = 'G'; $location{'3013'} = 'DRAMMEN';
$borough_number{'3014'} = '0602'; $type{'3014'} = 'G'; $location{'3014'} = 'DRAMMEN';
$borough_number{'3015'} = '0602'; $type{'3015'} = 'G'; $location{'3015'} = 'DRAMMEN';
$borough_number{'3016'} = '0602'; $type{'3016'} = 'G'; $location{'3016'} = 'DRAMMEN';
$borough_number{'3017'} = '0602'; $type{'3017'} = 'G'; $location{'3017'} = 'DRAMMEN';
$borough_number{'3018'} = '0602'; $type{'3018'} = 'G'; $location{'3018'} = 'DRAMMEN';
$borough_number{'3019'} = '0602'; $type{'3019'} = 'G'; $location{'3019'} = 'DRAMMEN';
$borough_number{'3020'} = '0602'; $type{'3020'} = 'K'; $location{'3020'} = 'DRAMMEN';
$borough_number{'3021'} = '0602'; $type{'3021'} = 'G'; $location{'3021'} = 'DRAMMEN';
$borough_number{'3022'} = '0602'; $type{'3022'} = 'G'; $location{'3022'} = 'DRAMMEN';
$borough_number{'3023'} = '0602'; $type{'3023'} = 'B'; $location{'3023'} = 'DRAMMEN';
$borough_number{'3024'} = '0602'; $type{'3024'} = 'B'; $location{'3024'} = 'DRAMMEN';
$borough_number{'3025'} = '0602'; $type{'3025'} = 'G'; $location{'3025'} = 'DRAMMEN';
$borough_number{'3026'} = '0602'; $type{'3026'} = 'G'; $location{'3026'} = 'DRAMMEN';
$borough_number{'3027'} = '0602'; $type{'3027'} = 'G'; $location{'3027'} = 'DRAMMEN';
$borough_number{'3028'} = '0602'; $type{'3028'} = 'B'; $location{'3028'} = 'DRAMMEN';
$borough_number{'3029'} = '0602'; $type{'3029'} = 'G'; $location{'3029'} = 'DRAMMEN';
$borough_number{'3030'} = '0602'; $type{'3030'} = 'G'; $location{'3030'} = 'DRAMMEN';
$borough_number{'3031'} = '0602'; $type{'3031'} = 'G'; $location{'3031'} = 'DRAMMEN';
$borough_number{'3032'} = '0602'; $type{'3032'} = 'G'; $location{'3032'} = 'DRAMMEN';
$borough_number{'3033'} = '0602'; $type{'3033'} = 'G'; $location{'3033'} = 'DRAMMEN';
$borough_number{'3034'} = '0602'; $type{'3034'} = 'B'; $location{'3034'} = 'DRAMMEN';
$borough_number{'3035'} = '0602'; $type{'3035'} = 'G'; $location{'3035'} = 'DRAMMEN';
$borough_number{'3036'} = '0602'; $type{'3036'} = 'G'; $location{'3036'} = 'DRAMMEN';
$borough_number{'3037'} = '0602'; $type{'3037'} = 'G'; $location{'3037'} = 'DRAMMEN';
$borough_number{'3038'} = '0602'; $type{'3038'} = 'B'; $location{'3038'} = 'DRAMMEN';
$borough_number{'3039'} = '0602'; $type{'3039'} = 'G'; $location{'3039'} = 'DRAMMEN';
$borough_number{'3040'} = '0602'; $type{'3040'} = 'G'; $location{'3040'} = 'DRAMMEN';
$borough_number{'3041'} = '0602'; $type{'3041'} = 'G'; $location{'3041'} = 'DRAMMEN';
$borough_number{'3042'} = '0602'; $type{'3042'} = 'G'; $location{'3042'} = 'DRAMMEN';
$borough_number{'3043'} = '0602'; $type{'3043'} = 'G'; $location{'3043'} = 'DRAMMEN';
$borough_number{'3044'} = '0602'; $type{'3044'} = 'G'; $location{'3044'} = 'DRAMMEN';
$borough_number{'3045'} = '0602'; $type{'3045'} = 'G'; $location{'3045'} = 'DRAMMEN';
$borough_number{'3046'} = '0602'; $type{'3046'} = 'G'; $location{'3046'} = 'DRAMMEN';
$borough_number{'3047'} = '0602'; $type{'3047'} = 'G'; $location{'3047'} = 'DRAMMEN';
$borough_number{'3048'} = '0602'; $type{'3048'} = 'G'; $location{'3048'} = 'DRAMMEN';
$borough_number{'3050'} = '0625'; $type{'3050'} = 'G'; $location{'3050'} = 'MJNDALEN';
$borough_number{'3051'} = '0625'; $type{'3051'} = 'P'; $location{'3051'} = 'MJNDALEN';
$borough_number{'3053'} = '0625'; $type{'3053'} = 'G'; $location{'3053'} = 'STEINBERG';
$borough_number{'3054'} = '0625'; $type{'3054'} = 'P'; $location{'3054'} = 'KROKSTADELVA';
$borough_number{'3055'} = '0625'; $type{'3055'} = 'G'; $location{'3055'} = 'KROKSTADELVA';
$borough_number{'3056'} = '0625'; $type{'3056'} = 'P'; $location{'3056'} = 'SOLBERGELVA';
$borough_number{'3057'} = '0625'; $type{'3057'} = 'G'; $location{'3057'} = 'SOLBERGELVA';
$borough_number{'3058'} = '0625'; $type{'3058'} = 'G'; $location{'3058'} = 'SOLBERGMOEN';
$borough_number{'3060'} = '0711'; $type{'3060'} = 'G'; $location{'3060'} = 'SVELVIK';
$borough_number{'3061'} = '0711'; $type{'3061'} = 'P'; $location{'3061'} = 'SVELVIK';
$borough_number{'3070'} = '0713'; $type{'3070'} = 'G'; $location{'3070'} = 'SANDE I VESTFOLD';
$borough_number{'3071'} = '0713'; $type{'3071'} = 'P'; $location{'3071'} = 'SANDE I VESTFOLD';
$borough_number{'3075'} = '0711'; $type{'3075'} = 'G'; $location{'3075'} = 'BERGER';
$borough_number{'3080'} = '0702'; $type{'3080'} = 'G'; $location{'3080'} = 'HOLMESTRAND';
$borough_number{'3081'} = '0702'; $type{'3081'} = 'P'; $location{'3081'} = 'HOLMESTRAND';
$borough_number{'3087'} = '0702'; $type{'3087'} = 'P'; $location{'3087'} = 'BOTNE';
$borough_number{'3088'} = '0702'; $type{'3088'} = 'P'; $location{'3088'} = 'BOTNE';
$borough_number{'3090'} = '0714'; $type{'3090'} = 'B'; $location{'3090'} = 'HOF';
$borough_number{'3092'} = '0714'; $type{'3092'} = 'G'; $location{'3092'} = 'SUNDBYFOSS';
$borough_number{'3095'} = '0714'; $type{'3095'} = 'B'; $location{'3095'} = 'EIDSFOSS';
$borough_number{'3101'} = '0704'; $type{'3101'} = 'P'; $location{'3101'} = 'TNSBERG';
$borough_number{'3103'} = '0704'; $type{'3103'} = 'P'; $location{'3103'} = 'TNSBERG';
$borough_number{'3104'} = '0704'; $type{'3104'} = 'P'; $location{'3104'} = 'TNSBERG';
$borough_number{'3105'} = '0704'; $type{'3105'} = 'P'; $location{'3105'} = 'TNSBERG';
$borough_number{'3106'} = '0722'; $type{'3106'} = 'P'; $location{'3106'} = 'TNSBERG';
$borough_number{'3107'} = '0704'; $type{'3107'} = 'P'; $location{'3107'} = 'SEM';
$borough_number{'3108'} = '0720'; $type{'3108'} = 'P'; $location{'3108'} = 'VEAR';
$borough_number{'3109'} = '0704'; $type{'3109'} = 'P'; $location{'3109'} = 'TNSBERG';
$borough_number{'3110'} = '0704'; $type{'3110'} = 'G'; $location{'3110'} = 'TNSBERG';
$borough_number{'3111'} = '0704'; $type{'3111'} = 'G'; $location{'3111'} = 'TNSBERG';
$borough_number{'3112'} = '0704'; $type{'3112'} = 'G'; $location{'3112'} = 'TNSBERG';
$borough_number{'3113'} = '0704'; $type{'3113'} = 'B'; $location{'3113'} = 'TNSBERG';
$borough_number{'3114'} = '0704'; $type{'3114'} = 'G'; $location{'3114'} = 'TNSBERG';
$borough_number{'3115'} = '0722'; $type{'3115'} = 'G'; $location{'3115'} = 'TNSBERG';
$borough_number{'3116'} = '0704'; $type{'3116'} = 'G'; $location{'3116'} = 'TNSBERG';
$borough_number{'3117'} = '0704'; $type{'3117'} = 'G'; $location{'3117'} = 'TNSBERG';
$borough_number{'3118'} = '0704'; $type{'3118'} = 'G'; $location{'3118'} = 'TNSBERG';
$borough_number{'3119'} = '0704'; $type{'3119'} = 'P'; $location{'3119'} = 'TNSBERG';
$borough_number{'3120'} = '0722'; $type{'3120'} = 'G'; $location{'3120'} = 'TNSBERG';
$borough_number{'3121'} = '0722'; $type{'3121'} = 'G'; $location{'3121'} = 'TNSBERG';
$borough_number{'3122'} = '0704'; $type{'3122'} = 'G'; $location{'3122'} = 'TNSBERG';
$borough_number{'3123'} = '0704'; $type{'3123'} = 'G'; $location{'3123'} = 'TNSBERG';
$borough_number{'3124'} = '0704'; $type{'3124'} = 'G'; $location{'3124'} = 'TNSBERG';
$borough_number{'3125'} = '0704'; $type{'3125'} = 'G'; $location{'3125'} = 'TNSBERG';
$borough_number{'3126'} = '0704'; $type{'3126'} = 'G'; $location{'3126'} = 'TNSBERG';
$borough_number{'3131'} = '0722'; $type{'3131'} = 'P'; $location{'3131'} = 'HUSYSUND';
$borough_number{'3132'} = '0722'; $type{'3132'} = 'G'; $location{'3132'} = 'HUSYSUND';
$borough_number{'3133'} = '0722'; $type{'3133'} = 'G'; $location{'3133'} = 'DUKEN';
$borough_number{'3135'} = '0722'; $type{'3135'} = 'G'; $location{'3135'} = 'TORD';
$borough_number{'3137'} = '0722'; $type{'3137'} = 'P'; $location{'3137'} = 'TORD';
$borough_number{'3138'} = '0722'; $type{'3138'} = 'B'; $location{'3138'} = 'SKALLESTAD';
$borough_number{'3140'} = '0722'; $type{'3140'} = 'G'; $location{'3140'} = 'BORGHEIM';
$borough_number{'3141'} = '0722'; $type{'3141'} = 'P'; $location{'3141'} = 'KJPMANNSKJR';
$borough_number{'3142'} = '0722'; $type{'3142'} = 'G'; $location{'3142'} = 'VESTSKOGEN';
$borough_number{'3143'} = '0722'; $type{'3143'} = 'G'; $location{'3143'} = 'KJPMANNSKJR';
$borough_number{'3144'} = '0722'; $type{'3144'} = 'B'; $location{'3144'} = 'VEIERLAND';
$borough_number{'3145'} = '0723'; $type{'3145'} = 'G'; $location{'3145'} = 'TJME';
$borough_number{'3147'} = '0723'; $type{'3147'} = 'G'; $location{'3147'} = 'VERDENS ENDE';
$borough_number{'3148'} = '0723'; $type{'3148'} = 'G'; $location{'3148'} = 'HVASSER';
$borough_number{'3150'} = '0704'; $type{'3150'} = 'G'; $location{'3150'} = 'TOLVSRD';
$borough_number{'3151'} = '0704'; $type{'3151'} = 'G'; $location{'3151'} = 'TOLVSRD';
$borough_number{'3152'} = '0704'; $type{'3152'} = 'G'; $location{'3152'} = 'TOLVSRD';
$borough_number{'3153'} = '0704'; $type{'3153'} = 'G'; $location{'3153'} = 'TOLVSRD';
$borough_number{'3154'} = '0704'; $type{'3154'} = 'G'; $location{'3154'} = 'TOLVSRD';
$borough_number{'3157'} = '0704'; $type{'3157'} = 'G'; $location{'3157'} = 'BARKKER';
$borough_number{'3158'} = '0719'; $type{'3158'} = 'G'; $location{'3158'} = 'ANDEBU';
$borough_number{'3159'} = '0720'; $type{'3159'} = 'B'; $location{'3159'} = 'MELSOMVIK';
$borough_number{'3160'} = '0720'; $type{'3160'} = 'G'; $location{'3160'} = 'STOKKE';
$borough_number{'3161'} = '0720'; $type{'3161'} = 'P'; $location{'3161'} = 'STOKKE';
$borough_number{'3162'} = '0719'; $type{'3162'} = 'P'; $location{'3162'} = 'ANDEBU';
$borough_number{'3163'} = '0722'; $type{'3163'} = 'P'; $location{'3163'} = 'BORGHEIM';
$borough_number{'3164'} = '0716'; $type{'3164'} = 'P'; $location{'3164'} = 'REVETAL';
$borough_number{'3165'} = '0723'; $type{'3165'} = 'P'; $location{'3165'} = 'TJME';
$borough_number{'3166'} = '0704'; $type{'3166'} = 'P'; $location{'3166'} = 'TOLVSRD';
$borough_number{'3167'} = '0701'; $type{'3167'} = 'P'; $location{'3167'} = 'SGRDSTRAND';
$borough_number{'3168'} = '0720'; $type{'3168'} = 'P'; $location{'3168'} = 'MELSOMVIK';
$borough_number{'3169'} = '0720'; $type{'3169'} = 'K'; $location{'3169'} = 'STOKKE';
$borough_number{'3170'} = '0704'; $type{'3170'} = 'G'; $location{'3170'} = 'SEM';
$borough_number{'3171'} = '0704'; $type{'3171'} = 'G'; $location{'3171'} = 'SEM';
$borough_number{'3172'} = '0704'; $type{'3172'} = 'G'; $location{'3172'} = 'VEAR';
$borough_number{'3173'} = '0720'; $type{'3173'} = 'G'; $location{'3173'} = 'VEAR';
$borough_number{'3174'} = '0716'; $type{'3174'} = 'G'; $location{'3174'} = 'REVETAL';
$borough_number{'3175'} = '0716'; $type{'3175'} = 'G'; $location{'3175'} = 'RAMNES';
$borough_number{'3177'} = '0716'; $type{'3177'} = 'P'; $location{'3177'} = 'VLE';
$borough_number{'3178'} = '0716'; $type{'3178'} = 'G'; $location{'3178'} = 'VLE';
$borough_number{'3179'} = '0701'; $type{'3179'} = 'G'; $location{'3179'} = 'SGRDSTRAND';
$borough_number{'3180'} = '0701'; $type{'3180'} = 'B'; $location{'3180'} = 'NYKIRKE';
$borough_number{'3181'} = '0701'; $type{'3181'} = 'G'; $location{'3181'} = 'HORTEN';
$borough_number{'3182'} = '0701'; $type{'3182'} = 'G'; $location{'3182'} = 'HORTEN';
$borough_number{'3183'} = '0701'; $type{'3183'} = 'G'; $location{'3183'} = 'HORTEN';
$borough_number{'3184'} = '0701'; $type{'3184'} = 'B'; $location{'3184'} = 'BORRE';
$borough_number{'3185'} = '0701'; $type{'3185'} = 'G'; $location{'3185'} = 'SKOPPUM';
$borough_number{'3186'} = '0701'; $type{'3186'} = 'G'; $location{'3186'} = 'HORTEN';
$borough_number{'3187'} = '0701'; $type{'3187'} = 'G'; $location{'3187'} = 'HORTEN';
$borough_number{'3188'} = '0701'; $type{'3188'} = 'G'; $location{'3188'} = 'HORTEN';
$borough_number{'3189'} = '0701'; $type{'3189'} = 'G'; $location{'3189'} = 'HORTEN';
$borough_number{'3191'} = '0701'; $type{'3191'} = 'P'; $location{'3191'} = 'HORTEN';
$borough_number{'3192'} = '0701'; $type{'3192'} = 'P'; $location{'3192'} = 'HORTEN';
$borough_number{'3193'} = '0701'; $type{'3193'} = 'P'; $location{'3193'} = 'HORTEN';
$borough_number{'3194'} = '0701'; $type{'3194'} = 'P'; $location{'3194'} = 'HORTEN';
$borough_number{'3195'} = '0701'; $type{'3195'} = 'P'; $location{'3195'} = 'SKOPPUM';
$borough_number{'3196'} = '0701'; $type{'3196'} = 'P'; $location{'3196'} = 'HORTEN';
$borough_number{'3197'} = '0701'; $type{'3197'} = 'K'; $location{'3197'} = 'HORTEN';
$borough_number{'3201'} = '0706'; $type{'3201'} = 'P'; $location{'3201'} = 'SANDEFJORD';
$borough_number{'3202'} = '0706'; $type{'3202'} = 'P'; $location{'3202'} = 'SANDEFJORD';
$borough_number{'3203'} = '0706'; $type{'3203'} = 'P'; $location{'3203'} = 'SANDEFJORD';
$borough_number{'3204'} = '0706'; $type{'3204'} = 'P'; $location{'3204'} = 'SANDEFJORD';
$borough_number{'3205'} = '0706'; $type{'3205'} = 'P'; $location{'3205'} = 'SANDEFJORD';
$borough_number{'3206'} = '0706'; $type{'3206'} = 'P'; $location{'3206'} = 'SANDEFJORD';
$borough_number{'3207'} = '0706'; $type{'3207'} = 'P'; $location{'3207'} = 'SANDEFJORD';
$borough_number{'3208'} = '0706'; $type{'3208'} = 'G'; $location{'3208'} = 'SANDEFJORD';
$borough_number{'3209'} = '0706'; $type{'3209'} = 'B'; $location{'3209'} = 'SANDEFJORD';
$borough_number{'3210'} = '0706'; $type{'3210'} = 'G'; $location{'3210'} = 'SANDEFJORD';
$borough_number{'3211'} = '0706'; $type{'3211'} = 'G'; $location{'3211'} = 'SANDEFJORD';
$borough_number{'3212'} = '0706'; $type{'3212'} = 'G'; $location{'3212'} = 'SANDEFJORD';
$borough_number{'3213'} = '0706'; $type{'3213'} = 'G'; $location{'3213'} = 'SANDEFJORD';
$borough_number{'3214'} = '0706'; $type{'3214'} = 'G'; $location{'3214'} = 'SANDEFJORD';
$borough_number{'3215'} = '0706'; $type{'3215'} = 'G'; $location{'3215'} = 'SANDEFJORD';
$borough_number{'3216'} = '0706'; $type{'3216'} = 'G'; $location{'3216'} = 'SANDEFJORD';
$borough_number{'3217'} = '0706'; $type{'3217'} = 'G'; $location{'3217'} = 'SANDEFJORD';
$borough_number{'3218'} = '0706'; $type{'3218'} = 'G'; $location{'3218'} = 'SANDEFJORD';
$borough_number{'3219'} = '0706'; $type{'3219'} = 'G'; $location{'3219'} = 'SANDEFJORD';
$borough_number{'3220'} = '0706'; $type{'3220'} = 'G'; $location{'3220'} = 'SANDEFJORD';
$borough_number{'3221'} = '0706'; $type{'3221'} = 'G'; $location{'3221'} = 'SANDEFJORD';
$borough_number{'3222'} = '0706'; $type{'3222'} = 'G'; $location{'3222'} = 'SANDEFJORD';
$borough_number{'3223'} = '0706'; $type{'3223'} = 'G'; $location{'3223'} = 'SANDEFJORD';
$borough_number{'3224'} = '0706'; $type{'3224'} = 'G'; $location{'3224'} = 'SANDEFJORD';
$borough_number{'3225'} = '0706'; $type{'3225'} = 'G'; $location{'3225'} = 'SANDEFJORD';
$borough_number{'3226'} = '0706'; $type{'3226'} = 'B'; $location{'3226'} = 'SANDEFJORD';
$borough_number{'3227'} = '0706'; $type{'3227'} = 'G'; $location{'3227'} = 'SANDEFJORD';
$borough_number{'3228'} = '0706'; $type{'3228'} = 'G'; $location{'3228'} = 'SANDEFJORD';
$borough_number{'3229'} = '0706'; $type{'3229'} = 'G'; $location{'3229'} = 'SANDEFJORD';
$borough_number{'3230'} = '0706'; $type{'3230'} = 'G'; $location{'3230'} = 'SANDEFJORD';
$borough_number{'3231'} = '0706'; $type{'3231'} = 'G'; $location{'3231'} = 'SANDEFJORD';
$borough_number{'3232'} = '0706'; $type{'3232'} = 'G'; $location{'3232'} = 'SANDEFJORD';
$borough_number{'3233'} = '0706'; $type{'3233'} = 'G'; $location{'3233'} = 'SANDEFJORD';
$borough_number{'3234'} = '0706'; $type{'3234'} = 'G'; $location{'3234'} = 'SANDEFJORD';
$borough_number{'3235'} = '0706'; $type{'3235'} = 'G'; $location{'3235'} = 'SANDEFJORD';
$borough_number{'3236'} = '0706'; $type{'3236'} = 'G'; $location{'3236'} = 'SANDEFJORD';
$borough_number{'3237'} = '0706'; $type{'3237'} = 'G'; $location{'3237'} = 'SANDEFJORD';
$borough_number{'3238'} = '0706'; $type{'3238'} = 'G'; $location{'3238'} = 'SANDEFJORD';
$borough_number{'3239'} = '0706'; $type{'3239'} = 'G'; $location{'3239'} = 'SANDEFJORD';
$borough_number{'3240'} = '0706'; $type{'3240'} = 'P'; $location{'3240'} = 'SANDEFJORD';
$borough_number{'3241'} = '0706'; $type{'3241'} = 'G'; $location{'3241'} = 'SANDEFJORD';
$borough_number{'3242'} = '0706'; $type{'3242'} = 'G'; $location{'3242'} = 'SANDEFJORD';
$borough_number{'3243'} = '0719'; $type{'3243'} = 'G'; $location{'3243'} = 'KODAL';
$borough_number{'3244'} = '0706'; $type{'3244'} = 'G'; $location{'3244'} = 'SANDEFJORD';
$borough_number{'3245'} = '0719'; $type{'3245'} = 'P'; $location{'3245'} = 'KODAL';
$borough_number{'3246'} = '0706'; $type{'3246'} = 'P'; $location{'3246'} = 'SANDEFJORD';
$borough_number{'3247'} = '0706'; $type{'3247'} = 'K'; $location{'3247'} = 'SANDEFJORD';
$borough_number{'3248'} = '0706'; $type{'3248'} = 'K'; $location{'3248'} = 'SANDEFJORD';
$borough_number{'3251'} = '0709'; $type{'3251'} = 'P'; $location{'3251'} = 'LARVIK';
$borough_number{'3252'} = '0709'; $type{'3252'} = 'P'; $location{'3252'} = 'LARVIK';
$borough_number{'3253'} = '0709'; $type{'3253'} = 'P'; $location{'3253'} = 'LARVIK';
$borough_number{'3254'} = '0709'; $type{'3254'} = 'P'; $location{'3254'} = 'LARVIK';
$borough_number{'3255'} = '0709'; $type{'3255'} = 'P'; $location{'3255'} = 'LARVIK';
$borough_number{'3256'} = '0709'; $type{'3256'} = 'G'; $location{'3256'} = 'LARVIK';
$borough_number{'3257'} = '0709'; $type{'3257'} = 'G'; $location{'3257'} = 'LARVIK';
$borough_number{'3258'} = '0709'; $type{'3258'} = 'G'; $location{'3258'} = 'LARVIK';
$borough_number{'3259'} = '0709'; $type{'3259'} = 'G'; $location{'3259'} = 'LARVIK';
$borough_number{'3260'} = '0709'; $type{'3260'} = 'G'; $location{'3260'} = 'LARVIK';
$borough_number{'3261'} = '0709'; $type{'3261'} = 'G'; $location{'3261'} = 'LARVIK';
$borough_number{'3262'} = '0709'; $type{'3262'} = 'G'; $location{'3262'} = 'LARVIK';
$borough_number{'3263'} = '0709'; $type{'3263'} = 'G'; $location{'3263'} = 'LARVIK';
$borough_number{'3264'} = '0709'; $type{'3264'} = 'G'; $location{'3264'} = 'LARVIK';
$borough_number{'3265'} = '0709'; $type{'3265'} = 'G'; $location{'3265'} = 'LARVIK';
$borough_number{'3267'} = '0709'; $type{'3267'} = 'G'; $location{'3267'} = 'LARVIK';
$borough_number{'3268'} = '0709'; $type{'3268'} = 'G'; $location{'3268'} = 'LARVIK';
$borough_number{'3269'} = '0709'; $type{'3269'} = 'G'; $location{'3269'} = 'LARVIK';
$borough_number{'3270'} = '0709'; $type{'3270'} = 'G'; $location{'3270'} = 'LARVIK';
$borough_number{'3271'} = '0709'; $type{'3271'} = 'G'; $location{'3271'} = 'LARVIK';
$borough_number{'3274'} = '0709'; $type{'3274'} = 'G'; $location{'3274'} = 'LARVIK';
$borough_number{'3275'} = '0728'; $type{'3275'} = 'G'; $location{'3275'} = 'SVARSTAD';
$borough_number{'3276'} = '0728'; $type{'3276'} = 'P'; $location{'3276'} = 'SVARSTAD';
$borough_number{'3277'} = '0728'; $type{'3277'} = 'G'; $location{'3277'} = 'STEINSHOLT';
$borough_number{'3280'} = '0709'; $type{'3280'} = 'G'; $location{'3280'} = 'TJODALYNG';
$borough_number{'3281'} = '0709'; $type{'3281'} = 'P'; $location{'3281'} = 'TJODALYNG';
$borough_number{'3282'} = '0709'; $type{'3282'} = 'G'; $location{'3282'} = 'KVELDE';
$borough_number{'3284'} = '0709'; $type{'3284'} = 'P'; $location{'3284'} = 'KVELDE';
$borough_number{'3285'} = '0709'; $type{'3285'} = 'P'; $location{'3285'} = 'LARVIK';
$borough_number{'3290'} = '0709'; $type{'3290'} = 'G'; $location{'3290'} = 'STAVERN';
$borough_number{'3291'} = '0709'; $type{'3291'} = 'P'; $location{'3291'} = 'STAVERN';
$borough_number{'3292'} = '0709'; $type{'3292'} = 'G'; $location{'3292'} = 'STAVERN';
$borough_number{'3294'} = '0709'; $type{'3294'} = 'G'; $location{'3294'} = 'STAVERN';
$borough_number{'3295'} = '0709'; $type{'3295'} = 'G'; $location{'3295'} = 'HELGEROA';
$borough_number{'3296'} = '0709'; $type{'3296'} = 'G'; $location{'3296'} = 'NEVLUNGHAMN';
$borough_number{'3297'} = '0709'; $type{'3297'} = 'P'; $location{'3297'} = 'HELGEROA';
$borough_number{'3300'} = '0624'; $type{'3300'} = 'G'; $location{'3300'} = 'HOKKSUND';
$borough_number{'3301'} = '0624'; $type{'3301'} = 'P'; $location{'3301'} = 'HOKKSUND';
$borough_number{'3320'} = '0624'; $type{'3320'} = 'G'; $location{'3320'} = 'VESTFOSSEN';
$borough_number{'3321'} = '0624'; $type{'3321'} = 'P'; $location{'3321'} = 'VESTFOSSEN';
$borough_number{'3322'} = '0624'; $type{'3322'} = 'G'; $location{'3322'} = 'DARBU';
$borough_number{'3330'} = '0624'; $type{'3330'} = 'G'; $location{'3330'} = 'SKOTSELV';
$borough_number{'3331'} = '0624'; $type{'3331'} = 'P'; $location{'3331'} = 'SKOTSELV';
$borough_number{'3340'} = '0623'; $type{'3340'} = 'G'; $location{'3340'} = 'MOT';
$borough_number{'3341'} = '0623'; $type{'3341'} = 'P'; $location{'3341'} = 'MOT';
$borough_number{'3342'} = '0623'; $type{'3342'} = 'P'; $location{'3342'} = 'MOT';
$borough_number{'3350'} = '0621'; $type{'3350'} = 'G'; $location{'3350'} = 'PRESTFOSS';
$borough_number{'3351'} = '0621'; $type{'3351'} = 'P'; $location{'3351'} = 'PRESTFOSS';
$borough_number{'3355'} = '0621'; $type{'3355'} = 'G'; $location{'3355'} = 'SOLUMSMOEN';
$borough_number{'3358'} = '0621'; $type{'3358'} = 'G'; $location{'3358'} = 'NEDRE EGGEDAL';
$borough_number{'3359'} = '0621'; $type{'3359'} = 'B'; $location{'3359'} = 'EGGEDAL';
$borough_number{'3360'} = '0623'; $type{'3360'} = 'G'; $location{'3360'} = 'GEITHUS';
$borough_number{'3361'} = '0623'; $type{'3361'} = 'P'; $location{'3361'} = 'GEITHUS';
$borough_number{'3370'} = '0623'; $type{'3370'} = 'G'; $location{'3370'} = 'VIKERSUND';
$borough_number{'3371'} = '0623'; $type{'3371'} = 'P'; $location{'3371'} = 'VIKERSUND';
$borough_number{'3387'} = '0623'; $type{'3387'} = 'G'; $location{'3387'} = 'SNARUM';
$borough_number{'3400'} = '0626'; $type{'3400'} = 'G'; $location{'3400'} = 'LIER';
$borough_number{'3401'} = '0626'; $type{'3401'} = 'P'; $location{'3401'} = 'LIER';
$borough_number{'3407'} = '0626'; $type{'3407'} = 'P'; $location{'3407'} = 'TRANBY';
$borough_number{'3408'} = '0626'; $type{'3408'} = 'G'; $location{'3408'} = 'TRANBY';
$borough_number{'3410'} = '0626'; $type{'3410'} = 'G'; $location{'3410'} = 'SYLLING';
$borough_number{'3411'} = '0626'; $type{'3411'} = 'P'; $location{'3411'} = 'SYLLING';
$borough_number{'3412'} = '0626'; $type{'3412'} = 'P'; $location{'3412'} = 'LIERSTRANDA';
$borough_number{'3420'} = '0626'; $type{'3420'} = 'G'; $location{'3420'} = 'LIERSKOGEN';
$borough_number{'3421'} = '0626'; $type{'3421'} = 'P'; $location{'3421'} = 'LIERSKOGEN';
$borough_number{'3425'} = '0626'; $type{'3425'} = 'G'; $location{'3425'} = 'REISTAD';
$borough_number{'3428'} = '0626'; $type{'3428'} = 'P'; $location{'3428'} = 'LIER';
$borough_number{'3430'} = '0627'; $type{'3430'} = 'G'; $location{'3430'} = 'SPIKKESTAD';
$borough_number{'3431'} = '0627'; $type{'3431'} = 'P'; $location{'3431'} = 'SPIKKESTAD';
$borough_number{'3440'} = '0627'; $type{'3440'} = 'G'; $location{'3440'} = 'RYKEN';
$borough_number{'3441'} = '0627'; $type{'3441'} = 'P'; $location{'3441'} = 'RYKEN';
$borough_number{'3442'} = '0627'; $type{'3442'} = 'G'; $location{'3442'} = 'HYGGEN';
$borough_number{'3470'} = '0627'; $type{'3470'} = 'G'; $location{'3470'} = 'SLEMMESTAD';
$borough_number{'3471'} = '0627'; $type{'3471'} = 'P'; $location{'3471'} = 'SLEMMESTAD';
$borough_number{'3472'} = '0627'; $type{'3472'} = 'G'; $location{'3472'} = 'BDALEN';
$borough_number{'3474'} = '0627'; $type{'3474'} = 'G'; $location{'3474'} = 'ROS';
$borough_number{'3475'} = '0628'; $type{'3475'} = 'G'; $location{'3475'} = 'STRE';
$borough_number{'3476'} = '0628'; $type{'3476'} = 'P'; $location{'3476'} = 'STRE';
$borough_number{'3477'} = '0627'; $type{'3477'} = 'G'; $location{'3477'} = 'BTST';
$borough_number{'3478'} = '0627'; $type{'3478'} = 'B'; $location{'3478'} = 'NRSNES';
$borough_number{'3480'} = '0628'; $type{'3480'} = 'B'; $location{'3480'} = 'FILTVET';
$borough_number{'3481'} = '0628'; $type{'3481'} = 'P'; $location{'3481'} = 'TOFTE';
$borough_number{'3482'} = '0628'; $type{'3482'} = 'G'; $location{'3482'} = 'TOFTE';
$borough_number{'3483'} = '0628'; $type{'3483'} = 'G'; $location{'3483'} = 'KANA';
$borough_number{'3484'} = '0628'; $type{'3484'} = 'G'; $location{'3484'} = 'HOLMSBU';
$borough_number{'3490'} = '0628'; $type{'3490'} = 'G'; $location{'3490'} = 'KLOKKARSTUA';
$borough_number{'3491'} = '0628'; $type{'3491'} = 'P'; $location{'3491'} = 'KLOKKARSTUA';
$borough_number{'3501'} = '0605'; $type{'3501'} = 'P'; $location{'3501'} = 'HNEFOSS';
$borough_number{'3502'} = '0605'; $type{'3502'} = 'P'; $location{'3502'} = 'HNEFOSS';
$borough_number{'3503'} = '0605'; $type{'3503'} = 'P'; $location{'3503'} = 'HNEFOSS';
$borough_number{'3504'} = '0605'; $type{'3504'} = 'S'; $location{'3504'} = 'HNEFOSS';
$borough_number{'3505'} = '0605'; $type{'3505'} = 'K'; $location{'3505'} = 'HNEFOSS';
$borough_number{'3506'} = '0605'; $type{'3506'} = 'K'; $location{'3506'} = 'HNEFOSS';
$borough_number{'3507'} = '0605'; $type{'3507'} = 'K'; $location{'3507'} = 'HNEFOSS';
$borough_number{'3510'} = '0605'; $type{'3510'} = 'G'; $location{'3510'} = 'HNEFOSS';
$borough_number{'3511'} = '0605'; $type{'3511'} = 'G'; $location{'3511'} = 'HNEFOSS';
$borough_number{'3512'} = '0605'; $type{'3512'} = 'G'; $location{'3512'} = 'HNEFOSS';
$borough_number{'3513'} = '0605'; $type{'3513'} = 'G'; $location{'3513'} = 'HNEFOSS';
$borough_number{'3514'} = '0605'; $type{'3514'} = 'G'; $location{'3514'} = 'HNEFOSS';
$borough_number{'3515'} = '0605'; $type{'3515'} = 'G'; $location{'3515'} = 'HNEFOSS';
$borough_number{'3516'} = '0605'; $type{'3516'} = 'G'; $location{'3516'} = 'HNEFOSS';
$borough_number{'3517'} = '0605'; $type{'3517'} = 'G'; $location{'3517'} = 'HNEFOSS';
$borough_number{'3518'} = '0605'; $type{'3518'} = 'G'; $location{'3518'} = 'HNEFOSS';
$borough_number{'3519'} = '0605'; $type{'3519'} = 'G'; $location{'3519'} = 'HNEFOSS';
$borough_number{'3520'} = '0532'; $type{'3520'} = 'G'; $location{'3520'} = 'JEVNAKER';
$borough_number{'3521'} = '0532'; $type{'3521'} = 'P'; $location{'3521'} = 'JEVNAKER';
$borough_number{'3522'} = '0534'; $type{'3522'} = 'G'; $location{'3522'} = 'BJONEROA';
$borough_number{'3523'} = '0605'; $type{'3523'} = 'P'; $location{'3523'} = 'NES I DAL';
$borough_number{'3524'} = '0605'; $type{'3524'} = 'G'; $location{'3524'} = 'NES I DAL';
$borough_number{'3525'} = '0605'; $type{'3525'} = 'G'; $location{'3525'} = 'HALLINGBY';
$borough_number{'3526'} = '0605'; $type{'3526'} = 'P'; $location{'3526'} = 'HALLINGBY';
$borough_number{'3528'} = '0540'; $type{'3528'} = 'G'; $location{'3528'} = 'HEDALEN';
$borough_number{'3529'} = '0612'; $type{'3529'} = 'P'; $location{'3529'} = 'RYSE';
$borough_number{'3530'} = '0612'; $type{'3530'} = 'G'; $location{'3530'} = 'RYSE';
$borough_number{'3531'} = '0612'; $type{'3531'} = 'B'; $location{'3531'} = 'KROKKLEIVA';
$borough_number{'3533'} = '0605'; $type{'3533'} = 'B'; $location{'3533'} = 'TYRISTRAND';
$borough_number{'3534'} = '0605'; $type{'3534'} = 'B'; $location{'3534'} = 'SOKNA';
$borough_number{'3535'} = '0622'; $type{'3535'} = 'G'; $location{'3535'} = 'KRDEREN';
$borough_number{'3536'} = '0622'; $type{'3536'} = 'B'; $location{'3536'} = 'NORESUND';
$borough_number{'3537'} = '0622'; $type{'3537'} = 'P'; $location{'3537'} = 'KRDEREN';
$borough_number{'3538'} = '0612'; $type{'3538'} = 'G'; $location{'3538'} = 'SOLLIHGDA';
$borough_number{'3539'} = '0615'; $type{'3539'} = 'B'; $location{'3539'} = 'FL';
$borough_number{'3540'} = '0616'; $type{'3540'} = 'G'; $location{'3540'} = 'NESBYEN';
$borough_number{'3541'} = '0616'; $type{'3541'} = 'P'; $location{'3541'} = 'NESBYEN';
$borough_number{'3550'} = '0617'; $type{'3550'} = 'G'; $location{'3550'} = 'GOL';
$borough_number{'3551'} = '0617'; $type{'3551'} = 'P'; $location{'3551'} = 'GOL';
$borough_number{'3560'} = '0618'; $type{'3560'} = 'G'; $location{'3560'} = 'HEMSEDAL';
$borough_number{'3561'} = '0618'; $type{'3561'} = 'P'; $location{'3561'} = 'HEMSEDAL';
$borough_number{'3570'} = '0619'; $type{'3570'} = 'G'; $location{'3570'} = 'L';
$borough_number{'3571'} = '0619'; $type{'3571'} = 'P'; $location{'3571'} = 'L';
$borough_number{'3575'} = '0620'; $type{'3575'} = 'P'; $location{'3575'} = 'HOL';
$borough_number{'3576'} = '0620'; $type{'3576'} = 'G'; $location{'3576'} = 'HOL';
$borough_number{'3577'} = '0620'; $type{'3577'} = 'G'; $location{'3577'} = 'HOVET';
$borough_number{'3579'} = '0619'; $type{'3579'} = 'G'; $location{'3579'} = 'TORPO';
$borough_number{'3580'} = '0620'; $type{'3580'} = 'G'; $location{'3580'} = 'GEILO';
$borough_number{'3581'} = '0620'; $type{'3581'} = 'P'; $location{'3581'} = 'GEILO';
$borough_number{'3593'} = '0620'; $type{'3593'} = 'B'; $location{'3593'} = 'USTAOSET';
$borough_number{'3595'} = '0620'; $type{'3595'} = 'B'; $location{'3595'} = 'HAUGASTL';
$borough_number{'3596'} = '1232'; $type{'3596'} = 'G'; $location{'3596'} = 'HALNE FJELLSTOVA';
$borough_number{'3598'} = '1232'; $type{'3598'} = 'G'; $location{'3598'} = 'DYRANUT';
$borough_number{'3599'} = '1232'; $type{'3599'} = 'G'; $location{'3599'} = 'SANDHAUG';
$borough_number{'3601'} = '0604'; $type{'3601'} = 'S'; $location{'3601'} = 'KONGSBERG';
$borough_number{'3602'} = '0604'; $type{'3602'} = 'P'; $location{'3602'} = 'KONGSBERG';
$borough_number{'3603'} = '0604'; $type{'3603'} = 'P'; $location{'3603'} = 'KONGSBERG';
$borough_number{'3604'} = '0604'; $type{'3604'} = 'P'; $location{'3604'} = 'KONGSBERG';
$borough_number{'3605'} = '0604'; $type{'3605'} = 'P'; $location{'3605'} = 'KONGSBERG';
$borough_number{'3606'} = '0604'; $type{'3606'} = 'P'; $location{'3606'} = 'KONGSBERG';
$borough_number{'3608'} = '0604'; $type{'3608'} = 'K'; $location{'3608'} = 'HEISTADMOEN';
$borough_number{'3610'} = '0604'; $type{'3610'} = 'B'; $location{'3610'} = 'KONGSBERG';
$borough_number{'3611'} = '0604'; $type{'3611'} = 'G'; $location{'3611'} = 'KONGSBERG';
$borough_number{'3612'} = '0604'; $type{'3612'} = 'G'; $location{'3612'} = 'KONGSBERG';
$borough_number{'3613'} = '0604'; $type{'3613'} = 'G'; $location{'3613'} = 'KONGSBERG';
$borough_number{'3614'} = '0604'; $type{'3614'} = 'G'; $location{'3614'} = 'KONGSBERG';
$borough_number{'3615'} = '0604'; $type{'3615'} = 'G'; $location{'3615'} = 'KONGSBERG';
$borough_number{'3616'} = '0604'; $type{'3616'} = 'G'; $location{'3616'} = 'KONGSBERG';
$borough_number{'3617'} = '0604'; $type{'3617'} = 'G'; $location{'3617'} = 'KONGSBERG';
$borough_number{'3618'} = '0604'; $type{'3618'} = 'B'; $location{'3618'} = 'SKOLLENBORG';
$borough_number{'3619'} = '0604'; $type{'3619'} = 'G'; $location{'3619'} = 'SKOLLENBORG';
$borough_number{'3620'} = '0631'; $type{'3620'} = 'G'; $location{'3620'} = 'FLESBERG';
$borough_number{'3621'} = '0631'; $type{'3621'} = 'P'; $location{'3621'} = 'LAMPELAND';
$borough_number{'3622'} = '0631'; $type{'3622'} = 'G'; $location{'3622'} = 'SVENE';
$borough_number{'3623'} = '0631'; $type{'3623'} = 'G'; $location{'3623'} = 'LAMPELAND';
$borough_number{'3624'} = '0631'; $type{'3624'} = 'G'; $location{'3624'} = 'LYNGDAL I NUMEDAL';
$borough_number{'3626'} = '0632'; $type{'3626'} = 'G'; $location{'3626'} = 'ROLLAG';
$borough_number{'3627'} = '0632'; $type{'3627'} = 'P'; $location{'3627'} = 'VEGGLI';
$borough_number{'3628'} = '0632'; $type{'3628'} = 'G'; $location{'3628'} = 'VEGGLI';
$borough_number{'3629'} = '0633'; $type{'3629'} = 'B'; $location{'3629'} = 'NORE';
$borough_number{'3630'} = '0633'; $type{'3630'} = 'G'; $location{'3630'} = 'RDBERG';
$borough_number{'3631'} = '0633'; $type{'3631'} = 'P'; $location{'3631'} = 'RDBERG';
$borough_number{'3632'} = '0633'; $type{'3632'} = 'G'; $location{'3632'} = 'UVDAL';
$borough_number{'3646'} = '0604'; $type{'3646'} = 'P'; $location{'3646'} = 'HVITTINGFOSS';
$borough_number{'3647'} = '0604'; $type{'3647'} = 'G'; $location{'3647'} = 'HVITTINGFOSS';
$borough_number{'3648'} = '0604'; $type{'3648'} = 'G'; $location{'3648'} = 'PASSEBEKK';
$borough_number{'3650'} = '0826'; $type{'3650'} = 'G'; $location{'3650'} = 'TINN AUSTBYGD';
$borough_number{'3652'} = '0826'; $type{'3652'} = 'G'; $location{'3652'} = 'HOVIN I TELEMARK';
$borough_number{'3656'} = '0826'; $type{'3656'} = 'G'; $location{'3656'} = 'ATR';
$borough_number{'3658'} = '0826'; $type{'3658'} = 'G'; $location{'3658'} = 'MILAND';
$borough_number{'3660'} = '0826'; $type{'3660'} = 'G'; $location{'3660'} = 'RJUKAN';
$borough_number{'3661'} = '0826'; $type{'3661'} = 'P'; $location{'3661'} = 'RJUKAN';
$borough_number{'3665'} = '0827'; $type{'3665'} = 'P'; $location{'3665'} = 'SAULAND';
$borough_number{'3666'} = '0826'; $type{'3666'} = 'P'; $location{'3666'} = 'TINN AUSTBYGD';
$borough_number{'3671'} = '0807'; $type{'3671'} = 'P'; $location{'3671'} = 'NOTODDEN';
$borough_number{'3672'} = '0807'; $type{'3672'} = 'P'; $location{'3672'} = 'NOTODDEN';
$borough_number{'3673'} = '0807'; $type{'3673'} = 'P'; $location{'3673'} = 'NOTODDEN';
$borough_number{'3674'} = '0807'; $type{'3674'} = 'G'; $location{'3674'} = 'NOTODDEN';
$borough_number{'3675'} = '0807'; $type{'3675'} = 'G'; $location{'3675'} = 'NOTODDEN';
$borough_number{'3676'} = '0807'; $type{'3676'} = 'G'; $location{'3676'} = 'NOTODDEN';
$borough_number{'3677'} = '0807'; $type{'3677'} = 'G'; $location{'3677'} = 'NOTODDEN';
$borough_number{'3678'} = '0807'; $type{'3678'} = 'G'; $location{'3678'} = 'NOTODDEN';
$borough_number{'3679'} = '0807'; $type{'3679'} = 'G'; $location{'3679'} = 'NOTODDEN';
$borough_number{'3680'} = '0807'; $type{'3680'} = 'G'; $location{'3680'} = 'NOTODDEN';
$borough_number{'3681'} = '0807'; $type{'3681'} = 'G'; $location{'3681'} = 'NOTODDEN';
$borough_number{'3683'} = '0807'; $type{'3683'} = 'G'; $location{'3683'} = 'NOTODDEN';
$borough_number{'3684'} = '0807'; $type{'3684'} = 'G'; $location{'3684'} = 'NOTODDEN';
$borough_number{'3690'} = '0827'; $type{'3690'} = 'G'; $location{'3690'} = 'HJARTDAL';
$borough_number{'3691'} = '0807'; $type{'3691'} = 'G'; $location{'3691'} = 'GRANSHERAD';
$borough_number{'3692'} = '0827'; $type{'3692'} = 'G'; $location{'3692'} = 'SAULAND';
$borough_number{'3697'} = '0827'; $type{'3697'} = 'G'; $location{'3697'} = 'TUDDAL';
$borough_number{'3699'} = '0826'; $type{'3699'} = 'G'; $location{'3699'} = 'GAUSTATOPPEN TURISTHYTTE';
$borough_number{'3701'} = '0806'; $type{'3701'} = 'P'; $location{'3701'} = 'SKIEN';
$borough_number{'3702'} = '0806'; $type{'3702'} = 'P'; $location{'3702'} = 'SKIEN';
$borough_number{'3703'} = '0806'; $type{'3703'} = 'P'; $location{'3703'} = 'SKIEN';
$borough_number{'3704'} = '0806'; $type{'3704'} = 'P'; $location{'3704'} = 'SKIEN';
$borough_number{'3705'} = '0806'; $type{'3705'} = 'P'; $location{'3705'} = 'SKIEN';
$borough_number{'3706'} = '0806'; $type{'3706'} = 'K'; $location{'3706'} = 'SKIEN';
$borough_number{'3707'} = '0806'; $type{'3707'} = 'P'; $location{'3707'} = 'SKIEN';
$borough_number{'3708'} = '0806'; $type{'3708'} = 'K'; $location{'3708'} = 'SKIEN';
$borough_number{'3709'} = '0806'; $type{'3709'} = 'K'; $location{'3709'} = 'SKIEN';
$borough_number{'3710'} = '0806'; $type{'3710'} = 'F'; $location{'3710'} = 'SKIEN';
$borough_number{'3711'} = '0806'; $type{'3711'} = 'G'; $location{'3711'} = 'SKIEN';
$borough_number{'3712'} = '0806'; $type{'3712'} = 'G'; $location{'3712'} = 'SKIEN';
$borough_number{'3713'} = '0806'; $type{'3713'} = 'G'; $location{'3713'} = 'SKIEN';
$borough_number{'3714'} = '0806'; $type{'3714'} = 'G'; $location{'3714'} = 'SKIEN';
$borough_number{'3715'} = '0806'; $type{'3715'} = 'G'; $location{'3715'} = 'SKIEN';
$borough_number{'3716'} = '0806'; $type{'3716'} = 'G'; $location{'3716'} = 'SKIEN';
$borough_number{'3717'} = '0806'; $type{'3717'} = 'G'; $location{'3717'} = 'SKIEN';
$borough_number{'3718'} = '0806'; $type{'3718'} = 'G'; $location{'3718'} = 'SKIEN';
$borough_number{'3719'} = '0806'; $type{'3719'} = 'G'; $location{'3719'} = 'SKIEN';
$borough_number{'3720'} = '0806'; $type{'3720'} = 'G'; $location{'3720'} = 'SKIEN';
$borough_number{'3721'} = '0806'; $type{'3721'} = 'G'; $location{'3721'} = 'SKIEN';
$borough_number{'3722'} = '0806'; $type{'3722'} = 'G'; $location{'3722'} = 'SKIEN';
$borough_number{'3723'} = '0806'; $type{'3723'} = 'G'; $location{'3723'} = 'SKIEN';
$borough_number{'3724'} = '0806'; $type{'3724'} = 'G'; $location{'3724'} = 'SKIEN';
$borough_number{'3725'} = '0806'; $type{'3725'} = 'G'; $location{'3725'} = 'SKIEN';
$borough_number{'3726'} = '0806'; $type{'3726'} = 'G'; $location{'3726'} = 'SKIEN';
$borough_number{'3727'} = '0806'; $type{'3727'} = 'G'; $location{'3727'} = 'SKIEN';
$borough_number{'3728'} = '0806'; $type{'3728'} = 'G'; $location{'3728'} = 'SKIEN';
$borough_number{'3729'} = '0806'; $type{'3729'} = 'G'; $location{'3729'} = 'SKIEN';
$borough_number{'3730'} = '0806'; $type{'3730'} = 'G'; $location{'3730'} = 'SKIEN';
$borough_number{'3731'} = '0806'; $type{'3731'} = 'G'; $location{'3731'} = 'SKIEN';
$borough_number{'3732'} = '0806'; $type{'3732'} = 'G'; $location{'3732'} = 'SKIEN';
$borough_number{'3733'} = '0806'; $type{'3733'} = 'G'; $location{'3733'} = 'SKIEN';
$borough_number{'3734'} = '0806'; $type{'3734'} = 'G'; $location{'3734'} = 'SKIEN';
$borough_number{'3735'} = '0806'; $type{'3735'} = 'G'; $location{'3735'} = 'SKIEN';
$borough_number{'3736'} = '0806'; $type{'3736'} = 'G'; $location{'3736'} = 'SKIEN';
$borough_number{'3737'} = '0806'; $type{'3737'} = 'G'; $location{'3737'} = 'SKIEN';
$borough_number{'3738'} = '0806'; $type{'3738'} = 'G'; $location{'3738'} = 'SKIEN';
$borough_number{'3739'} = '0806'; $type{'3739'} = 'G'; $location{'3739'} = 'SKIEN';
$borough_number{'3740'} = '0806'; $type{'3740'} = 'G'; $location{'3740'} = 'SKIEN';
$borough_number{'3741'} = '0806'; $type{'3741'} = 'G'; $location{'3741'} = 'SKIEN';
$borough_number{'3742'} = '0806'; $type{'3742'} = 'G'; $location{'3742'} = 'SKIEN';
$borough_number{'3743'} = '0806'; $type{'3743'} = 'G'; $location{'3743'} = 'SKIEN';
$borough_number{'3744'} = '0806'; $type{'3744'} = 'G'; $location{'3744'} = 'SKIEN';
$borough_number{'3746'} = '0806'; $type{'3746'} = 'G'; $location{'3746'} = 'SKIEN';
$borough_number{'3747'} = '0806'; $type{'3747'} = 'G'; $location{'3747'} = 'SKIEN';
$borough_number{'3748'} = '0811'; $type{'3748'} = 'G'; $location{'3748'} = 'SILJAN';
$borough_number{'3749'} = '0811'; $type{'3749'} = 'P'; $location{'3749'} = 'SILJAN';
$borough_number{'3750'} = '0817'; $type{'3750'} = 'G'; $location{'3750'} = 'DRANGEDAL';
$borough_number{'3753'} = '0817'; $type{'3753'} = 'G'; $location{'3753'} = 'TRDAL';
$borough_number{'3760'} = '0817'; $type{'3760'} = 'G'; $location{'3760'} = 'NESLANDSVATN';
$borough_number{'3766'} = '0815'; $type{'3766'} = 'G'; $location{'3766'} = 'SANNIDAL';
$borough_number{'3770'} = '0815'; $type{'3770'} = 'G'; $location{'3770'} = 'KRAGER';
$borough_number{'3780'} = '0815'; $type{'3780'} = 'G'; $location{'3780'} = 'SKTY';
$borough_number{'3781'} = '0815'; $type{'3781'} = 'G'; $location{'3781'} = 'JOMFRULAND';
$borough_number{'3782'} = '0815'; $type{'3782'} = 'G'; $location{'3782'} = 'KRAGER SOMMERRUTE';
$borough_number{'3783'} = '0815'; $type{'3783'} = 'G'; $location{'3783'} = 'KRAGER SKJRGRDSRUTE';
$borough_number{'3784'} = '0815'; $type{'3784'} = 'G'; $location{'3784'} = 'LANGY GRUVER';
$borough_number{'3785'} = '0806'; $type{'3785'} = 'P'; $location{'3785'} = 'SKIEN';
$borough_number{'3786'} = '0806'; $type{'3786'} = 'P'; $location{'3786'} = 'SKIEN';
$borough_number{'3787'} = '0806'; $type{'3787'} = 'P'; $location{'3787'} = 'SKIEN';
$borough_number{'3788'} = '0815'; $type{'3788'} = 'G'; $location{'3788'} = 'STABBESTAD';
$borough_number{'3789'} = '0815'; $type{'3789'} = 'P'; $location{'3789'} = 'KRAGER';
$borough_number{'3790'} = '0815'; $type{'3790'} = 'G'; $location{'3790'} = 'HELLE';
$borough_number{'3791'} = '0815'; $type{'3791'} = 'P'; $location{'3791'} = 'KRAGER';
$borough_number{'3792'} = '0806'; $type{'3792'} = 'P'; $location{'3792'} = 'SKIEN';
$borough_number{'3793'} = '0815'; $type{'3793'} = 'P'; $location{'3793'} = 'SANNIDAL';
$borough_number{'3794'} = '0815'; $type{'3794'} = 'P'; $location{'3794'} = 'HELLE';
$borough_number{'3795'} = '0817'; $type{'3795'} = 'P'; $location{'3795'} = 'DRANGEDAL';
$borough_number{'3796'} = '0806'; $type{'3796'} = 'P'; $location{'3796'} = 'SKIEN';
$borough_number{'3797'} = '0806'; $type{'3797'} = 'P'; $location{'3797'} = 'SKIEN';
$borough_number{'3798'} = '0806'; $type{'3798'} = 'P'; $location{'3798'} = 'SKIEN';
$borough_number{'3800'} = '0821'; $type{'3800'} = 'G'; $location{'3800'} = 'B I TELEMARK';
$borough_number{'3810'} = '0822'; $type{'3810'} = 'G'; $location{'3810'} = 'GVARV';
$borough_number{'3812'} = '0822'; $type{'3812'} = 'G'; $location{'3812'} = 'AKKERHAUGEN';
$borough_number{'3820'} = '0822'; $type{'3820'} = 'G'; $location{'3820'} = 'NORDAGUTU';
$borough_number{'3825'} = '0819'; $type{'3825'} = 'G'; $location{'3825'} = 'LUNDE';
$borough_number{'3830'} = '0819'; $type{'3830'} = 'G'; $location{'3830'} = 'ULEFOSS';
$borough_number{'3831'} = '0819'; $type{'3831'} = 'P'; $location{'3831'} = 'ULEFOSS';
$borough_number{'3832'} = '0819'; $type{'3832'} = 'P'; $location{'3832'} = 'LUNDE';
$borough_number{'3833'} = '0821'; $type{'3833'} = 'P'; $location{'3833'} = 'B I TELEMARK';
$borough_number{'3834'} = '0822'; $type{'3834'} = 'P'; $location{'3834'} = 'GVARV';
$borough_number{'3835'} = '0828'; $type{'3835'} = 'P'; $location{'3835'} = 'SELJORD';
$borough_number{'3836'} = '0829'; $type{'3836'} = 'P'; $location{'3836'} = 'KVITESEID';
$borough_number{'3840'} = '0828'; $type{'3840'} = 'G'; $location{'3840'} = 'SELJORD';
$borough_number{'3841'} = '0828'; $type{'3841'} = 'G'; $location{'3841'} = 'FLATDAL';
$borough_number{'3848'} = '0829'; $type{'3848'} = 'G'; $location{'3848'} = 'MORGEDAL';
$borough_number{'3849'} = '0829'; $type{'3849'} = 'G'; $location{'3849'} = 'VRLIOSEN';
$borough_number{'3850'} = '0829'; $type{'3850'} = 'G'; $location{'3850'} = 'KVITESEID';
$borough_number{'3853'} = '0829'; $type{'3853'} = 'B'; $location{'3853'} = 'VRDAL';
$borough_number{'3854'} = '0830'; $type{'3854'} = 'G'; $location{'3854'} = 'NISSEDAL';
$borough_number{'3855'} = '0830'; $type{'3855'} = 'G'; $location{'3855'} = 'TREUNGEN';
$borough_number{'3864'} = '0834'; $type{'3864'} = 'G'; $location{'3864'} = 'RAULAND';
$borough_number{'3870'} = '0831'; $type{'3870'} = 'G'; $location{'3870'} = 'FYRESDAL';
$borough_number{'3880'} = '0833'; $type{'3880'} = 'G'; $location{'3880'} = 'DALEN';
$borough_number{'3882'} = '0833'; $type{'3882'} = 'G'; $location{'3882'} = 'MDALS VERK';
$borough_number{'3883'} = '0830'; $type{'3883'} = 'P'; $location{'3883'} = 'TREUNGEN';
$borough_number{'3884'} = '0834'; $type{'3884'} = 'P'; $location{'3884'} = 'RAULAND';
$borough_number{'3885'} = '0831'; $type{'3885'} = 'P'; $location{'3885'} = 'FYRESDAL';
$borough_number{'3886'} = '0833'; $type{'3886'} = 'P'; $location{'3886'} = 'DALEN';
$borough_number{'3887'} = '0834'; $type{'3887'} = 'P'; $location{'3887'} = 'VINJE';
$borough_number{'3888'} = '0834'; $type{'3888'} = 'P'; $location{'3888'} = 'EDLAND';
$borough_number{'3890'} = '0834'; $type{'3890'} = 'G'; $location{'3890'} = 'VINJE';
$borough_number{'3891'} = '0833'; $type{'3891'} = 'G'; $location{'3891'} = 'HYDALSMO';
$borough_number{'3893'} = '0834'; $type{'3893'} = 'G'; $location{'3893'} = 'VINJESVINGEN';
$borough_number{'3895'} = '0834'; $type{'3895'} = 'G'; $location{'3895'} = 'EDLAND';
$borough_number{'3901'} = '0805'; $type{'3901'} = 'P'; $location{'3901'} = 'PORSGRUNN';
$borough_number{'3902'} = '0805'; $type{'3902'} = 'P'; $location{'3902'} = 'PORSGRUNN';
$borough_number{'3903'} = '0805'; $type{'3903'} = 'P'; $location{'3903'} = 'PORSGRUNN';
$borough_number{'3904'} = '0805'; $type{'3904'} = 'P'; $location{'3904'} = 'PORSGRUNN';
$borough_number{'3905'} = '0805'; $type{'3905'} = 'P'; $location{'3905'} = 'PORSGRUNN';
$borough_number{'3906'} = '0805'; $type{'3906'} = 'P'; $location{'3906'} = 'PORSGRUNN';
$borough_number{'3908'} = '0805'; $type{'3908'} = 'K'; $location{'3908'} = 'PORSGRUNN';
$borough_number{'3910'} = '0805'; $type{'3910'} = 'G'; $location{'3910'} = 'PORSGRUNN';
$borough_number{'3911'} = '0805'; $type{'3911'} = 'G'; $location{'3911'} = 'PORSGRUNN';
$borough_number{'3912'} = '0805'; $type{'3912'} = 'G'; $location{'3912'} = 'PORSGRUNN';
$borough_number{'3913'} = '0805'; $type{'3913'} = 'G'; $location{'3913'} = 'PORSGRUNN';
$borough_number{'3914'} = '0805'; $type{'3914'} = 'G'; $location{'3914'} = 'PORSGRUNN';
$borough_number{'3915'} = '0805'; $type{'3915'} = 'G'; $location{'3915'} = 'PORSGRUNN';
$borough_number{'3916'} = '0805'; $type{'3916'} = 'G'; $location{'3916'} = 'PORSGRUNN';
$borough_number{'3917'} = '0805'; $type{'3917'} = 'G'; $location{'3917'} = 'PORSGRUNN';
$borough_number{'3918'} = '0805'; $type{'3918'} = 'G'; $location{'3918'} = 'PORSGRUNN';
$borough_number{'3919'} = '0805'; $type{'3919'} = 'G'; $location{'3919'} = 'PORSGRUNN';
$borough_number{'3920'} = '0805'; $type{'3920'} = 'G'; $location{'3920'} = 'PORSGRUNN';
$borough_number{'3921'} = '0805'; $type{'3921'} = 'G'; $location{'3921'} = 'PORSGRUNN';
$borough_number{'3922'} = '0805'; $type{'3922'} = 'G'; $location{'3922'} = 'PORSGRUNN';
$borough_number{'3924'} = '0805'; $type{'3924'} = 'G'; $location{'3924'} = 'PORSGRUNN';
$borough_number{'3925'} = '0805'; $type{'3925'} = 'G'; $location{'3925'} = 'PORSGRUNN';
$borough_number{'3928'} = '0805'; $type{'3928'} = 'G'; $location{'3928'} = 'PORSGRUNN';
$borough_number{'3929'} = '0805'; $type{'3929'} = 'G'; $location{'3929'} = 'PORSGRUNN';
$borough_number{'3930'} = '0805'; $type{'3930'} = 'G'; $location{'3930'} = 'PORSGRUNN';
$borough_number{'3931'} = '0805'; $type{'3931'} = 'G'; $location{'3931'} = 'PORSGRUNN';
$borough_number{'3932'} = '0805'; $type{'3932'} = 'G'; $location{'3932'} = 'PORSGRUNN';
$borough_number{'3933'} = '0805'; $type{'3933'} = 'G'; $location{'3933'} = 'PORSGRUNN';
$borough_number{'3936'} = '0805'; $type{'3936'} = 'G'; $location{'3936'} = 'PORSGRUNN';
$borough_number{'3937'} = '0805'; $type{'3937'} = 'G'; $location{'3937'} = 'PORSGRUNN';
$borough_number{'3939'} = '0805'; $type{'3939'} = 'P'; $location{'3939'} = 'PORSGRUNN';
$borough_number{'3940'} = '0805'; $type{'3940'} = 'G'; $location{'3940'} = 'PORSGRUNN';
$borough_number{'3941'} = '0805'; $type{'3941'} = 'G'; $location{'3941'} = 'PORSGRUNN';
$borough_number{'3942'} = '0805'; $type{'3942'} = 'G'; $location{'3942'} = 'PORSGRUNN';
$borough_number{'3943'} = '0805'; $type{'3943'} = 'G'; $location{'3943'} = 'PORSGRUNN';
$borough_number{'3944'} = '0805'; $type{'3944'} = 'G'; $location{'3944'} = 'PORSGRUNN';
$borough_number{'3945'} = '0805'; $type{'3945'} = 'K'; $location{'3945'} = 'PORSGRUNN';
$borough_number{'3946'} = '0805'; $type{'3946'} = 'G'; $location{'3946'} = 'PORSGRUNN';
$borough_number{'3947'} = '0805'; $type{'3947'} = 'G'; $location{'3947'} = 'LANGANGEN';
$borough_number{'3948'} = '0805'; $type{'3948'} = 'G'; $location{'3948'} = 'PORSGRUNN';
$borough_number{'3949'} = '0805'; $type{'3949'} = 'G'; $location{'3949'} = 'PORSGRUNN';
$borough_number{'3950'} = '0805'; $type{'3950'} = 'G'; $location{'3950'} = 'BREVIK';
$borough_number{'3960'} = '0814'; $type{'3960'} = 'G'; $location{'3960'} = 'STATHELLE';
$borough_number{'3965'} = '0814'; $type{'3965'} = 'G'; $location{'3965'} = 'HERRE';
$borough_number{'3966'} = '0814'; $type{'3966'} = 'K'; $location{'3966'} = 'STATHELLE';
$borough_number{'3967'} = '0814'; $type{'3967'} = 'G'; $location{'3967'} = 'BAMBLE SOMMERRUTE';
$borough_number{'3970'} = '0814'; $type{'3970'} = 'G'; $location{'3970'} = 'LANGESUND';
$borough_number{'3991'} = '0805'; $type{'3991'} = 'P'; $location{'3991'} = 'BREVIK';
$borough_number{'3993'} = '0814'; $type{'3993'} = 'P'; $location{'3993'} = 'LANGESUND';
$borough_number{'3994'} = '0814'; $type{'3994'} = 'P'; $location{'3994'} = 'LANGESUND';
$borough_number{'3995'} = '0814'; $type{'3995'} = 'P'; $location{'3995'} = 'STATHELLE';
$borough_number{'3996'} = '0805'; $type{'3996'} = 'P'; $location{'3996'} = 'PORSGRUNN';
$borough_number{'3997'} = '0805'; $type{'3997'} = 'P'; $location{'3997'} = 'PORSGRUNN';
$borough_number{'3998'} = '0805'; $type{'3998'} = 'P'; $location{'3998'} = 'PORSGRUNN';
$borough_number{'3999'} = '0814'; $type{'3999'} = 'P'; $location{'3999'} = 'HERRE';
$borough_number{'4001'} = '1103'; $type{'4001'} = 'P'; $location{'4001'} = 'STAVANGER';
$borough_number{'4002'} = '1103'; $type{'4002'} = 'P'; $location{'4002'} = 'STAVANGER';
$borough_number{'4003'} = '1103'; $type{'4003'} = 'P'; $location{'4003'} = 'STAVANGER';
$borough_number{'4004'} = '1103'; $type{'4004'} = 'P'; $location{'4004'} = 'STAVANGER';
$borough_number{'4005'} = '1103'; $type{'4005'} = 'G'; $location{'4005'} = 'STAVANGER';
$borough_number{'4006'} = '1103'; $type{'4006'} = 'G'; $location{'4006'} = 'STAVANGER';
$borough_number{'4007'} = '1103'; $type{'4007'} = 'G'; $location{'4007'} = 'STAVANGER';
$borough_number{'4008'} = '1103'; $type{'4008'} = 'G'; $location{'4008'} = 'STAVANGER';
$borough_number{'4009'} = '1103'; $type{'4009'} = 'G'; $location{'4009'} = 'STAVANGER';
$borough_number{'4010'} = '1103'; $type{'4010'} = 'G'; $location{'4010'} = 'STAVANGER';
$borough_number{'4011'} = '1103'; $type{'4011'} = 'G'; $location{'4011'} = 'STAVANGER';
$borough_number{'4012'} = '1103'; $type{'4012'} = 'G'; $location{'4012'} = 'STAVANGER';
$borough_number{'4013'} = '1103'; $type{'4013'} = 'G'; $location{'4013'} = 'STAVANGER';
$borough_number{'4014'} = '1103'; $type{'4014'} = 'G'; $location{'4014'} = 'STAVANGER';
$borough_number{'4015'} = '1103'; $type{'4015'} = 'G'; $location{'4015'} = 'STAVANGER';
$borough_number{'4016'} = '1103'; $type{'4016'} = 'G'; $location{'4016'} = 'STAVANGER';
$borough_number{'4017'} = '1103'; $type{'4017'} = 'G'; $location{'4017'} = 'STAVANGER';
$borough_number{'4018'} = '1103'; $type{'4018'} = 'G'; $location{'4018'} = 'STAVANGER';
$borough_number{'4019'} = '1103'; $type{'4019'} = 'G'; $location{'4019'} = 'STAVANGER';
$borough_number{'4020'} = '1103'; $type{'4020'} = 'G'; $location{'4020'} = 'STAVANGER';
$borough_number{'4021'} = '1103'; $type{'4021'} = 'G'; $location{'4021'} = 'STAVANGER';
$borough_number{'4022'} = '1103'; $type{'4022'} = 'G'; $location{'4022'} = 'STAVANGER';
$borough_number{'4023'} = '1103'; $type{'4023'} = 'G'; $location{'4023'} = 'STAVANGER';
$borough_number{'4024'} = '1103'; $type{'4024'} = 'G'; $location{'4024'} = 'STAVANGER';
$borough_number{'4025'} = '1103'; $type{'4025'} = 'G'; $location{'4025'} = 'STAVANGER';
$borough_number{'4026'} = '1103'; $type{'4026'} = 'G'; $location{'4026'} = 'STAVANGER';
$borough_number{'4027'} = '1103'; $type{'4027'} = 'G'; $location{'4027'} = 'STAVANGER';
$borough_number{'4028'} = '1103'; $type{'4028'} = 'G'; $location{'4028'} = 'STAVANGER';
$borough_number{'4029'} = '1103'; $type{'4029'} = 'G'; $location{'4029'} = 'STAVANGER';
$borough_number{'4032'} = '1103'; $type{'4032'} = 'G'; $location{'4032'} = 'STAVANGER';
$borough_number{'4033'} = '1103'; $type{'4033'} = 'G'; $location{'4033'} = 'STAVANGER';
$borough_number{'4034'} = '1103'; $type{'4034'} = 'G'; $location{'4034'} = 'STAVANGER';
$borough_number{'4035'} = '1103'; $type{'4035'} = 'K'; $location{'4035'} = 'STAVANGER';
$borough_number{'4036'} = '1103'; $type{'4036'} = 'K'; $location{'4036'} = 'STAVANGER';
$borough_number{'4041'} = '1103'; $type{'4041'} = 'G'; $location{'4041'} = 'HAFRSFJORD';
$borough_number{'4042'} = '1103'; $type{'4042'} = 'G'; $location{'4042'} = 'HAFRSFJORD';
$borough_number{'4043'} = '1103'; $type{'4043'} = 'G'; $location{'4043'} = 'HAFRSFJORD';
$borough_number{'4044'} = '1103'; $type{'4044'} = 'G'; $location{'4044'} = 'HAFRSFJORD';
$borough_number{'4045'} = '1103'; $type{'4045'} = 'G'; $location{'4045'} = 'HAFRSFJORD';
$borough_number{'4046'} = '1103'; $type{'4046'} = 'G'; $location{'4046'} = 'HAFRSFJORD';
$borough_number{'4047'} = '1103'; $type{'4047'} = 'G'; $location{'4047'} = 'HAFRSFJORD';
$borough_number{'4048'} = '1103'; $type{'4048'} = 'G'; $location{'4048'} = 'HAFRSFJORD';
$borough_number{'4049'} = '1103'; $type{'4049'} = 'G'; $location{'4049'} = 'HAFRSFJORD';
$borough_number{'4050'} = '1124'; $type{'4050'} = 'G'; $location{'4050'} = 'SOLA';
$borough_number{'4052'} = '1124'; $type{'4052'} = 'G'; $location{'4052'} = 'RYNEBERG';
$borough_number{'4053'} = '1124'; $type{'4053'} = 'G'; $location{'4053'} = 'RGE';
$borough_number{'4054'} = '1124'; $type{'4054'} = 'B'; $location{'4054'} = 'TJELTA';
$borough_number{'4055'} = '1124'; $type{'4055'} = 'B'; $location{'4055'} = 'STAVANGER LUFTHAVN';
$borough_number{'4056'} = '1124'; $type{'4056'} = 'G'; $location{'4056'} = 'TANANGER';
$borough_number{'4059'} = '1124'; $type{'4059'} = 'P'; $location{'4059'} = 'RYNEBERG';
$borough_number{'4064'} = '1103'; $type{'4064'} = 'P'; $location{'4064'} = 'STAVANGER';
$borough_number{'4065'} = '1103'; $type{'4065'} = 'P'; $location{'4065'} = 'STAVANGER';
$borough_number{'4066'} = '1103'; $type{'4066'} = 'P'; $location{'4066'} = 'STAVANGER';
$borough_number{'4067'} = '1103'; $type{'4067'} = 'P'; $location{'4067'} = 'STAVANGER';
$borough_number{'4068'} = '1103'; $type{'4068'} = 'P'; $location{'4068'} = 'STAVANGER';
$borough_number{'4069'} = '1103'; $type{'4069'} = 'P'; $location{'4069'} = 'STAVANGER';
$borough_number{'4070'} = '1127'; $type{'4070'} = 'G'; $location{'4070'} = 'RANDABERG';
$borough_number{'4076'} = '1103'; $type{'4076'} = 'B'; $location{'4076'} = 'VASSY';
$borough_number{'4078'} = '1103'; $type{'4078'} = 'P'; $location{'4078'} = 'STAVANGER';
$borough_number{'4079'} = '1103'; $type{'4079'} = 'P'; $location{'4079'} = 'STAVANGER';
$borough_number{'4081'} = '1103'; $type{'4081'} = 'P'; $location{'4081'} = 'STAVANGER';
$borough_number{'4082'} = '1103'; $type{'4082'} = 'P'; $location{'4082'} = 'STAVANGER';
$borough_number{'4084'} = '1103'; $type{'4084'} = 'P'; $location{'4084'} = 'STAVANGER';
$borough_number{'4085'} = '1103'; $type{'4085'} = 'G'; $location{'4085'} = 'HUNDVG';
$borough_number{'4086'} = '1103'; $type{'4086'} = 'P'; $location{'4086'} = 'HUNDVG';
$borough_number{'4087'} = '1103'; $type{'4087'} = 'P'; $location{'4087'} = 'STAVANGER';
$borough_number{'4088'} = '1103'; $type{'4088'} = 'P'; $location{'4088'} = 'STAVANGER';
$borough_number{'4089'} = '1103'; $type{'4089'} = 'P'; $location{'4089'} = 'HAFRSFJORD';
$borough_number{'4090'} = '1103'; $type{'4090'} = 'P'; $location{'4090'} = 'HAFRSFJORD';
$borough_number{'4092'} = '1103'; $type{'4092'} = 'P'; $location{'4092'} = 'STAVANGER';
$borough_number{'4093'} = '1103'; $type{'4093'} = 'P'; $location{'4093'} = 'STAVANGER';
$borough_number{'4094'} = '1103'; $type{'4094'} = 'P'; $location{'4094'} = 'STAVANGER';
$borough_number{'4095'} = '1103'; $type{'4095'} = 'P'; $location{'4095'} = 'STAVANGER';
$borough_number{'4096'} = '1127'; $type{'4096'} = 'P'; $location{'4096'} = 'RANDABERG';
$borough_number{'4097'} = '1124'; $type{'4097'} = 'P'; $location{'4097'} = 'SOLA';
$borough_number{'4098'} = '1124'; $type{'4098'} = 'P'; $location{'4098'} = 'TANANGER';
$borough_number{'4100'} = '1130'; $type{'4100'} = 'G'; $location{'4100'} = 'JRPELAND';
$borough_number{'4102'} = '1130'; $type{'4102'} = 'G'; $location{'4102'} = 'IDSE';
$borough_number{'4110'} = '1129'; $type{'4110'} = 'G'; $location{'4110'} = 'FORSAND';
$borough_number{'4119'} = '1129'; $type{'4119'} = 'P'; $location{'4119'} = 'FORSAND';
$borough_number{'4120'} = '1130'; $type{'4120'} = 'G'; $location{'4120'} = 'TAU';
$borough_number{'4122'} = '1130'; $type{'4122'} = 'G'; $location{'4122'} = 'FISK';
$borough_number{'4123'} = '1130'; $type{'4123'} = 'G'; $location{'4123'} = 'SR-HIDLE';
$borough_number{'4124'} = '1130'; $type{'4124'} = 'P'; $location{'4124'} = 'TAU';
$borough_number{'4126'} = '1130'; $type{'4126'} = 'P'; $location{'4126'} = 'JRPELAND';
$borough_number{'4127'} = '1129'; $type{'4127'} = 'B'; $location{'4127'} = 'LYSEBOTN';
$borough_number{'4128'} = '1129'; $type{'4128'} = 'G'; $location{'4128'} = 'FLYRLI';
$borough_number{'4129'} = '1129'; $type{'4129'} = 'G'; $location{'4129'} = 'SONGESAND';
$borough_number{'4130'} = '1133'; $type{'4130'} = 'G'; $location{'4130'} = 'HJELMELAND';
$borough_number{'4134'} = '1133'; $type{'4134'} = 'G'; $location{'4134'} = 'JSENFJORDEN';
$borough_number{'4137'} = '1133'; $type{'4137'} = 'G'; $location{'4137'} = 'RDAL I RYFYLKE';
$borough_number{'4139'} = '1133'; $type{'4139'} = 'G'; $location{'4139'} = 'FISTER';
$borough_number{'4146'} = '1133'; $type{'4146'} = 'G'; $location{'4146'} = 'SKIFTUN';
$borough_number{'4148'} = '1133'; $type{'4148'} = 'P'; $location{'4148'} = 'HJELMELAND';
$borough_number{'4150'} = '1142'; $type{'4150'} = 'G'; $location{'4150'} = 'RENNESY';
$borough_number{'4152'} = '1142'; $type{'4152'} = 'G'; $location{'4152'} = 'VESTRE MY';
$borough_number{'4153'} = '1142'; $type{'4153'} = 'G'; $location{'4153'} = 'BRIMSE';
$borough_number{'4154'} = '1103'; $type{'4154'} = 'G'; $location{'4154'} = 'AUSTRE MY';
$borough_number{'4156'} = '1142'; $type{'4156'} = 'G'; $location{'4156'} = 'MOSTERY';
$borough_number{'4158'} = '1142'; $type{'4158'} = 'G'; $location{'4158'} = 'BRU';
$borough_number{'4159'} = '1142'; $type{'4159'} = 'P'; $location{'4159'} = 'RENNESY';
$borough_number{'4160'} = '1141'; $type{'4160'} = 'G'; $location{'4160'} = 'FINNY';
$borough_number{'4161'} = '1141'; $type{'4161'} = 'P'; $location{'4161'} = 'FINNY';
$borough_number{'4163'} = '1141'; $type{'4163'} = 'G'; $location{'4163'} = 'TALGJE';
$borough_number{'4164'} = '1141'; $type{'4164'} = 'G'; $location{'4164'} = 'FOGN';
$borough_number{'4167'} = '1133'; $type{'4167'} = 'G'; $location{'4167'} = 'HELGY I RYFYLKE';
$borough_number{'4168'} = '1141'; $type{'4168'} = 'G'; $location{'4168'} = 'BYRE';
$borough_number{'4169'} = '1141'; $type{'4169'} = 'G'; $location{'4169'} = 'SRBOKN';
$borough_number{'4170'} = '1141'; $type{'4170'} = 'G'; $location{'4170'} = 'SJERNARY';
$borough_number{'4173'} = '1141'; $type{'4173'} = 'G'; $location{'4173'} = 'NORD-HIDLE';
$borough_number{'4174'} = '1141'; $type{'4174'} = 'B'; $location{'4174'} = 'HELGYSUND';
$borough_number{'4180'} = '1144'; $type{'4180'} = 'B'; $location{'4180'} = 'KVITSY';
$borough_number{'4182'} = '1141'; $type{'4182'} = 'B'; $location{'4182'} = 'SKARTVEIT';
$borough_number{'4187'} = '1141'; $type{'4187'} = 'G'; $location{'4187'} = 'OMBO';
$borough_number{'4198'} = '1134'; $type{'4198'} = 'G'; $location{'4198'} = 'FOLDY';
$borough_number{'4200'} = '1135'; $type{'4200'} = 'G'; $location{'4200'} = 'SAUDA';
$borough_number{'4201'} = '1135'; $type{'4201'} = 'P'; $location{'4201'} = 'SAUDA';
$borough_number{'4208'} = '1135'; $type{'4208'} = 'G'; $location{'4208'} = 'SAUDASJEN';
$borough_number{'4209'} = '1134'; $type{'4209'} = 'G'; $location{'4209'} = 'VANVIK';
$borough_number{'4230'} = '1134'; $type{'4230'} = 'G'; $location{'4230'} = 'SAND';
$borough_number{'4233'} = '1134'; $type{'4233'} = 'B'; $location{'4233'} = 'ERFJORD';
$borough_number{'4234'} = '1134'; $type{'4234'} = 'G'; $location{'4234'} = 'JELSA';
$borough_number{'4235'} = '1134'; $type{'4235'} = 'G'; $location{'4235'} = 'HEBNES';
$borough_number{'4237'} = '1134'; $type{'4237'} = 'G'; $location{'4237'} = 'SULDALSOSEN';
$borough_number{'4239'} = '1134'; $type{'4239'} = 'P'; $location{'4239'} = 'SAND';
$borough_number{'4240'} = '1134'; $type{'4240'} = 'P'; $location{'4240'} = 'SULDALSOSEN';
$borough_number{'4244'} = '1134'; $type{'4244'} = 'B'; $location{'4244'} = 'NESFLATEN';
$borough_number{'4250'} = '1149'; $type{'4250'} = 'G'; $location{'4250'} = 'KOPERVIK';
$borough_number{'4260'} = '1149'; $type{'4260'} = 'G'; $location{'4260'} = 'TORVASTAD';
$borough_number{'4262'} = '1149'; $type{'4262'} = 'G'; $location{'4262'} = 'AVALDSNES';
$borough_number{'4264'} = '1149'; $type{'4264'} = 'B'; $location{'4264'} = 'KVALAVG';
$borough_number{'4265'} = '1149'; $type{'4265'} = 'G'; $location{'4265'} = 'HVIK';
$borough_number{'4270'} = '1149'; $type{'4270'} = 'G'; $location{'4270'} = 'KREHAMN';
$borough_number{'4272'} = '1149'; $type{'4272'} = 'B'; $location{'4272'} = 'SANDVE';
$borough_number{'4274'} = '1149'; $type{'4274'} = 'B'; $location{'4274'} = 'STOL';
$borough_number{'4275'} = '1149'; $type{'4275'} = 'B'; $location{'4275'} = 'SVELANDSVIK';
$borough_number{'4276'} = '1149'; $type{'4276'} = 'G'; $location{'4276'} = 'VEDAVGEN';
$borough_number{'4280'} = '1149'; $type{'4280'} = 'G'; $location{'4280'} = 'SKUDENESHAVN';
$borough_number{'4291'} = '1149'; $type{'4291'} = 'P'; $location{'4291'} = 'KOPERVIK';
$borough_number{'4294'} = '1149'; $type{'4294'} = 'P'; $location{'4294'} = 'KOPERVIK';
$borough_number{'4295'} = '1149'; $type{'4295'} = 'P'; $location{'4295'} = 'VEDAVGEN';
$borough_number{'4296'} = '1149'; $type{'4296'} = 'P'; $location{'4296'} = 'KREHAMN';
$borough_number{'4297'} = '1149'; $type{'4297'} = 'P'; $location{'4297'} = 'SKUDENESHAVN';
$borough_number{'4298'} = '1149'; $type{'4298'} = 'P'; $location{'4298'} = 'TORVASTAD';
$borough_number{'4299'} = '1149'; $type{'4299'} = 'P'; $location{'4299'} = 'AVALDSNES';
$borough_number{'4301'} = '1102'; $type{'4301'} = 'P'; $location{'4301'} = 'SANDNES';
$borough_number{'4302'} = '1102'; $type{'4302'} = 'P'; $location{'4302'} = 'SANDNES';
$borough_number{'4303'} = '1102'; $type{'4303'} = 'P'; $location{'4303'} = 'SANDNES';
$borough_number{'4304'} = '1102'; $type{'4304'} = 'P'; $location{'4304'} = 'SANDNES';
$borough_number{'4305'} = '1102'; $type{'4305'} = 'P'; $location{'4305'} = 'SANDNES';
$borough_number{'4306'} = '1102'; $type{'4306'} = 'G'; $location{'4306'} = 'SANDNES';
$borough_number{'4307'} = '1102'; $type{'4307'} = 'G'; $location{'4307'} = 'SANDNES';
$borough_number{'4308'} = '1102'; $type{'4308'} = 'B'; $location{'4308'} = 'SANDNES';
$borough_number{'4309'} = '1102'; $type{'4309'} = 'G'; $location{'4309'} = 'SANDNES';
$borough_number{'4310'} = '1102'; $type{'4310'} = 'G'; $location{'4310'} = 'HOMMERSK';
$borough_number{'4311'} = '1102'; $type{'4311'} = 'G'; $location{'4311'} = 'HOMMERSK';
$borough_number{'4312'} = '1102'; $type{'4312'} = 'G'; $location{'4312'} = 'SANDNES';
$borough_number{'4313'} = '1102'; $type{'4313'} = 'G'; $location{'4313'} = 'SANDNES';
$borough_number{'4314'} = '1102'; $type{'4314'} = 'G'; $location{'4314'} = 'SANDNES';
$borough_number{'4315'} = '1102'; $type{'4315'} = 'G'; $location{'4315'} = 'SANDNES';
$borough_number{'4316'} = '1102'; $type{'4316'} = 'G'; $location{'4316'} = 'SANDNES';
$borough_number{'4317'} = '1102'; $type{'4317'} = 'G'; $location{'4317'} = 'SANDNES';
$borough_number{'4318'} = '1102'; $type{'4318'} = 'G'; $location{'4318'} = 'SANDNES';
$borough_number{'4319'} = '1102'; $type{'4319'} = 'G'; $location{'4319'} = 'SANDNES';
$borough_number{'4321'} = '1102'; $type{'4321'} = 'G'; $location{'4321'} = 'SANDNES';
$borough_number{'4322'} = '1102'; $type{'4322'} = 'G'; $location{'4322'} = 'SANDNES';
$borough_number{'4323'} = '1102'; $type{'4323'} = 'G'; $location{'4323'} = 'SANDNES';
$borough_number{'4324'} = '1102'; $type{'4324'} = 'G'; $location{'4324'} = 'SANDNES';
$borough_number{'4325'} = '1102'; $type{'4325'} = 'G'; $location{'4325'} = 'SANDNES';
$borough_number{'4326'} = '1102'; $type{'4326'} = 'G'; $location{'4326'} = 'SANDNES';
$borough_number{'4327'} = '1102'; $type{'4327'} = 'G'; $location{'4327'} = 'SANDNES';
$borough_number{'4328'} = '1102'; $type{'4328'} = 'G'; $location{'4328'} = 'SANDNES';
$borough_number{'4329'} = '1102'; $type{'4329'} = 'G'; $location{'4329'} = 'SANDNES';
$borough_number{'4330'} = '1122'; $type{'4330'} = 'G'; $location{'4330'} = 'LGRD';
$borough_number{'4332'} = '1102'; $type{'4332'} = 'G'; $location{'4332'} = 'FIGGJO';
$borough_number{'4333'} = '1122'; $type{'4333'} = 'B'; $location{'4333'} = 'OLTEDAL';
$borough_number{'4335'} = '1122'; $type{'4335'} = 'G'; $location{'4335'} = 'DIRDAL';
$borough_number{'4339'} = '1122'; $type{'4339'} = 'P'; $location{'4339'} = 'LGRD';
$borough_number{'4340'} = '1121'; $type{'4340'} = 'G'; $location{'4340'} = 'BRYNE';
$borough_number{'4342'} = '1121'; $type{'4342'} = 'G'; $location{'4342'} = 'UNDHEIM';
$borough_number{'4343'} = '1120'; $type{'4343'} = 'G'; $location{'4343'} = 'ORRE';
$borough_number{'4348'} = '1121'; $type{'4348'} = 'P'; $location{'4348'} = 'BRYNE';
$borough_number{'4349'} = '1121'; $type{'4349'} = 'P'; $location{'4349'} = 'BRYNE';
$borough_number{'4352'} = '1120'; $type{'4352'} = 'G'; $location{'4352'} = 'KLEPPE';
$borough_number{'4353'} = '1120'; $type{'4353'} = 'G'; $location{'4353'} = 'KLEPP STASJON';
$borough_number{'4354'} = '1120'; $type{'4354'} = 'G'; $location{'4354'} = 'VOLL';
$borough_number{'4355'} = '1121'; $type{'4355'} = 'G'; $location{'4355'} = 'KVERNALAND';
$borough_number{'4356'} = '1121'; $type{'4356'} = 'P'; $location{'4356'} = 'KVERNALAND';
$borough_number{'4357'} = '1120'; $type{'4357'} = 'P'; $location{'4357'} = 'KLEPP STASJON';
$borough_number{'4358'} = '1120'; $type{'4358'} = 'P'; $location{'4358'} = 'KLEPPE';
$borough_number{'4360'} = '1119'; $type{'4360'} = 'G'; $location{'4360'} = 'VARHAUG';
$borough_number{'4362'} = '1119'; $type{'4362'} = 'G'; $location{'4362'} = 'VIGRESTAD';
$borough_number{'4363'} = '1119'; $type{'4363'} = 'G'; $location{'4363'} = 'BRUSAND';
$borough_number{'4364'} = '1119'; $type{'4364'} = 'B'; $location{'4364'} = 'SIREVG';
$borough_number{'4365'} = '1119'; $type{'4365'} = 'G'; $location{'4365'} = 'NRB';
$borough_number{'4367'} = '1119'; $type{'4367'} = 'P'; $location{'4367'} = 'NRB';
$borough_number{'4368'} = '1119'; $type{'4368'} = 'P'; $location{'4368'} = 'VARHAUG';
$borough_number{'4369'} = '1119'; $type{'4369'} = 'P'; $location{'4369'} = 'VIGRESTAD';
$borough_number{'4370'} = '1101'; $type{'4370'} = 'B'; $location{'4370'} = 'EGERSUND';
$borough_number{'4375'} = '1101'; $type{'4375'} = 'G'; $location{'4375'} = 'HELLVIK';
$borough_number{'4376'} = '1101'; $type{'4376'} = 'B'; $location{'4376'} = 'HELLELAND';
$borough_number{'4379'} = '1101'; $type{'4379'} = 'P'; $location{'4379'} = 'EGERSUND';
$borough_number{'4380'} = '1111'; $type{'4380'} = 'G'; $location{'4380'} = 'HAUGE I DALANE';
$borough_number{'4381'} = '1111'; $type{'4381'} = 'P'; $location{'4381'} = 'HAUGE I DALANE';
$borough_number{'4387'} = '1114'; $type{'4387'} = 'G'; $location{'4387'} = 'BJERKREIM';
$borough_number{'4389'} = '1114'; $type{'4389'} = 'B'; $location{'4389'} = 'VIKES';
$borough_number{'4391'} = '1102'; $type{'4391'} = 'P'; $location{'4391'} = 'SANDNES';
$borough_number{'4392'} = '1102'; $type{'4392'} = 'P'; $location{'4392'} = 'SANDNES';
$borough_number{'4393'} = '1102'; $type{'4393'} = 'P'; $location{'4393'} = 'SANDNES';
$borough_number{'4395'} = '1102'; $type{'4395'} = 'P'; $location{'4395'} = 'HOMMERSK';
$borough_number{'4396'} = '1102'; $type{'4396'} = 'P'; $location{'4396'} = 'SANDNES';
$borough_number{'4397'} = '1102'; $type{'4397'} = 'P'; $location{'4397'} = 'SANDNES';
$borough_number{'4398'} = '1102'; $type{'4398'} = 'P'; $location{'4398'} = 'SANDNES';
$borough_number{'4400'} = '1004'; $type{'4400'} = 'G'; $location{'4400'} = 'FLEKKEFJORD';
$borough_number{'4401'} = '1004'; $type{'4401'} = 'P'; $location{'4401'} = 'FLEKKEFJORD';
$borough_number{'4402'} = '1004'; $type{'4402'} = 'P'; $location{'4402'} = 'FLEKKEFJORD';
$borough_number{'4403'} = '1004'; $type{'4403'} = 'P'; $location{'4403'} = 'FLEKKEFJORD';
$borough_number{'4420'} = '1004'; $type{'4420'} = 'G'; $location{'4420'} = 'NA-SIRA';
$borough_number{'4432'} = '1004'; $type{'4432'} = 'G'; $location{'4432'} = 'HIDRASUND';
$borough_number{'4434'} = '1004'; $type{'4434'} = 'G'; $location{'4434'} = 'ANDABELY';
$borough_number{'4436'} = '1004'; $type{'4436'} = 'G'; $location{'4436'} = 'GYLAND';
$borough_number{'4438'} = '1004'; $type{'4438'} = 'B'; $location{'4438'} = 'SIRA';
$borough_number{'4440'} = '1046'; $type{'4440'} = 'G'; $location{'4440'} = 'TONSTAD';
$borough_number{'4441'} = '1046'; $type{'4441'} = 'P'; $location{'4441'} = 'TONSTAD';
$borough_number{'4443'} = '1046'; $type{'4443'} = 'G'; $location{'4443'} = 'TJRHOM';
$borough_number{'4460'} = '1112'; $type{'4460'} = 'G'; $location{'4460'} = 'MOI';
$borough_number{'4462'} = '1112'; $type{'4462'} = 'G'; $location{'4462'} = 'HOVSHERAD';
$borough_number{'4463'} = '1112'; $type{'4463'} = 'G'; $location{'4463'} = 'UALAND';
$borough_number{'4465'} = '1112'; $type{'4465'} = 'P'; $location{'4465'} = 'MOI';
$borough_number{'4473'} = '1037'; $type{'4473'} = 'G'; $location{'4473'} = 'KVINLOG';
$borough_number{'4480'} = '1037'; $type{'4480'} = 'G'; $location{'4480'} = 'KVINESDAL';
$borough_number{'4484'} = '1037'; $type{'4484'} = 'G'; $location{'4484'} = 'YESTRANDA';
$borough_number{'4485'} = '1037'; $type{'4485'} = 'B'; $location{'4485'} = 'FEDA';
$borough_number{'4490'} = '1037'; $type{'4490'} = 'P'; $location{'4490'} = 'KVINESDAL';
$borough_number{'4491'} = '1037'; $type{'4491'} = 'P'; $location{'4491'} = 'KVINESDAL';
$borough_number{'4492'} = '1037'; $type{'4492'} = 'P'; $location{'4492'} = 'KVINESDAL';
$borough_number{'4501'} = '1002'; $type{'4501'} = 'P'; $location{'4501'} = 'MANDAL';
$borough_number{'4502'} = '1002'; $type{'4502'} = 'P'; $location{'4502'} = 'MANDAL';
$borough_number{'4503'} = '1002'; $type{'4503'} = 'P'; $location{'4503'} = 'MANDAL';
$borough_number{'4504'} = '1002'; $type{'4504'} = 'P'; $location{'4504'} = 'MANDAL';
$borough_number{'4505'} = '1002'; $type{'4505'} = 'P'; $location{'4505'} = 'MANDAL';
$borough_number{'4506'} = '1002'; $type{'4506'} = 'P'; $location{'4506'} = 'MANDAL';
$borough_number{'4509'} = '1002'; $type{'4509'} = 'S'; $location{'4509'} = 'MANDAL';
$borough_number{'4512'} = '1029'; $type{'4512'} = 'G'; $location{'4512'} = 'LINDESNES';
$borough_number{'4513'} = '1002'; $type{'4513'} = 'G'; $location{'4513'} = 'MANDAL';
$borough_number{'4514'} = '1002'; $type{'4514'} = 'G'; $location{'4514'} = 'MANDAL';
$borough_number{'4515'} = '1002'; $type{'4515'} = 'G'; $location{'4515'} = 'MANDAL';
$borough_number{'4516'} = '1002'; $type{'4516'} = 'G'; $location{'4516'} = 'MANDAL';
$borough_number{'4517'} = '1002'; $type{'4517'} = 'G'; $location{'4517'} = 'MANDAL';
$borough_number{'4519'} = '1002'; $type{'4519'} = 'G'; $location{'4519'} = 'HOLUM';
$borough_number{'4520'} = '1029'; $type{'4520'} = 'G'; $location{'4520'} = 'SR-AUDNEDAL';
$borough_number{'4521'} = '1029'; $type{'4521'} = 'B'; $location{'4521'} = 'SPANGEREID';
$borough_number{'4523'} = '1029'; $type{'4523'} = 'P'; $location{'4523'} = 'SR-AUDNEDAL';
$borough_number{'4524'} = '1029'; $type{'4524'} = 'P'; $location{'4524'} = 'SR-AUDNEDAL';
$borough_number{'4525'} = '1027'; $type{'4525'} = 'B'; $location{'4525'} = 'KONSMO';
$borough_number{'4528'} = '1027'; $type{'4528'} = 'G'; $location{'4528'} = 'KOLLUNGTVEIT';
$borough_number{'4529'} = '1027'; $type{'4529'} = 'G'; $location{'4529'} = 'BYREMO';
$borough_number{'4532'} = '1021'; $type{'4532'} = 'G'; $location{'4532'} = 'YSLEB';
$borough_number{'4534'} = '1021'; $type{'4534'} = 'B'; $location{'4534'} = 'MARNARDAL';
$borough_number{'4536'} = '1021'; $type{'4536'} = 'G'; $location{'4536'} = 'BJELLAND';
$borough_number{'4540'} = '1026'; $type{'4540'} = 'B'; $location{'4540'} = 'SERAL';
$borough_number{'4544'} = '1026'; $type{'4544'} = 'G'; $location{'4544'} = 'FOSSDAL';
$borough_number{'4550'} = '1003'; $type{'4550'} = 'G'; $location{'4550'} = 'FARSUND';
$borough_number{'4551'} = '1003'; $type{'4551'} = 'P'; $location{'4551'} = 'FARSUND';
$borough_number{'4552'} = '1003'; $type{'4552'} = 'P'; $location{'4552'} = 'FARSUND';
$borough_number{'4553'} = '1003'; $type{'4553'} = 'P'; $location{'4553'} = 'FARSUND';
$borough_number{'4554'} = '1003'; $type{'4554'} = 'P'; $location{'4554'} = 'FARSUND';
$borough_number{'4557'} = '1003'; $type{'4557'} = 'P'; $location{'4557'} = 'VANSE';
$borough_number{'4558'} = '1003'; $type{'4558'} = 'P'; $location{'4558'} = 'VANSE';
$borough_number{'4560'} = '1003'; $type{'4560'} = 'G'; $location{'4560'} = 'VANSE';
$borough_number{'4563'} = '1003'; $type{'4563'} = 'G'; $location{'4563'} = 'BORHAUG';
$borough_number{'4575'} = '1032'; $type{'4575'} = 'P'; $location{'4575'} = 'LYNGDAL';
$borough_number{'4576'} = '1032'; $type{'4576'} = 'P'; $location{'4576'} = 'LYNGDAL';
$borough_number{'4577'} = '1032'; $type{'4577'} = 'P'; $location{'4577'} = 'LYNGDAL';
$borough_number{'4579'} = '1032'; $type{'4579'} = 'P'; $location{'4579'} = 'LYNGDAL';
$borough_number{'4580'} = '1032'; $type{'4580'} = 'G'; $location{'4580'} = 'LYNGDAL';
$borough_number{'4586'} = '1032'; $type{'4586'} = 'G'; $location{'4586'} = 'KORSHAMN';
$borough_number{'4588'} = '1032'; $type{'4588'} = 'G'; $location{'4588'} = 'KVS';
$borough_number{'4590'} = '1034'; $type{'4590'} = 'G'; $location{'4590'} = 'SNARTEMO';
$borough_number{'4595'} = '1034'; $type{'4595'} = 'G'; $location{'4595'} = 'TINGVATN';
$borough_number{'4596'} = '1034'; $type{'4596'} = 'B'; $location{'4596'} = 'EIKEN';
$borough_number{'4604'} = '1001'; $type{'4604'} = 'S'; $location{'4604'} = 'KRISTIANSAND S';
$borough_number{'4605'} = '1001'; $type{'4605'} = 'S'; $location{'4605'} = 'KRISTIANSAND S';
$borough_number{'4606'} = '1001'; $type{'4606'} = 'S'; $location{'4606'} = 'KRISTIANSAND S';
$borough_number{'4609'} = '1001'; $type{'4609'} = 'G'; $location{'4609'} = 'KARDEMOMME BY';
$borough_number{'4610'} = '1001'; $type{'4610'} = 'G'; $location{'4610'} = 'KRISTIANSAND S';
$borough_number{'4611'} = '1001'; $type{'4611'} = 'G'; $location{'4611'} = 'KRISTIANSAND S';
$borough_number{'4612'} = '1001'; $type{'4612'} = 'G'; $location{'4612'} = 'KRISTIANSAND S';
$borough_number{'4613'} = '1001'; $type{'4613'} = 'G'; $location{'4613'} = 'KRISTIANSAND S';
$borough_number{'4614'} = '1001'; $type{'4614'} = 'G'; $location{'4614'} = 'KRISTIANSAND S';
$borough_number{'4615'} = '1001'; $type{'4615'} = 'G'; $location{'4615'} = 'KRISTIANSAND S';
$borough_number{'4616'} = '1001'; $type{'4616'} = 'G'; $location{'4616'} = 'KRISTIANSAND S';
$borough_number{'4617'} = '1001'; $type{'4617'} = 'G'; $location{'4617'} = 'KRISTIANSAND S';
$borough_number{'4618'} = '1001'; $type{'4618'} = 'B'; $location{'4618'} = 'KRISTIANSAND S';
$borough_number{'4619'} = '1001'; $type{'4619'} = 'G'; $location{'4619'} = 'MOSBY';
$borough_number{'4620'} = '1001'; $type{'4620'} = 'G'; $location{'4620'} = 'KRISTIANSAND S';
$borough_number{'4621'} = '1001'; $type{'4621'} = 'G'; $location{'4621'} = 'KRISTIANSAND S';
$borough_number{'4622'} = '1001'; $type{'4622'} = 'G'; $location{'4622'} = 'KRISTIANSAND S';
$borough_number{'4623'} = '1001'; $type{'4623'} = 'G'; $location{'4623'} = 'KRISTIANSAND S';
$borough_number{'4624'} = '1001'; $type{'4624'} = 'G'; $location{'4624'} = 'KRISTIANSAND S';
$borough_number{'4625'} = '1001'; $type{'4625'} = 'G'; $location{'4625'} = 'FLEKKERY';
$borough_number{'4626'} = '1001'; $type{'4626'} = 'B'; $location{'4626'} = 'KRISTIANSAND S';
$borough_number{'4628'} = '1001'; $type{'4628'} = 'G'; $location{'4628'} = 'KRISTIANSAND S';
$borough_number{'4629'} = '1001'; $type{'4629'} = 'B'; $location{'4629'} = 'KRISTIANSAND S';
$borough_number{'4630'} = '1001'; $type{'4630'} = 'G'; $location{'4630'} = 'KRISTIANSAND S';
$borough_number{'4631'} = '1001'; $type{'4631'} = 'G'; $location{'4631'} = 'KRISTIANSAND S';
$borough_number{'4632'} = '1001'; $type{'4632'} = 'G'; $location{'4632'} = 'KRISTIANSAND S';
$borough_number{'4633'} = '1001'; $type{'4633'} = 'G'; $location{'4633'} = 'KRISTIANSAND S';
$borough_number{'4634'} = '1001'; $type{'4634'} = 'B'; $location{'4634'} = 'KRISTIANSAND S';
$borough_number{'4635'} = '1001'; $type{'4635'} = 'G'; $location{'4635'} = 'KRISTIANSAND S';
$borough_number{'4636'} = '1001'; $type{'4636'} = 'G'; $location{'4636'} = 'KRISTIANSAND S';
$borough_number{'4637'} = '1001'; $type{'4637'} = 'G'; $location{'4637'} = 'KRISTIANSAND S';
$borough_number{'4638'} = '1001'; $type{'4638'} = 'G'; $location{'4638'} = 'KRISTIANSAND S';
$borough_number{'4639'} = '1001'; $type{'4639'} = 'B'; $location{'4639'} = 'KRISTIANSAND S';
$borough_number{'4640'} = '1018'; $type{'4640'} = 'B'; $location{'4640'} = 'SGNE';
$borough_number{'4645'} = '1017'; $type{'4645'} = 'G'; $location{'4645'} = 'NODELAND';
$borough_number{'4646'} = '1017'; $type{'4646'} = 'B'; $location{'4646'} = 'FINSLAND';
$borough_number{'4647'} = '1017'; $type{'4647'} = 'B'; $location{'4647'} = 'BRENNSEN';
$borough_number{'4651'} = '1001'; $type{'4651'} = 'P'; $location{'4651'} = 'HAMRESANDEN';
$borough_number{'4656'} = '1001'; $type{'4656'} = 'G'; $location{'4656'} = 'HAMRESANDEN';
$borough_number{'4657'} = '1001'; $type{'4657'} = 'G'; $location{'4657'} = 'KJEVIK';
$borough_number{'4658'} = '1001'; $type{'4658'} = 'G'; $location{'4658'} = 'TVEIT';
$borough_number{'4659'} = '1001'; $type{'4659'} = 'P'; $location{'4659'} = 'KRISTIANSAND S';
$borough_number{'4661'} = '1001'; $type{'4661'} = 'P'; $location{'4661'} = 'KRISTIANSAND S';
$borough_number{'4662'} = '1001'; $type{'4662'} = 'P'; $location{'4662'} = 'KRISTIANSAND S';
$borough_number{'4663'} = '1001'; $type{'4663'} = 'P'; $location{'4663'} = 'KRISTIANSAND S';
$borough_number{'4664'} = '1001'; $type{'4664'} = 'P'; $location{'4664'} = 'KRISTIANSAND S';
$borough_number{'4665'} = '1001'; $type{'4665'} = 'P'; $location{'4665'} = 'KRISTIANSAND S';
$borough_number{'4666'} = '1001'; $type{'4666'} = 'P'; $location{'4666'} = 'KRISTIANSAND S';
$borough_number{'4671'} = '1001'; $type{'4671'} = 'P'; $location{'4671'} = 'MOSBY';
$borough_number{'4672'} = '1001'; $type{'4672'} = 'P'; $location{'4672'} = 'KRISTIANSAND S';
$borough_number{'4673'} = '1001'; $type{'4673'} = 'P'; $location{'4673'} = 'KRISTIANSAND S';
$borough_number{'4674'} = '1001'; $type{'4674'} = 'P'; $location{'4674'} = 'KRISTIANSAND S';
$borough_number{'4675'} = '1001'; $type{'4675'} = 'P'; $location{'4675'} = 'KRISTIANSAND S';
$borough_number{'4676'} = '1001'; $type{'4676'} = 'P'; $location{'4676'} = 'KRISTIANSAND S';
$borough_number{'4677'} = '1001'; $type{'4677'} = 'P'; $location{'4677'} = 'KRISTIANSAND S';
$borough_number{'4678'} = '1001'; $type{'4678'} = 'P'; $location{'4678'} = 'KRISTIANSAND S';
$borough_number{'4679'} = '1001'; $type{'4679'} = 'P'; $location{'4679'} = 'FLEKKERY';
$borough_number{'4682'} = '1018'; $type{'4682'} = 'P'; $location{'4682'} = 'SGNE';
$borough_number{'4683'} = '1018'; $type{'4683'} = 'P'; $location{'4683'} = 'SGNE';
$borough_number{'4685'} = '1017'; $type{'4685'} = 'P'; $location{'4685'} = 'NODELAND';
$borough_number{'4686'} = '1001'; $type{'4686'} = 'P'; $location{'4686'} = 'KRISTIANSAND S';
$borough_number{'4687'} = '1001'; $type{'4687'} = 'P'; $location{'4687'} = 'KRISTIANSAND S';
$borough_number{'4688'} = '1001'; $type{'4688'} = 'P'; $location{'4688'} = 'KRISTIANSAND S';
$borough_number{'4689'} = '1001'; $type{'4689'} = 'P'; $location{'4689'} = 'KRISTIANSAND S';
$borough_number{'4691'} = '1001'; $type{'4691'} = 'P'; $location{'4691'} = 'KRISTIANSAND S';
$borough_number{'4693'} = '1001'; $type{'4693'} = 'P'; $location{'4693'} = 'KRISTIANSAND S';
$borough_number{'4696'} = '1001'; $type{'4696'} = 'P'; $location{'4696'} = 'KRISTIANSAND S';
$borough_number{'4697'} = '1001'; $type{'4697'} = 'P'; $location{'4697'} = 'KRISTIANSAND S';
$borough_number{'4699'} = '1001'; $type{'4699'} = 'P'; $location{'4699'} = 'TVEIT';
$borough_number{'4700'} = '1014'; $type{'4700'} = 'G'; $location{'4700'} = 'VENNESLA';
$borough_number{'4701'} = '1014'; $type{'4701'} = 'P'; $location{'4701'} = 'VENNESLA';
$borough_number{'4702'} = '1014'; $type{'4702'} = 'P'; $location{'4702'} = 'VENNESLA';
$borough_number{'4703'} = '1014'; $type{'4703'} = 'P'; $location{'4703'} = 'VENNESLA';
$borough_number{'4705'} = '1014'; $type{'4705'} = 'P'; $location{'4705'} = 'VREB';
$borough_number{'4715'} = '1014'; $type{'4715'} = 'G'; $location{'4715'} = 'VREB';
$borough_number{'4720'} = '1014'; $type{'4720'} = 'B'; $location{'4720'} = 'HGELAND';
$borough_number{'4724'} = '0935'; $type{'4724'} = 'B'; $location{'4724'} = 'IVELAND';
$borough_number{'4730'} = '0935'; $type{'4730'} = 'G'; $location{'4730'} = 'VATNESTRM';
$borough_number{'4733'} = '0937'; $type{'4733'} = 'P'; $location{'4733'} = 'EVJE';
$borough_number{'4734'} = '0937'; $type{'4734'} = 'P'; $location{'4734'} = 'EVJE';
$borough_number{'4735'} = '0937'; $type{'4735'} = 'B'; $location{'4735'} = 'EVJE';
$borough_number{'4737'} = '0937'; $type{'4737'} = 'G'; $location{'4737'} = 'HORNNES';
$borough_number{'4741'} = '0938'; $type{'4741'} = 'G'; $location{'4741'} = 'BYGLANDSFJORD';
$borough_number{'4742'} = '0938'; $type{'4742'} = 'B'; $location{'4742'} = 'GRENDI';
$borough_number{'4745'} = '0938'; $type{'4745'} = 'B'; $location{'4745'} = 'BYGLAND';
$borough_number{'4747'} = '0940'; $type{'4747'} = 'B'; $location{'4747'} = 'VALLE';
$borough_number{'4748'} = '0940'; $type{'4748'} = 'B'; $location{'4748'} = 'RYSSTAD';
$borough_number{'4754'} = '0941'; $type{'4754'} = 'G'; $location{'4754'} = 'BYKLE';
$borough_number{'4755'} = '0941'; $type{'4755'} = 'B'; $location{'4755'} = 'HOVDEN I SETESDAL';
$borough_number{'4760'} = '0928'; $type{'4760'} = 'G'; $location{'4760'} = 'BIRKELAND';
$borough_number{'4766'} = '0928'; $type{'4766'} = 'G'; $location{'4766'} = 'HEREFOSS';
$borough_number{'4768'} = '0928'; $type{'4768'} = 'G'; $location{'4768'} = 'ENGESLAND';
$borough_number{'4770'} = '0926'; $type{'4770'} = 'B'; $location{'4770'} = 'HVG';
$borough_number{'4780'} = '0926'; $type{'4780'} = 'G'; $location{'4780'} = 'BREKKEST';
$borough_number{'4790'} = '0926'; $type{'4790'} = 'G'; $location{'4790'} = 'LILLESAND';
$borough_number{'4791'} = '0926'; $type{'4791'} = 'P'; $location{'4791'} = 'LILLESAND';
$borough_number{'4792'} = '0926'; $type{'4792'} = 'P'; $location{'4792'} = 'LILLESAND';
$borough_number{'4794'} = '0926'; $type{'4794'} = 'P'; $location{'4794'} = 'LILLESAND';
$borough_number{'4795'} = '0928'; $type{'4795'} = 'P'; $location{'4795'} = 'BIRKELAND';
$borough_number{'4801'} = '0906'; $type{'4801'} = 'P'; $location{'4801'} = 'ARENDAL';
$borough_number{'4802'} = '0906'; $type{'4802'} = 'P'; $location{'4802'} = 'ARENDAL';
$borough_number{'4803'} = '0906'; $type{'4803'} = 'P'; $location{'4803'} = 'ARENDAL';
$borough_number{'4804'} = '0906'; $type{'4804'} = 'P'; $location{'4804'} = 'ARENDAL';
$borough_number{'4808'} = '0906'; $type{'4808'} = 'S'; $location{'4808'} = 'ARENDAL';
$borough_number{'4809'} = '0906'; $type{'4809'} = 'S'; $location{'4809'} = 'ARENDAL';
$borough_number{'4810'} = '0906'; $type{'4810'} = 'G'; $location{'4810'} = 'EYDEHAVN';
$borough_number{'4812'} = '0906'; $type{'4812'} = 'G'; $location{'4812'} = 'KONGSHAVN';
$borough_number{'4815'} = '0906'; $type{'4815'} = 'G'; $location{'4815'} = 'SALTRD';
$borough_number{'4816'} = '0906'; $type{'4816'} = 'G'; $location{'4816'} = 'KOLBJRNSVIK';
$borough_number{'4817'} = '0906'; $type{'4817'} = 'G'; $location{'4817'} = 'HIS';
$borough_number{'4818'} = '0906'; $type{'4818'} = 'G'; $location{'4818'} = 'FRVIK';
$borough_number{'4820'} = '0919'; $type{'4820'} = 'G'; $location{'4820'} = 'FROLAND';
$borough_number{'4821'} = '0906'; $type{'4821'} = 'B'; $location{'4821'} = 'RYKENE';
$borough_number{'4823'} = '0906'; $type{'4823'} = 'G'; $location{'4823'} = 'NEDENES';
$borough_number{'4824'} = '0906'; $type{'4824'} = 'G'; $location{'4824'} = 'BJORBEKK';
$borough_number{'4825'} = '0906'; $type{'4825'} = 'G'; $location{'4825'} = 'ARENDAL';
$borough_number{'4827'} = '0919'; $type{'4827'} = 'G'; $location{'4827'} = 'FROLANDS VERK';
$borough_number{'4828'} = '0919'; $type{'4828'} = 'G'; $location{'4828'} = 'MJVATN';
$borough_number{'4830'} = '0919'; $type{'4830'} = 'G'; $location{'4830'} = 'HYNNEKLEIV';
$borough_number{'4832'} = '0919'; $type{'4832'} = 'G'; $location{'4832'} = 'MYKLAND';
$borough_number{'4834'} = '0919'; $type{'4834'} = 'G'; $location{'4834'} = 'RISDAL';
$borough_number{'4836'} = '0906'; $type{'4836'} = 'G'; $location{'4836'} = 'ARENDAL';
$borough_number{'4838'} = '0906'; $type{'4838'} = 'G'; $location{'4838'} = 'ARENDAL';
$borough_number{'4839'} = '0906'; $type{'4839'} = 'G'; $location{'4839'} = 'ARENDAL';
$borough_number{'4841'} = '0906'; $type{'4841'} = 'G'; $location{'4841'} = 'ARENDAL';
$borough_number{'4842'} = '0906'; $type{'4842'} = 'G'; $location{'4842'} = 'ARENDAL';
$borough_number{'4843'} = '0906'; $type{'4843'} = 'G'; $location{'4843'} = 'ARENDAL';
$borough_number{'4844'} = '0906'; $type{'4844'} = 'G'; $location{'4844'} = 'ARENDAL';
$borough_number{'4846'} = '0906'; $type{'4846'} = 'G'; $location{'4846'} = 'ARENDAL';
$borough_number{'4847'} = '0906'; $type{'4847'} = 'G'; $location{'4847'} = 'ARENDAL';
$borough_number{'4848'} = '0906'; $type{'4848'} = 'G'; $location{'4848'} = 'ARENDAL';
$borough_number{'4849'} = '0906'; $type{'4849'} = 'G'; $location{'4849'} = 'ARENDAL';
$borough_number{'4851'} = '0906'; $type{'4851'} = 'P'; $location{'4851'} = 'SALTRD';
$borough_number{'4852'} = '0906'; $type{'4852'} = 'P'; $location{'4852'} = 'FRVIK';
$borough_number{'4853'} = '0906'; $type{'4853'} = 'P'; $location{'4853'} = 'HIS';
$borough_number{'4854'} = '0906'; $type{'4854'} = 'P'; $location{'4854'} = 'NEDENES';
$borough_number{'4855'} = '0919'; $type{'4855'} = 'P'; $location{'4855'} = 'FROLAND';
$borough_number{'4856'} = '0906'; $type{'4856'} = 'P'; $location{'4856'} = 'ARENDAL';
$borough_number{'4857'} = '0906'; $type{'4857'} = 'P'; $location{'4857'} = 'ARENDAL';
$borough_number{'4858'} = '0906'; $type{'4858'} = 'P'; $location{'4858'} = 'ARENDAL';
$borough_number{'4859'} = '0906'; $type{'4859'} = 'P'; $location{'4859'} = 'ARENDAL';
$borough_number{'4861'} = '0906'; $type{'4861'} = 'P'; $location{'4861'} = 'ARENDAL';
$borough_number{'4862'} = '0906'; $type{'4862'} = 'P'; $location{'4862'} = 'EYDEHAVN';
$borough_number{'4863'} = '0929'; $type{'4863'} = 'B'; $location{'4863'} = 'NELAUG';
$borough_number{'4864'} = '0929'; $type{'4864'} = 'P'; $location{'4864'} = 'MLI';
$borough_number{'4865'} = '0929'; $type{'4865'} = 'G'; $location{'4865'} = 'MLI';
$borough_number{'4868'} = '0929'; $type{'4868'} = 'G'; $location{'4868'} = 'SELSVATN';
$borough_number{'4869'} = '0929'; $type{'4869'} = 'G'; $location{'4869'} = 'DLEMO';
$borough_number{'4870'} = '0904'; $type{'4870'} = 'G'; $location{'4870'} = 'FEVIK';
$borough_number{'4876'} = '0904'; $type{'4876'} = 'G'; $location{'4876'} = 'GRIMSTAD';
$borough_number{'4877'} = '0904'; $type{'4877'} = 'G'; $location{'4877'} = 'GRIMSTAD';
$borough_number{'4878'} = '0904'; $type{'4878'} = 'G'; $location{'4878'} = 'GRIMSTAD';
$borough_number{'4879'} = '0904'; $type{'4879'} = 'G'; $location{'4879'} = 'GRIMSTAD';
$borough_number{'4884'} = '0904'; $type{'4884'} = 'P'; $location{'4884'} = 'GRIMSTAD';
$borough_number{'4885'} = '0904'; $type{'4885'} = 'G'; $location{'4885'} = 'GRIMSTAD';
$borough_number{'4886'} = '0904'; $type{'4886'} = 'G'; $location{'4886'} = 'GRIMSTAD';
$borough_number{'4887'} = '0904'; $type{'4887'} = 'G'; $location{'4887'} = 'GRIMSTAD';
$borough_number{'4888'} = '0904'; $type{'4888'} = 'G'; $location{'4888'} = 'HOMBORSUND';
$borough_number{'4889'} = '0904'; $type{'4889'} = 'P'; $location{'4889'} = 'FEVIK';
$borough_number{'4891'} = '0904'; $type{'4891'} = 'P'; $location{'4891'} = 'GRIMSTAD';
$borough_number{'4892'} = '0904'; $type{'4892'} = 'P'; $location{'4892'} = 'GRIMSTAD';
$borough_number{'4894'} = '0904'; $type{'4894'} = 'K'; $location{'4894'} = 'GRIMSTAD';
$borough_number{'4895'} = '0904'; $type{'4895'} = 'K'; $location{'4895'} = 'GRIMSTAD';
$borough_number{'4896'} = '0904'; $type{'4896'} = 'K'; $location{'4896'} = 'GRIMSTAD';
$borough_number{'4898'} = '0904'; $type{'4898'} = 'S'; $location{'4898'} = 'GRIMSTAD';
$borough_number{'4900'} = '0914'; $type{'4900'} = 'G'; $location{'4900'} = 'TVEDESTRAND';
$borough_number{'4901'} = '0914'; $type{'4901'} = 'P'; $location{'4901'} = 'TVEDESTRAND';
$borough_number{'4902'} = '0914'; $type{'4902'} = 'P'; $location{'4902'} = 'TVEDESTRAND';
$borough_number{'4909'} = '0914'; $type{'4909'} = 'G'; $location{'4909'} = 'SONGE';
$borough_number{'4910'} = '0914'; $type{'4910'} = 'B'; $location{'4910'} = 'LYNGR';
$borough_number{'4912'} = '0914'; $type{'4912'} = 'G'; $location{'4912'} = 'GJEVING';
$borough_number{'4915'} = '0914'; $type{'4915'} = 'G'; $location{'4915'} = 'VESTRE SANDYA';
$borough_number{'4916'} = '0914'; $type{'4916'} = 'G'; $location{'4916'} = 'BORY';
$borough_number{'4920'} = '0906'; $type{'4920'} = 'B'; $location{'4920'} = 'STAUB';
$borough_number{'4934'} = '0914'; $type{'4934'} = 'G'; $location{'4934'} = 'NESGRENDA';
$borough_number{'4950'} = '0901'; $type{'4950'} = 'G'; $location{'4950'} = 'RISR';
$borough_number{'4951'} = '0901'; $type{'4951'} = 'P'; $location{'4951'} = 'RISR';
$borough_number{'4952'} = '0901'; $type{'4952'} = 'P'; $location{'4952'} = 'RISR';
$borough_number{'4953'} = '0901'; $type{'4953'} = 'P'; $location{'4953'} = 'RISR';
$borough_number{'4955'} = '0901'; $type{'4955'} = 'P'; $location{'4955'} = 'RISR';
$borough_number{'4971'} = '0911'; $type{'4971'} = 'P'; $location{'4971'} = 'SUNDEBRU';
$borough_number{'4972'} = '0911'; $type{'4972'} = 'P'; $location{'4972'} = 'GJERSTAD';
$borough_number{'4973'} = '0912'; $type{'4973'} = 'P'; $location{'4973'} = 'VEGRSHEI';
$borough_number{'4974'} = '0901'; $type{'4974'} = 'P'; $location{'4974'} = 'SNDELED';
$borough_number{'4980'} = '0911'; $type{'4980'} = 'G'; $location{'4980'} = 'GJERSTAD';
$borough_number{'4985'} = '0912'; $type{'4985'} = 'G'; $location{'4985'} = 'VEGRSHEI';
$borough_number{'4990'} = '0901'; $type{'4990'} = 'G'; $location{'4990'} = 'SNDELED';
$borough_number{'4993'} = '0911'; $type{'4993'} = 'G'; $location{'4993'} = 'SUNDEBRU';
$borough_number{'4994'} = '0901'; $type{'4994'} = 'G'; $location{'4994'} = 'AKLAND';
$borough_number{'5003'} = '1201'; $type{'5003'} = 'B'; $location{'5003'} = 'BERGEN';
$borough_number{'5004'} = '1201'; $type{'5004'} = 'G'; $location{'5004'} = 'BERGEN';
$borough_number{'5005'} = '1201'; $type{'5005'} = 'G'; $location{'5005'} = 'BERGEN';
$borough_number{'5006'} = '1201'; $type{'5006'} = 'B'; $location{'5006'} = 'BERGEN';
$borough_number{'5007'} = '1201'; $type{'5007'} = 'G'; $location{'5007'} = 'BERGEN';
$borough_number{'5008'} = '1201'; $type{'5008'} = 'G'; $location{'5008'} = 'BERGEN';
$borough_number{'5009'} = '1201'; $type{'5009'} = 'G'; $location{'5009'} = 'BERGEN';
$borough_number{'5010'} = '1201'; $type{'5010'} = 'G'; $location{'5010'} = 'BERGEN';
$borough_number{'5011'} = '1201'; $type{'5011'} = 'G'; $location{'5011'} = 'BERGEN';
$borough_number{'5012'} = '1201'; $type{'5012'} = 'G'; $location{'5012'} = 'BERGEN';
$borough_number{'5013'} = '1201'; $type{'5013'} = 'G'; $location{'5013'} = 'BERGEN';
$borough_number{'5014'} = '1201'; $type{'5014'} = 'G'; $location{'5014'} = 'BERGEN';
$borough_number{'5015'} = '1201'; $type{'5015'} = 'G'; $location{'5015'} = 'BERGEN';
$borough_number{'5016'} = '1201'; $type{'5016'} = 'G'; $location{'5016'} = 'BERGEN';
$borough_number{'5017'} = '1201'; $type{'5017'} = 'G'; $location{'5017'} = 'BERGEN';
$borough_number{'5018'} = '1201'; $type{'5018'} = 'G'; $location{'5018'} = 'BERGEN';
$borough_number{'5019'} = '1201'; $type{'5019'} = 'G'; $location{'5019'} = 'BERGEN';
$borough_number{'5020'} = '1201'; $type{'5020'} = 'S'; $location{'5020'} = 'BERGEN';
$borough_number{'5021'} = '1201'; $type{'5021'} = 'K'; $location{'5021'} = 'BERGEN';
$borough_number{'5031'} = '1201'; $type{'5031'} = 'G'; $location{'5031'} = 'BERGEN';
$borough_number{'5032'} = '1201'; $type{'5032'} = 'G'; $location{'5032'} = 'BERGEN';
$borough_number{'5033'} = '1201'; $type{'5033'} = 'G'; $location{'5033'} = 'BERGEN';
$borough_number{'5034'} = '1201'; $type{'5034'} = 'G'; $location{'5034'} = 'BERGEN';
$borough_number{'5035'} = '1201'; $type{'5035'} = 'B'; $location{'5035'} = 'BERGEN';
$borough_number{'5036'} = '1201'; $type{'5036'} = 'G'; $location{'5036'} = 'BERGEN';
$borough_number{'5037'} = '1201'; $type{'5037'} = 'G'; $location{'5037'} = 'BERGEN';
$borough_number{'5038'} = '1201'; $type{'5038'} = 'G'; $location{'5038'} = 'BERGEN';
$borough_number{'5039'} = '1201'; $type{'5039'} = 'G'; $location{'5039'} = 'BERGEN';
$borough_number{'5041'} = '1201'; $type{'5041'} = 'F'; $location{'5041'} = 'BERGEN';
$borough_number{'5042'} = '1201'; $type{'5042'} = 'G'; $location{'5042'} = 'BERGEN';
$borough_number{'5043'} = '1201'; $type{'5043'} = 'G'; $location{'5043'} = 'BERGEN';
$borough_number{'5045'} = '1201'; $type{'5045'} = 'F'; $location{'5045'} = 'BERGEN';
$borough_number{'5052'} = '1201'; $type{'5052'} = 'G'; $location{'5052'} = 'BERGEN';
$borough_number{'5053'} = '1201'; $type{'5053'} = 'G'; $location{'5053'} = 'BERGEN';
$borough_number{'5054'} = '1201'; $type{'5054'} = 'G'; $location{'5054'} = 'BERGEN';
$borough_number{'5055'} = '1201'; $type{'5055'} = 'G'; $location{'5055'} = 'BERGEN';
$borough_number{'5056'} = '1201'; $type{'5056'} = 'G'; $location{'5056'} = 'BERGEN';
$borough_number{'5057'} = '1201'; $type{'5057'} = 'G'; $location{'5057'} = 'BERGEN';
$borough_number{'5058'} = '1201'; $type{'5058'} = 'G'; $location{'5058'} = 'BERGEN';
$borough_number{'5059'} = '1201'; $type{'5059'} = 'G'; $location{'5059'} = 'BERGEN';
$borough_number{'5063'} = '1201'; $type{'5063'} = 'G'; $location{'5063'} = 'BERGEN';
$borough_number{'5067'} = '1201'; $type{'5067'} = 'G'; $location{'5067'} = 'BERGEN';
$borough_number{'5068'} = '1201'; $type{'5068'} = 'G'; $location{'5068'} = 'BERGEN';
$borough_number{'5072'} = '1201'; $type{'5072'} = 'G'; $location{'5072'} = 'BERGEN';
$borough_number{'5073'} = '1201'; $type{'5073'} = 'G'; $location{'5073'} = 'BERGEN';
$borough_number{'5075'} = '1201'; $type{'5075'} = 'F'; $location{'5075'} = 'BERGEN';
$borough_number{'5081'} = '1201'; $type{'5081'} = 'G'; $location{'5081'} = 'BERGEN';
$borough_number{'5089'} = '1201'; $type{'5089'} = 'G'; $location{'5089'} = 'BERGEN';
$borough_number{'5093'} = '1201'; $type{'5093'} = 'G'; $location{'5093'} = 'BERGEN';
$borough_number{'5094'} = '1201'; $type{'5094'} = 'G'; $location{'5094'} = 'BERGEN';
$borough_number{'5096'} = '1201'; $type{'5096'} = 'G'; $location{'5096'} = 'BERGEN';
$borough_number{'5097'} = '1201'; $type{'5097'} = 'G'; $location{'5097'} = 'BERGEN';
$borough_number{'5098'} = '1201'; $type{'5098'} = 'G'; $location{'5098'} = 'BERGEN';
$borough_number{'5099'} = '1201'; $type{'5099'} = 'G'; $location{'5099'} = 'BERGEN';
$borough_number{'5101'} = '1201'; $type{'5101'} = 'G'; $location{'5101'} = 'EIDSVGNESET';
$borough_number{'5104'} = '1201'; $type{'5104'} = 'G'; $location{'5104'} = 'EIDSVG I SANE';
$borough_number{'5105'} = '1201'; $type{'5105'} = 'G'; $location{'5105'} = 'EIDSVG I SANE';
$borough_number{'5106'} = '1201'; $type{'5106'} = 'G'; $location{'5106'} = 'VRE ERVIK';
$borough_number{'5107'} = '1201'; $type{'5107'} = 'G'; $location{'5107'} = 'SALHUS';
$borough_number{'5108'} = '1201'; $type{'5108'} = 'G'; $location{'5108'} = 'HORDVIK';
$borough_number{'5109'} = '1201'; $type{'5109'} = 'G'; $location{'5109'} = 'HYLKJE';
$borough_number{'5111'} = '1201'; $type{'5111'} = 'G'; $location{'5111'} = 'BREISTEIN';
$borough_number{'5113'} = '1201'; $type{'5113'} = 'B'; $location{'5113'} = 'TERTNES';
$borough_number{'5114'} = '1201'; $type{'5114'} = 'G'; $location{'5114'} = 'TERTNES';
$borough_number{'5115'} = '1201'; $type{'5115'} = 'G'; $location{'5115'} = 'ULSET';
$borough_number{'5116'} = '1201'; $type{'5116'} = 'G'; $location{'5116'} = 'ULSET';
$borough_number{'5117'} = '1201'; $type{'5117'} = 'G'; $location{'5117'} = 'ULSET';
$borough_number{'5118'} = '1201'; $type{'5118'} = 'G'; $location{'5118'} = 'ULSET';
$borough_number{'5119'} = '1201'; $type{'5119'} = 'G'; $location{'5119'} = 'ULSET';
$borough_number{'5121'} = '1201'; $type{'5121'} = 'G'; $location{'5121'} = 'ULSET';
$borough_number{'5122'} = '1201'; $type{'5122'} = 'G'; $location{'5122'} = 'MORVIK';
$borough_number{'5124'} = '1201'; $type{'5124'} = 'B'; $location{'5124'} = 'MORVIK';
$borough_number{'5131'} = '1201'; $type{'5131'} = 'G'; $location{'5131'} = 'NYBORG';
$borough_number{'5132'} = '1201'; $type{'5132'} = 'G'; $location{'5132'} = 'NYBORG';
$borough_number{'5134'} = '1201'; $type{'5134'} = 'G'; $location{'5134'} = 'FLAKTVEIT';
$borough_number{'5135'} = '1201'; $type{'5135'} = 'G'; $location{'5135'} = 'FLAKTVEIT';
$borough_number{'5136'} = '1201'; $type{'5136'} = 'G'; $location{'5136'} = 'MJLKEREN';
$borough_number{'5137'} = '1201'; $type{'5137'} = 'G'; $location{'5137'} = 'MJLKEREN';
$borough_number{'5141'} = '1201'; $type{'5141'} = 'B'; $location{'5141'} = 'FYLLINGSDALEN';
$borough_number{'5142'} = '1201'; $type{'5142'} = 'G'; $location{'5142'} = 'FYLLINGSDALEN';
$borough_number{'5143'} = '1201'; $type{'5143'} = 'G'; $location{'5143'} = 'FYLLINGSDALEN';
$borough_number{'5144'} = '1201'; $type{'5144'} = 'G'; $location{'5144'} = 'FYLLINGSDALEN';
$borough_number{'5145'} = '1201'; $type{'5145'} = 'G'; $location{'5145'} = 'FYLLINGSDALEN';
$borough_number{'5146'} = '1201'; $type{'5146'} = 'G'; $location{'5146'} = 'FYLLINGSDALEN';
$borough_number{'5147'} = '1201'; $type{'5147'} = 'G'; $location{'5147'} = 'FYLLINGSDALEN';
$borough_number{'5148'} = '1201'; $type{'5148'} = 'G'; $location{'5148'} = 'FYLLINGSDALEN';
$borough_number{'5151'} = '1201'; $type{'5151'} = 'G'; $location{'5151'} = 'STRAUMSGREND';
$borough_number{'5152'} = '1201'; $type{'5152'} = 'G'; $location{'5152'} = 'BNES';
$borough_number{'5155'} = '1201'; $type{'5155'} = 'G'; $location{'5155'} = 'BNES';
$borough_number{'5161'} = '1201'; $type{'5161'} = 'G'; $location{'5161'} = 'LAKSEVG';
$borough_number{'5162'} = '1201'; $type{'5162'} = 'G'; $location{'5162'} = 'LAKSEVG';
$borough_number{'5163'} = '1201'; $type{'5163'} = 'G'; $location{'5163'} = 'LAKSEVG';
$borough_number{'5164'} = '1201'; $type{'5164'} = 'G'; $location{'5164'} = 'LAKSEVG';
$borough_number{'5171'} = '1201'; $type{'5171'} = 'B'; $location{'5171'} = 'LODDEFJORD';
$borough_number{'5172'} = '1201'; $type{'5172'} = 'G'; $location{'5172'} = 'LODDEFJORD';
$borough_number{'5173'} = '1201'; $type{'5173'} = 'G'; $location{'5173'} = 'LODDEFJORD';
$borough_number{'5174'} = '1201'; $type{'5174'} = 'B'; $location{'5174'} = 'MATHOPEN';
$borough_number{'5177'} = '1246'; $type{'5177'} = 'G'; $location{'5177'} = 'BJRYHAMN';
$borough_number{'5178'} = '1201'; $type{'5178'} = 'G'; $location{'5178'} = 'LODDEFJORD';
$borough_number{'5179'} = '1201'; $type{'5179'} = 'G'; $location{'5179'} = 'GODVIK';
$borough_number{'5183'} = '1201'; $type{'5183'} = 'G'; $location{'5183'} = 'OLSVIK';
$borough_number{'5184'} = '1201'; $type{'5184'} = 'G'; $location{'5184'} = 'OLSVIK';
$borough_number{'5200'} = '1243'; $type{'5200'} = 'G'; $location{'5200'} = 'OS';
$borough_number{'5201'} = '1243'; $type{'5201'} = 'P'; $location{'5201'} = 'OS';
$borough_number{'5202'} = '1243'; $type{'5202'} = 'P'; $location{'5202'} = 'OS';
$borough_number{'5203'} = '1243'; $type{'5203'} = 'P'; $location{'5203'} = 'OS';
$borough_number{'5206'} = '1243'; $type{'5206'} = 'P'; $location{'5206'} = 'OS';
$borough_number{'5207'} = '1243'; $type{'5207'} = 'P'; $location{'5207'} = 'SFTELAND';
$borough_number{'5212'} = '1243'; $type{'5212'} = 'G'; $location{'5212'} = 'SFTELAND';
$borough_number{'5215'} = '1243'; $type{'5215'} = 'B'; $location{'5215'} = 'LYSEKLOSTER';
$borough_number{'5216'} = '1243'; $type{'5216'} = 'B'; $location{'5216'} = 'LEPSY';
$borough_number{'5217'} = '1243'; $type{'5217'} = 'G'; $location{'5217'} = 'HAGAVIK';
$borough_number{'5218'} = '1243'; $type{'5218'} = 'G'; $location{'5218'} = 'NORDSTRNO';
$borough_number{'5219'} = '1243'; $type{'5219'} = 'G'; $location{'5219'} = 'SKORPO FERIEHEIM';
$borough_number{'5221'} = '1201'; $type{'5221'} = 'G'; $location{'5221'} = 'NESTTUN';
$borough_number{'5222'} = '1201'; $type{'5222'} = 'G'; $location{'5222'} = 'NESTTUN';
$borough_number{'5223'} = '1201'; $type{'5223'} = 'G'; $location{'5223'} = 'NESTTUN';
$borough_number{'5224'} = '1201'; $type{'5224'} = 'G'; $location{'5224'} = 'NESTTUN';
$borough_number{'5225'} = '1201'; $type{'5225'} = 'G'; $location{'5225'} = 'NESTTUN';
$borough_number{'5226'} = '1201'; $type{'5226'} = 'G'; $location{'5226'} = 'NESTTUN';
$borough_number{'5227'} = '1201'; $type{'5227'} = 'G'; $location{'5227'} = 'NESTTUN';
$borough_number{'5229'} = '1201'; $type{'5229'} = 'G'; $location{'5229'} = 'KALANDSEIDET';
$borough_number{'5231'} = '1201'; $type{'5231'} = 'G'; $location{'5231'} = 'PARADIS';
$borough_number{'5232'} = '1201'; $type{'5232'} = 'G'; $location{'5232'} = 'PARADIS';
$borough_number{'5235'} = '1201'; $type{'5235'} = 'G'; $location{'5235'} = 'RDAL';
$borough_number{'5236'} = '1201'; $type{'5236'} = 'B'; $location{'5236'} = 'RDAL';
$borough_number{'5238'} = '1201'; $type{'5238'} = 'G'; $location{'5238'} = 'RDAL';
$borough_number{'5239'} = '1201'; $type{'5239'} = 'G'; $location{'5239'} = 'RDAL';
$borough_number{'5243'} = '1201'; $type{'5243'} = 'G'; $location{'5243'} = 'FANA';
$borough_number{'5244'} = '1201'; $type{'5244'} = 'G'; $location{'5244'} = 'FANA';
$borough_number{'5251'} = '1201'; $type{'5251'} = 'B'; $location{'5251'} = 'SREIDGREND';
$borough_number{'5252'} = '1201'; $type{'5252'} = 'G'; $location{'5252'} = 'SREIDGREND';
$borough_number{'5253'} = '1201'; $type{'5253'} = 'G'; $location{'5253'} = 'SANDSLI';
$borough_number{'5254'} = '1201'; $type{'5254'} = 'G'; $location{'5254'} = 'SANDSLI';
$borough_number{'5257'} = '1201'; $type{'5257'} = 'G'; $location{'5257'} = 'KOKSTAD';
$borough_number{'5258'} = '1201'; $type{'5258'} = 'G'; $location{'5258'} = 'BLOMSTERDALEN';
$borough_number{'5259'} = '1201'; $type{'5259'} = 'B'; $location{'5259'} = 'HJELLESTAD';
$borough_number{'5260'} = '1201'; $type{'5260'} = 'G'; $location{'5260'} = 'INDRE ARNA';
$borough_number{'5261'} = '1201'; $type{'5261'} = 'G'; $location{'5261'} = 'INDRE ARNA';
$borough_number{'5262'} = '1201'; $type{'5262'} = 'G'; $location{'5262'} = 'ARNATVEIT';
$borough_number{'5263'} = '1201'; $type{'5263'} = 'G'; $location{'5263'} = 'TRENGEREID';
$borough_number{'5264'} = '1201'; $type{'5264'} = 'G'; $location{'5264'} = 'GARNES';
$borough_number{'5265'} = '1201'; $type{'5265'} = 'G'; $location{'5265'} = 'YTRE ARNA';
$borough_number{'5267'} = '1201'; $type{'5267'} = 'G'; $location{'5267'} = 'ESPELAND';
$borough_number{'5268'} = '1201'; $type{'5268'} = 'B'; $location{'5268'} = 'HAUKELAND';
$borough_number{'5281'} = '1253'; $type{'5281'} = 'G'; $location{'5281'} = 'VALESTRANDSFOSSEN';
$borough_number{'5282'} = '1253'; $type{'5282'} = 'G'; $location{'5282'} = 'LONEVG';
$borough_number{'5283'} = '1253'; $type{'5283'} = 'G'; $location{'5283'} = 'FOTLANDSVG';
$borough_number{'5284'} = '1253'; $type{'5284'} = 'G'; $location{'5284'} = 'TYSSEBOTNEN';
$borough_number{'5285'} = '1253'; $type{'5285'} = 'G'; $location{'5285'} = 'BRUVIK';
$borough_number{'5286'} = '1253'; $type{'5286'} = 'G'; $location{'5286'} = 'HAUS';
$borough_number{'5291'} = '1253'; $type{'5291'} = 'P'; $location{'5291'} = 'VALESTRANDSFOSSEN';
$borough_number{'5293'} = '1253'; $type{'5293'} = 'P'; $location{'5293'} = 'LONEVG';
$borough_number{'5299'} = '1253'; $type{'5299'} = 'P'; $location{'5299'} = 'HAUS';
$borough_number{'5300'} = '1247'; $type{'5300'} = 'G'; $location{'5300'} = 'KLEPPEST';
$borough_number{'5302'} = '1247'; $type{'5302'} = 'G'; $location{'5302'} = 'STRUSSHAMN';
$borough_number{'5303'} = '1247'; $type{'5303'} = 'G'; $location{'5303'} = 'FOLLESE';
$borough_number{'5304'} = '1247'; $type{'5304'} = 'G'; $location{'5304'} = 'HETLEVIK';
$borough_number{'5305'} = '1247'; $type{'5305'} = 'G'; $location{'5305'} = 'FLORVG';
$borough_number{'5306'} = '1247'; $type{'5306'} = 'G'; $location{'5306'} = 'ERDAL';
$borough_number{'5307'} = '1247'; $type{'5307'} = 'G'; $location{'5307'} = 'ASK';
$borough_number{'5310'} = '1247'; $type{'5310'} = 'G'; $location{'5310'} = 'HAUGLANDSHELLA';
$borough_number{'5314'} = '1247'; $type{'5314'} = 'B'; $location{'5314'} = 'KJERRGARDEN';
$borough_number{'5315'} = '1247'; $type{'5315'} = 'G'; $location{'5315'} = 'HERDLA';
$borough_number{'5318'} = '1247'; $type{'5318'} = 'P'; $location{'5318'} = 'STRUSSHAMN';
$borough_number{'5319'} = '1247'; $type{'5319'} = 'P'; $location{'5319'} = 'KLEPPEST';
$borough_number{'5321'} = '1247'; $type{'5321'} = 'P'; $location{'5321'} = 'KLEPPEST';
$borough_number{'5322'} = '1247'; $type{'5322'} = 'P'; $location{'5322'} = 'KLEPPEST';
$borough_number{'5323'} = '1247'; $type{'5323'} = 'P'; $location{'5323'} = 'KLEPPEST';
$borough_number{'5325'} = '1247'; $type{'5325'} = 'P'; $location{'5325'} = 'FOLLESE';
$borough_number{'5326'} = '1247'; $type{'5326'} = 'P'; $location{'5326'} = 'ASK';
$borough_number{'5327'} = '1247'; $type{'5327'} = 'P'; $location{'5327'} = 'HAUGLANDSHELLA';
$borough_number{'5329'} = '1247'; $type{'5329'} = 'P'; $location{'5329'} = 'FLORVG';
$borough_number{'5331'} = '1259'; $type{'5331'} = 'P'; $location{'5331'} = 'RONG';
$borough_number{'5333'} = '1259'; $type{'5333'} = 'P'; $location{'5333'} = 'TJELDST';
$borough_number{'5334'} = '1259'; $type{'5334'} = 'G'; $location{'5334'} = 'HELLESY';
$borough_number{'5335'} = '1259'; $type{'5335'} = 'B'; $location{'5335'} = 'HERNAR';
$borough_number{'5336'} = '1259'; $type{'5336'} = 'G'; $location{'5336'} = 'TJELDST';
$borough_number{'5337'} = '1259'; $type{'5337'} = 'G'; $location{'5337'} = 'RONG';
$borough_number{'5341'} = '1246'; $type{'5341'} = 'P'; $location{'5341'} = 'STRAUME';
$borough_number{'5342'} = '1246'; $type{'5342'} = 'P'; $location{'5342'} = 'STRAUME';
$borough_number{'5343'} = '1246'; $type{'5343'} = 'P'; $location{'5343'} = 'STRAUME';
$borough_number{'5345'} = '1246'; $type{'5345'} = 'P'; $location{'5345'} = 'KNARREVIK';
$borough_number{'5346'} = '1246'; $type{'5346'} = 'P'; $location{'5346'} = 'GOTNES';
$borough_number{'5347'} = '1246'; $type{'5347'} = 'B'; $location{'5347'} = 'KYSTBASEN GOTNES';
$borough_number{'5350'} = '1246'; $type{'5350'} = 'G'; $location{'5350'} = 'BRATTHOLMEN';
$borough_number{'5353'} = '1246'; $type{'5353'} = 'G'; $location{'5353'} = 'STRAUME';
$borough_number{'5355'} = '1246'; $type{'5355'} = 'G'; $location{'5355'} = 'KNARREVIK';
$borough_number{'5357'} = '1246'; $type{'5357'} = 'G'; $location{'5357'} = 'FJELL';
$borough_number{'5358'} = '1246'; $type{'5358'} = 'P'; $location{'5358'} = 'FJELL';
$borough_number{'5363'} = '1246'; $type{'5363'} = 'G'; $location{'5363'} = 'GOTNES';
$borough_number{'5365'} = '1246'; $type{'5365'} = 'G'; $location{'5365'} = 'TURY';
$borough_number{'5366'} = '1246'; $type{'5366'} = 'G'; $location{'5366'} = 'MISJE';
$borough_number{'5371'} = '1245'; $type{'5371'} = 'P'; $location{'5371'} = 'SKOGSVG';
$borough_number{'5373'} = '1245'; $type{'5373'} = 'P'; $location{'5373'} = 'KLOKKARVIK';
$borough_number{'5374'} = '1245'; $type{'5374'} = 'P'; $location{'5374'} = 'STEINSLAND';
$borough_number{'5378'} = '1245'; $type{'5378'} = 'G'; $location{'5378'} = 'KLOKKARVIK';
$borough_number{'5379'} = '1245'; $type{'5379'} = 'G'; $location{'5379'} = 'STEINSLAND';
$borough_number{'5380'} = '1245'; $type{'5380'} = 'G'; $location{'5380'} = 'TLAVG';
$borough_number{'5381'} = '1245'; $type{'5381'} = 'G'; $location{'5381'} = 'GLESVR';
$borough_number{'5382'} = '1245'; $type{'5382'} = 'G'; $location{'5382'} = 'SKOGSVG';
$borough_number{'5384'} = '1244'; $type{'5384'} = 'G'; $location{'5384'} = 'TORANGSVG';
$borough_number{'5385'} = '1244'; $type{'5385'} = 'G'; $location{'5385'} = 'BAKKASUND';
$borough_number{'5387'} = '1244'; $type{'5387'} = 'B'; $location{'5387'} = 'MKSTER';
$borough_number{'5388'} = '1244'; $type{'5388'} = 'G'; $location{'5388'} = 'LITLAKALSY';
$borough_number{'5392'} = '1244'; $type{'5392'} = 'G'; $location{'5392'} = 'STOREB';
$borough_number{'5393'} = '1244'; $type{'5393'} = 'P'; $location{'5393'} = 'STOREB';
$borough_number{'5394'} = '1244'; $type{'5394'} = 'G'; $location{'5394'} = 'KOLBEINSVIK';
$borough_number{'5396'} = '1244'; $type{'5396'} = 'G'; $location{'5396'} = 'VESTRE VINNESVG';
$borough_number{'5397'} = '1244'; $type{'5397'} = 'G'; $location{'5397'} = 'BEKKJARVIK';
$borough_number{'5398'} = '1244'; $type{'5398'} = 'G'; $location{'5398'} = 'STOLMEN';
$borough_number{'5399'} = '1244'; $type{'5399'} = 'P'; $location{'5399'} = 'BEKKJARVIK';
$borough_number{'5401'} = '1221'; $type{'5401'} = 'P'; $location{'5401'} = 'STORD';
$borough_number{'5402'} = '1221'; $type{'5402'} = 'P'; $location{'5402'} = 'STORD';
$borough_number{'5403'} = '1221'; $type{'5403'} = 'P'; $location{'5403'} = 'STORD';
$borough_number{'5404'} = '1221'; $type{'5404'} = 'P'; $location{'5404'} = 'STORD';
$borough_number{'5405'} = '1221'; $type{'5405'} = 'P'; $location{'5405'} = 'STORD';
$borough_number{'5406'} = '1221'; $type{'5406'} = 'P'; $location{'5406'} = 'STORD';
$borough_number{'5407'} = '1221'; $type{'5407'} = 'P'; $location{'5407'} = 'STORD';
$borough_number{'5408'} = '1221'; $type{'5408'} = 'P'; $location{'5408'} = 'SAGVG';
$borough_number{'5409'} = '1221'; $type{'5409'} = 'S'; $location{'5409'} = 'STORD';
$borough_number{'5410'} = '1221'; $type{'5410'} = 'G'; $location{'5410'} = 'SAGVG';
$borough_number{'5411'} = '1221'; $type{'5411'} = 'G'; $location{'5411'} = 'STORD';
$borough_number{'5412'} = '1221'; $type{'5412'} = 'G'; $location{'5412'} = 'STORD';
$borough_number{'5414'} = '1221'; $type{'5414'} = 'G'; $location{'5414'} = 'STORD';
$borough_number{'5415'} = '1221'; $type{'5415'} = 'G'; $location{'5415'} = 'STORD';
$borough_number{'5416'} = '1221'; $type{'5416'} = 'G'; $location{'5416'} = 'STORD';
$borough_number{'5417'} = '1221'; $type{'5417'} = 'G'; $location{'5417'} = 'STORD';
$borough_number{'5418'} = '1222'; $type{'5418'} = 'P'; $location{'5418'} = 'FITJAR';
$borough_number{'5419'} = '1222'; $type{'5419'} = 'G'; $location{'5419'} = 'FITJAR';
$borough_number{'5420'} = '1219'; $type{'5420'} = 'G'; $location{'5420'} = 'RUBBESTADNESET';
$borough_number{'5423'} = '1219'; $type{'5423'} = 'G'; $location{'5423'} = 'BRANDASUND';
$borough_number{'5427'} = '1219'; $type{'5427'} = 'G'; $location{'5427'} = 'URANGSVG';
$borough_number{'5428'} = '1219'; $type{'5428'} = 'G'; $location{'5428'} = 'FOLDRYHAMN';
$borough_number{'5430'} = '1219'; $type{'5430'} = 'G'; $location{'5430'} = 'BREMNES';
$borough_number{'5437'} = '1219'; $type{'5437'} = 'G'; $location{'5437'} = 'FINNS';
$borough_number{'5440'} = '1219'; $type{'5440'} = 'G'; $location{'5440'} = 'MOSTERHAMN';
$borough_number{'5443'} = '1219'; $type{'5443'} = 'G'; $location{'5443'} = 'BMLO';
$borough_number{'5444'} = '1219'; $type{'5444'} = 'B'; $location{'5444'} = 'ESPEVR';
$borough_number{'5445'} = '1219'; $type{'5445'} = 'P'; $location{'5445'} = 'BREMNES';
$borough_number{'5447'} = '1219'; $type{'5447'} = 'P'; $location{'5447'} = 'MOSTERHAMN';
$borough_number{'5449'} = '1219'; $type{'5449'} = 'P'; $location{'5449'} = 'BMLO';
$borough_number{'5450'} = '1224'; $type{'5450'} = 'G'; $location{'5450'} = 'SUNDE I SUNNHORDLAND';
$borough_number{'5451'} = '1224'; $type{'5451'} = 'B'; $location{'5451'} = 'VALEN';
$borough_number{'5452'} = '1224'; $type{'5452'} = 'G'; $location{'5452'} = 'SANDVOLL';
$borough_number{'5453'} = '1224'; $type{'5453'} = 'G'; $location{'5453'} = 'UTKER';
$borough_number{'5454'} = '1224'; $type{'5454'} = 'G'; $location{'5454'} = 'SBVIK';
$borough_number{'5455'} = '1224'; $type{'5455'} = 'G'; $location{'5455'} = 'HALSNY KLOSTER';
$borough_number{'5457'} = '1224'; $type{'5457'} = 'G'; $location{'5457'} = 'HYLANDSBYGD';
$borough_number{'5458'} = '1224'; $type{'5458'} = 'G'; $location{'5458'} = 'ARNAVIK';
$borough_number{'5459'} = '1224'; $type{'5459'} = 'G'; $location{'5459'} = 'FJELBERG';
$borough_number{'5460'} = '1224'; $type{'5460'} = 'G'; $location{'5460'} = 'HUSNES';
$borough_number{'5462'} = '1224'; $type{'5462'} = 'B'; $location{'5462'} = 'HERYSUNDET';
$borough_number{'5463'} = '1224'; $type{'5463'} = 'G'; $location{'5463'} = 'USKEDALEN';
$borough_number{'5464'} = '1224'; $type{'5464'} = 'G'; $location{'5464'} = 'DIMMELSVIK';
$borough_number{'5465'} = '1224'; $type{'5465'} = 'P'; $location{'5465'} = 'USKEDALEN';
$borough_number{'5470'} = '1224'; $type{'5470'} = 'G'; $location{'5470'} = 'ROSENDAL';
$borough_number{'5472'} = '1224'; $type{'5472'} = 'G'; $location{'5472'} = 'SEIMSFOSS';
$borough_number{'5473'} = '1224'; $type{'5473'} = 'G'; $location{'5473'} = 'SNILSTVEITY';
$borough_number{'5474'} = '1224'; $type{'5474'} = 'G'; $location{'5474'} = 'LFALLSTRAND';
$borough_number{'5475'} = '1224'; $type{'5475'} = 'G'; $location{'5475'} = 'NES';
$borough_number{'5476'} = '1224'; $type{'5476'} = 'G'; $location{'5476'} = 'MAURANGER';
$borough_number{'5480'} = '1224'; $type{'5480'} = 'P'; $location{'5480'} = 'HUSNES';
$borough_number{'5484'} = '1224'; $type{'5484'} = 'P'; $location{'5484'} = 'SBVIK';
$borough_number{'5486'} = '1224'; $type{'5486'} = 'P'; $location{'5486'} = 'ROSENDAL';
$borough_number{'5497'} = '1221'; $type{'5497'} = 'G'; $location{'5497'} = 'HUGLO';
$borough_number{'5498'} = '1224'; $type{'5498'} = 'G'; $location{'5498'} = 'MATRE';
$borough_number{'5499'} = '1224'; $type{'5499'} = 'G'; $location{'5499'} = 'KRA';
$borough_number{'5501'} = '1106'; $type{'5501'} = 'P'; $location{'5501'} = 'HAUGESUND';
$borough_number{'5502'} = '1106'; $type{'5502'} = 'P'; $location{'5502'} = 'HAUGESUND';
$borough_number{'5503'} = '1106'; $type{'5503'} = 'P'; $location{'5503'} = 'HAUGESUND';
$borough_number{'5504'} = '1106'; $type{'5504'} = 'P'; $location{'5504'} = 'HAUGESUND';
$borough_number{'5505'} = '1106'; $type{'5505'} = 'P'; $location{'5505'} = 'HAUGESUND';
$borough_number{'5506'} = '1106'; $type{'5506'} = 'P'; $location{'5506'} = 'HAUGESUND';
$borough_number{'5507'} = '1106'; $type{'5507'} = 'P'; $location{'5507'} = 'HAUGESUND';
$borough_number{'5508'} = '1149'; $type{'5508'} = 'P'; $location{'5508'} = 'KARMSUND';
$borough_number{'5509'} = '1106'; $type{'5509'} = 'P'; $location{'5509'} = 'HAUGESUND';
$borough_number{'5511'} = '1106'; $type{'5511'} = 'P'; $location{'5511'} = 'HAUGESUND';
$borough_number{'5514'} = '1106'; $type{'5514'} = 'G'; $location{'5514'} = 'HAUGESUND';
$borough_number{'5515'} = '1106'; $type{'5515'} = 'G'; $location{'5515'} = 'HAUGESUND';
$borough_number{'5516'} = '1106'; $type{'5516'} = 'G'; $location{'5516'} = 'HAUGESUND';
$borough_number{'5517'} = '1106'; $type{'5517'} = 'G'; $location{'5517'} = 'HAUGESUND';
$borough_number{'5518'} = '1106'; $type{'5518'} = 'B'; $location{'5518'} = 'HAUGESUND';
$borough_number{'5519'} = '1106'; $type{'5519'} = 'G'; $location{'5519'} = 'HAUGESUND';
$borough_number{'5521'} = '1106'; $type{'5521'} = 'G'; $location{'5521'} = 'HAUGESUND';
$borough_number{'5522'} = '1106'; $type{'5522'} = 'G'; $location{'5522'} = 'HAUGESUND';
$borough_number{'5523'} = '1106'; $type{'5523'} = 'G'; $location{'5523'} = 'HAUGESUND';
$borough_number{'5525'} = '1106'; $type{'5525'} = 'G'; $location{'5525'} = 'HAUGESUND';
$borough_number{'5527'} = '1106'; $type{'5527'} = 'G'; $location{'5527'} = 'HAUGESUND';
$borough_number{'5528'} = '1106'; $type{'5528'} = 'G'; $location{'5528'} = 'HAUGESUND';
$borough_number{'5529'} = '1106'; $type{'5529'} = 'G'; $location{'5529'} = 'HAUGESUND';
$borough_number{'5531'} = '1106'; $type{'5531'} = 'G'; $location{'5531'} = 'HAUGESUND';
$borough_number{'5532'} = '1106'; $type{'5532'} = 'G'; $location{'5532'} = 'HAUGESUND';
$borough_number{'5533'} = '1106'; $type{'5533'} = 'G'; $location{'5533'} = 'HAUGESUND';
$borough_number{'5534'} = '1106'; $type{'5534'} = 'G'; $location{'5534'} = 'HAUGESUND';
$borough_number{'5535'} = '1106'; $type{'5535'} = 'G'; $location{'5535'} = 'HAUGESUND';
$borough_number{'5536'} = '1106'; $type{'5536'} = 'G'; $location{'5536'} = 'HAUGESUND';
$borough_number{'5537'} = '1106'; $type{'5537'} = 'G'; $location{'5537'} = 'HAUGESUND';
$borough_number{'5538'} = '1106'; $type{'5538'} = 'G'; $location{'5538'} = 'HAUGESUND';
$borough_number{'5541'} = '1149'; $type{'5541'} = 'G'; $location{'5541'} = 'KOLNES';
$borough_number{'5542'} = '1149'; $type{'5542'} = 'G'; $location{'5542'} = 'KARMSUND';
$borough_number{'5544'} = '1149'; $type{'5544'} = 'P'; $location{'5544'} = 'VORMEDAL';
$borough_number{'5545'} = '1149'; $type{'5545'} = 'G'; $location{'5545'} = 'VORMEDAL';
$borough_number{'5546'} = '1149'; $type{'5546'} = 'G'; $location{'5546'} = 'RYKSUND';
$borough_number{'5547'} = '1151'; $type{'5547'} = 'B'; $location{'5547'} = 'UTSIRA';
$borough_number{'5548'} = '1149'; $type{'5548'} = 'B'; $location{'5548'} = 'FEY';
$borough_number{'5549'} = '1106'; $type{'5549'} = 'B'; $location{'5549'} = 'RVR';
$borough_number{'5550'} = '1216'; $type{'5550'} = 'G'; $location{'5550'} = 'SVEIO';
$borough_number{'5551'} = '1216'; $type{'5551'} = 'G'; $location{'5551'} = 'AUKLANDSHAMN';
$borough_number{'5554'} = '1216'; $type{'5554'} = 'B'; $location{'5554'} = 'VALEVG';
$borough_number{'5555'} = '1216'; $type{'5555'} = 'B'; $location{'5555'} = 'FRDE I HORDALAND';
$borough_number{'5559'} = '1216'; $type{'5559'} = 'P'; $location{'5559'} = 'SVEIO';
$borough_number{'5560'} = '1146'; $type{'5560'} = 'B'; $location{'5560'} = 'NEDSTRAND';
$borough_number{'5561'} = '1145'; $type{'5561'} = 'B'; $location{'5561'} = 'BOKN';
$borough_number{'5563'} = '1146'; $type{'5563'} = 'G'; $location{'5563'} = 'FRRESFJORDEN';
$borough_number{'5565'} = '1146'; $type{'5565'} = 'G'; $location{'5565'} = 'TYSVRVG';
$borough_number{'5566'} = '1146'; $type{'5566'} = 'G'; $location{'5566'} = 'HERVIK';
$borough_number{'5567'} = '1146'; $type{'5567'} = 'B'; $location{'5567'} = 'SKJOLDASTRAUMEN';
$borough_number{'5568'} = '1160'; $type{'5568'} = 'G'; $location{'5568'} = 'VIKEBYGD';
$borough_number{'5570'} = '1146'; $type{'5570'} = 'G'; $location{'5570'} = 'AKSDAL';
$borough_number{'5574'} = '1160'; $type{'5574'} = 'B'; $location{'5574'} = 'SKJOLD';
$borough_number{'5575'} = '1146'; $type{'5575'} = 'P'; $location{'5575'} = 'AKSDAL';
$borough_number{'5576'} = '1160'; $type{'5576'} = 'B'; $location{'5576'} = 'VRE VATS';
$borough_number{'5578'} = '1160'; $type{'5578'} = 'B'; $location{'5578'} = 'NEDRE VATS';
$borough_number{'5580'} = '1160'; $type{'5580'} = 'G'; $location{'5580'} = 'LEN';
$borough_number{'5582'} = '1160'; $type{'5582'} = 'B'; $location{'5582'} = 'LENSVG';
$borough_number{'5583'} = '1160'; $type{'5583'} = 'G'; $location{'5583'} = 'VIKEDAL';
$borough_number{'5584'} = '1160'; $type{'5584'} = 'B'; $location{'5584'} = 'BJOA';
$borough_number{'5585'} = '1160'; $type{'5585'} = 'G'; $location{'5585'} = 'SANDEID';
$borough_number{'5586'} = '1160'; $type{'5586'} = 'P'; $location{'5586'} = 'VIKEDAL';
$borough_number{'5588'} = '1160'; $type{'5588'} = 'P'; $location{'5588'} = 'LEN';
$borough_number{'5589'} = '1160'; $type{'5589'} = 'P'; $location{'5589'} = 'SANDEID';
$borough_number{'5590'} = '1211'; $type{'5590'} = 'G'; $location{'5590'} = 'ETNE';
$borough_number{'5591'} = '1211'; $type{'5591'} = 'P'; $location{'5591'} = 'ETNE';
$borough_number{'5593'} = '1211'; $type{'5593'} = 'G'; $location{'5593'} = 'SKNEVIK';
$borough_number{'5594'} = '1211'; $type{'5594'} = 'P'; $location{'5594'} = 'SKNEVIK';
$borough_number{'5595'} = '1146'; $type{'5595'} = 'P'; $location{'5595'} = 'FRRESFJORDEN';
$borough_number{'5596'} = '1211'; $type{'5596'} = 'G'; $location{'5596'} = 'MARKHUS';
$borough_number{'5598'} = '1211'; $type{'5598'} = 'G'; $location{'5598'} = 'FJRA';
$borough_number{'5600'} = '1238'; $type{'5600'} = 'G'; $location{'5600'} = 'NORHEIMSUND';
$borough_number{'5601'} = '1238'; $type{'5601'} = 'P'; $location{'5601'} = 'NORHEIMSUND';
$borough_number{'5602'} = '1238'; $type{'5602'} = 'P'; $location{'5602'} = 'NORHEIMSUND';
$borough_number{'5604'} = '1238'; $type{'5604'} = 'P'; $location{'5604'} = 'YSTESE';
$borough_number{'5605'} = '1238'; $type{'5605'} = 'P'; $location{'5605'} = 'LVIK';
$borough_number{'5610'} = '1238'; $type{'5610'} = 'G'; $location{'5610'} = 'YSTESE';
$borough_number{'5612'} = '1238'; $type{'5612'} = 'G'; $location{'5612'} = 'STEINST';
$borough_number{'5614'} = '1238'; $type{'5614'} = 'G'; $location{'5614'} = 'LVIK';
$borough_number{'5620'} = '1238'; $type{'5620'} = 'G'; $location{'5620'} = 'TRVIKBYGD';
$borough_number{'5626'} = '1227'; $type{'5626'} = 'G'; $location{'5626'} = 'KYSNESSTRAND';
$borough_number{'5627'} = '1227'; $type{'5627'} = 'G'; $location{'5627'} = 'JONDAL';
$borough_number{'5628'} = '1227'; $type{'5628'} = 'G'; $location{'5628'} = 'HERAND';
$borough_number{'5629'} = '1227'; $type{'5629'} = 'P'; $location{'5629'} = 'JONDAL';
$borough_number{'5630'} = '1238'; $type{'5630'} = 'B'; $location{'5630'} = 'STRANDEBARM';
$borough_number{'5632'} = '1238'; $type{'5632'} = 'B'; $location{'5632'} = 'OMASTRAND';
$borough_number{'5635'} = '1224'; $type{'5635'} = 'B'; $location{'5635'} = 'HATLESTRAND';
$borough_number{'5636'} = '1224'; $type{'5636'} = 'G'; $location{'5636'} = 'VARALDSY';
$borough_number{'5637'} = '1224'; $type{'5637'} = 'G'; $location{'5637'} = 'LVE';
$borough_number{'5640'} = '1241'; $type{'5640'} = 'G'; $location{'5640'} = 'EIKELANDSOSEN';
$borough_number{'5641'} = '1241'; $type{'5641'} = 'B'; $location{'5641'} = 'FUSA';
$borough_number{'5642'} = '1241'; $type{'5642'} = 'G'; $location{'5642'} = 'HOLMEFJORD';
$borough_number{'5643'} = '1241'; $type{'5643'} = 'G'; $location{'5643'} = 'STRANDVIK';
$borough_number{'5645'} = '1241'; $type{'5645'} = 'B'; $location{'5645'} = 'SVAREID';
$borough_number{'5646'} = '1241'; $type{'5646'} = 'G'; $location{'5646'} = 'NORDTVEITGREND';
$borough_number{'5647'} = '1241'; $type{'5647'} = 'G'; $location{'5647'} = 'BALDERSHEIM';
$borough_number{'5649'} = '1241'; $type{'5649'} = 'P'; $location{'5649'} = 'EIKELANDSOSEN';
$borough_number{'5650'} = '1242'; $type{'5650'} = 'B'; $location{'5650'} = 'TYSSE';
$borough_number{'5652'} = '1242'; $type{'5652'} = 'G'; $location{'5652'} = 'RLAND';
$borough_number{'5653'} = '1242'; $type{'5653'} = 'P'; $location{'5653'} = 'RLAND';
$borough_number{'5680'} = '1223'; $type{'5680'} = 'G'; $location{'5680'} = 'TYSNES';
$borough_number{'5682'} = '1223'; $type{'5682'} = 'G'; $location{'5682'} = 'GODYSUND';
$borough_number{'5683'} = '1223'; $type{'5683'} = 'G'; $location{'5683'} = 'REKSTEREN';
$borough_number{'5685'} = '1223'; $type{'5685'} = 'G'; $location{'5685'} = 'UGGDAL';
$borough_number{'5687'} = '1223'; $type{'5687'} = 'G'; $location{'5687'} = 'FLATRKER';
$borough_number{'5690'} = '1223'; $type{'5690'} = 'G'; $location{'5690'} = 'LUNDEGREND';
$borough_number{'5693'} = '1223'; $type{'5693'} = 'G'; $location{'5693'} = 'RBAKKA';
$borough_number{'5694'} = '1223'; $type{'5694'} = 'G'; $location{'5694'} = 'ONARHEIM';
$borough_number{'5695'} = '1223'; $type{'5695'} = 'P'; $location{'5695'} = 'UGGDAL';
$borough_number{'5696'} = '1223'; $type{'5696'} = 'P'; $location{'5696'} = 'TYSNES';
$borough_number{'5700'} = '1235'; $type{'5700'} = 'B'; $location{'5700'} = 'VOSS';
$borough_number{'5701'} = '1235'; $type{'5701'} = 'P'; $location{'5701'} = 'VOSS';
$borough_number{'5702'} = '1235'; $type{'5702'} = 'P'; $location{'5702'} = 'VOSS';
$borough_number{'5703'} = '1235'; $type{'5703'} = 'P'; $location{'5703'} = 'VOSS';
$borough_number{'5707'} = '1235'; $type{'5707'} = 'G'; $location{'5707'} = 'EVANGER';
$borough_number{'5710'} = '1235'; $type{'5710'} = 'B'; $location{'5710'} = 'SKULESTADMO';
$borough_number{'5712'} = '1235'; $type{'5712'} = 'P'; $location{'5712'} = 'VOSSESTRAND';
$borough_number{'5713'} = '1235'; $type{'5713'} = 'G'; $location{'5713'} = 'VOSSESTRAND';
$borough_number{'5715'} = '1235'; $type{'5715'} = 'G'; $location{'5715'} = 'STALHEIM';
$borough_number{'5718'} = '1421'; $type{'5718'} = 'G'; $location{'5718'} = 'MYRDAL';
$borough_number{'5719'} = '1233'; $type{'5719'} = 'B'; $location{'5719'} = 'FINSE';
$borough_number{'5721'} = '1251'; $type{'5721'} = 'P'; $location{'5721'} = 'DALEKVAM';
$borough_number{'5722'} = '1251'; $type{'5722'} = 'G'; $location{'5722'} = 'DALEKVAM';
$borough_number{'5723'} = '1235'; $type{'5723'} = 'G'; $location{'5723'} = 'BOLSTADYRI';
$borough_number{'5724'} = '1251'; $type{'5724'} = 'B'; $location{'5724'} = 'STANGHELLE';
$borough_number{'5725'} = '1251'; $type{'5725'} = 'G'; $location{'5725'} = 'VAKSDAL';
$borough_number{'5726'} = '1251'; $type{'5726'} = 'P'; $location{'5726'} = 'VAKSDAL';
$borough_number{'5727'} = '1251'; $type{'5727'} = 'B'; $location{'5727'} = 'STAMNES';
$borough_number{'5728'} = '1251'; $type{'5728'} = 'G'; $location{'5728'} = 'EIDSLANDET';
$borough_number{'5729'} = '1252'; $type{'5729'} = 'B'; $location{'5729'} = 'MODALEN';
$borough_number{'5730'} = '1233'; $type{'5730'} = 'G'; $location{'5730'} = 'ULVIK';
$borough_number{'5731'} = '1233'; $type{'5731'} = 'P'; $location{'5731'} = 'ULVIK';
$borough_number{'5733'} = '1234'; $type{'5733'} = 'P'; $location{'5733'} = 'GRANVIN';
$borough_number{'5734'} = '1233'; $type{'5734'} = 'G'; $location{'5734'} = 'VALLAVIK';
$borough_number{'5736'} = '1234'; $type{'5736'} = 'G'; $location{'5736'} = 'GRANVIN';
$borough_number{'5741'} = '1421'; $type{'5741'} = 'P'; $location{'5741'} = 'AURLAND';
$borough_number{'5742'} = '1421'; $type{'5742'} = 'P'; $location{'5742'} = 'FLM';
$borough_number{'5743'} = '1421'; $type{'5743'} = 'G'; $location{'5743'} = 'FLM';
$borough_number{'5745'} = '1421'; $type{'5745'} = 'G'; $location{'5745'} = 'AURLAND';
$borough_number{'5746'} = '1421'; $type{'5746'} = 'B'; $location{'5746'} = 'UNDREDAL';
$borough_number{'5747'} = '1421'; $type{'5747'} = 'B'; $location{'5747'} = 'GUDVANGEN';
$borough_number{'5748'} = '1421'; $type{'5748'} = 'G'; $location{'5748'} = 'STYVI';
$borough_number{'5749'} = '1421'; $type{'5749'} = 'G'; $location{'5749'} = 'BAKKA';
$borough_number{'5750'} = '1228'; $type{'5750'} = 'G'; $location{'5750'} = 'ODDA';
$borough_number{'5751'} = '1228'; $type{'5751'} = 'P'; $location{'5751'} = 'ODDA';
$borough_number{'5760'} = '1228'; $type{'5760'} = 'B'; $location{'5760'} = 'RLDAL';
$borough_number{'5763'} = '1228'; $type{'5763'} = 'G'; $location{'5763'} = 'SKARE';
$borough_number{'5770'} = '1228'; $type{'5770'} = 'G'; $location{'5770'} = 'TYSSEDAL';
$borough_number{'5773'} = '1231'; $type{'5773'} = 'G'; $location{'5773'} = 'HOVLAND';
$borough_number{'5776'} = '1231'; $type{'5776'} = 'B'; $location{'5776'} = 'N';
$borough_number{'5777'} = '1231'; $type{'5777'} = 'G'; $location{'5777'} = 'GRIMO';
$borough_number{'5778'} = '1231'; $type{'5778'} = 'G'; $location{'5778'} = 'UTNE';
$borough_number{'5779'} = '1231'; $type{'5779'} = 'P'; $location{'5779'} = 'UTNE';
$borough_number{'5780'} = '1231'; $type{'5780'} = 'G'; $location{'5780'} = 'KINSARVIK';
$borough_number{'5781'} = '1231'; $type{'5781'} = 'G'; $location{'5781'} = 'LOFTHUS';
$borough_number{'5782'} = '1231'; $type{'5782'} = 'P'; $location{'5782'} = 'KINSARVIK';
$borough_number{'5783'} = '1232'; $type{'5783'} = 'G'; $location{'5783'} = 'EIDFJORD';
$borough_number{'5784'} = '1232'; $type{'5784'} = 'G'; $location{'5784'} = 'VRE EIDFJORD';
$borough_number{'5785'} = '1232'; $type{'5785'} = 'G'; $location{'5785'} = 'VRINGSFOSS';
$borough_number{'5786'} = '1232'; $type{'5786'} = 'P'; $location{'5786'} = 'EIDFJORD';
$borough_number{'5787'} = '1231'; $type{'5787'} = 'P'; $location{'5787'} = 'LOFTHUS';
$borough_number{'5788'} = '1231'; $type{'5788'} = 'K'; $location{'5788'} = 'KINSARVIK';
$borough_number{'5803'} = '1201'; $type{'5803'} = 'P'; $location{'5803'} = 'BERGEN';
$borough_number{'5804'} = '1201'; $type{'5804'} = 'P'; $location{'5804'} = 'BERGEN';
$borough_number{'5805'} = '1201'; $type{'5805'} = 'P'; $location{'5805'} = 'BERGEN';
$borough_number{'5806'} = '1201'; $type{'5806'} = 'P'; $location{'5806'} = 'BERGEN';
$borough_number{'5807'} = '1201'; $type{'5807'} = 'P'; $location{'5807'} = 'BERGEN';
$borough_number{'5808'} = '1201'; $type{'5808'} = 'P'; $location{'5808'} = 'BERGEN';
$borough_number{'5809'} = '1201'; $type{'5809'} = 'P'; $location{'5809'} = 'BERGEN';
$borough_number{'5811'} = '1201'; $type{'5811'} = 'P'; $location{'5811'} = 'BERGEN';
$borough_number{'5812'} = '1201'; $type{'5812'} = 'P'; $location{'5812'} = 'BERGEN';
$borough_number{'5815'} = '1201'; $type{'5815'} = 'P'; $location{'5815'} = 'BERGEN';
$borough_number{'5816'} = '1201'; $type{'5816'} = 'P'; $location{'5816'} = 'BERGEN';
$borough_number{'5817'} = '1201'; $type{'5817'} = 'P'; $location{'5817'} = 'BERGEN';
$borough_number{'5818'} = '1201'; $type{'5818'} = 'P'; $location{'5818'} = 'BERGEN';
$borough_number{'5819'} = '1201'; $type{'5819'} = 'P'; $location{'5819'} = 'BERGEN';
$borough_number{'5821'} = '1201'; $type{'5821'} = 'P'; $location{'5821'} = 'BERGEN';
$borough_number{'5822'} = '1201'; $type{'5822'} = 'P'; $location{'5822'} = 'BERGEN';
$borough_number{'5824'} = '1201'; $type{'5824'} = 'P'; $location{'5824'} = 'BERGEN';
$borough_number{'5825'} = '1201'; $type{'5825'} = 'P'; $location{'5825'} = 'BERGEN';
$borough_number{'5828'} = '1201'; $type{'5828'} = 'P'; $location{'5828'} = 'BERGEN';
$borough_number{'5829'} = '1201'; $type{'5829'} = 'P'; $location{'5829'} = 'BERGEN';
$borough_number{'5835'} = '1201'; $type{'5835'} = 'P'; $location{'5835'} = 'BERGEN';
$borough_number{'5836'} = '1201'; $type{'5836'} = 'P'; $location{'5836'} = 'BERGEN';
$borough_number{'5838'} = '1201'; $type{'5838'} = 'P'; $location{'5838'} = 'BERGEN';
$borough_number{'5845'} = '1201'; $type{'5845'} = 'P'; $location{'5845'} = 'BERGEN';
$borough_number{'5847'} = '1201'; $type{'5847'} = 'P'; $location{'5847'} = 'BERGEN';
$borough_number{'5848'} = '1201'; $type{'5848'} = 'P'; $location{'5848'} = 'BERGEN';
$borough_number{'5849'} = '1201'; $type{'5849'} = 'P'; $location{'5849'} = 'BERGEN';
$borough_number{'5851'} = '1201'; $type{'5851'} = 'P'; $location{'5851'} = 'BERGEN';
$borough_number{'5852'} = '1201'; $type{'5852'} = 'P'; $location{'5852'} = 'BERGEN';
$borough_number{'5853'} = '1201'; $type{'5853'} = 'P'; $location{'5853'} = 'BERGEN';
$borough_number{'5854'} = '1201'; $type{'5854'} = 'P'; $location{'5854'} = 'BERGEN';
$borough_number{'5857'} = '1201'; $type{'5857'} = 'P'; $location{'5857'} = 'BERGEN';
$borough_number{'5858'} = '1201'; $type{'5858'} = 'P'; $location{'5858'} = 'BERGEN';
$borough_number{'5859'} = '1201'; $type{'5859'} = 'P'; $location{'5859'} = 'BERGEN';
$borough_number{'5861'} = '1201'; $type{'5861'} = 'P'; $location{'5861'} = 'BERGEN';
$borough_number{'5862'} = '1201'; $type{'5862'} = 'P'; $location{'5862'} = 'BERGEN';
$borough_number{'5863'} = '1201'; $type{'5863'} = 'P'; $location{'5863'} = 'BERGEN';
$borough_number{'5864'} = '1201'; $type{'5864'} = 'P'; $location{'5864'} = 'BERGEN';
$borough_number{'5868'} = '1201'; $type{'5868'} = 'P'; $location{'5868'} = 'BERGEN';
$borough_number{'5869'} = '1201'; $type{'5869'} = 'P'; $location{'5869'} = 'BERGEN';
$borough_number{'5871'} = '1201'; $type{'5871'} = 'P'; $location{'5871'} = 'BERGEN';
$borough_number{'5872'} = '1201'; $type{'5872'} = 'P'; $location{'5872'} = 'BERGEN';
$borough_number{'5873'} = '1201'; $type{'5873'} = 'P'; $location{'5873'} = 'BERGEN';
$borough_number{'5876'} = '1201'; $type{'5876'} = 'P'; $location{'5876'} = 'BERGEN';
$borough_number{'5877'} = '1201'; $type{'5877'} = 'P'; $location{'5877'} = 'BERGEN';
$borough_number{'5878'} = '1201'; $type{'5878'} = 'P'; $location{'5878'} = 'BERGEN';
$borough_number{'5879'} = '1201'; $type{'5879'} = 'P'; $location{'5879'} = 'BERGEN';
$borough_number{'5881'} = '1201'; $type{'5881'} = 'P'; $location{'5881'} = 'BERGEN';
$borough_number{'5882'} = '1201'; $type{'5882'} = 'P'; $location{'5882'} = 'BERGEN';
$borough_number{'5883'} = '1201'; $type{'5883'} = 'P'; $location{'5883'} = 'BERGEN';
$borough_number{'5884'} = '1201'; $type{'5884'} = 'P'; $location{'5884'} = 'BERGEN';
$borough_number{'5886'} = '1201'; $type{'5886'} = 'P'; $location{'5886'} = 'BERGEN';
$borough_number{'5888'} = '1201'; $type{'5888'} = 'P'; $location{'5888'} = 'BERGEN';
$borough_number{'5889'} = '1201'; $type{'5889'} = 'P'; $location{'5889'} = 'BERGEN';
$borough_number{'5892'} = '1201'; $type{'5892'} = 'P'; $location{'5892'} = 'BERGEN';
$borough_number{'5893'} = '1201'; $type{'5893'} = 'P'; $location{'5893'} = 'BERGEN';
$borough_number{'5896'} = '1201'; $type{'5896'} = 'P'; $location{'5896'} = 'BERGEN';
$borough_number{'5899'} = '1201'; $type{'5899'} = 'P'; $location{'5899'} = 'BERGEN';
$borough_number{'5902'} = '1263'; $type{'5902'} = 'P'; $location{'5902'} = 'ISDALST';
$borough_number{'5903'} = '1263'; $type{'5903'} = 'P'; $location{'5903'} = 'ISDALST';
$borough_number{'5904'} = '1263'; $type{'5904'} = 'P'; $location{'5904'} = 'ISDALST';
$borough_number{'5906'} = '1256'; $type{'5906'} = 'P'; $location{'5906'} = 'FREKHAUG';
$borough_number{'5907'} = '1263'; $type{'5907'} = 'P'; $location{'5907'} = 'ALVERSUND';
$borough_number{'5908'} = '1263'; $type{'5908'} = 'P'; $location{'5908'} = 'ISDALST';
$borough_number{'5911'} = '1263'; $type{'5911'} = 'G'; $location{'5911'} = 'ALVERSUND';
$borough_number{'5912'} = '1263'; $type{'5912'} = 'G'; $location{'5912'} = 'SEIM';
$borough_number{'5913'} = '1263'; $type{'5913'} = 'G'; $location{'5913'} = 'EIKANGERVG';
$borough_number{'5914'} = '1263'; $type{'5914'} = 'G'; $location{'5914'} = 'ISDALST';
$borough_number{'5915'} = '1263'; $type{'5915'} = 'G'; $location{'5915'} = 'HJELMS';
$borough_number{'5917'} = '1256'; $type{'5917'} = 'B'; $location{'5917'} = 'ROSSLAND';
$borough_number{'5918'} = '1256'; $type{'5918'} = 'G'; $location{'5918'} = 'FREKHAUG';
$borough_number{'5931'} = '1260'; $type{'5931'} = 'P'; $location{'5931'} = 'MANGER';
$borough_number{'5936'} = '1260'; $type{'5936'} = 'G'; $location{'5936'} = 'MANGER';
$borough_number{'5937'} = '1260'; $type{'5937'} = 'B'; $location{'5937'} = 'BVGEN';
$borough_number{'5938'} = '1260'; $type{'5938'} = 'B'; $location{'5938'} = 'SBVGEN';
$borough_number{'5939'} = '1260'; $type{'5939'} = 'G'; $location{'5939'} = 'SLETTA';
$borough_number{'5941'} = '1264'; $type{'5941'} = 'P'; $location{'5941'} = 'AUSTRHEIM';
$borough_number{'5943'} = '1264'; $type{'5943'} = 'G'; $location{'5943'} = 'AUSTRHEIM';
$borough_number{'5947'} = '1265'; $type{'5947'} = 'G'; $location{'5947'} = 'FEDJE';
$borough_number{'5948'} = '1265'; $type{'5948'} = 'P'; $location{'5948'} = 'FEDJE';
$borough_number{'5951'} = '1263'; $type{'5951'} = 'P'; $location{'5951'} = 'LINDS';
$borough_number{'5953'} = '1264'; $type{'5953'} = 'B'; $location{'5953'} = 'FONNES';
$borough_number{'5954'} = '1263'; $type{'5954'} = 'G'; $location{'5954'} = 'MONGSTAD';
$borough_number{'5955'} = '1263'; $type{'5955'} = 'G'; $location{'5955'} = 'LINDS';
$borough_number{'5956'} = '1263'; $type{'5956'} = 'G'; $location{'5956'} = 'VGSEIDET';
$borough_number{'5957'} = '1263'; $type{'5957'} = 'B'; $location{'5957'} = 'MYKING';
$borough_number{'5960'} = '1411'; $type{'5960'} = 'B'; $location{'5960'} = 'DALSYRA';
$borough_number{'5961'} = '1411'; $type{'5961'} = 'B'; $location{'5961'} = 'BREKKE';
$borough_number{'5962'} = '1416'; $type{'5962'} = 'B'; $location{'5962'} = 'BJORDAL';
$borough_number{'5966'} = '1411'; $type{'5966'} = 'G'; $location{'5966'} = 'EIVINDVIK';
$borough_number{'5967'} = '1411'; $type{'5967'} = 'P'; $location{'5967'} = 'EIVINDVIK';
$borough_number{'5970'} = '1411'; $type{'5970'} = 'G'; $location{'5970'} = 'BYRKNESY';
$borough_number{'5977'} = '1411'; $type{'5977'} = 'G'; $location{'5977'} = 'NNELAND';
$borough_number{'5978'} = '1411'; $type{'5978'} = 'G'; $location{'5978'} = 'MJMNA';
$borough_number{'5979'} = '1411'; $type{'5979'} = 'P'; $location{'5979'} = 'BYRKNESY';
$borough_number{'5981'} = '1266'; $type{'5981'} = 'G'; $location{'5981'} = 'MASFJORDNES';
$borough_number{'5983'} = '1266'; $type{'5983'} = 'B'; $location{'5983'} = 'HAUGSVR';
$borough_number{'5984'} = '1266'; $type{'5984'} = 'G'; $location{'5984'} = 'MATREDAL';
$borough_number{'5986'} = '1266'; $type{'5986'} = 'G'; $location{'5986'} = 'HOSTELAND';
$borough_number{'5987'} = '1266'; $type{'5987'} = 'P'; $location{'5987'} = 'HOSTELAND';
$borough_number{'5991'} = '1263'; $type{'5991'} = 'P'; $location{'5991'} = 'OSTEREIDET';
$borough_number{'5993'} = '1263'; $type{'5993'} = 'G'; $location{'5993'} = 'OSTEREIDET';
$borough_number{'5994'} = '1263'; $type{'5994'} = 'G'; $location{'5994'} = 'VIKANES';
$borough_number{'6001'} = '1504'; $type{'6001'} = 'P'; $location{'6001'} = 'LESUND';
$borough_number{'6002'} = '1504'; $type{'6002'} = 'G'; $location{'6002'} = 'LESUND';
$borough_number{'6003'} = '1504'; $type{'6003'} = 'G'; $location{'6003'} = 'LESUND';
$borough_number{'6004'} = '1504'; $type{'6004'} = 'G'; $location{'6004'} = 'LESUND';
$borough_number{'6005'} = '1504'; $type{'6005'} = 'G'; $location{'6005'} = 'LESUND';
$borough_number{'6006'} = '1504'; $type{'6006'} = 'G'; $location{'6006'} = 'LESUND';
$borough_number{'6007'} = '1504'; $type{'6007'} = 'G'; $location{'6007'} = 'LESUND';
$borough_number{'6008'} = '1504'; $type{'6008'} = 'G'; $location{'6008'} = 'LESUND';
$borough_number{'6009'} = '1504'; $type{'6009'} = 'G'; $location{'6009'} = 'LESUND';
$borough_number{'6010'} = '1504'; $type{'6010'} = 'G'; $location{'6010'} = 'LESUND';
$borough_number{'6011'} = '1504'; $type{'6011'} = 'G'; $location{'6011'} = 'LESUND';
$borough_number{'6012'} = '1504'; $type{'6012'} = 'G'; $location{'6012'} = 'LESUND';
$borough_number{'6013'} = '1504'; $type{'6013'} = 'G'; $location{'6013'} = 'LESUND';
$borough_number{'6014'} = '1504'; $type{'6014'} = 'G'; $location{'6014'} = 'LESUND';
$borough_number{'6015'} = '1504'; $type{'6015'} = 'G'; $location{'6015'} = 'LESUND';
$borough_number{'6016'} = '1504'; $type{'6016'} = 'G'; $location{'6016'} = 'LESUND';
$borough_number{'6017'} = '1504'; $type{'6017'} = 'G'; $location{'6017'} = 'LESUND';
$borough_number{'6018'} = '1504'; $type{'6018'} = 'G'; $location{'6018'} = 'LESUND';
$borough_number{'6019'} = '1504'; $type{'6019'} = 'G'; $location{'6019'} = 'LESUND';
$borough_number{'6020'} = '1504'; $type{'6020'} = 'G'; $location{'6020'} = 'LESUND';
$borough_number{'6021'} = '1504'; $type{'6021'} = 'P'; $location{'6021'} = 'LESUND';
$borough_number{'6022'} = '1504'; $type{'6022'} = 'P'; $location{'6022'} = 'LESUND';
$borough_number{'6023'} = '1504'; $type{'6023'} = 'P'; $location{'6023'} = 'LESUND';
$borough_number{'6024'} = '1504'; $type{'6024'} = 'P'; $location{'6024'} = 'LESUND';
$borough_number{'6025'} = '1504'; $type{'6025'} = 'S'; $location{'6025'} = 'LESUND';
$borough_number{'6026'} = '1504'; $type{'6026'} = 'K'; $location{'6026'} = 'LESUND';
$borough_number{'6028'} = '1504'; $type{'6028'} = 'P'; $location{'6028'} = 'LESUND';
$borough_number{'6030'} = '1531'; $type{'6030'} = 'G'; $location{'6030'} = 'LANGEVG';
$borough_number{'6035'} = '1531'; $type{'6035'} = 'G'; $location{'6035'} = 'FISKARSTRAND';
$borough_number{'6036'} = '1531'; $type{'6036'} = 'G'; $location{'6036'} = 'MAUSEIDVG';
$borough_number{'6037'} = '1531'; $type{'6037'} = 'B'; $location{'6037'} = 'EIDSNES';
$borough_number{'6038'} = '1531'; $type{'6038'} = 'P'; $location{'6038'} = 'FISKARSTRAND';
$borough_number{'6039'} = '1531'; $type{'6039'} = 'P'; $location{'6039'} = 'LANGEVG';
$borough_number{'6040'} = '1532'; $type{'6040'} = 'G'; $location{'6040'} = 'VIGRA';
$borough_number{'6045'} = '1504'; $type{'6045'} = 'P'; $location{'6045'} = 'LESUND';
$borough_number{'6046'} = '1504'; $type{'6046'} = 'P'; $location{'6046'} = 'LESUND';
$borough_number{'6050'} = '1532'; $type{'6050'} = 'G'; $location{'6050'} = 'VALDERYA';
$borough_number{'6051'} = '1532'; $type{'6051'} = 'P'; $location{'6051'} = 'VALDERYA';
$borough_number{'6052'} = '1532'; $type{'6052'} = 'G'; $location{'6052'} = 'GISKE';
$borough_number{'6055'} = '1532'; $type{'6055'} = 'B'; $location{'6055'} = 'GODYA';
$borough_number{'6057'} = '1504'; $type{'6057'} = 'G'; $location{'6057'} = 'ELLINGSY';
$borough_number{'6058'} = '1532'; $type{'6058'} = 'P'; $location{'6058'} = 'VALDERYA';
$borough_number{'6059'} = '1532'; $type{'6059'} = 'P'; $location{'6059'} = 'VIGRA';
$borough_number{'6060'} = '1517'; $type{'6060'} = 'G'; $location{'6060'} = 'HAREID';
$borough_number{'6062'} = '1517'; $type{'6062'} = 'G'; $location{'6062'} = 'BRANDAL';
$borough_number{'6063'} = '1517'; $type{'6063'} = 'B'; $location{'6063'} = 'HJRUNGAVG';
$borough_number{'6064'} = '1516'; $type{'6064'} = 'B'; $location{'6064'} = 'HADDAL';
$borough_number{'6065'} = '1516'; $type{'6065'} = 'G'; $location{'6065'} = 'ULSTEINVIK';
$borough_number{'6067'} = '1516'; $type{'6067'} = 'P'; $location{'6067'} = 'ULSTEINVIK';
$borough_number{'6069'} = '1517'; $type{'6069'} = 'P'; $location{'6069'} = 'HAREID';
$borough_number{'6070'} = '1515'; $type{'6070'} = 'G'; $location{'6070'} = 'TJRVG';
$borough_number{'6076'} = '1515'; $type{'6076'} = 'B'; $location{'6076'} = 'MOLDTUSTRANDA';
$borough_number{'6080'} = '1515'; $type{'6080'} = 'B'; $location{'6080'} = 'GURSKY';
$borough_number{'6082'} = '1514'; $type{'6082'} = 'G'; $location{'6082'} = 'GURSKEN';
$borough_number{'6083'} = '1514'; $type{'6083'} = 'B'; $location{'6083'} = 'GJERDSVIKA';
$borough_number{'6084'} = '1514'; $type{'6084'} = 'G'; $location{'6084'} = 'LARSNES';
$borough_number{'6085'} = '1514'; $type{'6085'} = 'P'; $location{'6085'} = 'LARSNES';
$borough_number{'6087'} = '1514'; $type{'6087'} = 'B'; $location{'6087'} = 'KVAMSY';
$borough_number{'6089'} = '1514'; $type{'6089'} = 'B'; $location{'6089'} = 'SANDSHAMN';
$borough_number{'6090'} = '1515'; $type{'6090'} = 'G'; $location{'6090'} = 'FOSNAVG';
$borough_number{'6092'} = '1515'; $type{'6092'} = 'G'; $location{'6092'} = 'EGGESBNES';
$borough_number{'6094'} = '1515'; $type{'6094'} = 'G'; $location{'6094'} = 'LEINY';
$borough_number{'6095'} = '1515'; $type{'6095'} = 'G'; $location{'6095'} = 'BLANDET';
$borough_number{'6096'} = '1515'; $type{'6096'} = 'G'; $location{'6096'} = 'RUNDE';
$borough_number{'6098'} = '1515'; $type{'6098'} = 'G'; $location{'6098'} = 'NERLANDSY';
$borough_number{'6099'} = '1515'; $type{'6099'} = 'P'; $location{'6099'} = 'FOSNAVG';
$borough_number{'6100'} = '1519'; $type{'6100'} = 'G'; $location{'6100'} = 'VOLDA';
$borough_number{'6101'} = '1519'; $type{'6101'} = 'P'; $location{'6101'} = 'VOLDA';
$borough_number{'6110'} = '1519'; $type{'6110'} = 'G'; $location{'6110'} = 'AUSTEFJORDEN';
$borough_number{'6120'} = '1519'; $type{'6120'} = 'G'; $location{'6120'} = 'FOLKESTAD';
$borough_number{'6133'} = '1519'; $type{'6133'} = 'B'; $location{'6133'} = 'LAUVSTAD';
$borough_number{'6139'} = '1511'; $type{'6139'} = 'P'; $location{'6139'} = 'FISKBYGD';
$borough_number{'6140'} = '1511'; $type{'6140'} = 'B'; $location{'6140'} = 'SYVDE';
$borough_number{'6141'} = '1511'; $type{'6141'} = 'G'; $location{'6141'} = 'ROVDE';
$borough_number{'6142'} = '1511'; $type{'6142'} = 'G'; $location{'6142'} = 'EIDS';
$borough_number{'6143'} = '1511'; $type{'6143'} = 'G'; $location{'6143'} = 'FISKBYGD';
$borough_number{'6144'} = '1511'; $type{'6144'} = 'G'; $location{'6144'} = 'SYLTE';
$borough_number{'6146'} = '1511'; $type{'6146'} = 'B'; $location{'6146'} = 'HEIM';
$borough_number{'6149'} = '1511'; $type{'6149'} = 'G'; $location{'6149'} = 'RAM';
$borough_number{'6150'} = '1520'; $type{'6150'} = 'G'; $location{'6150'} = 'RSTA';
$borough_number{'6151'} = '1520'; $type{'6151'} = 'P'; $location{'6151'} = 'RSTA';
$borough_number{'6160'} = '1520'; $type{'6160'} = 'G'; $location{'6160'} = 'HOVDEBYGDA';
$borough_number{'6161'} = '1520'; $type{'6161'} = 'P'; $location{'6161'} = 'HOVDEBYGDA';
$borough_number{'6165'} = '1520'; $type{'6165'} = 'G'; $location{'6165'} = 'SB';
$borough_number{'6166'} = '1520'; $type{'6166'} = 'P'; $location{'6166'} = 'SB';
$borough_number{'6170'} = '1520'; $type{'6170'} = 'B'; $location{'6170'} = 'VARTDAL';
$borough_number{'6174'} = '1520'; $type{'6174'} = 'G'; $location{'6174'} = 'BARSTADVIK';
$borough_number{'6183'} = '1520'; $type{'6183'} = 'G'; $location{'6183'} = 'TRANDAL';
$borough_number{'6184'} = '1520'; $type{'6184'} = 'G'; $location{'6184'} = 'STORESTANDAL';
$borough_number{'6190'} = '1520'; $type{'6190'} = 'G'; $location{'6190'} = 'BJRKE';
$borough_number{'6196'} = '1520'; $type{'6196'} = 'G'; $location{'6196'} = 'NORANGSFJORDEN';
$borough_number{'6200'} = '1525'; $type{'6200'} = 'G'; $location{'6200'} = 'STRANDA';
$borough_number{'6201'} = '1525'; $type{'6201'} = 'P'; $location{'6201'} = 'STRANDA';
$borough_number{'6210'} = '1524'; $type{'6210'} = 'B'; $location{'6210'} = 'VALLDAL';
$borough_number{'6212'} = '1525'; $type{'6212'} = 'G'; $location{'6212'} = 'LIABYGDA';
$borough_number{'6213'} = '1524'; $type{'6213'} = 'G'; $location{'6213'} = 'TAFJORD';
$borough_number{'6214'} = '1524'; $type{'6214'} = 'G'; $location{'6214'} = 'NORDDAL';
$borough_number{'6215'} = '1524'; $type{'6215'} = 'B'; $location{'6215'} = 'EIDSDAL';
$borough_number{'6216'} = '1525'; $type{'6216'} = 'B'; $location{'6216'} = 'GEIRANGER';
$borough_number{'6218'} = '1525'; $type{'6218'} = 'B'; $location{'6218'} = 'HELLESYLT';
$borough_number{'6220'} = '1528'; $type{'6220'} = 'G'; $location{'6220'} = 'STRAUMGJERDE';
$borough_number{'6222'} = '1528'; $type{'6222'} = 'B'; $location{'6222'} = 'IKORNNES';
$borough_number{'6224'} = '1528'; $type{'6224'} = 'G'; $location{'6224'} = 'HUNDEIDVIK';
$borough_number{'6230'} = '1528'; $type{'6230'} = 'G'; $location{'6230'} = 'SYKKYLVEN';
$borough_number{'6238'} = '1528'; $type{'6238'} = 'P'; $location{'6238'} = 'STRAUMGJERDE';
$borough_number{'6239'} = '1528'; $type{'6239'} = 'P'; $location{'6239'} = 'SYKKYLVEN';
$borough_number{'6240'} = '1523'; $type{'6240'} = 'G'; $location{'6240'} = 'RSKOG';
$borough_number{'6249'} = '1523'; $type{'6249'} = 'P'; $location{'6249'} = 'RSKOG';
$borough_number{'6250'} = '1526'; $type{'6250'} = 'G'; $location{'6250'} = 'STORDAL';
$borough_number{'6259'} = '1526'; $type{'6259'} = 'P'; $location{'6259'} = 'STORDAL';
$borough_number{'6260'} = '1529'; $type{'6260'} = 'G'; $location{'6260'} = 'SKODJE';
$borough_number{'6263'} = '1529'; $type{'6263'} = 'P'; $location{'6263'} = 'SKODJE';
$borough_number{'6264'} = '1534'; $type{'6264'} = 'G'; $location{'6264'} = 'TENNFJORD';
$borough_number{'6265'} = '1534'; $type{'6265'} = 'G'; $location{'6265'} = 'VATNE';
$borough_number{'6270'} = '1534'; $type{'6270'} = 'G'; $location{'6270'} = 'BRATTVG';
$borough_number{'6272'} = '1534'; $type{'6272'} = 'G'; $location{'6272'} = 'HILDRE';
$borough_number{'6280'} = '1534'; $type{'6280'} = 'G'; $location{'6280'} = 'SVIK';
$borough_number{'6281'} = '1534'; $type{'6281'} = 'P'; $location{'6281'} = 'SVIK';
$borough_number{'6282'} = '1534'; $type{'6282'} = 'P'; $location{'6282'} = 'BRATTVG';
$borough_number{'6283'} = '1534'; $type{'6283'} = 'P'; $location{'6283'} = 'VATNE';
$borough_number{'6285'} = '1534'; $type{'6285'} = 'G'; $location{'6285'} = 'STOREKALVY';
$borough_number{'6290'} = '1534'; $type{'6290'} = 'B'; $location{'6290'} = 'HARAMSY';
$borough_number{'6292'} = '1534'; $type{'6292'} = 'G'; $location{'6292'} = 'KJERSTAD';
$borough_number{'6293'} = '1534'; $type{'6293'} = 'G'; $location{'6293'} = 'LONGVA';
$borough_number{'6294'} = '1534'; $type{'6294'} = 'G'; $location{'6294'} = 'FJRTOFT';
$borough_number{'6300'} = '1539'; $type{'6300'} = 'G'; $location{'6300'} = 'NDALSNES';
$borough_number{'6301'} = '1539'; $type{'6301'} = 'P'; $location{'6301'} = 'NDALSNES';
$borough_number{'6310'} = '1539'; $type{'6310'} = 'G'; $location{'6310'} = 'VEBLUNGSNES';
$borough_number{'6315'} = '1539'; $type{'6315'} = 'G'; $location{'6315'} = 'INNFJORDEN';
$borough_number{'6320'} = '1539'; $type{'6320'} = 'G'; $location{'6320'} = 'ISFJORDEN';
$borough_number{'6330'} = '1539'; $type{'6330'} = 'B'; $location{'6330'} = 'VERMA';
$borough_number{'6339'} = '1539'; $type{'6339'} = 'P'; $location{'6339'} = 'ISFJORDEN';
$borough_number{'6350'} = '1539'; $type{'6350'} = 'G'; $location{'6350'} = 'EIDSBYGDA';
$borough_number{'6360'} = '1539'; $type{'6360'} = 'B'; $location{'6360'} = 'FARNES';
$borough_number{'6363'} = '1539'; $type{'6363'} = 'G'; $location{'6363'} = 'MITTET';
$borough_number{'6364'} = '1543'; $type{'6364'} = 'B'; $location{'6364'} = 'VISTDAL';
$borough_number{'6386'} = '1539'; $type{'6386'} = 'B'; $location{'6386'} = 'MNDALEN';
$borough_number{'6387'} = '1539'; $type{'6387'} = 'B'; $location{'6387'} = 'VGSTRANDA';
$borough_number{'6390'} = '1535'; $type{'6390'} = 'G'; $location{'6390'} = 'VESTNES';
$borough_number{'6391'} = '1535'; $type{'6391'} = 'G'; $location{'6391'} = 'TRESFJORD';
$borough_number{'6392'} = '1535'; $type{'6392'} = 'G'; $location{'6392'} = 'VIKEBUKT';
$borough_number{'6393'} = '1535'; $type{'6393'} = 'G'; $location{'6393'} = 'TOMREFJORD';
$borough_number{'6394'} = '1535'; $type{'6394'} = 'B'; $location{'6394'} = 'FIKSDAL';
$borough_number{'6395'} = '1535'; $type{'6395'} = 'G'; $location{'6395'} = 'REKDAL';
$borough_number{'6396'} = '1535'; $type{'6396'} = 'P'; $location{'6396'} = 'VIKEBUKT';
$borough_number{'6397'} = '1535'; $type{'6397'} = 'P'; $location{'6397'} = 'TRESFJORD';
$borough_number{'6398'} = '1535'; $type{'6398'} = 'P'; $location{'6398'} = 'TOMREFJORD';
$borough_number{'6399'} = '1535'; $type{'6399'} = 'P'; $location{'6399'} = 'VESTNES';
$borough_number{'6401'} = '1502'; $type{'6401'} = 'P'; $location{'6401'} = 'MOLDE';
$borough_number{'6402'} = '1502'; $type{'6402'} = 'P'; $location{'6402'} = 'MOLDE';
$borough_number{'6403'} = '1502'; $type{'6403'} = 'P'; $location{'6403'} = 'MOLDE';
$borough_number{'6404'} = '1502'; $type{'6404'} = 'K'; $location{'6404'} = 'MOLDE';
$borough_number{'6405'} = '1502'; $type{'6405'} = 'S'; $location{'6405'} = 'MOLDE';
$borough_number{'6407'} = '1502'; $type{'6407'} = 'K'; $location{'6407'} = 'MOLDE';
$borough_number{'6408'} = '1548'; $type{'6408'} = 'G'; $location{'6408'} = 'AUREOSEN';
$borough_number{'6409'} = '1547'; $type{'6409'} = 'G'; $location{'6409'} = 'MOLDE';
$borough_number{'6410'} = '1502'; $type{'6410'} = 'P'; $location{'6410'} = 'MOLDE';
$borough_number{'6411'} = '1502'; $type{'6411'} = 'G'; $location{'6411'} = 'MOLDE';
$borough_number{'6412'} = '1502'; $type{'6412'} = 'G'; $location{'6412'} = 'MOLDE';
$borough_number{'6413'} = '1502'; $type{'6413'} = 'G'; $location{'6413'} = 'MOLDE';
$borough_number{'6414'} = '1502'; $type{'6414'} = 'G'; $location{'6414'} = 'MOLDE';
$borough_number{'6415'} = '1502'; $type{'6415'} = 'G'; $location{'6415'} = 'MOLDE';
$borough_number{'6416'} = '1502'; $type{'6416'} = 'G'; $location{'6416'} = 'MOLDE';
$borough_number{'6418'} = '1502'; $type{'6418'} = 'G'; $location{'6418'} = 'SEKKEN';
$borough_number{'6419'} = '1502'; $type{'6419'} = 'G'; $location{'6419'} = 'MOLDE';
$borough_number{'6421'} = '1502'; $type{'6421'} = 'G'; $location{'6421'} = 'MOLDE';
$borough_number{'6422'} = '1502'; $type{'6422'} = 'G'; $location{'6422'} = 'MOLDE';
$borough_number{'6425'} = '1502'; $type{'6425'} = 'G'; $location{'6425'} = 'MOLDE';
$borough_number{'6429'} = '1502'; $type{'6429'} = 'G'; $location{'6429'} = 'MOLDE';
$borough_number{'6430'} = '1548'; $type{'6430'} = 'B'; $location{'6430'} = 'BUD';
$borough_number{'6433'} = '1548'; $type{'6433'} = 'B'; $location{'6433'} = 'HUSTAD';
$borough_number{'6440'} = '1548'; $type{'6440'} = 'G'; $location{'6440'} = 'ELNESVGEN';
$borough_number{'6443'} = '1548'; $type{'6443'} = 'G'; $location{'6443'} = 'TORNES I ROMSDAL';
$borough_number{'6444'} = '1548'; $type{'6444'} = 'G'; $location{'6444'} = 'FARSTAD';
$borough_number{'6445'} = '1548'; $type{'6445'} = 'G'; $location{'6445'} = 'MALMEFJORDEN';
$borough_number{'6447'} = '1548'; $type{'6447'} = 'P'; $location{'6447'} = 'ELNESVGEN';
$borough_number{'6450'} = '1502'; $type{'6450'} = 'G'; $location{'6450'} = 'HJELSET';
$borough_number{'6453'} = '1502'; $type{'6453'} = 'B'; $location{'6453'} = 'KLEIVE';
$borough_number{'6454'} = '1502'; $type{'6454'} = 'P'; $location{'6454'} = 'HJELSET';
$borough_number{'6455'} = '1502'; $type{'6455'} = 'G'; $location{'6455'} = 'KORTGARDEN';
$borough_number{'6456'} = '1502'; $type{'6456'} = 'B'; $location{'6456'} = 'SKLA';
$borough_number{'6457'} = '1502'; $type{'6457'} = 'G'; $location{'6457'} = 'BOLSYA';
$borough_number{'6460'} = '1543'; $type{'6460'} = 'B'; $location{'6460'} = 'EIDSVG I ROMSDAL';
$borough_number{'6462'} = '1543'; $type{'6462'} = 'G'; $location{'6462'} = 'RAUDSAND';
$borough_number{'6470'} = '1543'; $type{'6470'} = 'B'; $location{'6470'} = 'ERESFJORD';
$borough_number{'6472'} = '1543'; $type{'6472'} = 'B'; $location{'6472'} = 'EIKESDAL';
$borough_number{'6475'} = '1545'; $type{'6475'} = 'G'; $location{'6475'} = 'MIDSUND';
$borough_number{'6476'} = '1545'; $type{'6476'} = 'P'; $location{'6476'} = 'MIDSUND';
$borough_number{'6480'} = '1547'; $type{'6480'} = 'G'; $location{'6480'} = 'AUKRA';
$borough_number{'6481'} = '1547'; $type{'6481'} = 'P'; $location{'6481'} = 'AUKRA';
$borough_number{'6483'} = '1546'; $type{'6483'} = 'B'; $location{'6483'} = 'ONA';
$borough_number{'6484'} = '1546'; $type{'6484'} = 'G'; $location{'6484'} = 'SANDY';
$borough_number{'6486'} = '1546'; $type{'6486'} = 'B'; $location{'6486'} = 'ORTEN';
$borough_number{'6487'} = '1546'; $type{'6487'} = 'B'; $location{'6487'} = 'HARY';
$borough_number{'6488'} = '1546'; $type{'6488'} = 'G'; $location{'6488'} = 'MYKLEBOST';
$borough_number{'6490'} = '1551'; $type{'6490'} = 'G'; $location{'6490'} = 'EIDE';
$borough_number{'6493'} = '1551'; $type{'6493'} = 'G'; $location{'6493'} = 'LYNGSTAD';
$borough_number{'6494'} = '1551'; $type{'6494'} = 'G'; $location{'6494'} = 'VEVANG';
$borough_number{'6499'} = '1551'; $type{'6499'} = 'P'; $location{'6499'} = 'EIDE';
$borough_number{'6501'} = '1503'; $type{'6501'} = 'P'; $location{'6501'} = 'KRISTIANSUND N';
$borough_number{'6502'} = '1503'; $type{'6502'} = 'P'; $location{'6502'} = 'KRISTIANSUND N';
$borough_number{'6503'} = '1503'; $type{'6503'} = 'P'; $location{'6503'} = 'KRISTIANSUND N';
$borough_number{'6504'} = '1503'; $type{'6504'} = 'S'; $location{'6504'} = 'KRISTIANSUND N';
$borough_number{'6506'} = '1503'; $type{'6506'} = 'P'; $location{'6506'} = 'KRISTIANSUND N';
$borough_number{'6507'} = '1503'; $type{'6507'} = 'G'; $location{'6507'} = 'KRISTIANSUND N';
$borough_number{'6508'} = '1503'; $type{'6508'} = 'G'; $location{'6508'} = 'KRISTIANSUND N';
$borough_number{'6509'} = '1503'; $type{'6509'} = 'G'; $location{'6509'} = 'KRISTIANSUND N';
$borough_number{'6510'} = '1503'; $type{'6510'} = 'G'; $location{'6510'} = 'KRISTIANSUND N';
$borough_number{'6511'} = '1503'; $type{'6511'} = 'G'; $location{'6511'} = 'KRISTIANSUND N';
$borough_number{'6512'} = '1503'; $type{'6512'} = 'G'; $location{'6512'} = 'KRISTIANSUND N';
$borough_number{'6514'} = '1503'; $type{'6514'} = 'G'; $location{'6514'} = 'KRISTIANSUND N';
$borough_number{'6515'} = '1503'; $type{'6515'} = 'G'; $location{'6515'} = 'KRISTIANSUND N';
$borough_number{'6516'} = '1503'; $type{'6516'} = 'G'; $location{'6516'} = 'KRISTIANSUND N';
$borough_number{'6517'} = '1503'; $type{'6517'} = 'G'; $location{'6517'} = 'KRISTIANSUND N';
$borough_number{'6518'} = '1503'; $type{'6518'} = 'G'; $location{'6518'} = 'KRISTIANSUND N';
$borough_number{'6520'} = '1556'; $type{'6520'} = 'B'; $location{'6520'} = 'FREI';
$borough_number{'6523'} = '1556'; $type{'6523'} = 'B'; $location{'6523'} = 'FREI';
$borough_number{'6529'} = '1556'; $type{'6529'} = 'P'; $location{'6529'} = 'FREI';
$borough_number{'6530'} = '1554'; $type{'6530'} = 'B'; $location{'6530'} = 'AVERY';
$borough_number{'6538'} = '1554'; $type{'6538'} = 'P'; $location{'6538'} = 'AVERY';
$borough_number{'6539'} = '1554'; $type{'6539'} = 'P'; $location{'6539'} = 'AVERY';
$borough_number{'6570'} = '1573'; $type{'6570'} = 'G'; $location{'6570'} = 'SMLA';
$borough_number{'6571'} = '1573'; $type{'6571'} = 'P'; $location{'6571'} = 'SMLA';
$borough_number{'6590'} = '1576'; $type{'6590'} = 'B'; $location{'6590'} = 'TUSTNA';
$borough_number{'6600'} = '1563'; $type{'6600'} = 'G'; $location{'6600'} = 'SUNNDALSRA';
$borough_number{'6601'} = '1563'; $type{'6601'} = 'P'; $location{'6601'} = 'SUNNDALSRA';
$borough_number{'6610'} = '1563'; $type{'6610'} = 'G'; $location{'6610'} = 'KSENDAL';
$borough_number{'6611'} = '1563'; $type{'6611'} = 'G'; $location{'6611'} = 'FURUGRENDA';
$borough_number{'6612'} = '1563'; $type{'6612'} = 'G'; $location{'6612'} = 'GRA';
$borough_number{'6613'} = '1563'; $type{'6613'} = 'B'; $location{'6613'} = 'GJRA';
$borough_number{'6620'} = '1563'; $type{'6620'} = 'B'; $location{'6620'} = 'LVUNDEID';
$borough_number{'6622'} = '1563'; $type{'6622'} = 'B'; $location{'6622'} = 'LVUNDFJORD';
$borough_number{'6628'} = '1560'; $type{'6628'} = 'B'; $location{'6628'} = 'MEISINGSET';
$borough_number{'6629'} = '1560'; $type{'6629'} = 'G'; $location{'6629'} = 'TORJULVGEN';
$borough_number{'6630'} = '1560'; $type{'6630'} = 'B'; $location{'6630'} = 'TINGVOLL';
$borough_number{'6631'} = '1557'; $type{'6631'} = 'B'; $location{'6631'} = 'BATNFJORDSRA';
$borough_number{'6633'} = '1557'; $type{'6633'} = 'G'; $location{'6633'} = 'GJEMNES';
$borough_number{'6636'} = '1557'; $type{'6636'} = 'G'; $location{'6636'} = 'ANGVIK';
$borough_number{'6637'} = '1557'; $type{'6637'} = 'G'; $location{'6637'} = 'FLEMMA';
$borough_number{'6638'} = '1557'; $type{'6638'} = 'G'; $location{'6638'} = 'OSMARKA';
$borough_number{'6639'} = '1557'; $type{'6639'} = 'B'; $location{'6639'} = 'TORVIKBUKT';
$borough_number{'6640'} = '1566'; $type{'6640'} = 'G'; $location{'6640'} = 'KVANNE';
$borough_number{'6642'} = '1566'; $type{'6642'} = 'G'; $location{'6642'} = 'STANGVIK';
$borough_number{'6643'} = '1566'; $type{'6643'} = 'G'; $location{'6643'} = 'BFJORDEN';
$borough_number{'6644'} = '1566'; $type{'6644'} = 'B'; $location{'6644'} = 'BVERFJORD';
$borough_number{'6645'} = '1566'; $type{'6645'} = 'B'; $location{'6645'} = 'TODALEN';
$borough_number{'6650'} = '1566'; $type{'6650'} = 'G'; $location{'6650'} = 'SURNADAL';
$borough_number{'6652'} = '1566'; $type{'6652'} = 'G'; $location{'6652'} = 'SURNA';
$borough_number{'6653'} = '1566'; $type{'6653'} = 'G'; $location{'6653'} = 'VRE SURNADAL';
$borough_number{'6655'} = '1566'; $type{'6655'} = 'G'; $location{'6655'} = 'VINDLA';
$borough_number{'6656'} = '1566'; $type{'6656'} = 'P'; $location{'6656'} = 'SURNADAL';
$borough_number{'6657'} = '1567'; $type{'6657'} = 'G'; $location{'6657'} = 'RINDAL';
$borough_number{'6658'} = '1567'; $type{'6658'} = 'G'; $location{'6658'} = 'RINDALSSKOGEN';
$borough_number{'6659'} = '1567'; $type{'6659'} = 'P'; $location{'6659'} = 'RINDAL';
$borough_number{'6670'} = '1560'; $type{'6670'} = 'B'; $location{'6670'} = 'YDEGARD';
$borough_number{'6674'} = '1560'; $type{'6674'} = 'G'; $location{'6674'} = 'KVISVIK';
$borough_number{'6680'} = '1571'; $type{'6680'} = 'G'; $location{'6680'} = 'HALSANAUSTAN';
$borough_number{'6683'} = '1571'; $type{'6683'} = 'G'; $location{'6683'} = 'VGLAND';
$borough_number{'6686'} = '1571'; $type{'6686'} = 'G'; $location{'6686'} = 'VALSYBOTN';
$borough_number{'6687'} = '1571'; $type{'6687'} = 'G'; $location{'6687'} = 'VALSYFJORD';
$borough_number{'6688'} = '1571'; $type{'6688'} = 'P'; $location{'6688'} = 'VGLAND';
$borough_number{'6689'} = '1576'; $type{'6689'} = 'P'; $location{'6689'} = 'AURE';
$borough_number{'6690'} = '1576'; $type{'6690'} = 'G'; $location{'6690'} = 'AURE';
$borough_number{'6693'} = '1576'; $type{'6693'} = 'G'; $location{'6693'} = 'MJOSUNDET';
$borough_number{'6694'} = '1576'; $type{'6694'} = 'G'; $location{'6694'} = 'FOLDFJORDEN';
$borough_number{'6697'} = '1576'; $type{'6697'} = 'G'; $location{'6697'} = 'VIHALS';
$borough_number{'6698'} = '1576'; $type{'6698'} = 'G'; $location{'6698'} = 'LESUND';
$borough_number{'6699'} = '1576'; $type{'6699'} = 'G'; $location{'6699'} = 'KJRSVIKBUGEN';
$borough_number{'6700'} = '1439'; $type{'6700'} = 'G'; $location{'6700'} = 'MLY';
$borough_number{'6701'} = '1439'; $type{'6701'} = 'P'; $location{'6701'} = 'MLY';
$borough_number{'6702'} = '1439'; $type{'6702'} = 'P'; $location{'6702'} = 'MLY';
$borough_number{'6703'} = '1439'; $type{'6703'} = 'P'; $location{'6703'} = 'MLY';
$borough_number{'6704'} = '1439'; $type{'6704'} = 'P'; $location{'6704'} = 'DEKNEPOLLEN';
$borough_number{'6706'} = '1439'; $type{'6706'} = 'S'; $location{'6706'} = 'MLY';
$borough_number{'6707'} = '1439'; $type{'6707'} = 'P'; $location{'6707'} = 'RAUDEBERG';
$borough_number{'6708'} = '1439'; $type{'6708'} = 'P'; $location{'6708'} = 'BRYGGJA';
$borough_number{'6710'} = '1439'; $type{'6710'} = 'G'; $location{'6710'} = 'RAUDEBERG';
$borough_number{'6711'} = '1439'; $type{'6711'} = 'G'; $location{'6711'} = 'BRYGGJA';
$borough_number{'6713'} = '1439'; $type{'6713'} = 'G'; $location{'6713'} = 'ALMENNINGEN';
$borough_number{'6714'} = '1439'; $type{'6714'} = 'G'; $location{'6714'} = 'SILDA';
$borough_number{'6715'} = '1441'; $type{'6715'} = 'G'; $location{'6715'} = 'BARMEN';
$borough_number{'6716'} = '1439'; $type{'6716'} = 'G'; $location{'6716'} = 'HUSEVG';
$borough_number{'6717'} = '1441'; $type{'6717'} = 'G'; $location{'6717'} = 'FLATRAKET';
$borough_number{'6718'} = '1439'; $type{'6718'} = 'G'; $location{'6718'} = 'DEKNEPOLLEN';
$borough_number{'6719'} = '1438'; $type{'6719'} = 'G'; $location{'6719'} = 'SKATESTRAUMEN';
$borough_number{'6721'} = '1438'; $type{'6721'} = 'P'; $location{'6721'} = 'SVELGEN';
$borough_number{'6723'} = '1438'; $type{'6723'} = 'G'; $location{'6723'} = 'SVELGEN';
$borough_number{'6726'} = '1438'; $type{'6726'} = 'P'; $location{'6726'} = 'BREMANGER';
$borough_number{'6727'} = '1438'; $type{'6727'} = 'G'; $location{'6727'} = 'BREMANGER';
$borough_number{'6728'} = '1438'; $type{'6728'} = 'P'; $location{'6728'} = 'KALVG';
$borough_number{'6729'} = '1438'; $type{'6729'} = 'G'; $location{'6729'} = 'KALVG';
$borough_number{'6730'} = '1438'; $type{'6730'} = 'G'; $location{'6730'} = 'DAVIK';
$borough_number{'6731'} = '1438'; $type{'6731'} = 'P'; $location{'6731'} = 'DAVIK';
$borough_number{'6734'} = '1438'; $type{'6734'} = 'G'; $location{'6734'} = 'RUGSUND';
$borough_number{'6737'} = '1438'; $type{'6737'} = 'G'; $location{'6737'} = 'LFOTEN';
$borough_number{'6740'} = '1441'; $type{'6740'} = 'G'; $location{'6740'} = 'SELJE';
$borough_number{'6741'} = '1441'; $type{'6741'} = 'P'; $location{'6741'} = 'SELJE';
$borough_number{'6750'} = '1441'; $type{'6750'} = 'G'; $location{'6750'} = 'STADLANDET';
$borough_number{'6751'} = '1441'; $type{'6751'} = 'P'; $location{'6751'} = 'STADLANDET';
$borough_number{'6761'} = '1444'; $type{'6761'} = 'P'; $location{'6761'} = 'HORNINDAL';
$borough_number{'6763'} = '1444'; $type{'6763'} = 'G'; $location{'6763'} = 'HORNINDAL';
$borough_number{'6770'} = '1443'; $type{'6770'} = 'G'; $location{'6770'} = 'NORDFJORDEID';
$borough_number{'6771'} = '1443'; $type{'6771'} = 'P'; $location{'6771'} = 'NORDFJORDEID';
$borough_number{'6772'} = '1443'; $type{'6772'} = 'P'; $location{'6772'} = 'NORDFJORDEID';
$borough_number{'6776'} = '1443'; $type{'6776'} = 'G'; $location{'6776'} = 'KJLSDALEN';
$borough_number{'6777'} = '1443'; $type{'6777'} = 'G'; $location{'6777'} = 'STRHEIM';
$borough_number{'6778'} = '1443'; $type{'6778'} = 'G'; $location{'6778'} = 'LOTE';
$borough_number{'6779'} = '1443'; $type{'6779'} = 'G'; $location{'6779'} = 'HOLMYANE';
$borough_number{'6781'} = '1449'; $type{'6781'} = 'P'; $location{'6781'} = 'STRYN';
$borough_number{'6782'} = '1449'; $type{'6782'} = 'P'; $location{'6782'} = 'STRYN';
$borough_number{'6783'} = '1449'; $type{'6783'} = 'G'; $location{'6783'} = 'STRYN';
$borough_number{'6784'} = '1449'; $type{'6784'} = 'P'; $location{'6784'} = 'OLDEN';
$borough_number{'6788'} = '1449'; $type{'6788'} = 'G'; $location{'6788'} = 'OLDEN';
$borough_number{'6789'} = '1449'; $type{'6789'} = 'B'; $location{'6789'} = 'LOEN';
$borough_number{'6791'} = '1449'; $type{'6791'} = 'G'; $location{'6791'} = 'OLDEDALEN';
$borough_number{'6792'} = '1449'; $type{'6792'} = 'G'; $location{'6792'} = 'BRIKSDALSBRE';
$borough_number{'6793'} = '1449'; $type{'6793'} = 'B'; $location{'6793'} = 'INNVIK';
$borough_number{'6795'} = '1449'; $type{'6795'} = 'G'; $location{'6795'} = 'BLAKSTER';
$borough_number{'6796'} = '1449'; $type{'6796'} = 'G'; $location{'6796'} = 'HOPLAND';
$borough_number{'6797'} = '1449'; $type{'6797'} = 'G'; $location{'6797'} = 'UTVIK';
$borough_number{'6798'} = '1449'; $type{'6798'} = 'G'; $location{'6798'} = 'HJELLEDALEN';
$borough_number{'6799'} = '1449'; $type{'6799'} = 'G'; $location{'6799'} = 'OPPSTRYN';
$borough_number{'6800'} = '1432'; $type{'6800'} = 'B'; $location{'6800'} = 'FRDE';
$borough_number{'6801'} = '1432'; $type{'6801'} = 'P'; $location{'6801'} = 'FRDE';
$borough_number{'6802'} = '1432'; $type{'6802'} = 'P'; $location{'6802'} = 'FRDE';
$borough_number{'6803'} = '1432'; $type{'6803'} = 'P'; $location{'6803'} = 'FRDE';
$borough_number{'6804'} = '1432'; $type{'6804'} = 'P'; $location{'6804'} = 'FRDE';
$borough_number{'6805'} = '1432'; $type{'6805'} = 'P'; $location{'6805'} = 'FRDE';
$borough_number{'6806'} = '1433'; $type{'6806'} = 'P'; $location{'6806'} = 'NAUSTDAL';
$borough_number{'6807'} = '1432'; $type{'6807'} = 'S'; $location{'6807'} = 'FRDE';
$borough_number{'6816'} = '1433'; $type{'6816'} = 'P'; $location{'6816'} = 'NAUSTDAL';
$borough_number{'6817'} = '1433'; $type{'6817'} = 'G'; $location{'6817'} = 'NAUSTDAL';
$borough_number{'6818'} = '1432'; $type{'6818'} = 'G'; $location{'6818'} = 'HAUKEDALEN';
$borough_number{'6819'} = '1432'; $type{'6819'} = 'G'; $location{'6819'} = 'HOLSEN';
$borough_number{'6821'} = '1445'; $type{'6821'} = 'P'; $location{'6821'} = 'SANDANE';
$borough_number{'6822'} = '1445'; $type{'6822'} = 'P'; $location{'6822'} = 'SANDANE';
$borough_number{'6823'} = '1445'; $type{'6823'} = 'G'; $location{'6823'} = 'SANDANE';
$borough_number{'6826'} = '1445'; $type{'6826'} = 'B'; $location{'6826'} = 'BYRKJELO';
$borough_number{'6827'} = '1445'; $type{'6827'} = 'G'; $location{'6827'} = 'BREIM';
$borough_number{'6828'} = '1445'; $type{'6828'} = 'G'; $location{'6828'} = 'HESTENESYRA';
$borough_number{'6829'} = '1445'; $type{'6829'} = 'B'; $location{'6829'} = 'HYEN';
$borough_number{'6841'} = '1431'; $type{'6841'} = 'P'; $location{'6841'} = 'SKEI I JLSTER';
$borough_number{'6843'} = '1431'; $type{'6843'} = 'G'; $location{'6843'} = 'SKEI I JLSTER';
$borough_number{'6847'} = '1431'; $type{'6847'} = 'B'; $location{'6847'} = 'VASSENDEN';
$borough_number{'6848'} = '1420'; $type{'6848'} = 'B'; $location{'6848'} = 'FJRLAND';
$borough_number{'6851'} = '1420'; $type{'6851'} = 'P'; $location{'6851'} = 'SOGNDAL';
$borough_number{'6852'} = '1420'; $type{'6852'} = 'P'; $location{'6852'} = 'SOGNDAL';
$borough_number{'6853'} = '1420'; $type{'6853'} = 'P'; $location{'6853'} = 'SOGNDAL';
$borough_number{'6854'} = '1420'; $type{'6854'} = 'B'; $location{'6854'} = 'KAUPANGER';
$borough_number{'6855'} = '1422'; $type{'6855'} = 'G'; $location{'6855'} = 'FRNNINGEN';
$borough_number{'6856'} = '1420'; $type{'6856'} = 'G'; $location{'6856'} = 'SOGNDAL';
$borough_number{'6858'} = '1420'; $type{'6858'} = 'G'; $location{'6858'} = 'FARDAL';
$borough_number{'6859'} = '1420'; $type{'6859'} = 'G'; $location{'6859'} = 'SLINDE';
$borough_number{'6861'} = '1419'; $type{'6861'} = 'P'; $location{'6861'} = 'LEIKANGER';
$borough_number{'6863'} = '1419'; $type{'6863'} = 'G'; $location{'6863'} = 'LEIKANGER';
$borough_number{'6866'} = '1426'; $type{'6866'} = 'P'; $location{'6866'} = 'GAUPNE';
$borough_number{'6868'} = '1426'; $type{'6868'} = 'G'; $location{'6868'} = 'GAUPNE';
$borough_number{'6869'} = '1426'; $type{'6869'} = 'B'; $location{'6869'} = 'HAFSLO';
$borough_number{'6870'} = '1426'; $type{'6870'} = 'G'; $location{'6870'} = 'ORNES';
$borough_number{'6871'} = '1426'; $type{'6871'} = 'G'; $location{'6871'} = 'JOSTEDAL';
$borough_number{'6872'} = '1426'; $type{'6872'} = 'B'; $location{'6872'} = 'LUSTER';
$borough_number{'6873'} = '1426'; $type{'6873'} = 'G'; $location{'6873'} = 'MARIFJRA';
$borough_number{'6875'} = '1426'; $type{'6875'} = 'G'; $location{'6875'} = 'HYHEIMSVIK';
$borough_number{'6876'} = '1426'; $type{'6876'} = 'G'; $location{'6876'} = 'SKJOLDEN';
$borough_number{'6877'} = '1426'; $type{'6877'} = 'G'; $location{'6877'} = 'FORTUN';
$borough_number{'6878'} = '1426'; $type{'6878'} = 'G'; $location{'6878'} = 'VEITASTROND';
$borough_number{'6879'} = '1426'; $type{'6879'} = 'G'; $location{'6879'} = 'SOLVORN';
$borough_number{'6881'} = '1424'; $type{'6881'} = 'P'; $location{'6881'} = 'RDALSTANGEN';
$borough_number{'6882'} = '1424'; $type{'6882'} = 'P'; $location{'6882'} = 'VRE RDAL';
$borough_number{'6884'} = '1424'; $type{'6884'} = 'G'; $location{'6884'} = 'VRE RDAL';
$borough_number{'6885'} = '1424'; $type{'6885'} = 'G'; $location{'6885'} = 'RDALSTANGEN';
$borough_number{'6886'} = '1422'; $type{'6886'} = 'P'; $location{'6886'} = 'LRDAL';
$borough_number{'6887'} = '1422'; $type{'6887'} = 'G'; $location{'6887'} = 'LRDAL';
$borough_number{'6888'} = '1422'; $type{'6888'} = 'G'; $location{'6888'} = 'STEINKLEPP';
$borough_number{'6891'} = '1417'; $type{'6891'} = 'P'; $location{'6891'} = 'VIK I SOGN';
$borough_number{'6893'} = '1417'; $type{'6893'} = 'G'; $location{'6893'} = 'VIK I SOGN';
$borough_number{'6894'} = '1417'; $type{'6894'} = 'G'; $location{'6894'} = 'VANGSNES';
$borough_number{'6895'} = '1417'; $type{'6895'} = 'G'; $location{'6895'} = 'FEIOS';
$borough_number{'6896'} = '1417'; $type{'6896'} = 'G'; $location{'6896'} = 'FRESVIK';
$borough_number{'6898'} = '1418'; $type{'6898'} = 'P'; $location{'6898'} = 'BALESTRAND';
$borough_number{'6899'} = '1418'; $type{'6899'} = 'G'; $location{'6899'} = 'BALESTRAND';
$borough_number{'6900'} = '1401'; $type{'6900'} = 'G'; $location{'6900'} = 'FLOR';
$borough_number{'6901'} = '1401'; $type{'6901'} = 'P'; $location{'6901'} = 'FLOR';
$borough_number{'6902'} = '1401'; $type{'6902'} = 'P'; $location{'6902'} = 'FLOR';
$borough_number{'6903'} = '1401'; $type{'6903'} = 'P'; $location{'6903'} = 'FLOR';
$borough_number{'6909'} = '1401'; $type{'6909'} = 'P'; $location{'6909'} = 'FLOR';
$borough_number{'6912'} = '1401'; $type{'6912'} = 'G'; $location{'6912'} = 'KINN';
$borough_number{'6914'} = '1401'; $type{'6914'} = 'G'; $location{'6914'} = 'SVANYBUKT';
$borough_number{'6915'} = '1401'; $type{'6915'} = 'G'; $location{'6915'} = 'ROGNALDSVG';
$borough_number{'6916'} = '1401'; $type{'6916'} = 'G'; $location{'6916'} = 'BAREKSTAD';
$borough_number{'6917'} = '1401'; $type{'6917'} = 'G'; $location{'6917'} = 'BATALDEN';
$borough_number{'6918'} = '1401'; $type{'6918'} = 'G'; $location{'6918'} = 'SR-SKORPA';
$borough_number{'6919'} = '1401'; $type{'6919'} = 'G'; $location{'6919'} = 'TANSY';
$borough_number{'6921'} = '1412'; $type{'6921'} = 'P'; $location{'6921'} = 'HARDBAKKE';
$borough_number{'6924'} = '1412'; $type{'6924'} = 'G'; $location{'6924'} = 'HARDBAKKE';
$borough_number{'6926'} = '1412'; $type{'6926'} = 'G'; $location{'6926'} = 'KRAKHELLA';
$borough_number{'6927'} = '1412'; $type{'6927'} = 'G'; $location{'6927'} = 'YTRYGREND';
$borough_number{'6928'} = '1412'; $type{'6928'} = 'G'; $location{'6928'} = 'KOLGROV';
$borough_number{'6929'} = '1412'; $type{'6929'} = 'G'; $location{'6929'} = 'HERSVIKBYGDA';
$borough_number{'6939'} = '1401'; $type{'6939'} = 'P'; $location{'6939'} = 'STAVANG';
$borough_number{'6940'} = '1401'; $type{'6940'} = 'G'; $location{'6940'} = 'EIKEFJORD';
$borough_number{'6941'} = '1401'; $type{'6941'} = 'P'; $location{'6941'} = 'EIKEFJORD';
$borough_number{'6942'} = '1401'; $type{'6942'} = 'G'; $location{'6942'} = 'SVORTEVIK';
$borough_number{'6944'} = '1401'; $type{'6944'} = 'G'; $location{'6944'} = 'STAVANG';
$borough_number{'6946'} = '1416'; $type{'6946'} = 'P'; $location{'6946'} = 'LAVIK';
$borough_number{'6947'} = '1416'; $type{'6947'} = 'G'; $location{'6947'} = 'LAVIK';
$borough_number{'6951'} = '1413'; $type{'6951'} = 'P'; $location{'6951'} = 'LEIRVIK I SOGN';
$borough_number{'6953'} = '1413'; $type{'6953'} = 'G'; $location{'6953'} = 'LEIRVIK I SOGN';
$borough_number{'6957'} = '1413'; $type{'6957'} = 'G'; $location{'6957'} = 'HYLLESTAD';
$borough_number{'6958'} = '1413'; $type{'6958'} = 'B'; $location{'6958'} = 'SRBVG';
$borough_number{'6961'} = '1429'; $type{'6961'} = 'P'; $location{'6961'} = 'DALE I SUNNFJORD';
$borough_number{'6963'} = '1429'; $type{'6963'} = 'G'; $location{'6963'} = 'DALE I SUNNFJORD';
$borough_number{'6964'} = '1429'; $type{'6964'} = 'G'; $location{'6964'} = 'KORSSUND';
$borough_number{'6966'} = '1429'; $type{'6966'} = 'G'; $location{'6966'} = 'GUDDAL';
$borough_number{'6967'} = '1429'; $type{'6967'} = 'G'; $location{'6967'} = 'HELLEVIK I FJALER';
$borough_number{'6968'} = '1429'; $type{'6968'} = 'B'; $location{'6968'} = 'FLEKKE';
$borough_number{'6969'} = '1429'; $type{'6969'} = 'G'; $location{'6969'} = 'STRAUMSNES';
$borough_number{'6971'} = '1430'; $type{'6971'} = 'P'; $location{'6971'} = 'SANDE I SUNNFJORD';
$borough_number{'6973'} = '1430'; $type{'6973'} = 'G'; $location{'6973'} = 'SANDE I SUNNFJORD';
$borough_number{'6975'} = '1430'; $type{'6975'} = 'G'; $location{'6975'} = 'SKILBREI';
$borough_number{'6977'} = '1430'; $type{'6977'} = 'B'; $location{'6977'} = 'BYGSTAD';
$borough_number{'6978'} = '1430'; $type{'6978'} = 'G'; $location{'6978'} = 'VIKSDALEN';
$borough_number{'6980'} = '1428'; $type{'6980'} = 'G'; $location{'6980'} = 'ASKVOLL';
$borough_number{'6981'} = '1428'; $type{'6981'} = 'P'; $location{'6981'} = 'HOLMEDAL';
$borough_number{'6982'} = '1428'; $type{'6982'} = 'G'; $location{'6982'} = 'HOLMEDAL';
$borough_number{'6983'} = '1428'; $type{'6983'} = 'B'; $location{'6983'} = 'KVAMMEN';
$borough_number{'6984'} = '1428'; $type{'6984'} = 'G'; $location{'6984'} = 'STONGFJORDEN';
$borough_number{'6985'} = '1428'; $type{'6985'} = 'B'; $location{'6985'} = 'ATLY';
$borough_number{'6986'} = '1428'; $type{'6986'} = 'G'; $location{'6986'} = 'VRLANDET';
$borough_number{'6987'} = '1428'; $type{'6987'} = 'G'; $location{'6987'} = 'BULANDET';
$borough_number{'6988'} = '1428'; $type{'6988'} = 'P'; $location{'6988'} = 'ASKVOLL';
$borough_number{'6991'} = '1416'; $type{'6991'} = 'P'; $location{'6991'} = 'HYANGER';
$borough_number{'6993'} = '1416'; $type{'6993'} = 'G'; $location{'6993'} = 'HYANGER';
$borough_number{'6995'} = '1416'; $type{'6995'} = 'G'; $location{'6995'} = 'KYRKJEB';
$borough_number{'6996'} = '1416'; $type{'6996'} = 'B'; $location{'6996'} = 'VADHEIM';
$borough_number{'7003'} = '1601'; $type{'7003'} = 'K'; $location{'7003'} = 'TRONDHEIM';
$borough_number{'7004'} = '1601'; $type{'7004'} = 'S'; $location{'7004'} = 'TRONDHEIM';
$borough_number{'7005'} = '1601'; $type{'7005'} = 'S'; $location{'7005'} = 'TRONDHEIM';
$borough_number{'7006'} = '1601'; $type{'7006'} = 'K'; $location{'7006'} = 'TRONDHEIM';
$borough_number{'7007'} = '1601'; $type{'7007'} = 'K'; $location{'7007'} = 'TRONDHEIM';
$borough_number{'7010'} = '1601'; $type{'7010'} = 'G'; $location{'7010'} = 'TRONDHEIM';
$borough_number{'7011'} = '1601'; $type{'7011'} = 'G'; $location{'7011'} = 'TRONDHEIM';
$borough_number{'7012'} = '1601'; $type{'7012'} = 'G'; $location{'7012'} = 'TRONDHEIM';
$borough_number{'7013'} = '1601'; $type{'7013'} = 'G'; $location{'7013'} = 'TRONDHEIM';
$borough_number{'7014'} = '1601'; $type{'7014'} = 'B'; $location{'7014'} = 'TRONDHEIM';
$borough_number{'7015'} = '1601'; $type{'7015'} = 'G'; $location{'7015'} = 'TRONDHEIM';
$borough_number{'7016'} = '1601'; $type{'7016'} = 'G'; $location{'7016'} = 'TRONDHEIM';
$borough_number{'7018'} = '1601'; $type{'7018'} = 'B'; $location{'7018'} = 'TRONDHEIM';
$borough_number{'7019'} = '1601'; $type{'7019'} = 'G'; $location{'7019'} = 'TRONDHEIM';
$borough_number{'7020'} = '1601'; $type{'7020'} = 'G'; $location{'7020'} = 'TRONDHEIM';
$borough_number{'7021'} = '1601'; $type{'7021'} = 'G'; $location{'7021'} = 'TRONDHEIM';
$borough_number{'7022'} = '1601'; $type{'7022'} = 'G'; $location{'7022'} = 'TRONDHEIM';
$borough_number{'7023'} = '1601'; $type{'7023'} = 'G'; $location{'7023'} = 'TRONDHEIM';
$borough_number{'7024'} = '1601'; $type{'7024'} = 'G'; $location{'7024'} = 'TRONDHEIM';
$borough_number{'7025'} = '1601'; $type{'7025'} = 'B'; $location{'7025'} = 'TRONDHEIM';
$borough_number{'7026'} = '1601'; $type{'7026'} = 'G'; $location{'7026'} = 'TRONDHEIM';
$borough_number{'7027'} = '1601'; $type{'7027'} = 'G'; $location{'7027'} = 'TRONDHEIM';
$borough_number{'7028'} = '1601'; $type{'7028'} = 'G'; $location{'7028'} = 'TRONDHEIM';
$borough_number{'7029'} = '1601'; $type{'7029'} = 'G'; $location{'7029'} = 'TRONDHEIM';
$borough_number{'7030'} = '1601'; $type{'7030'} = 'G'; $location{'7030'} = 'TRONDHEIM';
$borough_number{'7031'} = '1601'; $type{'7031'} = 'B'; $location{'7031'} = 'TRONDHEIM';
$borough_number{'7032'} = '1601'; $type{'7032'} = 'G'; $location{'7032'} = 'TRONDHEIM';
$borough_number{'7033'} = '1601'; $type{'7033'} = 'G'; $location{'7033'} = 'TRONDHEIM';
$borough_number{'7034'} = '1601'; $type{'7034'} = 'G'; $location{'7034'} = 'TRONDHEIM';
$borough_number{'7036'} = '1601'; $type{'7036'} = 'B'; $location{'7036'} = 'TRONDHEIM';
$borough_number{'7037'} = '1601'; $type{'7037'} = 'B'; $location{'7037'} = 'TRONDHEIM';
$borough_number{'7038'} = '1601'; $type{'7038'} = 'G'; $location{'7038'} = 'TRONDHEIM';
$borough_number{'7039'} = '1601'; $type{'7039'} = 'B'; $location{'7039'} = 'TRONDHEIM';
$borough_number{'7040'} = '1601'; $type{'7040'} = 'G'; $location{'7040'} = 'TRONDHEIM';
$borough_number{'7041'} = '1601'; $type{'7041'} = 'G'; $location{'7041'} = 'TRONDHEIM';
$borough_number{'7042'} = '1601'; $type{'7042'} = 'G'; $location{'7042'} = 'TRONDHEIM';
$borough_number{'7043'} = '1601'; $type{'7043'} = 'G'; $location{'7043'} = 'TRONDHEIM';
$borough_number{'7044'} = '1601'; $type{'7044'} = 'G'; $location{'7044'} = 'TRONDHEIM';
$borough_number{'7045'} = '1601'; $type{'7045'} = 'B'; $location{'7045'} = 'TRONDHEIM';
$borough_number{'7046'} = '1601'; $type{'7046'} = 'G'; $location{'7046'} = 'TRONDHEIM';
$borough_number{'7047'} = '1601'; $type{'7047'} = 'G'; $location{'7047'} = 'TRONDHEIM';
$borough_number{'7048'} = '1601'; $type{'7048'} = 'G'; $location{'7048'} = 'TRONDHEIM';
$borough_number{'7049'} = '1601'; $type{'7049'} = 'G'; $location{'7049'} = 'TRONDHEIM';
$borough_number{'7050'} = '1601'; $type{'7050'} = 'G'; $location{'7050'} = 'TRONDHEIM';
$borough_number{'7051'} = '1601'; $type{'7051'} = 'B'; $location{'7051'} = 'TRONDHEIM';
$borough_number{'7052'} = '1601'; $type{'7052'} = 'B'; $location{'7052'} = 'TRONDHEIM';
$borough_number{'7053'} = '1601'; $type{'7053'} = 'G'; $location{'7053'} = 'RANHEIM';
$borough_number{'7054'} = '1601'; $type{'7054'} = 'G'; $location{'7054'} = 'RANHEIM';
$borough_number{'7056'} = '1601'; $type{'7056'} = 'G'; $location{'7056'} = 'RANHEIM';
$borough_number{'7057'} = '1601'; $type{'7057'} = 'G'; $location{'7057'} = 'JONSVATNET';
$borough_number{'7058'} = '1601'; $type{'7058'} = 'G'; $location{'7058'} = 'JAKOBSLI';
$borough_number{'7059'} = '1601'; $type{'7059'} = 'G'; $location{'7059'} = 'JAKOBSLI';
$borough_number{'7070'} = '1601'; $type{'7070'} = 'B'; $location{'7070'} = 'BOSBERG';
$borough_number{'7072'} = '1601'; $type{'7072'} = 'G'; $location{'7072'} = 'HEIMDAL';
$borough_number{'7074'} = '1601'; $type{'7074'} = 'B'; $location{'7074'} = 'SPONGDAL';
$borough_number{'7075'} = '1601'; $type{'7075'} = 'G'; $location{'7075'} = 'TILLER';
$borough_number{'7078'} = '1601'; $type{'7078'} = 'G'; $location{'7078'} = 'SAUPSTAD';
$borough_number{'7079'} = '1601'; $type{'7079'} = 'G'; $location{'7079'} = 'FLATSEN';
$borough_number{'7080'} = '1601'; $type{'7080'} = 'G'; $location{'7080'} = 'HEIMDAL';
$borough_number{'7081'} = '1601'; $type{'7081'} = 'B'; $location{'7081'} = 'SJETNEMARKA';
$borough_number{'7082'} = '1601'; $type{'7082'} = 'B'; $location{'7082'} = 'KATTEM';
$borough_number{'7083'} = '1601'; $type{'7083'} = 'B'; $location{'7083'} = 'LEINSTRAND';
$borough_number{'7088'} = '1601'; $type{'7088'} = 'G'; $location{'7088'} = 'HEIMDAL';
$borough_number{'7089'} = '1601'; $type{'7089'} = 'G'; $location{'7089'} = 'HEIMDAL';
$borough_number{'7091'} = '1601'; $type{'7091'} = 'B'; $location{'7091'} = 'TILLER';
$borough_number{'7092'} = '1601'; $type{'7092'} = 'G'; $location{'7092'} = 'TILLER';
$borough_number{'7097'} = '1601'; $type{'7097'} = 'G'; $location{'7097'} = 'SAUPSTAD';
$borough_number{'7098'} = '1601'; $type{'7098'} = 'G'; $location{'7098'} = 'SAUPSTAD';
$borough_number{'7099'} = '1601'; $type{'7099'} = 'G'; $location{'7099'} = 'FLATSEN';
$borough_number{'7100'} = '1624'; $type{'7100'} = 'G'; $location{'7100'} = 'RISSA';
$borough_number{'7101'} = '1624'; $type{'7101'} = 'P'; $location{'7101'} = 'RISSA';
$borough_number{'7105'} = '1624'; $type{'7105'} = 'G'; $location{'7105'} = 'STADSBYGD';
$borough_number{'7110'} = '1624'; $type{'7110'} = 'B'; $location{'7110'} = 'FEVG';
$borough_number{'7112'} = '1624'; $type{'7112'} = 'B'; $location{'7112'} = 'HASSELVIKA';
$borough_number{'7113'} = '1624'; $type{'7113'} = 'B'; $location{'7113'} = 'HUSBYSJEN';
$borough_number{'7114'} = '1624'; $type{'7114'} = 'B'; $location{'7114'} = 'RKVG';
$borough_number{'7119'} = '1624'; $type{'7119'} = 'P'; $location{'7119'} = 'STADSBYGD';
$borough_number{'7120'} = '1718'; $type{'7120'} = 'G'; $location{'7120'} = 'LEKSVIK';
$borough_number{'7121'} = '1718'; $type{'7121'} = 'P'; $location{'7121'} = 'LEKSVIK';
$borough_number{'7125'} = '1718'; $type{'7125'} = 'G'; $location{'7125'} = 'VANVIKAN';
$borough_number{'7126'} = '1718'; $type{'7126'} = 'P'; $location{'7126'} = 'VANVIKAN';
$borough_number{'7127'} = '1621'; $type{'7127'} = 'P'; $location{'7127'} = 'OPPHAUG';
$borough_number{'7128'} = '1621'; $type{'7128'} = 'P'; $location{'7128'} = 'UTHAUG';
$borough_number{'7129'} = '1621'; $type{'7129'} = 'P'; $location{'7129'} = 'BREKSTAD';
$borough_number{'7130'} = '1621'; $type{'7130'} = 'G'; $location{'7130'} = 'BREKSTAD';
$borough_number{'7140'} = '1621'; $type{'7140'} = 'G'; $location{'7140'} = 'OPPHAUG';
$borough_number{'7142'} = '1621'; $type{'7142'} = 'G'; $location{'7142'} = 'UTHAUG';
$borough_number{'7150'} = '1621'; $type{'7150'} = 'B'; $location{'7150'} = 'STORFOSNA';
$borough_number{'7152'} = '1621'; $type{'7152'} = 'G'; $location{'7152'} = 'KRKVG';
$borough_number{'7153'} = '1621'; $type{'7153'} = 'G'; $location{'7153'} = 'GARTEN';
$borough_number{'7156'} = '1622'; $type{'7156'} = 'G'; $location{'7156'} = 'LEKSA';
$borough_number{'7159'} = '1627'; $type{'7159'} = 'P'; $location{'7159'} = 'BJUGN';
$borough_number{'7160'} = '1627'; $type{'7160'} = 'G'; $location{'7160'} = 'BJUGN';
$borough_number{'7165'} = '1627'; $type{'7165'} = 'G'; $location{'7165'} = 'OKSVOLL';
$borough_number{'7166'} = '1627'; $type{'7166'} = 'G'; $location{'7166'} = 'TARVA';
$borough_number{'7167'} = '1627'; $type{'7167'} = 'G'; $location{'7167'} = 'VALLERSUND';
$borough_number{'7168'} = '1627'; $type{'7168'} = 'B'; $location{'7168'} = 'LYSYSUNDET';
$borough_number{'7169'} = '1630'; $type{'7169'} = 'P'; $location{'7169'} = 'FJORD';
$borough_number{'7170'} = '1630'; $type{'7170'} = 'B'; $location{'7170'} = 'FJORD';
$borough_number{'7176'} = '1630'; $type{'7176'} = 'G'; $location{'7176'} = 'LINESYA';
$borough_number{'7177'} = '1630'; $type{'7177'} = 'B'; $location{'7177'} = 'REVSNES';
$borough_number{'7178'} = '1630'; $type{'7178'} = 'B'; $location{'7178'} = 'STOKKY';
$borough_number{'7180'} = '1632'; $type{'7180'} = 'B'; $location{'7180'} = 'ROAN';
$borough_number{'7190'} = '1632'; $type{'7190'} = 'B'; $location{'7190'} = 'BESSAKER';
$borough_number{'7194'} = '1632'; $type{'7194'} = 'B'; $location{'7194'} = 'BRANDSFJORD';
$borough_number{'7200'} = '1612'; $type{'7200'} = 'G'; $location{'7200'} = 'KYRKSTERRA';
$borough_number{'7201'} = '1612'; $type{'7201'} = 'P'; $location{'7201'} = 'KYRKSTERRA';
$borough_number{'7203'} = '1612'; $type{'7203'} = 'G'; $location{'7203'} = 'VINJERA';
$borough_number{'7206'} = '1612'; $type{'7206'} = 'G'; $location{'7206'} = 'HELLANDSJEN';
$borough_number{'7211'} = '1653'; $type{'7211'} = 'P'; $location{'7211'} = 'KORSVEGEN';
$borough_number{'7212'} = '1653'; $type{'7212'} = 'G'; $location{'7212'} = 'KORSVEGEN';
$borough_number{'7213'} = '1653'; $type{'7213'} = 'G'; $location{'7213'} = 'GSBAKKEN';
$borough_number{'7221'} = '1653'; $type{'7221'} = 'P'; $location{'7221'} = 'MELHUS';
$borough_number{'7223'} = '1653'; $type{'7223'} = 'P'; $location{'7223'} = 'MELHUS';
$borough_number{'7224'} = '1653'; $type{'7224'} = 'G'; $location{'7224'} = 'MELHUS';
$borough_number{'7227'} = '1653'; $type{'7227'} = 'G'; $location{'7227'} = 'GIMSE';
$borough_number{'7228'} = '1653'; $type{'7228'} = 'G'; $location{'7228'} = 'KVL';
$borough_number{'7231'} = '1653'; $type{'7231'} = 'P'; $location{'7231'} = 'LUNDAMO';
$borough_number{'7232'} = '1653'; $type{'7232'} = 'G'; $location{'7232'} = 'LUNDAMO';
$borough_number{'7234'} = '1653'; $type{'7234'} = 'G'; $location{'7234'} = 'LER';
$borough_number{'7235'} = '1653'; $type{'7235'} = 'P'; $location{'7235'} = 'LER';
$borough_number{'7236'} = '1653'; $type{'7236'} = 'G'; $location{'7236'} = 'HOVIN I GAULDAL';
$borough_number{'7238'} = '1653'; $type{'7238'} = 'P'; $location{'7238'} = 'HOVIN I GAULDAL';
$borough_number{'7239'} = '1617'; $type{'7239'} = 'P'; $location{'7239'} = 'HITRA';
$borough_number{'7240'} = '1617'; $type{'7240'} = 'G'; $location{'7240'} = 'HITRA';
$borough_number{'7241'} = '1617'; $type{'7241'} = 'G'; $location{'7241'} = 'ANSNES';
$borough_number{'7242'} = '1617'; $type{'7242'} = 'B'; $location{'7242'} = 'KNARRLAGSUND';
$borough_number{'7243'} = '1617'; $type{'7243'} = 'B'; $location{'7243'} = 'KVENVR';
$borough_number{'7246'} = '1617'; $type{'7246'} = 'G'; $location{'7246'} = 'SANDSTAD';
$borough_number{'7247'} = '1617'; $type{'7247'} = 'G'; $location{'7247'} = 'HESTVIKA';
$borough_number{'7250'} = '1617'; $type{'7250'} = 'G'; $location{'7250'} = 'MELANDSJ';
$borough_number{'7252'} = '1617'; $type{'7252'} = 'G'; $location{'7252'} = 'DOLMY';
$borough_number{'7255'} = '1613'; $type{'7255'} = 'G'; $location{'7255'} = 'SUNDLANDET';
$borough_number{'7256'} = '1613'; $type{'7256'} = 'G'; $location{'7256'} = 'HEMNSKJELA';
$borough_number{'7257'} = '1613'; $type{'7257'} = 'G'; $location{'7257'} = 'SNILLFJORD';
$borough_number{'7259'} = '1613'; $type{'7259'} = 'P'; $location{'7259'} = 'SNILLFJORD';
$borough_number{'7260'} = '1620'; $type{'7260'} = 'G'; $location{'7260'} = 'SISTRANDA';
$borough_number{'7261'} = '1620'; $type{'7261'} = 'P'; $location{'7261'} = 'SISTRANDA';
$borough_number{'7263'} = '1620'; $type{'7263'} = 'G'; $location{'7263'} = 'HAMARVIK';
$borough_number{'7264'} = '1620'; $type{'7264'} = 'P'; $location{'7264'} = 'HAMARVIK';
$borough_number{'7266'} = '1620'; $type{'7266'} = 'G'; $location{'7266'} = 'KVERVA';
$borough_number{'7268'} = '1620'; $type{'7268'} = 'G'; $location{'7268'} = 'TITRAN';
$borough_number{'7270'} = '1620'; $type{'7270'} = 'G'; $location{'7270'} = 'DYRVIK';
$borough_number{'7273'} = '1620'; $type{'7273'} = 'B'; $location{'7273'} = 'NORDDYRY';
$borough_number{'7280'} = '1620'; $type{'7280'} = 'B'; $location{'7280'} = 'SULA';
$borough_number{'7282'} = '1620'; $type{'7282'} = 'G'; $location{'7282'} = 'BOGYVR';
$borough_number{'7284'} = '1620'; $type{'7284'} = 'B'; $location{'7284'} = 'MAUSUND';
$borough_number{'7285'} = '1620'; $type{'7285'} = 'G'; $location{'7285'} = 'GJSINGEN';
$borough_number{'7286'} = '1620'; $type{'7286'} = 'G'; $location{'7286'} = 'SRBURY';
$borough_number{'7287'} = '1620'; $type{'7287'} = 'G'; $location{'7287'} = 'SAUY';
$borough_number{'7288'} = '1648'; $type{'7288'} = 'G'; $location{'7288'} = 'SOKNEDAL';
$borough_number{'7289'} = '1648'; $type{'7289'} = 'P'; $location{'7289'} = 'SOKNEDAL';
$borough_number{'7290'} = '1648'; $type{'7290'} = 'G'; $location{'7290'} = 'STREN';
$borough_number{'7291'} = '1648'; $type{'7291'} = 'P'; $location{'7291'} = 'STREN';
$borough_number{'7295'} = '1648'; $type{'7295'} = 'G'; $location{'7295'} = 'ROGNES';
$borough_number{'7298'} = '1648'; $type{'7298'} = 'G'; $location{'7298'} = 'BUDALEN';
$borough_number{'7300'} = '1638'; $type{'7300'} = 'G'; $location{'7300'} = 'ORKANGER';
$borough_number{'7301'} = '1638'; $type{'7301'} = 'P'; $location{'7301'} = 'ORKANGER';
$borough_number{'7302'} = '1638'; $type{'7302'} = 'P'; $location{'7302'} = 'ORKANGER';
$borough_number{'7310'} = '1638'; $type{'7310'} = 'G'; $location{'7310'} = 'GJLME';
$borough_number{'7315'} = '1622'; $type{'7315'} = 'P'; $location{'7315'} = 'LENSVIK';
$borough_number{'7316'} = '1622'; $type{'7316'} = 'G'; $location{'7316'} = 'LENSVIK';
$borough_number{'7318'} = '1622'; $type{'7318'} = 'G'; $location{'7318'} = 'AGDENES';
$borough_number{'7319'} = '1622'; $type{'7319'} = 'P'; $location{'7319'} = 'AGDENES';
$borough_number{'7320'} = '1638'; $type{'7320'} = 'G'; $location{'7320'} = 'FANNREM';
$borough_number{'7321'} = '1638'; $type{'7321'} = 'P'; $location{'7321'} = 'FANNREM';
$borough_number{'7327'} = '1638'; $type{'7327'} = 'G'; $location{'7327'} = 'SVORKMO';
$borough_number{'7329'} = '1638'; $type{'7329'} = 'P'; $location{'7329'} = 'SVORKMO';
$borough_number{'7331'} = '1636'; $type{'7331'} = 'P'; $location{'7331'} = 'LKKEN VERK';
$borough_number{'7332'} = '1636'; $type{'7332'} = 'G'; $location{'7332'} = 'LKKEN VERK';
$borough_number{'7333'} = '1636'; $type{'7333'} = 'P'; $location{'7333'} = 'STORS';
$borough_number{'7334'} = '1636'; $type{'7334'} = 'G'; $location{'7334'} = 'STORS';
$borough_number{'7335'} = '1636'; $type{'7335'} = 'G'; $location{'7335'} = 'JERPSTAD';
$borough_number{'7336'} = '1636'; $type{'7336'} = 'G'; $location{'7336'} = 'MELDAL';
$borough_number{'7338'} = '1636'; $type{'7338'} = 'P'; $location{'7338'} = 'MELDAL';
$borough_number{'7340'} = '1634'; $type{'7340'} = 'G'; $location{'7340'} = 'OPPDAL';
$borough_number{'7341'} = '1634'; $type{'7341'} = 'P'; $location{'7341'} = 'OPPDAL';
$borough_number{'7342'} = '1634'; $type{'7342'} = 'G'; $location{'7342'} = 'LNSET';
$borough_number{'7343'} = '1634'; $type{'7343'} = 'G'; $location{'7343'} = 'VOGNILL';
$borough_number{'7345'} = '1634'; $type{'7345'} = 'G'; $location{'7345'} = 'DRIVA';
$borough_number{'7350'} = '1657'; $type{'7350'} = 'G'; $location{'7350'} = 'BUVIKA';
$borough_number{'7351'} = '1657'; $type{'7351'} = 'P'; $location{'7351'} = 'BUVIKA';
$borough_number{'7353'} = '1657'; $type{'7353'} = 'G'; $location{'7353'} = 'BRSA';
$borough_number{'7354'} = '1657'; $type{'7354'} = 'G'; $location{'7354'} = 'VIGGJA';
$borough_number{'7355'} = '1657'; $type{'7355'} = 'G'; $location{'7355'} = 'EGGKLEIVA';
$borough_number{'7357'} = '1657'; $type{'7357'} = 'B'; $location{'7357'} = 'SKAUN';
$borough_number{'7358'} = '1657'; $type{'7358'} = 'P'; $location{'7358'} = 'BRSA';
$borough_number{'7361'} = '1640'; $type{'7361'} = 'P'; $location{'7361'} = 'RROS';
$borough_number{'7366'} = '1640'; $type{'7366'} = 'S'; $location{'7366'} = 'RROS';
$borough_number{'7370'} = '1640'; $type{'7370'} = 'G'; $location{'7370'} = 'BREKKEBYGD';
$borough_number{'7372'} = '1640'; $type{'7372'} = 'G'; $location{'7372'} = 'GLMOS';
$borough_number{'7374'} = '1640'; $type{'7374'} = 'G'; $location{'7374'} = 'RROS';
$borough_number{'7380'} = '1644'; $type{'7380'} = 'G'; $location{'7380'} = 'LEN';
$borough_number{'7383'} = '1644'; $type{'7383'} = 'G'; $location{'7383'} = 'HALTDALEN';
$borough_number{'7384'} = '1644'; $type{'7384'} = 'P'; $location{'7384'} = 'LEN';
$borough_number{'7386'} = '1648'; $type{'7386'} = 'P'; $location{'7386'} = 'SINGSS';
$borough_number{'7387'} = '1648'; $type{'7387'} = 'B'; $location{'7387'} = 'SINGSS';
$borough_number{'7391'} = '1635'; $type{'7391'} = 'G'; $location{'7391'} = 'RENNEBU';
$borough_number{'7392'} = '1635'; $type{'7392'} = 'G'; $location{'7392'} = 'RENNEBU';
$borough_number{'7393'} = '1635'; $type{'7393'} = 'G'; $location{'7393'} = 'RENNEBU';
$borough_number{'7397'} = '1635'; $type{'7397'} = 'G'; $location{'7397'} = 'RENNEBU';
$borough_number{'7398'} = '1635'; $type{'7398'} = 'G'; $location{'7398'} = 'RENNEBU';
$borough_number{'7399'} = '1635'; $type{'7399'} = 'P'; $location{'7399'} = 'RENNEBU';
$borough_number{'7400'} = '1601'; $type{'7400'} = 'P'; $location{'7400'} = 'TRONDHEIM';
$borough_number{'7401'} = '1601'; $type{'7401'} = 'P'; $location{'7401'} = 'TRONDHEIM';
$borough_number{'7402'} = '1601'; $type{'7402'} = 'P'; $location{'7402'} = 'TRONDHEIM';
$borough_number{'7403'} = '1601'; $type{'7403'} = 'P'; $location{'7403'} = 'TRONDHEIM';
$borough_number{'7404'} = '1601'; $type{'7404'} = 'P'; $location{'7404'} = 'TRONDHEIM';
$borough_number{'7405'} = '1601'; $type{'7405'} = 'P'; $location{'7405'} = 'TRONDHEIM';
$borough_number{'7406'} = '1601'; $type{'7406'} = 'P'; $location{'7406'} = 'TRONDHEIM';
$borough_number{'7407'} = '1601'; $type{'7407'} = 'P'; $location{'7407'} = 'TRONDHEIM';
$borough_number{'7408'} = '1601'; $type{'7408'} = 'P'; $location{'7408'} = 'TRONDHEIM';
$borough_number{'7409'} = '1601'; $type{'7409'} = 'P'; $location{'7409'} = 'TRONDHEIM';
$borough_number{'7410'} = '1601'; $type{'7410'} = 'P'; $location{'7410'} = 'TRONDHEIM';
$borough_number{'7411'} = '1601'; $type{'7411'} = 'P'; $location{'7411'} = 'TRONDHEIM';
$borough_number{'7412'} = '1601'; $type{'7412'} = 'P'; $location{'7412'} = 'TRONDHEIM';
$borough_number{'7413'} = '1601'; $type{'7413'} = 'P'; $location{'7413'} = 'TRONDHEIM';
$borough_number{'7414'} = '1601'; $type{'7414'} = 'P'; $location{'7414'} = 'TRONDHEIM';
$borough_number{'7415'} = '1601'; $type{'7415'} = 'P'; $location{'7415'} = 'TRONDHEIM';
$borough_number{'7416'} = '1601'; $type{'7416'} = 'P'; $location{'7416'} = 'TRONDHEIM';
$borough_number{'7417'} = '1601'; $type{'7417'} = 'P'; $location{'7417'} = 'TRONDHEIM';
$borough_number{'7418'} = '1601'; $type{'7418'} = 'P'; $location{'7418'} = 'TRONDHEIM';
$borough_number{'7419'} = '1601'; $type{'7419'} = 'P'; $location{'7419'} = 'TRONDHEIM';
$borough_number{'7420'} = '1601'; $type{'7420'} = 'P'; $location{'7420'} = 'TRONDHEIM';
$borough_number{'7421'} = '1601'; $type{'7421'} = 'P'; $location{'7421'} = 'TRONDHEIM';
$borough_number{'7423'} = '1601'; $type{'7423'} = 'P'; $location{'7423'} = 'TRONDHEIM';
$borough_number{'7424'} = '1601'; $type{'7424'} = 'P'; $location{'7424'} = 'TRONDHEIM';
$borough_number{'7425'} = '1601'; $type{'7425'} = 'P'; $location{'7425'} = 'TRONDHEIM';
$borough_number{'7426'} = '1601'; $type{'7426'} = 'P'; $location{'7426'} = 'TRONDHEIM';
$borough_number{'7427'} = '1601'; $type{'7427'} = 'P'; $location{'7427'} = 'TRONDHEIM';
$borough_number{'7428'} = '1601'; $type{'7428'} = 'P'; $location{'7428'} = 'TRONDHEIM';
$borough_number{'7429'} = '1601'; $type{'7429'} = 'P'; $location{'7429'} = 'TRONDHEIM';
$borough_number{'7430'} = '1601'; $type{'7430'} = 'P'; $location{'7430'} = 'TRONDHEIM';
$borough_number{'7431'} = '1601'; $type{'7431'} = 'P'; $location{'7431'} = 'TRONDHEIM';
$borough_number{'7432'} = '1601'; $type{'7432'} = 'P'; $location{'7432'} = 'TRONDHEIM';
$borough_number{'7433'} = '1601'; $type{'7433'} = 'P'; $location{'7433'} = 'TRONDHEIM';
$borough_number{'7434'} = '1601'; $type{'7434'} = 'P'; $location{'7434'} = 'TRONDHEIM';
$borough_number{'7435'} = '1601'; $type{'7435'} = 'P'; $location{'7435'} = 'TRONDHEIM';
$borough_number{'7436'} = '1601'; $type{'7436'} = 'P'; $location{'7436'} = 'TRONDHEIM';
$borough_number{'7437'} = '1601'; $type{'7437'} = 'P'; $location{'7437'} = 'TRONDHEIM';
$borough_number{'7438'} = '1601'; $type{'7438'} = 'P'; $location{'7438'} = 'TRONDHEIM';
$borough_number{'7439'} = '1601'; $type{'7439'} = 'P'; $location{'7439'} = 'TRONDHEIM';
$borough_number{'7440'} = '1601'; $type{'7440'} = 'P'; $location{'7440'} = 'TRONDHEIM';
$borough_number{'7441'} = '1601'; $type{'7441'} = 'P'; $location{'7441'} = 'TRONDHEIM';
$borough_number{'7442'} = '1601'; $type{'7442'} = 'P'; $location{'7442'} = 'TRONDHEIM';
$borough_number{'7443'} = '1601'; $type{'7443'} = 'P'; $location{'7443'} = 'TRONDHEIM';
$borough_number{'7444'} = '1601'; $type{'7444'} = 'P'; $location{'7444'} = 'TRONDHEIM';
$borough_number{'7445'} = '1601'; $type{'7445'} = 'P'; $location{'7445'} = 'TRONDHEIM';
$borough_number{'7446'} = '1601'; $type{'7446'} = 'P'; $location{'7446'} = 'TRONDHEIM';
$borough_number{'7447'} = '1601'; $type{'7447'} = 'P'; $location{'7447'} = 'TRONDHEIM';
$borough_number{'7448'} = '1601'; $type{'7448'} = 'P'; $location{'7448'} = 'TRONDHEIM';
$borough_number{'7449'} = '1601'; $type{'7449'} = 'P'; $location{'7449'} = 'TRONDHEIM';
$borough_number{'7450'} = '1601'; $type{'7450'} = 'P'; $location{'7450'} = 'TRONDHEIM';
$borough_number{'7451'} = '1601'; $type{'7451'} = 'P'; $location{'7451'} = 'TRONDHEIM';
$borough_number{'7452'} = '1601'; $type{'7452'} = 'P'; $location{'7452'} = 'TRONDHEIM';
$borough_number{'7453'} = '1601'; $type{'7453'} = 'P'; $location{'7453'} = 'TRONDHEIM';
$borough_number{'7456'} = '1601'; $type{'7456'} = 'P'; $location{'7456'} = 'TRONDHEIM';
$borough_number{'7457'} = '1601'; $type{'7457'} = 'P'; $location{'7457'} = 'TRONDHEIM';
$borough_number{'7458'} = '1601'; $type{'7458'} = 'P'; $location{'7458'} = 'TRONDHEIM';
$borough_number{'7459'} = '1601'; $type{'7459'} = 'P'; $location{'7459'} = 'TRONDHEIM';
$borough_number{'7462'} = '1601'; $type{'7462'} = 'S'; $location{'7462'} = 'TRONDHEIM';
$borough_number{'7463'} = '1601'; $type{'7463'} = 'S'; $location{'7463'} = 'TRONDHEIM';
$borough_number{'7464'} = '1601'; $type{'7464'} = 'K'; $location{'7464'} = 'TRONDHEIM';
$borough_number{'7465'} = '1601'; $type{'7465'} = 'K'; $location{'7465'} = 'TRONDHEIM';
$borough_number{'7466'} = '1601'; $type{'7466'} = 'K'; $location{'7466'} = 'TRONDHEIM';
$borough_number{'7467'} = '1601'; $type{'7467'} = 'K'; $location{'7467'} = 'TRONDHEIM';
$borough_number{'7468'} = '1601'; $type{'7468'} = 'K'; $location{'7468'} = 'TRONDHEIM';
$borough_number{'7469'} = '1601'; $type{'7469'} = 'K'; $location{'7469'} = 'TRONDHEIM';
$borough_number{'7472'} = '1601'; $type{'7472'} = 'P'; $location{'7472'} = 'TRONDHEIM';
$borough_number{'7473'} = '1601'; $type{'7473'} = 'P'; $location{'7473'} = 'TRONDHEIM';
$borough_number{'7474'} = '1601'; $type{'7474'} = 'P'; $location{'7474'} = 'TRONDHEIM';
$borough_number{'7475'} = '1601'; $type{'7475'} = 'P'; $location{'7475'} = 'TRONDHEIM';
$borough_number{'7476'} = '1601'; $type{'7476'} = 'P'; $location{'7476'} = 'TRONDHEIM';
$borough_number{'7477'} = '1601'; $type{'7477'} = 'P'; $location{'7477'} = 'TRONDHEIM';
$borough_number{'7478'} = '1601'; $type{'7478'} = 'P'; $location{'7478'} = 'TRONDHEIM';
$borough_number{'7479'} = '1601'; $type{'7479'} = 'P'; $location{'7479'} = 'TRONDHEIM';
$borough_number{'7481'} = '1601'; $type{'7481'} = 'P'; $location{'7481'} = 'TRONDHEIM';
$borough_number{'7483'} = '1601'; $type{'7483'} = 'S'; $location{'7483'} = 'TRONDHEIM';
$borough_number{'7484'} = '1601'; $type{'7484'} = 'S'; $location{'7484'} = 'TRONDHEIM';
$borough_number{'7485'} = '1601'; $type{'7485'} = 'S'; $location{'7485'} = 'TRONDHEIM';
$borough_number{'7486'} = '1601'; $type{'7486'} = 'S'; $location{'7486'} = 'TRONDHEIM';
$borough_number{'7488'} = '1601'; $type{'7488'} = 'S'; $location{'7488'} = 'TRONDHEIM';
$borough_number{'7489'} = '1601'; $type{'7489'} = 'S'; $location{'7489'} = 'TRONDHEIM';
$borough_number{'7491'} = '1601'; $type{'7491'} = 'S'; $location{'7491'} = 'TRONDHEIM';
$borough_number{'7492'} = '1601'; $type{'7492'} = 'S'; $location{'7492'} = 'TRONDHEIM';
$borough_number{'7493'} = '1601'; $type{'7493'} = 'S'; $location{'7493'} = 'TRONDHEIM';
$borough_number{'7495'} = '1601'; $type{'7495'} = 'S'; $location{'7495'} = 'TRONDHEIM';
$borough_number{'7496'} = '1601'; $type{'7496'} = 'S'; $location{'7496'} = 'TRONDHEIM';
$borough_number{'7498'} = '1601'; $type{'7498'} = 'S'; $location{'7498'} = 'TRONDHEIM';
$borough_number{'7499'} = '1601'; $type{'7499'} = 'S'; $location{'7499'} = 'TRONDHEIM';
$borough_number{'7500'} = '1714'; $type{'7500'} = 'G'; $location{'7500'} = 'STJRDAL';
$borough_number{'7501'} = '1714'; $type{'7501'} = 'P'; $location{'7501'} = 'STJRDAL';
$borough_number{'7506'} = '1714'; $type{'7506'} = 'S'; $location{'7506'} = 'STJRDAL';
$borough_number{'7508'} = '1714'; $type{'7508'} = 'P'; $location{'7508'} = 'STJRDAL';
$borough_number{'7510'} = '1714'; $type{'7510'} = 'B'; $location{'7510'} = 'SKATVAL';
$borough_number{'7517'} = '1714'; $type{'7517'} = 'G'; $location{'7517'} = 'HELL';
$borough_number{'7519'} = '1714'; $type{'7519'} = 'G'; $location{'7519'} = 'ELVARLI';
$borough_number{'7520'} = '1714'; $type{'7520'} = 'G'; $location{'7520'} = 'HEGRA';
$borough_number{'7525'} = '1714'; $type{'7525'} = 'G'; $location{'7525'} = 'FLORNES';
$borough_number{'7529'} = '1714'; $type{'7529'} = 'P'; $location{'7529'} = 'HEGRA';
$borough_number{'7530'} = '1711'; $type{'7530'} = 'G'; $location{'7530'} = 'MERKER';
$borough_number{'7531'} = '1711'; $type{'7531'} = 'P'; $location{'7531'} = 'MERKER';
$borough_number{'7533'} = '1711'; $type{'7533'} = 'G'; $location{'7533'} = 'KOPPER';
$borough_number{'7540'} = '1662'; $type{'7540'} = 'G'; $location{'7540'} = 'KLBU';
$borough_number{'7541'} = '1662'; $type{'7541'} = 'P'; $location{'7541'} = 'KLBU';
$borough_number{'7549'} = '1662'; $type{'7549'} = 'G'; $location{'7549'} = 'TANEM';
$borough_number{'7550'} = '1663'; $type{'7550'} = 'G'; $location{'7550'} = 'HOMMELVIK';
$borough_number{'7551'} = '1663'; $type{'7551'} = 'P'; $location{'7551'} = 'HOMMELVIK';
$borough_number{'7560'} = '1663'; $type{'7560'} = 'G'; $location{'7560'} = 'VIKHAMMER';
$borough_number{'7562'} = '1663'; $type{'7562'} = 'G'; $location{'7562'} = 'HUNDHAMAREN';
$borough_number{'7563'} = '1663'; $type{'7563'} = 'G'; $location{'7563'} = 'MALVIK';
$borough_number{'7566'} = '1663'; $type{'7566'} = 'P'; $location{'7566'} = 'VIKHAMMER';
$borough_number{'7570'} = '1714'; $type{'7570'} = 'P'; $location{'7570'} = 'HELL';
$borough_number{'7580'} = '1664'; $type{'7580'} = 'G'; $location{'7580'} = 'SELBU';
$borough_number{'7581'} = '1664'; $type{'7581'} = 'P'; $location{'7581'} = 'SELBU';
$borough_number{'7583'} = '1664'; $type{'7583'} = 'P'; $location{'7583'} = 'SELBU';
$borough_number{'7584'} = '1664'; $type{'7584'} = 'G'; $location{'7584'} = 'SELBUSTRAND';
$borough_number{'7586'} = '1664'; $type{'7586'} = 'P'; $location{'7586'} = 'SELBUSTRAND';
$borough_number{'7590'} = '1665'; $type{'7590'} = 'G'; $location{'7590'} = 'TYDAL';
$borough_number{'7591'} = '1665'; $type{'7591'} = 'P'; $location{'7591'} = 'TYDAL';
$borough_number{'7596'} = '1664'; $type{'7596'} = 'G'; $location{'7596'} = 'FLAKNAN';
$borough_number{'7600'} = '1719'; $type{'7600'} = 'G'; $location{'7600'} = 'LEVANGER';
$borough_number{'7601'} = '1719'; $type{'7601'} = 'P'; $location{'7601'} = 'LEVANGER';
$borough_number{'7609'} = '1719'; $type{'7609'} = 'S'; $location{'7609'} = 'LEVANGER';
$borough_number{'7610'} = '1719'; $type{'7610'} = 'P'; $location{'7610'} = 'LEVANGER';
$borough_number{'7619'} = '1719'; $type{'7619'} = 'P'; $location{'7619'} = 'SKOGN';
$borough_number{'7620'} = '1719'; $type{'7620'} = 'G'; $location{'7620'} = 'SKOGN';
$borough_number{'7622'} = '1719'; $type{'7622'} = 'G'; $location{'7622'} = 'MARKABYGDA';
$borough_number{'7623'} = '1719'; $type{'7623'} = 'G'; $location{'7623'} = 'RONGLAN';
$borough_number{'7624'} = '1719'; $type{'7624'} = 'G'; $location{'7624'} = 'EKNE';
$borough_number{'7629'} = '1719'; $type{'7629'} = 'G'; $location{'7629'} = 'YTTERY';
$borough_number{'7630'} = '1719'; $type{'7630'} = 'G'; $location{'7630'} = 'SEN';
$borough_number{'7631'} = '1719'; $type{'7631'} = 'P'; $location{'7631'} = 'SEN';
$borough_number{'7632'} = '1719'; $type{'7632'} = 'G'; $location{'7632'} = 'SENFJORD';
$borough_number{'7633'} = '1717'; $type{'7633'} = 'G'; $location{'7633'} = 'FROSTA';
$borough_number{'7634'} = '1717'; $type{'7634'} = 'P'; $location{'7634'} = 'FROSTA';
$borough_number{'7650'} = '1721'; $type{'7650'} = 'G'; $location{'7650'} = 'VERDAL';
$borough_number{'7651'} = '1721'; $type{'7651'} = 'P'; $location{'7651'} = 'VERDAL';
$borough_number{'7658'} = '1721'; $type{'7658'} = 'P'; $location{'7658'} = 'VERDAL';
$borough_number{'7659'} = '1721'; $type{'7659'} = 'S'; $location{'7659'} = 'VERDAL';
$borough_number{'7660'} = '1721'; $type{'7660'} = 'B'; $location{'7660'} = 'VUKU';
$borough_number{'7663'} = '1721'; $type{'7663'} = 'G'; $location{'7663'} = 'STIKLESTAD';
$borough_number{'7670'} = '1729'; $type{'7670'} = 'G'; $location{'7670'} = 'INDERY';
$borough_number{'7671'} = '1729'; $type{'7671'} = 'P'; $location{'7671'} = 'INDERY';
$borough_number{'7690'} = '1723'; $type{'7690'} = 'B'; $location{'7690'} = 'MOSVIK';
$borough_number{'7701'} = '1702'; $type{'7701'} = 'P'; $location{'7701'} = 'STEINKJER';
$borough_number{'7702'} = '1702'; $type{'7702'} = 'P'; $location{'7702'} = 'STEINKJER';
$borough_number{'7703'} = '1702'; $type{'7703'} = 'P'; $location{'7703'} = 'STEINKJER';
$borough_number{'7704'} = '1702'; $type{'7704'} = 'P'; $location{'7704'} = 'STEINKJER';
$borough_number{'7705'} = '1702'; $type{'7705'} = 'P'; $location{'7705'} = 'STEINKJER';
$borough_number{'7707'} = '1702'; $type{'7707'} = 'P'; $location{'7707'} = 'STEINKJER';
$borough_number{'7708'} = '1702'; $type{'7708'} = 'P'; $location{'7708'} = 'STEINKJER';
$borough_number{'7709'} = '1702'; $type{'7709'} = 'P'; $location{'7709'} = 'STEINKJER';
$borough_number{'7710'} = '1702'; $type{'7710'} = 'B'; $location{'7710'} = 'SPARBU';
$borough_number{'7711'} = '1702'; $type{'7711'} = 'G'; $location{'7711'} = 'STEINKJER';
$borough_number{'7712'} = '1702'; $type{'7712'} = 'G'; $location{'7712'} = 'STEINKJER';
$borough_number{'7713'} = '1702'; $type{'7713'} = 'G'; $location{'7713'} = 'STEINKJER';
$borough_number{'7715'} = '1702'; $type{'7715'} = 'G'; $location{'7715'} = 'STEINKJER';
$borough_number{'7716'} = '1702'; $type{'7716'} = 'G'; $location{'7716'} = 'STEINKJER';
$borough_number{'7717'} = '1702'; $type{'7717'} = 'G'; $location{'7717'} = 'STEINKJER';
$borough_number{'7718'} = '1702'; $type{'7718'} = 'G'; $location{'7718'} = 'STEINKJER';
$borough_number{'7724'} = '1702'; $type{'7724'} = 'G'; $location{'7724'} = 'STEINKJER';
$borough_number{'7725'} = '1702'; $type{'7725'} = 'G'; $location{'7725'} = 'STEINKJER';
$borough_number{'7726'} = '1702'; $type{'7726'} = 'P'; $location{'7726'} = 'STEINKJER';
$borough_number{'7728'} = '1702'; $type{'7728'} = 'S'; $location{'7728'} = 'STEINKJER';
$borough_number{'7729'} = '1702'; $type{'7729'} = 'S'; $location{'7729'} = 'STEINKJER';
$borough_number{'7730'} = '1702'; $type{'7730'} = 'G'; $location{'7730'} = 'BEITSTAD';
$borough_number{'7732'} = '1702'; $type{'7732'} = 'G'; $location{'7732'} = 'STEINKJER';
$borough_number{'7734'} = '1702'; $type{'7734'} = 'K'; $location{'7734'} = 'STEINKJER';
$borough_number{'7735'} = '1702'; $type{'7735'} = 'K'; $location{'7735'} = 'STEINKJER';
$borough_number{'7736'} = '1702'; $type{'7736'} = 'K'; $location{'7736'} = 'STEINKJER';
$borough_number{'7737'} = '1702'; $type{'7737'} = 'K'; $location{'7737'} = 'STEINKJER';
$borough_number{'7738'} = '1702'; $type{'7738'} = 'K'; $location{'7738'} = 'STEINKJER';
$borough_number{'7739'} = '1702'; $type{'7739'} = 'P'; $location{'7739'} = 'BEITSTAD';
$borough_number{'7740'} = '1633'; $type{'7740'} = 'B'; $location{'7740'} = 'STEINSDALEN';
$borough_number{'7742'} = '1633'; $type{'7742'} = 'B'; $location{'7742'} = 'YTTERVG';
$borough_number{'7744'} = '1633'; $type{'7744'} = 'G'; $location{'7744'} = 'HEPSY';
$borough_number{'7745'} = '1749'; $type{'7745'} = 'G'; $location{'7745'} = 'OPPLAND';
$borough_number{'7746'} = '1749'; $type{'7746'} = 'G'; $location{'7746'} = 'HASVG';
$borough_number{'7748'} = '1633'; $type{'7748'} = 'B'; $location{'7748'} = 'STERVIK';
$borough_number{'7750'} = '1725'; $type{'7750'} = 'G'; $location{'7750'} = 'NAMDALSEID';
$borough_number{'7751'} = '1725'; $type{'7751'} = 'P'; $location{'7751'} = 'NAMDALSEID';
$borough_number{'7760'} = '1736'; $type{'7760'} = 'G'; $location{'7760'} = 'SNSA';
$borough_number{'7761'} = '1736'; $type{'7761'} = 'P'; $location{'7761'} = 'SNSA';
$borough_number{'7770'} = '1749'; $type{'7770'} = 'G'; $location{'7770'} = 'FLATANGER';
$borough_number{'7771'} = '1749'; $type{'7771'} = 'P'; $location{'7771'} = 'FLATANGER';
$borough_number{'7777'} = '1725'; $type{'7777'} = 'B'; $location{'7777'} = 'NORD-STATLAND';
$borough_number{'7790'} = '1724'; $type{'7790'} = 'G'; $location{'7790'} = 'MALM';
$borough_number{'7791'} = '1724'; $type{'7791'} = 'P'; $location{'7791'} = 'MALM';
$borough_number{'7796'} = '1724'; $type{'7796'} = 'B'; $location{'7796'} = 'FOLLAFOSS';
$borough_number{'7797'} = '1724'; $type{'7797'} = 'G'; $location{'7797'} = 'VERRABOTN';
$borough_number{'7800'} = '1703'; $type{'7800'} = 'G'; $location{'7800'} = 'NAMSOS';
$borough_number{'7801'} = '1703'; $type{'7801'} = 'P'; $location{'7801'} = 'NAMSOS';
$borough_number{'7808'} = '1703'; $type{'7808'} = 'P'; $location{'7808'} = 'NAMSOS';
$borough_number{'7809'} = '1703'; $type{'7809'} = 'S'; $location{'7809'} = 'NAMSOS';
$borough_number{'7817'} = '1748'; $type{'7817'} = 'G'; $location{'7817'} = 'SALSNES';
$borough_number{'7818'} = '1751'; $type{'7818'} = 'G'; $location{'7818'} = 'LUND';
$borough_number{'7819'} = '1703'; $type{'7819'} = 'G'; $location{'7819'} = 'FOSSLANDSOSEN';
$borough_number{'7820'} = '1703'; $type{'7820'} = 'B'; $location{'7820'} = 'SPILLUM';
$borough_number{'7822'} = '1703'; $type{'7822'} = 'B'; $location{'7822'} = 'BANGSUND';
$borough_number{'7856'} = '1748'; $type{'7856'} = 'G'; $location{'7856'} = 'JA';
$borough_number{'7860'} = '1744'; $type{'7860'} = 'G'; $location{'7860'} = 'SKAGE I NAMDALEN';
$borough_number{'7863'} = '1744'; $type{'7863'} = 'G'; $location{'7863'} = 'OVERHALLA';
$borough_number{'7864'} = '1744'; $type{'7864'} = 'P'; $location{'7864'} = 'OVERHALLA';
$borough_number{'7869'} = '1744'; $type{'7869'} = 'P'; $location{'7869'} = 'SKAGE I NAMDALEN';
$borough_number{'7870'} = '1742'; $type{'7870'} = 'G'; $location{'7870'} = 'GRONG';
$borough_number{'7871'} = '1742'; $type{'7871'} = 'P'; $location{'7871'} = 'GRONG';
$borough_number{'7873'} = '1742'; $type{'7873'} = 'B'; $location{'7873'} = 'HARRAN';
$borough_number{'7882'} = '1738'; $type{'7882'} = 'B'; $location{'7882'} = 'NORDLI';
$borough_number{'7884'} = '1738'; $type{'7884'} = 'B'; $location{'7884'} = 'SRLI';
$borough_number{'7890'} = '1740'; $type{'7890'} = 'B'; $location{'7890'} = 'NAMSSKOGAN';
$borough_number{'7892'} = '1740'; $type{'7892'} = 'B'; $location{'7892'} = 'TRONES';
$borough_number{'7893'} = '1740'; $type{'7893'} = 'G'; $location{'7893'} = 'SKOROVATN';
$borough_number{'7896'} = '1740'; $type{'7896'} = 'G'; $location{'7896'} = 'BREKKVASSELV';
$borough_number{'7898'} = '1739'; $type{'7898'} = 'B'; $location{'7898'} = 'LIMINGEN';
$borough_number{'7900'} = '1750'; $type{'7900'} = 'B'; $location{'7900'} = 'RRVIK';
$borough_number{'7901'} = '1750'; $type{'7901'} = 'P'; $location{'7901'} = 'RRVIK';
$borough_number{'7940'} = '1751'; $type{'7940'} = 'B'; $location{'7940'} = 'OTTERSY';
$borough_number{'7944'} = '1751'; $type{'7944'} = 'G'; $location{'7944'} = 'INDRE NRY';
$borough_number{'7950'} = '1751'; $type{'7950'} = 'G'; $location{'7950'} = 'ABELVR';
$borough_number{'7960'} = '1751'; $type{'7960'} = 'G'; $location{'7960'} = 'SALSBRUKET';
$borough_number{'7970'} = '1751'; $type{'7970'} = 'G'; $location{'7970'} = 'KOLVEREID';
$borough_number{'7971'} = '1751'; $type{'7971'} = 'P'; $location{'7971'} = 'KOLVEREID';
$borough_number{'7973'} = '1751'; $type{'7973'} = 'G'; $location{'7973'} = 'GJERDINGA';
$borough_number{'7976'} = '1743'; $type{'7976'} = 'G'; $location{'7976'} = 'KONGSMOEN';
$borough_number{'7977'} = '1743'; $type{'7977'} = 'B'; $location{'7977'} = 'HYLANDET';
$borough_number{'7980'} = '1811'; $type{'7980'} = 'B'; $location{'7980'} = 'TERRK';
$borough_number{'7981'} = '1811'; $type{'7981'} = 'G'; $location{'7981'} = 'HARANGSFJORD';
$borough_number{'7982'} = '1811'; $type{'7982'} = 'B'; $location{'7982'} = 'BINDALSEIDET';
$borough_number{'7985'} = '1751'; $type{'7985'} = 'B'; $location{'7985'} = 'FOLDEREID';
$borough_number{'7990'} = '1751'; $type{'7990'} = 'G'; $location{'7990'} = 'NAUSTBUKTA';
$borough_number{'7993'} = '1755'; $type{'7993'} = 'G'; $location{'7993'} = 'GUTVIK';
$borough_number{'7994'} = '1755'; $type{'7994'} = 'B'; $location{'7994'} = 'LEKA';
$borough_number{'8001'} = '1804'; $type{'8001'} = 'P'; $location{'8001'} = 'BOD';
$borough_number{'8002'} = '1804'; $type{'8002'} = 'S'; $location{'8002'} = 'BOD';
$borough_number{'8003'} = '1804'; $type{'8003'} = 'G'; $location{'8003'} = 'BOD';
$borough_number{'8004'} = '1804'; $type{'8004'} = 'G'; $location{'8004'} = 'BOD';
$borough_number{'8005'} = '1804'; $type{'8005'} = 'G'; $location{'8005'} = 'BOD';
$borough_number{'8006'} = '1804'; $type{'8006'} = 'G'; $location{'8006'} = 'BOD';
$borough_number{'8007'} = '1804'; $type{'8007'} = 'G'; $location{'8007'} = 'BOD';
$borough_number{'8008'} = '1804'; $type{'8008'} = 'G'; $location{'8008'} = 'BOD';
$borough_number{'8009'} = '1804'; $type{'8009'} = 'G'; $location{'8009'} = 'BOD';
$borough_number{'8010'} = '1804'; $type{'8010'} = 'G'; $location{'8010'} = 'BOD';
$borough_number{'8011'} = '1804'; $type{'8011'} = 'G'; $location{'8011'} = 'BOD';
$borough_number{'8012'} = '1804'; $type{'8012'} = 'G'; $location{'8012'} = 'BOD';
$borough_number{'8013'} = '1804'; $type{'8013'} = 'G'; $location{'8013'} = 'BOD';
$borough_number{'8014'} = '1804'; $type{'8014'} = 'G'; $location{'8014'} = 'BOD';
$borough_number{'8015'} = '1804'; $type{'8015'} = 'G'; $location{'8015'} = 'BOD';
$borough_number{'8016'} = '1804'; $type{'8016'} = 'G'; $location{'8016'} = 'BOD';
$borough_number{'8019'} = '1804'; $type{'8019'} = 'G'; $location{'8019'} = 'BOD';
$borough_number{'8020'} = '1804'; $type{'8020'} = 'G'; $location{'8020'} = 'BOD';
$borough_number{'8021'} = '1804'; $type{'8021'} = 'G'; $location{'8021'} = 'BOD';
$borough_number{'8022'} = '1804'; $type{'8022'} = 'G'; $location{'8022'} = 'BOD';
$borough_number{'8023'} = '1804'; $type{'8023'} = 'G'; $location{'8023'} = 'BOD';
$borough_number{'8026'} = '1804'; $type{'8026'} = 'G'; $location{'8026'} = 'BOD';
$borough_number{'8027'} = '1804'; $type{'8027'} = 'G'; $location{'8027'} = 'BOD';
$borough_number{'8028'} = '1804'; $type{'8028'} = 'G'; $location{'8028'} = 'BOD';
$borough_number{'8029'} = '1804'; $type{'8029'} = 'G'; $location{'8029'} = 'BOD';
$borough_number{'8030'} = '1804'; $type{'8030'} = 'G'; $location{'8030'} = 'BOD';
$borough_number{'8031'} = '1804'; $type{'8031'} = 'P'; $location{'8031'} = 'BOD';
$borough_number{'8032'} = '1804'; $type{'8032'} = 'P'; $location{'8032'} = 'BOD';
$borough_number{'8037'} = '1804'; $type{'8037'} = 'S'; $location{'8037'} = 'BOD';
$borough_number{'8038'} = '1804'; $type{'8038'} = 'S'; $location{'8038'} = 'BOD';
$borough_number{'8039'} = '1804'; $type{'8039'} = 'S'; $location{'8039'} = 'BOD';
$borough_number{'8041'} = '1804'; $type{'8041'} = 'S'; $location{'8041'} = 'BOD';
$borough_number{'8047'} = '1804'; $type{'8047'} = 'K'; $location{'8047'} = 'BOD';
$borough_number{'8048'} = '1804'; $type{'8048'} = 'K'; $location{'8048'} = 'BOD';
$borough_number{'8049'} = '1804'; $type{'8049'} = 'K'; $location{'8049'} = 'BOD';
$borough_number{'8050'} = '1804'; $type{'8050'} = 'G'; $location{'8050'} = 'TVERLANDET';
$borough_number{'8056'} = '1804'; $type{'8056'} = 'B'; $location{'8056'} = 'SALTSTRAUMEN';
$borough_number{'8058'} = '1804'; $type{'8058'} = 'P'; $location{'8058'} = 'TVERLANDET';
$borough_number{'8063'} = '1857'; $type{'8063'} = 'B'; $location{'8063'} = 'VRY';
$borough_number{'8064'} = '1856'; $type{'8064'} = 'B'; $location{'8064'} = 'RST';
$borough_number{'8070'} = '1804'; $type{'8070'} = 'G'; $location{'8070'} = 'BOD';
$borough_number{'8071'} = '1804'; $type{'8071'} = 'G'; $location{'8071'} = 'BOD';
$borough_number{'8072'} = '1804'; $type{'8072'} = 'G'; $location{'8072'} = 'BOD';
$borough_number{'8073'} = '1804'; $type{'8073'} = 'G'; $location{'8073'} = 'BOD';
$borough_number{'8074'} = '1804'; $type{'8074'} = 'G'; $location{'8074'} = 'BOD';
$borough_number{'8075'} = '1804'; $type{'8075'} = 'G'; $location{'8075'} = 'BOD';
$borough_number{'8076'} = '1804'; $type{'8076'} = 'G'; $location{'8076'} = 'BOD';
$borough_number{'8079'} = '1804'; $type{'8079'} = 'G'; $location{'8079'} = 'BOD';
$borough_number{'8084'} = '1804'; $type{'8084'} = 'P'; $location{'8084'} = 'BOD';
$borough_number{'8086'} = '1804'; $type{'8086'} = 'P'; $location{'8086'} = 'BOD';
$borough_number{'8087'} = '1804'; $type{'8087'} = 'P'; $location{'8087'} = 'BOD';
$borough_number{'8088'} = '1804'; $type{'8088'} = 'P'; $location{'8088'} = 'BOD';
$borough_number{'8089'} = '1804'; $type{'8089'} = 'P'; $location{'8089'} = 'BOD';
$borough_number{'8091'} = '1804'; $type{'8091'} = 'P'; $location{'8091'} = 'BOD';
$borough_number{'8092'} = '1804'; $type{'8092'} = 'P'; $location{'8092'} = 'BOD';
$borough_number{'8093'} = '1804'; $type{'8093'} = 'B'; $location{'8093'} = 'KJERRINGY';
$borough_number{'8094'} = '1838'; $type{'8094'} = 'B'; $location{'8094'} = 'FLEINVR';
$borough_number{'8095'} = '1804'; $type{'8095'} = 'B'; $location{'8095'} = 'HELLIGVR';
$borough_number{'8096'} = '1804'; $type{'8096'} = 'G'; $location{'8096'} = 'BLIKSVR';
$borough_number{'8097'} = '1804'; $type{'8097'} = 'G'; $location{'8097'} = 'GIVR';
$borough_number{'8098'} = '1804'; $type{'8098'} = 'G'; $location{'8098'} = 'LANDEGODE';
$borough_number{'8099'} = '2211'; $type{'8099'} = 'G'; $location{'8099'} = 'JAN MAYEN';
$borough_number{'8100'} = '1804'; $type{'8100'} = 'G'; $location{'8100'} = 'MISVR';
$borough_number{'8102'} = '1804'; $type{'8102'} = 'G'; $location{'8102'} = 'SKJERSTAD';
$borough_number{'8103'} = '1804'; $type{'8103'} = 'G'; $location{'8103'} = 'BREIVIK I SALTEN';
$borough_number{'8108'} = '1804'; $type{'8108'} = 'P'; $location{'8108'} = 'MISVR';
$borough_number{'8110'} = '1839'; $type{'8110'} = 'G'; $location{'8110'} = 'MOLDJORD';
$borough_number{'8114'} = '1839'; $type{'8114'} = 'G'; $location{'8114'} = 'TOLL';
$borough_number{'8118'} = '1839'; $type{'8118'} = 'P'; $location{'8118'} = 'MOLDJORD';
$borough_number{'8120'} = '1838'; $type{'8120'} = 'G'; $location{'8120'} = 'NYGRDSJEN';
$borough_number{'8128'} = '1839'; $type{'8128'} = 'G'; $location{'8128'} = 'YTRE BEIARN';
$borough_number{'8130'} = '1838'; $type{'8130'} = 'G'; $location{'8130'} = 'SANDHORNY';
$borough_number{'8135'} = '1838'; $type{'8135'} = 'B'; $location{'8135'} = 'SRARNY';
$borough_number{'8136'} = '1838'; $type{'8136'} = 'G'; $location{'8136'} = 'NORDARNY';
$borough_number{'8138'} = '1838'; $type{'8138'} = 'P'; $location{'8138'} = 'INNDYR';
$borough_number{'8140'} = '1838'; $type{'8140'} = 'G'; $location{'8140'} = 'INNDYR';
$borough_number{'8145'} = '1838'; $type{'8145'} = 'G'; $location{'8145'} = 'STORVIK';
$borough_number{'8146'} = '1837'; $type{'8146'} = 'G'; $location{'8146'} = 'REIP';
$borough_number{'8149'} = '1837'; $type{'8149'} = 'G'; $location{'8149'} = 'NEVERDAL';
$borough_number{'8150'} = '1837'; $type{'8150'} = 'G'; $location{'8150'} = 'RNES';
$borough_number{'8151'} = '1837'; $type{'8151'} = 'P'; $location{'8151'} = 'RNES';
$borough_number{'8157'} = '1837'; $type{'8157'} = 'G'; $location{'8157'} = 'MELY';
$borough_number{'8158'} = '1837'; $type{'8158'} = 'B'; $location{'8158'} = 'BOLGA';
$borough_number{'8159'} = '1837'; $type{'8159'} = 'B'; $location{'8159'} = 'STTT';
$borough_number{'8160'} = '1837'; $type{'8160'} = 'G'; $location{'8160'} = 'GLOMFJORD';
$borough_number{'8161'} = '1837'; $type{'8161'} = 'P'; $location{'8161'} = 'GLOMFJORD';
$borough_number{'8168'} = '1837'; $type{'8168'} = 'P'; $location{'8168'} = 'ENGAVGEN';
$borough_number{'8170'} = '1837'; $type{'8170'} = 'G'; $location{'8170'} = 'ENGAVGEN';
$borough_number{'8171'} = '1837'; $type{'8171'} = 'G'; $location{'8171'} = 'SVARTISEN GRD';
$borough_number{'8178'} = '1837'; $type{'8178'} = 'B'; $location{'8178'} = 'HALSA';
$borough_number{'8181'} = '1836'; $type{'8181'} = 'B'; $location{'8181'} = 'MYKEN';
$borough_number{'8182'} = '1836'; $type{'8182'} = 'G'; $location{'8182'} = 'MELFJORDBOTN';
$borough_number{'8184'} = '1837'; $type{'8184'} = 'G'; $location{'8184'} = 'GSKARDET';
$borough_number{'8185'} = '1836'; $type{'8185'} = 'B'; $location{'8185'} = 'VGAHOLMEN';
$borough_number{'8186'} = '1836'; $type{'8186'} = 'G'; $location{'8186'} = 'TJONGSFJORDEN';
$borough_number{'8187'} = '1836'; $type{'8187'} = 'B'; $location{'8187'} = 'JEKTVIK';
$borough_number{'8188'} = '1836'; $type{'8188'} = 'G'; $location{'8188'} = 'NORDVERNES';
$borough_number{'8189'} = '1836'; $type{'8189'} = 'G'; $location{'8189'} = 'GJERSVIKGRENDA';
$borough_number{'8190'} = '1836'; $type{'8190'} = 'B'; $location{'8190'} = 'SRFJORDEN';
$borough_number{'8193'} = '1836'; $type{'8193'} = 'B'; $location{'8193'} = 'RDY';
$borough_number{'8195'} = '1836'; $type{'8195'} = 'B'; $location{'8195'} = 'GJERY';
$borough_number{'8196'} = '1836'; $type{'8196'} = 'B'; $location{'8196'} = 'SELSYVIK';
$borough_number{'8197'} = '1836'; $type{'8197'} = 'G'; $location{'8197'} = 'STORSELSY';
$borough_number{'8198'} = '1836'; $type{'8198'} = 'G'; $location{'8198'} = 'NORDNESY';
$borough_number{'8200'} = '1841'; $type{'8200'} = 'G'; $location{'8200'} = 'FAUSKE';
$borough_number{'8201'} = '1841'; $type{'8201'} = 'P'; $location{'8201'} = 'FAUSKE';
$borough_number{'8202'} = '1841'; $type{'8202'} = 'P'; $location{'8202'} = 'FAUSKE';
$borough_number{'8205'} = '1841'; $type{'8205'} = 'S'; $location{'8205'} = 'FAUSKE';
$borough_number{'8210'} = '1841'; $type{'8210'} = 'G'; $location{'8210'} = 'FAUSKE';
$borough_number{'8215'} = '1841'; $type{'8215'} = 'G'; $location{'8215'} = 'VALNESFJORD';
$borough_number{'8220'} = '1845'; $type{'8220'} = 'G'; $location{'8220'} = 'RSVIK';
$borough_number{'8226'} = '1845'; $type{'8226'} = 'G'; $location{'8226'} = 'STRAUMEN';
$borough_number{'8230'} = '1841'; $type{'8230'} = 'G'; $location{'8230'} = 'SULITJELMA';
$borough_number{'8231'} = '1841'; $type{'8231'} = 'P'; $location{'8231'} = 'SULITJELMA';
$borough_number{'8232'} = '1845'; $type{'8232'} = 'P'; $location{'8232'} = 'STRAUMEN';
$borough_number{'8233'} = '1841'; $type{'8233'} = 'P'; $location{'8233'} = 'VALNESFJORD';
$borough_number{'8250'} = '1840'; $type{'8250'} = 'G'; $location{'8250'} = 'ROGNAN';
$borough_number{'8251'} = '1840'; $type{'8251'} = 'P'; $location{'8251'} = 'ROGNAN';
$borough_number{'8255'} = '1840'; $type{'8255'} = 'G'; $location{'8255'} = 'RKLAND';
$borough_number{'8256'} = '1840'; $type{'8256'} = 'P'; $location{'8256'} = 'RKLAND';
$borough_number{'8260'} = '1849'; $type{'8260'} = 'G'; $location{'8260'} = 'INNHAVET';
$borough_number{'8261'} = '1849'; $type{'8261'} = 'P'; $location{'8261'} = 'INNHAVET';
$borough_number{'8264'} = '1845'; $type{'8264'} = 'G'; $location{'8264'} = 'ENGAN';
$borough_number{'8266'} = '1845'; $type{'8266'} = 'G'; $location{'8266'} = 'MRSVIKBOTN';
$borough_number{'8270'} = '1850'; $type{'8270'} = 'G'; $location{'8270'} = 'DRAG';
$borough_number{'8271'} = '1850'; $type{'8271'} = 'P'; $location{'8271'} = 'DRAG';
$borough_number{'8273'} = '1850'; $type{'8273'} = 'G'; $location{'8273'} = 'NEVERVIK';
$borough_number{'8274'} = '1850'; $type{'8274'} = 'G'; $location{'8274'} = 'MUSKEN';
$borough_number{'8275'} = '1850'; $type{'8275'} = 'G'; $location{'8275'} = 'STORJORD I TYSFJORD';
$borough_number{'8276'} = '1849'; $type{'8276'} = 'G'; $location{'8276'} = 'ULVSVG';
$borough_number{'8281'} = '1848'; $type{'8281'} = 'P'; $location{'8281'} = 'LEINESFJORD';
$borough_number{'8283'} = '1848'; $type{'8283'} = 'G'; $location{'8283'} = 'LEINESFJORD';
$borough_number{'8285'} = '1848'; $type{'8285'} = 'G'; $location{'8285'} = 'LEINES';
$borough_number{'8286'} = '1848'; $type{'8286'} = 'G'; $location{'8286'} = 'NORDFOLD';
$borough_number{'8288'} = '1848'; $type{'8288'} = 'G'; $location{'8288'} = 'BOGY';
$borough_number{'8289'} = '1848'; $type{'8289'} = 'B'; $location{'8289'} = 'VG';
$borough_number{'8290'} = '1849'; $type{'8290'} = 'B'; $location{'8290'} = 'SKUTVIK';
$borough_number{'8294'} = '1849'; $type{'8294'} = 'G'; $location{'8294'} = 'HAMARY';
$borough_number{'8297'} = '1849'; $type{'8297'} = 'G'; $location{'8297'} = 'TRANY';
$borough_number{'8298'} = '1849'; $type{'8298'} = 'P'; $location{'8298'} = 'HAMARY';
$borough_number{'8300'} = '1865'; $type{'8300'} = 'G'; $location{'8300'} = 'SVOLVR';
$borough_number{'8301'} = '1865'; $type{'8301'} = 'P'; $location{'8301'} = 'SVOLVR';
$borough_number{'8305'} = '1865'; $type{'8305'} = 'S'; $location{'8305'} = 'SVOLVR';
$borough_number{'8309'} = '1865'; $type{'8309'} = 'P'; $location{'8309'} = 'KABELVG';
$borough_number{'8310'} = '1865'; $type{'8310'} = 'G'; $location{'8310'} = 'KABELVG';
$borough_number{'8311'} = '1865'; $type{'8311'} = 'P'; $location{'8311'} = 'HENNINGSVR';
$borough_number{'8312'} = '1865'; $type{'8312'} = 'G'; $location{'8312'} = 'HENNINGSVR';
$borough_number{'8313'} = '1865'; $type{'8313'} = 'G'; $location{'8313'} = 'KLEPPSTAD';
$borough_number{'8314'} = '1865'; $type{'8314'} = 'G'; $location{'8314'} = 'GIMSYSAND';
$borough_number{'8315'} = '1865'; $type{'8315'} = 'G'; $location{'8315'} = 'LAUKVIK';
$borough_number{'8316'} = '1865'; $type{'8316'} = 'G'; $location{'8316'} = 'LAUPSTAD';
$borough_number{'8317'} = '1866'; $type{'8317'} = 'G'; $location{'8317'} = 'STRNSTAD';
$borough_number{'8320'} = '1865'; $type{'8320'} = 'B'; $location{'8320'} = 'SKROVA';
$borough_number{'8322'} = '1865'; $type{'8322'} = 'G'; $location{'8322'} = 'BRETTESNES';
$borough_number{'8323'} = '1865'; $type{'8323'} = 'G'; $location{'8323'} = 'STORFJELL';
$borough_number{'8324'} = '1865'; $type{'8324'} = 'G'; $location{'8324'} = 'DIGERMULEN';
$borough_number{'8325'} = '1866'; $type{'8325'} = 'G'; $location{'8325'} = 'TENGELFJORD';
$borough_number{'8328'} = '1865'; $type{'8328'} = 'G'; $location{'8328'} = 'STOREMOLLA';
$borough_number{'8340'} = '1860'; $type{'8340'} = 'G'; $location{'8340'} = 'STAMSUND';
$borough_number{'8352'} = '1860'; $type{'8352'} = 'G'; $location{'8352'} = 'SENNESVIK';
$borough_number{'8360'} = '1860'; $type{'8360'} = 'B'; $location{'8360'} = 'BSTAD';
$borough_number{'8370'} = '1860'; $type{'8370'} = 'G'; $location{'8370'} = 'LEKNES';
$borough_number{'8372'} = '1860'; $type{'8372'} = 'G'; $location{'8372'} = 'GRAVDAL';
$borough_number{'8373'} = '1860'; $type{'8373'} = 'B'; $location{'8373'} = 'BALLSTAD';
$borough_number{'8375'} = '1860'; $type{'8375'} = 'S'; $location{'8375'} = 'LEKNES';
$borough_number{'8376'} = '1860'; $type{'8376'} = 'P'; $location{'8376'} = 'LEKNES';
$borough_number{'8377'} = '1860'; $type{'8377'} = 'P'; $location{'8377'} = 'GRAVDAL';
$borough_number{'8378'} = '1860'; $type{'8378'} = 'P'; $location{'8378'} = 'STAMSUND';
$borough_number{'8380'} = '1859'; $type{'8380'} = 'G'; $location{'8380'} = 'RAMBERG';
$borough_number{'8382'} = '1859'; $type{'8382'} = 'G'; $location{'8382'} = 'NAPP';
$borough_number{'8384'} = '1859'; $type{'8384'} = 'G'; $location{'8384'} = 'SUND I LOFOTEN';
$borough_number{'8387'} = '1859'; $type{'8387'} = 'G'; $location{'8387'} = 'FREDVANG';
$borough_number{'8388'} = '1859'; $type{'8388'} = 'P'; $location{'8388'} = 'RAMBERG';
$borough_number{'8390'} = '1874'; $type{'8390'} = 'G'; $location{'8390'} = 'REINE';
$borough_number{'8392'} = '1874'; $type{'8392'} = 'G'; $location{'8392'} = 'SRVGEN';
$borough_number{'8393'} = '1874'; $type{'8393'} = 'P'; $location{'8393'} = 'SRVGEN';
$borough_number{'8398'} = '1874'; $type{'8398'} = 'P'; $location{'8398'} = 'REINE';
$borough_number{'8400'} = '1870'; $type{'8400'} = 'G'; $location{'8400'} = 'SORTLAND';
$borough_number{'8401'} = '1870'; $type{'8401'} = 'P'; $location{'8401'} = 'SORTLAND';
$borough_number{'8405'} = '1870'; $type{'8405'} = 'S'; $location{'8405'} = 'SORTLAND';
$borough_number{'8407'} = '1870'; $type{'8407'} = 'G'; $location{'8407'} = 'GODFJORD';
$borough_number{'8408'} = '1868'; $type{'8408'} = 'G'; $location{'8408'} = 'SANDSET';
$borough_number{'8409'} = '1911'; $type{'8409'} = 'G'; $location{'8409'} = 'GULLESFJORD';
$borough_number{'8413'} = '1866'; $type{'8413'} = 'G'; $location{'8413'} = 'KVITNES';
$borough_number{'8414'} = '1866'; $type{'8414'} = 'G'; $location{'8414'} = 'HENNES';
$borough_number{'8415'} = '1866'; $type{'8415'} = 'P'; $location{'8415'} = 'HENNES';
$borough_number{'8426'} = '1868'; $type{'8426'} = 'G'; $location{'8426'} = 'BARKESTAD';
$borough_number{'8428'} = '1868'; $type{'8428'} = 'G'; $location{'8428'} = 'TUNSTAD';
$borough_number{'8430'} = '1868'; $type{'8430'} = 'G'; $location{'8430'} = 'MYRE';
$borough_number{'8432'} = '1868'; $type{'8432'} = 'G'; $location{'8432'} = 'ALSVG';
$borough_number{'8438'} = '1868'; $type{'8438'} = 'G'; $location{'8438'} = 'ST';
$borough_number{'8439'} = '1868'; $type{'8439'} = 'P'; $location{'8439'} = 'MYRE';
$borough_number{'8445'} = '1866'; $type{'8445'} = 'G'; $location{'8445'} = 'MELBU';
$borough_number{'8446'} = '1866'; $type{'8446'} = 'S'; $location{'8446'} = 'MELBU';
$borough_number{'8447'} = '1866'; $type{'8447'} = 'G'; $location{'8447'} = 'LONKAN';
$borough_number{'8448'} = '1866'; $type{'8448'} = 'G'; $location{'8448'} = 'MYRLAND';
$borough_number{'8450'} = '1866'; $type{'8450'} = 'B'; $location{'8450'} = 'STOKMARKNES';
$borough_number{'8452'} = '1866'; $type{'8452'} = 'S'; $location{'8452'} = 'STOKMARKNES';
$borough_number{'8455'} = '1866'; $type{'8455'} = 'P'; $location{'8455'} = 'STOKMARKNES';
$borough_number{'8459'} = '1866'; $type{'8459'} = 'P'; $location{'8459'} = 'MELBU';
$borough_number{'8465'} = '1867'; $type{'8465'} = 'P'; $location{'8465'} = 'STRAUMSJEN';
$borough_number{'8469'} = '1867'; $type{'8469'} = 'P'; $location{'8469'} = 'B I VESTERLEN';
$borough_number{'8470'} = '1867'; $type{'8470'} = 'G'; $location{'8470'} = 'B I VESTERLEN';
$borough_number{'8475'} = '1867'; $type{'8475'} = 'G'; $location{'8475'} = 'STRAUMSJEN';
$borough_number{'8480'} = '1871'; $type{'8480'} = 'G'; $location{'8480'} = 'ANDENES';
$borough_number{'8481'} = '1871'; $type{'8481'} = 'G'; $location{'8481'} = 'BLEIK';
$borough_number{'8483'} = '1871'; $type{'8483'} = 'P'; $location{'8483'} = 'ANDENES';
$borough_number{'8484'} = '1871'; $type{'8484'} = 'G'; $location{'8484'} = 'RISYHAMN';
$borough_number{'8485'} = '1871'; $type{'8485'} = 'G'; $location{'8485'} = 'DVERBERG';
$borough_number{'8488'} = '1871'; $type{'8488'} = 'G'; $location{'8488'} = 'NSS';
$borough_number{'8489'} = '1871'; $type{'8489'} = 'G'; $location{'8489'} = 'NORDMELA';
$borough_number{'8493'} = '1871'; $type{'8493'} = 'P'; $location{'8493'} = 'RISYHAMN';
$borough_number{'8501'} = '1805'; $type{'8501'} = 'P'; $location{'8501'} = 'NARVIK';
$borough_number{'8502'} = '1805'; $type{'8502'} = 'P'; $location{'8502'} = 'NARVIK';
$borough_number{'8503'} = '1805'; $type{'8503'} = 'P'; $location{'8503'} = 'NARVIK';
$borough_number{'8504'} = '1805'; $type{'8504'} = 'P'; $location{'8504'} = 'NARVIK';
$borough_number{'8505'} = '1805'; $type{'8505'} = 'P'; $location{'8505'} = 'NARVIK';
$borough_number{'8506'} = '1805'; $type{'8506'} = 'P'; $location{'8506'} = 'NARVIK';
$borough_number{'8507'} = '1805'; $type{'8507'} = 'P'; $location{'8507'} = 'NARVIK';
$borough_number{'8508'} = '1805'; $type{'8508'} = 'P'; $location{'8508'} = 'NARVIK';
$borough_number{'8509'} = '1805'; $type{'8509'} = 'P'; $location{'8509'} = 'NARVIK';
$borough_number{'8510'} = '1805'; $type{'8510'} = 'P'; $location{'8510'} = 'NARVIK';
$borough_number{'8512'} = '1805'; $type{'8512'} = 'S'; $location{'8512'} = 'NARVIK';
$borough_number{'8513'} = '1805'; $type{'8513'} = 'P'; $location{'8513'} = 'ANKENESSTRAND';
$borough_number{'8514'} = '1805'; $type{'8514'} = 'G'; $location{'8514'} = 'NARVIK';
$borough_number{'8515'} = '1805'; $type{'8515'} = 'G'; $location{'8515'} = 'NARVIK';
$borough_number{'8516'} = '1805'; $type{'8516'} = 'G'; $location{'8516'} = 'NARVIK';
$borough_number{'8517'} = '1805'; $type{'8517'} = 'G'; $location{'8517'} = 'NARVIK';
$borough_number{'8518'} = '1805'; $type{'8518'} = 'P'; $location{'8518'} = 'NARVIK';
$borough_number{'8520'} = '1805'; $type{'8520'} = 'G'; $location{'8520'} = 'ANKENESSTRAND';
$borough_number{'8522'} = '1805'; $type{'8522'} = 'G'; $location{'8522'} = 'BEISFJORD';
$borough_number{'8523'} = '1805'; $type{'8523'} = 'G'; $location{'8523'} = 'ELVEGARD';
$borough_number{'8530'} = '1805'; $type{'8530'} = 'G'; $location{'8530'} = 'BJERKVIK';
$borough_number{'8531'} = '1805'; $type{'8531'} = 'P'; $location{'8531'} = 'BJERKVIK';
$borough_number{'8533'} = '1853'; $type{'8533'} = 'G'; $location{'8533'} = 'BOGEN I OFOTEN';
$borough_number{'8534'} = '1853'; $type{'8534'} = 'G'; $location{'8534'} = 'LILAND';
$borough_number{'8535'} = '1853'; $type{'8535'} = 'G'; $location{'8535'} = 'TRSTAD';
$borough_number{'8536'} = '1853'; $type{'8536'} = 'G'; $location{'8536'} = 'EVENES';
$borough_number{'8539'} = '1853'; $type{'8539'} = 'P'; $location{'8539'} = 'BOGEN I OFOTEN';
$borough_number{'8540'} = '1854'; $type{'8540'} = 'G'; $location{'8540'} = 'BALLANGEN';
$borough_number{'8542'} = '1854'; $type{'8542'} = 'P'; $location{'8542'} = 'KJELDEBOTN';
$borough_number{'8543'} = '1854'; $type{'8543'} = 'G'; $location{'8543'} = 'KJELDEBOTN';
$borough_number{'8546'} = '1854'; $type{'8546'} = 'P'; $location{'8546'} = 'BALLANGEN';
$borough_number{'8550'} = '1851'; $type{'8550'} = 'G'; $location{'8550'} = 'LDINGEN';
$borough_number{'8551'} = '1851'; $type{'8551'} = 'P'; $location{'8551'} = 'LDINGEN';
$borough_number{'8581'} = '1851'; $type{'8581'} = 'G'; $location{'8581'} = 'VESTBYGD';
$borough_number{'8587'} = '1850'; $type{'8587'} = 'G'; $location{'8587'} = 'STOR';
$borough_number{'8590'} = '1850'; $type{'8590'} = 'G'; $location{'8590'} = 'KJPSVIK';
$borough_number{'8591'} = '1850'; $type{'8591'} = 'P'; $location{'8591'} = 'KJPSVIK';
$borough_number{'8601'} = '1833'; $type{'8601'} = 'P'; $location{'8601'} = 'MO I RANA';
$borough_number{'8602'} = '1833'; $type{'8602'} = 'P'; $location{'8602'} = 'MO I RANA';
$borough_number{'8603'} = '1833'; $type{'8603'} = 'P'; $location{'8603'} = 'MO I RANA';
$borough_number{'8604'} = '1833'; $type{'8604'} = 'P'; $location{'8604'} = 'MO I RANA';
$borough_number{'8605'} = '1833'; $type{'8605'} = 'K'; $location{'8605'} = 'MO I RANA';
$borough_number{'8606'} = '1833'; $type{'8606'} = 'K'; $location{'8606'} = 'MO I RANA';
$borough_number{'8607'} = '1833'; $type{'8607'} = 'S'; $location{'8607'} = 'MO I RANA';
$borough_number{'8608'} = '1833'; $type{'8608'} = 'P'; $location{'8608'} = 'MO I RANA';
$borough_number{'8610'} = '1833'; $type{'8610'} = 'G'; $location{'8610'} = 'MO I RANA';
$borough_number{'8613'} = '1833'; $type{'8613'} = 'G'; $location{'8613'} = 'MO I RANA';
$borough_number{'8614'} = '1833'; $type{'8614'} = 'G'; $location{'8614'} = 'MO I RANA';
$borough_number{'8615'} = '1833'; $type{'8615'} = 'G'; $location{'8615'} = 'SKONSENG';
$borough_number{'8616'} = '1833'; $type{'8616'} = 'B'; $location{'8616'} = 'MO I RANA';
$borough_number{'8617'} = '1833'; $type{'8617'} = 'G'; $location{'8617'} = 'DALSGRENDA';
$borough_number{'8618'} = '1833'; $type{'8618'} = 'B'; $location{'8618'} = 'MO I RANA';
$borough_number{'8622'} = '1833'; $type{'8622'} = 'G'; $location{'8622'} = 'MO I RANA';
$borough_number{'8624'} = '1833'; $type{'8624'} = 'G'; $location{'8624'} = 'MO I RANA';
$borough_number{'8626'} = '1833'; $type{'8626'} = 'G'; $location{'8626'} = 'MO I RANA';
$borough_number{'8629'} = '1833'; $type{'8629'} = 'G'; $location{'8629'} = 'SVARTISDAL';
$borough_number{'8630'} = '1833'; $type{'8630'} = 'G'; $location{'8630'} = 'STORFORSHEI';
$borough_number{'8634'} = '1833'; $type{'8634'} = 'K'; $location{'8634'} = 'MO I RANA';
$borough_number{'8635'} = '1833'; $type{'8635'} = 'K'; $location{'8635'} = 'POLARSIRKELEN';
$borough_number{'8638'} = '1833'; $type{'8638'} = 'P'; $location{'8638'} = 'STORFORSHEI';
$borough_number{'8640'} = '1832'; $type{'8640'} = 'G'; $location{'8640'} = 'HEMNESBERGET';
$borough_number{'8641'} = '1832'; $type{'8641'} = 'P'; $location{'8641'} = 'HEMNESBERGET';
$borough_number{'8642'} = '1832'; $type{'8642'} = 'B'; $location{'8642'} = 'FINNEIDFJORD';
$borough_number{'8643'} = '1832'; $type{'8643'} = 'B'; $location{'8643'} = 'BJERKA';
$borough_number{'8646'} = '1832'; $type{'8646'} = 'G'; $location{'8646'} = 'KORGEN';
$borough_number{'8647'} = '1832'; $type{'8647'} = 'G'; $location{'8647'} = 'BLEIKVASSLIA';
$borough_number{'8648'} = '1832'; $type{'8648'} = 'P'; $location{'8648'} = 'KORGEN';
$borough_number{'8651'} = '1824'; $type{'8651'} = 'P'; $location{'8651'} = 'MOSJEN';
$borough_number{'8654'} = '1824'; $type{'8654'} = 'S'; $location{'8654'} = 'MOSJEN';
$borough_number{'8655'} = '1824'; $type{'8655'} = 'F'; $location{'8655'} = 'MOSJEN';
$borough_number{'8656'} = '1824'; $type{'8656'} = 'G'; $location{'8656'} = 'MOSJEN';
$borough_number{'8657'} = '1824'; $type{'8657'} = 'G'; $location{'8657'} = 'MOSJEN';
$borough_number{'8658'} = '1824'; $type{'8658'} = 'G'; $location{'8658'} = 'MOSJEN';
$borough_number{'8659'} = '1824'; $type{'8659'} = 'G'; $location{'8659'} = 'MOSJEN';
$borough_number{'8661'} = '1824'; $type{'8661'} = 'G'; $location{'8661'} = 'MOSJEN';
$borough_number{'8663'} = '1824'; $type{'8663'} = 'G'; $location{'8663'} = 'MOSJEN';
$borough_number{'8664'} = '1824'; $type{'8664'} = 'G'; $location{'8664'} = 'MOSJEN';
$borough_number{'8665'} = '1824'; $type{'8665'} = 'G'; $location{'8665'} = 'MOSJEN';
$borough_number{'8672'} = '1824'; $type{'8672'} = 'G'; $location{'8672'} = 'ELSFJORD';
$borough_number{'8680'} = '1825'; $type{'8680'} = 'G'; $location{'8680'} = 'TROFORS';
$borough_number{'8681'} = '1825'; $type{'8681'} = 'P'; $location{'8681'} = 'TROFORS';
$borough_number{'8690'} = '1826'; $type{'8690'} = 'G'; $location{'8690'} = 'HATTFJELLDAL';
$borough_number{'8691'} = '1826'; $type{'8691'} = 'P'; $location{'8691'} = 'HATTFJELLDAL';
$borough_number{'8700'} = '1828'; $type{'8700'} = 'G'; $location{'8700'} = 'NESNA';
$borough_number{'8701'} = '1828'; $type{'8701'} = 'P'; $location{'8701'} = 'NESNA';
$borough_number{'8720'} = '1828'; $type{'8720'} = 'G'; $location{'8720'} = 'VIKHOLMEN';
$borough_number{'8723'} = '1828'; $type{'8723'} = 'G'; $location{'8723'} = 'HUSBY';
$borough_number{'8724'} = '1828'; $type{'8724'} = 'G'; $location{'8724'} = 'SAURA';
$borough_number{'8725'} = '1833'; $type{'8725'} = 'G'; $location{'8725'} = 'UTSKARPEN';
$borough_number{'8726'} = '1833'; $type{'8726'} = 'P'; $location{'8726'} = 'UTSKARPEN';
$borough_number{'8730'} = '1834'; $type{'8730'} = 'G'; $location{'8730'} = 'BRATLAND';
$borough_number{'8732'} = '1834'; $type{'8732'} = 'G'; $location{'8732'} = 'ALDRA';
$borough_number{'8733'} = '1834'; $type{'8733'} = 'G'; $location{'8733'} = 'STUVLAND';
$borough_number{'8735'} = '1834'; $type{'8735'} = 'G'; $location{'8735'} = 'STOKKVGEN';
$borough_number{'8740'} = '1834'; $type{'8740'} = 'G'; $location{'8740'} = 'NORD-SOLVR';
$borough_number{'8742'} = '1835'; $type{'8742'} = 'B'; $location{'8742'} = 'SELVR';
$borough_number{'8743'} = '1834'; $type{'8743'} = 'B'; $location{'8743'} = 'INDRE KVARY';
$borough_number{'8750'} = '1834'; $type{'8750'} = 'G'; $location{'8750'} = 'TONNES';
$borough_number{'8752'} = '1834'; $type{'8752'} = 'G'; $location{'8752'} = 'KONSVIKOSEN';
$borough_number{'8753'} = '1834'; $type{'8753'} = 'P'; $location{'8753'} = 'KONSVIKOSEN';
$borough_number{'8754'} = '1836'; $type{'8754'} = 'G'; $location{'8754'} = 'RESVIK';
$borough_number{'8762'} = '1834'; $type{'8762'} = 'B'; $location{'8762'} = 'SLENESET';
$borough_number{'8764'} = '1834'; $type{'8764'} = 'B'; $location{'8764'} = 'LOVUND';
$borough_number{'8766'} = '1834'; $type{'8766'} = 'G'; $location{'8766'} = 'LURY';
$borough_number{'8767'} = '1834'; $type{'8767'} = 'P'; $location{'8767'} = 'LURY';
$borough_number{'8770'} = '1835'; $type{'8770'} = 'B'; $location{'8770'} = 'TRNA';
$borough_number{'8800'} = '1820'; $type{'8800'} = 'G'; $location{'8800'} = 'SANDNESSJEN';
$borough_number{'8801'} = '1820'; $type{'8801'} = 'P'; $location{'8801'} = 'SANDNESSJEN';
$borough_number{'8805'} = '1820'; $type{'8805'} = 'S'; $location{'8805'} = 'SANDNESSJEN';
$borough_number{'8813'} = '1827'; $type{'8813'} = 'G'; $location{'8813'} = 'KOPARDAL';
$borough_number{'8820'} = '1827'; $type{'8820'} = 'G'; $location{'8820'} = 'DNNA';
$borough_number{'8826'} = '1827'; $type{'8826'} = 'G'; $location{'8826'} = 'NORDYVGEN';
$borough_number{'8827'} = '1827'; $type{'8827'} = 'P'; $location{'8827'} = 'DNNA';
$borough_number{'8830'} = '1827'; $type{'8830'} = 'B'; $location{'8830'} = 'VANDVE';
$borough_number{'8842'} = '1818'; $type{'8842'} = 'G'; $location{'8842'} = 'BRASY';
$borough_number{'8844'} = '1818'; $type{'8844'} = 'B'; $location{'8844'} = 'SANDVR';
$borough_number{'8850'} = '1818'; $type{'8850'} = 'G'; $location{'8850'} = 'HERY';
$borough_number{'8851'} = '1818'; $type{'8851'} = 'P'; $location{'8851'} = 'HERY';
$borough_number{'8852'} = '1818'; $type{'8852'} = 'P'; $location{'8852'} = 'HERY';
$borough_number{'8854'} = '1820'; $type{'8854'} = 'G'; $location{'8854'} = 'AUSTB';
$borough_number{'8860'} = '1820'; $type{'8860'} = 'B'; $location{'8860'} = 'TJTTA';
$borough_number{'8865'} = '1820'; $type{'8865'} = 'B'; $location{'8865'} = 'TRO';
$borough_number{'8870'} = '1816'; $type{'8870'} = 'G'; $location{'8870'} = 'VISTHUS';
$borough_number{'8880'} = '1820'; $type{'8880'} = 'B'; $location{'8880'} = 'BRYVGEN';
$borough_number{'8883'} = '1824'; $type{'8883'} = 'G'; $location{'8883'} = 'HUSVIKA';
$borough_number{'8890'} = '1822'; $type{'8890'} = 'G'; $location{'8890'} = 'LEIRFJORD';
$borough_number{'8891'} = '1822'; $type{'8891'} = 'P'; $location{'8891'} = 'LEIRFJORD';
$borough_number{'8892'} = '1822'; $type{'8892'} = 'G'; $location{'8892'} = 'SUNDY';
$borough_number{'8900'} = '1813'; $type{'8900'} = 'G'; $location{'8900'} = 'BRNNYSUND';
$borough_number{'8901'} = '1813'; $type{'8901'} = 'P'; $location{'8901'} = 'BRNNYSUND';
$borough_number{'8905'} = '1813'; $type{'8905'} = 'S'; $location{'8905'} = 'BRNNYSUND';
$borough_number{'8910'} = '1813'; $type{'8910'} = 'K'; $location{'8910'} = 'BRNNYSUND';
$borough_number{'8920'} = '1812'; $type{'8920'} = 'G'; $location{'8920'} = 'SMNA';
$borough_number{'8921'} = '1812'; $type{'8921'} = 'P'; $location{'8921'} = 'SMNA';
$borough_number{'8922'} = '1812'; $type{'8922'} = 'P'; $location{'8922'} = 'SMNA';
$borough_number{'8960'} = '1813'; $type{'8960'} = 'G'; $location{'8960'} = 'HOMMELST';
$borough_number{'8961'} = '1813'; $type{'8961'} = 'P'; $location{'8961'} = 'HOMMELST';
$borough_number{'8976'} = '1816'; $type{'8976'} = 'B'; $location{'8976'} = 'VEVELSTAD';
$borough_number{'8978'} = '1816'; $type{'8978'} = 'G'; $location{'8978'} = 'HESSTUN';
$borough_number{'8980'} = '1815'; $type{'8980'} = 'G'; $location{'8980'} = 'VEGA';
$borough_number{'8981'} = '1815'; $type{'8981'} = 'P'; $location{'8981'} = 'VEGA';
$borough_number{'8985'} = '1815'; $type{'8985'} = 'B'; $location{'8985'} = 'YLVINGEN';
$borough_number{'9006'} = '1902'; $type{'9006'} = 'G'; $location{'9006'} = 'TROMS';
$borough_number{'9007'} = '1902'; $type{'9007'} = 'G'; $location{'9007'} = 'TROMS';
$borough_number{'9008'} = '1902'; $type{'9008'} = 'G'; $location{'9008'} = 'TROMS';
$borough_number{'9009'} = '1902'; $type{'9009'} = 'G'; $location{'9009'} = 'TROMS';
$borough_number{'9010'} = '1902'; $type{'9010'} = 'G'; $location{'9010'} = 'TROMS';
$borough_number{'9011'} = '1902'; $type{'9011'} = 'G'; $location{'9011'} = 'TROMS';
$borough_number{'9012'} = '1902'; $type{'9012'} = 'G'; $location{'9012'} = 'TROMS';
$borough_number{'9013'} = '1902'; $type{'9013'} = 'B'; $location{'9013'} = 'TROMS';
$borough_number{'9014'} = '1902'; $type{'9014'} = 'G'; $location{'9014'} = 'TROMS';
$borough_number{'9015'} = '1902'; $type{'9015'} = 'G'; $location{'9015'} = 'TROMS';
$borough_number{'9016'} = '1902'; $type{'9016'} = 'G'; $location{'9016'} = 'TROMS';
$borough_number{'9017'} = '1902'; $type{'9017'} = 'G'; $location{'9017'} = 'TROMS';
$borough_number{'9018'} = '1902'; $type{'9018'} = 'G'; $location{'9018'} = 'TROMS';
$borough_number{'9019'} = '1902'; $type{'9019'} = 'G'; $location{'9019'} = 'TROMS';
$borough_number{'9020'} = '1902'; $type{'9020'} = 'G'; $location{'9020'} = 'TROMSDALEN';
$borough_number{'9022'} = '1902'; $type{'9022'} = 'G'; $location{'9022'} = 'KROKELVDALEN';
$borough_number{'9024'} = '1902'; $type{'9024'} = 'G'; $location{'9024'} = 'TOMASJORD';
$borough_number{'9027'} = '1902'; $type{'9027'} = 'G'; $location{'9027'} = 'RAMFJORDBOTN';
$borough_number{'9030'} = '1902'; $type{'9030'} = 'G'; $location{'9030'} = 'SJURSNES';
$borough_number{'9034'} = '1902'; $type{'9034'} = 'G'; $location{'9034'} = 'OLDERVIK';
$borough_number{'9037'} = '1902'; $type{'9037'} = 'K'; $location{'9037'} = 'TROMS';
$borough_number{'9038'} = '1902'; $type{'9038'} = 'K'; $location{'9038'} = 'TROMS';
$borough_number{'9040'} = '1933'; $type{'9040'} = 'G'; $location{'9040'} = 'NORDKJOSBOTN';
$borough_number{'9042'} = '1933'; $type{'9042'} = 'G'; $location{'9042'} = 'LAKSVATN';
$borough_number{'9043'} = '1902'; $type{'9043'} = 'G'; $location{'9043'} = 'JVIK';
$borough_number{'9046'} = '1939'; $type{'9046'} = 'G'; $location{'9046'} = 'OTEREN';
$borough_number{'9049'} = '1933'; $type{'9049'} = 'P'; $location{'9049'} = 'NORDKJOSBOTN';
$borough_number{'9050'} = '1933'; $type{'9050'} = 'G'; $location{'9050'} = 'STORSTEINNES';
$borough_number{'9054'} = '1933'; $type{'9054'} = 'G'; $location{'9054'} = 'MALANGSEIDET';
$borough_number{'9055'} = '1933'; $type{'9055'} = 'G'; $location{'9055'} = 'MEISTERVIK';
$borough_number{'9056'} = '1933'; $type{'9056'} = 'G'; $location{'9056'} = 'MORTENHALS';
$borough_number{'9057'} = '1902'; $type{'9057'} = 'B'; $location{'9057'} = 'VIKRAN';
$borough_number{'9059'} = '1933'; $type{'9059'} = 'P'; $location{'9059'} = 'STORSTEINNES';
$borough_number{'9060'} = '1938'; $type{'9060'} = 'G'; $location{'9060'} = 'LYNGSEIDET';
$borough_number{'9062'} = '1938'; $type{'9062'} = 'G'; $location{'9062'} = 'FURUFLATEN';
$borough_number{'9064'} = '1938'; $type{'9064'} = 'G'; $location{'9064'} = 'SVENSBY';
$borough_number{'9068'} = '1938'; $type{'9068'} = 'G'; $location{'9068'} = 'NORD-LENANGEN';
$borough_number{'9069'} = '1938'; $type{'9069'} = 'P'; $location{'9069'} = 'LYNGSEIDET';
$borough_number{'9100'} = '1902'; $type{'9100'} = 'G'; $location{'9100'} = 'KVALYSLETTA';
$borough_number{'9103'} = '1902'; $type{'9103'} = 'G'; $location{'9103'} = 'SKULSFJORD';
$borough_number{'9106'} = '1902'; $type{'9106'} = 'G'; $location{'9106'} = 'STRAUMSBUKTA';
$borough_number{'9107'} = '1902'; $type{'9107'} = 'G'; $location{'9107'} = 'TROMVIK';
$borough_number{'9110'} = '1902'; $type{'9110'} = 'G'; $location{'9110'} = 'SOMMARY';
$borough_number{'9118'} = '1902'; $type{'9118'} = 'G'; $location{'9118'} = 'BRENSHOLMEN';
$borough_number{'9119'} = '1902'; $type{'9119'} = 'P'; $location{'9119'} = 'SOMMARY';
$borough_number{'9120'} = '1902'; $type{'9120'} = 'G'; $location{'9120'} = 'VENGSY';
$borough_number{'9128'} = '1902'; $type{'9128'} = 'G'; $location{'9128'} = 'TUSSY';
$borough_number{'9130'} = '1936'; $type{'9130'} = 'G'; $location{'9130'} = 'HANSNES';
$borough_number{'9131'} = '1902'; $type{'9131'} = 'G'; $location{'9131'} = 'KRVIK';
$borough_number{'9132'} = '1936'; $type{'9132'} = 'G'; $location{'9132'} = 'STAKKVIK';
$borough_number{'9134'} = '1936'; $type{'9134'} = 'P'; $location{'9134'} = 'HANSNES';
$borough_number{'9135'} = '1936'; $type{'9135'} = 'G'; $location{'9135'} = 'VANNVG';
$borough_number{'9136'} = '1936'; $type{'9136'} = 'G'; $location{'9136'} = 'VANNAREID';
$borough_number{'9137'} = '1936'; $type{'9137'} = 'P'; $location{'9137'} = 'VANNVG';
$borough_number{'9138'} = '1936'; $type{'9138'} = 'B'; $location{'9138'} = 'KARLSY';
$borough_number{'9140'} = '1936'; $type{'9140'} = 'G'; $location{'9140'} = 'REBBENES';
$borough_number{'9141'} = '1902'; $type{'9141'} = 'G'; $location{'9141'} = 'MJLVIK';
$borough_number{'9142'} = '1939'; $type{'9142'} = 'P'; $location{'9142'} = 'SKIBOTN';
$borough_number{'9143'} = '1939'; $type{'9143'} = 'G'; $location{'9143'} = 'SKIBOTN';
$borough_number{'9144'} = '1940'; $type{'9144'} = 'B'; $location{'9144'} = 'SAMUELSBERG';
$borough_number{'9146'} = '1940'; $type{'9146'} = 'G'; $location{'9146'} = 'OLDERDALEN';
$borough_number{'9147'} = '1940'; $type{'9147'} = 'B'; $location{'9147'} = 'BIRTAVARRE';
$borough_number{'9148'} = '1940'; $type{'9148'} = 'P'; $location{'9148'} = 'OLDERDALEN';
$borough_number{'9151'} = '1942'; $type{'9151'} = 'G'; $location{'9151'} = 'STORSLETT';
$borough_number{'9152'} = '1942'; $type{'9152'} = 'B'; $location{'9152'} = 'SRKJOSEN';
$borough_number{'9153'} = '1942'; $type{'9153'} = 'G'; $location{'9153'} = 'ROTSUND';
$borough_number{'9156'} = '1942'; $type{'9156'} = 'P'; $location{'9156'} = 'STORSLETT';
$borough_number{'9159'} = '1942'; $type{'9159'} = 'B'; $location{'9159'} = 'HAVNNES';
$borough_number{'9161'} = '1943'; $type{'9161'} = 'G'; $location{'9161'} = 'BURFJORD';
$borough_number{'9162'} = '1943'; $type{'9162'} = 'G'; $location{'9162'} = 'SRSTRAUMEN';
$borough_number{'9163'} = '1943'; $type{'9163'} = 'G'; $location{'9163'} = 'JKELFJORD';
$borough_number{'9164'} = '1943'; $type{'9164'} = 'G'; $location{'9164'} = 'KVNANGSFJELLET';
$borough_number{'9169'} = '1943'; $type{'9169'} = 'P'; $location{'9169'} = 'BURFJORD';
$borough_number{'9170'} = '2111'; $type{'9170'} = 'G'; $location{'9170'} = 'LONGYEARBYEN';
$borough_number{'9171'} = '2111'; $type{'9171'} = 'F'; $location{'9171'} = 'LONGYEARBYEN';
$borough_number{'9172'} = '2111'; $type{'9172'} = 'G'; $location{'9172'} = 'ISFJORD P SVALBARD';
$borough_number{'9173'} = '2111'; $type{'9173'} = 'B'; $location{'9173'} = 'NY-LESUND';
$borough_number{'9174'} = '2131'; $type{'9174'} = 'G'; $location{'9174'} = 'HOPEN';
$borough_number{'9175'} = '2111'; $type{'9175'} = 'G'; $location{'9175'} = 'SVEAGRUVA';
$borough_number{'9176'} = '2121'; $type{'9176'} = 'G'; $location{'9176'} = 'BJRNYA';
$borough_number{'9177'} = '2111'; $type{'9177'} = 'G'; $location{'9177'} = 'HORNSUND';
$borough_number{'9178'} = '2111'; $type{'9178'} = 'G'; $location{'9178'} = 'BARENTSBURG';
$borough_number{'9179'} = '2111'; $type{'9179'} = 'G'; $location{'9179'} = 'PYRAMIDEN';
$borough_number{'9180'} = '1941'; $type{'9180'} = 'G'; $location{'9180'} = 'SKJERVY';
$borough_number{'9181'} = '1942'; $type{'9181'} = 'G'; $location{'9181'} = 'HAMNEIDET';
$borough_number{'9182'} = '1943'; $type{'9182'} = 'G'; $location{'9182'} = 'SEGLVIK';
$borough_number{'9184'} = '1943'; $type{'9184'} = 'B'; $location{'9184'} = 'REINFJORD';
$borough_number{'9185'} = '1943'; $type{'9185'} = 'G'; $location{'9185'} = 'SPILDRA';
$borough_number{'9186'} = '1943'; $type{'9186'} = 'G'; $location{'9186'} = 'ANDSNES';
$borough_number{'9189'} = '1941'; $type{'9189'} = 'P'; $location{'9189'} = 'SKJERVY';
$borough_number{'9190'} = '1941'; $type{'9190'} = 'G'; $location{'9190'} = 'AKKARVIK';
$borough_number{'9192'} = '1941'; $type{'9192'} = 'G'; $location{'9192'} = 'ARNYHAMN';
$borough_number{'9193'} = '1941'; $type{'9193'} = 'G'; $location{'9193'} = 'NIKKEBY';
$borough_number{'9194'} = '1941'; $type{'9194'} = 'G'; $location{'9194'} = 'LAUKSLETTA';
$borough_number{'9195'} = '1941'; $type{'9195'} = 'B'; $location{'9195'} = 'RVIKSAND';
$borough_number{'9197'} = '1941'; $type{'9197'} = 'G'; $location{'9197'} = 'ULYBUKT';
$borough_number{'9251'} = '1902'; $type{'9251'} = 'P'; $location{'9251'} = 'TROMS';
$borough_number{'9252'} = '1902'; $type{'9252'} = 'P'; $location{'9252'} = 'TROMS';
$borough_number{'9253'} = '1902'; $type{'9253'} = 'P'; $location{'9253'} = 'TROMS';
$borough_number{'9254'} = '1902'; $type{'9254'} = 'P'; $location{'9254'} = 'TROMS';
$borough_number{'9255'} = '1902'; $type{'9255'} = 'P'; $location{'9255'} = 'TROMS';
$borough_number{'9256'} = '1902'; $type{'9256'} = 'P'; $location{'9256'} = 'TROMS';
$borough_number{'9257'} = '1902'; $type{'9257'} = 'P'; $location{'9257'} = 'TROMS';
$borough_number{'9258'} = '1902'; $type{'9258'} = 'P'; $location{'9258'} = 'TROMS';
$borough_number{'9259'} = '1902'; $type{'9259'} = 'P'; $location{'9259'} = 'TROMS';
$borough_number{'9260'} = '1902'; $type{'9260'} = 'P'; $location{'9260'} = 'TROMS';
$borough_number{'9261'} = '1902'; $type{'9261'} = 'P'; $location{'9261'} = 'TROMS';
$borough_number{'9262'} = '1902'; $type{'9262'} = 'P'; $location{'9262'} = 'TROMS';
$borough_number{'9263'} = '1902'; $type{'9263'} = 'P'; $location{'9263'} = 'TROMS';
$borough_number{'9265'} = '1902'; $type{'9265'} = 'P'; $location{'9265'} = 'TROMS';
$borough_number{'9266'} = '1902'; $type{'9266'} = 'P'; $location{'9266'} = 'TROMS';
$borough_number{'9267'} = '1902'; $type{'9267'} = 'P'; $location{'9267'} = 'TROMS';
$borough_number{'9268'} = '1902'; $type{'9268'} = 'P'; $location{'9268'} = 'TROMS';
$borough_number{'9269'} = '1902'; $type{'9269'} = 'P'; $location{'9269'} = 'TROMS';
$borough_number{'9270'} = '1902'; $type{'9270'} = 'P'; $location{'9270'} = 'TROMS';
$borough_number{'9271'} = '1902'; $type{'9271'} = 'P'; $location{'9271'} = 'TROMS';
$borough_number{'9272'} = '1902'; $type{'9272'} = 'P'; $location{'9272'} = 'TROMS';
$borough_number{'9273'} = '1902'; $type{'9273'} = 'P'; $location{'9273'} = 'TROMS';
$borough_number{'9274'} = '1902'; $type{'9274'} = 'P'; $location{'9274'} = 'TROMS';
$borough_number{'9275'} = '1902'; $type{'9275'} = 'P'; $location{'9275'} = 'TROMS';
$borough_number{'9276'} = '1902'; $type{'9276'} = 'P'; $location{'9276'} = 'TROMS';
$borough_number{'9277'} = '1902'; $type{'9277'} = 'P'; $location{'9277'} = 'TROMS';
$borough_number{'9278'} = '1902'; $type{'9278'} = 'P'; $location{'9278'} = 'TROMS';
$borough_number{'9279'} = '1902'; $type{'9279'} = 'P'; $location{'9279'} = 'TROMS';
$borough_number{'9280'} = '1902'; $type{'9280'} = 'P'; $location{'9280'} = 'TROMS';
$borough_number{'9281'} = '1902'; $type{'9281'} = 'P'; $location{'9281'} = 'TROMS';
$borough_number{'9282'} = '1902'; $type{'9282'} = 'P'; $location{'9282'} = 'TROMS';
$borough_number{'9283'} = '1902'; $type{'9283'} = 'P'; $location{'9283'} = 'TROMS';
$borough_number{'9284'} = '1902'; $type{'9284'} = 'P'; $location{'9284'} = 'TROMS';
$borough_number{'9285'} = '1902'; $type{'9285'} = 'P'; $location{'9285'} = 'TROMS';
$borough_number{'9286'} = '1902'; $type{'9286'} = 'P'; $location{'9286'} = 'TROMS';
$borough_number{'9287'} = '1902'; $type{'9287'} = 'P'; $location{'9287'} = 'TROMS';
$borough_number{'9288'} = '1902'; $type{'9288'} = 'P'; $location{'9288'} = 'TROMS';
$borough_number{'9290'} = '1902'; $type{'9290'} = 'K'; $location{'9290'} = 'TROMS';
$borough_number{'9291'} = '1902'; $type{'9291'} = 'S'; $location{'9291'} = 'TROMS';
$borough_number{'9292'} = '1902'; $type{'9292'} = 'S'; $location{'9292'} = 'TROMS';
$borough_number{'9293'} = '1902'; $type{'9293'} = 'S'; $location{'9293'} = 'TROMS';
$borough_number{'9294'} = '1902'; $type{'9294'} = 'S'; $location{'9294'} = 'TROMS';
$borough_number{'9296'} = '1902'; $type{'9296'} = 'S'; $location{'9296'} = 'TROMS';
$borough_number{'9297'} = '1902'; $type{'9297'} = 'K'; $location{'9297'} = 'TROMS';
$borough_number{'9298'} = '1902'; $type{'9298'} = 'K'; $location{'9298'} = 'TROMS';
$borough_number{'9299'} = '1902'; $type{'9299'} = 'K'; $location{'9299'} = 'TROMS';
$borough_number{'9300'} = '1931'; $type{'9300'} = 'G'; $location{'9300'} = 'FINNSNES';
$borough_number{'9302'} = '1931'; $type{'9302'} = 'G'; $location{'9302'} = 'ROSSFJORDSTRAUMEN';
$borough_number{'9303'} = '1931'; $type{'9303'} = 'G'; $location{'9303'} = 'SILSAND';
$borough_number{'9304'} = '1927'; $type{'9304'} = 'G'; $location{'9304'} = 'VANGSVIK';
$borough_number{'9305'} = '1931'; $type{'9305'} = 'P'; $location{'9305'} = 'FINNSNES';
$borough_number{'9306'} = '1931'; $type{'9306'} = 'S'; $location{'9306'} = 'FINNSNES';
$borough_number{'9310'} = '1925'; $type{'9310'} = 'G'; $location{'9310'} = 'SRREISA';
$borough_number{'9311'} = '1926'; $type{'9311'} = 'G'; $location{'9311'} = 'BRSTADBOTN';
$borough_number{'9315'} = '1925'; $type{'9315'} = 'P'; $location{'9315'} = 'SRREISA';
$borough_number{'9316'} = '1926'; $type{'9316'} = 'P'; $location{'9316'} = 'BRSTADBOTN';
$borough_number{'9321'} = '1924'; $type{'9321'} = 'G'; $location{'9321'} = 'MOEN';
$borough_number{'9322'} = '1924'; $type{'9322'} = 'G'; $location{'9322'} = 'KARLSTAD';
$borough_number{'9325'} = '1924'; $type{'9325'} = 'G'; $location{'9325'} = 'BARDUFOSS';
$borough_number{'9326'} = '1924'; $type{'9326'} = 'P'; $location{'9326'} = 'BARDUFOSS';
$borough_number{'9327'} = '1924'; $type{'9327'} = 'P'; $location{'9327'} = 'BARDUFOSS';
$borough_number{'9329'} = '1924'; $type{'9329'} = 'P'; $location{'9329'} = 'MOEN';
$borough_number{'9334'} = '1924'; $type{'9334'} = 'G'; $location{'9334'} = 'VERBYGD';
$borough_number{'9335'} = '1924'; $type{'9335'} = 'P'; $location{'9335'} = 'VERBYGD';
$borough_number{'9336'} = '1924'; $type{'9336'} = 'G'; $location{'9336'} = 'RUNDHAUG';
$borough_number{'9350'} = '1923'; $type{'9350'} = 'G'; $location{'9350'} = 'SJVEGAN';
$borough_number{'9355'} = '1923'; $type{'9355'} = 'P'; $location{'9355'} = 'SJVEGAN';
$borough_number{'9357'} = '1920'; $type{'9357'} = 'G'; $location{'9357'} = 'TENNEVOLL';
$borough_number{'9358'} = '1920'; $type{'9358'} = 'P'; $location{'9358'} = 'TENNEVOLL';
$borough_number{'9360'} = '1922'; $type{'9360'} = 'G'; $location{'9360'} = 'BARDU';
$borough_number{'9365'} = '1922'; $type{'9365'} = 'P'; $location{'9365'} = 'BARDU';
$borough_number{'9370'} = '1931'; $type{'9370'} = 'P'; $location{'9370'} = 'SILSAND';
$borough_number{'9372'} = '1931'; $type{'9372'} = 'G'; $location{'9372'} = 'GIBOSTAD';
$borough_number{'9373'} = '1931'; $type{'9373'} = 'G'; $location{'9373'} = 'BOTNHAMN';
$borough_number{'9379'} = '1928'; $type{'9379'} = 'P'; $location{'9379'} = 'GRYLLEFJORD';
$borough_number{'9380'} = '1928'; $type{'9380'} = 'G'; $location{'9380'} = 'GRYLLEFJORD';
$borough_number{'9381'} = '1928'; $type{'9381'} = 'G'; $location{'9381'} = 'TORSKEN';
$borough_number{'9382'} = '1931'; $type{'9382'} = 'P'; $location{'9382'} = 'GIBOSTAD';
$borough_number{'9384'} = '1929'; $type{'9384'} = 'P'; $location{'9384'} = 'SKALAND';
$borough_number{'9385'} = '1929'; $type{'9385'} = 'G'; $location{'9385'} = 'SKALAND';
$borough_number{'9386'} = '1929'; $type{'9386'} = 'G'; $location{'9386'} = 'SENJAHOPEN';
$borough_number{'9387'} = '1929'; $type{'9387'} = 'P'; $location{'9387'} = 'SENJAHOPEN';
$borough_number{'9388'} = '1931'; $type{'9388'} = 'B'; $location{'9388'} = 'FJORDGARD';
$borough_number{'9389'} = '1931'; $type{'9389'} = 'B'; $location{'9389'} = 'HUSY I SENJA';
$borough_number{'9391'} = '1927'; $type{'9391'} = 'P'; $location{'9391'} = 'STONGLANDSEIDET';
$borough_number{'9392'} = '1927'; $type{'9392'} = 'G'; $location{'9392'} = 'STONGLANDSEIDET';
$borough_number{'9393'} = '1928'; $type{'9393'} = 'G'; $location{'9393'} = 'FLAKSTADVG';
$borough_number{'9395'} = '1928'; $type{'9395'} = 'B'; $location{'9395'} = 'KALDFARNES';
$borough_number{'9402'} = '1901'; $type{'9402'} = 'G'; $location{'9402'} = 'HARSTAD';
$borough_number{'9403'} = '1901'; $type{'9403'} = 'G'; $location{'9403'} = 'HARSTAD';
$borough_number{'9404'} = '1901'; $type{'9404'} = 'G'; $location{'9404'} = 'HARSTAD';
$borough_number{'9405'} = '1901'; $type{'9405'} = 'G'; $location{'9405'} = 'HARSTAD';
$borough_number{'9406'} = '1901'; $type{'9406'} = 'G'; $location{'9406'} = 'HARSTAD';
$borough_number{'9407'} = '1901'; $type{'9407'} = 'G'; $location{'9407'} = 'HARSTAD';
$borough_number{'9408'} = '1901'; $type{'9408'} = 'G'; $location{'9408'} = 'HARSTAD';
$borough_number{'9409'} = '1901'; $type{'9409'} = 'G'; $location{'9409'} = 'HARSTAD';
$borough_number{'9411'} = '1901'; $type{'9411'} = 'G'; $location{'9411'} = 'HARSTAD';
$borough_number{'9414'} = '1901'; $type{'9414'} = 'G'; $location{'9414'} = 'HARSTAD';
$borough_number{'9415'} = '1901'; $type{'9415'} = 'B'; $location{'9415'} = 'HARSTAD';
$borough_number{'9419'} = '1901'; $type{'9419'} = 'G'; $location{'9419'} = 'SRVIK';
$borough_number{'9420'} = '1901'; $type{'9420'} = 'B'; $location{'9420'} = 'LUNDENES';
$borough_number{'9423'} = '1901'; $type{'9423'} = 'G'; $location{'9423'} = 'GRTAVR';
$borough_number{'9424'} = '1901'; $type{'9424'} = 'G'; $location{'9424'} = 'KJTTA';
$borough_number{'9425'} = '1915'; $type{'9425'} = 'B'; $location{'9425'} = 'SANDSY';
$borough_number{'9426'} = '1915'; $type{'9426'} = 'B'; $location{'9426'} = 'BJARKY';
$borough_number{'9427'} = '1915'; $type{'9427'} = 'G'; $location{'9427'} = 'MELYVR';
$borough_number{'9430'} = '1901'; $type{'9430'} = 'G'; $location{'9430'} = 'SANDTORG';
$borough_number{'9436'} = '1852'; $type{'9436'} = 'G'; $location{'9436'} = 'KONGSVIK';
$borough_number{'9439'} = '1913'; $type{'9439'} = 'P'; $location{'9439'} = 'EVENSKJER';
$borough_number{'9440'} = '1913'; $type{'9440'} = 'G'; $location{'9440'} = 'EVENSKJER';
$borough_number{'9441'} = '1852'; $type{'9441'} = 'G'; $location{'9441'} = 'FJELLDAL';
$borough_number{'9442'} = '1852'; $type{'9442'} = 'G'; $location{'9442'} = 'RAMSUND';
$borough_number{'9443'} = '1852'; $type{'9443'} = 'G'; $location{'9443'} = 'MYKLEBOSTAD';
$borough_number{'9444'} = '1852'; $type{'9444'} = 'G'; $location{'9444'} = 'HOL I TJELDSUND';
$borough_number{'9445'} = '1913'; $type{'9445'} = 'G'; $location{'9445'} = 'TOVIK';
$borough_number{'9446'} = '1913'; $type{'9446'} = 'G'; $location{'9446'} = 'GROVFJORD';
$borough_number{'9447'} = '1913'; $type{'9447'} = 'P'; $location{'9447'} = 'GROVFJORD';
$borough_number{'9448'} = '1852'; $type{'9448'} = 'P'; $location{'9448'} = 'RAMSUND';
$borough_number{'9450'} = '1917'; $type{'9450'} = 'G'; $location{'9450'} = 'HAMNVIK';
$borough_number{'9451'} = '1917'; $type{'9451'} = 'P'; $location{'9451'} = 'HAMNVIK';
$borough_number{'9453'} = '1917'; $type{'9453'} = 'G'; $location{'9453'} = 'KRKRHAMN';
$borough_number{'9454'} = '1917'; $type{'9454'} = 'G'; $location{'9454'} = 'NSTAD';
$borough_number{'9455'} = '1917'; $type{'9455'} = 'B'; $location{'9455'} = 'ENGENES';
$borough_number{'9470'} = '1919'; $type{'9470'} = 'G'; $location{'9470'} = 'GRATANGEN';
$borough_number{'9471'} = '1919'; $type{'9471'} = 'P'; $location{'9471'} = 'GRATANGEN';
$borough_number{'9475'} = '1911'; $type{'9475'} = 'G'; $location{'9475'} = 'BORKENES';
$borough_number{'9476'} = '1911'; $type{'9476'} = 'P'; $location{'9476'} = 'BORKENES';
$borough_number{'9479'} = '1901'; $type{'9479'} = 'S'; $location{'9479'} = 'HARSTAD';
$borough_number{'9480'} = '1901'; $type{'9480'} = 'S'; $location{'9480'} = 'HARSTAD';
$borough_number{'9481'} = '1901'; $type{'9481'} = 'P'; $location{'9481'} = 'HARSTAD';
$borough_number{'9482'} = '1901'; $type{'9482'} = 'P'; $location{'9482'} = 'HARSTAD';
$borough_number{'9483'} = '1901'; $type{'9483'} = 'P'; $location{'9483'} = 'HARSTAD';
$borough_number{'9484'} = '1901'; $type{'9484'} = 'P'; $location{'9484'} = 'HARSTAD';
$borough_number{'9485'} = '1901'; $type{'9485'} = 'P'; $location{'9485'} = 'HARSTAD';
$borough_number{'9486'} = '1901'; $type{'9486'} = 'P'; $location{'9486'} = 'HARSTAD';
$borough_number{'9487'} = '1901'; $type{'9487'} = 'P'; $location{'9487'} = 'HARSTAD';
$borough_number{'9488'} = '1901'; $type{'9488'} = 'P'; $location{'9488'} = 'HARSTAD';
$borough_number{'9489'} = '1901'; $type{'9489'} = 'P'; $location{'9489'} = 'HARSTAD';
$borough_number{'9496'} = '1901'; $type{'9496'} = 'P'; $location{'9496'} = 'HARSTAD';
$borough_number{'9497'} = '1901'; $type{'9497'} = 'P'; $location{'9497'} = 'HARSTAD';
$borough_number{'9498'} = '1901'; $type{'9498'} = 'P'; $location{'9498'} = 'HARSTAD';
$borough_number{'9499'} = '1901'; $type{'9499'} = 'P'; $location{'9499'} = 'HARSTAD';
$borough_number{'9501'} = '2012'; $type{'9501'} = 'P'; $location{'9501'} = 'ALTA';
$borough_number{'9502'} = '2012'; $type{'9502'} = 'P'; $location{'9502'} = 'ALTA';
$borough_number{'9503'} = '2012'; $type{'9503'} = 'P'; $location{'9503'} = 'ALTA';
$borough_number{'9504'} = '2012'; $type{'9504'} = 'P'; $location{'9504'} = 'ALTA';
$borough_number{'9505'} = '2012'; $type{'9505'} = 'P'; $location{'9505'} = 'ALTA';
$borough_number{'9506'} = '2012'; $type{'9506'} = 'P'; $location{'9506'} = 'ALTA';
$borough_number{'9507'} = '2012'; $type{'9507'} = 'P'; $location{'9507'} = 'ALTA';
$borough_number{'9508'} = '2012'; $type{'9508'} = 'P'; $location{'9508'} = 'ALTA';
$borough_number{'9509'} = '2012'; $type{'9509'} = 'F'; $location{'9509'} = 'ALTA';
$borough_number{'9510'} = '2012'; $type{'9510'} = 'G'; $location{'9510'} = 'ALTA';
$borough_number{'9511'} = '2012'; $type{'9511'} = 'G'; $location{'9511'} = 'ALTA';
$borough_number{'9512'} = '2012'; $type{'9512'} = 'G'; $location{'9512'} = 'ALTA';
$borough_number{'9513'} = '2012'; $type{'9513'} = 'G'; $location{'9513'} = 'ALTA';
$borough_number{'9514'} = '2012'; $type{'9514'} = 'G'; $location{'9514'} = 'ALTA';
$borough_number{'9515'} = '2012'; $type{'9515'} = 'G'; $location{'9515'} = 'ALTA';
$borough_number{'9516'} = '2012'; $type{'9516'} = 'G'; $location{'9516'} = 'ALTA';
$borough_number{'9517'} = '2012'; $type{'9517'} = 'G'; $location{'9517'} = 'ALTA';
$borough_number{'9518'} = '2012'; $type{'9518'} = 'G'; $location{'9518'} = 'ALTA';
$borough_number{'9519'} = '2012'; $type{'9519'} = 'G'; $location{'9519'} = 'KVIBY';
$borough_number{'9520'} = '2011'; $type{'9520'} = 'G'; $location{'9520'} = 'KAUTOKEINO';
$borough_number{'9521'} = '2011'; $type{'9521'} = 'P'; $location{'9521'} = 'KAUTOKEINO';
$borough_number{'9525'} = '2011'; $type{'9525'} = 'B'; $location{'9525'} = 'MAZE';
$borough_number{'9526'} = '2011'; $type{'9526'} = 'G'; $location{'9526'} = 'SUOLOVUOPMI';
$borough_number{'9531'} = '2012'; $type{'9531'} = 'B'; $location{'9531'} = 'KVALFJORD';
$borough_number{'9532'} = '2012'; $type{'9532'} = 'B'; $location{'9532'} = 'HAKKSTABBEN';
$borough_number{'9533'} = '2012'; $type{'9533'} = 'B'; $location{'9533'} = 'KONGSHUS';
$borough_number{'9536'} = '2012'; $type{'9536'} = 'G'; $location{'9536'} = 'KORSFJORDEN';
$borough_number{'9540'} = '2012'; $type{'9540'} = 'G'; $location{'9540'} = 'TALVIK';
$borough_number{'9545'} = '2012'; $type{'9545'} = 'G'; $location{'9545'} = 'LANGFJORDBOTN';
$borough_number{'9550'} = '2014'; $type{'9550'} = 'G'; $location{'9550'} = 'KSFJORD';
$borough_number{'9551'} = '2014'; $type{'9551'} = 'P'; $location{'9551'} = 'KSFJORD';
$borough_number{'9580'} = '2014'; $type{'9580'} = 'B'; $location{'9580'} = 'BERGSFJORD';
$borough_number{'9582'} = '2014'; $type{'9582'} = 'G'; $location{'9582'} = 'NUVSVG';
$borough_number{'9583'} = '2014'; $type{'9583'} = 'B'; $location{'9583'} = 'LANGFJORDHAMN';
$borough_number{'9584'} = '2014'; $type{'9584'} = 'B'; $location{'9584'} = 'SR-TVERRFJORD';
$borough_number{'9585'} = '2014'; $type{'9585'} = 'G'; $location{'9585'} = 'SANDLAND';
$borough_number{'9586'} = '2014'; $type{'9586'} = 'G'; $location{'9586'} = 'LOPPA';
$borough_number{'9587'} = '2014'; $type{'9587'} = 'G'; $location{'9587'} = 'SKAVNAKK';
$borough_number{'9590'} = '2015'; $type{'9590'} = 'B'; $location{'9590'} = 'HASVIK';
$borough_number{'9593'} = '2015'; $type{'9593'} = 'B'; $location{'9593'} = 'BREIVIKBOTN';
$borough_number{'9595'} = '2015'; $type{'9595'} = 'B'; $location{'9595'} = 'SRVR';
$borough_number{'9600'} = '2004'; $type{'9600'} = 'B'; $location{'9600'} = 'HAMMERFEST';
$borough_number{'9609'} = '2004'; $type{'9609'} = 'G'; $location{'9609'} = 'HNSEBY';
$borough_number{'9610'} = '2004'; $type{'9610'} = 'B'; $location{'9610'} = 'RYPEFJORD';
$borough_number{'9613'} = '2004'; $type{'9613'} = 'S'; $location{'9613'} = 'HAMMERFEST';
$borough_number{'9615'} = '2004'; $type{'9615'} = 'P'; $location{'9615'} = 'HAMMERFEST';
$borough_number{'9616'} = '2004'; $type{'9616'} = 'P'; $location{'9616'} = 'HAMMERFEST';
$borough_number{'9620'} = '2017'; $type{'9620'} = 'G'; $location{'9620'} = 'KVALSUND';
$borough_number{'9621'} = '2017'; $type{'9621'} = 'P'; $location{'9621'} = 'KVALSUND';
$borough_number{'9624'} = '2017'; $type{'9624'} = 'G'; $location{'9624'} = 'REVSNESHAMN';
$borough_number{'9650'} = '2004'; $type{'9650'} = 'B'; $location{'9650'} = 'AKKARFJORD';
$borough_number{'9653'} = '2004'; $type{'9653'} = 'G'; $location{'9653'} = 'HELLEFJORD';
$borough_number{'9657'} = '2004'; $type{'9657'} = 'B'; $location{'9657'} = 'KRHAMN';
$borough_number{'9664'} = '2004'; $type{'9664'} = 'B'; $location{'9664'} = 'SANDYBOTN';
$borough_number{'9670'} = '2018'; $type{'9670'} = 'B'; $location{'9670'} = 'TUFJORD';
$borough_number{'9672'} = '2018'; $type{'9672'} = 'B'; $location{'9672'} = 'INGY';
$borough_number{'9690'} = '2018'; $type{'9690'} = 'G'; $location{'9690'} = 'HAVYSUND';
$borough_number{'9691'} = '2018'; $type{'9691'} = 'P'; $location{'9691'} = 'HAVYSUND';
$borough_number{'9692'} = '2018'; $type{'9692'} = 'B'; $location{'9692'} = 'MSY';
$borough_number{'9700'} = '2020'; $type{'9700'} = 'G'; $location{'9700'} = 'LAKSELV';
$borough_number{'9709'} = '2020'; $type{'9709'} = 'G'; $location{'9709'} = 'PORSANGMOEN';
$borough_number{'9710'} = '2020'; $type{'9710'} = 'G'; $location{'9710'} = 'INDRE BILLEFJORD';
$borough_number{'9711'} = '2020'; $type{'9711'} = 'P'; $location{'9711'} = 'LAKSELV';
$borough_number{'9712'} = '2020'; $type{'9712'} = 'S'; $location{'9712'} = 'LAKSELV';
$borough_number{'9713'} = '2020'; $type{'9713'} = 'B'; $location{'9713'} = 'RUSSENES';
$borough_number{'9714'} = '2018'; $type{'9714'} = 'G'; $location{'9714'} = 'SNEFJORD';
$borough_number{'9715'} = '2017'; $type{'9715'} = 'G'; $location{'9715'} = 'KOKELV';
$borough_number{'9716'} = '2020'; $type{'9716'} = 'B'; $location{'9716'} = 'BRSELV';
$borough_number{'9717'} = '2022'; $type{'9717'} = 'B'; $location{'9717'} = 'VEIDNESKLUBBEN';
$borough_number{'9722'} = '2020'; $type{'9722'} = 'B'; $location{'9722'} = 'SKOGANVARRE';
$borough_number{'9730'} = '2021'; $type{'9730'} = 'G'; $location{'9730'} = 'KARASJOK';
$borough_number{'9735'} = '2021'; $type{'9735'} = 'P'; $location{'9735'} = 'KARASJOK';
$borough_number{'9740'} = '2022'; $type{'9740'} = 'B'; $location{'9740'} = 'LEBESBY';
$borough_number{'9742'} = '2022'; $type{'9742'} = 'B'; $location{'9742'} = 'KUNES';
$borough_number{'9750'} = '2019'; $type{'9750'} = 'G'; $location{'9750'} = 'HONNINGSVG';
$borough_number{'9751'} = '2019'; $type{'9751'} = 'P'; $location{'9751'} = 'HONNINGSVG';
$borough_number{'9755'} = '2019'; $type{'9755'} = 'S'; $location{'9755'} = 'HONNINGSVG';
$borough_number{'9760'} = '2019'; $type{'9760'} = 'G'; $location{'9760'} = 'NORDVGEN';
$borough_number{'9763'} = '2019'; $type{'9763'} = 'B'; $location{'9763'} = 'SKARSVG';
$borough_number{'9764'} = '2019'; $type{'9764'} = 'G'; $location{'9764'} = 'NORDKAPP';
$borough_number{'9765'} = '2019'; $type{'9765'} = 'B'; $location{'9765'} = 'GJESVR';
$borough_number{'9768'} = '2019'; $type{'9768'} = 'G'; $location{'9768'} = 'REPVG';
$borough_number{'9770'} = '2023'; $type{'9770'} = 'B'; $location{'9770'} = 'MEHAMN';
$borough_number{'9771'} = '2023'; $type{'9771'} = 'B'; $location{'9771'} = 'SKJNES';
$borough_number{'9772'} = '2023'; $type{'9772'} = 'G'; $location{'9772'} = 'LANGFJORDNES';
$borough_number{'9773'} = '2023'; $type{'9773'} = 'B'; $location{'9773'} = 'NERVEI';
$borough_number{'9775'} = '2023'; $type{'9775'} = 'B'; $location{'9775'} = 'GAMVIK';
$borough_number{'9782'} = '2022'; $type{'9782'} = 'B'; $location{'9782'} = 'DYFJORD';
$borough_number{'9783'} = '2022'; $type{'9783'} = 'G'; $location{'9783'} = 'NORDMANNSET I LAKSEFJORD';
$borough_number{'9790'} = '2022'; $type{'9790'} = 'B'; $location{'9790'} = 'KJLLEFJORD';
$borough_number{'9800'} = '2003'; $type{'9800'} = 'G'; $location{'9800'} = 'VADS';
$borough_number{'9802'} = '2003'; $type{'9802'} = 'G'; $location{'9802'} = 'VESTRE JAKOBSELV';
$borough_number{'9810'} = '2003'; $type{'9810'} = 'P'; $location{'9810'} = 'VESTRE JAKOBSELV';
$borough_number{'9811'} = '2003'; $type{'9811'} = 'P'; $location{'9811'} = 'VADS';
$borough_number{'9815'} = '2003'; $type{'9815'} = 'S'; $location{'9815'} = 'VADS';
$borough_number{'9820'} = '2027'; $type{'9820'} = 'P'; $location{'9820'} = 'VARANGERBOTN';
$borough_number{'9826'} = '2025'; $type{'9826'} = 'G'; $location{'9826'} = 'SIRMA';
$borough_number{'9840'} = '2027'; $type{'9840'} = 'G'; $location{'9840'} = 'VARANGERBOTN';
$borough_number{'9845'} = '2025'; $type{'9845'} = 'G'; $location{'9845'} = 'TANA';
$borough_number{'9846'} = '2025'; $type{'9846'} = 'P'; $location{'9846'} = 'TANA';
$borough_number{'9900'} = '2030'; $type{'9900'} = 'G'; $location{'9900'} = 'KIRKENES';
$borough_number{'9910'} = '2030'; $type{'9910'} = 'G'; $location{'9910'} = 'BJRNEVATN';
$borough_number{'9912'} = '2030'; $type{'9912'} = 'G'; $location{'9912'} = 'HESSENG';
$borough_number{'9914'} = '2030'; $type{'9914'} = 'P'; $location{'9914'} = 'BJRNEVATN';
$borough_number{'9915'} = '2030'; $type{'9915'} = 'P'; $location{'9915'} = 'KIRKENES';
$borough_number{'9916'} = '2030'; $type{'9916'} = 'P'; $location{'9916'} = 'HESSENG';
$borough_number{'9917'} = '2030'; $type{'9917'} = 'S'; $location{'9917'} = 'KIRKENES';
$borough_number{'9925'} = '2030'; $type{'9925'} = 'G'; $location{'9925'} = 'SVANVIK';
$borough_number{'9930'} = '2030'; $type{'9930'} = 'G'; $location{'9930'} = 'NEIDEN';
$borough_number{'9934'} = '2030'; $type{'9934'} = 'G'; $location{'9934'} = 'BUGYFJORD';
$borough_number{'9935'} = '2030'; $type{'9935'} = 'B'; $location{'9935'} = 'BUGYNES';
$borough_number{'9950'} = '2002'; $type{'9950'} = 'G'; $location{'9950'} = 'VARD';
$borough_number{'9951'} = '2002'; $type{'9951'} = 'P'; $location{'9951'} = 'VARD';
$borough_number{'9960'} = '2002'; $type{'9960'} = 'B'; $location{'9960'} = 'KIBERG';
$borough_number{'9980'} = '2024'; $type{'9980'} = 'G'; $location{'9980'} = 'BERLEVG';
$borough_number{'9981'} = '2024'; $type{'9981'} = 'P'; $location{'9981'} = 'BERLEVG';
$borough_number{'9982'} = '2024'; $type{'9982'} = 'B'; $location{'9982'} = 'KONGSFJORD';
$borough_number{'9990'} = '2028'; $type{'9990'} = 'G'; $location{'9990'} = 'BTSFJORD';
$borough_number{'9991'} = '2028'; $type{'9991'} = 'P'; $location{'9991'} = 'BTSFJORD';

$borough{'0101'} = 'HALDEN';
$borough{'0104'} = 'MOSS';
$borough{'0105'} = 'SARPSBORG';
$borough{'0106'} = 'FREDRIKSTAD';
$borough{'0111'} = 'HVALER';
$borough{'0118'} = 'AREMARK';
$borough{'0119'} = 'MARKER';
$borough{'0121'} = 'RMSKOG';
$borough{'0122'} = 'TRGSTAD';
$borough{'0123'} = 'SPYDEBERG';
$borough{'0124'} = 'ASKIM';
$borough{'0125'} = 'EIDSBERG';
$borough{'0127'} = 'SKIPTVET';
$borough{'0128'} = 'RAKKESTAD';
$borough{'0135'} = 'RDE';
$borough{'0136'} = 'RYGGE';
$borough{'0137'} = 'VLER';
$borough{'0138'} = 'HOBL';
$borough{'0211'} = 'VESTBY';
$borough{'0213'} = 'SKI';
$borough{'0214'} = 'S';
$borough{'0215'} = 'FROGN';
$borough{'0216'} = 'NESODDEN';
$borough{'0217'} = 'OPPEGRD';
$borough{'0219'} = 'BRUM';
$borough{'0220'} = 'ASKER';
$borough{'0221'} = 'AURSKOG HLAND';
$borough{'0226'} = 'SRUM';
$borough{'0227'} = 'FET';
$borough{'0228'} = 'RLINGEN';
$borough{'0229'} = 'ENEBAKK';
$borough{'0230'} = 'LRENSKOG';
$borough{'0231'} = 'SKEDSMO';
$borough{'0233'} = 'NITTEDAL';
$borough{'0234'} = 'GJERDRUM';
$borough{'0235'} = 'ULLENSAKER';
$borough{'0236'} = 'NES';
$borough{'0237'} = 'EIDSVOLL';
$borough{'0238'} = 'NANNESTAD';
$borough{'0239'} = 'HURDAL';
$borough{'0301'} = 'OSLO';
$borough{'0402'} = 'KONGSVINGER';
$borough{'0403'} = 'HAMAR';
$borough{'0412'} = 'RINGSAKER';
$borough{'0415'} = 'LTEN';
$borough{'0417'} = 'STANGE';
$borough{'0418'} = 'NORD-ODAL';
$borough{'0419'} = 'SR-ODAL';
$borough{'0420'} = 'EIDSKOG';
$borough{'0423'} = 'GRUE';
$borough{'0425'} = 'SNES';
$borough{'0426'} = 'VLER';
$borough{'0427'} = 'ELVERUM';
$borough{'0428'} = 'TRYSIL';
$borough{'0429'} = 'MOT';
$borough{'0430'} = 'STOR-ELVDAL';
$borough{'0432'} = 'RENDALEN';
$borough{'0434'} = 'ENGERDAL';
$borough{'0436'} = 'TOLGA';
$borough{'0437'} = 'TYNSET';
$borough{'0438'} = 'ALVDAL';
$borough{'0439'} = 'FOLLDAL';
$borough{'0441'} = 'OS (HEDMARK)';
$borough{'0501'} = 'LILLEHAMMER';
$borough{'0502'} = 'GJVIK';
$borough{'0511'} = 'DOVRE';
$borough{'0512'} = 'LESJA';
$borough{'0513'} = 'SKJK';
$borough{'0514'} = 'LOM';
$borough{'0515'} = 'VG';
$borough{'0516'} = 'NORD-FRON';
$borough{'0517'} = 'SEL';
$borough{'0519'} = 'SR-FRON';
$borough{'0520'} = 'RINGEBU';
$borough{'0521'} = 'YER';
$borough{'0522'} = 'GAUSDAL';
$borough{'0528'} = 'STRE TOTEN';
$borough{'0529'} = 'VESTRE TOTEN';
$borough{'0532'} = 'JEVNAKER';
$borough{'0533'} = 'LUNNER';
$borough{'0534'} = 'GRAN';
$borough{'0536'} = 'SNDRE LAND';
$borough{'0538'} = 'NORDRE LAND';
$borough{'0540'} = 'SR-AURDAL';
$borough{'0541'} = 'ETNEDAL';
$borough{'0542'} = 'NORD-AURDAL';
$borough{'0543'} = 'VESTRE SLIDRE';
$borough{'0544'} = 'YSTRE SLIDRE';
$borough{'0545'} = 'VANG';
$borough{'0602'} = 'DRAMMEN';
$borough{'0604'} = 'KONGSBERG';
$borough{'0605'} = 'RINGERIKE';
$borough{'0612'} = 'HOLE';
$borough{'0615'} = 'FL';
$borough{'0616'} = 'NES';
$borough{'0617'} = 'GOL';
$borough{'0618'} = 'HEMSEDAL';
$borough{'0619'} = 'L';
$borough{'0620'} = 'HOL';
$borough{'0621'} = 'SIGDAL';
$borough{'0622'} = 'KRDSHERAD';
$borough{'0623'} = 'MODUM';
$borough{'0624'} = 'VRE EIKER';
$borough{'0625'} = 'NEDRE EIKER';
$borough{'0626'} = 'LIER';
$borough{'0627'} = 'RYKEN';
$borough{'0628'} = 'HURUM';
$borough{'0631'} = 'FLESBERG';
$borough{'0632'} = 'ROLLAG';
$borough{'0633'} = 'NORE OG UVDAL';
$borough{'0701'} = 'HORTEN';
$borough{'0702'} = 'HOLMESTRAND';
$borough{'0704'} = 'TNSBERG';
$borough{'0706'} = 'SANDEFJORD';
$borough{'0709'} = 'LARVIK';
$borough{'0711'} = 'SVELVIK';
$borough{'0713'} = 'SANDE (V.)';
$borough{'0714'} = 'HOF';
$borough{'0716'} = 'RE';
$borough{'0719'} = 'ANDEBU';
$borough{'0720'} = 'STOKKE';
$borough{'0722'} = 'NTTERY';
$borough{'0723'} = 'TJME';
$borough{'0728'} = 'LARDAL';
$borough{'0805'} = 'PORSGRUNN';
$borough{'0806'} = 'SKIEN';
$borough{'0807'} = 'NOTODDEN';
$borough{'0811'} = 'SILJAN';
$borough{'0814'} = 'BAMBLE';
$borough{'0815'} = 'KRAGER';
$borough{'0817'} = 'DRANGEDAL';
$borough{'0819'} = 'NOME';
$borough{'0821'} = 'B (TEL.)';
$borough{'0822'} = 'SAUHERAD';
$borough{'0826'} = 'TINN';
$borough{'0827'} = 'HJARTDAL';
$borough{'0828'} = 'SELJORD';
$borough{'0829'} = 'KVITESEID';
$borough{'0830'} = 'NISSEDAL';
$borough{'0831'} = 'FYRESDAL';
$borough{'0833'} = 'TOKKE';
$borough{'0834'} = 'VINJE';
$borough{'0901'} = 'RISR';
$borough{'0904'} = 'GRIMSTAD';
$borough{'0906'} = 'ARENDAL';
$borough{'0911'} = 'GJERSTAD';
$borough{'0912'} = 'VEGRSHEI';
$borough{'0914'} = 'TVEDESTRAND';
$borough{'0919'} = 'FROLAND';
$borough{'0926'} = 'LILLESAND';
$borough{'0928'} = 'BIRKENES';
$borough{'0929'} = 'MLI';
$borough{'0935'} = 'IVELAND';
$borough{'0937'} = 'EVJE OG HORNNES';
$borough{'0938'} = 'BYGLAND';
$borough{'0940'} = 'VALLE';
$borough{'0941'} = 'BYKLE';
$borough{'1001'} = 'KRISTIANSAND';
$borough{'1002'} = 'MANDAL';
$borough{'1003'} = 'FARSUND';
$borough{'1004'} = 'FLEKKEFJORD';
$borough{'1014'} = 'VENNESLA';
$borough{'1017'} = 'SONGDALEN';
$borough{'1018'} = 'SGNE';
$borough{'1021'} = 'MARNARDAL';
$borough{'1026'} = 'SERAL';
$borough{'1027'} = 'AUDNEDAL';
$borough{'1029'} = 'LINDESNES';
$borough{'1032'} = 'LYNGDAL';
$borough{'1034'} = 'HGEBOSTAD';
$borough{'1037'} = 'KVINESDAL';
$borough{'1046'} = 'SIRDAL';
$borough{'1101'} = 'EIGERSUND';
$borough{'1102'} = 'SANDNES';
$borough{'1103'} = 'STAVANGER';
$borough{'1106'} = 'HAUGESUND';
$borough{'1111'} = 'SOKNDAL';
$borough{'1112'} = 'LUND';
$borough{'1114'} = 'BJERKREIM';
$borough{'1119'} = 'H';
$borough{'1120'} = 'KLEPP';
$borough{'1121'} = 'TIME';
$borough{'1122'} = 'GJESDAL';
$borough{'1124'} = 'SOLA';
$borough{'1127'} = 'RANDABERG';
$borough{'1129'} = 'FORSAND';
$borough{'1130'} = 'STRAND';
$borough{'1133'} = 'HJELMELAND';
$borough{'1134'} = 'SULDAL';
$borough{'1135'} = 'SAUDA';
$borough{'1141'} = 'FINNY';
$borough{'1142'} = 'RENNESY';
$borough{'1144'} = 'KVITSY';
$borough{'1145'} = 'BOKN';
$borough{'1146'} = 'TYSVR';
$borough{'1149'} = 'KARMY';
$borough{'1151'} = 'UTSIRA';
$borough{'1160'} = 'VINDAFJORD';
$borough{'1201'} = 'BERGEN';
$borough{'1211'} = 'ETNE';
$borough{'1216'} = 'SVEIO';
$borough{'1219'} = 'BMLO';
$borough{'1221'} = 'STORD';
$borough{'1222'} = 'FITJAR';
$borough{'1223'} = 'TYSNES';
$borough{'1224'} = 'KVINNHERAD';
$borough{'1227'} = 'JONDAL';
$borough{'1228'} = 'ODDA';
$borough{'1231'} = 'ULLENSVANG';
$borough{'1232'} = 'EIDFJORD';
$borough{'1233'} = 'ULVIK';
$borough{'1234'} = 'GRANVIN';
$borough{'1235'} = 'VOSS';
$borough{'1238'} = 'KVAM';
$borough{'1241'} = 'FUSA';
$borough{'1242'} = 'SAMNANGER';
$borough{'1243'} = 'OS (HORDALAND)';
$borough{'1244'} = 'AUSTEVOLL';
$borough{'1245'} = 'SUND';
$borough{'1246'} = 'FJELL';
$borough{'1247'} = 'ASKY';
$borough{'1251'} = 'VAKSDAL';
$borough{'1252'} = 'MODALEN';
$borough{'1253'} = 'OSTERY';
$borough{'1256'} = 'MELAND';
$borough{'1259'} = 'YGARDEN';
$borough{'1260'} = 'RADY';
$borough{'1263'} = 'LINDS';
$borough{'1264'} = 'AUSTRHEIM';
$borough{'1265'} = 'FEDJE';
$borough{'1266'} = 'MASFJORDEN';
$borough{'1401'} = 'FLORA';
$borough{'1411'} = 'GULEN';
$borough{'1412'} = 'SOLUND';
$borough{'1413'} = 'HYLLESTAD';
$borough{'1416'} = 'HYANGER';
$borough{'1417'} = 'VIK';
$borough{'1418'} = 'BALESTRAND';
$borough{'1419'} = 'LEIKANGER';
$borough{'1420'} = 'SOGNDAL';
$borough{'1421'} = 'AURLAND';
$borough{'1422'} = 'LRDAL';
$borough{'1424'} = 'RDAL';
$borough{'1426'} = 'LUSTER';
$borough{'1428'} = 'ASKVOLL';
$borough{'1429'} = 'FJALER';
$borough{'1430'} = 'GAULAR';
$borough{'1431'} = 'JLSTER';
$borough{'1432'} = 'FRDE';
$borough{'1433'} = 'NAUSTDAL';
$borough{'1438'} = 'BREMANGER';
$borough{'1439'} = 'VGSY';
$borough{'1441'} = 'SELJE';
$borough{'1443'} = 'EID';
$borough{'1444'} = 'HORNINDAL';
$borough{'1445'} = 'GLOPPEN';
$borough{'1449'} = 'STRYN';
$borough{'1502'} = 'MOLDE';
$borough{'1503'} = 'KRISTIANSUND';
$borough{'1504'} = 'LESUND';
$borough{'1511'} = 'VANYLVEN';
$borough{'1514'} = 'SANDE (M.R.)';
$borough{'1515'} = 'HERY (M.R.)';
$borough{'1516'} = 'ULSTEIN';
$borough{'1517'} = 'HAREID';
$borough{'1519'} = 'VOLDA';
$borough{'1520'} = 'RSTA';
$borough{'1523'} = 'RSKOG';
$borough{'1524'} = 'NORDDAL';
$borough{'1525'} = 'STRANDA';
$borough{'1526'} = 'STORDAL';
$borough{'1528'} = 'SYKKYLVEN';
$borough{'1529'} = 'SKODJE';
$borough{'1531'} = 'SULA';
$borough{'1532'} = 'GISKE';
$borough{'1534'} = 'HARAM';
$borough{'1535'} = 'VESTNES';
$borough{'1539'} = 'RAUMA';
$borough{'1543'} = 'NESSET';
$borough{'1545'} = 'MIDSUND';
$borough{'1546'} = 'SANDY';
$borough{'1547'} = 'AUKRA';
$borough{'1548'} = 'FRNA';
$borough{'1551'} = 'EIDE';
$borough{'1554'} = 'AVERY';
$borough{'1556'} = 'FREI';
$borough{'1557'} = 'GJEMNES';
$borough{'1560'} = 'TINGVOLL';
$borough{'1563'} = 'SUNNDAL';
$borough{'1566'} = 'SURNADAL';
$borough{'1567'} = 'RINDAL';
$borough{'1571'} = 'HALSA';
$borough{'1573'} = 'SMLA';
$borough{'1576'} = 'AURE';
$borough{'1601'} = 'TRONDHEIM';
$borough{'1612'} = 'HEMNE';
$borough{'1613'} = 'SNILLFJORD';
$borough{'1617'} = 'HITRA';
$borough{'1620'} = 'FRYA';
$borough{'1621'} = 'RLAND';
$borough{'1622'} = 'AGDENES';
$borough{'1624'} = 'RISSA';
$borough{'1627'} = 'BJUGN';
$borough{'1630'} = 'FJORD';
$borough{'1632'} = 'ROAN';
$borough{'1633'} = 'OSEN';
$borough{'1634'} = 'OPPDAL';
$borough{'1635'} = 'RENNEBU';
$borough{'1636'} = 'MELDAL';
$borough{'1638'} = 'ORKDAL';
$borough{'1640'} = 'RROS';
$borough{'1644'} = 'HOLTLEN';
$borough{'1648'} = 'MIDTRE GAULDAL';
$borough{'1653'} = 'MELHUS';
$borough{'1657'} = 'SKAUN';
$borough{'1662'} = 'KLBU';
$borough{'1663'} = 'MALVIK';
$borough{'1664'} = 'SELBU';
$borough{'1665'} = 'TYDAL';
$borough{'1702'} = 'STEINKJER';
$borough{'1703'} = 'NAMSOS';
$borough{'1711'} = 'MERKER';
$borough{'1714'} = 'STJRDAL';
$borough{'1717'} = 'FROSTA';
$borough{'1718'} = 'LEKSVIK';
$borough{'1719'} = 'LEVANGER';
$borough{'1721'} = 'VERDAL';
$borough{'1723'} = 'MOSVIK';
$borough{'1724'} = 'VERRAN';
$borough{'1725'} = 'NAMDALSEID';
$borough{'1729'} = 'INDERY';
$borough{'1736'} = 'SNSA';
$borough{'1738'} = 'LIERNE';
$borough{'1739'} = 'RYRVIK';
$borough{'1740'} = 'NAMSSKOGAN';
$borough{'1742'} = 'GRONG';
$borough{'1743'} = 'HYLANDET';
$borough{'1744'} = 'OVERHALLA';
$borough{'1748'} = 'FOSNES';
$borough{'1749'} = 'FLATANGER';
$borough{'1750'} = 'VIKNA';
$borough{'1751'} = 'NRY';
$borough{'1755'} = 'LEKA';
$borough{'1804'} = 'BOD';
$borough{'1805'} = 'NARVIK';
$borough{'1811'} = 'BINDAL';
$borough{'1812'} = 'SMNA';
$borough{'1813'} = 'BRNNY';
$borough{'1815'} = 'VEGA';
$borough{'1816'} = 'VEVELSTAD';
$borough{'1818'} = 'HERY (N.)';
$borough{'1820'} = 'ALSTAHAUG';
$borough{'1822'} = 'LEIRFJORD';
$borough{'1824'} = 'VEFSN';
$borough{'1825'} = 'GRANE';
$borough{'1826'} = 'HATTFJELLDAL';
$borough{'1827'} = 'DNNA';
$borough{'1828'} = 'NESNA';
$borough{'1832'} = 'HEMNES';
$borough{'1833'} = 'RANA';
$borough{'1834'} = 'LURY';
$borough{'1835'} = 'TRNA';
$borough{'1836'} = 'RDY';
$borough{'1837'} = 'MELY';
$borough{'1838'} = 'GILDESKL';
$borough{'1839'} = 'BEIARN';
$borough{'1840'} = 'SALTDAL';
$borough{'1841'} = 'FAUSKE';
$borough{'1845'} = 'SRFOLD';
$borough{'1848'} = 'STEIGEN';
$borough{'1849'} = 'HAMARY';
$borough{'1850'} = 'TYSFJORD';
$borough{'1851'} = 'LDINGEN';
$borough{'1852'} = 'TJELDSUND';
$borough{'1853'} = 'EVENES';
$borough{'1854'} = 'BALLANGEN';
$borough{'1856'} = 'RST';
$borough{'1857'} = 'VRY';
$borough{'1859'} = 'FLAKSTAD';
$borough{'1860'} = 'VESTVGY';
$borough{'1865'} = 'VGAN';
$borough{'1866'} = 'HADSEL';
$borough{'1867'} = 'B (N.)';
$borough{'1868'} = 'KSNES';
$borough{'1870'} = 'SORTLAND';
$borough{'1871'} = 'ANDY';
$borough{'1874'} = 'MOSKENES';
$borough{'1901'} = 'HARSTAD';
$borough{'1902'} = 'TROMS';
$borough{'1911'} = 'KVFJORD';
$borough{'1913'} = 'SKNLAND';
$borough{'1915'} = 'BJARKY';
$borough{'1917'} = 'IBESTAD';
$borough{'1919'} = 'GRATANGEN';
$borough{'1920'} = 'LAVANGEN';
$borough{'1922'} = 'BARDU';
$borough{'1923'} = 'SALANGEN';
$borough{'1924'} = 'MLSELV';
$borough{'1925'} = 'SRREISA';
$borough{'1926'} = 'DYRY';
$borough{'1927'} = 'TRANY';
$borough{'1928'} = 'TORSKEN';
$borough{'1929'} = 'BERG';
$borough{'1931'} = 'LENVIK';
$borough{'1933'} = 'BALSFJORD';
$borough{'1936'} = 'KARLSY';
$borough{'1938'} = 'LYNGEN';
$borough{'1939'} = 'STORFJORD';
$borough{'1940'} = 'GIVUOTNA KFJORD';
$borough{'1941'} = 'SKJERVY';
$borough{'1942'} = 'NORDREISA';
$borough{'1943'} = 'KVNANGEN';
$borough{'2002'} = 'VARD';
$borough{'2003'} = 'VADS';
$borough{'2004'} = 'HAMMERFEST';
$borough{'2011'} = 'GUOVDAGEAIDNU KAUTOKEINO';
$borough{'2012'} = 'ALTA';
$borough{'2014'} = 'LOPPA';
$borough{'2015'} = 'HASVIK';
$borough{'2017'} = 'KVALSUND';
$borough{'2018'} = 'MSY';
$borough{'2019'} = 'NORDKAPP';
$borough{'2020'} = 'PORSANGER PORSNGU PORSANKI';
$borough{'2021'} = 'KARASJOHKA KARASJOK';
$borough{'2022'} = 'LEBESBY';
$borough{'2023'} = 'GAMVIK';
$borough{'2024'} = 'BERLEVG';
$borough{'2025'} = 'DEATNU TANA';
$borough{'2027'} = 'UNJARGGA NESSEBY';
$borough{'2028'} = 'BTSFJORD';
$borough{'2030'} = 'SR-VARANGER';
$borough{'2111'} = 'SPITSBERGEN';
$borough{'2121'} = 'BJRNYA';
$borough{'2131'} = 'HOPEN';
$borough{'2211'} = 'JAN MAYEN';

## bin/update end

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

Geo::Postcodes::NO - Norwegian postcodes with associated information

=head1 SYNOPSIS

This module can be used object oriented, or as procedures.
Take your pick.

=head2 OBJECTS

use Geo::Postcodes::NO qw(valid);

my $postcode = '1178'; # My postcode.

if (valid($postcode)) # A valid postcode?
{
  my $P = Geo::Postcodes::NO->new($postcode);

  printf "Postcode         '%s'.\n", $P->postcode();
  printf "Postal location: '%s'.\n", $P->location();
  printf "Borough number:  '%s'.\n", $P->borough_number();
  printf "Borough:         '%s'.\n", $P->borough();
  printf "County:          '%s'.\n", $P->county();
  printf "Postcode type:   '%s'.\n", $P->type(); 
}

The test for a valid postcode can also be expressed this way:

my $P = Geo::Postcodes::NO->new($postcode);

if ($P) { ... }

=head2 PROCEDURES

use Geo::Postcodes::NO ':all';

my $postcode = "1178";

if (valid($postcode))
{
  printf "Postcode"        '%s'.\n", $postcode;
  printf "Postal location: '%s'.\n", location_of($postcode);
  printf "Borough number:  '%s'.\n", borough_number_of($postcode);
  printf "Borough:         '%s'.\n", borough_of($postcode);
  printf "County:          '%s'.\n", county_of($postcode);
  printf "Postcode type:   '%s'.\n", type_of($postcode); 
}

=head1 ABSTRACT

Geo::Postcodes::NO - Perl extension for the mapping between norwegian postal
codes, postal locations, and the local administrative levels of boroughs
(kommuner) and counties (fylker).

=head1 DESCRIPTION

Tired of entering the postal location all the time? This is not necessary,
as it is uniquely defined from the postcode. Request the postcode only,
and use this library to get the postal name.

The library can also tell you in which borough by name or number and county
by name the postcode is located. The borough number can be handy, as it is
used when reporting wages and tax to the Norwegian Tax Administration 

=head2 EXPORT

None by default.

The procedures can be imported individually, or I<en block> with 
B<use Geo::Postcodes::NO ':all';>.

=head1 DEPENDENCIES

This module is a subclass of Geo::Postcodes, which must be installed first.

=head1 PROCEDURES and METHODS

These functions can be used as methods or procedures.

=head2 is_method

C<my $boolean = Geo::postcodes::NO::is_method($method);>

C<my $boolean = $object-E<gt>is_method($method);>

Does the specified method exist.

=head2 methods

C<my @methods = Geo::postcodes::NO::methods();>

C<my @methods = $object-E<gt>methods();>

A list of legal methods.

=head2 selection

See the I<Geo::Postcodes> manual. 

=head1 PROCEDURES

Note that the I<xxx_of> procedures return I<undef> when passed an illegal
argument.

=head2 legal

C<my $boolean = Geo::Postcodes::NO::legal($number);>

Do we have a legal postcode; a code that follows the syntax rules?

=head2 valid

C<my $boolean = Geo::Postcodes::NO::valid($number);>

Do we have a valid postcode; a code in actual use?

=head2 location_of

C<my $poststed = Geo::Postcodes::NO::location_of($number);>

The postal location associated with the specified postcode.

=head2 borough_number_of

C<my $kommunenr = Geo::Postcodes::NO::borough_number_of($number);>

The number of the borough (kommune) where the postcode is located.

=head2 kommunenr2kommune

C<my $kommune = Geo::Postcodes::NO::kommunenr2kommune($number);>

The name of the borough (kommune) with the specified borough number.

=head2 borough_of

C<my $kommune = Geo::Postcodes::NO::borough_of($number);>

The name of the borough (kommune) where the postcode is located.

=head2 county_of

C<my $fylke = Geo::Postcodes::NO::county_of($number);>

The name of the county (fylke) where the postcode is located.

=head2 kommunenr2fylke

C<my $fylke = Geo::Postcodes::NO::kommunenr2fylke($number);>

The name of the county (fylke) where the specified borough number
(kommune nummer) is located.

=head2 type_of

C<my $kategori = Geo::Postcodes::NO::type_of($number);>

What kind of postcode is this. The values, as given by the norwegian postal
service, are I<"Bde gateadresser og postbokser">, I<"Flere bruksomrder
(felles)">, I<"Gateadresser">, I<"Kunde med eget postnummer">, I<"Postbokser">,
and I<"Serviceboks">.

This information may not be especially useful.

=head1 METHODS

=head2 new

C<my $P = Geo::Postcodes::NO-E<gt>new($number);>

Create a new postcode object. 

The constructor will return I<undef> when passed an invalid or illegal postcode.
See the description of the I<legal> and I<valid> procedures above.

Either check the postcode with C<legal> before this call,
or test it afterwards; C<if ($P) { ... }>.

=head2 postcode

C<my $postcode = $P-E<gt>postcode();>

The postcode, as given to the constructor.

=head2 location

C<my $location = $P-E<gt>location();>

The postal location associated with the specified postcode.

=head2 borough_number

C<my $borough_number = $P-E<gt>borough_number();>

The number of the borough (kommune) where the postcode is located.

=head2 borough

C<my $borough = $P-E<gt>borough();>

The name of the borough (kommune) where the postcode is located.

=head2 county

C<my $county = $P-E<gt>county();>

The name of the county (fylke) where the postcode is located.

=head2 type

C<my $postal_type = $P-E<gt>type();>

See the description of the procedure I<type_of> above.

=head1 CAVEAT

=head2 POSTCODES

The norwegain postcodes are four digit numbers, in the interval "0000"
to "9999" (and this means that "0010" is legal, while "10" is not).

Use I<legal> to check for legal postcodes, and I<valid> to check if
the postcode is actually in use. Geo::Postcodes::NO->new($postcode)
will return I<undef> if passed an illegal or invalid postcode. 

An attempt to access the methods of a non-existent postcode object will
result in a runtime error. This can be avoided by checking if the postal
code is legal, before creating the object; C<valid($postcode)>
returns true or false.

=head2 LEGAL BOROUGH NUMBERS

Borough (Kommune) numbers are also four digit numbers (not to be confused
with the postcodes), in the interval "0101" to "2399". The two first digits
identifies the county (fylke).

=head2 CHARACTER SET

The library was written using the ISO-8859-1 (iso-latin1) character set, and the
special norwegian letters '', '' and '' occur regularly in the postal locations
and borough and county names. Usage of other character sets may cause havoc.
Unicode is not tested. Some locations in northern norway use sami names, but
the special characters is not handled correctly.

Note that all names are given in UPPER CASE. This is courtesy of the norwegian
postal services. 

=head1 SEE ALSO

The latest version of this library should always be available on CPAN, but see
also the library home page; L<http://bbop.org/perl/GeoPostcodes> for addittional
information and sample usage.

=head1 AUTHOR

Arne Sommer, E<lt>arne@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Arne Sommer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
