package Geo::Postcodes::DK;

use Geo::Postcodes 0.10;
use base qw(Geo::Postcodes);

use strict;
use warnings;

our $VERSION = '0.10';

## Which methods are available ##################################################

my @valid_methods = qw(postcode location address owner type type_verbose); # selection);
  # Used by the 'methods' method.

my %valid_methods;

foreach (@valid_methods)
{
  $valid_methods{$_} = 1;
}

## Private Variables ############################################################

my (%location, %borough, %type, %address, %owner);

## Type Description #############################################################

my %typedesc;

$typedesc{BX} = "Postboks";
$typedesc{ST} = "Gadeadresse";
$typedesc{IO} = "Personlig ejer";
$typedesc{PP} = "Ufrankerede svarforsendelser";

## OO Methods ###################################################################

sub new
{
  my $class      = shift;
  my $postcode     = shift;

  return undef unless valid($postcode);

  my $self = bless \(my $dummy), $class;

  $Geo::Postcodes::postcode_of  {$self} = $postcode;
  $Geo::Postcodes::location_of  {$self} = location_of($postcode);
  # $Geo::Postcodes::borough_of {$self} = borough_of($postcode);
  # $Geo::Postcodes::county_of  {$self} = county_of($postcode);
  $Geo::Postcodes::type_of      {$self} = type_of($postcode);
  $Geo::Postcodes::owner_of     {$self} = owner_of($postcode);
  $Geo::Postcodes::address_of   {$self} = address_of($postcode);

  return $self;
}

sub DESTROY {
  my $dead_body = $_[0];

  delete $Geo::Postcodes::postcode_of  {$dead_body};
  delete $Geo::Postcodes::location_of  {$dead_body};
  # delete $Geo::Postcodes::borough_of {$dead_body};
  # delete $Geo::Postcodes::county_of  {$dead_body};
  delete $Geo::Postcodes::type_of      {$dead_body};
  delete $Geo::Postcodes::owner_of     {$dead_body};
  delete $Geo::Postcodes::address_of   {$dead_body};
}

sub get_methods
{
  return @valid_methods;
}

sub is_method
{
  my $method = shift;
  $method    = shift if $method =~ /Geo::Postcodes/; # Called on an object.

  return 1 if $valid_methods{$method};
  return 0;
}

sub type_verbose # Override the one in the base class.
{
  my $self = shift;
  return unless $self;
  return unless $Geo::Postcodes::type_of{$self};
  return unless $typedesc{$Geo::Postcodes::type_of{$self}};
  return $typedesc{$Geo::Postcodes::type_of{$self}};
}

## Global Procedures ############################################################

sub legal # Is it a legal code, i.e. something that follows the syntax rule.
{
  my $postcode = shift;
  return 0 unless $postcode;
  return 0 unless $postcode =~ /^\d{3,4}$/;
  return 1;
}

sub valid # Is the code in actual use.
{
  my $postcode = shift;
  return 0 unless legal($postcode);

  return 1 if $location{$postcode};
  return 0;
}

sub postcode_of # So that 'selection' does not choke.
{
  my $postcode = shift;
  return $postcode;
}

sub location_of
{
  my $postcode = shift;
  return unless $postcode;

  return $location{$postcode} if $location{$postcode};
  return;
}

sub address_of
{
  my $postcode = shift;
  return unless $postcode;

  return $address{$postcode} if $address{$postcode};
  return;
}

sub owner_of
{
  my $postcode = shift;
  return unless $postcode;

  return $owner{$postcode} if $owner{$postcode};
  return;
}

sub type_of
{
  my $postcode = shift;
  return unless $postcode;
  return unless $type{$postcode};

  return $type{$postcode};
}

sub type_verbose_of
{
  my $postcode = shift;
  return unless $postcode;

  my $type = type_of($postcode);
  return unless $type;

  return type2verbose($type);
}

sub type2verbose
{
  my $type = shift;
  return unless $type;
  return unless $typedesc{$type};
  return $typedesc{$type};
}

sub get_postcodes
{
  return keys %location;
}

## Returns a list of postcodes if called as a procedure; Geo::Postcodes::NO::selection(xx => 'yy')
## Returns a list of objects if called as a method;      Geo::Postcodes::NO->selection(xx => 'yy')

sub selection
{
  return Geo::Postcodes::_selection("Geo::Postcodes::DK", @_);
}

## bin/update begin
## This data structure was auto generated on Wed Jul 19 13:03:36 2006. Do NOT edit it!

$location{'0555'} = "Scanning"; $owner{'0555'} = "Data Scanning A/S, 'Ls Ind'-service";
$location{'0555'} = "Scanning"; $owner{'0555'} = "Data Scanning A/S, 'Ls Ind'-service";
$location{'0800'} = "Hje Taastrup"; $owner{'0800'} = "BG-Bank A/S"; $type{'0800'} = "IO";
$location{'0877'} = "Valby"; $owner{'0877'} = "Aller Press (konkurrencer)"; $type{'0877'} = "IO";
$location{'0900'} = "Kbenhavn C"; $owner{'0900'} = "Kbenhavns Postcenter + erhvervskunder";
$location{'0910'} = "Kbenhavn C"; $type{'0910'} = "PP";
$location{'0929'} = "Kbenhavn C"; $type{'0929'} = "PP";
$location{'0999'} = "Kbenhavn C"; $owner{'0999'} = "DR Byen"; $type{'0999'} = "IO";
$location{'1000'} = "Kbenhavn K"; $owner{'1000'} = "Kbmagergade Postkontor"; $type{'1000'} = "IO";
$location{'1001'} = "Kbenhavn K"; $type{'1001'} = "BX";
$location{'1002'} = "Kbenhavn K"; $type{'1002'} = "BX";
$location{'1003'} = "Kbenhavn K"; $type{'1003'} = "BX";
$location{'1004'} = "Kbenhavn K"; $type{'1004'} = "BX";
$location{'1005'} = "Kbenhavn K"; $type{'1005'} = "BX";
$location{'1006'} = "Kbenhavn K"; $type{'1006'} = "BX";
$location{'1007'} = "Kbenhavn K"; $type{'1007'} = "BX";
$location{'1008'} = "Kbenhavn K"; $type{'1008'} = "BX";
$location{'1009'} = "Kbenhavn K"; $type{'1009'} = "BX";
$location{'1010'} = "Kbenhavn K"; $type{'1010'} = "BX";
$location{'1011'} = "Kbenhavn K"; $type{'1011'} = "BX";
$location{'1012'} = "Kbenhavn K"; $type{'1012'} = "BX";
$location{'1013'} = "Kbenhavn K"; $type{'1013'} = "BX";
$location{'1014'} = "Kbenhavn K"; $type{'1014'} = "BX";
$location{'1015'} = "Kbenhavn K"; $type{'1015'} = "BX";
$location{'1016'} = "Kbenhavn K"; $type{'1016'} = "BX";
$location{'1017'} = "Kbenhavn K"; $type{'1017'} = "BX";
$location{'1018'} = "Kbenhavn K"; $type{'1018'} = "BX";
$location{'1019'} = "Kbenhavn K"; $type{'1019'} = "BX";
$location{'1020'} = "Kbenhavn K"; $type{'1020'} = "BX";
$location{'1021'} = "Kbenhavn K"; $type{'1021'} = "BX";
$location{'1022'} = "Kbenhavn K"; $type{'1022'} = "BX";
$location{'1023'} = "Kbenhavn K"; $type{'1023'} = "BX";
$location{'1024'} = "Kbenhavn K"; $type{'1024'} = "BX";
$location{'1025'} = "Kbenhavn K"; $type{'1025'} = "BX";
$location{'1026'} = "Kbenhavn K"; $type{'1026'} = "BX";
$location{'1045'} = "Kbenhavn K"; $type{'1045'} = "PP";
$location{'1050'} = "Kbenhavn K"; $address{'1050'} = "Kongens Nytorv"; $type{'1050'} = "ST";
$location{'1051'} = "Kbenhavn K"; $address{'1051'} = "Nyhavn"; $type{'1051'} = "ST";
$location{'1052'} = "Kbenhavn K"; $address{'1052'} = "Herluf Trolles Gade"; $type{'1052'} = "ST";
$location{'1053'} = "Kbenhavn K"; $address{'1053'} = "Cort Adelers Gade"; $type{'1053'} = "ST";
$location{'1054'} = "Kbenhavn K"; $address{'1054'} = "Peder Skrams Gade"; $type{'1054'} = "ST";
$location{'1055'} = "Kbenhavn K"; $address{'1055'} = "August Bournonvilles Passage"; $type{'1055'} = "ST";
$location{'1055'} = "Kbenhavn K"; $address{'1055'} = "August Bournonvilles Passage"; $type{'1055'} = "ST";
$location{'1056'} = "Kbenhavn K"; $address{'1056'} = "Heibergsgade"; $type{'1056'} = "ST";
$location{'1057'} = "Kbenhavn K"; $address{'1057'} = "Holbergsgade"; $type{'1057'} = "ST";
$location{'1058'} = "Kbenhavn K"; $address{'1058'} = "Havnegade"; $type{'1058'} = "ST";
$location{'1059'} = "Kbenhavn K"; $address{'1059'} = "Niels Juels Gade"; $type{'1059'} = "ST";
$location{'1060'} = "Kbenhavn K"; $address{'1060'} = "Holmens Kanal"; $type{'1060'} = "ST";
$location{'1061'} = "Kbenhavn K"; $address{'1061'} = "Ved Stranden"; $type{'1061'} = "ST";
$location{'1062'} = "Kbenhavn K"; $address{'1062'} = "Boldhusgade"; $type{'1062'} = "ST";
$location{'1063'} = "Kbenhavn K"; $address{'1063'} = "Laksegade"; $type{'1063'} = "ST";
$location{'1064'} = "Kbenhavn K"; $address{'1064'} = "Asylgade"; $type{'1064'} = "ST";
$location{'1065'} = "Kbenhavn K"; $address{'1065'} = "Fortunstrde"; $type{'1065'} = "ST";
$location{'1066'} = "Kbenhavn K"; $address{'1066'} = "Admiralgade"; $type{'1066'} = "ST";
$location{'1067'} = "Kbenhavn K"; $address{'1067'} = "Nikolaj Plads"; $type{'1067'} = "ST";
$location{'1068'} = "Kbenhavn K"; $address{'1068'} = "Nikolajgade"; $type{'1068'} = "ST";
$location{'1069'} = "Kbenhavn K"; $address{'1069'} = "Bremerholm"; $type{'1069'} = "ST";
$location{'1070'} = "Kbenhavn K"; $address{'1070'} = "Vingrdstrde"; $type{'1070'} = "ST";
$location{'1071'} = "Kbenhavn K"; $address{'1071'} = "Dybensgade"; $type{'1071'} = "ST";
$location{'1072'} = "Kbenhavn K"; $address{'1072'} = "Lille Kirkestrde"; $type{'1072'} = "ST";
$location{'1073'} = "Kbenhavn K"; $address{'1073'} = "Store Kirkestrde"; $type{'1073'} = "ST";
$location{'1074'} = "Kbenhavn K"; $address{'1074'} = "Lille Kongensgade"; $type{'1074'} = "ST";
$location{'1092'} = "Kbenhavn K"; $owner{'1092'} = "Danske Bank A/S"; $type{'1092'} = "IO";
$location{'1093'} = "Kbenhavn K"; $owner{'1093'} = "Danmarks Nationalbank"; $type{'1093'} = "IO";
$location{'1095'} = "Kbenhavn K"; $owner{'1095'} = "Magasin du Nord"; $type{'1095'} = "IO";
$location{'1098'} = "Kbenhavn K"; $owner{'1098'} = "A.P. Mller"; $type{'1098'} = "IO";
$location{'1100'} = "Kbenhavn K"; $address{'1100'} = "stergade"; $type{'1100'} = "ST";
$location{'1101'} = "Kbenhavn K"; $address{'1101'} = "Ny stergade"; $type{'1101'} = "ST";
$location{'1102'} = "Kbenhavn K"; $address{'1102'} = "Pistolstrde"; $type{'1102'} = "ST";
$location{'1103'} = "Kbenhavn K"; $address{'1103'} = "Hovedvagtsgade"; $type{'1103'} = "ST";
$location{'1104'} = "Kbenhavn K"; $address{'1104'} = "Ny Adelgade"; $type{'1104'} = "ST";
$location{'1105'} = "Kbenhavn K"; $address{'1105'} = "Kristen Bernikows Gade"; $type{'1105'} = "ST";
$location{'1106'} = "Kbenhavn K"; $address{'1106'} = "Antonigade"; $type{'1106'} = "ST";
$location{'1107'} = "Kbenhavn K"; $address{'1107'} = "Grnnegade"; $type{'1107'} = "ST";
$location{'1110'} = "Kbenhavn K"; $address{'1110'} = "Store Regnegade"; $type{'1110'} = "ST";
$location{'1111'} = "Kbenhavn K"; $address{'1111'} = "Christian IX's Gade"; $type{'1111'} = "ST";
$location{'1112'} = "Kbenhavn K"; $address{'1112'} = "Pilestrde"; $type{'1112'} = "ST";
$location{'1113'} = "Kbenhavn K"; $address{'1113'} = "Silkegade"; $type{'1113'} = "ST";
$location{'1114'} = "Kbenhavn K"; $address{'1114'} = "Kronprinsensgade"; $type{'1114'} = "ST";
$location{'1115'} = "Kbenhavn K"; $address{'1115'} = "Klareboderne"; $type{'1115'} = "ST";
$location{'1116'} = "Kbenhavn K"; $address{'1116'} = "Mntergade"; $type{'1116'} = "ST";
$location{'1117'} = "Kbenhavn K"; $address{'1117'} = "Gammel Mnt"; $type{'1117'} = "ST";
$location{'1118'} = "Kbenhavn K"; $address{'1118'} = "Svrtegade"; $type{'1118'} = "ST";
$location{'1119'} = "Kbenhavn K"; $address{'1119'} = "Landemrket"; $type{'1119'} = "ST";
$location{'1120'} = "Kbenhavn K"; $address{'1120'} = "Vognmagergade"; $type{'1120'} = "ST";
$location{'1121'} = "Kbenhavn K"; $address{'1121'} = "Lnporten"; $type{'1121'} = "ST";
$location{'1122'} = "Kbenhavn K"; $address{'1122'} = "Sjleboderne"; $type{'1122'} = "ST";
$location{'1123'} = "Kbenhavn K"; $address{'1123'} = "Gothersgade"; $type{'1123'} = "ST";
$location{'1124'} = "Kbenhavn K"; $address{'1124'} = "benr"; $type{'1124'} = "ST";
$location{'1125'} = "Kbenhavn K"; $address{'1125'} = "Suhmsgade"; $type{'1125'} = "ST";
$location{'1126'} = "Kbenhavn K"; $address{'1126'} = "Pustervig"; $type{'1126'} = "ST";
$location{'1127'} = "Kbenhavn K"; $address{'1127'} = "Hauser Plads"; $type{'1127'} = "ST";
$location{'1128'} = "Kbenhavn K"; $address{'1128'} = "Hausergade"; $type{'1128'} = "ST";
$location{'1129'} = "Kbenhavn K"; $address{'1129'} = "Sankt Gertruds Strde"; $type{'1129'} = "ST";
$location{'1130'} = "Kbenhavn K"; $address{'1130'} = "Rosenborggade"; $type{'1130'} = "ST";
$location{'1131'} = "Kbenhavn K"; $address{'1131'} = "Tornebuskegade"; $type{'1131'} = "ST";
$location{'1140'} = "Kbenhavn K"; $owner{'1140'} = "Dagbladet Brsen"; $type{'1140'} = "IO";
$location{'1147'} = "Kbenhavn K"; $owner{'1147'} = "Berlingske Tidende"; $type{'1147'} = "IO";
$location{'1148'} = "Kbenhavn K"; $owner{'1148'} = "Gutenberghus"; $type{'1148'} = "IO";
$location{'1150'} = "Kbenhavn K"; $address{'1150'} = "Kbmagergade"; $type{'1150'} = "ST";
$location{'1151'} = "Kbenhavn K"; $address{'1151'} = "Valkendorfsgade"; $type{'1151'} = "ST";
$location{'1152'} = "Kbenhavn K"; $address{'1152'} = "Lvstrde"; $type{'1152'} = "ST";
$location{'1153'} = "Kbenhavn K"; $address{'1153'} = "Niels Hemmingsens Gade"; $type{'1153'} = "ST";
$location{'1154'} = "Kbenhavn K"; $address{'1154'} = "Grbrdretorv"; $type{'1154'} = "ST";
$location{'1155'} = "Kbenhavn K"; $address{'1155'} = "Kejsergade"; $type{'1155'} = "ST";
$location{'1156'} = "Kbenhavn K"; $address{'1156'} = "Grbrdrestrde"; $type{'1156'} = "ST";
$location{'1157'} = "Kbenhavn K"; $address{'1157'} = "Klosterstrde"; $type{'1157'} = "ST";
$location{'1158'} = "Kbenhavn K"; $address{'1158'} = "Skoubogade"; $type{'1158'} = "ST";
$location{'1159'} = "Kbenhavn K"; $address{'1159'} = "Skindergade"; $type{'1159'} = "ST";
$location{'1160'} = "Kbenhavn K"; $address{'1160'} = "Amagertorv"; $type{'1160'} = "ST";
$location{'1161'} = "Kbenhavn K"; $address{'1161'} = "Vimmelskaftet"; $type{'1161'} = "ST";
$location{'1162'} = "Kbenhavn K"; $address{'1162'} = "Jorcks Passage"; $type{'1162'} = "ST";
$location{'1163'} = "Kbenhavn K"; $address{'1163'} = "Klostergrden"; $type{'1163'} = "ST";
$location{'1164'} = "Kbenhavn K"; $address{'1164'} = "Nygade"; $type{'1164'} = "ST";
$location{'1165'} = "Kbenhavn K"; $address{'1165'} = "Nrregade"; $type{'1165'} = "ST";
$location{'1166'} = "Kbenhavn K"; $address{'1166'} = "Dyrkb"; $type{'1166'} = "ST";
$location{'1167'} = "Kbenhavn K"; $address{'1167'} = "Bispetorvet"; $type{'1167'} = "ST";
$location{'1168'} = "Kbenhavn K"; $address{'1168'} = "Frue Plads"; $type{'1168'} = "ST";
$location{'1169'} = "Kbenhavn K"; $address{'1169'} = "Store Kannikestrde"; $type{'1169'} = "ST";
$location{'1170'} = "Kbenhavn K"; $address{'1170'} = "Lille Kannikestrde"; $type{'1170'} = "ST";
$location{'1171'} = "Kbenhavn K"; $address{'1171'} = "Fiolstrde"; $type{'1171'} = "ST";
$location{'1172'} = "Kbenhavn K"; $address{'1172'} = "Krystalgade"; $type{'1172'} = "ST";
$location{'1173'} = "Kbenhavn K"; $address{'1173'} = "Peder Hvitfeldts Strde"; $type{'1173'} = "ST";
$location{'1174'} = "Kbenhavn K"; $address{'1174'} = "Rosengrden"; $type{'1174'} = "ST";
$location{'1175'} = "Kbenhavn K"; $address{'1175'} = "Kultorvet"; $type{'1175'} = "ST";
$location{'1200'} = "Kbenhavn K"; $address{'1200'} = "Hjbro Plads"; $type{'1200'} = "ST";
$location{'1201'} = "Kbenhavn K"; $address{'1201'} = "Lderstrde"; $type{'1201'} = "ST";
$location{'1202'} = "Kbenhavn K"; $address{'1202'} = "Gammel Strand"; $type{'1202'} = "ST";
$location{'1203'} = "Kbenhavn K"; $address{'1203'} = "Nybrogade"; $type{'1203'} = "ST";
$location{'1204'} = "Kbenhavn K"; $address{'1204'} = "Magstrde"; $type{'1204'} = "ST";
$location{'1205'} = "Kbenhavn K"; $address{'1205'} = "Snaregade"; $type{'1205'} = "ST";
$location{'1206'} = "Kbenhavn K"; $address{'1206'} = "Nabols"; $type{'1206'} = "ST";
$location{'1207'} = "Kbenhavn K"; $address{'1207'} = "Hyskenstrde"; $type{'1207'} = "ST";
$location{'1208'} = "Kbenhavn K"; $address{'1208'} = "Kompagnistrde"; $type{'1208'} = "ST";
$location{'1209'} = "Kbenhavn K"; $address{'1209'} = "Badstuestrde"; $type{'1209'} = "ST";
$location{'1210'} = "Kbenhavn K"; $address{'1210'} = "Knabrostrde"; $type{'1210'} = "ST";
$location{'1211'} = "Kbenhavn K"; $address{'1211'} = "Brolggerstrde"; $type{'1211'} = "ST";
$location{'1212'} = "Kbenhavn K"; $address{'1212'} = "Vindebrogade"; $type{'1212'} = "ST";
$location{'1213'} = "Kbenhavn K"; $address{'1213'} = "Bertel Thorvaldsens Plads"; $type{'1213'} = "ST";
$location{'1214'} = "Kbenhavn K"; $address{'1214'} = "Tjhusgade"; $type{'1214'} = "ST";
$location{'1214'} = "Kbenhavn K"; $address{'1214'} = "Tjhusgade"; $type{'1214'} = "ST";
$location{'1215'} = "Kbenhavn K"; $address{'1215'} = "Brsgade"; $type{'1215'} = "ST";
$location{'1216'} = "Kbenhavn K"; $address{'1216'} = "Slotsholmsgade"; $type{'1216'} = "ST";
$location{'1217'} = "Kbenhavn K"; $address{'1217'} = "Brsen"; $type{'1217'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1218'} = "Kbenhavn K"; $address{'1218'} = "Christiansborg Slotsplads"; $type{'1218'} = "ST";
$location{'1219'} = "Kbenhavn K"; $address{'1219'} = "Christians Brygge ulige nr. + 2-22"; $type{'1219'} = "ST";
$location{'1220'} = "Kbenhavn K"; $address{'1220'} = "Frederiksholms Kanal"; $type{'1220'} = "ST";
$location{'1240'} = "Kbenhavn K"; $owner{'1240'} = "Folketinget"; $type{'1240'} = "IO";
$location{'1250'} = "Kbenhavn K"; $address{'1250'} = "Sankt Ann Plads"; $type{'1250'} = "ST";
$location{'1251'} = "Kbenhavn K"; $address{'1251'} = "Kvsthusgade"; $type{'1251'} = "ST";
$location{'1252'} = "Kbenhavn K"; $address{'1252'} = "Kvsthusbroen"; $type{'1252'} = "ST";
$location{'1253'} = "Kbenhavn K"; $address{'1253'} = "Toldbodgade"; $type{'1253'} = "ST";
$location{'1254'} = "Kbenhavn K"; $address{'1254'} = "Lille Strandstrde"; $type{'1254'} = "ST";
$location{'1255'} = "Kbenhavn K"; $address{'1255'} = "Store Strandstrde"; $type{'1255'} = "ST";
$location{'1256'} = "Kbenhavn K"; $address{'1256'} = "Amaliegade"; $type{'1256'} = "ST";
$location{'1257'} = "Kbenhavn K"; $address{'1257'} = "Amalienborg"; $type{'1257'} = "ST";
$location{'1258'} = "Kbenhavn K"; $address{'1258'} = "Larsens Plads"; $type{'1258'} = "ST";
$location{'1259'} = "Kbenhavn K"; $address{'1259'} = "Trekroner"; $type{'1259'} = "ST";
$location{'1259'} = "Kbenhavn K"; $address{'1259'} = "Trekroner"; $type{'1259'} = "ST";
$location{'1260'} = "Kbenhavn K"; $address{'1260'} = "Bredgade"; $type{'1260'} = "ST";
$location{'1261'} = "Kbenhavn K"; $address{'1261'} = "Palgade"; $type{'1261'} = "ST";
$location{'1263'} = "Kbenhavn K"; $address{'1263'} = "Churchillparken"; $type{'1263'} = "ST";
$location{'1263'} = "Kbenhavn K"; $address{'1263'} = "Churchillparken"; $type{'1263'} = "ST";
$location{'1264'} = "Kbenhavn K"; $address{'1264'} = "Store Kongensgade"; $type{'1264'} = "ST";
$location{'1265'} = "Kbenhavn K"; $address{'1265'} = "Frederiksgade"; $type{'1265'} = "ST";
$location{'1266'} = "Kbenhavn K"; $address{'1266'} = "Bornholmsgade"; $type{'1266'} = "ST";
$location{'1267'} = "Kbenhavn K"; $address{'1267'} = "Hammerensgade"; $type{'1267'} = "ST";
$location{'1268'} = "Kbenhavn K"; $address{'1268'} = "Jens Kofods Gade"; $type{'1268'} = "ST";
$location{'1270'} = "Kbenhavn K"; $address{'1270'} = "Grnningen"; $type{'1270'} = "ST";
$location{'1271'} = "Kbenhavn K"; $address{'1271'} = "Poul Ankers Gade"; $type{'1271'} = "ST";
$location{'1291'} = "Kbenhavn K"; $owner{'1291'} = "J. Lauritzen A/S"; $type{'1291'} = "IO";
$location{'1300'} = "Kbenhavn K"; $address{'1300'} = "Borgergade"; $type{'1300'} = "ST";
$location{'1301'} = "Kbenhavn K"; $address{'1301'} = "Landgreven"; $type{'1301'} = "ST";
$location{'1302'} = "Kbenhavn K"; $address{'1302'} = "Dronningens Tvrgade"; $type{'1302'} = "ST";
$location{'1303'} = "Kbenhavn K"; $address{'1303'} = "Hindegade"; $type{'1303'} = "ST";
$location{'1304'} = "Kbenhavn K"; $address{'1304'} = "Adelgade"; $type{'1304'} = "ST";
$location{'1306'} = "Kbenhavn K"; $address{'1306'} = "Kronprinsessegade"; $type{'1306'} = "ST";
$location{'1307'} = "Kbenhavn K"; $address{'1307'} = "Slvgade"; $type{'1307'} = "ST";
$location{'1307'} = "Kbenhavn K"; $address{'1307'} = "Slvgade"; $type{'1307'} = "ST";
$location{'1308'} = "Kbenhavn K"; $address{'1308'} = "Klerkegade"; $type{'1308'} = "ST";
$location{'1309'} = "Kbenhavn K"; $address{'1309'} = "Rosengade"; $type{'1309'} = "ST";
$location{'1310'} = "Kbenhavn K"; $address{'1310'} = "Fredericiagade"; $type{'1310'} = "ST";
$location{'1311'} = "Kbenhavn K"; $address{'1311'} = "Olfert Fischers Gade"; $type{'1311'} = "ST";
$location{'1312'} = "Kbenhavn K"; $address{'1312'} = "Gammelvagt"; $type{'1312'} = "ST";
$location{'1313'} = "Kbenhavn K"; $address{'1313'} = "Sankt Pauls Gade"; $type{'1313'} = "ST";
$location{'1314'} = "Kbenhavn K"; $address{'1314'} = "Sankt Pauls Plads"; $type{'1314'} = "ST";
$location{'1315'} = "Kbenhavn K"; $address{'1315'} = "Rvegade"; $type{'1315'} = "ST";
$location{'1316'} = "Kbenhavn K"; $address{'1316'} = "Rigensgade"; $type{'1316'} = "ST";
$location{'1317'} = "Kbenhavn K"; $address{'1317'} = "Stokhusgade"; $type{'1317'} = "ST";
$location{'1318'} = "Kbenhavn K"; $address{'1318'} = "Krusemyntegade"; $type{'1318'} = "ST";
$location{'1319'} = "Kbenhavn K"; $address{'1319'} = "Gernersgade"; $type{'1319'} = "ST";
$location{'1320'} = "Kbenhavn K"; $address{'1320'} = "Haregade"; $type{'1320'} = "ST";
$location{'1321'} = "Kbenhavn K"; $address{'1321'} = "Tigergade"; $type{'1321'} = "ST";
$location{'1322'} = "Kbenhavn K"; $address{'1322'} = "Suensonsgade"; $type{'1322'} = "ST";
$location{'1323'} = "Kbenhavn K"; $address{'1323'} = "Hjertensfrydsgade"; $type{'1323'} = "ST";
$location{'1324'} = "Kbenhavn K"; $address{'1324'} = "Elsdyrsgade"; $type{'1324'} = "ST";
$location{'1325'} = "Kbenhavn K"; $address{'1325'} = "Delfingade"; $type{'1325'} = "ST";
$location{'1326'} = "Kbenhavn K"; $address{'1326'} = "Krokodillegade"; $type{'1326'} = "ST";
$location{'1327'} = "Kbenhavn K"; $address{'1327'} = "Vildandegade"; $type{'1327'} = "ST";
$location{'1328'} = "Kbenhavn K"; $address{'1328'} = "Svanegade"; $type{'1328'} = "ST";
$location{'1329'} = "Kbenhavn K"; $address{'1329'} = "Timiansgade"; $type{'1329'} = "ST";
$location{'1349'} = "Kbenhavn K"; $owner{'1349'} = "DSB"; $type{'1349'} = "IO";
$location{'1350'} = "Kbenhavn K"; $address{'1350'} = "ster Voldgade"; $type{'1350'} = "ST";
$location{'1352'} = "Kbenhavn K"; $address{'1352'} = "Rrholmsgade"; $type{'1352'} = "ST";
$location{'1353'} = "Kbenhavn K"; $address{'1353'} = "ster Farimagsgade 1-19 + 2-2D"; $type{'1353'} = "ST";
$location{'1354'} = "Kbenhavn K"; $address{'1354'} = "Ole Suhrs Gade"; $type{'1354'} = "ST";
$location{'1355'} = "Kbenhavn K"; $address{'1355'} = "Gammeltoftsgade"; $type{'1355'} = "ST";
$location{'1356'} = "Kbenhavn K"; $address{'1356'} = "Bartholinsgade"; $type{'1356'} = "ST";
$location{'1357'} = "Kbenhavn K"; $address{'1357'} = "ster Sgade 1 - 36"; $type{'1357'} = "ST";
$location{'1358'} = "Kbenhavn K"; $address{'1358'} = "Nrre Voldgade"; $type{'1358'} = "ST";
$location{'1359'} = "Kbenhavn K"; $address{'1359'} = "Ahlefeldtsgade"; $type{'1359'} = "ST";
$location{'1360'} = "Kbenhavn K"; $address{'1360'} = "Frederiksborggade"; $type{'1360'} = "ST";
$location{'1361'} = "Kbenhavn K"; $address{'1361'} = "Linnsgade"; $type{'1361'} = "ST";
$location{'1361'} = "Kbenhavn K"; $address{'1361'} = "Linnsgade"; $type{'1361'} = "ST";
$location{'1362'} = "Kbenhavn K"; $address{'1362'} = "Rmersgade"; $type{'1362'} = "ST";
$location{'1363'} = "Kbenhavn K"; $address{'1363'} = "Vendersgade"; $type{'1363'} = "ST";
$location{'1364'} = "Kbenhavn K"; $address{'1364'} = "Nrre Farimagsgade"; $type{'1364'} = "ST";
$location{'1365'} = "Kbenhavn K"; $address{'1365'} = "Schacksgade"; $type{'1365'} = "ST";
$location{'1366'} = "Kbenhavn K"; $address{'1366'} = "Nansensgade"; $type{'1366'} = "ST";
$location{'1367'} = "Kbenhavn K"; $address{'1367'} = "Kjeld Langes Gade"; $type{'1367'} = "ST";
$location{'1368'} = "Kbenhavn K"; $address{'1368'} = "Turesensgade"; $type{'1368'} = "ST";
$location{'1369'} = "Kbenhavn K"; $address{'1369'} = "Gyldenlvesgade Lige nr"; $type{'1369'} = "ST";
$location{'1370'} = "Kbenhavn K"; $address{'1370'} = "Nrre Sgade"; $type{'1370'} = "ST";
$location{'1371'} = "Kbenhavn K"; $address{'1371'} = "Storvet"; $type{'1371'} = "ST";
$location{'1390'} = "Kbenhavn K"; $owner{'1390'} = "BG-Bank"; $type{'1390'} = "IO";
$location{'1400'} = "Kbenhavn K"; $address{'1400'} = "Knippelsbro"; $type{'1400'} = "ST";
$location{'1400'} = "Kbenhavn K"; $address{'1400'} = "Knippelsbro"; $type{'1400'} = "ST";
$location{'1401'} = "Kbenhavn K"; $address{'1401'} = "Strandgade"; $type{'1401'} = "ST";
$location{'1402'} = "Kbenhavn K"; $address{'1402'} = "Hammershi Kaj"; $type{'1402'} = "ST";
$location{'1402'} = "Kbenhavn K"; $address{'1402'} = "Hammershi Kaj"; $type{'1402'} = "ST";
$location{'1402'} = "Kbenhavn K"; $address{'1402'} = "Hammershi Kaj"; $type{'1402'} = "ST";
$location{'1402'} = "Kbenhavn K"; $address{'1402'} = "Hammershi Kaj"; $type{'1402'} = "ST";
$location{'1402'} = "Kbenhavn K"; $address{'1402'} = "Hammershi Kaj"; $type{'1402'} = "ST";
$location{'1403'} = "Kbenhavn K"; $address{'1403'} = "Wilders Plads"; $type{'1403'} = "ST";
$location{'1404'} = "Kbenhavn K"; $address{'1404'} = "Kryers Plads"; $type{'1404'} = "ST";
$location{'1405'} = "Kbenhavn K"; $address{'1405'} = "Grnlandske Handels Plads"; $type{'1405'} = "ST";
$location{'1406'} = "Kbenhavn K"; $address{'1406'} = "Christianshavns Kanal"; $type{'1406'} = "ST";
$location{'1407'} = "Kbenhavn K"; $address{'1407'} = "Bdsmandsstrde"; $type{'1407'} = "ST";
$location{'1408'} = "Kbenhavn K"; $address{'1408'} = "Wildersgade"; $type{'1408'} = "ST";
$location{'1409'} = "Kbenhavn K"; $address{'1409'} = "Knippelsbrogade"; $type{'1409'} = "ST";
$location{'1410'} = "Kbenhavn K"; $address{'1410'} = "Christianshavns Torv"; $type{'1410'} = "ST";
$location{'1411'} = "Kbenhavn K"; $address{'1411'} = "Applebys Plads"; $type{'1411'} = "ST";
$location{'1411'} = "Kbenhavn K"; $address{'1411'} = "Applebys Plads"; $type{'1411'} = "ST";
$location{'1412'} = "Kbenhavn K"; $address{'1412'} = "Voldgrden"; $type{'1412'} = "ST";
$location{'1413'} = "Kbenhavn K"; $address{'1413'} = "Ved Kanalen"; $type{'1413'} = "ST";
$location{'1414'} = "Kbenhavn K"; $address{'1414'} = "Overgaden neden Vandet"; $type{'1414'} = "ST";
$location{'1415'} = "Kbenhavn K"; $address{'1415'} = "Overgaden oven Vandet"; $type{'1415'} = "ST";
$location{'1416'} = "Kbenhavn K"; $address{'1416'} = "Sankt Ann Gade"; $type{'1416'} = "ST";
$location{'1417'} = "Kbenhavn K"; $address{'1417'} = "Mikkel Vibes Gade"; $type{'1417'} = "ST";
$location{'1418'} = "Kbenhavn K"; $address{'1418'} = "Sofiegade"; $type{'1418'} = "ST";
$location{'1419'} = "Kbenhavn K"; $address{'1419'} = "Store Sndervoldstrde"; $type{'1419'} = "ST";
$location{'1420'} = "Kbenhavn K"; $address{'1420'} = "Dronningensgade"; $type{'1420'} = "ST";
$location{'1421'} = "Kbenhavn K"; $address{'1421'} = "Lille Sndervoldstrde"; $type{'1421'} = "ST";
$location{'1422'} = "Kbenhavn K"; $address{'1422'} = "Prinsessegade"; $type{'1422'} = "ST";
$location{'1423'} = "Kbenhavn K"; $address{'1423'} = "Amagergade"; $type{'1423'} = "ST";
$location{'1424'} = "Kbenhavn K"; $address{'1424'} = "Christianshavns Voldgade"; $type{'1424'} = "ST";
$location{'1425'} = "Kbenhavn K"; $address{'1425'} = "Ved Volden"; $type{'1425'} = "ST";
$location{'1426'} = "Kbenhavn K"; $address{'1426'} = "Voldboligerne"; $type{'1426'} = "ST";
$location{'1427'} = "Kbenhavn K"; $address{'1427'} = "Brobergsgade"; $type{'1427'} = "ST";
$location{'1428'} = "Kbenhavn K"; $address{'1428'} = "Andreas Bjrns Gade"; $type{'1428'} = "ST";
$location{'1429'} = "Kbenhavn K"; $address{'1429'} = "Burmeistersgade"; $type{'1429'} = "ST";
$location{'1430'} = "Kbenhavn K"; $address{'1430'} = "Bodenhoffs Plads"; $type{'1430'} = "ST";
$location{'1431'} = "Kbenhavn K"; $address{'1431'} = "Islands Plads"; $type{'1431'} = "ST";
$location{'1432'} = "Kbenhavn K"; $address{'1432'} = "Margretheholmsvej"; $type{'1432'} = "ST";
$location{'1432'} = "Kbenhavn K"; $address{'1432'} = "Margretheholmsvej"; $type{'1432'} = "ST";
$location{'1432'} = "Kbenhavn K"; $address{'1432'} = "Margretheholmsvej"; $type{'1432'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1433'} = "Kbenhavn K"; $address{'1433'} = "Christiansholms "; $type{'1433'} = "ST";
$location{'1434'} = "Kbenhavn K"; $address{'1434'} = "Danneskiold-Samses All"; $type{'1434'} = "ST";
$location{'1435'} = "Kbenhavn K"; $address{'1435'} = "Philip de Langes All"; $type{'1435'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1436'} = "Kbenhavn K"; $address{'1436'} = "Kuglegrden"; $type{'1436'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1437'} = "Kbenhavn K"; $address{'1437'} = "Leo Mathisens Vej"; $type{'1437'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1438'} = "Kbenhavn K"; $address{'1438'} = "Judichrs Kvarter"; $type{'1438'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1439'} = "Kbenhavn K"; $address{'1439'} = "H.C. Sneedorffs All"; $type{'1439'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1440'} = "Kbenhavn K"; $address{'1440'} = "Mlkevejen"; $type{'1440'} = "ST";
$location{'1441'} = "Kbenhavn K"; $address{'1441'} = "Norddyssen"; $type{'1441'} = "ST";
$location{'1441'} = "Kbenhavn K"; $address{'1441'} = "Norddyssen"; $type{'1441'} = "ST";
$location{'1441'} = "Kbenhavn K"; $address{'1441'} = "Norddyssen"; $type{'1441'} = "ST";
$location{'1448'} = "Kbenhavn K"; $owner{'1448'} = "Udenrigsministeriet"; $type{'1448'} = "IO";
$location{'1450'} = "Kbenhavn K"; $address{'1450'} = "Nytorv"; $type{'1450'} = "ST";
$location{'1451'} = "Kbenhavn K"; $address{'1451'} = "Larslejsstrde"; $type{'1451'} = "ST";
$location{'1452'} = "Kbenhavn K"; $address{'1452'} = "Teglgrdstrde"; $type{'1452'} = "ST";
$location{'1453'} = "Kbenhavn K"; $address{'1453'} = "Sankt Peders Strde"; $type{'1453'} = "ST";
$location{'1454'} = "Kbenhavn K"; $address{'1454'} = "Larsbjrnsstrde"; $type{'1454'} = "ST";
$location{'1455'} = "Kbenhavn K"; $address{'1455'} = "Studiestrde 1-49 + 2-42"; $type{'1455'} = "ST";
$location{'1456'} = "Kbenhavn K"; $address{'1456'} = "Vestergade"; $type{'1456'} = "ST";
$location{'1457'} = "Kbenhavn K"; $address{'1457'} = "Gammeltorv"; $type{'1457'} = "ST";
$location{'1458'} = "Kbenhavn K"; $address{'1458'} = "Kattesundet"; $type{'1458'} = "ST";
$location{'1459'} = "Kbenhavn K"; $address{'1459'} = "Frederiksberggade"; $type{'1459'} = "ST";
$location{'1460'} = "Kbenhavn K"; $address{'1460'} = "Mikkel Bryggers Gade"; $type{'1460'} = "ST";
$location{'1461'} = "Kbenhavn K"; $address{'1461'} = "Slutterigade"; $type{'1461'} = "ST";
$location{'1462'} = "Kbenhavn K"; $address{'1462'} = "Lavendelstrde"; $type{'1462'} = "ST";
$location{'1463'} = "Kbenhavn K"; $address{'1463'} = "Farvergade"; $type{'1463'} = "ST";
$location{'1464'} = "Kbenhavn K"; $address{'1464'} = "Hestemllestrde"; $type{'1464'} = "ST";
$location{'1465'} = "Kbenhavn K"; $address{'1465'} = "Gsegade"; $type{'1465'} = "ST";
$location{'1466'} = "Kbenhavn K"; $address{'1466'} = "Rdhusstrde"; $type{'1466'} = "ST";
$location{'1467'} = "Kbenhavn K"; $address{'1467'} = "Vandkunsten"; $type{'1467'} = "ST";
$location{'1468'} = "Kbenhavn K"; $address{'1468'} = "Lngangstrde"; $type{'1468'} = "ST";
$location{'1470'} = "Kbenhavn K"; $address{'1470'} = "Stormgade 2-16"; $type{'1470'} = "ST";
$location{'1471'} = "Kbenhavn K"; $address{'1471'} = "Ny Vestergade"; $type{'1471'} = "ST";
$location{'1472'} = "Kbenhavn K"; $address{'1472'} = "Ny Kongensgade,  til 17 + til 16"; $type{'1472'} = "ST";
$location{'1473'} = "Kbenhavn K"; $address{'1473'} = "Bryghusgade"; $type{'1473'} = "ST";
$location{'1500'} = "Kbenhavn V"; $owner{'1500'} = "Vesterbro Postkontor"; $type{'1500'} = "IO";
$location{'1501'} = "Kbenhavn V"; $type{'1501'} = "BX";
$location{'1502'} = "Kbenhavn V"; $type{'1502'} = "BX";
$location{'1503'} = "Kbenhavn V"; $type{'1503'} = "BX";
$location{'1504'} = "Kbenhavn V"; $type{'1504'} = "BX";
$location{'1505'} = "Kbenhavn V"; $type{'1505'} = "BX";
$location{'1506'} = "Kbenhavn V"; $type{'1506'} = "BX";
$location{'1507'} = "Kbenhavn V"; $type{'1507'} = "BX";
$location{'1508'} = "Kbenhavn V"; $type{'1508'} = "BX";
$location{'1509'} = "Kbenhavn V"; $type{'1509'} = "BX";
$location{'1510'} = "Kbenhavn V"; $type{'1510'} = "BX";
$location{'1532'} = "Kbenhavn V"; $owner{'1532'} = "Internationalt Postcenter, returforsendelser + consignment"; $type{'1532'} = "IO";
$location{'1533'} = "Kbenhavn V"; $owner{'1533'} = "Internationalt Postcenter"; $type{'1533'} = "IO";
$location{'1550'} = "Kbenhavn V"; $address{'1550'} = "Bag Rdhuset"; $type{'1550'} = "ST";
$location{'1550'} = "Kbenhavn V"; $address{'1550'} = "Bag Rdhuset"; $type{'1550'} = "ST";
$location{'1551'} = "Kbenhavn V"; $address{'1551'} = "Jarmers Plads"; $type{'1551'} = "ST";
$location{'1552'} = "Kbenhavn V"; $address{'1552'} = "Vester Voldgade"; $type{'1552'} = "ST";
$location{'1553'} = "Kbenhavn V"; $address{'1553'} = "Langebro"; $type{'1553'} = "ST";
$location{'1553'} = "Kbenhavn V"; $address{'1553'} = "Langebro"; $type{'1553'} = "ST";
$location{'1554'} = "Kbenhavn V"; $address{'1554'} = "Studiestrde 51-69 + 46-54"; $type{'1554'} = "ST";
$location{'1555'} = "Kbenhavn V"; $address{'1555'} = "Stormgade Ulige nr + 18-20"; $type{'1555'} = "ST";
$location{'1556'} = "Kbenhavn V"; $address{'1556'} = "Dantes Plads"; $type{'1556'} = "ST";
$location{'1557'} = "Kbenhavn V"; $address{'1557'} = "Ny Kongensgade, fra 18 + fra 19"; $type{'1557'} = "ST";
$location{'1558'} = "Kbenhavn V"; $address{'1558'} = "Christiansborggade"; $type{'1558'} = "ST";
$location{'1559'} = "Kbenhavn V"; $address{'1559'} = "Christians Brygge 24 - 30"; $type{'1559'} = "ST";
$location{'1560'} = "Kbenhavn V"; $address{'1560'} = "Kalvebod Brygge"; $type{'1560'} = "ST";
$location{'1561'} = "Kbenhavn V"; $address{'1561'} = "Fisketorvet"; $type{'1561'} = "ST";
$location{'1561'} = "Kbenhavn V"; $address{'1561'} = "Fisketorvet"; $type{'1561'} = "ST";
$location{'1562'} = "Kbenhavn V"; $address{'1562'} = "Hambrosgade"; $type{'1562'} = "ST";
$location{'1563'} = "Kbenhavn V"; $address{'1563'} = "Otto Mnsteds Plads"; $type{'1563'} = "ST";
$location{'1564'} = "Kbenhavn V"; $address{'1564'} = "Rysensteensgade"; $type{'1564'} = "ST";
$location{'1566'} = "Kbenhavn V"; $owner{'1566'} = "Post Danmark A/S"; $type{'1566'} = "IO";
$location{'1567'} = "Kbenhavn V"; $address{'1567'} = "Polititorvet"; $type{'1567'} = "ST";
$location{'1568'} = "Kbenhavn V"; $address{'1568'} = "Mitchellsgade"; $type{'1568'} = "ST";
$location{'1569'} = "Kbenhavn V"; $address{'1569'} = "Edvard Falcks Gade"; $type{'1569'} = "ST";
$location{'1570'} = "Kbenhavn V"; $address{'1570'} = "Kbenhavns Hovedbanegrd"; $type{'1570'} = "ST";
$location{'1570'} = "Kbenhavn V"; $address{'1570'} = "Kbenhavns Hovedbanegrd"; $type{'1570'} = "ST";
$location{'1571'} = "Kbenhavn V"; $address{'1571'} = "Otto Mnsteds Gade"; $type{'1571'} = "ST";
$location{'1572'} = "Kbenhavn V"; $address{'1572'} = "Anker Heegaards Gade"; $type{'1572'} = "ST";
$location{'1573'} = "Kbenhavn V"; $address{'1573'} = "Puggaardsgade"; $type{'1573'} = "ST";
$location{'1574'} = "Kbenhavn V"; $address{'1574'} = "Niels Brocks Gade"; $type{'1574'} = "ST";
$location{'1575'} = "Kbenhavn V"; $address{'1575'} = "Ved Glyptoteket"; $type{'1575'} = "ST";
$location{'1576'} = "Kbenhavn V"; $address{'1576'} = "Stoltenbergsgade"; $type{'1576'} = "ST";
$location{'1577'} = "Kbenhavn V"; $address{'1577'} = "Bernstorffsgade"; $type{'1577'} = "ST";
$location{'1590'} = "Kbenhavn V"; $owner{'1590'} = "Realkredit Danmark"; $type{'1590'} = "IO";
$location{'1592'} = "Kbenhavn V"; $owner{'1592'} = "Kbenhavns Socialdirektorat"; $type{'1592'} = "IO";
$location{'1599'} = "Kbenhavn V"; $owner{'1599'} = "Kbenhavns Rdhus"; $type{'1599'} = "IO";
$location{'1600'} = "Kbenhavn V"; $address{'1600'} = "Gyldenlvesgade Ulige nr."; $type{'1600'} = "ST";
$location{'1601'} = "Kbenhavn V"; $address{'1601'} = "Vester Sgade"; $type{'1601'} = "ST";
$location{'1602'} = "Kbenhavn V"; $address{'1602'} = "Nyropsgade"; $type{'1602'} = "ST";
$location{'1603'} = "Kbenhavn V"; $address{'1603'} = "Dahlerupsgade"; $type{'1603'} = "ST";
$location{'1604'} = "Kbenhavn V"; $address{'1604'} = "Kampmannsgade"; $type{'1604'} = "ST";
$location{'1605'} = "Kbenhavn V"; $address{'1605'} = "Herholdtsgade"; $type{'1605'} = "ST";
$location{'1606'} = "Kbenhavn V"; $address{'1606'} = "Vester Farimagsgade"; $type{'1606'} = "ST";
$location{'1607'} = "Kbenhavn V"; $address{'1607'} = "Staunings Plads"; $type{'1607'} = "ST";
$location{'1608'} = "Kbenhavn V"; $address{'1608'} = "Jernbanegade"; $type{'1608'} = "ST";
$location{'1609'} = "Kbenhavn V"; $address{'1609'} = "Axeltorv"; $type{'1609'} = "ST";
$location{'1610'} = "Kbenhavn V"; $address{'1610'} = "Gammel Kongevej 1-51 + 2-10"; $type{'1610'} = "ST";
$location{'1611'} = "Kbenhavn V"; $address{'1611'} = "Hammerichsgade"; $type{'1611'} = "ST";
$location{'1612'} = "Kbenhavn V"; $address{'1612'} = "Ved Vesterport"; $type{'1612'} = "ST";
$location{'1613'} = "Kbenhavn V"; $address{'1613'} = "Meldahlsgade"; $type{'1613'} = "ST";
$location{'1614'} = "Kbenhavn V"; $address{'1614'} = "Trommesalen"; $type{'1614'} = "ST";
$location{'1615'} = "Kbenhavn V"; $address{'1615'} = "Sankt Jrgens All"; $type{'1615'} = "ST";
$location{'1616'} = "Kbenhavn V"; $address{'1616'} = "Stenosgade"; $type{'1616'} = "ST";
$location{'1617'} = "Kbenhavn V"; $address{'1617'} = "Bagerstrde"; $type{'1617'} = "ST";
$location{'1618'} = "Kbenhavn V"; $address{'1618'} = "Tullinsgade"; $type{'1618'} = "ST";
$location{'1619'} = "Kbenhavn V"; $address{'1619'} = "Vrnedamsvej Lige nr."; $type{'1619'} = "ST";
$location{'1620'} = "Kbenhavn V"; $address{'1620'} = "Vesterbros Torv"; $type{'1620'} = "ST";
$location{'1620'} = "Kbenhavn V"; $address{'1620'} = "Vesterbros Torv"; $type{'1620'} = "ST";
$location{'1621'} = "Kbenhavn V"; $address{'1621'} = "Frederiksberg All 1 - 13B"; $type{'1621'} = "ST";
$location{'1622'} = "Kbenhavn V"; $address{'1622'} = "Boyesgade Ulige nr"; $type{'1622'} = "ST";
$location{'1623'} = "Kbenhavn V"; $address{'1623'} = "Kingosgade 1-9 + 2-6"; $type{'1623'} = "ST";
$location{'1624'} = "Kbenhavn V"; $address{'1624'} = "Brorsonsgade"; $type{'1624'} = "ST";
$location{'1630'} = "Kbenhavn V"; $owner{'1630'} = "Tivoli A/S"; $type{'1630'} = "IO";
$location{'1631'} = "Kbenhavn V"; $address{'1631'} = "Herman Triers Plads"; $type{'1631'} = "ST";
$location{'1632'} = "Kbenhavn V"; $address{'1632'} = "Julius Thomsens Gade Lige nr"; $type{'1632'} = "ST";
$location{'1633'} = "Kbenhavn V"; $address{'1633'} = "Kleinsgade"; $type{'1633'} = "ST";
$location{'1634'} = "Kbenhavn V"; $address{'1634'} = "Rosenrns All 2-18"; $type{'1634'} = "ST";
$location{'1635'} = "Kbenhavn V"; $address{'1635'} = "boulevard 1-13"; $type{'1635'} = "ST";
$location{'1639'} = "Kbenhavn V"; $owner{'1639'} = "Kbenhavns Skatteforvaltning"; $type{'1639'} = "IO";
$location{'1640'} = "Kbenhavn V"; $owner{'1640'} = "Kbenhavns Folkeregister"; $type{'1640'} = "IO";
$location{'1650'} = "Kbenhavn V"; $address{'1650'} = "Istedgade"; $type{'1650'} = "ST";
$location{'1651'} = "Kbenhavn V"; $address{'1651'} = "Reventlowsgade"; $type{'1651'} = "ST";
$location{'1652'} = "Kbenhavn V"; $address{'1652'} = "Colbjrnsensgade"; $type{'1652'} = "ST";
$location{'1653'} = "Kbenhavn V"; $address{'1653'} = "Helgolandsgade"; $type{'1653'} = "ST";
$location{'1654'} = "Kbenhavn V"; $address{'1654'} = "Abel Cathrines Gade"; $type{'1654'} = "ST";
$location{'1655'} = "Kbenhavn V"; $address{'1655'} = "Viktoriagade"; $type{'1655'} = "ST";
$location{'1656'} = "Kbenhavn V"; $address{'1656'} = "Gasvrksvej"; $type{'1656'} = "ST";
$location{'1657'} = "Kbenhavn V"; $address{'1657'} = "Eskildsgade"; $type{'1657'} = "ST";
$location{'1658'} = "Kbenhavn V"; $address{'1658'} = "Absalonsgade"; $type{'1658'} = "ST";
$location{'1659'} = "Kbenhavn V"; $address{'1659'} = "Svendsgade"; $type{'1659'} = "ST";
$location{'1660'} = "Kbenhavn V"; $address{'1660'} = "Otto Krabbes Plads"; $type{'1660'} = "ST";
$location{'1660'} = "Kbenhavn V"; $address{'1660'} = "Otto Krabbes Plads"; $type{'1660'} = "ST";
$location{'1661'} = "Kbenhavn V"; $address{'1661'} = "Westend"; $type{'1661'} = "ST";
$location{'1662'} = "Kbenhavn V"; $address{'1662'} = "Saxogade"; $type{'1662'} = "ST";
$location{'1663'} = "Kbenhavn V"; $address{'1663'} = "Oehlenschlgersgade"; $type{'1663'} = "ST";
$location{'1664'} = "Kbenhavn V"; $address{'1664'} = "Kaalundsgade"; $type{'1664'} = "ST";
$location{'1665'} = "Kbenhavn V"; $address{'1665'} = "Valdemarsgade"; $type{'1665'} = "ST";
$location{'1666'} = "Kbenhavn V"; $address{'1666'} = "Matthusgade"; $type{'1666'} = "ST";
$location{'1667'} = "Kbenhavn V"; $address{'1667'} = "Frederiksstadsgade"; $type{'1667'} = "ST";
$location{'1668'} = "Kbenhavn V"; $address{'1668'} = "Mysundegade"; $type{'1668'} = "ST";
$location{'1669'} = "Kbenhavn V"; $address{'1669'} = "Flensborggade"; $type{'1669'} = "ST";
$location{'1670'} = "Kbenhavn V"; $address{'1670'} = "Enghave Plads"; $type{'1670'} = "ST";
$location{'1671'} = "Kbenhavn V"; $address{'1671'} = "Haderslevgade"; $type{'1671'} = "ST";
$location{'1671'} = "Kbenhavn V"; $address{'1671'} = "Haderslevgade"; $type{'1671'} = "ST";
$location{'1672'} = "Kbenhavn V"; $address{'1672'} = "Broagergade"; $type{'1672'} = "ST";
$location{'1673'} = "Kbenhavn V"; $address{'1673'} = "Ullerupgade"; $type{'1673'} = "ST";
$location{'1674'} = "Kbenhavn V"; $address{'1674'} = "Enghavevej, til 79 + til 78"; $type{'1674'} = "ST";
$location{'1675'} = "Kbenhavn V"; $address{'1675'} = "Kongshjgade"; $type{'1675'} = "ST";
$location{'1676'} = "Kbenhavn V"; $address{'1676'} = "Sankelmarksgade"; $type{'1676'} = "ST";
$location{'1677'} = "Kbenhavn V"; $address{'1677'} = "Grstensgade"; $type{'1677'} = "ST";
$location{'1699'} = "Kbenhavn V"; $address{'1699'} = "Staldgade"; $type{'1699'} = "ST";
$location{'1700'} = "Kbenhavn V"; $address{'1700'} = "Halmtorvet"; $type{'1700'} = "ST";
$location{'1701'} = "Kbenhavn V"; $address{'1701'} = "Reverdilsgade"; $type{'1701'} = "ST";
$location{'1702'} = "Kbenhavn V"; $address{'1702'} = "Stampesgade"; $type{'1702'} = "ST";
$location{'1703'} = "Kbenhavn V"; $address{'1703'} = "Lille Colbjrnsensgade"; $type{'1703'} = "ST";
$location{'1704'} = "Kbenhavn V"; $address{'1704'} = "Tietgensgade"; $type{'1704'} = "ST";
$location{'1705'} = "Kbenhavn V"; $address{'1705'} = "Ingerslevsgade"; $type{'1705'} = "ST";
$location{'1706'} = "Kbenhavn V"; $address{'1706'} = "Lille Istedgade"; $type{'1706'} = "ST";
$location{'1707'} = "Kbenhavn V"; $address{'1707'} = "Maria Kirkeplads"; $type{'1707'} = "ST";
$location{'1708'} = "Kbenhavn V"; $address{'1708'} = "Eriksgade"; $type{'1708'} = "ST";
$location{'1709'} = "Kbenhavn V"; $address{'1709'} = "Skydebanegade"; $type{'1709'} = "ST";
$location{'1710'} = "Kbenhavn V"; $address{'1710'} = "Kvgtorvsgade"; $type{'1710'} = "ST";
$location{'1711'} = "Kbenhavn V"; $address{'1711'} = "Flsketorvet"; $type{'1711'} = "ST";
$location{'1712'} = "Kbenhavn V"; $address{'1712'} = "Hkerboderne"; $type{'1712'} = "ST";
$location{'1713'} = "Kbenhavn V"; $address{'1713'} = "Kvgtorvet"; $type{'1713'} = "ST";
$location{'1714'} = "Kbenhavn V"; $address{'1714'} = "Kdboderne"; $type{'1714'} = "ST";
$location{'1715'} = "Kbenhavn V"; $address{'1715'} = "Slagtehusgade"; $type{'1715'} = "ST";
$location{'1716'} = "Kbenhavn V"; $address{'1716'} = "Slagterboderne"; $type{'1716'} = "ST";
$location{'1717'} = "Kbenhavn V"; $address{'1717'} = "Skelbkgade"; $type{'1717'} = "ST";
$location{'1718'} = "Kbenhavn V"; $address{'1718'} = "Sommerstedgade"; $type{'1718'} = "ST";
$location{'1719'} = "Kbenhavn V"; $address{'1719'} = "Krusgade"; $type{'1719'} = "ST";
$location{'1720'} = "Kbenhavn V"; $address{'1720'} = "Snder Boulevard"; $type{'1720'} = "ST";
$location{'1721'} = "Kbenhavn V"; $address{'1721'} = "Dybblsgade"; $type{'1721'} = "ST";
$location{'1722'} = "Kbenhavn V"; $address{'1722'} = "Godsbanegade"; $type{'1722'} = "ST";
$location{'1723'} = "Kbenhavn V"; $address{'1723'} = "Letlandsgade"; $type{'1723'} = "ST";
$location{'1724'} = "Kbenhavn V"; $address{'1724'} = "Estlandsgade"; $type{'1724'} = "ST";
$location{'1725'} = "Kbenhavn V"; $address{'1725'} = "Esbern Snares Gade"; $type{'1725'} = "ST";
$location{'1726'} = "Kbenhavn V"; $address{'1726'} = "Arkonagade"; $type{'1726'} = "ST";
$location{'1727'} = "Kbenhavn V"; $address{'1727'} = "Asger Rygs Gade"; $type{'1727'} = "ST";
$location{'1728'} = "Kbenhavn V"; $address{'1728'} = "Skjalm Hvides Gade"; $type{'1728'} = "ST";
$location{'1729'} = "Kbenhavn V"; $address{'1729'} = "Sigerstedgade"; $type{'1729'} = "ST";
$location{'1730'} = "Kbenhavn V"; $address{'1730'} = "Knud Lavards Gade"; $type{'1730'} = "ST";
$location{'1731'} = "Kbenhavn V"; $address{'1731'} = "Erik Ejegods Gade"; $type{'1731'} = "ST";
$location{'1732'} = "Kbenhavn V"; $address{'1732'} = "Bodilsgade"; $type{'1732'} = "ST";
$location{'1733'} = "Kbenhavn V"; $address{'1733'} = "Palnatokesgade"; $type{'1733'} = "ST";
$location{'1734'} = "Kbenhavn V"; $address{'1734'} = "Heilsgade"; $type{'1734'} = "ST";
$location{'1735'} = "Kbenhavn V"; $address{'1735'} = "Rddinggade"; $type{'1735'} = "ST";
$location{'1736'} = "Kbenhavn V"; $address{'1736'} = "Bevtoftgade"; $type{'1736'} = "ST";
$location{'1737'} = "Kbenhavn V"; $address{'1737'} = "Bustrupgade"; $type{'1737'} = "ST";
$location{'1738'} = "Kbenhavn V"; $address{'1738'} = "Stenderupgade"; $type{'1738'} = "ST";
$location{'1739'} = "Kbenhavn V"; $address{'1739'} = "Enghave Passage"; $type{'1739'} = "ST";
$location{'1748'} = "Kbenhavn V"; $address{'1748'} = "Kammasvej 2"; $type{'1748'} = "ST";
$location{'1749'} = "Kbenhavn V"; $address{'1749'} = "Rahbeks All 3-15"; $type{'1749'} = "ST";
$location{'1750'} = "Kbenhavn V"; $address{'1750'} = "Vesterflledvej"; $type{'1750'} = "ST";
$location{'1751'} = "Kbenhavn V"; $address{'1751'} = "Sundevedsgade"; $type{'1751'} = "ST";
$location{'1752'} = "Kbenhavn V"; $address{'1752'} = "Tndergade"; $type{'1752'} = "ST";
$location{'1753'} = "Kbenhavn V"; $address{'1753'} = "Ballumgade"; $type{'1753'} = "ST";
$location{'1754'} = "Kbenhavn V"; $address{'1754'} = "Hedebygade"; $type{'1754'} = "ST";
$location{'1755'} = "Kbenhavn V"; $address{'1755'} = "Mgeltndergade"; $type{'1755'} = "ST";
$location{'1756'} = "Kbenhavn V"; $address{'1756'} = "Amerikavej"; $type{'1756'} = "ST";
$location{'1757'} = "Kbenhavn V"; $address{'1757'} = "Trjborggade"; $type{'1757'} = "ST";
$location{'1758'} = "Kbenhavn V"; $address{'1758'} = "Lyrskovgade"; $type{'1758'} = "ST";
$location{'1759'} = "Kbenhavn V"; $address{'1759'} = "Rejsbygade"; $type{'1759'} = "ST";
$location{'1760'} = "Kbenhavn V"; $address{'1760'} = "Ny Carlsberg Vej"; $type{'1760'} = "ST";
$location{'1761'} = "Kbenhavn V"; $address{'1761'} = "Ejderstedgade"; $type{'1761'} = "ST";
$location{'1762'} = "Kbenhavn V"; $address{'1762'} = "Slesvigsgade"; $type{'1762'} = "ST";
$location{'1763'} = "Kbenhavn V"; $address{'1763'} = "Dannevirkegade"; $type{'1763'} = "ST";
$location{'1764'} = "Kbenhavn V"; $address{'1764'} = "Alsgade"; $type{'1764'} = "ST";
$location{'1765'} = "Kbenhavn V"; $address{'1765'} = "Angelgade"; $type{'1765'} = "ST";
$location{'1766'} = "Kbenhavn V"; $address{'1766'} = "Slien"; $type{'1766'} = "ST";
$location{'1770'} = "Kbenhavn V"; $address{'1770'} = "Carstensgade"; $type{'1770'} = "ST";
$location{'1771'} = "Kbenhavn V"; $address{'1771'} = "Lundbyesgade"; $type{'1771'} = "ST";
$location{'1772'} = "Kbenhavn V"; $address{'1772'} = "Ernst Meyers Gade"; $type{'1772'} = "ST";
$location{'1773'} = "Kbenhavn V"; $address{'1773'} = "Bissensgade"; $type{'1773'} = "ST";
$location{'1774'} = "Kbenhavn V"; $address{'1774'} = "Kchlersgade"; $type{'1774'} = "ST";
$location{'1775'} = "Kbenhavn V"; $address{'1775'} = "Freundsgade"; $type{'1775'} = "ST";
$location{'1777'} = "Kbenhavn V"; $address{'1777'} = "Jerichausgade"; $type{'1777'} = "ST";
$location{'1778'} = "Kbenhavn V"; $address{'1778'} = "Pasteursvej"; $type{'1778'} = "ST";
$location{'1780'} = "Kbenhavn V"; $owner{'1780'} = "Erhvervskunder";
$location{'1782'} = "Kbenhavn V"; $type{'1782'} = "PP";
$location{'1784'} = "Kbenhavn V"; $owner{'1784'} = "Forlagsgruppen (ufrankerede svarforsendelser)"; $type{'1784'} = "IO";
$location{'1785'} = "Kbenhavn V"; $owner{'1785'} = "Politiken og Ekstrabladet"; $type{'1785'} = "IO";
$location{'1786'} = "Kbenhavn V"; $owner{'1786'} = "Unibank"; $type{'1786'} = "IO";
$location{'1787'} = "Kbenhavn V"; $owner{'1787'} = "Dansk Industri"; $type{'1787'} = "IO";
$location{'1788'} = "Kbenhavn V"; $owner{'1788'} = "Erhvervskunder";
$location{'1789'} = "Kbenhavn V"; $owner{'1789'} = "Star Tour A/S"; $type{'1789'} = "IO";
$location{'1790'} = "Kbenhavn V"; $owner{'1790'} = "Erhvervskunder";
$location{'1795'} = "Kbenhavn V"; $owner{'1795'} = "Bogklubforlag"; $type{'1795'} = "IO";
$location{'1799'} = "Kbenhavn V"; $owner{'1799'} = "Carlsberg"; $type{'1799'} = "IO";
$location{'1800'} = "Frederiksberg C"; $address{'1800'} = "Vesterbrogade, fra 152 og 153"; $type{'1800'} = "ST";
$location{'1801'} = "Frederiksberg C"; $address{'1801'} = "Rahbeks All 2-36 + 17-23"; $type{'1801'} = "ST";
$location{'1802'} = "Frederiksberg C"; $address{'1802'} = "Halls All"; $type{'1802'} = "ST";
$location{'1803'} = "Frederiksberg C"; $address{'1803'} = "Brndsteds All"; $type{'1803'} = "ST";
$location{'1804'} = "Frederiksberg C"; $address{'1804'} = "Bakkegrds All"; $type{'1804'} = "ST";
$location{'1805'} = "Frederiksberg C"; $address{'1805'} = "Kammasvej 1-3 + 4"; $type{'1805'} = "ST";
$location{'1806'} = "Frederiksberg C"; $address{'1806'} = "Jacobys All"; $type{'1806'} = "ST";
$location{'1807'} = "Frederiksberg C"; $address{'1807'} = "Schlegels All"; $type{'1807'} = "ST";
$location{'1808'} = "Frederiksberg C"; $address{'1808'} = "Asmussens All"; $type{'1808'} = "ST";
$location{'1809'} = "Frederiksberg C"; $address{'1809'} = "Frydendalsvej"; $type{'1809'} = "ST";
$location{'1810'} = "Frederiksberg C"; $address{'1810'} = "Platanvej"; $type{'1810'} = "ST";
$location{'1811'} = "Frederiksberg C"; $address{'1811'} = "Asgrdsvej"; $type{'1811'} = "ST";
$location{'1812'} = "Frederiksberg C"; $address{'1812'} = "Kochsvej"; $type{'1812'} = "ST";
$location{'1813'} = "Frederiksberg C"; $address{'1813'} = "Henrik Ibsens Vej"; $type{'1813'} = "ST";
$location{'1814'} = "Frederiksberg C"; $address{'1814'} = "Carit Etlars Vej"; $type{'1814'} = "ST";
$location{'1815'} = "Frederiksberg C"; $address{'1815'} = "Paludan Mllers Vej"; $type{'1815'} = "ST";
$location{'1816'} = "Frederiksberg C"; $address{'1816'} = "Engtoftevej"; $type{'1816'} = "ST";
$location{'1817'} = "Frederiksberg C"; $address{'1817'} = "Carl Bernhards Vej"; $type{'1817'} = "ST";
$location{'1818'} = "Frederiksberg C"; $address{'1818'} = "Kingosgade 8-12 + 11-17"; $type{'1818'} = "ST";
$location{'1819'} = "Frederiksberg C"; $address{'1819'} = "Vrnedamsvej Ulige nr."; $type{'1819'} = "ST";
$location{'1820'} = "Frederiksberg C"; $address{'1820'} = "Frederiksberg All 15-65 + 2-104"; $type{'1820'} = "ST";
$location{'1822'} = "Frederiksberg C"; $address{'1822'} = "Boyesgade Lige nr"; $type{'1822'} = "ST";
$location{'1823'} = "Frederiksberg C"; $address{'1823'} = "Haveselskabetsvej"; $type{'1823'} = "ST";
$location{'1824'} = "Frederiksberg C"; $address{'1824'} = "Sankt Thomas All"; $type{'1824'} = "ST";
$location{'1825'} = "Frederiksberg C"; $address{'1825'} = "Hauchsvej"; $type{'1825'} = "ST";
$location{'1826'} = "Frederiksberg C"; $address{'1826'} = "Alhambravej"; $type{'1826'} = "ST";
$location{'1827'} = "Frederiksberg C"; $address{'1827'} = "Mynstersvej"; $type{'1827'} = "ST";
$location{'1828'} = "Frederiksberg C"; $address{'1828'} = "Martensens All"; $type{'1828'} = "ST";
$location{'1829'} = "Frederiksberg C"; $address{'1829'} = "Madvigs All"; $type{'1829'} = "ST";
$location{'1835'} = "Frederiksberg C"; $owner{'1835'} = "inkl. Frederiksberg C Postkontor"; $type{'1835'} = "BX";
$location{'1850'} = "Frederiksberg C"; $address{'1850'} = "Gammel Kongevej 85-179 + 60-178"; $type{'1850'} = "ST";
$location{'1851'} = "Frederiksberg C"; $address{'1851'} = "Nyvej"; $type{'1851'} = "ST";
$location{'1852'} = "Frederiksberg C"; $address{'1852'} = "Amicisvej"; $type{'1852'} = "ST";
$location{'1853'} = "Frederiksberg C"; $address{'1853'} = "Maglekildevej"; $type{'1853'} = "ST";
$location{'1854'} = "Frederiksberg C"; $address{'1854'} = "Dr. Priemes Vej"; $type{'1854'} = "ST";
$location{'1855'} = "Frederiksberg C"; $address{'1855'} = "Hollndervej"; $type{'1855'} = "ST";
$location{'1856'} = "Frederiksberg C"; $address{'1856'} = "Edisonsvej"; $type{'1856'} = "ST";
$location{'1857'} = "Frederiksberg C"; $address{'1857'} = "Hortensiavej"; $type{'1857'} = "ST";
$location{'1860'} = "Frederiksberg C"; $address{'1860'} = "Christian Winthers Vej"; $type{'1860'} = "ST";
$location{'1861'} = "Frederiksberg C"; $address{'1861'} = "Sagasvej"; $type{'1861'} = "ST";
$location{'1862'} = "Frederiksberg C"; $address{'1862'} = "Rathsacksvej"; $type{'1862'} = "ST";
$location{'1863'} = "Frederiksberg C"; $address{'1863'} = "Ceresvej"; $type{'1863'} = "ST";
$location{'1864'} = "Frederiksberg C"; $address{'1864'} = "Grundtvigsvej"; $type{'1864'} = "ST";
$location{'1865'} = "Frederiksberg C"; $address{'1865'} = "Grundtvigs Sidevej"; $type{'1865'} = "ST";
$location{'1866'} = "Frederiksberg C"; $address{'1866'} = "Henrik Steffens Vej"; $type{'1866'} = "ST";
$location{'1867'} = "Frederiksberg C"; $address{'1867'} = "Acaciavej"; $type{'1867'} = "ST";
$location{'1868'} = "Frederiksberg C"; $address{'1868'} = "Bianco Lunos All"; $type{'1868'} = "ST";
$location{'1870'} = "Frederiksberg C"; $address{'1870'} = "Blowsvej"; $type{'1870'} = "ST";
$location{'1871'} = "Frederiksberg C"; $address{'1871'} = "Thorvaldsensvej"; $type{'1871'} = "ST";
$location{'1872'} = "Frederiksberg C"; $address{'1872'} = "Bomhoffs Have"; $type{'1872'} = "ST";
$location{'1873'} = "Frederiksberg C"; $address{'1873'} = "Helenevej"; $type{'1873'} = "ST";
$location{'1874'} = "Frederiksberg C"; $address{'1874'} = "Harsdorffsvej"; $type{'1874'} = "ST";
$location{'1875'} = "Frederiksberg C"; $address{'1875'} = "Amalievej"; $type{'1875'} = "ST";
$location{'1876'} = "Frederiksberg C"; $address{'1876'} = "Kastanievej"; $type{'1876'} = "ST";
$location{'1877'} = "Frederiksberg C"; $address{'1877'} = "Lindevej"; $type{'1877'} = "ST";
$location{'1878'} = "Frederiksberg C"; $address{'1878'} = "Uraniavej"; $type{'1878'} = "ST";
$location{'1879'} = "Frederiksberg C"; $address{'1879'} = "H.C. rsteds Vej"; $type{'1879'} = "ST";
$location{'1900'} = "Frederiksberg C"; $address{'1900'} = "Vodroffsvej"; $type{'1900'} = "ST";
$location{'1901'} = "Frederiksberg C"; $address{'1901'} = "Trnborgvej"; $type{'1901'} = "ST";
$location{'1902'} = "Frederiksberg C"; $address{'1902'} = "Lykkesholms All"; $type{'1902'} = "ST";
$location{'1903'} = "Frederiksberg C"; $address{'1903'} = "Sankt Knuds Vej"; $type{'1903'} = "ST";
$location{'1904'} = "Frederiksberg C"; $address{'1904'} = "Forhbningsholms All"; $type{'1904'} = "ST";
$location{'1905'} = "Frederiksberg C"; $address{'1905'} = "Svanholmsvej"; $type{'1905'} = "ST";
$location{'1906'} = "Frederiksberg C"; $address{'1906'} = "Schnbergsgade"; $type{'1906'} = "ST";
$location{'1908'} = "Frederiksberg C"; $address{'1908'} = "Prinsesse Maries All"; $type{'1908'} = "ST";
$location{'1909'} = "Frederiksberg C"; $address{'1909'} = "Vodroffs Tvrgade"; $type{'1909'} = "ST";
$location{'1910'} = "Frederiksberg C"; $address{'1910'} = "Danasvej"; $type{'1910'} = "ST";
$location{'1911'} = "Frederiksberg C"; $address{'1911'} = "Niels Ebbesens Vej"; $type{'1911'} = "ST";
$location{'1912'} = "Frederiksberg C"; $address{'1912'} = "Svend Trsts Vej"; $type{'1912'} = "ST";
$location{'1913'} = "Frederiksberg C"; $address{'1913'} = "Carl Plougs Vej"; $type{'1913'} = "ST";
$location{'1914'} = "Frederiksberg C"; $address{'1914'} = "Vodroffslund"; $type{'1914'} = "ST";
$location{'1915'} = "Frederiksberg C"; $address{'1915'} = "Danas Plads"; $type{'1915'} = "ST";
$location{'1916'} = "Frederiksberg C"; $address{'1916'} = "Norsvej"; $type{'1916'} = "ST";
$location{'1917'} = "Frederiksberg C"; $address{'1917'} = "Sveasvej"; $type{'1917'} = "ST";
$location{'1920'} = "Frederiksberg C"; $address{'1920'} = "Forchhammersvej"; $type{'1920'} = "ST";
$location{'1921'} = "Frederiksberg C"; $address{'1921'} = "Sankt Markus Plads"; $type{'1921'} = "ST";
$location{'1922'} = "Frederiksberg C"; $address{'1922'} = "Sankt Markus All"; $type{'1922'} = "ST";
$location{'1923'} = "Frederiksberg C"; $address{'1923'} = "Johnstrups All"; $type{'1923'} = "ST";
$location{'1924'} = "Frederiksberg C"; $address{'1924'} = "Steenstrups All"; $type{'1924'} = "ST";
$location{'1925'} = "Frederiksberg C"; $address{'1925'} = "Julius Thomsens Plads"; $type{'1925'} = "ST";
$location{'1926'} = "Frederiksberg C"; $address{'1926'} = "Martinsvej"; $type{'1926'} = "ST";
$location{'1927'} = "Frederiksberg C"; $address{'1927'} = "Suomisvej"; $type{'1927'} = "ST";
$location{'1928'} = "Frederiksberg C"; $address{'1928'} = "Filippavej"; $type{'1928'} = "ST";
$location{'1931'} = "Frederiksberg C"; $type{'1931'} = "PP";
$location{'1950'} = "Frederiksberg C"; $address{'1950'} = "Hostrupsvej"; $type{'1950'} = "ST";
$location{'1951'} = "Frederiksberg C"; $address{'1951'} = "Christian Richardts Vej"; $type{'1951'} = "ST";
$location{'1952'} = "Frederiksberg C"; $address{'1952'} = "Falkonervnget"; $type{'1952'} = "ST";
$location{'1953'} = "Frederiksberg C"; $address{'1953'} = "Sankt Nikolaj Vej"; $type{'1953'} = "ST";
$location{'1954'} = "Frederiksberg C"; $address{'1954'} = "Hostrups Have"; $type{'1954'} = "ST";
$location{'1955'} = "Frederiksberg C"; $address{'1955'} = "Dr. Abildgaards All"; $type{'1955'} = "ST";
$location{'1956'} = "Frederiksberg C"; $address{'1956'} = "L.I. Brandes All"; $type{'1956'} = "ST";
$location{'1957'} = "Frederiksberg C"; $address{'1957'} = "N.J. Fjords All"; $type{'1957'} = "ST";
$location{'1958'} = "Frederiksberg C"; $address{'1958'} = "Rolighedsvej"; $type{'1958'} = "ST";
$location{'1959'} = "Frederiksberg C"; $address{'1959'} = "Falkonergrdsvej"; $type{'1959'} = "ST";
$location{'1960'} = "Frederiksberg C"; $address{'1960'} = "boulevard 15-55"; $type{'1960'} = "ST";
$location{'1961'} = "Frederiksberg C"; $address{'1961'} = "J.M. Thieles Vej"; $type{'1961'} = "ST";
$location{'1962'} = "Frederiksberg C"; $address{'1962'} = "Fuglevangsvej"; $type{'1962'} = "ST";
$location{'1963'} = "Frederiksberg C"; $address{'1963'} = "Bille Brahes Vej"; $type{'1963'} = "ST";
$location{'1964'} = "Frederiksberg C"; $address{'1964'} = "Ingemannsvej"; $type{'1964'} = "ST";
$location{'1965'} = "Frederiksberg C"; $address{'1965'} = "Erik Menveds Vej"; $type{'1965'} = "ST";
$location{'1966'} = "Frederiksberg C"; $address{'1966'} = "Steenwinkelsvej"; $type{'1966'} = "ST";
$location{'1967'} = "Frederiksberg C"; $address{'1967'} = "Svanemosegrdsvej"; $type{'1967'} = "ST";
$location{'1970'} = "Frederiksberg C"; $address{'1970'} = "Rosenrns All 1-65 + 20-70"; $type{'1970'} = "ST";
$location{'1971'} = "Frederiksberg C"; $address{'1971'} = "Adolph Steens All"; $type{'1971'} = "ST";
$location{'1972'} = "Frederiksberg C"; $address{'1972'} = "Worsaaesvej"; $type{'1972'} = "ST";
$location{'1973'} = "Frederiksberg C"; $address{'1973'} = "Jakob Dannefrds Vej"; $type{'1973'} = "ST";
$location{'1974'} = "Frederiksberg C"; $address{'1974'} = "Julius Thomsens Gade Ulige nr"; $type{'1974'} = "ST";
$location{'1999'} = "Frederiksberg C"; $owner{'1999'} = "Danmarks Radio"; $type{'1999'} = "IO";
$location{'2000'} = "Frederiksberg";
$location{'2100'} = "Kbenhavn ";
$location{'2200'} = "Kbenhavn N";
$location{'2300'} = "Kbenhavn S";
$location{'2400'} = "Kbenhavn NV";
$location{'2450'} = "Kbenhavn SV";
$location{'2500'} = "Valby";
$location{'2600'} = "Glostrup";
$location{'2605'} = "Brndby";
$location{'2610'} = "Rdovre";
$location{'2620'} = "Albertslund";
$location{'2625'} = "Vallensbk";
$location{'2630'} = "Taastrup";
$location{'2633'} = "Taastrup"; $owner{'2633'} = "Erhvervskunder";
$location{'2635'} = "Ishj";
$location{'2640'} = "Hedehusene";
$location{'2650'} = "Hvidovre";
$location{'2660'} = "Brndby Strand";
$location{'2665'} = "Vallensbk Strand";
$location{'2670'} = "Greve";
$location{'2680'} = "Solrd Strand";
$location{'2690'} = "Karlslunde";
$location{'2700'} = "Brnshj";
$location{'2720'} = "Vanlse";
$location{'2730'} = "Herlev";
$location{'2740'} = "Skovlunde";
$location{'2750'} = "Ballerup";
$location{'2760'} = "Mlv";
$location{'2765'} = "Smrum";
$location{'2770'} = "Kastrup";
$location{'2791'} = "Dragr";
$location{'2800'} = "Kongens Lyngby";
$location{'2820'} = "Gentofte";
$location{'2830'} = "Virum";
$location{'2840'} = "Holte";
$location{'2850'} = "Nrum";
$location{'2860'} = "Sborg";
$location{'2870'} = "Dyssegrd ";
$location{'2880'} = "Bagsvrd";
$location{'2900'} = "Hellerup";
$location{'2920'} = "Charlottenlund";
$location{'2930'} = "Klampenborg";
$location{'2942'} = "Skodsborg";
$location{'2950'} = "Vedbk";
$location{'2960'} = "Rungsted Kyst";
$location{'2970'} = "Hrsholm";
$location{'2980'} = "Kokkedal";
$location{'2990'} = "Niv";
$location{'3000'} = "Helsingr";
$location{'3050'} = "Humlebk";
$location{'3060'} = "Espergrde";
$location{'3070'} = "Snekkersten";
$location{'3080'} = "Tikb";
$location{'3100'} = "Hornbk";
$location{'3120'} = "Dronningmlle";
$location{'3140'} = "lsgrde";
$location{'3150'} = "Hellebk";
$location{'3200'} = "Helsinge";
$location{'3210'} = "Vejby";
$location{'3220'} = "Tisvildeleje";
$location{'3230'} = "Grsted";
$location{'3250'} = "Gilleleje";
$location{'3300'} = "Frederiksvrk";
$location{'3310'} = "lsted";
$location{'3320'} = "Skvinge";
$location{'3330'} = "Grlse";
$location{'3360'} = "Liseleje";
$location{'3370'} = "Melby";
$location{'3390'} = "Hundested";
$location{'3400'} = "Hillerd";
$location{'3450'} = "Allerd";
$location{'3460'} = "Birkerd";
$location{'3480'} = "Fredensborg";
$location{'3490'} = "Kvistgrd";
$location{'3500'} = "Vrlse";
$location{'3520'} = "Farum";
$location{'3540'} = "Lynge";
$location{'3550'} = "Slangerup";
$location{'3600'} = "Frederikssund";
$location{'3630'} = "Jgerspris";
$location{'3650'} = "lstykke";
$location{'3660'} = "Stenlse";
$location{'3670'} = "Veks Sjlland";
$location{'3700'} = "Rnne";
$location{'3720'} = "Aakirkeby";
$location{'3730'} = "Nex";
$location{'3740'} = "Svaneke";
$location{'3751'} = "stermarie";
$location{'3760'} = "Gudhjem";
$location{'3770'} = "Allinge";
$location{'3782'} = "Klemensker";
$location{'3790'} = "Hasle";
$location{'4000'} = "Roskilde";
$location{'4040'} = "Jyllinge";
$location{'4050'} = "Skibby";
$location{'4060'} = "Kirke Sby";
$location{'4070'} = "Kirke Hyllinge";
$location{'4100'} = "Ringsted";
$location{'4105'} = "Ringsted"; $owner{'4105'} = "Midtsjllands Postcenter + erhvervskunder";
$location{'4129'} = "Ringsted"; $type{'4129'} = "PP";
$location{'4130'} = "Viby Sjlland";
$location{'4140'} = "Borup";
$location{'4160'} = "Herlufmagle";
$location{'4171'} = "Glums";
$location{'4173'} = "Fjenneslev";
$location{'4174'} = "Jystrup Midtsj";
$location{'4180'} = "Sor";
$location{'4190'} = "Munke Bjergby";
$location{'4200'} = "Slagelse";
$location{'4220'} = "Korsr";
$location{'4230'} = "Sklskr";
$location{'4241'} = "Vemmelev";
$location{'4242'} = "Boeslunde";
$location{'4243'} = "Rude";
$location{'4250'} = "Fuglebjerg";
$location{'4261'} = "Dalmose";
$location{'4262'} = "Sandved";
$location{'4270'} = "Hng";
$location{'4281'} = "Grlev";
$location{'4291'} = "Ruds Vedby";
$location{'4293'} = "Dianalund";
$location{'4295'} = "Stenlille";
$location{'4296'} = "Nyrup";
$location{'4300'} = "Holbk";
$location{'4320'} = "Lejre";
$location{'4330'} = "Hvals";
$location{'4340'} = "Tllse";
$location{'4350'} = "Ugerlse";
$location{'4360'} = "Kirke Eskilstrup";
$location{'4370'} = "Store Merlse";
$location{'4390'} = "Vipperd";
$location{'4400'} = "Kalundborg";
$location{'4420'} = "Regstrup";
$location{'4440'} = "Mrkv";
$location{'4450'} = "Jyderup";
$location{'4460'} = "Snertinge";
$location{'4470'} = "Sveblle";
$location{'4480'} = "Store Fuglede";
$location{'4490'} = "Jerslev Sjlland";
$location{'4500'} = "Nykbing Sj";
$location{'4520'} = "Svinninge";
$location{'4532'} = "Gislinge";
$location{'4534'} = "Hrve";
$location{'4540'} = "Frevejle";
$location{'4550'} = "Asns";
$location{'4560'} = "Vig";
$location{'4571'} = "Grevinge";
$location{'4572'} = "Nrre Asmindrup";
$location{'4573'} = "Hjby";
$location{'4581'} = "Rrvig";
$location{'4583'} = "Sjllands Odde";
$location{'4591'} = "Fllenslev";
$location{'4592'} = "Sejer";
$location{'4593'} = "Eskebjerg";
$location{'4600'} = "Kge";
$location{'4621'} = "Gadstrup";
$location{'4622'} = "Havdrup";
$location{'4623'} = "Lille Skensved";
$location{'4632'} = "Bjverskov";
$location{'4640'} = "Fakse";
$location{'4652'} = "Hrlev";
$location{'4653'} = "Karise";
$location{'4654'} = "Fakse Ladeplads";
$location{'4660'} = "Store Heddinge";
$location{'4671'} = "Strby";
$location{'4672'} = "Klippinge";
$location{'4673'} = "Rdvig Stevns";
$location{'4681'} = "Herflge";
$location{'4682'} = "Tureby";
$location{'4683'} = "Rnnede";
$location{'4684'} = "Holmegaard ";
$location{'4690'} = "Haslev";
$location{'4700'} = "Nstved";
$location{'4720'} = "Prst";
$location{'4733'} = "Tappernje";
$location{'4735'} = "Mern";
$location{'4736'} = "Karrebksminde";
$location{'4750'} = "Lundby";
$location{'4760'} = "Vordingborg";
$location{'4771'} = "Kalvehave";
$location{'4772'} = "Langebk";
$location{'4773'} = "Stensved";
$location{'4780'} = "Stege";
$location{'4791'} = "Borre";
$location{'4792'} = "Askeby";
$location{'4793'} = "Bog By";
$location{'4800'} = "Nykbing F";
$location{'4840'} = "Nrre Alslev";
$location{'4850'} = "Stubbekbing";
$location{'4862'} = "Guldborg";
$location{'4863'} = "Eskilstrup";
$location{'4871'} = "Horbelev";
$location{'4872'} = "Idestrup";
$location{'4873'} = "Vggerlse";
$location{'4874'} = "Gedser";
$location{'4880'} = "Nysted";
$location{'4891'} = "Toreby L";
$location{'4892'} = "Kettinge";
$location{'4894'} = "ster Ulslev";
$location{'4895'} = "Errindlev";
$location{'4900'} = "Nakskov";
$location{'4912'} = "Harpelunde";
$location{'4913'} = "Horslunde";
$location{'4920'} = "Sllested";
$location{'4930'} = "Maribo";
$location{'4941'} = "Bandholm";
$location{'4943'} = "Torrig L";
$location{'4944'} = "Fej";
$location{'4951'} = "Nrreballe";
$location{'4952'} = "Stokkemarke";
$location{'4953'} = "Vesterborg";
$location{'4960'} = "Holeby";
$location{'4970'} = "Rdby";
$location{'4983'} = "Dannemare";
$location{'4990'} = "Sakskbing";
$location{'5000'} = "Odense C";
$location{'5029'} = "Odense C"; $type{'5029'} = "PP";
$location{'5090'} = "Odense C"; $owner{'5090'} = "Erhvervskunder";
$location{'5100'} = "Odense C"; $type{'5100'} = "BX";
$location{'5200'} = "Odense V";
$location{'5210'} = "Odense NV";
$location{'5220'} = "Odense S";
$location{'5230'} = "Odense M";
$location{'5240'} = "Odense N";
$location{'5250'} = "Odense SV";
$location{'5260'} = "Odense S";
$location{'5270'} = "Odense N";
$location{'5290'} = "Marslev";
$location{'5300'} = "Kerteminde";
$location{'5320'} = "Agedrup";
$location{'5330'} = "Munkebo";
$location{'5350'} = "Rynkeby";
$location{'5370'} = "Mesinge";
$location{'5380'} = "Dalby";
$location{'5390'} = "Martofte";
$location{'5400'} = "Bogense";
$location{'5450'} = "Otterup";
$location{'5462'} = "Morud";
$location{'5463'} = "Harndrup";
$location{'5464'} = "Brenderup Fyn";
$location{'5466'} = "Asperup";
$location{'5471'} = "Snders";
$location{'5474'} = "Veflinge";
$location{'5485'} = "Skamby";
$location{'5491'} = "Blommenslyst";
$location{'5492'} = "Vissenbjerg";
$location{'5500'} = "Middelfart";
$location{'5540'} = "Ullerslev";
$location{'5550'} = "Langeskov";
$location{'5560'} = "Aarup";
$location{'5580'} = "Nrre Aaby";
$location{'5591'} = "Gelsted";
$location{'5592'} = "Ejby";
$location{'5600'} = "Faaborg";
$location{'5610'} = "Assens";
$location{'5620'} = "Glamsbjerg";
$location{'5631'} = "Ebberup";
$location{'5642'} = "Millinge";
$location{'5672'} = "Broby";
$location{'5683'} = "Haarby";
$location{'5690'} = "Tommerup";
$location{'5700'} = "Svendborg";
$location{'5750'} = "Ringe";
$location{'5762'} = "Vester Skerninge";
$location{'5771'} = "Stenstrup";
$location{'5772'} = "Kvrndrup";
$location{'5792'} = "rslev";
$location{'5800'} = "Nyborg";
$location{'5853'} = "rbk";
$location{'5854'} = "Gislev";
$location{'5856'} = "Ryslinge";
$location{'5863'} = "Ferritslev Fyn";
$location{'5871'} = "Frrup";
$location{'5874'} = "Hesselager";
$location{'5881'} = "Skrup Fyn";
$location{'5882'} = "Vejstrup";
$location{'5883'} = "Oure";
$location{'5884'} = "Gudme";
$location{'5892'} = "Gudbjerg Sydfyn";
$location{'5900'} = "Rudkbing";
$location{'5932'} = "Humble";
$location{'5935'} = "Bagenkop";
$location{'5953'} = "Tranekr";
$location{'5960'} = "Marstal";
$location{'5970'} = "rskbing";
$location{'5985'} = "Sby r";
$location{'6000'} = "Kolding";
$location{'6040'} = "Egtved";
$location{'6051'} = "Almind";
$location{'6052'} = "Viuf";
$location{'6064'} = "Jordrup";
$location{'6070'} = "Christiansfeld";
$location{'6091'} = "Bjert";
$location{'6092'} = "Snder Stenderup";
$location{'6093'} = "Sjlund";
$location{'6094'} = "Hejls";
$location{'6100'} = "Haderslev";
$location{'6200'} = "Aabenraa";
$location{'6230'} = "Rdekro";
$location{'6240'} = "Lgumkloster";
$location{'6261'} = "Bredebro";
$location{'6270'} = "Tnder";
$location{'6280'} = "Hjer";
$location{'6300'} = "Grsten";
$location{'6310'} = "Broager";
$location{'6320'} = "Egernsund";
$location{'6330'} = "Padborg";
$location{'6340'} = "Krus";
$location{'6360'} = "Tinglev";
$location{'6372'} = "Bylderup-Bov";
$location{'6392'} = "Bolderslev";
$location{'6400'} = "Snderborg";
$location{'6430'} = "Nordborg";
$location{'6440'} = "Augustenborg";
$location{'6470'} = "Sydals";
$location{'6500'} = "Vojens";
$location{'6510'} = "Gram";
$location{'6520'} = "Toftlund";
$location{'6534'} = "Agerskov";
$location{'6535'} = "Branderup J";
$location{'6541'} = "Bevtoft";
$location{'6560'} = "Sommersted";
$location{'6580'} = "Vamdrup";
$location{'6600'} = "Vejen";
$location{'6621'} = "Gesten";
$location{'6622'} = "Bkke";
$location{'6623'} = "Vorbasse";
$location{'6630'} = "Rdding";
$location{'6640'} = "Lunderskov";
$location{'6650'} = "Brrup";
$location{'6660'} = "Lintrup";
$location{'6670'} = "Holsted";
$location{'6682'} = "Hovborg";
$location{'6683'} = "Fvling";
$location{'6690'} = "Grding";
$location{'6700'} = "Esbjerg";
$location{'6701'} = "Esbjerg"; $type{'6701'} = "BX";
$location{'6705'} = "Esbjerg ";
$location{'6710'} = "Esbjerg V";
$location{'6715'} = "Esbjerg N";
$location{'6720'} = "Fan";
$location{'6731'} = "Tjreborg";
$location{'6740'} = "Bramming";
$location{'6752'} = "Glejbjerg";
$location{'6753'} = "Agerbk";
$location{'6760'} = "Ribe";
$location{'6771'} = "Gredstedbro";
$location{'6780'} = "Skrbk";
$location{'6792'} = "Rm";
$location{'6800'} = "Varde";
$location{'6818'} = "rre";
$location{'6823'} = "Ansager";
$location{'6830'} = "Nrre Nebel";
$location{'6840'} = "Oksbl";
$location{'6851'} = "Janderup Vestj";
$location{'6852'} = "Billum";
$location{'6853'} = "Vejers Strand";
$location{'6854'} = "Henne";
$location{'6855'} = "Outrup";
$location{'6857'} = "Blvand";
$location{'6862'} = "Tistrup";
$location{'6870'} = "lgod";
$location{'6880'} = "Tarm";
$location{'6893'} = "Hemmet";
$location{'6900'} = "Skjern";
$location{'6920'} = "Videbk";
$location{'6933'} = "Kibk";
$location{'6940'} = "Lem St";
$location{'6950'} = "Ringkbing";
$location{'6960'} = "Hvide Sande";
$location{'6971'} = "Spjald";
$location{'6973'} = "rnhj";
$location{'6980'} = "Tim";
$location{'6990'} = "Ulfborg";
$location{'7000'} = "Fredericia";
$location{'7007'} = "Fredericia"; $owner{'7007'} = "Sydjyllands Postcenter + erhvervskunder";
$location{'7029'} = "Fredericia"; $type{'7029'} = "PP";
$location{'7080'} = "Brkop";
$location{'7100'} = "Vejle";
$location{'7120'} = "Vejle st";
$location{'7130'} = "Juelsminde";
$location{'7140'} = "Stouby";
$location{'7150'} = "Barrit";
$location{'7160'} = "Trring";
$location{'7171'} = "Uldum";
$location{'7173'} = "Vonge";
$location{'7182'} = "Bredsten";
$location{'7183'} = "Randbl";
$location{'7184'} = "Vandel";
$location{'7190'} = "Billund";
$location{'7200'} = "Grindsted";
$location{'7250'} = "Hejnsvig";
$location{'7260'} = "Snder Omme";
$location{'7270'} = "Stakroge";
$location{'7280'} = "Snder Felding";
$location{'7300'} = "Jelling";
$location{'7321'} = "Gadbjerg";
$location{'7323'} = "Give";
$location{'7330'} = "Brande";
$location{'7361'} = "Ejstrupholm";
$location{'7362'} = "Hampen";
$location{'7400'} = "Herning";
$location{'7401'} = "Herning"; $owner{'7401'} = "Erhvervskunder";
$location{'7429'} = "Herning"; $type{'7429'} = "PP";
$location{'7430'} = "Ikast";
$location{'7441'} = "Bording";
$location{'7442'} = "Engesvang";
$location{'7451'} = "Sunds";
$location{'7470'} = "Karup J";
$location{'7480'} = "Vildbjerg";
$location{'7490'} = "Aulum";
$location{'7500'} = "Holstebro";
$location{'7540'} = "Haderup";
$location{'7550'} = "Srvad";
$location{'7560'} = "Hjerm";
$location{'7570'} = "Vemb";
$location{'7600'} = "Struer";
$location{'7620'} = "Lemvig";
$location{'7650'} = "Bvlingbjerg";
$location{'7660'} = "Bkmarksbro";
$location{'7673'} = "Harbore";
$location{'7680'} = "Thyborn";
$location{'7700'} = "Thisted";
$location{'7730'} = "Hanstholm";
$location{'7741'} = "Frstrup";
$location{'7742'} = "Vesls";
$location{'7752'} = "Snedsted";
$location{'7755'} = "Bedsted Thy";
$location{'7760'} = "Hurup Thy";
$location{'7770'} = "Vestervig";
$location{'7790'} = "Thyholm";
$location{'7800'} = "Skive";
$location{'7830'} = "Vinderup";
$location{'7840'} = "Hjslev";
$location{'7850'} = "Stoholm Jyll";
$location{'7860'} = "Spttrup";
$location{'7870'} = "Roslev";
$location{'7884'} = "Fur";
$location{'7900'} = "Nykbing M";
$location{'7950'} = "Erslev";
$location{'7960'} = "Karby";
$location{'7970'} = "Redsted M";
$location{'7980'} = "Vils";
$location{'7990'} = "ster Assels";
$location{'8000'} = "rhus C";
$location{'8100'} = "rhus C"; $type{'8100'} = "BX";
$location{'8200'} = "rhus N";
$location{'8210'} = "rhus V";
$location{'8220'} = "Brabrand";
$location{'8229'} = "Risskov "; $type{'8229'} = "PP";
$location{'8230'} = "byhj";
$location{'8240'} = "Risskov";
$location{'8245'} = "Risskov "; $owner{'8245'} = "stjyllands Postcenter + erhvervskunder";
$location{'8250'} = "Eg";
$location{'8260'} = "Viby J";
$location{'8270'} = "Hjbjerg";
$location{'8300'} = "Odder";
$location{'8305'} = "Sams";
$location{'8310'} = "Tranbjerg J";
$location{'8320'} = "Mrslet";
$location{'8330'} = "Beder";
$location{'8340'} = "Malling";
$location{'8350'} = "Hundslund";
$location{'8355'} = "Solbjerg";
$location{'8361'} = "Hasselager";
$location{'8362'} = "Hrning";
$location{'8370'} = "Hadsten";
$location{'8380'} = "Trige";
$location{'8381'} = "Tilst";
$location{'8382'} = "Hinnerup";
$location{'8400'} = "Ebeltoft";
$location{'8410'} = "Rnde";
$location{'8420'} = "Knebel";
$location{'8444'} = "Balle";
$location{'8450'} = "Hammel";
$location{'8462'} = "Harlev J";
$location{'8464'} = "Galten";
$location{'8471'} = "Sabro";
$location{'8472'} = "Sporup";
$location{'8500'} = "Grenaa";
$location{'8520'} = "Lystrup";
$location{'8530'} = "Hjortshj";
$location{'8541'} = "Skdstrup";
$location{'8543'} = "Hornslet";
$location{'8544'} = "Mrke";
$location{'8550'} = "Ryomgrd";
$location{'8560'} = "Kolind";
$location{'8570'} = "Trustrup";
$location{'8581'} = "Nimtofte";
$location{'8585'} = "Glesborg";
$location{'8586'} = "rum Djurs";
$location{'8592'} = "Anholt";
$location{'8600'} = "Silkeborg";
$location{'8620'} = "Kjellerup";
$location{'8632'} = "Lemming";
$location{'8641'} = "Sorring";
$location{'8643'} = "Ans By";
$location{'8653'} = "Them";
$location{'8654'} = "Bryrup";
$location{'8660'} = "Skanderborg";
$location{'8670'} = "Lsby";
$location{'8680'} = "Ry";
$location{'8700'} = "Horsens";
$location{'8721'} = "Daugrd";
$location{'8722'} = "Hedensted";
$location{'8723'} = "Lsning";
$location{'8732'} = "Hovedgrd";
$location{'8740'} = "Brdstrup";
$location{'8751'} = "Gedved";
$location{'8752'} = "stbirk";
$location{'8762'} = "Flemming";
$location{'8763'} = "Rask Mlle";
$location{'8765'} = "Klovborg";
$location{'8766'} = "Nrre Snede";
$location{'8781'} = "Stenderup";
$location{'8783'} = "Hornsyld";
$location{'8800'} = "Viborg";
$location{'8830'} = "Tjele";
$location{'8831'} = "Lgstrup";
$location{'8832'} = "Skals";
$location{'8840'} = "Rdkrsbro";
$location{'8850'} = "Bjerringbro";
$location{'8860'} = "Ulstrup";
$location{'8870'} = "Lang";
$location{'8881'} = "Thors";
$location{'8882'} = "Frvang";
$location{'8883'} = "Gjern";
$location{'8900'} = "Randers";
$location{'8950'} = "rsted";
$location{'8961'} = "Allingbro";
$location{'8963'} = "Auning";
$location{'8970'} = "Havndal";
$location{'8981'} = "Spentrup";
$location{'8983'} = "Gjerlev J";
$location{'8990'} = "Frup";
$location{'9000'} = "Aalborg";
$location{'9020'} = "Aalborg"; $owner{'9020'} = "Erhvervskunder";
$location{'9029'} = "Aalborg"; $type{'9029'} = "PP";
$location{'9100'} = "Aalborg"; $type{'9100'} = "BX";
$location{'9200'} = "Aalborg SV";
$location{'9210'} = "Aalborg S";
$location{'9220'} = "Aalborg st";
$location{'9230'} = "Svenstrup J";
$location{'9240'} = "Nibe";
$location{'9260'} = "Gistrup";
$location{'9270'} = "Klarup";
$location{'9280'} = "Storvorde";
$location{'9293'} = "Kongerslev";
$location{'9300'} = "Sby";
$location{'9310'} = "Vodskov";
$location{'9320'} = "Hjallerup";
$location{'9330'} = "Dronninglund";
$location{'9340'} = "Asaa";
$location{'9352'} = "Dybvad";
$location{'9362'} = "Gandrup";
$location{'9370'} = "Hals";
$location{'9380'} = "Vestbjerg";
$location{'9381'} = "Sulsted";
$location{'9382'} = "Tylstrup";
$location{'9400'} = "Nrresundby";
$location{'9430'} = "Vadum";
$location{'9440'} = "Aabybro";
$location{'9460'} = "Brovst";
$location{'9480'} = "Lkken";
$location{'9490'} = "Pandrup";
$location{'9492'} = "Blokhus";
$location{'9493'} = "Saltum";
$location{'9500'} = "Hobro";
$location{'9510'} = "Arden";
$location{'9520'} = "Skrping";
$location{'9530'} = "Stvring";
$location{'9541'} = "Suldrup";
$location{'9550'} = "Mariager";
$location{'9560'} = "Hadsund";
$location{'9574'} = "Blum";
$location{'9575'} = "Terndrup";
$location{'9600'} = "Aars";
$location{'9610'} = "Nrager";
$location{'9620'} = "Aalestrup";
$location{'9631'} = "Gedsted";
$location{'9632'} = "Mldrup";
$location{'9640'} = "Fars";
$location{'9670'} = "Lgstr";
$location{'9681'} = "Ranum";
$location{'9690'} = "Fjerritslev";
$location{'9700'} = "Brnderslev";
$location{'9740'} = "Jerslev J";
$location{'9750'} = "stervr";
$location{'9760'} = "Vr";
$location{'9800'} = "Hjrring";
$location{'9830'} = "Trs";
$location{'9850'} = "Hirtshals";
$location{'9870'} = "Sindal";
$location{'9881'} = "Bindslev";
$location{'9900'} = "Frederikshavn";
$location{'9940'} = "Ls";
$location{'9970'} = "Strandby";
$location{'9981'} = "Jerup";
$location{'9982'} = "lbk";
$location{'9990'} = "Skagen";
$location{'3900'} = "Nuuk";
$location{'3905'} = "Nuussuaq";
$location{'3910'} = "Kangerlussuaq";
$location{'3911'} = "Sisimiut";
$location{'3912'} = "Maniitsoq";
$location{'3913'} = "Tasiilaq";
$location{'3915'} = "Kulusuk";
$location{'3919'} = "Alluitsup Paa";
$location{'3920'} = "Qaqortoq";
$location{'3921'} = "Narsaq";
$location{'3922'} = "Nanortalik";
$location{'3923'} = "Narsarsuaq";
$location{'3924'} = "Ikerasassuaq";
$location{'3930'} = "Kangilinnguit";
$location{'3932'} = "Arsuk";
$location{'3940'} = "Paamiut";
$location{'3950'} = "Aasiaat";
$location{'3951'} = "Qasigiannguit";
$location{'3952'} = "Ilulissat";
$location{'3953'} = "Qeqertarsuaq";
$location{'3955'} = "Kangaatsiaq";
$location{'3961'} = "Uummannaq";
$location{'3962'} = "Upernavik";
$location{'3964'} = "Qaarsut";
$location{'3970'} = "Pituffik";
$location{'3971'} = "Qaanaaq";
$location{'3980'} = "Ittoqqortoormiit";
$location{'3984'} = "Danmarkshavn";
$location{'3985'} = "Constable Pynt";
$location{'100'} = "Trshavn";
$location{'110'} = "Trshavn "; $type{'110'} = "BX";
$location{'160'} = "Argir";
$location{'165'} = "Argir "; $type{'165'} = "BX";
$location{'175'} = "Kirkjubur";
$location{'176'} = "Velbastadur";
$location{'177'} = "Sydradalur, Streymoy";
$location{'178'} = "Nordradalur";
$location{'180'} = "Kaldbak";
$location{'185'} = "Kaldbaksbotnur";
$location{'186'} = "Sund";
$location{'187'} = "Hvitanes";
$location{'188'} = "Hoyvk";
$location{'210'} = "Sandur";
$location{'215'} = "Sandur"; $type{'215'} = "BX";
$location{'220'} = "Sklavk";
$location{'230'} = "Hsavk";
$location{'235'} = "Dalur";
$location{'236'} = "Skarvanes";
$location{'240'} = "Skopun";
$location{'260'} = "Skvoy";
$location{'270'} = "Nlsoy";
$location{'280'} = "Hestur";
$location{'285'} = "Koltur";
$location{'286'} = "Stra Dimun";
$location{'330'} = "Stykkid";
$location{'335'} = "Leynar";
$location{'336'} = "Skllingur";
$location{'340'} = "Kvvk";
$location{'350'} = "Vestmanna";
$location{'355'} = "Vestmanna"; $type{'355'} = "BX";
$location{'358'} = "Vlur";
$location{'360'} = "Sandavgur";
$location{'370'} = "Midvgur";
$location{'375'} = "Midvgur"; $type{'375'} = "BX";
$location{'380'} = "Srvgur";
$location{'385'} = "Vatnsoyrar";
$location{'386'} = "Bur";
$location{'387'} = "Gsadalur";
$location{'388'} = "Mykines";
$location{'400'} = "Oyrarbakki";
$location{'405'} = "Oyrarbakki"; $type{'405'} = "BX";
$location{'410'} = "Kollafjrdur";
$location{'415'} = "Oyrareingir";
$location{'416'} = "Signabur";
$location{'420'} = "Hsvk";
$location{'430'} = "Hvalvk";
$location{'435'} = "Streymnes";
$location{'436'} = "Saksun";
$location{'437'} = "Nesvk";
$location{'438'} = "Langasandur";
$location{'440'} = "Haldarsvk";
$location{'445'} = "Tjrnuvk";
$location{'450'} = "Oyri";
$location{'460'} = "Nordskli";
$location{'465'} = "Svinir";
$location{'466'} = "Ljs";
$location{'470'} = "Eidi";
$location{'475'} = "Funningur";
$location{'476'} = "Gjgv";
$location{'477'} = "Funningsfjrdur";
$location{'478'} = "Elduvk";
$location{'480'} = "Skli";
$location{'485'} = "Sklafjrdur";
$location{'490'} = "Strendur";
$location{'494'} = "innan Glyvur";
$location{'495'} = "Kolbanargjgv";
$location{'496'} = "Morskranes";
$location{'497'} = "Selatrad";
$location{'510'} = "Gta";
$location{'511'} = "Gtugjgv";
$location{'512'} = "Nordragta";
$location{'513'} = "Sydrugta";
$location{'515'} = "Gta"; $type{'515'} = "BX";
$location{'520'} = "Leirvk";
$location{'530'} = "Fuglafjrdur";
$location{'535'} = "Fuglafjrdur"; $type{'535'} = "BX";
$location{'600'} = "Saltangar";
$location{'610'} = "Saltangar"; $type{'610'} = "BX";
$location{'620'} = "Runavk";
$location{'625'} = "Glyvrar";
$location{'626'} = "Lambareidi";
$location{'627'} = "Lambi";
$location{'640'} = "Rituvk";
$location{'645'} = "duvk";
$location{'650'} = "Toftir";
$location{'655'} = "Nes, Eysturoy";
$location{'656'} = "Saltnes";
$location{'660'} = "Sldarfjrdur";
$location{'665'} = "Skipanes";
$location{'666'} = "Gtueidi";
$location{'690'} = "Oyndarfjrdur";
$location{'695'} = "Hellur";
$location{'700'} = "Klaksvk";
$location{'710'} = "Klaksvk"; $type{'710'} = "BX";
$location{'725'} = "Nordoyri";
$location{'726'} = "nir";
$location{'727'} = "rnafjrdur";
$location{'730'} = "Norddepil";
$location{'735'} = "Depil";
$location{'736'} = "Nordtoftir";
$location{'737'} = "Mli";
$location{'740'} = "Hvannasund";
$location{'750'} = "Vidareidi";
$location{'765'} = "Svinoy";
$location{'766'} = "Kirkja";
$location{'767'} = "Hattarvk";
$location{'780'} = "Kunoy";
$location{'785'} = "Haraldssund";
$location{'795'} = "Sydradalur, Kalsoy";
$location{'796'} = "Hsar";
$location{'797'} = "Mikladalur";
$location{'798'} = "Trllanes";
$location{'800'} = "Tvroyri";
$location{'810'} = "Tvroyri"; $type{'810'} = "BX";
$location{'825'} = "Frodba";
$location{'826'} = "Trongisvgur";
$location{'827'} = "ravk";
$location{'850'} = "Hvalba";
$location{'860'} = "Sandvk";
$location{'870'} = "Fmjin";
$location{'900'} = "Vgur";
$location{'910'} = "Vgur"; $type{'910'} = "BX";
$location{'925'} = "Nes, Vgur";
$location{'926'} = "Lopra";
$location{'927'} = "Akrar";
$location{'928'} = "Vikarbyrgi";
$location{'950'} = "Porkeri";
$location{'960'} = "Hov";
$location{'970'} = "Sumba";

## bin/update end

1;
__END__

=head1 NAME

Geo::Postcodes::DK - Danish postcodes with associated information

=head1 SYNOPSIS

This module can be used object oriented, or as procedures.
Take your pick.

=head2 OBJECTS

  use Geo::Postcodes::DK;

  my $postcode = '1171';

  if (Geo::Postcodes::DK::valid($postcode)) # A valid postcode?
  {
    my $P = Geo::Postcodes::DK->new($postcode);

    printf "Postcode         '%s'.\n", $P->postcode();
    printf "Postal location: '%s'.\n", $P->location();
    printf "Borough:         '%s'.\n", $P->borough();
    printf "County:          '%s'.\n", $P->county();
    printf "Owner:           '%s'.\n", $P->owner();
    printf "Address:         '%s'.\n", $P->address();
    printf "Postcode type:   '%s'.\n", $P->type(); 
    printf "- in danish:     '%s'.\n", $P->type_verbose(); 
    printf "- in english:    '%s'.\n", $P->Geo::Postcodes::type_verbose(); 
  }

The test for a valid postcode can also be done on the object itself, as
it will be I<undef> when passed an illegal postcode (and thus no object
 at all.)

  my $P = Geo::postcodes::DK->new($postcode);

  if ($P) { ... }

A more compact solution:

  if ($P = Geo::Postcodes::DK->new($postcode))
  {
    foreach my $method (Geo::Postcodes::DK::methods())
    {
      printf("%-20s %s\n", ucfirst($method), $P->$method())
    }
  }

=head2 PROCEDURES

  use Geo::postcodes::DK;

  my $postcode = "1171";

  if (Geo::Postcodes::DK::valid($postcode))
  {
    printf "Postcode"        '%s'.\n", $postcode;
    printf "Postal location: '%s'.\n", location_of($postcode);
    printf "Postcode type:   '%s'.\n", type_of($postcode); 
    printf "Owner:           '%s'.\n", owner_of($postcode);
    printf "Address:         '%s'.\n", address_of($postcode);
  }

=head1 ABSTRACT

Geo::postcodes::DK - Perl extension for the mapping between danish
(including Grnland and Frerne) postcodes, postal location,
address and address owner.

=head1 DESCRIPTION

Tired og entering the postal name all the time? This is not necessary, as
it is uniquely defined from the postcode. Request the postcode only,
and use this library to get the postal name.

=head2 EXPORT

None.

The module supports the following methods: 'postcode', 'location', 'address',
'owner', 'type', and -type_verbose'. This list can also be obtained with the
call C<Geo::Postcodes::DK::methods()>.

=head1 DEPENDENCIES

This module is a subclass of Geo::Postcodes, which must be installed first.

=head1 PROCEDURES and METHODS

These functions can be used as methods or procedures.

=head2 is_method

 my $boolean = Geo::postcodes::DK::is_method($method);
 my $boolean = $postcode_object->is_method($method);

Does the specified method exist.

=head2 methods

  my @methods = Geo::postcodes::DK::methods();
  my @methods = $postcode_object->methods();

A list of methods supported by this class.

=head2 selection

See the I<Geo::Postcodes> manual for a description of this powerfull feature. 

=head1 PROCEDURES

Note that the I<xxx_of> procedures return I<undef> when passed an illegal
argument. They are used internally by the object constructor (new).

=head2 legal

C<my $boolean = Geo::postcodes::DK::legal($postcode);>

Do we have a legal postcode; a code that follows the syntax rules?

=head2 valid

C<my $boolean = Geo::postcodes::DK::valid($postcode);>

Do we have a valid postcode; a code in actual use?

=head2 location_of

C<my $location = Geo::postcodes::DK::location_of($postcode);>

The postal place associated with the specified postcode.

=head2 owner_of

C<my $owner = Geo::postcodes::DK::owner_of($postcode);>

The owner (company) of the postcode, if any.

=head2 address_of

C<my $address = Geo::postcodes::DK::address_of($postcode);>

The address (street) associated with the specified postcode.

=head2 type_of

 my $type = Geo::postcodes::DK::type_of($postcode);

What kind of postcode is this, as a code.

=head2 type_verbose_of

 my $danish_description  = Geo::postcodes::DK::type_verbose_of($postcode);
 my $english_description = Geo::postcodes::type_verbose_of($postcode);

A danish text describing the type. Use the base class for the english
description.

See the L<'TYPE'> section for a description of the types.

=head2 type2verbose

Get the description of the specified type.

  my $danish_description  = Geo::Postcodes::DK::type2verbose($type);
  my $english_description = Geo::Postcodes::type2verbose($type);

=head1 METHODS

=head2 new

  my $P = Geo::postcodes::DK-E<gt>new($postcode);

Create a new postcode object. Internally this will call the C<xxx_of> procedures
for the fields supported by this class.

The constructor will return I<undef> when passed an invalid or illegal postcode.
Do not try method calls on it, as it is not an object. See the description of
the I<legal> and I<valid> procedures above.

=head2 postcode

  my $postcode = $P->postcode();

The postcode, as given to the constructor (new).

=head2 location

  my $location = $P->location();

The postal location associated with the specified postcode.

=head2 type

  my $type = $P->type();

See the description of the procedure I<type_of> above.

=head2 type_verbose

See the description of the procedure I<type_verbose_of> above.

  my $type_danish  = $P->type_verbose();
  my $type_english = $P->Geo::Postcodes::type_verbose();

Use this to get the description.

See the L<'TYPE'> section for a description of the types.

=head1 TYPE

This class supports the following types for the postal locatuons:

=over

=item BX

Postboks (Post Office box)

=item ST

Gadeadresse (Street address)

=item IO

Personlig eier (Individual owner)

=item PP

Ufrankerede svarforsendelser (Porto Paye receiver)

=cut

Se L<Geo::Postcodes> for furter descriptions.

=head1 CAVEAT

=head2 POSTCODES

Danish postcodes (including Grnland) are four digit numbers ("0000" to "9999"),
while Frerne uses three digits numbers ("000" to "999"). This means that
"0010" and "010" are legal, while "10" is not.

Use I<legal> to check for legal postcodes, and I<valid> to check if
the postcode is actually in use. C<Geo::postcodes::DK->new($postcode)>
will return I<undef> if passed an illegal or invalid postcode. 

An attempt to access the methods of a non-existent postcode object will
result in a runtime error. This can be avoided by checking if the postal
code is legal, before creating the object; C<valid($postcode)>
returns true or false.

=head2 CHARACTER SET

The library was written using the ISO-8859-1 (iso-latin1) character set, and the
special danish letters '', '' and '' occur regularly in the postal places,
kommune name and fylke name. Usage of other character sets may cause havoc.
Unicode is not tested.

Note that the case insensitive search (in the 'selection' method/procedure)
doesn't recognize an '' as an '' (and so on). C<use locale> in the
application program should fix this, if the current locale supports these
characters.

=head1 SEE ALSO

The latest version of this library should always be available on CPAN, but see
also the library home page; L<http://bbop.org/perl/GeoPostcodes> for additional
information and sample usage.

=head1 AUTHOR

Arne Sommer, E<lt>perl@bbop.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Arne Sommer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
