package Bundle::Lingua::PT;

$VERSION = '0.02';

=head1 NAME

Bundle::Lingua::PT - install a set of useful modules for Natural
Language Processing of the Portuguese

=head1 SYNOPSIS

cpan Bundle::Lingua::PT

=head1 DESCRIPTION

This module includes some specific modules related to Natural Language
Processing of the Portuguese language, as well as some others we find
useful to have when doing this kind of task.

If you think some useful module is missing let us know.

=head1 CONTENTS

Text::Ngram

Text::Affixes

Lingua::Identify

Lingua::PT::Abbrev

Lingua::PT::Conjugate

Lingua::PT::Hyphenate

Lingua::PT::Inflect

Lingua::PT::Nums2Ords

Lingua::PT::Nums2Words

Lingua::PT::Ords2Nums

Lingua::PT::PLN

Lingua::PT::PLNbase

Lingua::PT::ProperNames

Lingua::PT::Words2Nums

Lingua::PT::Speaker

=head1 AUTHOR

Alberto Simes, C<< <ambs@cpan.org> >>

Jos Castro, C<< <cog@cpan.org> >>

=head1 COPYRIGHT & LICENSE

Copyright 2005 Alberto Simes and Jos Castro, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Bundle::Lingua::PT
