use Evo;
use Test::More tests => 7;
use Promises6 'deferred';
use Promises6::Util ':const';

my $p;

# ful
$p = do {
  deferred->resolve('val')->promise;
};
is $p->deferred->state, FULFILLED, 'right state';
is $p->then(sub { })->deferred->state, FULFILLED, 'right state';
$p->then(sub { is shift(), 'val', 'right value' });

# rej
$p = do {
  deferred->reject('reason')->promise;
};
is $p->deferred->state, REJECTED, 'right state';
is $p->then()->deferred->state, REJECTED, 'rejected remains';
is $p->then(undef, sub { })->deferred->state, FULFILLED,
  'changed to fulfilled';
$p->then(undef, sub { is shift(), 'reason', 'right reason' });
