package main;
use Evo::Base -strict;
use Test::More tests => 1;
use Promises6 'deferred';
use Mojo::IOLoop;

# resolve
my ($count, $d, $err, $F1, $F2);
$count = 0;
$d     = deferred;
$d->promise->then(sub { ThenableCircularA->single })
  ->then(sub {fail}, sub($r) { $err = $r });

$d->resolve(undef);

$F1->(ThenableCircularB->single);
$F2->(ThenableCircularA->single);

like $err, qr/Circular thenable.+ThenableCircularA/, 'right error';

{

  package ThenableCircularA;
  use Mojo::IOLoop;
  sub single { state $o = bless {}, shift }

  sub then {
    die "recursion" if ++$count > 1;
    $F1 = $_[1];
  }

  package ThenableCircularB;
  sub single { state $o = bless {}, shift }
  sub then { $F2 = $_[1] }
}

