package Evo::Loop::Role::Postpone;
use Evo '-Class::Role *';

requires qw(zone_cb);

has postpone_queue => default => sub { [] };

sub postpone_count($self) { $self->postpone_queue->@* }

sub postpone ($self, $fn) {
  push $self->postpone_queue->@*, $self->zone_cb($fn);
}

sub postpone_process($self) {
  my $postpone = $self->postpone_queue;
  shift(@$postpone)->() while @$postpone;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop::Role::Postpone

=head1 VERSION

version 0.0225

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
